\NeedsTeXFormat{LaTeX2e}
\ProvidesClass{briefe2}[2004/12/03 Klasse fuer Wurzel Briefe (Version 2.1 14.12.07)]
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% OPTIONEN DEKLARIEREN
\newif\ifBankverbindung
\newif\ifBankverbindungkurz
\newif\ifAdressen
\DeclareOption{bank}{\Bankverbindungtrue}
\DeclareOption{bankkurz}{\Bankverbindungkurztrue}
\DeclareOption{adr}{\Adressentrue}
\DeclareOption*{\PassOptionsToClass{\CurrentOption}{scrlttr2}}
\ProcessOptions
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% SCRLTTR2-KLASSE UND PAKETE LADEN
\LoadClass[paper=a4,DIN,DIV13]{scrlttr2}
\RequirePackage[utf8]{inputenc}
\RequirePackage[ngerman]{babel}
\RequirePackage{eurosym}
\RequirePackage{url}
\RequirePackage{wzllogo}
\RequirePackage{xml,ifthen}
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% SEITEN-LAYOUT
\KOMAoptions{parskip=half,foldmarks}
%\KOMAoptions{parskip=half,enlargefirstpage,foldmarks}
\KOMAoptions{headsepline,footsepline=false,pagenumber=botcenter}
\addtokomafont{fromname}{\small\sffamily}
\addtokomafont{fromaddress}{\sffamily}
\addtokomafont{pagehead}{\small\sffamily\upshape}
\addtokomafont{pagenumber}{\small\sffamily\upshape}
\@addtoplength{firstheadvpos}{-1mm}
\@addtoplength{firstfootvpos}{0mm}
\pagestyle{myheadings}
\markright{\centerline{\usekomavar{fromname}}}
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% KOPF- UND FUSSZEILEN
% Briefkopf
\KOMAoptions{fromalign=center,fromrule=aftername}
\KOMAoptions{fromphone,fromemail,fromurl=false,fromfax=false}
% Adressfeld
\KOMAoptions{addrfield,backaddress}
% Betreff und Datum
\KOMAoptions{subject=untitled,subject=beforeopening,numericaldate}
% Bankverbindung (nur mit Option bank)
\newcommand\Bankverbindung{%
  \newkomavar{bankseperator}
  \setkomavar{bankseperator}{:~~}
  \firstfoot{\hrule\vspace*{-1ex}\sffamily\scriptsize%
      \textbf{\usekomavar*{frombank}\usekomavar{bankseperator}}%
      \usekomavar{frombank}}}
\newcommand\Bankverbindungkurz{%
  \newkomavar{bankseperator}
  \setkomavar{bankseperator}{:~~}
  \firstfoot{\hrule\vspace*{+1ex}\sffamily\small\centerline{%
      \usekomavar*{frombank}\usekomavar{bankseperator}%
      \usekomavar{frombankkurz}}}}
\newcommand\Bankverbindungaus{\firstfoot{}}
\ifBankverbindung\Bankverbindung\fi
\ifBankverbindungkurz\Bankverbindungkurz\fi
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% ABSENDERANGABEN
\setkomavar{backaddress}{Wurzel e.\,V. (Math. Fak.), E.-Abbe-Platz 2, 07743 Jena}
\setkomavar{fromname}{WURZEL -- Verein zur Förderung der
    Mathematik an Schulen und Universitäten e.\,V.\vspace{-0.5ex}}
\setkomavar{fromaddress}{Friedrich-Schiller-Universität Jena\\
    Fakultät für Mathematik und Informatik\\
    Ernst--Abbe--Platz 2\\
    07743 Jena}
\setkomavar{fromphone}{03641/9\,46006}
\setkomavar{fromfax}{03641/9\,46032}
\setkomavar{fromemail}{\url{redaktion@wurzel.org}\vspace*{-2ex}}
\setkomavar{fromurl}{\url{www.wurzel.org}}
\setkomavar{frombank}{%
  \begin{tabular}[t]{@{}r@{~}l@{\qquad\qquad}r@{~}l@{}}
    Kontoinhaber: & Wurzel e.\,V. & \hspace*{-5em}Gläubiger-Identifikationsnummer: & DE82ZZZ00000027399 \\
    Kontonummer:  & 4130618       & IBAN:        & DE21 8302 0087 0004 1306 18 \\
    BLZ:          & 830 200 87 (HypoVereinsbank Jena) & BIC:         & HYVEDEMM463
 \end{tabular}}
\newkomavar{frombankkurz}
\setkomavar{frombankkurz}{IBAN DE21\,8302\,0087\,0004\,1306\,18, BIC HYVEDEMM463 (HypoVereinsbank Jena)}
\setkomavar{place}{Jena}
\setkomavar{signature}{Thomas Schneider\\{\small (Vorstandsvorsitzender)}}
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% BEFEHLE FUER (SERIEN)BREIFE AUS ADRESS-DATEIEN
%Hilfsbefehle
\newcommand\adrleer[3][]{\ifthenelse{\equal{#2}{}}{#3}{#1}}
\newcommand\adrnichtleer[3][]{\ifthenelse{\equal{#2}{}}{#1}{#3}}
% Adresse formatieren
\newcommand\Adressformat{\def\Adresse{\ignorespaces
  \adrnichtleer{\XML{Anrede}}{\XML{Anrede} }%
  \adrnichtleer{\XML{Vorname}}{\XML{Vorname} }%
  \XML{Name}
  \adrnichtleer{\XML{Namenszusatz1}}{\\\XML{Namenszusatz1}}
  \adrnichtleer{\XML{Namenszusatz2}}{\\\XML{Namenszusatz2}}
  \adrnichtleer[\vspace*{0.5ex}]{\XML{Strasse}}{\\\XML{Strasse}\\[0.5ex]}
  \adrnichtleer{\XML{Postleitzahl}}{\XML{Postleitzahl} }%
  \XML{Ort}
  \ifthenelse{\equal{\XML{Land}}{Deutschland}}{}{\\\XML{Land}}
}}
% Standardbestandteile der Adresse (Angaben trotzdem optional)
\newcommand\Adressfelder{
  \XMLitem{Anrede}{}
  \XMLitem{Name}{}
  \XMLitem{Vorname}{}
  \XMLitem{Strasse}{}
  \XMLitem{Namenszusatz1}{}
  \XMLitem{Namenszusatz2}{}
  \XMLitem{Postleitzahl}{}
  \XMLitem{Ort}{}
  \XMLitem{Land}{}
  \XMLitem{Telefon}{}
  \XMLitem{Email}{}
  \XMLitem{EMail}{} % wegen Wurzel-Datenbank
}
% Zusaetzliche Angaben. Veraendern mit \renewcommand\Zusatzfelder{\XML...}
\newcommand\Zusatzfelder{}
% Befehl fuer Einzelbrief aus verdefinierter Adresse
\newcommand\Brief[2]{%
  \XMLgroup{Datensatz}
    {\Adressfelder\Zusatzfelder}
    {\Adressformat{}#2}
  \XMLuse{#1}}
% Befehl fuer Serienbrief aus Adresse-Datei
\newcommand\Serie[2]{%
  \XMLinput{#1}{%
    \XMLgroup{Datensatz}
      {\Adressfelder\Zusatzfelder}
      {\Adressformat{}#2}
  }}
% Einlesen der Wurzel-Adress-Datei
\ifAdressen
  \XMLinput{adressen.xml}{}
\fi
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% PROVIDE COMMANDS FOR COMPATIBILITY
\providecommand\signature[1]{\setkomavar{signature}{#1}}
\providecommand\subject[1]{\setkomavar{subject}{#1}}
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
\endinput
