/*
 * Decompiled with CFR 0.152.
 */
package uk.me.parabola.mkgmap.osmstyle.housenumber;

import uk.me.parabola.imgfmt.app.Coord;
import uk.me.parabola.mkgmap.general.CityInfo;
import uk.me.parabola.mkgmap.general.MapRoad;
import uk.me.parabola.mkgmap.general.ZipCodeInfo;
import uk.me.parabola.mkgmap.reader.osm.Element;
import uk.me.parabola.mkgmap.reader.osm.FakeIdGenerator;
import uk.me.parabola.mkgmap.reader.osm.Node;
import uk.me.parabola.mkgmap.reader.osm.Way;
import uk.me.parabola.util.Locatable;

class HousenumberElem
implements Locatable {
    protected final Element element;
    private int housenumber;
    private String sign;
    private String place;
    private CityInfo cityInfo;
    private ZipCodeInfo zipCode;
    private String street;
    private Coord location;

    public HousenumberElem(Element el, CityInfo ci) {
        this.element = el;
        this.cityInfo = ci;
    }

    public HousenumberElem(HousenumberElem he) {
        this.element = he.element;
        this.housenumber = he.housenumber;
        this.sign = he.sign;
        this.street = he.street;
        this.place = he.place;
        this.cityInfo = he.cityInfo;
        this.zipCode = he.zipCode;
        this.location = he.location;
    }

    public Element getElement() {
        return this.element;
    }

    public int getHousenumber() {
        return this.housenumber;
    }

    public void setHousenumber(int housenumber) {
        this.housenumber = housenumber;
    }

    public String getSign() {
        return this.sign;
    }

    public void setSign(String sign) {
        this.sign = sign;
    }

    public String getPlace() {
        return this.place;
    }

    public void setPlace(String place) {
        this.place = place;
    }

    public String getStreet() {
        return this.street;
    }

    public void setStreet(String street) {
        this.street = street;
    }

    public MapRoad getRoad() {
        return null;
    }

    public CityInfo getCityInfo() {
        return this.cityInfo;
    }

    public void setZipCode(ZipCodeInfo zip) {
        this.zipCode = zip;
    }

    public ZipCodeInfo getZipCode() {
        return this.zipCode;
    }

    @Override
    public Coord getLocation() {
        if (this.location == null) {
            this.location = this.element instanceof Node ? ((Node)this.element).getLocation() : ((Way)this.element).getCofG();
        }
        return this.location;
    }

    public String toString() {
        if (this.street != null) {
            return this.street + " " + this.sign;
        }
        if (this.place != null) {
            return this.place + " " + this.sign;
        }
        return "? " + this.sign;
    }

    public String toBrowseURL() {
        if (FakeIdGenerator.isFakeId(this.element.getId())) {
            return this.getLocation().toOSMURL();
        }
        return this.element.toBrowseURL();
    }
}

