/*
 * Decompiled with CFR 0.152.
 */
package uk.me.parabola.mkgmap.osmstyle.eval;

import java.util.Set;
import uk.me.parabola.mkgmap.osmstyle.eval.BinaryOp;
import uk.me.parabola.mkgmap.osmstyle.eval.LinkedBinaryOp;
import uk.me.parabola.mkgmap.osmstyle.eval.NodeType;
import uk.me.parabola.mkgmap.osmstyle.eval.Op;
import uk.me.parabola.mkgmap.reader.osm.Element;
import uk.me.parabola.mkgmap.reader.osm.ElementSaver;

public class LinkedOp
implements Op {
    protected final Op wrapped;
    private final boolean first;
    private LinkedOp link;
    private Element current;

    protected LinkedOp(Op wrapped, boolean first) {
        this.wrapped = wrapped;
        this.first = first;
    }

    @Override
    public boolean eval(Element el) {
        if (el == this.current) {
            return false;
        }
        boolean b = this.wrapped.eval(el);
        if (this.link != null && b) {
            this.link.setMatched(el);
        }
        return b;
    }

    @Override
    public boolean eval(int cacheId, Element el) {
        if (el == this.current) {
            return false;
        }
        boolean b = this.wrapped.eval(cacheId, el);
        if (this.link != null && b) {
            this.link.setMatched(el);
        }
        return b;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (!this.first) {
            sb.append("# Part of the previous OR expression: ");
        }
        sb.append(this.wrapped);
        LinkedOp l = this.link;
        while (l != null) {
            sb.append(" | ");
            sb.append(l.wrapped);
            l = l.link;
        }
        return sb.toString();
    }

    @Override
    public int priority() {
        return this.wrapped.priority();
    }

    @Override
    public boolean hasHigherPriority(Op other) {
        return this.wrapped.hasHigherPriority(other);
    }

    @Override
    public Op getFirst() {
        return this.wrapped.getFirst();
    }

    @Override
    public <T extends Op> T setFirst(Op first) {
        return this.wrapped.setFirst(first);
    }

    @Override
    public Op getSecond() {
        return null;
    }

    @Override
    public <T extends Op> T set(Op first, Op second) {
        throw new UnsupportedOperationException();
    }

    @Override
    public NodeType getType() {
        return this.wrapped.getType();
    }

    @Override
    public String value(Element el) {
        return this.wrapped.value(el);
    }

    @Override
    public String getKeyValue() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isType(NodeType value) {
        return this.wrapped.isType(value);
    }

    private void setMatched(Element el) {
        this.current = el;
        if (this.link != null) {
            this.link.setMatched(el);
        }
    }

    public void setLink(LinkedOp link) {
        if (this.link == null) {
            this.link = link;
        } else {
            this.link.setLink(link);
        }
    }

    public static LinkedOp create(Op op, boolean first) {
        if (op instanceof BinaryOp) {
            return new LinkedBinaryOp((BinaryOp)op, first);
        }
        return new LinkedOp(op, first);
    }

    public boolean isFirstPart() {
        return this.first;
    }

    @Override
    public Set<String> getEvaluatedTagKeys() {
        return this.wrapped.getEvaluatedTagKeys();
    }

    @Override
    public void augmentWith(ElementSaver elementSaver) {
        if (this.wrapped != null) {
            this.wrapped.augmentWith(elementSaver);
        }
        if (this.link != null) {
            this.link.augmentWith(elementSaver);
        }
    }
}

