/*
 * Decompiled with CFR 0.152.
 */
package uk.me.parabola.mkgmap.main;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.StandardCharsets;
import java.nio.file.StandardOpenOption;
import uk.me.parabola.imgfmt.ExitException;
import uk.me.parabola.imgfmt.MapFailedException;
import uk.me.parabola.imgfmt.app.srt.Sort;
import uk.me.parabola.imgfmt.app.typ.TYPFile;
import uk.me.parabola.imgfmt.app.typ.TypData;
import uk.me.parabola.imgfmt.app.typ.TypLabelException;
import uk.me.parabola.imgfmt.app.typ.TypParam;
import uk.me.parabola.imgfmt.sys.FileImgChannel;
import uk.me.parabola.mkgmap.CommandArgs;
import uk.me.parabola.mkgmap.main.MapProcessor;
import uk.me.parabola.mkgmap.scan.SyntaxException;
import uk.me.parabola.mkgmap.typ.TypTextReader;

public class TypCompiler
implements MapProcessor {
    @Override
    public String makeMap(CommandArgs args, String filename) {
        int last;
        File outFile;
        String outName;
        TypData data;
        assert (filename.toLowerCase().endsWith(".txt"));
        CharsetProbe probe = new CharsetProbe();
        String readCharset = probe.probeCharset(filename);
        try {
            data = TypCompiler.compile(filename, readCharset, args.getSort());
        }
        catch (SyntaxException e) {
            throw new MapFailedException("Compiling TYP txt file: " + e.getMessage());
        }
        catch (FileNotFoundException e) {
            throw new MapFailedException("Could not open TYP file " + filename + " to read");
        }
        TypParam param = data.getParam();
        int family = args.get("family-id", -1);
        int product = args.get("product-id", -1);
        int cp = args.get("code-page", -1);
        if (family != -1) {
            param.setFamilyId(family);
        }
        if (product != -1) {
            param.setProductId(product);
        }
        if (cp != -1) {
            param.setCodePage(cp);
        }
        if ((outName = (outFile = new File(filename)).getName()).length() > 4 && (last = outName.lastIndexOf(46)) > 0) {
            outName = outName.substring(0, last);
        }
        outName = outName + ".typ";
        outFile = new File(args.getOutputDir(), outName);
        try {
            TypCompiler.writeTyp(data, outFile);
        }
        catch (TypLabelException e) {
            throw new MapFailedException("TYP file cannot be written in code page " + data.getSort().getCodepage());
        }
        catch (IOException e) {
            throw new MapFailedException("Error while writing typ file", e);
        }
        return outFile.getPath();
    }

    private static TypData compile(String filename, String charset, Sort sort) throws FileNotFoundException, SyntaxException {
        TypTextReader tr = new TypTextReader();
        TypData data = tr.getData();
        data.setSort(sort);
        try (BufferedReader r = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(filename), charset));){
            tr.read(filename, r, charset);
        }
        catch (UnsupportedEncodingException e) {
            throw new MapFailedException("Unsupported character set", e);
        }
        catch (IOException e) {
            throw new ExitException("Unable to read/close file " + filename);
        }
        return tr.getData();
    }

    private static void writeTyp(TypData data, File file) throws IOException {
        try (FileChannel channel = FileChannel.open(file.toPath(), StandardOpenOption.CREATE, StandardOpenOption.WRITE, StandardOpenOption.READ);){
            channel.truncate(0L);
            FileImgChannel w = new FileImgChannel(channel);
            try (TYPFile typ = new TYPFile(w);){
                typ.setData(data);
                typ.write();
            }
        }
    }

    public static void main(String ... args) {
        String in = "default.txt";
        if (args.length > 0) {
            in = args[0];
        }
        String out = "OUT.TYP";
        if (args.length > 1) {
            out = args[1];
        }
        new TypCompiler().standAloneRun(in, out);
    }

    private void standAloneRun(String in, String out) {
        TypData data;
        CharsetProbe probe = new CharsetProbe();
        String readCharset = probe.probeCharset(in);
        try {
            data = TypCompiler.compile(in, readCharset, null);
        }
        catch (SyntaxException e) {
            System.out.println(e.getMessage());
            return;
        }
        catch (FileNotFoundException e) {
            throw new MapFailedException("Could not open TYP file " + in + " to read");
        }
        try {
            TypCompiler.writeTyp(data, new File(out));
        }
        catch (IOException e) {
            System.out.println("Error writing file: " + e.getMessage());
        }
    }

    class CharsetProbe {
        CharsetProbe() {
        }

        private String probeCharset(String file) {
            String BOM_UTF_8 = "\u00ef\u00bb\u00bf";
            String BOM_UTF_16LE = "\u00ff\u00fe";
            String BOM_UTF_16BE = "\u00fe\u00ff";
            String BOM_UTF_32LE = "\u00ff\u00fe\u0000\u0000";
            String BOM_UTF_32BE = "\u0000\u0000\u00fe\u00ff";
            Charset byteCharNoMap = StandardCharsets.ISO_8859_1;
            CharsetDecoder utf8Decoder = StandardCharsets.UTF_8.newDecoder();
            String charset = null;
            boolean validUTF8 = true;
            try (BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), byteCharNoMap));){
                String line;
                int lineNo = 0;
                while ((line = br.readLine()) != null) {
                    ++lineNo;
                    if (line.isEmpty()) continue;
                    if (lineNo <= 2) {
                        if (line.contains("\u00ef\u00bb\u00bf")) {
                            charset = "UTF-8";
                        } else if (line.contains("\u00ff\u00fe\u0000\u0000")) {
                            charset = "UTF-32LE";
                        } else if (line.contains("\u0000\u0000\u00fe\u00ff")) {
                            charset = "UTF-32BE";
                        } else if (line.contains("\u00ff\u00fe")) {
                            charset = "UTF-16LE";
                        } else if (line.contains("\u00fe\u00ff")) {
                            charset = "UTF-16BE";
                        }
                        if (charset != null) {
                            break;
                        }
                        int strInx = line.indexOf("-*- coding:");
                        if (strInx >= 0) {
                            charset = line.substring(strInx + 11).trim();
                            if ((strInx = charset.indexOf(32)) >= 0) {
                                charset = charset.substring(0, strInx);
                            }
                            break;
                        }
                    }
                    if (line.startsWith("CodePage=")) {
                        charset = line.substring(9).trim();
                        try {
                            int codePage = Integer.decode(charset);
                            if (codePage == 65001) {
                                charset = "UTF-8";
                                break;
                            }
                            charset = "cp" + codePage;
                        }
                        catch (NumberFormatException codePage) {}
                        break;
                    }
                    if (!validUTF8) continue;
                    ByteBuffer asBytes = byteCharNoMap.encode(line);
                    try {
                        utf8Decoder.decode(asBytes);
                    }
                    catch (CharacterCodingException e) {
                        validUTF8 = false;
                    }
                }
            }
            catch (FileNotFoundException e) {
                throw new ExitException("File not found " + file);
            }
            catch (IOException e) {
                throw new ExitException("Unable to read file " + file);
            }
            return charset != null ? charset : (validUTF8 ? "UTF-8" : "cp1252");
        }
    }
}

