/*
 * Decompiled with CFR 0.152.
 */
package uk.me.parabola.imgfmt.app.typ;

import uk.me.parabola.imgfmt.app.BitWriter;
import uk.me.parabola.imgfmt.app.ImgFileWriter;
import uk.me.parabola.imgfmt.app.typ.ColourInfo;
import uk.me.parabola.imgfmt.app.typ.Image;

public class TrueImage
implements Image {
    private final ColourInfo colourInfo;
    private final int[] image;
    private int transparentPixel;

    public TrueImage(ColourInfo colourInfo, int[] image) {
        this.analyzeColours(image, colourInfo);
        this.colourInfo = colourInfo;
        this.image = image;
    }

    @Override
    public void write(ImgFileWriter writer) {
        int width = this.colourInfo.getWidth();
        int height = this.colourInfo.getHeight();
        int mode = this.colourInfo.getColourMode();
        if (mode == 16) {
            writer.put1u(this.transparentPixel >> 8);
            writer.put1u(this.transparentPixel >> 16);
            writer.put1u(this.transparentPixel >> 24);
        }
        boolean hasAlpha = mode == 32;
        BitWriter bitWriter = new BitWriter();
        for (int h = 0; h < height; ++h) {
            for (int w = 0; w < width; ++w) {
                int col = this.image[h * width + w];
                bitWriter.putn(col >> 8 & 0xFF, 8);
                bitWriter.putn(col >> 16 & 0xFF, 8);
                bitWriter.putn(col >> 24 & 0xFF, 8);
                if (!hasAlpha) continue;
                int alpha = 255 - (col & 0xFF);
                alpha = ColourInfo.alphaRound4(alpha);
                bitWriter.putn(alpha, 4);
            }
        }
        writer.put(bitWriter.getBytes(), 0, bitWriter.getLength());
    }

    private void analyzeColours(int[] image, ColourInfo colourInfo) {
        boolean hasTransparent = false;
        boolean hasAlpha = false;
        int nPixels = colourInfo.getWidth() * colourInfo.getHeight();
        for (int i = 0; i < nPixels; ++i) {
            int col = image[i];
            int a = col & 0xFF;
            if (a == 0) {
                if (hasTransparent) {
                    image[i] = this.transparentPixel;
                } else {
                    this.transparentPixel = image[i];
                }
                hasTransparent = true;
                continue;
            }
            if (a >= 255) continue;
            hasAlpha = true;
        }
        if (hasAlpha) {
            colourInfo.setColourMode(32);
        } else if (hasTransparent) {
            colourInfo.setColourMode(16);
        }
    }
}

