/*
 * Decompiled with CFR 0.152.
 */
package uk.me.parabola.imgfmt.app.labelenc;

import uk.me.parabola.imgfmt.ExitException;
import uk.me.parabola.imgfmt.app.labelenc.AnyCharsetDecoder;
import uk.me.parabola.imgfmt.app.labelenc.AnyCharsetEncoder;
import uk.me.parabola.imgfmt.app.labelenc.CharacterDecoder;
import uk.me.parabola.imgfmt.app.labelenc.CharacterEncoder;
import uk.me.parabola.imgfmt.app.labelenc.Format6Decoder;
import uk.me.parabola.imgfmt.app.labelenc.Format6Encoder;
import uk.me.parabola.imgfmt.app.labelenc.SparseTransliterator;
import uk.me.parabola.imgfmt.app.labelenc.TableTransliterator;
import uk.me.parabola.imgfmt.app.labelenc.Utf8Decoder;
import uk.me.parabola.imgfmt.app.labelenc.Utf8Encoder;

public class CodeFunctions {
    public static final int ENCODING_FORMAT6 = 6;
    private static final int ENCODING_FORMAT9 = 9;
    private static final int ENCODING_FORMAT10 = 10;
    private int codepage;
    private int encodingType;
    private CharacterEncoder encoder;
    private CharacterDecoder decoder;

    protected void setEncoder(CharacterEncoder encoder) {
        this.encoder = encoder;
    }

    public CharacterEncoder getEncoder() {
        return this.encoder;
    }

    private void setDecoder(CharacterDecoder decoder) {
        this.decoder = decoder;
    }

    public CharacterDecoder getDecoder() {
        return this.decoder;
    }

    public int getEncodingType() {
        return this.encodingType;
    }

    private void setEncodingType(int encodingType) {
        this.encodingType = encodingType;
    }

    public int getCodepage() {
        return this.codepage;
    }

    protected void setCodepage(int codepage) {
        this.codepage = codepage;
    }

    public static CodeFunctions createEncoderForLBL(String charset) {
        CodeFunctions funcs = new CodeFunctions();
        switch (charset) {
            case "ascii": {
                funcs.setEncodingType(6);
                funcs.setEncoder(new Format6Encoder());
                funcs.setDecoder(new Format6Decoder());
                break;
            }
            case "cp0": {
                funcs.setEncodingType(9);
                funcs.setEncoder(new AnyCharsetEncoder("ascii", new TableTransliterator("ascii")));
                funcs.setDecoder(new AnyCharsetDecoder("ascii"));
                funcs.setCodepage(0);
                break;
            }
            case "cp1252": 
            case "latin1": {
                funcs.setEncodingType(9);
                funcs.setEncoder(new AnyCharsetEncoder("cp1252", new TableTransliterator("latin1")));
                funcs.setDecoder(new AnyCharsetDecoder("cp1252"));
                funcs.setCodepage(1252);
                break;
            }
            case "cp65001": 
            case "unicode": {
                funcs.setEncodingType(10);
                funcs.setEncoder(new Utf8Encoder());
                funcs.setDecoder(new Utf8Decoder());
                funcs.setCodepage(65001);
                break;
            }
            case "cp932": 
            case "ms932": {
                funcs.setEncodingType(10);
                funcs.setEncoder(new AnyCharsetEncoder("ms932", new SparseTransliterator("nomacron")));
                funcs.setDecoder(new AnyCharsetDecoder("ms932"));
                funcs.setCodepage(932);
                break;
            }
            default: {
                funcs.setEncodingType(9);
                funcs.setDecoder(new AnyCharsetDecoder(charset));
                funcs.setEncoder(new AnyCharsetEncoder(charset, new TableTransliterator("ascii")));
                funcs.setCodepage(CodeFunctions.guessCodepage(charset));
            }
        }
        return funcs;
    }

    public static CodeFunctions createEncoderForLBL(int format, int codePage) {
        CodeFunctions funcs = format == 6 ? CodeFunctions.createEncoderForLBL("ascii") : CodeFunctions.createEncoderForLBL("cp" + codePage);
        return funcs;
    }

    private static int guessCodepage(String charset) {
        String cs = charset.toLowerCase();
        if (cs.startsWith("cp")) {
            try {
                return Integer.parseInt(charset.substring(2));
            }
            catch (NumberFormatException e) {
                throw new ExitException("Invalid character set: " + cs);
            }
        }
        if (cs.startsWith("windows-")) {
            try {
                return Integer.parseInt(charset.substring(8));
            }
            catch (NumberFormatException e) {
                throw new ExitException("Invalid character set: " + cs);
            }
        }
        if ("latin1".equals(cs)) {
            return 1252;
        }
        return 0;
    }

    public static CharacterEncoder getDefaultEncoder() {
        return new Format6Encoder();
    }

    public static CharacterDecoder getDefaultDecoder() {
        return new Format6Decoder();
    }
}

