"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getTempFilePath = exports.getTempPath = void 0;
const fs = require("fs-extra");
const path = require("path");
const getTempPath = () => {
    return process.env.TEMP || process.env.TMPDIR || "/tmp";
};
exports.getTempPath = getTempPath;
const getTempFilePath = (fileName, extension) => {
    const tempFolderPath = path.join(fs.mkdtempSync(path.join((0, exports.getTempPath)(), fileName)));
    const tempFilePath = path.join(tempFolderPath, `${fileName}.${extension}`);
    return { tempFolderPath, tempFilePath };
};
exports.getTempFilePath = getTempFilePath;
//# sourceMappingURL=fs-helper.js.map