"use strict";

var _electron = require("electron");
/*
 * Copyright 2025 The Kubernetes Authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

// Expose protected methods that allow the renderer process to use
// the ipcRenderer without exposing the entire object
_electron.contextBridge.exposeInMainWorld('desktopApi', {
  send: (channel, data) => {
    // allowed channels
    const validChannels = ['setMenu', 'locale', 'appConfig', 'pluginsLoaded', 'run-command', 'plugin-manager', 'request-backend-token', 'request-plugin-permission-secrets', 'open-plugin-folder', 'request-backend-port'];
    if (validChannels.includes(channel)) {
      _electron.ipcRenderer.send(channel, data);
    }
  },
  receive: (channel, func) => {
    const validChannels = ['currentMenu', 'setMenu', 'locale', 'appConfig', 'command-stdout', 'command-stderr', 'command-exit', 'plugin-manager', 'backend-token', 'plugin-permission-secrets', 'open-about-dialog', 'backend-port'];
    if (validChannels.includes(channel)) {
      // Deliberately strip event as it includes `sender`
      _electron.ipcRenderer.on(channel, (event, ...args) => func(...args));
    }
  },
  removeListener: (channel, func) => {
    _electron.ipcRenderer.removeListener(channel, func);
  }
});