/*!-----------------------------------------------------------------------------
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Version: 0.52.0(f6dc0eb8fce67e57f6036f4769d92c1666cdf546)
 * Released under the MIT license
 * https://github.com/microsoft/monaco-editor/blob/main/LICENSE.txt
 *-----------------------------------------------------------------------------*/
define("vs/language/css/cssWorker", ["require","require"],(require)=>{
"use strict";var moduleExports=(()=>{var Er=Object.defineProperty;var Fo=Object.getOwnPropertyDescriptor;var Eo=Object.getOwnPropertyNames;var _o=Object.prototype.hasOwnProperty;var Io=(n,e)=>{for(var t in e)Er(n,t,{get:e[t],enumerable:!0})},Do=(n,e,t,r)=>{if(e&&typeof e=="object"||typeof e=="function")for(let i of Eo(e))!_o.call(n,i)&&i!==t&&Er(n,i,{get:()=>e[i],enumerable:!(r=Fo(e,i))||r.enumerable});return n};var Ro=n=>Do(Er({},"__esModule",{value:!0}),n);var nl={};Io(nl,{CSSWorker:()=>Fr,create:()=>tl});var c;(function(n){n[n.Ident=0]="Ident",n[n.AtKeyword=1]="AtKeyword",n[n.String=2]="String",n[n.BadString=3]="BadString",n[n.UnquotedString=4]="UnquotedString",n[n.Hash=5]="Hash",n[n.Num=6]="Num",n[n.Percentage=7]="Percentage",n[n.Dimension=8]="Dimension",n[n.UnicodeRange=9]="UnicodeRange",n[n.CDO=10]="CDO",n[n.CDC=11]="CDC",n[n.Colon=12]="Colon",n[n.SemiColon=13]="SemiColon",n[n.CurlyL=14]="CurlyL",n[n.CurlyR=15]="CurlyR",n[n.ParenthesisL=16]="ParenthesisL",n[n.ParenthesisR=17]="ParenthesisR",n[n.BracketL=18]="BracketL",n[n.BracketR=19]="BracketR",n[n.Whitespace=20]="Whitespace",n[n.Includes=21]="Includes",n[n.Dashmatch=22]="Dashmatch",n[n.SubstringOperator=23]="SubstringOperator",n[n.PrefixOperator=24]="PrefixOperator",n[n.SuffixOperator=25]="SuffixOperator",n[n.Delim=26]="Delim",n[n.EMS=27]="EMS",n[n.EXS=28]="EXS",n[n.Length=29]="Length",n[n.Angle=30]="Angle",n[n.Time=31]="Time",n[n.Freq=32]="Freq",n[n.Exclamation=33]="Exclamation",n[n.Resolution=34]="Resolution",n[n.Comma=35]="Comma",n[n.Charset=36]="Charset",n[n.EscapedJavaScript=37]="EscapedJavaScript",n[n.BadEscapedJavaScript=38]="BadEscapedJavaScript",n[n.Comment=39]="Comment",n[n.SingleLineComment=40]="SingleLineComment",n[n.EOF=41]="EOF",n[n.ContainerQueryLength=42]="ContainerQueryLength",n[n.CustomToken=43]="CustomToken"})(c||(c={}));var un=class{constructor(e){this.source=e,this.len=e.length,this.position=0}substring(e,t=this.position){return this.source.substring(e,t)}eos(){return this.len<=this.position}pos(){return this.position}goBackTo(e){this.position=e}goBack(e){this.position-=e}advance(e){this.position+=e}nextChar(){return this.source.charCodeAt(this.position++)||0}peekChar(e=0){return this.source.charCodeAt(this.position+e)||0}lookbackChar(e=0){return this.source.charCodeAt(this.position-e)||0}advanceIfChar(e){return e===this.source.charCodeAt(this.position)?(this.position++,!0):!1}advanceIfChars(e){if(this.position+e.length>this.source.length)return!1;let t=0;for(;t<e.length;t++)if(this.source.charCodeAt(this.position+t)!==e[t])return!1;return this.advance(t),!0}advanceWhileChar(e){let t=this.position;for(;this.position<this.len&&e(this.source.charCodeAt(this.position));)this.position++;return this.position-t}},pn=97,Pi=102,Ai=122;var mn=65,Wi=70,Li=90,At=48,Wt=57,zo=126,Mo=94,Lt=61,To=124,Qe=45,$i=95,No=37,_r=42,Ki=40,Gi=41,Oo=60,Po=62,Ao=64,Wo=35,Lo=36,Ir=92,Ui=47,ct=10,dt=13,$t=12,Vi=34,ji=39,Dr=32,Rr=9,$o=59,Uo=58,Vo=123,jo=125,Bo=91,qo=93,Ko=44,Bi=46,qi=33,Go=63,Ho=43,ve={};ve[$o]=c.SemiColon;ve[Uo]=c.Colon;ve[Vo]=c.CurlyL;ve[jo]=c.CurlyR;ve[qo]=c.BracketR;ve[Bo]=c.BracketL;ve[Ki]=c.ParenthesisL;ve[Gi]=c.ParenthesisR;ve[Ko]=c.Comma;var U={};U.em=c.EMS;U.ex=c.EXS;U.px=c.Length;U.cm=c.Length;U.mm=c.Length;U.in=c.Length;U.pt=c.Length;U.pc=c.Length;U.deg=c.Angle;U.rad=c.Angle;U.grad=c.Angle;U.ms=c.Time;U.s=c.Time;U.hz=c.Freq;U.khz=c.Freq;U["%"]=c.Percentage;U.fr=c.Percentage;U.dpi=c.Resolution;U.dpcm=c.Resolution;U.cqw=c.ContainerQueryLength;U.cqh=c.ContainerQueryLength;U.cqi=c.ContainerQueryLength;U.cqb=c.ContainerQueryLength;U.cqmin=c.ContainerQueryLength;U.cqmax=c.ContainerQueryLength;var ce=class{constructor(){this.stream=new un(""),this.ignoreComment=!0,this.ignoreWhitespace=!0,this.inURL=!1}setSource(e){this.stream=new un(e)}finishToken(e,t,r){return{offset:e,len:this.stream.pos()-e,type:t,text:r||this.stream.substring(e)}}substring(e,t){return this.stream.substring(e,e+t)}pos(){return this.stream.pos()}goBackTo(e){this.stream.goBackTo(e)}scanUnquotedString(){let e=this.stream.pos(),t=[];return this._unquotedString(t)?this.finishToken(e,c.UnquotedString,t.join("")):null}scan(){let e=this.trivia();if(e!==null)return e;let t=this.stream.pos();return this.stream.eos()?this.finishToken(t,c.EOF):this.scanNext(t)}tryScanUnicode(){let e=this.stream.pos();if(!this.stream.eos()&&this._unicodeRange())return this.finishToken(e,c.UnicodeRange);this.stream.goBackTo(e)}scanNext(e){if(this.stream.advanceIfChars([Oo,qi,Qe,Qe]))return this.finishToken(e,c.CDO);if(this.stream.advanceIfChars([Qe,Qe,Po]))return this.finishToken(e,c.CDC);let t=[];if(this.ident(t))return this.finishToken(e,c.Ident,t.join(""));if(this.stream.advanceIfChar(Ao))if(t=["@"],this._name(t)){let i=t.join("");return i==="@charset"?this.finishToken(e,c.Charset,i):this.finishToken(e,c.AtKeyword,i)}else return this.finishToken(e,c.Delim);if(this.stream.advanceIfChar(Wo))return t=["#"],this._name(t)?this.finishToken(e,c.Hash,t.join("")):this.finishToken(e,c.Delim);if(this.stream.advanceIfChar(qi))return this.finishToken(e,c.Exclamation);if(this._number()){let i=this.stream.pos();if(t=[this.stream.substring(e,i)],this.stream.advanceIfChar(No))return this.finishToken(e,c.Percentage);if(this.ident(t)){let s=this.stream.substring(i).toLowerCase(),a=U[s];return typeof a<"u"?this.finishToken(e,a,t.join("")):this.finishToken(e,c.Dimension,t.join(""))}return this.finishToken(e,c.Num)}t=[];let r=this._string(t);return r!==null?this.finishToken(e,r,t.join("")):(r=ve[this.stream.peekChar()],typeof r<"u"?(this.stream.advance(1),this.finishToken(e,r)):this.stream.peekChar(0)===zo&&this.stream.peekChar(1)===Lt?(this.stream.advance(2),this.finishToken(e,c.Includes)):this.stream.peekChar(0)===To&&this.stream.peekChar(1)===Lt?(this.stream.advance(2),this.finishToken(e,c.Dashmatch)):this.stream.peekChar(0)===_r&&this.stream.peekChar(1)===Lt?(this.stream.advance(2),this.finishToken(e,c.SubstringOperator)):this.stream.peekChar(0)===Mo&&this.stream.peekChar(1)===Lt?(this.stream.advance(2),this.finishToken(e,c.PrefixOperator)):this.stream.peekChar(0)===Lo&&this.stream.peekChar(1)===Lt?(this.stream.advance(2),this.finishToken(e,c.SuffixOperator)):(this.stream.nextChar(),this.finishToken(e,c.Delim)))}trivia(){for(;;){let e=this.stream.pos();if(this._whitespace()){if(!this.ignoreWhitespace)return this.finishToken(e,c.Whitespace)}else if(this.comment()){if(!this.ignoreComment)return this.finishToken(e,c.Comment)}else return null}}comment(){if(this.stream.advanceIfChars([Ui,_r])){let e=!1,t=!1;return this.stream.advanceWhileChar(r=>t&&r===Ui?(e=!0,!1):(t=r===_r,!0)),e&&this.stream.advance(1),!0}return!1}_number(){let e=0,t;return this.stream.peekChar()===Bi&&(e=1),t=this.stream.peekChar(e),t>=At&&t<=Wt?(this.stream.advance(e+1),this.stream.advanceWhileChar(r=>r>=At&&r<=Wt||e===0&&r===Bi),!0):!1}_newline(e){let t=this.stream.peekChar();switch(t){case dt:case $t:case ct:return this.stream.advance(1),e.push(String.fromCharCode(t)),t===dt&&this.stream.advanceIfChar(ct)&&e.push(`
`),!0}return!1}_escape(e,t){let r=this.stream.peekChar();if(r===Ir){this.stream.advance(1),r=this.stream.peekChar();let i=0;for(;i<6&&(r>=At&&r<=Wt||r>=pn&&r<=Pi||r>=mn&&r<=Wi);)this.stream.advance(1),r=this.stream.peekChar(),i++;if(i>0){try{let s=parseInt(this.stream.substring(this.stream.pos()-i),16);s&&e.push(String.fromCharCode(s))}catch{}return r===Dr||r===Rr?this.stream.advance(1):this._newline([]),!0}if(r!==dt&&r!==$t&&r!==ct)return this.stream.advance(1),e.push(String.fromCharCode(r)),!0;if(t)return this._newline(e)}return!1}_stringChar(e,t){let r=this.stream.peekChar();return r!==0&&r!==e&&r!==Ir&&r!==dt&&r!==$t&&r!==ct?(this.stream.advance(1),t.push(String.fromCharCode(r)),!0):!1}_string(e){if(this.stream.peekChar()===ji||this.stream.peekChar()===Vi){let t=this.stream.nextChar();for(e.push(String.fromCharCode(t));this._stringChar(t,e)||this._escape(e,!0););return this.stream.peekChar()===t?(this.stream.nextChar(),e.push(String.fromCharCode(t)),c.String):c.BadString}return null}_unquotedChar(e){let t=this.stream.peekChar();return t!==0&&t!==Ir&&t!==ji&&t!==Vi&&t!==Ki&&t!==Gi&&t!==Dr&&t!==Rr&&t!==ct&&t!==$t&&t!==dt?(this.stream.advance(1),e.push(String.fromCharCode(t)),!0):!1}_unquotedString(e){let t=!1;for(;this._unquotedChar(e)||this._escape(e);)t=!0;return t}_whitespace(){return this.stream.advanceWhileChar(t=>t===Dr||t===Rr||t===ct||t===$t||t===dt)>0}_name(e){let t=!1;for(;this._identChar(e)||this._escape(e);)t=!0;return t}ident(e){let t=this.stream.pos();if(this._minus(e)){if(this._minus(e)||this._identFirstChar(e)||this._escape(e)){for(;this._identChar(e)||this._escape(e););return!0}}else if(this._identFirstChar(e)||this._escape(e)){for(;this._identChar(e)||this._escape(e););return!0}return this.stream.goBackTo(t),!1}_identFirstChar(e){let t=this.stream.peekChar();return t===$i||t>=pn&&t<=Ai||t>=mn&&t<=Li||t>=128&&t<=65535?(this.stream.advance(1),e.push(String.fromCharCode(t)),!0):!1}_minus(e){let t=this.stream.peekChar();return t===Qe?(this.stream.advance(1),e.push(String.fromCharCode(t)),!0):!1}_identChar(e){let t=this.stream.peekChar();return t===$i||t===Qe||t>=pn&&t<=Ai||t>=mn&&t<=Li||t>=At&&t<=Wt||t>=128&&t<=65535?(this.stream.advance(1),e.push(String.fromCharCode(t)),!0):!1}_unicodeRange(){if(this.stream.advanceIfChar(Ho)){let e=r=>r>=At&&r<=Wt||r>=pn&&r<=Pi||r>=mn&&r<=Wi,t=this.stream.advanceWhileChar(e)+this.stream.advanceWhileChar(r=>r===Go);if(t>=1&&t<=6)if(this.stream.advanceIfChar(Qe)){let r=this.stream.advanceWhileChar(e);if(r>=1&&r<=6)return!0}else return!0}return!1}};function V(n,e){if(n.length<e.length)return!1;for(let t=0;t<e.length;t++)if(n[t]!==e[t])return!1;return!0}function fn(n,e){let t=n.length-e.length;return t>0?n.lastIndexOf(e)===t:t===0?n===e:!1}function Hi(n,e,t=4){let r=Math.abs(n.length-e.length);if(r>t)return 0;let i=[],s=[],a,l;for(a=0;a<e.length+1;++a)s.push(0);for(a=0;a<n.length+1;++a)i.push(s);for(a=1;a<n.length+1;++a)for(l=1;l<e.length+1;++l)n[a-1]===e[l-1]?i[a][l]=i[a-1][l-1]+1:i[a][l]=Math.max(i[a-1][l],i[a][l-1]);return i[n.length][e.length]-Math.sqrt(r)}function zr(n,e=!0){return n?n.length<140?n:n.slice(0,140)+(e?"\u2026":""):""}function Ji(n,e){let t=e.exec(n);return t&&t[0].length?n.substr(0,n.length-t[0].length):n}function Mr(n,e){let t="";for(;e>0;)(e&1)===1&&(t+=n),n+=n,e=e>>>1;return t}var m;(function(n){n[n.Undefined=0]="Undefined",n[n.Identifier=1]="Identifier",n[n.Stylesheet=2]="Stylesheet",n[n.Ruleset=3]="Ruleset",n[n.Selector=4]="Selector",n[n.SimpleSelector=5]="SimpleSelector",n[n.SelectorInterpolation=6]="SelectorInterpolation",n[n.SelectorCombinator=7]="SelectorCombinator",n[n.SelectorCombinatorParent=8]="SelectorCombinatorParent",n[n.SelectorCombinatorSibling=9]="SelectorCombinatorSibling",n[n.SelectorCombinatorAllSiblings=10]="SelectorCombinatorAllSiblings",n[n.SelectorCombinatorShadowPiercingDescendant=11]="SelectorCombinatorShadowPiercingDescendant",n[n.Page=12]="Page",n[n.PageBoxMarginBox=13]="PageBoxMarginBox",n[n.ClassSelector=14]="ClassSelector",n[n.IdentifierSelector=15]="IdentifierSelector",n[n.ElementNameSelector=16]="ElementNameSelector",n[n.PseudoSelector=17]="PseudoSelector",n[n.AttributeSelector=18]="AttributeSelector",n[n.Declaration=19]="Declaration",n[n.Declarations=20]="Declarations",n[n.Property=21]="Property",n[n.Expression=22]="Expression",n[n.BinaryExpression=23]="BinaryExpression",n[n.Term=24]="Term",n[n.Operator=25]="Operator",n[n.Value=26]="Value",n[n.StringLiteral=27]="StringLiteral",n[n.URILiteral=28]="URILiteral",n[n.EscapedValue=29]="EscapedValue",n[n.Function=30]="Function",n[n.NumericValue=31]="NumericValue",n[n.HexColorValue=32]="HexColorValue",n[n.RatioValue=33]="RatioValue",n[n.MixinDeclaration=34]="MixinDeclaration",n[n.MixinReference=35]="MixinReference",n[n.VariableName=36]="VariableName",n[n.VariableDeclaration=37]="VariableDeclaration",n[n.Prio=38]="Prio",n[n.Interpolation=39]="Interpolation",n[n.NestedProperties=40]="NestedProperties",n[n.ExtendsReference=41]="ExtendsReference",n[n.SelectorPlaceholder=42]="SelectorPlaceholder",n[n.Debug=43]="Debug",n[n.If=44]="If",n[n.Else=45]="Else",n[n.For=46]="For",n[n.Each=47]="Each",n[n.While=48]="While",n[n.MixinContentReference=49]="MixinContentReference",n[n.MixinContentDeclaration=50]="MixinContentDeclaration",n[n.Media=51]="Media",n[n.Keyframe=52]="Keyframe",n[n.FontFace=53]="FontFace",n[n.Import=54]="Import",n[n.Namespace=55]="Namespace",n[n.Invocation=56]="Invocation",n[n.FunctionDeclaration=57]="FunctionDeclaration",n[n.ReturnStatement=58]="ReturnStatement",n[n.MediaQuery=59]="MediaQuery",n[n.MediaCondition=60]="MediaCondition",n[n.MediaFeature=61]="MediaFeature",n[n.FunctionParameter=62]="FunctionParameter",n[n.FunctionArgument=63]="FunctionArgument",n[n.KeyframeSelector=64]="KeyframeSelector",n[n.ViewPort=65]="ViewPort",n[n.Document=66]="Document",n[n.AtApplyRule=67]="AtApplyRule",n[n.CustomPropertyDeclaration=68]="CustomPropertyDeclaration",n[n.CustomPropertySet=69]="CustomPropertySet",n[n.ListEntry=70]="ListEntry",n[n.Supports=71]="Supports",n[n.SupportsCondition=72]="SupportsCondition",n[n.NamespacePrefix=73]="NamespacePrefix",n[n.GridLine=74]="GridLine",n[n.Plugin=75]="Plugin",n[n.UnknownAtRule=76]="UnknownAtRule",n[n.Use=77]="Use",n[n.ModuleConfiguration=78]="ModuleConfiguration",n[n.Forward=79]="Forward",n[n.ForwardVisibility=80]="ForwardVisibility",n[n.Module=81]="Module",n[n.UnicodeRange=82]="UnicodeRange",n[n.Layer=83]="Layer",n[n.LayerNameList=84]="LayerNameList",n[n.LayerName=85]="LayerName",n[n.PropertyAtRule=86]="PropertyAtRule",n[n.Container=87]="Container"})(m||(m={}));var z;(function(n){n[n.Mixin=0]="Mixin",n[n.Rule=1]="Rule",n[n.Variable=2]="Variable",n[n.Function=3]="Function",n[n.Keyframe=4]="Keyframe",n[n.Unknown=5]="Unknown",n[n.Module=6]="Module",n[n.Forward=7]="Forward",n[n.ForwardVisibility=8]="ForwardVisibility",n[n.Property=9]="Property"})(z||(z={}));function Hn(n,e){let t=null;return!n||e<n.offset||e>n.end?null:(n.accept(r=>r.offset===-1&&r.length===-1?!0:r.offset<=e&&r.end>=e?(t?r.length<=t.length&&(t=r):t=r,!0):!1),t)}function vt(n,e){let t=Hn(n,e),r=[];for(;t;)r.unshift(t),t=t.parent;return r}function Xi(n){let e=n.findParent(m.Declaration),t=e&&e.getValue();return t&&t.encloses(n)?e:null}var x=class{get end(){return this.offset+this.length}constructor(e=-1,t=-1,r){this.parent=null,this.offset=e,this.length=t,r&&(this.nodeType=r)}set type(e){this.nodeType=e}get type(){return this.nodeType||m.Undefined}getTextProvider(){let e=this;for(;e&&!e.textProvider;)e=e.parent;return e?e.textProvider:()=>"unknown"}getText(){return this.getTextProvider()(this.offset,this.length)}matches(e){return this.length===e.length&&this.getTextProvider()(this.offset,this.length)===e}startsWith(e){return this.length>=e.length&&this.getTextProvider()(this.offset,e.length)===e}endsWith(e){return this.length>=e.length&&this.getTextProvider()(this.end-e.length,e.length)===e}accept(e){if(e(this)&&this.children)for(let t of this.children)t.accept(e)}acceptVisitor(e){this.accept(e.visitNode.bind(e))}adoptChild(e,t=-1){if(e.parent&&e.parent.children){let i=e.parent.children.indexOf(e);i>=0&&e.parent.children.splice(i,1)}e.parent=this;let r=this.children;return r||(r=this.children=[]),t!==-1?r.splice(t,0,e):r.push(e),e}attachTo(e,t=-1){return e&&e.adoptChild(this,t),this}collectIssues(e){this.issues&&e.push.apply(e,this.issues)}addIssue(e){this.issues||(this.issues=[]),this.issues.push(e)}hasIssue(e){return Array.isArray(this.issues)&&this.issues.some(t=>t.getRule()===e)}isErroneous(e=!1){return this.issues&&this.issues.length>0?!0:e&&Array.isArray(this.children)&&this.children.some(t=>t.isErroneous(!0))}setNode(e,t,r=-1){return t?(t.attachTo(this,r),this[e]=t,!0):!1}addChild(e){return e?(this.children||(this.children=[]),e.attachTo(this),this.updateOffsetAndLength(e),!0):!1}updateOffsetAndLength(e){(e.offset<this.offset||this.offset===-1)&&(this.offset=e.offset);let t=e.end;(t>this.end||this.length===-1)&&(this.length=t-this.offset)}hasChildren(){return!!this.children&&this.children.length>0}getChildren(){return this.children?this.children.slice(0):[]}getChild(e){return this.children&&e<this.children.length?this.children[e]:null}addChildren(e){for(let t of e)this.addChild(t)}findFirstChildBeforeOffset(e){if(this.children){let t=null;for(let r=this.children.length-1;r>=0;r--)if(t=this.children[r],t.offset<=e)return t}return null}findChildAtOffset(e,t){let r=this.findFirstChildBeforeOffset(e);return r&&r.end>=e?t&&r.findChildAtOffset(e,!0)||r:null}encloses(e){return this.offset<=e.offset&&this.offset+this.length>=e.offset+e.length}getParent(){let e=this.parent;for(;e instanceof J;)e=e.parent;return e}findParent(e){let t=this;for(;t&&t.type!==e;)t=t.parent;return t}findAParent(...e){let t=this;for(;t&&!e.some(r=>t.type===r);)t=t.parent;return t}setData(e,t){this.options||(this.options={}),this.options[e]=t}getData(e){return!this.options||!this.options.hasOwnProperty(e)?null:this.options[e]}},J=class extends x{constructor(e,t=-1){super(-1,-1),this.attachTo(e,t),this.offset=-1,this.length=-1}},gn=class extends x{constructor(e,t){super(e,t)}get type(){return m.UnicodeRange}setRangeStart(e){return this.setNode("rangeStart",e)}getRangeStart(){return this.rangeStart}setRangeEnd(e){return this.setNode("rangeEnd",e)}getRangeEnd(){return this.rangeEnd}},G=class extends x{constructor(e,t){super(e,t),this.isCustomProperty=!1}get type(){return m.Identifier}containsInterpolation(){return this.hasChildren()}},bn=class extends x{constructor(e,t){super(e,t)}get type(){return m.Stylesheet}},Ze=class extends x{constructor(e,t){super(e,t)}get type(){return m.Declarations}},L=class extends x{constructor(e,t){super(e,t)}getDeclarations(){return this.declarations}setDeclarations(e){return this.setNode("declarations",e)}},ae=class extends L{constructor(e,t){super(e,t)}get type(){return m.Ruleset}getSelectors(){return this.selectors||(this.selectors=new J(this)),this.selectors}isNested(){return!!this.parent&&this.parent.findParent(m.Declarations)!==null}},de=class extends x{constructor(e,t){super(e,t)}get type(){return m.Selector}},he=class extends x{constructor(e,t){super(e,t)}get type(){return m.SimpleSelector}};var ht=class extends x{constructor(e,t){super(e,t)}},wn=class extends L{constructor(e,t){super(e,t)}get type(){return m.CustomPropertySet}},Q=class n extends ht{constructor(e,t){super(e,t),this.property=null}get type(){return m.Declaration}setProperty(e){return this.setNode("property",e)}getProperty(){return this.property}getFullPropertyName(){let e=this.property?this.property.getName():"unknown";if(this.parent instanceof Ze&&this.parent.getParent()instanceof Ut){let t=this.parent.getParent().getParent();if(t instanceof n)return t.getFullPropertyName()+e}return e}getNonPrefixedPropertyName(){let e=this.getFullPropertyName();if(e&&e.charAt(0)==="-"){let t=e.indexOf("-",1);if(t!==-1)return e.substring(t+1)}return e}setValue(e){return this.setNode("value",e)}getValue(){return this.value}setNestedProperties(e){return this.setNode("nestedProperties",e)}getNestedProperties(){return this.nestedProperties}},vn=class extends Q{constructor(e,t){super(e,t)}get type(){return m.CustomPropertyDeclaration}setPropertySet(e){return this.setNode("propertySet",e)}getPropertySet(){return this.propertySet}},Ve=class extends x{constructor(e,t){super(e,t)}get type(){return m.Property}setIdentifier(e){return this.setNode("identifier",e)}getIdentifier(){return this.identifier}getName(){return Ji(this.getText(),/[_\+]+$/)}isCustomProperty(){return!!this.identifier&&this.identifier.isCustomProperty}},Tr=class extends x{constructor(e,t){super(e,t)}get type(){return m.Invocation}getArguments(){return this.arguments||(this.arguments=new J(this)),this.arguments}},me=class extends Tr{constructor(e,t){super(e,t)}get type(){return m.Function}setIdentifier(e){return this.setNode("identifier",e,0)}getIdentifier(){return this.identifier}getName(){return this.identifier?this.identifier.getText():""}},ye=class extends x{constructor(e,t){super(e,t)}get type(){return m.FunctionParameter}setIdentifier(e){return this.setNode("identifier",e,0)}getIdentifier(){return this.identifier}getName(){return this.identifier?this.identifier.getText():""}setDefaultValue(e){return this.setNode("defaultValue",e,0)}getDefaultValue(){return this.defaultValue}},le=class extends x{constructor(e,t){super(e,t)}get type(){return m.FunctionArgument}setIdentifier(e){return this.setNode("identifier",e,0)}getIdentifier(){return this.identifier}getName(){return this.identifier?this.identifier.getText():""}setValue(e){return this.setNode("value",e,0)}getValue(){return this.value}},yn=class extends L{constructor(e,t){super(e,t)}get type(){return m.If}setExpression(e){return this.setNode("expression",e,0)}setElseClause(e){return this.setNode("elseClause",e)}},xn=class extends L{constructor(e,t){super(e,t)}get type(){return m.For}setVariable(e){return this.setNode("variable",e,0)}},Sn=class extends L{constructor(e,t){super(e,t)}get type(){return m.Each}getVariables(){return this.variables||(this.variables=new J(this)),this.variables}},Cn=class extends L{constructor(e,t){super(e,t)}get type(){return m.While}},kn=class extends L{constructor(e,t){super(e,t)}get type(){return m.Else}},De=class extends L{constructor(e,t){super(e,t)}get type(){return m.FunctionDeclaration}setIdentifier(e){return this.setNode("identifier",e,0)}getIdentifier(){return this.identifier}getName(){return this.identifier?this.identifier.getText():""}getParameters(){return this.parameters||(this.parameters=new J(this)),this.parameters}},Fn=class extends L{constructor(e,t){super(e,t)}get type(){return m.ViewPort}},pt=class extends L{constructor(e,t){super(e,t)}get type(){return m.FontFace}},Ut=class extends L{constructor(e,t){super(e,t)}get type(){return m.NestedProperties}},mt=class extends L{constructor(e,t){super(e,t)}get type(){return m.Keyframe}setKeyword(e){return this.setNode("keyword",e,0)}getKeyword(){return this.keyword}setIdentifier(e){return this.setNode("identifier",e,0)}getIdentifier(){return this.identifier}getName(){return this.identifier?this.identifier.getText():""}},Vt=class extends L{constructor(e,t){super(e,t)}get type(){return m.KeyframeSelector}},je=class extends x{constructor(e,t){super(e,t)}get type(){return m.Import}setMedialist(e){return e?(e.attachTo(this),!0):!1}},En=class extends x{get type(){return m.Use}getParameters(){return this.parameters||(this.parameters=new J(this)),this.parameters}setIdentifier(e){return this.setNode("identifier",e,0)}getIdentifier(){return this.identifier}},_n=class extends x{get type(){return m.ModuleConfiguration}setIdentifier(e){return this.setNode("identifier",e,0)}getIdentifier(){return this.identifier}getName(){return this.identifier?this.identifier.getText():""}setValue(e){return this.setNode("value",e,0)}getValue(){return this.value}},In=class extends x{get type(){return m.Forward}setIdentifier(e){return this.setNode("identifier",e,0)}getIdentifier(){return this.identifier}getMembers(){return this.members||(this.members=new J(this)),this.members}getParameters(){return this.parameters||(this.parameters=new J(this)),this.parameters}},Dn=class extends x{get type(){return m.ForwardVisibility}setIdentifier(e){return this.setNode("identifier",e,0)}getIdentifier(){return this.identifier}},Rn=class extends x{constructor(e,t){super(e,t)}get type(){return m.Namespace}},Be=class extends L{constructor(e,t){super(e,t)}get type(){return m.Media}},et=class extends L{constructor(e,t){super(e,t)}get type(){return m.Supports}},zn=class extends L{constructor(e,t){super(e,t)}get type(){return m.Layer}setNames(e){return this.setNode("names",e)}getNames(){return this.names}},Mn=class extends L{constructor(e,t){super(e,t)}get type(){return m.PropertyAtRule}setName(e){return e?(e.attachTo(this),this.name=e,!0):!1}getName(){return this.name}},Tn=class extends L{constructor(e,t){super(e,t)}get type(){return m.Document}},Nn=class extends L{constructor(e,t){super(e,t)}get type(){return m.Container}},ut=class extends x{constructor(e,t){super(e,t)}},ft=class extends x{constructor(e,t){super(e,t)}get type(){return m.MediaQuery}},On=class extends x{constructor(e,t){super(e,t)}get type(){return m.MediaCondition}},Pn=class extends x{constructor(e,t){super(e,t)}get type(){return m.MediaFeature}},Re=class extends x{constructor(e,t){super(e,t)}get type(){return m.SupportsCondition}},An=class extends L{constructor(e,t){super(e,t)}get type(){return m.Page}},Wn=class extends L{constructor(e,t){super(e,t)}get type(){return m.PageBoxMarginBox}},gt=class extends x{constructor(e,t){super(e,t)}get type(){return m.Expression}},qe=class extends x{constructor(e,t){super(e,t)}get type(){return m.BinaryExpression}setLeft(e){return this.setNode("left",e)}getLeft(){return this.left}setRight(e){return this.setNode("right",e)}getRight(){return this.right}setOperator(e){return this.setNode("operator",e)}getOperator(){return this.operator}},Ln=class extends x{constructor(e,t){super(e,t)}get type(){return m.Term}setOperator(e){return this.setNode("operator",e)}getOperator(){return this.operator}setExpression(e){return this.setNode("expression",e)}getExpression(){return this.expression}},$n=class extends x{constructor(e,t){super(e,t)}get type(){return m.AttributeSelector}setNamespacePrefix(e){return this.setNode("namespacePrefix",e)}getNamespacePrefix(){return this.namespacePrefix}setIdentifier(e){return this.setNode("identifier",e)}getIdentifier(){return this.identifier}setOperator(e){return this.setNode("operator",e)}getOperator(){return this.operator}setValue(e){return this.setNode("value",e)}getValue(){return this.value}};var tt=class extends x{constructor(e,t){super(e,t)}get type(){return m.HexColorValue}},Un=class extends x{constructor(e,t){super(e,t)}get type(){return m.RatioValue}},Yo=46,Qo=48,Zo=57,nt=class extends x{constructor(e,t){super(e,t)}get type(){return m.NumericValue}getValue(){let e=this.getText(),t=0,r;for(let i=0,s=e.length;i<s&&(r=e.charCodeAt(i),Qo<=r&&r<=Zo||r===Yo);i++)t+=1;return{value:e.substring(0,t),unit:t<e.length?e.substring(t):void 0}}},xe=class extends ht{constructor(e,t){super(e,t),this.needsSemicolon=!0}get type(){return m.VariableDeclaration}setVariable(e){return e?(e.attachTo(this),this.variable=e,!0):!1}getVariable(){return this.variable}getName(){return this.variable?this.variable.getName():""}setValue(e){return e?(e.attachTo(this),this.value=e,!0):!1}getValue(){return this.value}},rt=class extends x{constructor(e,t){super(e,t)}get type(){return m.Interpolation}},Ke=class extends x{constructor(e,t){super(e,t)}get type(){return m.VariableName}getName(){return this.getText()}},Se=class extends x{constructor(e,t){super(e,t)}get type(){return m.ExtendsReference}getSelectors(){return this.selectors||(this.selectors=new J(this)),this.selectors}},Vn=class extends x{constructor(e,t){super(e,t)}get type(){return m.MixinContentReference}getArguments(){return this.arguments||(this.arguments=new J(this)),this.arguments}},jn=class extends L{constructor(e,t){super(e,t)}get type(){return m.MixinContentDeclaration}getParameters(){return this.parameters||(this.parameters=new J(this)),this.parameters}},ze=class extends x{constructor(e,t){super(e,t)}get type(){return m.MixinReference}getNamespaces(){return this.namespaces||(this.namespaces=new J(this)),this.namespaces}setIdentifier(e){return this.setNode("identifier",e,0)}getIdentifier(){return this.identifier}getName(){return this.identifier?this.identifier.getText():""}getArguments(){return this.arguments||(this.arguments=new J(this)),this.arguments}setContent(e){return this.setNode("content",e)}getContent(){return this.content}},ue=class extends L{constructor(e,t){super(e,t)}get type(){return m.MixinDeclaration}setIdentifier(e){return this.setNode("identifier",e,0)}getIdentifier(){return this.identifier}getName(){return this.identifier?this.identifier.getText():""}getParameters(){return this.parameters||(this.parameters=new J(this)),this.parameters}setGuard(e){return e&&(e.attachTo(this),this.guard=e),!1}},bt=class extends L{constructor(e,t){super(e,t)}get type(){return m.UnknownAtRule}setAtRuleName(e){this.atRuleName=e}getAtRuleName(){return this.atRuleName}},Bn=class extends x{get type(){return m.ListEntry}setKey(e){return this.setNode("key",e,0)}setValue(e){return this.setNode("value",e,1)}},qn=class extends x{getConditions(){return this.conditions||(this.conditions=new J(this)),this.conditions}},Kn=class extends x{setVariable(e){return this.setNode("variable",e)}},jt=class extends x{get type(){return m.Module}setIdentifier(e){return this.setNode("identifier",e,0)}getIdentifier(){return this.identifier}},ee;(function(n){n[n.Ignore=1]="Ignore",n[n.Warning=2]="Warning",n[n.Error=4]="Error"})(ee||(ee={}));var wt=class{constructor(e,t,r,i,s=e.offset,a=e.length){this.node=e,this.rule=t,this.level=r,this.message=i||t.message,this.offset=s,this.length=a}getRule(){return this.rule}getLevel(){return this.level}getOffset(){return this.offset}getLength(){return this.length}getNode(){return this.node}getMessage(){return this.message}},Gn=class n{static entries(e){let t=new n;return e.acceptVisitor(t),t.entries}constructor(){this.entries=[]}visitNode(e){return e.isErroneous()&&e.collectIssues(this.entries),!0}};var ea;function p(...n){let e=n[0],t,r,i;if(typeof e=="string")t=e,r=e,n.splice(0,1),i=!n||typeof n[0]!="object"?n:n[0];else if(e instanceof Array){let a=n.slice(1);if(e.length!==a.length+1)throw new Error("expected a string as the first argument to l10n.t");let l=e[0];for(let o=1;o<e.length;o++)l+=`{${o-1}}`+e[o];return p(l,...a)}else r=e.message,t=r,e.comment&&e.comment.length>0&&(t+=`/${Array.isArray(e.comment)?e.comment.join(""):e.comment}`),i=e.args??{};let s=ea?.[t];return s?typeof s=="string"?Jn(s,i):s.comment?Jn(s.message,i):Jn(r,i):Jn(r,i)}var ta=/{([^}]+)}/g;function Jn(n,e){return Object.keys(e).length===0?n:n.replace(ta,(t,r)=>e[r]??t)}var O=class{constructor(e,t){this.id=e,this.message=t}},f={NumberExpected:new O("css-numberexpected",p("number expected")),ConditionExpected:new O("css-conditionexpected",p("condition expected")),RuleOrSelectorExpected:new O("css-ruleorselectorexpected",p("at-rule or selector expected")),DotExpected:new O("css-dotexpected",p("dot expected")),ColonExpected:new O("css-colonexpected",p("colon expected")),SemiColonExpected:new O("css-semicolonexpected",p("semi-colon expected")),TermExpected:new O("css-termexpected",p("term expected")),ExpressionExpected:new O("css-expressionexpected",p("expression expected")),OperatorExpected:new O("css-operatorexpected",p("operator expected")),IdentifierExpected:new O("css-identifierexpected",p("identifier expected")),PercentageExpected:new O("css-percentageexpected",p("percentage expected")),URIOrStringExpected:new O("css-uriorstringexpected",p("uri or string expected")),URIExpected:new O("css-uriexpected",p("URI expected")),VariableNameExpected:new O("css-varnameexpected",p("variable name expected")),VariableValueExpected:new O("css-varvalueexpected",p("variable value expected")),PropertyValueExpected:new O("css-propertyvalueexpected",p("property value expected")),LeftCurlyExpected:new O("css-lcurlyexpected",p("{ expected")),RightCurlyExpected:new O("css-rcurlyexpected",p("} expected")),LeftSquareBracketExpected:new O("css-rbracketexpected",p("[ expected")),RightSquareBracketExpected:new O("css-lbracketexpected",p("] expected")),LeftParenthesisExpected:new O("css-lparentexpected",p("( expected")),RightParenthesisExpected:new O("css-rparentexpected",p(") expected")),CommaExpected:new O("css-commaexpected",p("comma expected")),PageDirectiveOrDeclarationExpected:new O("css-pagedirordeclexpected",p("page directive or declaraton expected")),UnknownAtRule:new O("css-unknownatrule",p("at-rule unknown")),UnknownKeyword:new O("css-unknownkeyword",p("unknown keyword")),SelectorExpected:new O("css-selectorexpected",p("selector expected")),StringLiteralExpected:new O("css-stringliteralexpected",p("string literal expected")),WhitespaceExpected:new O("css-whitespaceexpected",p("whitespace expected")),MediaQueryExpected:new O("css-mediaqueryexpected",p("media query expected")),IdentifierOrWildcardExpected:new O("css-idorwildcardexpected",p("identifier or wildcard expected")),WildcardExpected:new O("css-wildcardexpected",p("wildcard expected")),IdentifierOrVariableExpected:new O("css-idorvarexpected",p("identifier or variable expected"))};var Nr;(function(n){function e(t){return typeof t=="string"}n.is=e})(Nr||(Nr={}));var Or;(function(n){function e(t){return typeof t=="string"}n.is=e})(Or||(Or={}));var Yi;(function(n){n.MIN_VALUE=-2147483648,n.MAX_VALUE=2147483647;function e(t){return typeof t=="number"&&n.MIN_VALUE<=t&&t<=n.MAX_VALUE}n.is=e})(Yi||(Yi={}));var Xn;(function(n){n.MIN_VALUE=0,n.MAX_VALUE=2147483647;function e(t){return typeof t=="number"&&n.MIN_VALUE<=t&&t<=n.MAX_VALUE}n.is=e})(Xn||(Xn={}));var H;(function(n){function e(r,i){return r===Number.MAX_VALUE&&(r=Xn.MAX_VALUE),i===Number.MAX_VALUE&&(i=Xn.MAX_VALUE),{line:r,character:i}}n.create=e;function t(r){let i=r;return g.objectLiteral(i)&&g.uinteger(i.line)&&g.uinteger(i.character)}n.is=t})(H||(H={}));var R;(function(n){function e(r,i,s,a){if(g.uinteger(r)&&g.uinteger(i)&&g.uinteger(s)&&g.uinteger(a))return{start:H.create(r,i),end:H.create(s,a)};if(H.is(r)&&H.is(i))return{start:r,end:i};throw new Error(`Range#create called with invalid arguments[${r}, ${i}, ${s}, ${a}]`)}n.create=e;function t(r){let i=r;return g.objectLiteral(i)&&H.is(i.start)&&H.is(i.end)}n.is=t})(R||(R={}));var it;(function(n){function e(r,i){return{uri:r,range:i}}n.create=e;function t(r){let i=r;return g.objectLiteral(i)&&R.is(i.range)&&(g.string(i.uri)||g.undefined(i.uri))}n.is=t})(it||(it={}));var Qi;(function(n){function e(r,i,s,a){return{targetUri:r,targetRange:i,targetSelectionRange:s,originSelectionRange:a}}n.create=e;function t(r){let i=r;return g.objectLiteral(i)&&R.is(i.targetRange)&&g.string(i.targetUri)&&R.is(i.targetSelectionRange)&&(R.is(i.originSelectionRange)||g.undefined(i.originSelectionRange))}n.is=t})(Qi||(Qi={}));var Yn;(function(n){function e(r,i,s,a){return{red:r,green:i,blue:s,alpha:a}}n.create=e;function t(r){let i=r;return g.objectLiteral(i)&&g.numberRange(i.red,0,1)&&g.numberRange(i.green,0,1)&&g.numberRange(i.blue,0,1)&&g.numberRange(i.alpha,0,1)}n.is=t})(Yn||(Yn={}));var Pr;(function(n){function e(r,i){return{range:r,color:i}}n.create=e;function t(r){let i=r;return g.objectLiteral(i)&&R.is(i.range)&&Yn.is(i.color)}n.is=t})(Pr||(Pr={}));var Ar;(function(n){function e(r,i,s){return{label:r,textEdit:i,additionalTextEdits:s}}n.create=e;function t(r){let i=r;return g.objectLiteral(i)&&g.string(i.label)&&(g.undefined(i.textEdit)||_.is(i))&&(g.undefined(i.additionalTextEdits)||g.typedArray(i.additionalTextEdits,_.is))}n.is=t})(Ar||(Ar={}));var Wr;(function(n){n.Comment="comment",n.Imports="imports",n.Region="region"})(Wr||(Wr={}));var Lr;(function(n){function e(r,i,s,a,l,o){let d={startLine:r,endLine:i};return g.defined(s)&&(d.startCharacter=s),g.defined(a)&&(d.endCharacter=a),g.defined(l)&&(d.kind=l),g.defined(o)&&(d.collapsedText=o),d}n.create=e;function t(r){let i=r;return g.objectLiteral(i)&&g.uinteger(i.startLine)&&g.uinteger(i.startLine)&&(g.undefined(i.startCharacter)||g.uinteger(i.startCharacter))&&(g.undefined(i.endCharacter)||g.uinteger(i.endCharacter))&&(g.undefined(i.kind)||g.string(i.kind))}n.is=t})(Lr||(Lr={}));var $r;(function(n){function e(r,i){return{location:r,message:i}}n.create=e;function t(r){let i=r;return g.defined(i)&&it.is(i.location)&&g.string(i.message)}n.is=t})($r||($r={}));var yt;(function(n){n.Error=1,n.Warning=2,n.Information=3,n.Hint=4})(yt||(yt={}));var Zi;(function(n){n.Unnecessary=1,n.Deprecated=2})(Zi||(Zi={}));var es;(function(n){function e(t){let r=t;return g.objectLiteral(r)&&g.string(r.href)}n.is=e})(es||(es={}));var Bt;(function(n){function e(r,i,s,a,l,o){let d={range:r,message:i};return g.defined(s)&&(d.severity=s),g.defined(a)&&(d.code=a),g.defined(l)&&(d.source=l),g.defined(o)&&(d.relatedInformation=o),d}n.create=e;function t(r){var i;let s=r;return g.defined(s)&&R.is(s.range)&&g.string(s.message)&&(g.number(s.severity)||g.undefined(s.severity))&&(g.integer(s.code)||g.string(s.code)||g.undefined(s.code))&&(g.undefined(s.codeDescription)||g.string((i=s.codeDescription)===null||i===void 0?void 0:i.href))&&(g.string(s.source)||g.undefined(s.source))&&(g.undefined(s.relatedInformation)||g.typedArray(s.relatedInformation,$r.is))}n.is=t})(Bt||(Bt={}));var Me;(function(n){function e(r,i,...s){let a={title:r,command:i};return g.defined(s)&&s.length>0&&(a.arguments=s),a}n.create=e;function t(r){let i=r;return g.defined(i)&&g.string(i.title)&&g.string(i.command)}n.is=t})(Me||(Me={}));var _;(function(n){function e(s,a){return{range:s,newText:a}}n.replace=e;function t(s,a){return{range:{start:s,end:s},newText:a}}n.insert=t;function r(s){return{range:s,newText:""}}n.del=r;function i(s){let a=s;return g.objectLiteral(a)&&g.string(a.newText)&&R.is(a.range)}n.is=i})(_||(_={}));var Ur;(function(n){function e(r,i,s){let a={label:r};return i!==void 0&&(a.needsConfirmation=i),s!==void 0&&(a.description=s),a}n.create=e;function t(r){let i=r;return g.objectLiteral(i)&&g.string(i.label)&&(g.boolean(i.needsConfirmation)||i.needsConfirmation===void 0)&&(g.string(i.description)||i.description===void 0)}n.is=t})(Ur||(Ur={}));var xt;(function(n){function e(t){let r=t;return g.string(r)}n.is=e})(xt||(xt={}));var ts;(function(n){function e(s,a,l){return{range:s,newText:a,annotationId:l}}n.replace=e;function t(s,a,l){return{range:{start:s,end:s},newText:a,annotationId:l}}n.insert=t;function r(s,a){return{range:s,newText:"",annotationId:a}}n.del=r;function i(s){let a=s;return _.is(a)&&(Ur.is(a.annotationId)||xt.is(a.annotationId))}n.is=i})(ts||(ts={}));var St;(function(n){function e(r,i){return{textDocument:r,edits:i}}n.create=e;function t(r){let i=r;return g.defined(i)&&qr.is(i.textDocument)&&Array.isArray(i.edits)}n.is=t})(St||(St={}));var Vr;(function(n){function e(r,i,s){let a={kind:"create",uri:r};return i!==void 0&&(i.overwrite!==void 0||i.ignoreIfExists!==void 0)&&(a.options=i),s!==void 0&&(a.annotationId=s),a}n.create=e;function t(r){let i=r;return i&&i.kind==="create"&&g.string(i.uri)&&(i.options===void 0||(i.options.overwrite===void 0||g.boolean(i.options.overwrite))&&(i.options.ignoreIfExists===void 0||g.boolean(i.options.ignoreIfExists)))&&(i.annotationId===void 0||xt.is(i.annotationId))}n.is=t})(Vr||(Vr={}));var jr;(function(n){function e(r,i,s,a){let l={kind:"rename",oldUri:r,newUri:i};return s!==void 0&&(s.overwrite!==void 0||s.ignoreIfExists!==void 0)&&(l.options=s),a!==void 0&&(l.annotationId=a),l}n.create=e;function t(r){let i=r;return i&&i.kind==="rename"&&g.string(i.oldUri)&&g.string(i.newUri)&&(i.options===void 0||(i.options.overwrite===void 0||g.boolean(i.options.overwrite))&&(i.options.ignoreIfExists===void 0||g.boolean(i.options.ignoreIfExists)))&&(i.annotationId===void 0||xt.is(i.annotationId))}n.is=t})(jr||(jr={}));var Br;(function(n){function e(r,i,s){let a={kind:"delete",uri:r};return i!==void 0&&(i.recursive!==void 0||i.ignoreIfNotExists!==void 0)&&(a.options=i),s!==void 0&&(a.annotationId=s),a}n.create=e;function t(r){let i=r;return i&&i.kind==="delete"&&g.string(i.uri)&&(i.options===void 0||(i.options.recursive===void 0||g.boolean(i.options.recursive))&&(i.options.ignoreIfNotExists===void 0||g.boolean(i.options.ignoreIfNotExists)))&&(i.annotationId===void 0||xt.is(i.annotationId))}n.is=t})(Br||(Br={}));var Qn;(function(n){function e(t){let r=t;return r&&(r.changes!==void 0||r.documentChanges!==void 0)&&(r.documentChanges===void 0||r.documentChanges.every(i=>g.string(i.kind)?Vr.is(i)||jr.is(i)||Br.is(i):St.is(i)))}n.is=e})(Qn||(Qn={}));var ns;(function(n){function e(r){return{uri:r}}n.create=e;function t(r){let i=r;return g.defined(i)&&g.string(i.uri)}n.is=t})(ns||(ns={}));var qt;(function(n){function e(r,i){return{uri:r,version:i}}n.create=e;function t(r){let i=r;return g.defined(i)&&g.string(i.uri)&&g.integer(i.version)}n.is=t})(qt||(qt={}));var qr;(function(n){function e(r,i){return{uri:r,version:i}}n.create=e;function t(r){let i=r;return g.defined(i)&&g.string(i.uri)&&(i.version===null||g.integer(i.version))}n.is=t})(qr||(qr={}));var rs;(function(n){function e(r,i,s,a){return{uri:r,languageId:i,version:s,text:a}}n.create=e;function t(r){let i=r;return g.defined(i)&&g.string(i.uri)&&g.string(i.languageId)&&g.integer(i.version)&&g.string(i.text)}n.is=t})(rs||(rs={}));var se;(function(n){n.PlainText="plaintext",n.Markdown="markdown";function e(t){let r=t;return r===n.PlainText||r===n.Markdown}n.is=e})(se||(se={}));var Ct;(function(n){function e(t){let r=t;return g.objectLiteral(t)&&se.is(r.kind)&&g.string(r.value)}n.is=e})(Ct||(Ct={}));var k;(function(n){n.Text=1,n.Method=2,n.Function=3,n.Constructor=4,n.Field=5,n.Variable=6,n.Class=7,n.Interface=8,n.Module=9,n.Property=10,n.Unit=11,n.Value=12,n.Enum=13,n.Keyword=14,n.Snippet=15,n.Color=16,n.File=17,n.Reference=18,n.Folder=19,n.EnumMember=20,n.Constant=21,n.Struct=22,n.Event=23,n.Operator=24,n.TypeParameter=25})(k||(k={}));var te;(function(n){n.PlainText=1,n.Snippet=2})(te||(te={}));var Te;(function(n){n.Deprecated=1})(Te||(Te={}));var is;(function(n){function e(r,i,s){return{newText:r,insert:i,replace:s}}n.create=e;function t(r){let i=r;return i&&g.string(i.newText)&&R.is(i.insert)&&R.is(i.replace)}n.is=t})(is||(is={}));var ss;(function(n){n.asIs=1,n.adjustIndentation=2})(ss||(ss={}));var os;(function(n){function e(t){let r=t;return r&&(g.string(r.detail)||r.detail===void 0)&&(g.string(r.description)||r.description===void 0)}n.is=e})(os||(os={}));var Kr;(function(n){function e(t){return{label:t}}n.create=e})(Kr||(Kr={}));var Gr;(function(n){function e(t,r){return{items:t||[],isIncomplete:!!r}}n.create=e})(Gr||(Gr={}));var Kt;(function(n){function e(r){return r.replace(/[\\`*_{}[\]()#+\-.!]/g,"\\$&")}n.fromPlainText=e;function t(r){let i=r;return g.string(i)||g.objectLiteral(i)&&g.string(i.language)&&g.string(i.value)}n.is=t})(Kt||(Kt={}));var Hr;(function(n){function e(t){let r=t;return!!r&&g.objectLiteral(r)&&(Ct.is(r.contents)||Kt.is(r.contents)||g.typedArray(r.contents,Kt.is))&&(t.range===void 0||R.is(t.range))}n.is=e})(Hr||(Hr={}));var as;(function(n){function e(t,r){return r?{label:t,documentation:r}:{label:t}}n.create=e})(as||(as={}));var ls;(function(n){function e(t,r,...i){let s={label:t};return g.defined(r)&&(s.documentation=r),g.defined(i)?s.parameters=i:s.parameters=[],s}n.create=e})(ls||(ls={}));var Ge;(function(n){n.Text=1,n.Read=2,n.Write=3})(Ge||(Ge={}));var Jr;(function(n){function e(t,r){let i={range:t};return g.number(r)&&(i.kind=r),i}n.create=e})(Jr||(Jr={}));var ge;(function(n){n.File=1,n.Module=2,n.Namespace=3,n.Package=4,n.Class=5,n.Method=6,n.Property=7,n.Field=8,n.Constructor=9,n.Enum=10,n.Interface=11,n.Function=12,n.Variable=13,n.Constant=14,n.String=15,n.Number=16,n.Boolean=17,n.Array=18,n.Object=19,n.Key=20,n.Null=21,n.EnumMember=22,n.Struct=23,n.Event=24,n.Operator=25,n.TypeParameter=26})(ge||(ge={}));var cs;(function(n){n.Deprecated=1})(cs||(cs={}));var Xr;(function(n){function e(t,r,i,s,a){let l={name:t,kind:r,location:{uri:s,range:i}};return a&&(l.containerName=a),l}n.create=e})(Xr||(Xr={}));var ds;(function(n){function e(t,r,i,s){return s!==void 0?{name:t,kind:r,location:{uri:i,range:s}}:{name:t,kind:r,location:{uri:i}}}n.create=e})(ds||(ds={}));var Yr;(function(n){function e(r,i,s,a,l,o){let d={name:r,detail:i,kind:s,range:a,selectionRange:l};return o!==void 0&&(d.children=o),d}n.create=e;function t(r){let i=r;return i&&g.string(i.name)&&g.number(i.kind)&&R.is(i.range)&&R.is(i.selectionRange)&&(i.detail===void 0||g.string(i.detail))&&(i.deprecated===void 0||g.boolean(i.deprecated))&&(i.children===void 0||Array.isArray(i.children))&&(i.tags===void 0||Array.isArray(i.tags))}n.is=t})(Yr||(Yr={}));var Gt;(function(n){n.Empty="",n.QuickFix="quickfix",n.Refactor="refactor",n.RefactorExtract="refactor.extract",n.RefactorInline="refactor.inline",n.RefactorRewrite="refactor.rewrite",n.Source="source",n.SourceOrganizeImports="source.organizeImports",n.SourceFixAll="source.fixAll"})(Gt||(Gt={}));var Zn;(function(n){n.Invoked=1,n.Automatic=2})(Zn||(Zn={}));var Qr;(function(n){function e(r,i,s){let a={diagnostics:r};return i!=null&&(a.only=i),s!=null&&(a.triggerKind=s),a}n.create=e;function t(r){let i=r;return g.defined(i)&&g.typedArray(i.diagnostics,Bt.is)&&(i.only===void 0||g.typedArray(i.only,g.string))&&(i.triggerKind===void 0||i.triggerKind===Zn.Invoked||i.triggerKind===Zn.Automatic)}n.is=t})(Qr||(Qr={}));var Ht;(function(n){function e(r,i,s){let a={title:r},l=!0;return typeof i=="string"?(l=!1,a.kind=i):Me.is(i)?a.command=i:a.edit=i,l&&s!==void 0&&(a.kind=s),a}n.create=e;function t(r){let i=r;return i&&g.string(i.title)&&(i.diagnostics===void 0||g.typedArray(i.diagnostics,Bt.is))&&(i.kind===void 0||g.string(i.kind))&&(i.edit!==void 0||i.command!==void 0)&&(i.command===void 0||Me.is(i.command))&&(i.isPreferred===void 0||g.boolean(i.isPreferred))&&(i.edit===void 0||Qn.is(i.edit))}n.is=t})(Ht||(Ht={}));var hs;(function(n){function e(r,i){let s={range:r};return g.defined(i)&&(s.data=i),s}n.create=e;function t(r){let i=r;return g.defined(i)&&R.is(i.range)&&(g.undefined(i.command)||Me.is(i.command))}n.is=t})(hs||(hs={}));var ps;(function(n){function e(r,i){return{tabSize:r,insertSpaces:i}}n.create=e;function t(r){let i=r;return g.defined(i)&&g.uinteger(i.tabSize)&&g.boolean(i.insertSpaces)}n.is=t})(ps||(ps={}));var Zr;(function(n){function e(r,i,s){return{range:r,target:i,data:s}}n.create=e;function t(r){let i=r;return g.defined(i)&&R.is(i.range)&&(g.undefined(i.target)||g.string(i.target))}n.is=t})(Zr||(Zr={}));var kt;(function(n){function e(r,i){return{range:r,parent:i}}n.create=e;function t(r){let i=r;return g.objectLiteral(i)&&R.is(i.range)&&(i.parent===void 0||n.is(i.parent))}n.is=t})(kt||(kt={}));var ms;(function(n){n.namespace="namespace",n.type="type",n.class="class",n.enum="enum",n.interface="interface",n.struct="struct",n.typeParameter="typeParameter",n.parameter="parameter",n.variable="variable",n.property="property",n.enumMember="enumMember",n.event="event",n.function="function",n.method="method",n.macro="macro",n.keyword="keyword",n.modifier="modifier",n.comment="comment",n.string="string",n.number="number",n.regexp="regexp",n.operator="operator",n.decorator="decorator"})(ms||(ms={}));var us;(function(n){n.declaration="declaration",n.definition="definition",n.readonly="readonly",n.static="static",n.deprecated="deprecated",n.abstract="abstract",n.async="async",n.modification="modification",n.documentation="documentation",n.defaultLibrary="defaultLibrary"})(us||(us={}));var fs;(function(n){function e(t){let r=t;return g.objectLiteral(r)&&(r.resultId===void 0||typeof r.resultId=="string")&&Array.isArray(r.data)&&(r.data.length===0||typeof r.data[0]=="number")}n.is=e})(fs||(fs={}));var gs;(function(n){function e(r,i){return{range:r,text:i}}n.create=e;function t(r){let i=r;return i!=null&&R.is(i.range)&&g.string(i.text)}n.is=t})(gs||(gs={}));var bs;(function(n){function e(r,i,s){return{range:r,variableName:i,caseSensitiveLookup:s}}n.create=e;function t(r){let i=r;return i!=null&&R.is(i.range)&&g.boolean(i.caseSensitiveLookup)&&(g.string(i.variableName)||i.variableName===void 0)}n.is=t})(bs||(bs={}));var ws;(function(n){function e(r,i){return{range:r,expression:i}}n.create=e;function t(r){let i=r;return i!=null&&R.is(i.range)&&(g.string(i.expression)||i.expression===void 0)}n.is=t})(ws||(ws={}));var vs;(function(n){function e(r,i){return{frameId:r,stoppedLocation:i}}n.create=e;function t(r){let i=r;return g.defined(i)&&R.is(r.stoppedLocation)}n.is=t})(vs||(vs={}));var ei;(function(n){n.Type=1,n.Parameter=2;function e(t){return t===1||t===2}n.is=e})(ei||(ei={}));var ti;(function(n){function e(r){return{value:r}}n.create=e;function t(r){let i=r;return g.objectLiteral(i)&&(i.tooltip===void 0||g.string(i.tooltip)||Ct.is(i.tooltip))&&(i.location===void 0||it.is(i.location))&&(i.command===void 0||Me.is(i.command))}n.is=t})(ti||(ti={}));var ys;(function(n){function e(r,i,s){let a={position:r,label:i};return s!==void 0&&(a.kind=s),a}n.create=e;function t(r){let i=r;return g.objectLiteral(i)&&H.is(i.position)&&(g.string(i.label)||g.typedArray(i.label,ti.is))&&(i.kind===void 0||ei.is(i.kind))&&i.textEdits===void 0||g.typedArray(i.textEdits,_.is)&&(i.tooltip===void 0||g.string(i.tooltip)||Ct.is(i.tooltip))&&(i.paddingLeft===void 0||g.boolean(i.paddingLeft))&&(i.paddingRight===void 0||g.boolean(i.paddingRight))}n.is=t})(ys||(ys={}));var xs;(function(n){function e(t){return{kind:"snippet",value:t}}n.createSnippet=e})(xs||(xs={}));var Ss;(function(n){function e(t,r,i,s){return{insertText:t,filterText:r,range:i,command:s}}n.create=e})(Ss||(Ss={}));var Cs;(function(n){function e(t){return{items:t}}n.create=e})(Cs||(Cs={}));var ks;(function(n){n.Invoked=0,n.Automatic=1})(ks||(ks={}));var Fs;(function(n){function e(t,r){return{range:t,text:r}}n.create=e})(Fs||(Fs={}));var Es;(function(n){function e(t,r){return{triggerKind:t,selectedCompletionInfo:r}}n.create=e})(Es||(Es={}));var _s;(function(n){function e(t){let r=t;return g.objectLiteral(r)&&Or.is(r.uri)&&g.string(r.name)}n.is=e})(_s||(_s={}));var Is;(function(n){function e(s,a,l,o){return new ni(s,a,l,o)}n.create=e;function t(s){let a=s;return!!(g.defined(a)&&g.string(a.uri)&&(g.undefined(a.languageId)||g.string(a.languageId))&&g.uinteger(a.lineCount)&&g.func(a.getText)&&g.func(a.positionAt)&&g.func(a.offsetAt))}n.is=t;function r(s,a){let l=s.getText(),o=i(a,(h,u)=>{let w=h.range.start.line-u.range.start.line;return w===0?h.range.start.character-u.range.start.character:w}),d=l.length;for(let h=o.length-1;h>=0;h--){let u=o[h],w=s.offsetAt(u.range.start),b=s.offsetAt(u.range.end);if(b<=d)l=l.substring(0,w)+u.newText+l.substring(b,l.length);else throw new Error("Overlapping edit");d=w}return l}n.applyEdits=r;function i(s,a){if(s.length<=1)return s;let l=s.length/2|0,o=s.slice(0,l),d=s.slice(l);i(o,a),i(d,a);let h=0,u=0,w=0;for(;h<o.length&&u<d.length;)a(o[h],d[u])<=0?s[w++]=o[h++]:s[w++]=d[u++];for(;h<o.length;)s[w++]=o[h++];for(;u<d.length;)s[w++]=d[u++];return s}})(Is||(Is={}));var ni=class{constructor(e,t,r,i){this._uri=e,this._languageId=t,this._version=r,this._content=i,this._lineOffsets=void 0}get uri(){return this._uri}get languageId(){return this._languageId}get version(){return this._version}getText(e){if(e){let t=this.offsetAt(e.start),r=this.offsetAt(e.end);return this._content.substring(t,r)}return this._content}update(e,t){this._content=e.text,this._version=t,this._lineOffsets=void 0}getLineOffsets(){if(this._lineOffsets===void 0){let e=[],t=this._content,r=!0;for(let i=0;i<t.length;i++){r&&(e.push(i),r=!1);let s=t.charAt(i);r=s==="\r"||s===`
`,s==="\r"&&i+1<t.length&&t.charAt(i+1)===`
`&&i++}r&&t.length>0&&e.push(t.length),this._lineOffsets=e}return this._lineOffsets}positionAt(e){e=Math.max(Math.min(e,this._content.length),0);let t=this.getLineOffsets(),r=0,i=t.length;if(i===0)return H.create(0,e);for(;r<i;){let a=Math.floor((r+i)/2);t[a]>e?i=a:r=a+1}let s=r-1;return H.create(s,e-t[s])}offsetAt(e){let t=this.getLineOffsets();if(e.line>=t.length)return this._content.length;if(e.line<0)return 0;let r=t[e.line],i=e.line+1<t.length?t[e.line+1]:this._content.length;return Math.max(Math.min(r+e.character,i),r)}get lineCount(){return this.getLineOffsets().length}},g;(function(n){let e=Object.prototype.toString;function t(b){return typeof b<"u"}n.defined=t;function r(b){return typeof b>"u"}n.undefined=r;function i(b){return b===!0||b===!1}n.boolean=i;function s(b){return e.call(b)==="[object String]"}n.string=s;function a(b){return e.call(b)==="[object Number]"}n.number=a;function l(b,y,E){return e.call(b)==="[object Number]"&&y<=b&&b<=E}n.numberRange=l;function o(b){return e.call(b)==="[object Number]"&&-2147483648<=b&&b<=2147483647}n.integer=o;function d(b){return e.call(b)==="[object Number]"&&0<=b&&b<=2147483647}n.uinteger=d;function h(b){return e.call(b)==="[object Function]"}n.func=h;function u(b){return b!==null&&typeof b=="object"}n.objectLiteral=u;function w(b,y){return Array.isArray(b)&&b.every(y)}n.typedArray=w})(g||(g={}));var er=class n{constructor(e,t,r,i){this._uri=e,this._languageId=t,this._version=r,this._content=i,this._lineOffsets=void 0}get uri(){return this._uri}get languageId(){return this._languageId}get version(){return this._version}getText(e){if(e){let t=this.offsetAt(e.start),r=this.offsetAt(e.end);return this._content.substring(t,r)}return this._content}update(e,t){for(let r of e)if(n.isIncremental(r)){let i=Rs(r.range),s=this.offsetAt(i.start),a=this.offsetAt(i.end);this._content=this._content.substring(0,s)+r.text+this._content.substring(a,this._content.length);let l=Math.max(i.start.line,0),o=Math.max(i.end.line,0),d=this._lineOffsets,h=Ds(r.text,!1,s);if(o-l===h.length)for(let w=0,b=h.length;w<b;w++)d[w+l+1]=h[w];else h.length<1e4?d.splice(l+1,o-l,...h):this._lineOffsets=d=d.slice(0,l+1).concat(h,d.slice(o+1));let u=r.text.length-(a-s);if(u!==0)for(let w=l+1+h.length,b=d.length;w<b;w++)d[w]=d[w]+u}else if(n.isFull(r))this._content=r.text,this._lineOffsets=void 0;else throw new Error("Unknown change event received");this._version=t}getLineOffsets(){return this._lineOffsets===void 0&&(this._lineOffsets=Ds(this._content,!0)),this._lineOffsets}positionAt(e){e=Math.max(Math.min(e,this._content.length),0);let t=this.getLineOffsets(),r=0,i=t.length;if(i===0)return{line:0,character:e};for(;r<i;){let a=Math.floor((r+i)/2);t[a]>e?i=a:r=a+1}let s=r-1;return{line:s,character:e-t[s]}}offsetAt(e){let t=this.getLineOffsets();if(e.line>=t.length)return this._content.length;if(e.line<0)return 0;let r=t[e.line],i=e.line+1<t.length?t[e.line+1]:this._content.length;return Math.max(Math.min(r+e.character,i),r)}get lineCount(){return this.getLineOffsets().length}static isIncremental(e){let t=e;return t!=null&&typeof t.text=="string"&&t.range!==void 0&&(t.rangeLength===void 0||typeof t.rangeLength=="number")}static isFull(e){let t=e;return t!=null&&typeof t.text=="string"&&t.range===void 0&&t.rangeLength===void 0}},Jt;(function(n){function e(i,s,a,l){return new er(i,s,a,l)}n.create=e;function t(i,s,a){if(i instanceof er)return i.update(s,a),i;throw new Error("TextDocument.update: document must be created by TextDocument.create")}n.update=t;function r(i,s){let a=i.getText(),l=ri(s.map(na),(h,u)=>{let w=h.range.start.line-u.range.start.line;return w===0?h.range.start.character-u.range.start.character:w}),o=0,d=[];for(let h of l){let u=i.offsetAt(h.range.start);if(u<o)throw new Error("Overlapping edit");u>o&&d.push(a.substring(o,u)),h.newText.length&&d.push(h.newText),o=i.offsetAt(h.range.end)}return d.push(a.substr(o)),d.join("")}n.applyEdits=r})(Jt||(Jt={}));function ri(n,e){if(n.length<=1)return n;let t=n.length/2|0,r=n.slice(0,t),i=n.slice(t);ri(r,e),ri(i,e);let s=0,a=0,l=0;for(;s<r.length&&a<i.length;)e(r[s],i[a])<=0?n[l++]=r[s++]:n[l++]=i[a++];for(;s<r.length;)n[l++]=r[s++];for(;a<i.length;)n[l++]=i[a++];return n}function Ds(n,e,t=0){let r=e?[t]:[];for(let i=0;i<n.length;i++){let s=n.charCodeAt(i);(s===13||s===10)&&(s===13&&i+1<n.length&&n.charCodeAt(i+1)===10&&i++,r.push(t+i+1))}return r}function Rs(n){let e=n.start,t=n.end;return e.line>t.line||e.line===t.line&&e.character>t.character?{start:t,end:e}:n}function na(n){let e=Rs(n.range);return e!==n.range?{newText:n.newText,range:e}:n}var zs;(function(n){n.LATEST={textDocument:{completion:{completionItem:{documentationFormat:[se.Markdown,se.PlainText]}},hover:{contentFormat:[se.Markdown,se.PlainText]}}}})(zs||(zs={}));var st;(function(n){n[n.Unknown=0]="Unknown",n[n.File=1]="File",n[n.Directory=2]="Directory",n[n.SymbolicLink=64]="SymbolicLink"})(st||(st={}));var Ms={E:"Edge",FF:"Firefox",S:"Safari",C:"Chrome",IE:"IE",O:"Opera"};function Ts(n){switch(n){case"experimental":return`\u26A0\uFE0F Property is experimental. Be cautious when using it.\uFE0F

`;case"nonstandard":return`\u{1F6A8}\uFE0F Property is nonstandard. Avoid using it.

`;case"obsolete":return`\u{1F6A8}\uFE0F\uFE0F\uFE0F Property is obsolete. Avoid using it.

`;default:return""}}function Ce(n,e,t){let r;if(e?r={kind:"markdown",value:ia(n,t)}:r={kind:"plaintext",value:ra(n,t)},r.value!=="")return r}function tr(n){return n=n.replace(/[\\`*_{}[\]()#+\-.!]/g,"\\$&"),n.replace(/</g,"&lt;").replace(/>/g,"&gt;")}function ra(n,e){if(!n.description||n.description==="")return"";if(typeof n.description!="string")return n.description.value;let t="";if(e?.documentation!==!1){n.status&&(t+=Ts(n.status)),t+=n.description;let r=Ns(n.browsers);r&&(t+=`
(`+r+")"),"syntax"in n&&(t+=`

Syntax: ${n.syntax}`)}return n.references&&n.references.length>0&&e?.references!==!1&&(t.length>0&&(t+=`

`),t+=n.references.map(r=>`${r.name}: ${r.url}`).join(" | ")),t}function ia(n,e){if(!n.description||n.description==="")return"";let t="";if(e?.documentation!==!1){n.status&&(t+=Ts(n.status)),typeof n.description=="string"?t+=tr(n.description):t+=n.description.kind===se.Markdown?n.description.value:tr(n.description.value);let r=Ns(n.browsers);r&&(t+=`

(`+tr(r)+")"),"syntax"in n&&n.syntax&&(t+=`

Syntax: ${tr(n.syntax)}`)}return n.references&&n.references.length>0&&e?.references!==!1&&(t.length>0&&(t+=`

`),t+=n.references.map(r=>`[${r.name}](${r.url})`).join(" | ")),t}function Ns(n=[]){return n.length===0?null:n.map(e=>{let t="",r=e.match(/([A-Z]+)(\d+)?/),i=r[1],s=r[2];return i in Ms&&(t+=Ms[i]),s&&(t+=" "+s),t}).join(", ")}var sa=/(^#([0-9A-F]{3}){1,2}$)|(^#([0-9A-F]{4}){1,2}$)/i,Ws=[{label:"rgb",func:"rgb($red, $green, $blue)",insertText:"rgb(${1:red}, ${2:green}, ${3:blue})",desc:p("Creates a Color from red, green, and blue values.")},{label:"rgba",func:"rgba($red, $green, $blue, $alpha)",insertText:"rgba(${1:red}, ${2:green}, ${3:blue}, ${4:alpha})",desc:p("Creates a Color from red, green, blue, and alpha values.")},{label:"rgb relative",func:"rgb(from $color $red $green $blue)",insertText:"rgb(from ${1:color} ${2:r} ${3:g} ${4:b})",desc:p("Creates a Color from the red, green, and blue values of another Color.")},{label:"hsl",func:"hsl($hue, $saturation, $lightness)",insertText:"hsl(${1:hue}, ${2:saturation}, ${3:lightness})",desc:p("Creates a Color from hue, saturation, and lightness values.")},{label:"hsla",func:"hsla($hue, $saturation, $lightness, $alpha)",insertText:"hsla(${1:hue}, ${2:saturation}, ${3:lightness}, ${4:alpha})",desc:p("Creates a Color from hue, saturation, lightness, and alpha values.")},{label:"hsl relative",func:"hsl(from $color $hue $saturation $lightness)",insertText:"hsl(from ${1:color} ${2:h} ${3:s} ${4:l})",desc:p("Creates a Color from the hue, saturation, and lightness values of another Color.")},{label:"hwb",func:"hwb($hue $white $black)",insertText:"hwb(${1:hue} ${2:white} ${3:black})",desc:p("Creates a Color from hue, white, and black values.")},{label:"hwb relative",func:"hwb(from $color $hue $white $black)",insertText:"hwb(from ${1:color} ${2:h} ${3:w} ${4:b})",desc:p("Creates a Color from the hue, white, and black values of another Color.")},{label:"lab",func:"lab($lightness $a $b)",insertText:"lab(${1:lightness} ${2:a} ${3:b})",desc:p("Creates a Color from lightness, a, and b values.")},{label:"lab relative",func:"lab(from $color $lightness $a $b)",insertText:"lab(from ${1:color} ${2:l} ${3:a} ${4:b})",desc:p("Creates a Color from the lightness, a, and b values of another Color.")},{label:"oklab",func:"oklab($lightness $a $b)",insertText:"oklab(${1:lightness} ${2:a} ${3:b})",desc:p("Creates a Color from lightness, a, and b values.")},{label:"oklab relative",func:"oklab(from $color $lightness $a $b)",insertText:"oklab(from ${1:color} ${2:l} ${3:a} ${4:b})",desc:p("Creates a Color from the lightness, a, and b values of another Color.")},{label:"lch",func:"lch($lightness $chroma $hue)",insertText:"lch(${1:lightness} ${2:chroma} ${3:hue})",desc:p("Creates a Color from lightness, chroma, and hue values.")},{label:"lch relative",func:"lch(from $color $lightness $chroma $hue)",insertText:"lch(from ${1:color} ${2:l} ${3:c} ${4:h})",desc:p("Creates a Color from the lightness, chroma, and hue values of another Color.")},{label:"oklch",func:"oklch($lightness $chroma $hue)",insertText:"oklch(${1:lightness} ${2:chroma} ${3:hue})",desc:p("Creates a Color from lightness, chroma, and hue values.")},{label:"oklch relative",func:"oklch(from $color $lightness $chroma $hue)",insertText:"oklch(from ${1:color} ${2:l} ${3:c} ${4:h})",desc:p("Creates a Color from the lightness, chroma, and hue values of another Color.")},{label:"color",func:"color($color-space $red $green $blue)",insertText:"color(${1|srgb,srgb-linear,display-p3,a98-rgb,prophoto-rgb,rec2020,xyx,xyz-d50,xyz-d65|} ${2:red} ${3:green} ${4:blue})",desc:p("Creates a Color in a specific color space from red, green, and blue values.")},{label:"color relative",func:"color(from $color $color-space $red $green $blue)",insertText:"color(from ${1:color} ${2|srgb,srgb-linear,display-p3,a98-rgb,prophoto-rgb,rec2020,xyx,xyz-d50,xyz-d65|} ${3:r} ${4:g} ${5:b})",desc:p("Creates a Color in a specific color space from the red, green, and blue values of another Color.")},{label:"color-mix",func:"color-mix(in $color-space, $color $percentage, $color $percentage)",insertText:"color-mix(in ${1|srgb,srgb-linear,lab,oklab,xyz,xyz-d50,xyz-d65|}, ${3:color} ${4:percentage}, ${5:color} ${6:percentage})",desc:p("Mix two colors together in a rectangular color space.")},{label:"color-mix hue",func:"color-mix(in $color-space $interpolation-method hue, $color $percentage, $color $percentage)",insertText:"color-mix(in ${1|hsl,hwb,lch,oklch|} ${2|shorter hue,longer hue,increasing hue,decreasing hue|}, ${3:color} ${4:percentage}, ${5:color} ${6:percentage})",desc:p("Mix two colors together in a polar color space.")}],oa=/^(rgb|rgba|hsl|hsla|hwb)$/i,Xt={aliceblue:"#f0f8ff",antiquewhite:"#faebd7",aqua:"#00ffff",aquamarine:"#7fffd4",azure:"#f0ffff",beige:"#f5f5dc",bisque:"#ffe4c4",black:"#000000",blanchedalmond:"#ffebcd",blue:"#0000ff",blueviolet:"#8a2be2",brown:"#a52a2a",burlywood:"#deb887",cadetblue:"#5f9ea0",chartreuse:"#7fff00",chocolate:"#d2691e",coral:"#ff7f50",cornflowerblue:"#6495ed",cornsilk:"#fff8dc",crimson:"#dc143c",cyan:"#00ffff",darkblue:"#00008b",darkcyan:"#008b8b",darkgoldenrod:"#b8860b",darkgray:"#a9a9a9",darkgrey:"#a9a9a9",darkgreen:"#006400",darkkhaki:"#bdb76b",darkmagenta:"#8b008b",darkolivegreen:"#556b2f",darkorange:"#ff8c00",darkorchid:"#9932cc",darkred:"#8b0000",darksalmon:"#e9967a",darkseagreen:"#8fbc8f",darkslateblue:"#483d8b",darkslategray:"#2f4f4f",darkslategrey:"#2f4f4f",darkturquoise:"#00ced1",darkviolet:"#9400d3",deeppink:"#ff1493",deepskyblue:"#00bfff",dimgray:"#696969",dimgrey:"#696969",dodgerblue:"#1e90ff",firebrick:"#b22222",floralwhite:"#fffaf0",forestgreen:"#228b22",fuchsia:"#ff00ff",gainsboro:"#dcdcdc",ghostwhite:"#f8f8ff",gold:"#ffd700",goldenrod:"#daa520",gray:"#808080",grey:"#808080",green:"#008000",greenyellow:"#adff2f",honeydew:"#f0fff0",hotpink:"#ff69b4",indianred:"#cd5c5c",indigo:"#4b0082",ivory:"#fffff0",khaki:"#f0e68c",lavender:"#e6e6fa",lavenderblush:"#fff0f5",lawngreen:"#7cfc00",lemonchiffon:"#fffacd",lightblue:"#add8e6",lightcoral:"#f08080",lightcyan:"#e0ffff",lightgoldenrodyellow:"#fafad2",lightgray:"#d3d3d3",lightgrey:"#d3d3d3",lightgreen:"#90ee90",lightpink:"#ffb6c1",lightsalmon:"#ffa07a",lightseagreen:"#20b2aa",lightskyblue:"#87cefa",lightslategray:"#778899",lightslategrey:"#778899",lightsteelblue:"#b0c4de",lightyellow:"#ffffe0",lime:"#00ff00",limegreen:"#32cd32",linen:"#faf0e6",magenta:"#ff00ff",maroon:"#800000",mediumaquamarine:"#66cdaa",mediumblue:"#0000cd",mediumorchid:"#ba55d3",mediumpurple:"#9370d8",mediumseagreen:"#3cb371",mediumslateblue:"#7b68ee",mediumspringgreen:"#00fa9a",mediumturquoise:"#48d1cc",mediumvioletred:"#c71585",midnightblue:"#191970",mintcream:"#f5fffa",mistyrose:"#ffe4e1",moccasin:"#ffe4b5",navajowhite:"#ffdead",navy:"#000080",oldlace:"#fdf5e6",olive:"#808000",olivedrab:"#6b8e23",orange:"#ffa500",orangered:"#ff4500",orchid:"#da70d6",palegoldenrod:"#eee8aa",palegreen:"#98fb98",paleturquoise:"#afeeee",palevioletred:"#d87093",papayawhip:"#ffefd5",peachpuff:"#ffdab9",peru:"#cd853f",pink:"#ffc0cb",plum:"#dda0dd",powderblue:"#b0e0e6",purple:"#800080",red:"#ff0000",rebeccapurple:"#663399",rosybrown:"#bc8f8f",royalblue:"#4169e1",saddlebrown:"#8b4513",salmon:"#fa8072",sandybrown:"#f4a460",seagreen:"#2e8b57",seashell:"#fff5ee",sienna:"#a0522d",silver:"#c0c0c0",skyblue:"#87ceeb",slateblue:"#6a5acd",slategray:"#708090",slategrey:"#708090",snow:"#fffafa",springgreen:"#00ff7f",steelblue:"#4682b4",tan:"#d2b48c",teal:"#008080",thistle:"#d8bfd8",tomato:"#ff6347",turquoise:"#40e0d0",violet:"#ee82ee",wheat:"#f5deb3",white:"#ffffff",whitesmoke:"#f5f5f5",yellow:"#ffff00",yellowgreen:"#9acd32"},aa=new RegExp(`^(${Object.keys(Xt).join("|")})$`,"i"),rr={currentColor:"The value of the 'color' property. The computed value of the 'currentColor' keyword is the computed value of the 'color' property. If the 'currentColor' keyword is set on the 'color' property itself, it is treated as 'color:inherit' at parse time.",transparent:"Fully transparent. This keyword can be considered a shorthand for rgba(0,0,0,0) which is its computed value."},la=new RegExp(`^(${Object.keys(rr).join("|")})$`,"i");function He(n,e){let r=n.getText().match(/^([-+]?[0-9]*\.?[0-9]+)(%?)$/);if(r){r[2]&&(e=100);let i=parseFloat(r[1])/e;if(i>=0&&i<=1)return i}throw new Error}function Os(n){let e=n.getText(),t=e.match(/^([-+]?[0-9]*\.?[0-9]+)(deg|rad|grad|turn)?$/);if(t)switch(t[2]){case"deg":return parseFloat(e)%360;case"rad":return parseFloat(e)*180/Math.PI%360;case"grad":return parseFloat(e)*.9%360;case"turn":return parseFloat(e)*360%360;default:if(typeof t[2]>"u")return parseFloat(e)%360}throw new Error}function Ls(n){let e=n.getName();return e?oa.test(e):!1}function ii(n){return sa.test(n)||aa.test(n)||la.test(n)}var Ps=48,ca=57,da=65;var nr=97,ha=102;function B(n){return n<Ps?0:n<=ca?n-Ps:(n<nr&&(n+=nr-da),n>=nr&&n<=ha?n-nr+10:0)}function As(n){if(n[0]!=="#")return null;switch(n.length){case 4:return{red:B(n.charCodeAt(1))*17/255,green:B(n.charCodeAt(2))*17/255,blue:B(n.charCodeAt(3))*17/255,alpha:1};case 5:return{red:B(n.charCodeAt(1))*17/255,green:B(n.charCodeAt(2))*17/255,blue:B(n.charCodeAt(3))*17/255,alpha:B(n.charCodeAt(4))*17/255};case 7:return{red:(B(n.charCodeAt(1))*16+B(n.charCodeAt(2)))/255,green:(B(n.charCodeAt(3))*16+B(n.charCodeAt(4)))/255,blue:(B(n.charCodeAt(5))*16+B(n.charCodeAt(6)))/255,alpha:1};case 9:return{red:(B(n.charCodeAt(1))*16+B(n.charCodeAt(2)))/255,green:(B(n.charCodeAt(3))*16+B(n.charCodeAt(4)))/255,blue:(B(n.charCodeAt(5))*16+B(n.charCodeAt(6)))/255,alpha:(B(n.charCodeAt(7))*16+B(n.charCodeAt(8)))/255}}return null}function $s(n,e,t,r=1){if(n=n/60,e===0)return{red:t,green:t,blue:t,alpha:r};{let i=(l,o,d)=>{for(;d<0;)d+=6;for(;d>=6;)d-=6;return d<1?(o-l)*d+l:d<3?o:d<4?(o-l)*(4-d)+l:l},s=t<=.5?t*(e+1):t+e-t*e,a=t*2-s;return{red:i(a,s,n+2),green:i(a,s,n),blue:i(a,s,n-2),alpha:r}}}function si(n){let e=n.red,t=n.green,r=n.blue,i=n.alpha,s=Math.max(e,t,r),a=Math.min(e,t,r),l=0,o=0,d=(a+s)/2,h=s-a;if(h>0){switch(o=Math.min(d<=.5?h/(2*d):h/(2-2*d),1),s){case e:l=(t-r)/h+(t<r?6:0);break;case t:l=(r-e)/h+2;break;case r:l=(e-t)/h+4;break}l*=60,l=Math.round(l)}return{h:l,s:o,l:d,a:i}}function pa(n,e,t,r=1){if(e+t>=1){let o=e/(e+t);return{red:o,green:o,blue:o,alpha:r}}let i=$s(n,1,.5,r),s=i.red;s*=1-e-t,s+=e;let a=i.green;a*=1-e-t,a+=e;let l=i.blue;return l*=1-e-t,l+=e,{red:s,green:a,blue:l,alpha:r}}function Us(n){let e=si(n),t=Math.min(n.red,n.green,n.blue),r=1-Math.max(n.red,n.green,n.blue);return{h:e.h,w:t,b:r,a:e.a}}function Vs(n){if(n.type===m.HexColorValue){let e=n.getText();return As(e)}else if(n.type===m.Function){let e=n,t=e.getName(),r=e.getArguments().getChildren();if(r.length===1){let i=r[0].getChildren();if(i.length===1&&i[0].type===m.Expression&&(r=i[0].getChildren(),r.length===3)){let s=r[2];if(s instanceof qe){let a=s.getLeft(),l=s.getRight(),o=s.getOperator();a&&l&&o&&o.matches("/")&&(r=[r[0],r[1],a,l])}}}if(!t||r.length<3||r.length>4)return null;try{let i=r.length===4?He(r[3],1):1;if(t==="rgb"||t==="rgba")return{red:He(r[0],255),green:He(r[1],255),blue:He(r[2],255),alpha:i};if(t==="hsl"||t==="hsla"){let s=Os(r[0]),a=He(r[1],100),l=He(r[2],100);return $s(s,a,l,i)}else if(t==="hwb"){let s=Os(r[0]),a=He(r[1],100),l=He(r[2],100);return pa(s,a,l,i)}}catch{return null}}else if(n.type===m.Identifier){if(n.parent&&n.parent.type!==m.Term)return null;let e=n.parent;if(e&&e.parent&&e.parent.type===m.BinaryExpression){let i=e.parent;if(i.parent&&i.parent.type===m.ListEntry&&i.parent.key===i)return null}let t=n.getText().toLowerCase();if(t==="none")return null;let r=Xt[t];if(r)return As(r)}return null}var oi={bottom:"Computes to \u2018100%\u2019 for the vertical position if one or two values are given, otherwise specifies the bottom edge as the origin for the next offset.",center:"Computes to \u201850%\u2019 (\u2018left 50%\u2019) for the horizontal position if the horizontal position is not otherwise specified, or \u201850%\u2019 (\u2018top 50%\u2019) for the vertical position if it is.",left:"Computes to \u20180%\u2019 for the horizontal position if one or two values are given, otherwise specifies the left edge as the origin for the next offset.",right:"Computes to \u2018100%\u2019 for the horizontal position if one or two values are given, otherwise specifies the right edge as the origin for the next offset.",top:"Computes to \u20180%\u2019 for the vertical position if one or two values are given, otherwise specifies the top edge as the origin for the next offset."},ai={"no-repeat":"Placed once and not repeated in this direction.",repeat:"Repeated in this direction as often as needed to cover the background painting area.","repeat-x":"Computes to \u2018repeat no-repeat\u2019.","repeat-y":"Computes to \u2018no-repeat repeat\u2019.",round:"Repeated as often as will fit within the background positioning area. If it doesn\u2019t fit a whole number of times, it is rescaled so that it does.",space:"Repeated as often as will fit within the background positioning area without being clipped and then the images are spaced out to fill the area."},li={dashed:"A series of square-ended dashes.",dotted:"A series of round dots.",double:"Two parallel solid lines with some space between them.",groove:"Looks as if it were carved in the canvas.",hidden:"Same as \u2018none\u2019, but has different behavior in the border conflict resolution rules for border-collapsed tables.",inset:"Looks as if the content on the inside of the border is sunken into the canvas.",none:"No border. Color and width are ignored.",outset:"Looks as if the content on the inside of the border is coming out of the canvas.",ridge:"Looks as if it were coming out of the canvas.",solid:"A single line segment."},js=["medium","thick","thin"],ci={"border-box":"The background is painted within (clipped to) the border box.","content-box":"The background is painted within (clipped to) the content box.","padding-box":"The background is painted within (clipped to) the padding box."},di={"margin-box":"Uses the margin box as reference box.","fill-box":"Uses the object bounding box as reference box.","stroke-box":"Uses the stroke bounding box as reference box.","view-box":"Uses the nearest SVG viewport as reference box."},hi={initial:"Represents the value specified as the property\u2019s initial value.",inherit:"Represents the computed value of the property on the element\u2019s parent.",unset:"Acts as either `inherit` or `initial`, depending on whether the property is inherited or not."},pi={"var()":"Evaluates the value of a custom variable.","calc()":"Evaluates an mathematical expression. The following operators can be used: + - * /."},mi={"url()":"Reference an image file by URL","image()":"Provide image fallbacks and annotations.","-webkit-image-set()":"Provide multiple resolutions. Remember to use unprefixed image-set() in addition.","image-set()":"Provide multiple resolutions of an image and const the UA decide which is most appropriate in a given situation.","-moz-element()":"Use an element in the document as an image. Remember to use unprefixed element() in addition.","element()":"Use an element in the document as an image.","cross-fade()":"Indicates the two images to be combined and how far along in the transition the combination is.","-webkit-gradient()":"Deprecated. Use modern linear-gradient() or radial-gradient() instead.","-webkit-linear-gradient()":"Linear gradient. Remember to use unprefixed version in addition.","-moz-linear-gradient()":"Linear gradient. Remember to use unprefixed version in addition.","-o-linear-gradient()":"Linear gradient. Remember to use unprefixed version in addition.","linear-gradient()":"A linear gradient is created by specifying a straight gradient line, and then several colors placed along that line.","-webkit-repeating-linear-gradient()":"Repeating Linear gradient. Remember to use unprefixed version in addition.","-moz-repeating-linear-gradient()":"Repeating Linear gradient. Remember to use unprefixed version in addition.","-o-repeating-linear-gradient()":"Repeating Linear gradient. Remember to use unprefixed version in addition.","repeating-linear-gradient()":"Same as linear-gradient, except the color-stops are repeated infinitely in both directions, with their positions shifted by multiples of the difference between the last specified color-stop\u2019s position and the first specified color-stop\u2019s position.","-webkit-radial-gradient()":"Radial gradient. Remember to use unprefixed version in addition.","-moz-radial-gradient()":"Radial gradient. Remember to use unprefixed version in addition.","radial-gradient()":"Colors emerge from a single point and smoothly spread outward in a circular or elliptical shape.","-webkit-repeating-radial-gradient()":"Repeating radial gradient. Remember to use unprefixed version in addition.","-moz-repeating-radial-gradient()":"Repeating radial gradient. Remember to use unprefixed version in addition.","repeating-radial-gradient()":"Same as radial-gradient, except the color-stops are repeated infinitely in both directions, with their positions shifted by multiples of the difference between the last specified color-stop\u2019s position and the first specified color-stop\u2019s position."},ui={ease:"Equivalent to cubic-bezier(0.25, 0.1, 0.25, 1.0).","ease-in":"Equivalent to cubic-bezier(0.42, 0, 1.0, 1.0).","ease-in-out":"Equivalent to cubic-bezier(0.42, 0, 0.58, 1.0).","ease-out":"Equivalent to cubic-bezier(0, 0, 0.58, 1.0).",linear:"Equivalent to cubic-bezier(0.0, 0.0, 1.0, 1.0).","step-end":"Equivalent to steps(1, end).","step-start":"Equivalent to steps(1, start).","steps()":"The first parameter specifies the number of intervals in the function. The second parameter, which is optional, is either the value \u201Cstart\u201D or \u201Cend\u201D.","cubic-bezier()":"Specifies a cubic-bezier curve. The four values specify points P1 and P2  of the curve as (x1, y1, x2, y2).","cubic-bezier(0.6, -0.28, 0.735, 0.045)":"Ease-in Back. Overshoots.","cubic-bezier(0.68, -0.55, 0.265, 1.55)":"Ease-in-out Back. Overshoots.","cubic-bezier(0.175, 0.885, 0.32, 1.275)":"Ease-out Back. Overshoots.","cubic-bezier(0.6, 0.04, 0.98, 0.335)":"Ease-in Circular. Based on half circle.","cubic-bezier(0.785, 0.135, 0.15, 0.86)":"Ease-in-out Circular. Based on half circle.","cubic-bezier(0.075, 0.82, 0.165, 1)":"Ease-out Circular. Based on half circle.","cubic-bezier(0.55, 0.055, 0.675, 0.19)":"Ease-in Cubic. Based on power of three.","cubic-bezier(0.645, 0.045, 0.355, 1)":"Ease-in-out Cubic. Based on power of three.","cubic-bezier(0.215, 0.610, 0.355, 1)":"Ease-out Cubic. Based on power of three.","cubic-bezier(0.95, 0.05, 0.795, 0.035)":"Ease-in Exponential. Based on two to the power ten.","cubic-bezier(1, 0, 0, 1)":"Ease-in-out Exponential. Based on two to the power ten.","cubic-bezier(0.19, 1, 0.22, 1)":"Ease-out Exponential. Based on two to the power ten.","cubic-bezier(0.47, 0, 0.745, 0.715)":"Ease-in Sine.","cubic-bezier(0.445, 0.05, 0.55, 0.95)":"Ease-in-out Sine.","cubic-bezier(0.39, 0.575, 0.565, 1)":"Ease-out Sine.","cubic-bezier(0.55, 0.085, 0.68, 0.53)":"Ease-in Quadratic. Based on power of two.","cubic-bezier(0.455, 0.03, 0.515, 0.955)":"Ease-in-out Quadratic. Based on power of two.","cubic-bezier(0.25, 0.46, 0.45, 0.94)":"Ease-out Quadratic. Based on power of two.","cubic-bezier(0.895, 0.03, 0.685, 0.22)":"Ease-in Quartic. Based on power of four.","cubic-bezier(0.77, 0, 0.175, 1)":"Ease-in-out Quartic. Based on power of four.","cubic-bezier(0.165, 0.84, 0.44, 1)":"Ease-out Quartic. Based on power of four.","cubic-bezier(0.755, 0.05, 0.855, 0.06)":"Ease-in Quintic. Based on power of five.","cubic-bezier(0.86, 0, 0.07, 1)":"Ease-in-out Quintic. Based on power of five.","cubic-bezier(0.23, 1, 0.320, 1)":"Ease-out Quintic. Based on power of five."},fi={"circle()":"Defines a circle.","ellipse()":"Defines an ellipse.","inset()":"Defines an inset rectangle.","polygon()":"Defines a polygon."},ir={length:["cap","ch","cm","cqb","cqh","cqi","cqmax","cqmin","cqw","dvb","dvh","dvi","dvw","em","ex","ic","in","lh","lvb","lvh","lvi","lvw","mm","pc","pt","px","q","rcap","rch","rem","rex","ric","rlh","svb","svh","svi","svw","vb","vh","vi","vmax","vmin","vw"],angle:["deg","rad","grad","turn"],time:["ms","s"],frequency:["Hz","kHz"],resolution:["dpi","dpcm","dppx"],percentage:["%","fr"]},Bs=["a","abbr","address","area","article","aside","audio","b","base","bdi","bdo","blockquote","body","br","button","canvas","caption","cite","code","col","colgroup","data","datalist","dd","del","details","dfn","dialog","div","dl","dt","em","embed","fieldset","figcaption","figure","footer","form","h1","h2","h3","h4","h5","h6","head","header","hgroup","hr","html","i","iframe","img","input","ins","kbd","keygen","label","legend","li","link","main","map","mark","menu","menuitem","meta","meter","nav","noscript","object","ol","optgroup","option","output","p","param","picture","pre","progress","q","rb","rp","rt","rtc","ruby","s","samp","script","section","select","small","source","span","strong","style","sub","summary","sup","table","tbody","td","template","textarea","tfoot","th","thead","time","title","tr","track","u","ul","const","video","wbr"],qs=["circle","clipPath","cursor","defs","desc","ellipse","feBlend","feColorMatrix","feComponentTransfer","feComposite","feConvolveMatrix","feDiffuseLighting","feDisplacementMap","feDistantLight","feDropShadow","feFlood","feFuncA","feFuncB","feFuncG","feFuncR","feGaussianBlur","feImage","feMerge","feMergeNode","feMorphology","feOffset","fePointLight","feSpecularLighting","feSpotLight","feTile","feTurbulence","filter","foreignObject","g","hatch","hatchpath","image","line","linearGradient","marker","mask","mesh","meshpatch","meshrow","metadata","mpath","path","pattern","polygon","polyline","radialGradient","rect","set","solidcolor","stop","svg","switch","symbol","text","textPath","tspan","use","view"],Ks=["@bottom-center","@bottom-left","@bottom-left-corner","@bottom-right","@bottom-right-corner","@left-bottom","@left-middle","@left-top","@right-bottom","@right-middle","@right-top","@top-center","@top-left","@top-left-corner","@top-right","@top-right-corner"];function Yt(n){return Object.keys(n).map(e=>n[e])}function ie(n){return typeof n<"u"}var ke=class{constructor(e=new ce){this.keyframeRegex=/^@(\-(webkit|ms|moz|o)\-)?keyframes$/i,this.scanner=e,this.token={type:c.EOF,offset:-1,len:0,text:""},this.prevToken=void 0}peekIdent(e){return c.Ident===this.token.type&&e.length===this.token.text.length&&e===this.token.text.toLowerCase()}peekKeyword(e){return c.AtKeyword===this.token.type&&e.length===this.token.text.length&&e===this.token.text.toLowerCase()}peekDelim(e){return c.Delim===this.token.type&&e===this.token.text}peek(e){return e===this.token.type}peekOne(...e){return e.indexOf(this.token.type)!==-1}peekRegExp(e,t){return e!==this.token.type?!1:t.test(this.token.text)}hasWhitespace(){return!!this.prevToken&&this.prevToken.offset+this.prevToken.len!==this.token.offset}consumeToken(){this.prevToken=this.token,this.token=this.scanner.scan()}acceptUnicodeRange(){let e=this.scanner.tryScanUnicode();return e?(this.prevToken=e,this.token=this.scanner.scan(),!0):!1}mark(){return{prev:this.prevToken,curr:this.token,pos:this.scanner.pos()}}restoreAtMark(e){this.prevToken=e.prev,this.token=e.curr,this.scanner.goBackTo(e.pos)}try(e){let t=this.mark(),r=e();return r||(this.restoreAtMark(t),null)}acceptOneKeyword(e){if(c.AtKeyword===this.token.type){for(let t of e)if(t.length===this.token.text.length&&t===this.token.text.toLowerCase())return this.consumeToken(),!0}return!1}accept(e){return e===this.token.type?(this.consumeToken(),!0):!1}acceptIdent(e){return this.peekIdent(e)?(this.consumeToken(),!0):!1}acceptKeyword(e){return this.peekKeyword(e)?(this.consumeToken(),!0):!1}acceptDelim(e){return this.peekDelim(e)?(this.consumeToken(),!0):!1}acceptRegexp(e){return e.test(this.token.text)?(this.consumeToken(),!0):!1}_parseRegexp(e){let t=this.createNode(m.Identifier);do;while(this.acceptRegexp(e));return this.finish(t)}acceptUnquotedString(){let e=this.scanner.pos();this.scanner.goBackTo(this.token.offset);let t=this.scanner.scanUnquotedString();return t?(this.token=t,this.consumeToken(),!0):(this.scanner.goBackTo(e),!1)}resync(e,t){for(;;){if(e&&e.indexOf(this.token.type)!==-1)return this.consumeToken(),!0;if(t&&t.indexOf(this.token.type)!==-1)return!0;if(this.token.type===c.EOF)return!1;this.token=this.scanner.scan()}}createNode(e){return new x(this.token.offset,this.token.len,e)}create(e){return new e(this.token.offset,this.token.len)}finish(e,t,r,i){if(!(e instanceof J)&&(t&&this.markError(e,t,r,i),this.prevToken)){let s=this.prevToken.offset+this.prevToken.len;e.length=s>e.offset?s-e.offset:0}return e}markError(e,t,r,i){this.token!==this.lastErrorToken&&(e.addIssue(new wt(e,t,ee.Error,void 0,this.token.offset,this.token.len)),this.lastErrorToken=this.token),(r||i)&&this.resync(r,i)}parseStylesheet(e){let t=e.version,r=e.getText(),i=(s,a)=>{if(e.version!==t)throw new Error("Underlying model has changed, AST is no longer valid");return r.substr(s,a)};return this.internalParse(r,this._parseStylesheet,i)}internalParse(e,t,r){this.scanner.setSource(e),this.token=this.scanner.scan();let i=t.bind(this)();return i&&(r?i.textProvider=r:i.textProvider=(s,a)=>e.substr(s,a)),i}_parseStylesheet(){let e=this.create(bn);for(;e.addChild(this._parseStylesheetStart()););let t=!1;do{let r=!1;do{r=!1;let i=this._parseStylesheetStatement();for(i&&(e.addChild(i),r=!0,t=!1,!this.peek(c.EOF)&&this._needsSemicolonAfter(i)&&!this.accept(c.SemiColon)&&this.markError(e,f.SemiColonExpected));this.accept(c.SemiColon)||this.accept(c.CDO)||this.accept(c.CDC);)r=!0,t=!1}while(r);if(this.peek(c.EOF))break;t||(this.peek(c.AtKeyword)?this.markError(e,f.UnknownAtRule):this.markError(e,f.RuleOrSelectorExpected),t=!0),this.consumeToken()}while(!this.peek(c.EOF));return this.finish(e)}_parseStylesheetStart(){return this._parseCharset()}_parseStylesheetStatement(e=!1){return this.peek(c.AtKeyword)?this._parseStylesheetAtStatement(e):this._parseRuleset(e)}_parseStylesheetAtStatement(e=!1){return this._parseImport()||this._parseMedia(e)||this._parsePage()||this._parseFontFace()||this._parseKeyframe()||this._parseSupports(e)||this._parseLayer(e)||this._parsePropertyAtRule()||this._parseViewPort()||this._parseNamespace()||this._parseDocument()||this._parseContainer(e)||this._parseUnknownAtRule()}_tryParseRuleset(e){let t=this.mark();if(this._parseSelector(e)){for(;this.accept(c.Comma)&&this._parseSelector(e););if(this.accept(c.CurlyL))return this.restoreAtMark(t),this._parseRuleset(e)}return this.restoreAtMark(t),null}_parseRuleset(e=!1){let t=this.create(ae),r=t.getSelectors();if(!r.addChild(this._parseSelector(e)))return null;for(;this.accept(c.Comma);)if(!r.addChild(this._parseSelector(e)))return this.finish(t,f.SelectorExpected);return this._parseBody(t,this._parseRuleSetDeclaration.bind(this))}_parseRuleSetDeclarationAtStatement(){return this._parseMedia(!0)||this._parseSupports(!0)||this._parseLayer(!0)||this._parseContainer(!0)||this._parseUnknownAtRule()}_parseRuleSetDeclaration(){return this.peek(c.AtKeyword)?this._parseRuleSetDeclarationAtStatement():this.peek(c.Ident)?this._tryParseRuleset(!0)||this._parseDeclaration():this._parseRuleset(!0)}_needsSemicolonAfter(e){switch(e.type){case m.Keyframe:case m.ViewPort:case m.Media:case m.Ruleset:case m.Namespace:case m.If:case m.For:case m.Each:case m.While:case m.MixinDeclaration:case m.FunctionDeclaration:case m.MixinContentDeclaration:return!1;case m.ExtendsReference:case m.MixinContentReference:case m.ReturnStatement:case m.MediaQuery:case m.Debug:case m.Import:case m.AtApplyRule:case m.CustomPropertyDeclaration:return!0;case m.VariableDeclaration:return e.needsSemicolon;case m.MixinReference:return!e.getContent();case m.Declaration:return!e.getNestedProperties()}return!1}_parseDeclarations(e){let t=this.create(Ze);if(!this.accept(c.CurlyL))return null;let r=e();for(;t.addChild(r)&&!this.peek(c.CurlyR);){if(this._needsSemicolonAfter(r)&&!this.accept(c.SemiColon))return this.finish(t,f.SemiColonExpected,[c.SemiColon,c.CurlyR]);for(r&&this.prevToken&&this.prevToken.type===c.SemiColon&&(r.semicolonPosition=this.prevToken.offset);this.accept(c.SemiColon););r=e()}return this.accept(c.CurlyR)?this.finish(t):this.finish(t,f.RightCurlyExpected,[c.CurlyR,c.SemiColon])}_parseBody(e,t){return e.setDeclarations(this._parseDeclarations(t))?this.finish(e):this.finish(e,f.LeftCurlyExpected,[c.CurlyR,c.SemiColon])}_parseSelector(e){let t=this.create(de),r=!1;for(e&&(r=t.addChild(this._parseCombinator()));t.addChild(this._parseSimpleSelector());)r=!0,t.addChild(this._parseCombinator());return r?this.finish(t):null}_parseDeclaration(e){let t=this._tryParseCustomPropertyDeclaration(e);if(t)return t;let r=this.create(Q);return r.setProperty(this._parseProperty())?this.accept(c.Colon)?(this.prevToken&&(r.colonPosition=this.prevToken.offset),r.setValue(this._parseExpr())?(r.addChild(this._parsePrio()),this.peek(c.SemiColon)&&(r.semicolonPosition=this.token.offset),this.finish(r)):this.finish(r,f.PropertyValueExpected)):this.finish(r,f.ColonExpected,[c.Colon],e||[c.SemiColon]):null}_tryParseCustomPropertyDeclaration(e){if(!this.peekRegExp(c.Ident,/^--/))return null;let t=this.create(vn);if(!t.setProperty(this._parseProperty()))return null;if(!this.accept(c.Colon))return this.finish(t,f.ColonExpected,[c.Colon]);this.prevToken&&(t.colonPosition=this.prevToken.offset);let r=this.mark();if(this.peek(c.CurlyL)){let s=this.create(wn),a=this._parseDeclarations(this._parseRuleSetDeclaration.bind(this));if(s.setDeclarations(a)&&!a.isErroneous(!0)&&(s.addChild(this._parsePrio()),this.peek(c.SemiColon)))return this.finish(s),t.setPropertySet(s),t.semicolonPosition=this.token.offset,this.finish(t);this.restoreAtMark(r)}let i=this._parseExpr();return i&&!i.isErroneous(!0)&&(this._parsePrio(),this.peekOne(...e||[],c.SemiColon,c.EOF))?(t.setValue(i),this.peek(c.SemiColon)&&(t.semicolonPosition=this.token.offset),this.finish(t)):(this.restoreAtMark(r),t.addChild(this._parseCustomPropertyValue(e)),t.addChild(this._parsePrio()),ie(t.colonPosition)&&this.token.offset===t.colonPosition+1?this.finish(t,f.PropertyValueExpected):this.finish(t))}_parseCustomPropertyValue(e=[c.CurlyR]){let t=this.create(x),r=()=>s===0&&a===0&&l===0,i=()=>e.indexOf(this.token.type)!==-1,s=0,a=0,l=0;e:for(;;){switch(this.token.type){case c.SemiColon:if(r())break e;break;case c.Exclamation:if(r())break e;break;case c.CurlyL:s++;break;case c.CurlyR:if(s--,s<0){if(i()&&a===0&&l===0)break e;return this.finish(t,f.LeftCurlyExpected)}break;case c.ParenthesisL:a++;break;case c.ParenthesisR:if(a--,a<0){if(i()&&l===0&&s===0)break e;return this.finish(t,f.LeftParenthesisExpected)}break;case c.BracketL:l++;break;case c.BracketR:if(l--,l<0)return this.finish(t,f.LeftSquareBracketExpected);break;case c.BadString:break e;case c.EOF:let o=f.RightCurlyExpected;return l>0?o=f.RightSquareBracketExpected:a>0&&(o=f.RightParenthesisExpected),this.finish(t,o)}this.consumeToken()}return this.finish(t)}_tryToParseDeclaration(e){let t=this.mark();return this._parseProperty()&&this.accept(c.Colon)?(this.restoreAtMark(t),this._parseDeclaration(e)):(this.restoreAtMark(t),null)}_parseProperty(){let e=this.create(Ve),t=this.mark();return(this.acceptDelim("*")||this.acceptDelim("_"))&&this.hasWhitespace()?(this.restoreAtMark(t),null):e.setIdentifier(this._parsePropertyIdentifier())?this.finish(e):null}_parsePropertyIdentifier(){return this._parseIdent()}_parseCharset(){if(!this.peek(c.Charset))return null;let e=this.create(x);return this.consumeToken(),this.accept(c.String)?this.accept(c.SemiColon)?this.finish(e):this.finish(e,f.SemiColonExpected):this.finish(e,f.IdentifierExpected)}_parseImport(){if(!this.peekKeyword("@import"))return null;let e=this.create(je);return this.consumeToken(),!e.addChild(this._parseURILiteral())&&!e.addChild(this._parseStringLiteral())?this.finish(e,f.URIOrStringExpected):this._completeParseImport(e)}_completeParseImport(e){if(this.acceptIdent("layer")&&this.accept(c.ParenthesisL)){if(!e.addChild(this._parseLayerName()))return this.finish(e,f.IdentifierExpected,[c.SemiColon]);if(!this.accept(c.ParenthesisR))return this.finish(e,f.RightParenthesisExpected,[c.ParenthesisR],[])}return this.acceptIdent("supports")&&this.accept(c.ParenthesisL)&&(e.addChild(this._tryToParseDeclaration()||this._parseSupportsCondition()),!this.accept(c.ParenthesisR))?this.finish(e,f.RightParenthesisExpected,[c.ParenthesisR],[]):(!this.peek(c.SemiColon)&&!this.peek(c.EOF)&&e.setMedialist(this._parseMediaQueryList()),this.finish(e))}_parseNamespace(){if(!this.peekKeyword("@namespace"))return null;let e=this.create(Rn);return this.consumeToken(),!e.addChild(this._parseURILiteral())&&(e.addChild(this._parseIdent()),!e.addChild(this._parseURILiteral())&&!e.addChild(this._parseStringLiteral()))?this.finish(e,f.URIExpected,[c.SemiColon]):this.accept(c.SemiColon)?this.finish(e):this.finish(e,f.SemiColonExpected)}_parseFontFace(){if(!this.peekKeyword("@font-face"))return null;let e=this.create(pt);return this.consumeToken(),this._parseBody(e,this._parseRuleSetDeclaration.bind(this))}_parseViewPort(){if(!this.peekKeyword("@-ms-viewport")&&!this.peekKeyword("@-o-viewport")&&!this.peekKeyword("@viewport"))return null;let e=this.create(Fn);return this.consumeToken(),this._parseBody(e,this._parseRuleSetDeclaration.bind(this))}_parseKeyframe(){if(!this.peekRegExp(c.AtKeyword,this.keyframeRegex))return null;let e=this.create(mt),t=this.create(x);return this.consumeToken(),e.setKeyword(this.finish(t)),t.matches("@-ms-keyframes")&&this.markError(t,f.UnknownKeyword),e.setIdentifier(this._parseKeyframeIdent())?this._parseBody(e,this._parseKeyframeSelector.bind(this)):this.finish(e,f.IdentifierExpected,[c.CurlyR])}_parseKeyframeIdent(){return this._parseIdent([z.Keyframe])}_parseKeyframeSelector(){let e=this.create(Vt),t=!1;if(e.addChild(this._parseIdent())&&(t=!0),this.accept(c.Percentage)&&(t=!0),!t)return null;for(;this.accept(c.Comma);)if(t=!1,e.addChild(this._parseIdent())&&(t=!0),this.accept(c.Percentage)&&(t=!0),!t)return this.finish(e,f.PercentageExpected);return this._parseBody(e,this._parseRuleSetDeclaration.bind(this))}_tryParseKeyframeSelector(){let e=this.create(Vt),t=this.mark(),r=!1;if(e.addChild(this._parseIdent())&&(r=!0),this.accept(c.Percentage)&&(r=!0),!r)return null;for(;this.accept(c.Comma);)if(r=!1,e.addChild(this._parseIdent())&&(r=!0),this.accept(c.Percentage)&&(r=!0),!r)return this.restoreAtMark(t),null;return this.peek(c.CurlyL)?this._parseBody(e,this._parseRuleSetDeclaration.bind(this)):(this.restoreAtMark(t),null)}_parsePropertyAtRule(){if(!this.peekKeyword("@property"))return null;let e=this.create(Mn);return this.consumeToken(),!this.peekRegExp(c.Ident,/^--/)||!e.setName(this._parseIdent([z.Property]))?this.finish(e,f.IdentifierExpected):this._parseBody(e,this._parseDeclaration.bind(this))}_parseLayer(e=!1){if(!this.peekKeyword("@layer"))return null;let t=this.create(zn);this.consumeToken();let r=this._parseLayerNameList();return r&&t.setNames(r),(!r||r.getChildren().length===1)&&this.peek(c.CurlyL)?this._parseBody(t,this._parseLayerDeclaration.bind(this,e)):this.accept(c.SemiColon)?this.finish(t):this.finish(t,f.SemiColonExpected)}_parseLayerDeclaration(e=!1){return e?this._tryParseRuleset(!0)||this._tryToParseDeclaration()||this._parseStylesheetStatement(!0):this._parseStylesheetStatement(!1)}_parseLayerNameList(){let e=this.createNode(m.LayerNameList);if(!e.addChild(this._parseLayerName()))return null;for(;this.accept(c.Comma);)if(!e.addChild(this._parseLayerName()))return this.finish(e,f.IdentifierExpected);return this.finish(e)}_parseLayerName(){let e=this.createNode(m.LayerName);if(!e.addChild(this._parseIdent()))return null;for(;!this.hasWhitespace()&&this.acceptDelim(".");)if(this.hasWhitespace()||!e.addChild(this._parseIdent()))return this.finish(e,f.IdentifierExpected);return this.finish(e)}_parseSupports(e=!1){if(!this.peekKeyword("@supports"))return null;let t=this.create(et);return this.consumeToken(),t.addChild(this._parseSupportsCondition()),this._parseBody(t,this._parseSupportsDeclaration.bind(this,e))}_parseSupportsDeclaration(e=!1){return e?this._tryParseRuleset(!0)||this._tryToParseDeclaration()||this._parseStylesheetStatement(!0):this._parseStylesheetStatement(!1)}_parseSupportsCondition(){let e=this.create(Re);if(this.acceptIdent("not"))e.addChild(this._parseSupportsConditionInParens());else if(e.addChild(this._parseSupportsConditionInParens()),this.peekRegExp(c.Ident,/^(and|or)$/i)){let t=this.token.text.toLowerCase();for(;this.acceptIdent(t);)e.addChild(this._parseSupportsConditionInParens())}return this.finish(e)}_parseSupportsConditionInParens(){let e=this.create(Re);if(this.accept(c.ParenthesisL))return this.prevToken&&(e.lParent=this.prevToken.offset),!e.addChild(this._tryToParseDeclaration([c.ParenthesisR]))&&!this._parseSupportsCondition()?this.finish(e,f.ConditionExpected):this.accept(c.ParenthesisR)?(this.prevToken&&(e.rParent=this.prevToken.offset),this.finish(e)):this.finish(e,f.RightParenthesisExpected,[c.ParenthesisR],[]);if(this.peek(c.Ident)){let t=this.mark();if(this.consumeToken(),!this.hasWhitespace()&&this.accept(c.ParenthesisL)){let r=1;for(;this.token.type!==c.EOF&&r!==0;)this.token.type===c.ParenthesisL?r++:this.token.type===c.ParenthesisR&&r--,this.consumeToken();return this.finish(e)}else this.restoreAtMark(t)}return this.finish(e,f.LeftParenthesisExpected,[],[c.ParenthesisL])}_parseMediaDeclaration(e=!1){return e?this._tryParseRuleset(!0)||this._tryToParseDeclaration()||this._parseStylesheetStatement(!0):this._parseStylesheetStatement(!1)}_parseMedia(e=!1){if(!this.peekKeyword("@media"))return null;let t=this.create(Be);return this.consumeToken(),t.addChild(this._parseMediaQueryList())?this._parseBody(t,this._parseMediaDeclaration.bind(this,e)):this.finish(t,f.MediaQueryExpected)}_parseMediaQueryList(){let e=this.create(ut);if(!e.addChild(this._parseMediaQuery()))return this.finish(e,f.MediaQueryExpected);for(;this.accept(c.Comma);)if(!e.addChild(this._parseMediaQuery()))return this.finish(e,f.MediaQueryExpected);return this.finish(e)}_parseMediaQuery(){let e=this.create(ft),t=this.mark();if(this.acceptIdent("not"),this.peek(c.ParenthesisL))this.restoreAtMark(t),e.addChild(this._parseMediaCondition());else{if(this.acceptIdent("only"),!e.addChild(this._parseIdent()))return null;this.acceptIdent("and")&&e.addChild(this._parseMediaCondition())}return this.finish(e)}_parseRatio(){let e=this.mark(),t=this.create(Un);return this._parseNumeric()?this.acceptDelim("/")?this._parseNumeric()?this.finish(t):this.finish(t,f.NumberExpected):(this.restoreAtMark(e),null):null}_parseMediaCondition(){let e=this.create(On);this.acceptIdent("not");let t=!0;for(;t;){if(!this.accept(c.ParenthesisL))return this.finish(e,f.LeftParenthesisExpected,[],[c.CurlyL]);if(this.peek(c.ParenthesisL)||this.peekIdent("not")?e.addChild(this._parseMediaCondition()):e.addChild(this._parseMediaFeature()),!this.accept(c.ParenthesisR))return this.finish(e,f.RightParenthesisExpected,[],[c.CurlyL]);t=this.acceptIdent("and")||this.acceptIdent("or")}return this.finish(e)}_parseMediaFeature(){let e=[c.ParenthesisR],t=this.create(Pn);if(t.addChild(this._parseMediaFeatureName())){if(this.accept(c.Colon)){if(!t.addChild(this._parseMediaFeatureValue()))return this.finish(t,f.TermExpected,[],e)}else if(this._parseMediaFeatureRangeOperator()){if(!t.addChild(this._parseMediaFeatureValue()))return this.finish(t,f.TermExpected,[],e);if(this._parseMediaFeatureRangeOperator()&&!t.addChild(this._parseMediaFeatureValue()))return this.finish(t,f.TermExpected,[],e)}}else if(t.addChild(this._parseMediaFeatureValue())){if(!this._parseMediaFeatureRangeOperator())return this.finish(t,f.OperatorExpected,[],e);if(!t.addChild(this._parseMediaFeatureName()))return this.finish(t,f.IdentifierExpected,[],e);if(this._parseMediaFeatureRangeOperator()&&!t.addChild(this._parseMediaFeatureValue()))return this.finish(t,f.TermExpected,[],e)}else return this.finish(t,f.IdentifierExpected,[],e);return this.finish(t)}_parseMediaFeatureRangeOperator(){return this.acceptDelim("<")||this.acceptDelim(">")?(this.hasWhitespace()||this.acceptDelim("="),!0):!!this.acceptDelim("=")}_parseMediaFeatureName(){return this._parseIdent()}_parseMediaFeatureValue(){return this._parseRatio()||this._parseTermExpression()}_parseMedium(){let e=this.create(x);return e.addChild(this._parseIdent())?this.finish(e):null}_parsePageDeclaration(){return this._parsePageMarginBox()||this._parseRuleSetDeclaration()}_parsePage(){if(!this.peekKeyword("@page"))return null;let e=this.create(An);if(this.consumeToken(),e.addChild(this._parsePageSelector())){for(;this.accept(c.Comma);)if(!e.addChild(this._parsePageSelector()))return this.finish(e,f.IdentifierExpected)}return this._parseBody(e,this._parsePageDeclaration.bind(this))}_parsePageMarginBox(){if(!this.peek(c.AtKeyword))return null;let e=this.create(Wn);return this.acceptOneKeyword(Ks)||this.markError(e,f.UnknownAtRule,[],[c.CurlyL]),this._parseBody(e,this._parseRuleSetDeclaration.bind(this))}_parsePageSelector(){if(!this.peek(c.Ident)&&!this.peek(c.Colon))return null;let e=this.create(x);return e.addChild(this._parseIdent()),this.accept(c.Colon)&&!e.addChild(this._parseIdent())?this.finish(e,f.IdentifierExpected):this.finish(e)}_parseDocument(){if(!this.peekKeyword("@-moz-document"))return null;let e=this.create(Tn);return this.consumeToken(),this.resync([],[c.CurlyL]),this._parseBody(e,this._parseStylesheetStatement.bind(this))}_parseContainerDeclaration(e=!1){return e?this._tryParseRuleset(!0)||this._tryToParseDeclaration()||this._parseStylesheetStatement(!0):this._parseStylesheetStatement(!1)}_parseContainer(e=!1){if(!this.peekKeyword("@container"))return null;let t=this.create(Nn);return this.consumeToken(),t.addChild(this._parseIdent()),t.addChild(this._parseContainerQuery()),this._parseBody(t,this._parseContainerDeclaration.bind(this,e))}_parseContainerQuery(){let e=this.create(x);if(this.acceptIdent("not"))e.addChild(this._parseContainerQueryInParens());else if(e.addChild(this._parseContainerQueryInParens()),this.peekIdent("and"))for(;this.acceptIdent("and");)e.addChild(this._parseContainerQueryInParens());else if(this.peekIdent("or"))for(;this.acceptIdent("or");)e.addChild(this._parseContainerQueryInParens());return this.finish(e)}_parseContainerQueryInParens(){let e=this.create(x);if(this.accept(c.ParenthesisL)){if(this.peekIdent("not")||this.peek(c.ParenthesisL)?e.addChild(this._parseContainerQuery()):e.addChild(this._parseMediaFeature()),!this.accept(c.ParenthesisR))return this.finish(e,f.RightParenthesisExpected,[],[c.CurlyL])}else if(this.acceptIdent("style")){if(this.hasWhitespace()||!this.accept(c.ParenthesisL))return this.finish(e,f.LeftParenthesisExpected,[],[c.CurlyL]);if(e.addChild(this._parseStyleQuery()),!this.accept(c.ParenthesisR))return this.finish(e,f.RightParenthesisExpected,[],[c.CurlyL])}else return this.finish(e,f.LeftParenthesisExpected,[],[c.CurlyL]);return this.finish(e)}_parseStyleQuery(){let e=this.create(x);if(this.acceptIdent("not"))e.addChild(this._parseStyleInParens());else if(this.peek(c.ParenthesisL)){if(e.addChild(this._parseStyleInParens()),this.peekIdent("and"))for(;this.acceptIdent("and");)e.addChild(this._parseStyleInParens());else if(this.peekIdent("or"))for(;this.acceptIdent("or");)e.addChild(this._parseStyleInParens())}else e.addChild(this._parseDeclaration([c.ParenthesisR]));return this.finish(e)}_parseStyleInParens(){let e=this.create(x);if(this.accept(c.ParenthesisL)){if(e.addChild(this._parseStyleQuery()),!this.accept(c.ParenthesisR))return this.finish(e,f.RightParenthesisExpected,[],[c.CurlyL])}else return this.finish(e,f.LeftParenthesisExpected,[],[c.CurlyL]);return this.finish(e)}_parseUnknownAtRule(){if(!this.peek(c.AtKeyword))return null;let e=this.create(bt);e.addChild(this._parseUnknownAtRuleName());let t=()=>i===0&&s===0&&a===0,r=0,i=0,s=0,a=0;e:for(;;){switch(this.token.type){case c.SemiColon:if(t())break e;break;case c.EOF:return i>0?this.finish(e,f.RightCurlyExpected):a>0?this.finish(e,f.RightSquareBracketExpected):s>0?this.finish(e,f.RightParenthesisExpected):this.finish(e);case c.CurlyL:r++,i++;break;case c.CurlyR:if(i--,r>0&&i===0){if(this.consumeToken(),a>0)return this.finish(e,f.RightSquareBracketExpected);if(s>0)return this.finish(e,f.RightParenthesisExpected);break e}if(i<0){if(s===0&&a===0)break e;return this.finish(e,f.LeftCurlyExpected)}break;case c.ParenthesisL:s++;break;case c.ParenthesisR:if(s--,s<0)return this.finish(e,f.LeftParenthesisExpected);break;case c.BracketL:a++;break;case c.BracketR:if(a--,a<0)return this.finish(e,f.LeftSquareBracketExpected);break}this.consumeToken()}return e}_parseUnknownAtRuleName(){let e=this.create(x);return this.accept(c.AtKeyword)?this.finish(e):e}_parseOperator(){if(this.peekDelim("/")||this.peekDelim("*")||this.peekDelim("+")||this.peekDelim("-")||this.peek(c.Dashmatch)||this.peek(c.Includes)||this.peek(c.SubstringOperator)||this.peek(c.PrefixOperator)||this.peek(c.SuffixOperator)||this.peekDelim("=")){let e=this.createNode(m.Operator);return this.consumeToken(),this.finish(e)}else return null}_parseUnaryOperator(){if(!this.peekDelim("+")&&!this.peekDelim("-"))return null;let e=this.create(x);return this.consumeToken(),this.finish(e)}_parseCombinator(){if(this.peekDelim(">")){let e=this.create(x);this.consumeToken();let t=this.mark();if(!this.hasWhitespace()&&this.acceptDelim(">")){if(!this.hasWhitespace()&&this.acceptDelim(">"))return e.type=m.SelectorCombinatorShadowPiercingDescendant,this.finish(e);this.restoreAtMark(t)}return e.type=m.SelectorCombinatorParent,this.finish(e)}else if(this.peekDelim("+")){let e=this.create(x);return this.consumeToken(),e.type=m.SelectorCombinatorSibling,this.finish(e)}else if(this.peekDelim("~")){let e=this.create(x);return this.consumeToken(),e.type=m.SelectorCombinatorAllSiblings,this.finish(e)}else if(this.peekDelim("/")){let e=this.create(x);this.consumeToken();let t=this.mark();if(!this.hasWhitespace()&&this.acceptIdent("deep")&&!this.hasWhitespace()&&this.acceptDelim("/"))return e.type=m.SelectorCombinatorShadowPiercingDescendant,this.finish(e);this.restoreAtMark(t)}return null}_parseSimpleSelector(){let e=this.create(he),t=0;for(e.addChild(this._parseElementName()||this._parseNestingSelector())&&t++;(t===0||!this.hasWhitespace())&&e.addChild(this._parseSimpleSelectorBody());)t++;return t>0?this.finish(e):null}_parseNestingSelector(){if(this.peekDelim("&")){let e=this.createNode(m.SelectorCombinator);return this.consumeToken(),this.finish(e)}return null}_parseSimpleSelectorBody(){return this._parsePseudo()||this._parseHash()||this._parseClass()||this._parseAttrib()}_parseSelectorIdent(){return this._parseIdent()}_parseHash(){if(!this.peek(c.Hash)&&!this.peekDelim("#"))return null;let e=this.createNode(m.IdentifierSelector);if(this.acceptDelim("#")){if(this.hasWhitespace()||!e.addChild(this._parseSelectorIdent()))return this.finish(e,f.IdentifierExpected)}else this.consumeToken();return this.finish(e)}_parseClass(){if(!this.peekDelim("."))return null;let e=this.createNode(m.ClassSelector);return this.consumeToken(),this.hasWhitespace()||!e.addChild(this._parseSelectorIdent())?this.finish(e,f.IdentifierExpected):this.finish(e)}_parseElementName(){let e=this.mark(),t=this.createNode(m.ElementNameSelector);return t.addChild(this._parseNamespacePrefix()),!t.addChild(this._parseSelectorIdent())&&!this.acceptDelim("*")?(this.restoreAtMark(e),null):this.finish(t)}_parseNamespacePrefix(){let e=this.mark(),t=this.createNode(m.NamespacePrefix);return!t.addChild(this._parseIdent())&&this.acceptDelim("*"),this.acceptDelim("|")?this.finish(t):(this.restoreAtMark(e),null)}_parseAttrib(){if(!this.peek(c.BracketL))return null;let e=this.create($n);return this.consumeToken(),e.setNamespacePrefix(this._parseNamespacePrefix()),e.setIdentifier(this._parseIdent())?(e.setOperator(this._parseOperator())&&(e.setValue(this._parseBinaryExpr()),this.acceptIdent("i"),this.acceptIdent("s")),this.accept(c.BracketR)?this.finish(e):this.finish(e,f.RightSquareBracketExpected)):this.finish(e,f.IdentifierExpected)}_parsePseudo(){let e=this._tryParsePseudoIdentifier();if(e){if(!this.hasWhitespace()&&this.accept(c.ParenthesisL)){let t=()=>{let i=this.create(x);if(!i.addChild(this._parseSelector(!0)))return null;for(;this.accept(c.Comma)&&i.addChild(this._parseSelector(!0)););return this.peek(c.ParenthesisR)?this.finish(i):null};if(!e.addChild(this.try(t))&&e.addChild(this._parseBinaryExpr())&&this.acceptIdent("of")&&!e.addChild(this.try(t)))return this.finish(e,f.SelectorExpected);if(!this.accept(c.ParenthesisR))return this.finish(e,f.RightParenthesisExpected)}return this.finish(e)}return null}_tryParsePseudoIdentifier(){if(!this.peek(c.Colon))return null;let e=this.mark(),t=this.createNode(m.PseudoSelector);return this.consumeToken(),this.hasWhitespace()?(this.restoreAtMark(e),null):(this.accept(c.Colon),this.hasWhitespace()||!t.addChild(this._parseIdent())?this.finish(t,f.IdentifierExpected):this.finish(t))}_tryParsePrio(){let e=this.mark(),t=this._parsePrio();return t||(this.restoreAtMark(e),null)}_parsePrio(){if(!this.peek(c.Exclamation))return null;let e=this.createNode(m.Prio);return this.accept(c.Exclamation)&&this.acceptIdent("important")?this.finish(e):null}_parseExpr(e=!1){let t=this.create(gt);if(!t.addChild(this._parseBinaryExpr()))return null;for(;;){if(this.peek(c.Comma)){if(e)return this.finish(t);this.consumeToken()}if(!t.addChild(this._parseBinaryExpr()))break}return this.finish(t)}_parseUnicodeRange(){if(!this.peekIdent("u"))return null;let e=this.create(gn);return this.acceptUnicodeRange()?this.finish(e):null}_parseNamedLine(){if(!this.peek(c.BracketL))return null;let e=this.createNode(m.GridLine);for(this.consumeToken();e.addChild(this._parseIdent()););return this.accept(c.BracketR)?this.finish(e):this.finish(e,f.RightSquareBracketExpected)}_parseBinaryExpr(e,t){let r=this.create(qe);if(!r.setLeft(e||this._parseTerm()))return null;if(!r.setOperator(t||this._parseOperator()))return this.finish(r);if(!r.setRight(this._parseTerm()))return this.finish(r,f.TermExpected);r=this.finish(r);let i=this._parseOperator();return i&&(r=this._parseBinaryExpr(r,i)),this.finish(r)}_parseTerm(){let e=this.create(Ln);return e.setOperator(this._parseUnaryOperator()),e.setExpression(this._parseTermExpression())?this.finish(e):null}_parseTermExpression(){return this._parseURILiteral()||this._parseUnicodeRange()||this._parseFunction()||this._parseIdent()||this._parseStringLiteral()||this._parseNumeric()||this._parseHexColor()||this._parseOperation()||this._parseNamedLine()}_parseOperation(){if(!this.peek(c.ParenthesisL))return null;let e=this.create(x);return this.consumeToken(),e.addChild(this._parseExpr()),this.accept(c.ParenthesisR)?this.finish(e):this.finish(e,f.RightParenthesisExpected)}_parseNumeric(){if(this.peek(c.Num)||this.peek(c.Percentage)||this.peek(c.Resolution)||this.peek(c.Length)||this.peek(c.EMS)||this.peek(c.EXS)||this.peek(c.Angle)||this.peek(c.Time)||this.peek(c.Dimension)||this.peek(c.ContainerQueryLength)||this.peek(c.Freq)){let e=this.create(nt);return this.consumeToken(),this.finish(e)}return null}_parseStringLiteral(){if(!this.peek(c.String)&&!this.peek(c.BadString))return null;let e=this.createNode(m.StringLiteral);return this.consumeToken(),this.finish(e)}_parseURILiteral(){if(!this.peekRegExp(c.Ident,/^url(-prefix)?$/i))return null;let e=this.mark(),t=this.createNode(m.URILiteral);return this.accept(c.Ident),this.hasWhitespace()||!this.peek(c.ParenthesisL)?(this.restoreAtMark(e),null):(this.scanner.inURL=!0,this.consumeToken(),t.addChild(this._parseURLArgument()),this.scanner.inURL=!1,this.accept(c.ParenthesisR)?this.finish(t):this.finish(t,f.RightParenthesisExpected))}_parseURLArgument(){let e=this.create(x);return!this.accept(c.String)&&!this.accept(c.BadString)&&!this.acceptUnquotedString()?null:this.finish(e)}_parseIdent(e){if(!this.peek(c.Ident))return null;let t=this.create(G);return e&&(t.referenceTypes=e),t.isCustomProperty=this.peekRegExp(c.Ident,/^--/),this.consumeToken(),this.finish(t)}_parseFunction(){let e=this.mark(),t=this.create(me);if(!t.setIdentifier(this._parseFunctionIdentifier()))return null;if(this.hasWhitespace()||!this.accept(c.ParenthesisL))return this.restoreAtMark(e),null;if(t.getArguments().addChild(this._parseFunctionArgument()))for(;this.accept(c.Comma)&&!this.peek(c.ParenthesisR);)t.getArguments().addChild(this._parseFunctionArgument())||this.markError(t,f.ExpressionExpected);return this.accept(c.ParenthesisR)?this.finish(t):this.finish(t,f.RightParenthesisExpected)}_parseFunctionIdentifier(){if(!this.peek(c.Ident))return null;let e=this.create(G);if(e.referenceTypes=[z.Function],this.acceptIdent("progid")){if(this.accept(c.Colon))for(;this.accept(c.Ident)&&this.acceptDelim("."););return this.finish(e)}return this.consumeToken(),this.finish(e)}_parseFunctionArgument(){let e=this.create(le);return e.setValue(this._parseExpr(!0))?this.finish(e):null}_parseHexColor(){if(this.peekRegExp(c.Hash,/^#([A-Fa-f0-9]{3}|[A-Fa-f0-9]{4}|[A-Fa-f0-9]{6}|[A-Fa-f0-9]{8})$/g)){let e=this.create(tt);return this.consumeToken(),this.finish(e)}else return null}};function Hs(n,e){let t=0,r=n.length;if(r===0)return 0;for(;t<r;){let i=Math.floor((t+r)/2);e(n[i])?r=i:t=i+1}return t}function gi(n,e){return n.indexOf(e)!==-1}function Qt(...n){let e=[];for(let t of n)for(let r of t)gi(e,r)||e.push(r);return e}var or=class{constructor(e,t){this.offset=e,this.length=t,this.symbols=[],this.parent=null,this.children=[]}addChild(e){this.children.push(e),e.setParent(this)}setParent(e){this.parent=e}findScope(e,t=0){return this.offset<=e&&this.offset+this.length>e+t||this.offset===e&&this.length===t?this.findInScope(e,t):null}findInScope(e,t=0){let r=e+t,i=Hs(this.children,a=>a.offset>r);if(i===0)return this;let s=this.children[i-1];return s.offset<=e&&s.offset+s.length>=e+t?s.findInScope(e,t):this}addSymbol(e){this.symbols.push(e)}getSymbol(e,t){for(let r=0;r<this.symbols.length;r++){let i=this.symbols[r];if(i.name===e&&i.type===t)return i}return null}getSymbols(){return this.symbols}},bi=class extends or{constructor(){super(0,Number.MAX_VALUE)}},Ft=class{constructor(e,t,r,i){this.name=e,this.value=t,this.node=r,this.type=i}},wi=class{constructor(e){this.scope=e}addSymbol(e,t,r,i){if(e.offset!==-1){let s=this.scope.findScope(e.offset,e.length);s&&s.addSymbol(new Ft(t,r,e,i))}}addScope(e){if(e.offset!==-1){let t=this.scope.findScope(e.offset,e.length);if(t&&(t.offset!==e.offset||t.length!==e.length)){let r=new or(e.offset,e.length);return t.addChild(r),r}return t}return null}addSymbolToChildScope(e,t,r,i,s){if(e&&e.offset!==-1){let a=this.addScope(e);a&&a.addSymbol(new Ft(r,i,t,s))}}visitNode(e){switch(e.type){case m.Keyframe:return this.addSymbol(e,e.getName(),void 0,z.Keyframe),!0;case m.CustomPropertyDeclaration:return this.visitCustomPropertyDeclarationNode(e);case m.VariableDeclaration:return this.visitVariableDeclarationNode(e);case m.Ruleset:return this.visitRuleSet(e);case m.MixinDeclaration:return this.addSymbol(e,e.getName(),void 0,z.Mixin),!0;case m.FunctionDeclaration:return this.addSymbol(e,e.getName(),void 0,z.Function),!0;case m.FunctionParameter:return this.visitFunctionParameterNode(e);case m.Declarations:return this.addScope(e),!0;case m.For:let t=e,r=t.getDeclarations();return r&&t.variable&&this.addSymbolToChildScope(r,t.variable,t.variable.getName(),void 0,z.Variable),!0;case m.Each:{let i=e,s=i.getDeclarations();if(s){let a=i.getVariables().getChildren();for(let l of a)this.addSymbolToChildScope(s,l,l.getName(),void 0,z.Variable)}return!0}}return!0}visitRuleSet(e){let t=this.scope.findScope(e.offset,e.length);if(t)for(let r of e.getSelectors().getChildren())r instanceof de&&r.getChildren().length===1&&t.addSymbol(new Ft(r.getChild(0).getText(),void 0,r,z.Rule));return!0}visitVariableDeclarationNode(e){let t=e.getValue()?e.getValue().getText():void 0;return this.addSymbol(e,e.getName(),t,z.Variable),!0}visitFunctionParameterNode(e){let t=e.getParent().getDeclarations();if(t){let r=e.getDefaultValue(),i=r?r.getText():void 0;this.addSymbolToChildScope(t,e,e.getName(),i,z.Variable)}return!0}visitCustomPropertyDeclarationNode(e){let t=e.getValue()?e.getValue().getText():"";return this.addCSSVariable(e.getProperty(),e.getProperty().getName(),t,z.Variable),!0}addCSSVariable(e,t,r,i){e.offset!==-1&&this.scope.addSymbol(new Ft(t,r,e,i))}},ot=class{constructor(e){this.global=new bi,e.acceptVisitor(new wi(this.global))}findSymbolsAtOffset(e,t){let r=this.global.findScope(e,0),i=[],s={};for(;r;){let a=r.getSymbols();for(let l=0;l<a.length;l++){let o=a[l];o.type===t&&!s[o.name]&&(i.push(o),s[o.name]=!0)}r=r.parent}return i}internalFindSymbol(e,t){let r=e;if(e.parent instanceof ye&&e.parent.getParent()instanceof L&&(r=e.parent.getParent().getDeclarations()),e.parent instanceof le&&e.parent.getParent()instanceof me){let a=e.parent.getParent().getIdentifier();if(a){let l=this.internalFindSymbol(a,[z.Function]);l&&(r=l.node.getDeclarations())}}if(!r)return null;let i=e.getText(),s=this.global.findScope(r.offset,r.length);for(;s;){for(let a=0;a<t.length;a++){let l=t[a],o=s.getSymbol(i,l);if(o)return o}s=s.parent}return null}evaluateReferenceTypes(e){if(e instanceof G){let r=e.referenceTypes;if(r)return r;{if(e.isCustomProperty)return[z.Variable];let i=Xi(e);if(i){let s=i.getNonPrefixedPropertyName();if((s==="animation"||s==="animation-name")&&i.getValue()&&i.getValue().offset===e.offset)return[z.Keyframe]}}}else if(e instanceof Ke)return[z.Variable];return e.findAParent(m.Selector,m.ExtendsReference)?[z.Rule]:null}findSymbolFromNode(e){if(!e)return null;for(;e.type===m.Interpolation;)e=e.getParent();let t=this.evaluateReferenceTypes(e);return t?this.internalFindSymbol(e,t):null}matchesSymbol(e,t){if(!e)return!1;for(;e.type===m.Interpolation;)e=e.getParent();if(!e.matches(t.name))return!1;let r=this.evaluateReferenceTypes(e);return!r||r.indexOf(t.type)===-1?!1:this.internalFindSymbol(e,r)===t}findSymbol(e,t,r){let i=this.global.findScope(r);for(;i;){let s=i.getSymbol(e,t);if(s)return s;i=i.parent}return null}};var Js;(()=>{"use strict";var n={470:i=>{function s(o){if(typeof o!="string")throw new TypeError("Path must be a string. Received "+JSON.stringify(o))}function a(o,d){for(var h,u="",w=0,b=-1,y=0,E=0;E<=o.length;++E){if(E<o.length)h=o.charCodeAt(E);else{if(h===47)break;h=47}if(h===47){if(!(b===E-1||y===1))if(b!==E-1&&y===2){if(u.length<2||w!==2||u.charCodeAt(u.length-1)!==46||u.charCodeAt(u.length-2)!==46){if(u.length>2){var A=u.lastIndexOf("/");if(A!==u.length-1){A===-1?(u="",w=0):w=(u=u.slice(0,A)).length-1-u.lastIndexOf("/"),b=E,y=0;continue}}else if(u.length===2||u.length===1){u="",w=0,b=E,y=0;continue}}d&&(u.length>0?u+="/..":u="..",w=2)}else u.length>0?u+="/"+o.slice(b+1,E):u=o.slice(b+1,E),w=E-b-1;b=E,y=0}else h===46&&y!==-1?++y:y=-1}return u}var l={resolve:function(){for(var o,d="",h=!1,u=arguments.length-1;u>=-1&&!h;u--){var w;u>=0?w=arguments[u]:(o===void 0&&(o=process.cwd()),w=o),s(w),w.length!==0&&(d=w+"/"+d,h=w.charCodeAt(0)===47)}return d=a(d,!h),h?d.length>0?"/"+d:"/":d.length>0?d:"."},normalize:function(o){if(s(o),o.length===0)return".";var d=o.charCodeAt(0)===47,h=o.charCodeAt(o.length-1)===47;return(o=a(o,!d)).length!==0||d||(o="."),o.length>0&&h&&(o+="/"),d?"/"+o:o},isAbsolute:function(o){return s(o),o.length>0&&o.charCodeAt(0)===47},join:function(){if(arguments.length===0)return".";for(var o,d=0;d<arguments.length;++d){var h=arguments[d];s(h),h.length>0&&(o===void 0?o=h:o+="/"+h)}return o===void 0?".":l.normalize(o)},relative:function(o,d){if(s(o),s(d),o===d||(o=l.resolve(o))===(d=l.resolve(d)))return"";for(var h=1;h<o.length&&o.charCodeAt(h)===47;++h);for(var u=o.length,w=u-h,b=1;b<d.length&&d.charCodeAt(b)===47;++b);for(var y=d.length-b,E=w<y?w:y,A=-1,I=0;I<=E;++I){if(I===E){if(y>E){if(d.charCodeAt(b+I)===47)return d.slice(b+I+1);if(I===0)return d.slice(b+I)}else w>E&&(o.charCodeAt(h+I)===47?A=I:I===0&&(A=0));break}var P=o.charCodeAt(h+I);if(P!==d.charCodeAt(b+I))break;P===47&&(A=I)}var T="";for(I=h+A+1;I<=u;++I)I!==u&&o.charCodeAt(I)!==47||(T.length===0?T+="..":T+="/..");return T.length>0?T+d.slice(b+A):(b+=A,d.charCodeAt(b)===47&&++b,d.slice(b))},_makeLong:function(o){return o},dirname:function(o){if(s(o),o.length===0)return".";for(var d=o.charCodeAt(0),h=d===47,u=-1,w=!0,b=o.length-1;b>=1;--b)if((d=o.charCodeAt(b))===47){if(!w){u=b;break}}else w=!1;return u===-1?h?"/":".":h&&u===1?"//":o.slice(0,u)},basename:function(o,d){if(d!==void 0&&typeof d!="string")throw new TypeError('"ext" argument must be a string');s(o);var h,u=0,w=-1,b=!0;if(d!==void 0&&d.length>0&&d.length<=o.length){if(d.length===o.length&&d===o)return"";var y=d.length-1,E=-1;for(h=o.length-1;h>=0;--h){var A=o.charCodeAt(h);if(A===47){if(!b){u=h+1;break}}else E===-1&&(b=!1,E=h+1),y>=0&&(A===d.charCodeAt(y)?--y==-1&&(w=h):(y=-1,w=E))}return u===w?w=E:w===-1&&(w=o.length),o.slice(u,w)}for(h=o.length-1;h>=0;--h)if(o.charCodeAt(h)===47){if(!b){u=h+1;break}}else w===-1&&(b=!1,w=h+1);return w===-1?"":o.slice(u,w)},extname:function(o){s(o);for(var d=-1,h=0,u=-1,w=!0,b=0,y=o.length-1;y>=0;--y){var E=o.charCodeAt(y);if(E!==47)u===-1&&(w=!1,u=y+1),E===46?d===-1?d=y:b!==1&&(b=1):d!==-1&&(b=-1);else if(!w){h=y+1;break}}return d===-1||u===-1||b===0||b===1&&d===u-1&&d===h+1?"":o.slice(d,u)},format:function(o){if(o===null||typeof o!="object")throw new TypeError('The "pathObject" argument must be of type Object. Received type '+typeof o);return function(d,h){var u=h.dir||h.root,w=h.base||(h.name||"")+(h.ext||"");return u?u===h.root?u+w:u+"/"+w:w}(0,o)},parse:function(o){s(o);var d={root:"",dir:"",base:"",ext:"",name:""};if(o.length===0)return d;var h,u=o.charCodeAt(0),w=u===47;w?(d.root="/",h=1):h=0;for(var b=-1,y=0,E=-1,A=!0,I=o.length-1,P=0;I>=h;--I)if((u=o.charCodeAt(I))!==47)E===-1&&(A=!1,E=I+1),u===46?b===-1?b=I:P!==1&&(P=1):b!==-1&&(P=-1);else if(!A){y=I+1;break}return b===-1||E===-1||P===0||P===1&&b===E-1&&b===y+1?E!==-1&&(d.base=d.name=y===0&&w?o.slice(1,E):o.slice(y,E)):(y===0&&w?(d.name=o.slice(1,b),d.base=o.slice(1,E)):(d.name=o.slice(y,b),d.base=o.slice(y,E)),d.ext=o.slice(b,E)),y>0?d.dir=o.slice(0,y-1):w&&(d.dir="/"),d},sep:"/",delimiter:":",win32:null,posix:null};l.posix=l,i.exports=l}},e={};function t(i){var s=e[i];if(s!==void 0)return s.exports;var a=e[i]={exports:{}};return n[i](a,a.exports,t),a.exports}t.d=(i,s)=>{for(var a in s)t.o(s,a)&&!t.o(i,a)&&Object.defineProperty(i,a,{enumerable:!0,get:s[a]})},t.o=(i,s)=>Object.prototype.hasOwnProperty.call(i,s),t.r=i=>{typeof Symbol<"u"&&Symbol.toStringTag&&Object.defineProperty(i,Symbol.toStringTag,{value:"Module"}),Object.defineProperty(i,"__esModule",{value:!0})};var r={};(()=>{let i;t.r(r),t.d(r,{URI:()=>w,Utils:()=>Ie}),typeof process=="object"?i=process.platform==="win32":typeof navigator=="object"&&(i=navigator.userAgent.indexOf("Windows")>=0);let s=/^\w[\w\d+.-]*$/,a=/^\//,l=/^\/\//;function o(S,v){if(!S.scheme&&v)throw new Error(`[UriError]: Scheme is missing: {scheme: "", authority: "${S.authority}", path: "${S.path}", query: "${S.query}", fragment: "${S.fragment}"}`);if(S.scheme&&!s.test(S.scheme))throw new Error("[UriError]: Scheme contains illegal characters.");if(S.path){if(S.authority){if(!a.test(S.path))throw new Error('[UriError]: If a URI contains an authority component, then the path component must either be empty or begin with a slash ("/") character')}else if(l.test(S.path))throw new Error('[UriError]: If a URI does not contain an authority component, then the path cannot begin with two slash characters ("//")')}}let d="",h="/",u=/^(([^:/?#]+?):)?(\/\/([^/?#]*))?([^?#]*)(\?([^#]*))?(#(.*))?/;class w{static isUri(v){return v instanceof w||!!v&&typeof v.authority=="string"&&typeof v.fragment=="string"&&typeof v.path=="string"&&typeof v.query=="string"&&typeof v.scheme=="string"&&typeof v.fsPath=="string"&&typeof v.with=="function"&&typeof v.toString=="function"}scheme;authority;path;query;fragment;constructor(v,F,C,N,D,M=!1){typeof v=="object"?(this.scheme=v.scheme||d,this.authority=v.authority||d,this.path=v.path||d,this.query=v.query||d,this.fragment=v.fragment||d):(this.scheme=function(oe,Z){return oe||Z?oe:"file"}(v,M),this.authority=F||d,this.path=function(oe,Z){switch(oe){case"https":case"http":case"file":Z?Z[0]!==h&&(Z=h+Z):Z=h}return Z}(this.scheme,C||d),this.query=N||d,this.fragment=D||d,o(this,M))}get fsPath(){return P(this,!1)}with(v){if(!v)return this;let{scheme:F,authority:C,path:N,query:D,fragment:M}=v;return F===void 0?F=this.scheme:F===null&&(F=d),C===void 0?C=this.authority:C===null&&(C=d),N===void 0?N=this.path:N===null&&(N=d),D===void 0?D=this.query:D===null&&(D=d),M===void 0?M=this.fragment:M===null&&(M=d),F===this.scheme&&C===this.authority&&N===this.path&&D===this.query&&M===this.fragment?this:new y(F,C,N,D,M)}static parse(v,F=!1){let C=u.exec(v);return C?new y(C[2]||d,Y(C[4]||d),Y(C[5]||d),Y(C[7]||d),Y(C[9]||d),F):new y(d,d,d,d,d)}static file(v){let F=d;if(i&&(v=v.replace(/\\/g,h)),v[0]===h&&v[1]===h){let C=v.indexOf(h,2);C===-1?(F=v.substring(2),v=h):(F=v.substring(2,C),v=v.substring(C)||h)}return new y("file",F,v,d,d)}static from(v){let F=new y(v.scheme,v.authority,v.path,v.query,v.fragment);return o(F,!0),F}toString(v=!1){return T(this,v)}toJSON(){return this}static revive(v){if(v){if(v instanceof w)return v;{let F=new y(v);return F._formatted=v.external,F._fsPath=v._sep===b?v.fsPath:null,F}}return v}}let b=i?1:void 0;class y extends w{_formatted=null;_fsPath=null;get fsPath(){return this._fsPath||(this._fsPath=P(this,!1)),this._fsPath}toString(v=!1){return v?T(this,!0):(this._formatted||(this._formatted=T(this,!1)),this._formatted)}toJSON(){let v={$mid:1};return this._fsPath&&(v.fsPath=this._fsPath,v._sep=b),this._formatted&&(v.external=this._formatted),this.path&&(v.path=this.path),this.scheme&&(v.scheme=this.scheme),this.authority&&(v.authority=this.authority),this.query&&(v.query=this.query),this.fragment&&(v.fragment=this.fragment),v}}let E={58:"%3A",47:"%2F",63:"%3F",35:"%23",91:"%5B",93:"%5D",64:"%40",33:"%21",36:"%24",38:"%26",39:"%27",40:"%28",41:"%29",42:"%2A",43:"%2B",44:"%2C",59:"%3B",61:"%3D",32:"%20"};function A(S,v,F){let C,N=-1;for(let D=0;D<S.length;D++){let M=S.charCodeAt(D);if(M>=97&&M<=122||M>=65&&M<=90||M>=48&&M<=57||M===45||M===46||M===95||M===126||v&&M===47||F&&M===91||F&&M===93||F&&M===58)N!==-1&&(C+=encodeURIComponent(S.substring(N,D)),N=-1),C!==void 0&&(C+=S.charAt(D));else{C===void 0&&(C=S.substr(0,D));let oe=E[M];oe!==void 0?(N!==-1&&(C+=encodeURIComponent(S.substring(N,D)),N=-1),C+=oe):N===-1&&(N=D)}}return N!==-1&&(C+=encodeURIComponent(S.substring(N))),C!==void 0?C:S}function I(S){let v;for(let F=0;F<S.length;F++){let C=S.charCodeAt(F);C===35||C===63?(v===void 0&&(v=S.substr(0,F)),v+=E[C]):v!==void 0&&(v+=S[F])}return v!==void 0?v:S}function P(S,v){let F;return F=S.authority&&S.path.length>1&&S.scheme==="file"?`//${S.authority}${S.path}`:S.path.charCodeAt(0)===47&&(S.path.charCodeAt(1)>=65&&S.path.charCodeAt(1)<=90||S.path.charCodeAt(1)>=97&&S.path.charCodeAt(1)<=122)&&S.path.charCodeAt(2)===58?v?S.path.substr(1):S.path[1].toLowerCase()+S.path.substr(2):S.path,i&&(F=F.replace(/\//g,"\\")),F}function T(S,v){let F=v?I:A,C="",{scheme:N,authority:D,path:M,query:oe,fragment:Z}=S;if(N&&(C+=N,C+=":"),(D||N==="file")&&(C+=h,C+=h),D){let $=D.indexOf("@");if($!==-1){let Ue=D.substr(0,$);D=D.substr($+1),$=Ue.lastIndexOf(":"),$===-1?C+=F(Ue,!1,!1):(C+=F(Ue.substr(0,$),!1,!1),C+=":",C+=F(Ue.substr($+1),!1,!0)),C+="@"}D=D.toLowerCase(),$=D.lastIndexOf(":"),$===-1?C+=F(D,!1,!0):(C+=F(D.substr(0,$),!1,!0),C+=D.substr($))}if(M){if(M.length>=3&&M.charCodeAt(0)===47&&M.charCodeAt(2)===58){let $=M.charCodeAt(1);$>=65&&$<=90&&(M=`/${String.fromCharCode($+32)}:${M.substr(3)}`)}else if(M.length>=2&&M.charCodeAt(1)===58){let $=M.charCodeAt(0);$>=65&&$<=90&&(M=`${String.fromCharCode($+32)}:${M.substr(2)}`)}C+=F(M,!0,!1)}return oe&&(C+="?",C+=F(oe,!1,!1)),Z&&(C+="#",C+=v?Z:A(Z,!1,!1)),C}function j(S){try{return decodeURIComponent(S)}catch{return S.length>3?S.substr(0,3)+j(S.substr(3)):S}}let X=/(%[0-9A-Za-z][0-9A-Za-z])+/g;function Y(S){return S.match(X)?S.replace(X,v=>j(v)):S}var $e=t(470);let K=$e.posix||$e,_e="/";var Ie;(function(S){S.joinPath=function(v,...F){return v.with({path:K.join(v.path,...F)})},S.resolvePath=function(v,...F){let C=v.path,N=!1;C[0]!==_e&&(C=_e+C,N=!0);let D=K.resolve(C,...F);return N&&D[0]===_e&&!v.authority&&(D=D.substring(1)),v.with({path:D})},S.dirname=function(v){if(v.path.length===0||v.path===_e)return v;let F=K.dirname(v.path);return F.length===1&&F.charCodeAt(0)===46&&(F=""),v.with({path:F})},S.basename=function(v){return K.basename(v.path)},S.extname=function(v){return K.extname(v.path)}})(Ie||(Ie={}))})(),Js=r})();var{URI:Zt,Utils:Fe}=Js;function ar(n){return Fe.dirname(Zt.parse(n)).toString(!0)}function Je(n,...e){return Fe.joinPath(Zt.parse(n),...e).toString(!0)}var cr=class{constructor(e){this.readDirectory=e,this.literalCompletions=[],this.importCompletions=[]}onCssURILiteralValue(e){this.literalCompletions.push(e)}onCssImportPath(e){this.importCompletions.push(e)}async computeCompletions(e,t){let r={items:[],isIncomplete:!1};for(let i of this.literalCompletions){let s=i.uriValue,a=vi(s);if(a==="."||a==="..")r.isIncomplete=!0;else{let l=await this.providePathSuggestions(s,i.position,i.range,e,t);for(let o of l)r.items.push(o)}}for(let i of this.importCompletions){let s=i.pathValue,a=vi(s);if(a==="."||a==="..")r.isIncomplete=!0;else{let l=await this.providePathSuggestions(s,i.position,i.range,e,t);e.languageId==="scss"&&l.forEach(o=>{V(o.label,"_")&&fn(o.label,".scss")&&(o.textEdit?o.textEdit.newText=o.label.slice(1,-5):o.label=o.label.slice(1,-5))});for(let o of l)r.items.push(o)}}return r}async providePathSuggestions(e,t,r,i,s){let a=vi(e),l=V(e,"'")||V(e,'"'),o=l?a.slice(0,t.character-(r.start.character+1)):a.slice(0,t.character-r.start.character),d=i.uri,h=l?ba(r,1,-1):r,u=fa(o,a,h),w=o.substring(0,o.lastIndexOf("/")+1),b=s.resolveReference(w||".",d);if(b)try{let y=[],E=await this.readDirectory(b);for(let[A,I]of E)A.charCodeAt(0)!==ua&&(I===st.Directory||Je(b,A)!==d)&&y.push(ga(A,I===st.Directory,u));return y}catch{}return[]}},ua=46;function vi(n){return V(n,"'")||V(n,'"')?n.slice(1,-1):n}function fa(n,e,t){let r,i=n.lastIndexOf("/");if(i===-1)r=t;else{let s=e.slice(i+1),a=dr(t.end,-s.length),l=s.indexOf(" "),o;l!==-1?o=dr(a,l):o=t.end,r=R.create(a,o)}return r}function ga(n,e,t){return e?(n=n+"/",{label:lr(n),kind:k.Folder,textEdit:_.replace(t,lr(n)),command:{title:"Suggest",command:"editor.action.triggerSuggest"}}):{label:lr(n),kind:k.File,textEdit:_.replace(t,lr(n))}}function lr(n){return n.replace(/(\s|\(|\)|,|"|')/g,"\\$1")}function dr(n,e){return H.create(n.line,n.character+e)}function ba(n,e,t){let r=dr(n.start,e),i=dr(n.end,t);return R.create(r,i)}var Ne=te.Snippet,Xs={title:"Suggest",command:"editor.action.triggerSuggest"},Ee;(function(n){n.Enums=" ",n.Normal="d",n.VendorPrefixed="x",n.Term="y",n.Variable="z"})(Ee||(Ee={}));var Xe=class{constructor(e=null,t,r){this.variablePrefix=e,this.lsOptions=t,this.cssDataManager=r,this.completionParticipants=[]}configure(e){this.defaultSettings=e}getSymbolContext(){return this.symbolContext||(this.symbolContext=new ot(this.styleSheet)),this.symbolContext}setCompletionParticipants(e){this.completionParticipants=e||[]}async doComplete2(e,t,r,i,s=this.defaultSettings){if(!this.lsOptions.fileSystemProvider||!this.lsOptions.fileSystemProvider.readDirectory)return this.doComplete(e,t,r,s);let a=new cr(this.lsOptions.fileSystemProvider.readDirectory),l=this.completionParticipants;this.completionParticipants=[a].concat(l);let o=this.doComplete(e,t,r,s);try{let d=await a.computeCompletions(e,i);return{isIncomplete:o.isIncomplete||d.isIncomplete,itemDefaults:o.itemDefaults,items:d.items.concat(o.items)}}finally{this.completionParticipants=l}}doComplete(e,t,r,i){this.offset=e.offsetAt(t),this.position=t,this.currentWord=va(e,this.offset),this.defaultReplaceRange=R.create(H.create(this.position.line,this.position.character-this.currentWord.length),this.position),this.textDocument=e,this.styleSheet=r,this.documentSettings=i;try{let s={isIncomplete:!1,itemDefaults:{editRange:{start:{line:t.line,character:t.character-this.currentWord.length},end:t}},items:[]};this.nodePath=vt(this.styleSheet,this.offset);for(let a=this.nodePath.length-1;a>=0;a--){let l=this.nodePath[a];if(l instanceof Ve)this.getCompletionsForDeclarationProperty(l.getParent(),s);else if(l instanceof gt)l.parent instanceof rt?this.getVariableProposals(null,s):this.getCompletionsForExpression(l,s);else if(l instanceof he){let o=l.findAParent(m.ExtendsReference,m.Ruleset);if(o)if(o.type===m.ExtendsReference)this.getCompletionsForExtendsReference(o,l,s);else{let d=o;this.getCompletionsForSelector(d,d&&d.isNested(),s)}}else if(l instanceof le)this.getCompletionsForFunctionArgument(l,l.getParent(),s);else if(l instanceof Ze)this.getCompletionsForDeclarations(l,s);else if(l instanceof xe)this.getCompletionsForVariableDeclaration(l,s);else if(l instanceof ae)this.getCompletionsForRuleSet(l,s);else if(l instanceof rt)this.getCompletionsForInterpolation(l,s);else if(l instanceof De)this.getCompletionsForFunctionDeclaration(l,s);else if(l instanceof ze)this.getCompletionsForMixinReference(l,s);else if(l instanceof me)this.getCompletionsForFunctionArgument(null,l,s);else if(l instanceof et)this.getCompletionsForSupports(l,s);else if(l instanceof Re)this.getCompletionsForSupportsCondition(l,s);else if(l instanceof Se)this.getCompletionsForExtendsReference(l,null,s);else if(l.type===m.URILiteral)this.getCompletionForUriLiteralValue(l,s);else if(l.parent===null)this.getCompletionForTopLevel(s);else if(l.type===m.StringLiteral&&this.isImportPathParent(l.parent.type))this.getCompletionForImportPath(l,s);else continue;if(s.items.length>0||this.offset>l.offset)return this.finalize(s)}return this.getCompletionsForStylesheet(s),s.items.length===0&&this.variablePrefix&&this.currentWord.indexOf(this.variablePrefix)===0&&this.getVariableProposals(null,s),this.finalize(s)}finally{this.position=null,this.currentWord=null,this.textDocument=null,this.styleSheet=null,this.symbolContext=null,this.defaultReplaceRange=null,this.nodePath=null}}isImportPathParent(e){return e===m.Import}finalize(e){return e}findInNodePath(...e){for(let t=this.nodePath.length-1;t>=0;t--){let r=this.nodePath[t];if(e.indexOf(r.type)!==-1)return r}return null}getCompletionsForDeclarationProperty(e,t){return this.getPropertyProposals(e,t)}getPropertyProposals(e,t){let r=this.isTriggerPropertyValueCompletionEnabled,i=this.isCompletePropertyWithSemicolonEnabled;return this.cssDataManager.getProperties().forEach(a=>{let l,o,d=!1;e?(l=this.getCompletionRange(e.getProperty()),o=a.name,ie(e.colonPosition)||(o+=": ",d=!0)):(l=this.getCompletionRange(null),o=a.name+": ",d=!0),!e&&i&&(o+="$0;"),e&&!e.semicolonPosition&&i&&this.offset>=this.textDocument.offsetAt(l.end)&&(o+="$0;");let h={label:a.name,documentation:Ce(a,this.doesSupportMarkdown()),tags:en(a)?[Te.Deprecated]:[],textEdit:_.replace(l,o),insertTextFormat:te.Snippet,kind:k.Property};a.restrictions||(d=!1),r&&d&&(h.command=Xs);let w=(255-(typeof a.relevance=="number"?Math.min(Math.max(a.relevance,0),99):50)).toString(16),b=V(a.name,"-")?Ee.VendorPrefixed:Ee.Normal;h.sortText=b+"_"+w,t.items.push(h)}),this.completionParticipants.forEach(a=>{a.onCssProperty&&a.onCssProperty({propertyName:this.currentWord,range:this.defaultReplaceRange})}),t}get isTriggerPropertyValueCompletionEnabled(){return this.documentSettings?.triggerPropertyValueCompletion??!0}get isCompletePropertyWithSemicolonEnabled(){return this.documentSettings?.completePropertyWithSemicolon??!0}getCompletionsForDeclarationValue(e,t){let r=e.getFullPropertyName(),i=this.cssDataManager.getProperty(r),s=e.getValue()||null;for(;s&&s.hasChildren();)s=s.findChildAtOffset(this.offset,!1);if(this.completionParticipants.forEach(a=>{a.onCssPropertyValue&&a.onCssPropertyValue({propertyName:r,propertyValue:this.currentWord,range:this.getCompletionRange(s)})}),i){if(i.restrictions)for(let a of i.restrictions)switch(a){case"color":this.getColorProposals(i,s,t);break;case"position":this.getPositionProposals(i,s,t);break;case"repeat":this.getRepeatStyleProposals(i,s,t);break;case"line-style":this.getLineStyleProposals(i,s,t);break;case"line-width":this.getLineWidthProposals(i,s,t);break;case"geometry-box":this.getGeometryBoxProposals(i,s,t);break;case"box":this.getBoxProposals(i,s,t);break;case"image":this.getImageProposals(i,s,t);break;case"timing-function":this.getTimingFunctionProposals(i,s,t);break;case"shape":this.getBasicShapeProposals(i,s,t);break}this.getValueEnumProposals(i,s,t),this.getCSSWideKeywordProposals(i,s,t),this.getUnitProposals(i,s,t)}else{let a=wa(this.styleSheet,e);for(let l of a.getEntries())t.items.push({label:l,textEdit:_.replace(this.getCompletionRange(s),l),kind:k.Value})}return this.getVariableProposals(s,t),this.getTermProposals(i,s,t),t}getValueEnumProposals(e,t,r){if(e.values)for(let i of e.values){let s=i.name,a;if(fn(s,")")){let d=s.lastIndexOf("(");d!==-1&&(s=s.substring(0,d+1)+"$1"+s.substring(d+1),a=Ne)}let l=Ee.Enums;V(i.name,"-")&&(l+=Ee.VendorPrefixed);let o={label:i.name,documentation:Ce(i,this.doesSupportMarkdown()),tags:en(e)?[Te.Deprecated]:[],textEdit:_.replace(this.getCompletionRange(t),s),sortText:l,kind:k.Value,insertTextFormat:a};r.items.push(o)}return r}getCSSWideKeywordProposals(e,t,r){for(let i in hi)r.items.push({label:i,documentation:hi[i],textEdit:_.replace(this.getCompletionRange(t),i),kind:k.Value});for(let i in pi){let s=Et(i);r.items.push({label:i,documentation:pi[i],textEdit:_.replace(this.getCompletionRange(t),s),kind:k.Function,insertTextFormat:Ne,command:V(i,"var")?Xs:void 0})}return r}getCompletionsForInterpolation(e,t){return this.offset>=e.offset+2&&this.getVariableProposals(null,t),t}getVariableProposals(e,t){let r=this.getSymbolContext().findSymbolsAtOffset(this.offset,z.Variable);for(let i of r){let s=V(i.name,"--")?`var(${i.name})`:i.name,a={label:i.name,documentation:i.value?zr(i.value):i.value,textEdit:_.replace(this.getCompletionRange(e),s),kind:k.Variable,sortText:Ee.Variable};if(typeof a.documentation=="string"&&ii(a.documentation)&&(a.kind=k.Color),i.node.type===m.FunctionParameter){let l=i.node.getParent();l.type===m.MixinDeclaration&&(a.detail=p("argument from '{0}'",l.getName()))}t.items.push(a)}return t}getVariableProposalsForCSSVarFunction(e){let t=new tn;this.styleSheet.acceptVisitor(new xi(t,this.offset));let r=this.getSymbolContext().findSymbolsAtOffset(this.offset,z.Variable);for(let i of r){if(V(i.name,"--")){let s={label:i.name,documentation:i.value?zr(i.value):i.value,textEdit:_.replace(this.getCompletionRange(null),i.name),kind:k.Variable};typeof s.documentation=="string"&&ii(s.documentation)&&(s.kind=k.Color),e.items.push(s)}t.remove(i.name)}for(let i of t.getEntries())if(V(i,"--")){let s={label:i,textEdit:_.replace(this.getCompletionRange(null),i),kind:k.Variable};e.items.push(s)}return e}getUnitProposals(e,t,r){let i="0";if(this.currentWord.length>0){let s=this.currentWord.match(/^-?\d[\.\d+]*/);s&&(i=s[0],r.isIncomplete=i.length===this.currentWord.length)}else this.currentWord.length===0&&(r.isIncomplete=!0);if(t&&t.parent&&t.parent.type===m.Term&&(t=t.getParent()),e.restrictions)for(let s of e.restrictions){let a=ir[s];if(a)for(let l of a){let o=i+l;r.items.push({label:o,textEdit:_.replace(this.getCompletionRange(t),o),kind:k.Unit})}}return r}getCompletionRange(e){if(e&&e.offset<=this.offset&&this.offset<=e.end){let t=e.end!==-1?this.textDocument.positionAt(e.end):this.position,r=this.textDocument.positionAt(e.offset);if(r.line===t.line)return R.create(r,t)}return this.defaultReplaceRange}getColorProposals(e,t,r){for(let s in Xt)r.items.push({label:s,documentation:Xt[s],textEdit:_.replace(this.getCompletionRange(t),s),kind:k.Color});for(let s in rr)r.items.push({label:s,documentation:rr[s],textEdit:_.replace(this.getCompletionRange(t),s),kind:k.Value});let i=new tn;this.styleSheet.acceptVisitor(new yi(i,this.offset));for(let s of i.getEntries())r.items.push({label:s,textEdit:_.replace(this.getCompletionRange(t),s),kind:k.Color});for(let s of Ws)r.items.push({label:s.label,detail:s.func,documentation:s.desc,textEdit:_.replace(this.getCompletionRange(t),s.insertText),insertTextFormat:Ne,kind:k.Function});return r}getPositionProposals(e,t,r){for(let i in oi)r.items.push({label:i,documentation:oi[i],textEdit:_.replace(this.getCompletionRange(t),i),kind:k.Value});return r}getRepeatStyleProposals(e,t,r){for(let i in ai)r.items.push({label:i,documentation:ai[i],textEdit:_.replace(this.getCompletionRange(t),i),kind:k.Value});return r}getLineStyleProposals(e,t,r){for(let i in li)r.items.push({label:i,documentation:li[i],textEdit:_.replace(this.getCompletionRange(t),i),kind:k.Value});return r}getLineWidthProposals(e,t,r){for(let i of js)r.items.push({label:i,textEdit:_.replace(this.getCompletionRange(t),i),kind:k.Value});return r}getGeometryBoxProposals(e,t,r){for(let i in di)r.items.push({label:i,documentation:di[i],textEdit:_.replace(this.getCompletionRange(t),i),kind:k.Value});return r}getBoxProposals(e,t,r){for(let i in ci)r.items.push({label:i,documentation:ci[i],textEdit:_.replace(this.getCompletionRange(t),i),kind:k.Value});return r}getImageProposals(e,t,r){for(let i in mi){let s=Et(i);r.items.push({label:i,documentation:mi[i],textEdit:_.replace(this.getCompletionRange(t),s),kind:k.Function,insertTextFormat:i!==s?Ne:void 0})}return r}getTimingFunctionProposals(e,t,r){for(let i in ui){let s=Et(i);r.items.push({label:i,documentation:ui[i],textEdit:_.replace(this.getCompletionRange(t),s),kind:k.Function,insertTextFormat:i!==s?Ne:void 0})}return r}getBasicShapeProposals(e,t,r){for(let i in fi){let s=Et(i);r.items.push({label:i,documentation:fi[i],textEdit:_.replace(this.getCompletionRange(t),s),kind:k.Function,insertTextFormat:i!==s?Ne:void 0})}return r}getCompletionsForStylesheet(e){let t=this.styleSheet.findFirstChildBeforeOffset(this.offset);return t?t instanceof ae?this.getCompletionsForRuleSet(t,e):t instanceof et?this.getCompletionsForSupports(t,e):e:this.getCompletionForTopLevel(e)}getCompletionForTopLevel(e){return this.cssDataManager.getAtDirectives().forEach(t=>{e.items.push({label:t.name,textEdit:_.replace(this.getCompletionRange(null),t.name),documentation:Ce(t,this.doesSupportMarkdown()),tags:en(t)?[Te.Deprecated]:[],kind:k.Keyword})}),this.getCompletionsForSelector(null,!1,e),e}getCompletionsForRuleSet(e,t){let r=e.getDeclarations();return r&&r.endsWith("}")&&this.offset>=r.end?this.getCompletionForTopLevel(t):!r||this.offset<=r.offset?this.getCompletionsForSelector(e,e.isNested(),t):this.getCompletionsForDeclarations(e.getDeclarations(),t)}getCompletionsForSelector(e,t,r){let i=this.findInNodePath(m.PseudoSelector,m.IdentifierSelector,m.ClassSelector,m.ElementNameSelector);if(!i&&this.hasCharacterAtPosition(this.offset-this.currentWord.length-1,":")&&(this.currentWord=":"+this.currentWord,this.hasCharacterAtPosition(this.offset-this.currentWord.length-1,":")&&(this.currentWord=":"+this.currentWord),this.defaultReplaceRange=R.create(H.create(this.position.line,this.position.character-this.currentWord.length),this.position)),this.cssDataManager.getPseudoClasses().forEach(d=>{let h=Et(d.name),u={label:d.name,textEdit:_.replace(this.getCompletionRange(i),h),documentation:Ce(d,this.doesSupportMarkdown()),tags:en(d)?[Te.Deprecated]:[],kind:k.Function,insertTextFormat:d.name!==h?Ne:void 0};V(d.name,":-")&&(u.sortText=Ee.VendorPrefixed),r.items.push(u)}),this.cssDataManager.getPseudoElements().forEach(d=>{let h=Et(d.name),u={label:d.name,textEdit:_.replace(this.getCompletionRange(i),h),documentation:Ce(d,this.doesSupportMarkdown()),tags:en(d)?[Te.Deprecated]:[],kind:k.Function,insertTextFormat:d.name!==h?Ne:void 0};V(d.name,"::-")&&(u.sortText=Ee.VendorPrefixed),r.items.push(u)}),!t){for(let d of Bs)r.items.push({label:d,textEdit:_.replace(this.getCompletionRange(i),d),kind:k.Keyword});for(let d of qs)r.items.push({label:d,textEdit:_.replace(this.getCompletionRange(i),d),kind:k.Keyword})}let l={};l[this.currentWord]=!0;let o=this.textDocument.getText();if(this.styleSheet.accept(d=>{if(d.type===m.SimpleSelector&&d.length>0){let h=o.substr(d.offset,d.length);return h.charAt(0)==="."&&!l[h]&&(l[h]=!0,r.items.push({label:h,textEdit:_.replace(this.getCompletionRange(i),h),kind:k.Keyword})),!1}return!0}),e&&e.isNested()){let d=e.getSelectors().findFirstChildBeforeOffset(this.offset);d&&e.getSelectors().getChildren().indexOf(d)===0&&this.getPropertyProposals(null,r)}return r}getCompletionsForDeclarations(e,t){if(!e||this.offset===e.offset)return t;let r=e.findFirstChildBeforeOffset(this.offset);if(!r)return this.getCompletionsForDeclarationProperty(null,t);if(r instanceof ht){let i=r;if(!ie(i.colonPosition)||this.offset<=i.colonPosition)return this.getCompletionsForDeclarationProperty(i,t);if(ie(i.semicolonPosition)&&i.semicolonPosition<this.offset)return this.offset===i.semicolonPosition+1?t:this.getCompletionsForDeclarationProperty(null,t);if(i instanceof Q)return this.getCompletionsForDeclarationValue(i,t)}else r instanceof Se?this.getCompletionsForExtendsReference(r,null,t):this.currentWord&&this.currentWord[0]==="@"?this.getCompletionsForDeclarationProperty(null,t):r instanceof ae&&this.getCompletionsForDeclarationProperty(null,t);return t}getCompletionsForVariableDeclaration(e,t){return this.offset&&ie(e.colonPosition)&&this.offset>e.colonPosition&&this.getVariableProposals(e.getValue()||null,t),t}getCompletionsForExpression(e,t){let r=e.getParent();if(r instanceof le)return this.getCompletionsForFunctionArgument(r,r.getParent(),t),t;let i=e.findParent(m.Declaration);if(!i)return this.getTermProposals(void 0,null,t),t;let s=e.findChildAtOffset(this.offset,!0);return s?s instanceof nt||s instanceof G?this.getCompletionsForDeclarationValue(i,t):t:this.getCompletionsForDeclarationValue(i,t)}getCompletionsForFunctionArgument(e,t,r){let i=t.getIdentifier();return i&&i.matches("var")&&(!t.getArguments().hasChildren()||t.getArguments().getChild(0)===e)&&this.getVariableProposalsForCSSVarFunction(r),r}getCompletionsForFunctionDeclaration(e,t){let r=e.getDeclarations();return r&&this.offset>r.offset&&this.offset<r.end&&this.getTermProposals(void 0,null,t),t}getCompletionsForMixinReference(e,t){let r=this.getSymbolContext().findSymbolsAtOffset(this.offset,z.Mixin);for(let s of r)s.node instanceof ue&&t.items.push(this.makeTermProposal(s,s.node.getParameters(),null));let i=e.getIdentifier()||null;return this.completionParticipants.forEach(s=>{s.onCssMixinReference&&s.onCssMixinReference({mixinName:this.currentWord,range:this.getCompletionRange(i)})}),t}getTermProposals(e,t,r){let i=this.getSymbolContext().findSymbolsAtOffset(this.offset,z.Function);for(let s of i)s.node instanceof De&&r.items.push(this.makeTermProposal(s,s.node.getParameters(),t));return r}makeTermProposal(e,t,r){let i=e.node,s=t.getChildren().map(l=>l instanceof ye?l.getName():l.getText()),a=e.name+"("+s.map((l,o)=>"${"+(o+1)+":"+l+"}").join(", ")+")";return{label:e.name,detail:e.name+"("+s.join(", ")+")",textEdit:_.replace(this.getCompletionRange(r),a),insertTextFormat:Ne,kind:k.Function,sortText:Ee.Term}}getCompletionsForSupportsCondition(e,t){let r=e.findFirstChildBeforeOffset(this.offset);if(r){if(r instanceof Q)return!ie(r.colonPosition)||this.offset<=r.colonPosition?this.getCompletionsForDeclarationProperty(r,t):this.getCompletionsForDeclarationValue(r,t);if(r instanceof Re)return this.getCompletionsForSupportsCondition(r,t)}return ie(e.lParent)&&this.offset>e.lParent&&(!ie(e.rParent)||this.offset<=e.rParent)?this.getCompletionsForDeclarationProperty(null,t):t}getCompletionsForSupports(e,t){let r=e.getDeclarations();if(!r||this.offset<=r.offset){let s=e.findFirstChildBeforeOffset(this.offset);return s instanceof Re?this.getCompletionsForSupportsCondition(s,t):t}return this.getCompletionForTopLevel(t)}getCompletionsForExtendsReference(e,t,r){return r}getCompletionForUriLiteralValue(e,t){let r,i,s;if(e.hasChildren()){let a=e.getChild(0);r=a.getText(),i=this.position,s=this.getCompletionRange(a)}else{r="",i=this.position;let a=this.textDocument.positionAt(e.offset+4);s=R.create(a,a)}return this.completionParticipants.forEach(a=>{a.onCssURILiteralValue&&a.onCssURILiteralValue({uriValue:r,position:i,range:s})}),t}getCompletionForImportPath(e,t){return this.completionParticipants.forEach(r=>{r.onCssImportPath&&r.onCssImportPath({pathValue:e.getText(),position:this.position,range:this.getCompletionRange(e)})}),t}hasCharacterAtPosition(e,t){let r=this.textDocument.getText();return e>=0&&e<r.length&&r.charAt(e)===t}doesSupportMarkdown(){if(!ie(this.supportsMarkdown)){if(!ie(this.lsOptions.clientCapabilities))return this.supportsMarkdown=!0,this.supportsMarkdown;let e=this.lsOptions.clientCapabilities.textDocument?.completion?.completionItem?.documentationFormat;this.supportsMarkdown=Array.isArray(e)&&e.indexOf(se.Markdown)!==-1}return this.supportsMarkdown}};function en(n){return!!(n.status&&(n.status==="nonstandard"||n.status==="obsolete"))}var tn=class{constructor(){this.entries={}}add(e){this.entries[e]=!0}remove(e){delete this.entries[e]}getEntries(){return Object.keys(this.entries)}};function Et(n){return n.replace(/\(\)$/,"($1)")}function wa(n,e){let t=e.getFullPropertyName(),r=new tn;function i(l){return(l instanceof G||l instanceof nt||l instanceof tt)&&r.add(l.getText()),!0}function s(l){let o=l.getFullPropertyName();return t===o}function a(l){if(l instanceof Q&&l!==e&&s(l)){let o=l.getValue();o&&o.accept(i)}return!0}return n.accept(a),r}var yi=class{constructor(e,t){this.entries=e,this.currentOffset=t}visitNode(e){return(e instanceof tt||e instanceof me&&Ls(e))&&(this.currentOffset<e.offset||e.end<this.currentOffset)&&this.entries.add(e.getText()),!0}},xi=class{constructor(e,t){this.entries=e,this.currentOffset=t}visitNode(e){return e instanceof G&&e.isCustomProperty&&(this.currentOffset<e.offset||e.end<this.currentOffset)&&this.entries.add(e.getText()),!0}};function va(n,e){let t=e-1,r=n.getText();for(;t>=0&&` 	
\r":{[()]},*>+`.indexOf(r.charAt(t))===-1;)t--;return r.substring(t+1,e)}var rn=class n{constructor(){this.parent=null,this.children=null,this.attributes=null}findAttribute(e){if(this.attributes){for(let t of this.attributes)if(t.name===e)return t.value}return null}addChild(e){e instanceof n&&(e.parent=this),this.children||(this.children=[]),this.children.push(e)}append(e){if(this.attributes){let t=this.attributes[this.attributes.length-1];t.value=t.value+e}}prepend(e){if(this.attributes){let t=this.attributes[0];t.value=e+t.value}}findRoot(){let e=this;for(;e.parent&&!(e.parent instanceof Ye);)e=e.parent;return e}removeChild(e){if(this.children){let t=this.children.indexOf(e);if(t!==-1)return this.children.splice(t,1),!0}return!1}addAttr(e,t){this.attributes||(this.attributes=[]);for(let r of this.attributes)if(r.name===e){r.value+=" "+t;return}this.attributes.push({name:e,value:t})}clone(e=!0){let t=new n;if(this.attributes){t.attributes=[];for(let r of this.attributes)t.addAttr(r.name,r.value)}if(e&&this.children){t.children=[];for(let r=0;r<this.children.length;r++)t.addChild(this.children[r].clone())}return t}cloneWithParent(){let e=this.clone(!1);return this.parent&&!(this.parent instanceof Ye)&&this.parent.cloneWithParent().addChild(e),e}},Ye=class extends rn{},sn=class extends rn{constructor(e){super(),this.addAttr("name",e)}},hr=class{constructor(e){this.quote=e,this.result=[]}print(e,t){this.result=[],e instanceof Ye?e.children&&this.doPrint(e.children,0):this.doPrint([e],0);let r;return t?r=`${t.text}
 \u2026 `+this.result.join(`
`):r=this.result.join(`
`),[{language:"html",value:r}]}doPrint(e,t){for(let r of e)this.doPrintElement(r,t),r.children&&this.doPrint(r.children,t+1)}writeLine(e,t){let r=new Array(e+1).join("  ");this.result.push(r+t)}doPrintElement(e,t){let r=e.findAttribute("name");if(e instanceof sn||r==="\u2026"){this.writeLine(t,r);return}let i=["<"];if(r?i.push(r):i.push("element"),e.attributes){for(let s of e.attributes)if(s.name!=="name"){i.push(" "),i.push(s.name);let a=s.value;a&&(i.push("="),i.push(Oe.ensure(a,this.quote)))}}i.push(">"),this.writeLine(t,i.join(""))}},Oe;(function(n){function e(r,i){return i+t(r)+i}n.ensure=e;function t(r){let i=r.match(/^['"](.*)["']$/);return i?i[1]:r}n.remove=t})(Oe||(Oe={}));var nn=class{constructor(){this.id=0,this.attr=0,this.tag=0}};function Ys(n,e){let t=new rn;for(let r of n.getChildren())switch(r.type){case m.SelectorCombinator:if(e){let l=r.getText().split("&");if(l.length===1){t.addAttr("name",l[0]);break}t=e.cloneWithParent(),l[0]&&t.findRoot().prepend(l[0]);for(let o=1;o<l.length;o++){if(o>1){let d=e.cloneWithParent();t.addChild(d.findRoot()),t=d}t.append(l[o])}}break;case m.SelectorPlaceholder:if(r.matches("@at-root"))return t;case m.ElementNameSelector:let i=r.getText();t.addAttr("name",i==="*"?"element":pe(i));break;case m.ClassSelector:t.addAttr("class",pe(r.getText().substring(1)));break;case m.IdentifierSelector:t.addAttr("id",pe(r.getText().substring(1)));break;case m.MixinDeclaration:t.addAttr("class",r.getName());break;case m.PseudoSelector:t.addAttr(pe(r.getText()),"");break;case m.AttributeSelector:let s=r,a=s.getIdentifier();if(a){let l=s.getValue(),o=s.getOperator(),d;if(l&&o)switch(pe(o.getText())){case"|=":d=`${Oe.remove(pe(l.getText()))}-\u2026`;break;case"^=":d=`${Oe.remove(pe(l.getText()))}\u2026`;break;case"$=":d=`\u2026${Oe.remove(pe(l.getText()))}`;break;case"~=":d=` \u2026 ${Oe.remove(pe(l.getText()))} \u2026 `;break;case"*=":d=`\u2026${Oe.remove(pe(l.getText()))}\u2026`;break;default:d=Oe.remove(pe(l.getText()));break}t.addAttr(pe(a.getText()),d)}break}return t}function pe(n){let e=new ce;e.setSource(n);let t=e.scanUnquotedString();return t?t.text:n}var pr=class{constructor(e){this.cssDataManager=e}selectorToMarkedString(e,t){let r=xa(e);if(r){let i=new hr('"').print(r,t);return i.push(this.selectorToSpecificityMarkedString(e)),i}else return[]}simpleSelectorToMarkedString(e){let t=Ys(e),r=new hr('"').print(t);return r.push(this.selectorToSpecificityMarkedString(e)),r}isPseudoElementIdentifier(e){let t=e.match(/^::?([\w-]+)/);return t?!!this.cssDataManager.getPseudoElement("::"+t[1]):!1}selectorToSpecificityMarkedString(e){let t=s=>{let a=new nn,l=new nn;for(let o of s)for(let d of o.getChildren()){let h=r(d);if(h.id>l.id){l=h;continue}else if(h.id<l.id)continue;if(h.attr>l.attr){l=h;continue}else if(h.attr<l.attr)continue;if(h.tag>l.tag){l=h;continue}}return a.id+=l.id,a.attr+=l.attr,a.tag+=l.tag,a},r=s=>{let a=new nn;e:for(let l of s.getChildren()){switch(l.type){case m.IdentifierSelector:a.id++;break;case m.ClassSelector:case m.AttributeSelector:a.attr++;break;case m.ElementNameSelector:if(l.matches("*"))break;a.tag++;break;case m.PseudoSelector:let o=l.getText(),d=l.getChildren();if(this.isPseudoElementIdentifier(o)){if(o.match(/^::slotted/i)&&d.length>0){a.tag++;let h=t(d);a.id+=h.id,a.attr+=h.attr,a.tag+=h.tag;continue e}a.tag++;continue e}if(o.match(/^:where/i))continue e;if(o.match(/^:(?:not|has|is)/i)&&d.length>0){let h=t(d);a.id+=h.id,a.attr+=h.attr,a.tag+=h.tag;continue e}if(o.match(/^:(?:host|host-context)/i)&&d.length>0){a.attr++;let h=t(d);a.id+=h.id,a.attr+=h.attr,a.tag+=h.tag;continue e}if(o.match(/^:(?:nth-child|nth-last-child)/i)&&d.length>0){if(a.attr++,d.length===3&&d[1].type===23){let y=t(d[2].getChildren());a.id+=y.id,a.attr+=y.attr,a.tag+=y.tag;continue e}let h=new ke,u=d[1].getText();h.scanner.setSource(u);let w=h.scanner.scan(),b=h.scanner.scan();if(w.text==="n"||w.text==="-n"&&b.text==="of"){let y=[],A=u.slice(b.offset+2).split(",");for(let P of A){let T=h.internalParse(P,h._parseSelector);T&&y.push(T)}let I=t(y);a.id+=I.id,a.attr+=I.attr,a.tag+=I.tag;continue e}continue e}a.attr++;continue e}if(l.getChildren().length>0){let o=r(l);a.id+=o.id,a.attr+=o.attr,a.tag+=o.tag}}return a},i=r(e);return`[${p("Selector Specificity")}](https://developer.mozilla.org/docs/Web/CSS/Specificity): (${i.id}, ${i.attr}, ${i.tag})`}},Si=class{constructor(e){this.prev=null,this.element=e}processSelector(e){let t=null;if(!(this.element instanceof Ye)&&e.getChildren().some(r=>r.hasChildren()&&r.getChild(0).type===m.SelectorCombinator)){let r=this.element.findRoot();r.parent instanceof Ye&&(t=this.element,this.element=r.parent,this.element.removeChild(r),this.prev=null)}for(let r of e.getChildren()){if(r instanceof he){if(this.prev instanceof he){let a=new sn("\u2026");this.element.addChild(a),this.element=a}else this.prev&&(this.prev.matches("+")||this.prev.matches("~"))&&this.element.parent&&(this.element=this.element.parent);this.prev&&this.prev.matches("~")&&this.element.addChild(new sn("\u22EE"));let i=Ys(r,t),s=i.findRoot();this.element.addChild(s),this.element=i}(r instanceof he||r.type===m.SelectorCombinatorParent||r.type===m.SelectorCombinatorShadowPiercingDescendant||r.type===m.SelectorCombinatorSibling||r.type===m.SelectorCombinatorAllSiblings)&&(this.prev=r)}}};function ya(n){switch(n.type){case m.MixinDeclaration:case m.Stylesheet:return!0}return!1}function xa(n){if(n.matches("@at-root"))return null;let e=new Ye,t=[],r=n.getParent();if(r instanceof ae){let s=r.getParent();for(;s&&!ya(s);){if(s instanceof ae){if(s.getSelectors().matches("@at-root"))break;t.push(s)}s=s.getParent()}}let i=new Si(e);for(let s=t.length-1;s>=0;s--){let a=t[s].getSelectors().getChild(0);a&&i.processSelector(a)}return i.processSelector(n),e}var _t=class{constructor(e,t){this.clientCapabilities=e,this.cssDataManager=t,this.selectorPrinting=new pr(t)}configure(e){this.defaultSettings=e}doHover(e,t,r,i=this.defaultSettings){function s(h){return R.create(e.positionAt(h.offset),e.positionAt(h.end))}let a=e.offsetAt(t),l=vt(r,a),o=null,d;for(let h=0;h<l.length;h++){let u=l[h];if(u instanceof Be){let w=/@media[^\{]+/g;d={isMedia:!0,text:u.getText().match(w)?.[0]}}if(u instanceof de){o={contents:this.selectorPrinting.selectorToMarkedString(u,d),range:s(u)};break}if(u instanceof he){V(u.getText(),"@")||(o={contents:this.selectorPrinting.simpleSelectorToMarkedString(u),range:s(u)});break}if(u instanceof Q){let w=u.getFullPropertyName(),b=this.cssDataManager.getProperty(w);if(b){let y=Ce(b,this.doesSupportMarkdown(),i);y?o={contents:y,range:s(u)}:o=null}continue}if(u instanceof bt){let w=u.getText(),b=this.cssDataManager.getAtDirective(w);if(b){let y=Ce(b,this.doesSupportMarkdown(),i);y?o={contents:y,range:s(u)}:o=null}continue}if(u instanceof x&&u.type===m.PseudoSelector){let w=u.getText(),b=w.slice(0,2)==="::"?this.cssDataManager.getPseudoElement(w):this.cssDataManager.getPseudoClass(w);if(b){let y=Ce(b,this.doesSupportMarkdown(),i);y?o={contents:y,range:s(u)}:o=null}continue}}return o&&(o.contents=this.convertContents(o.contents)),o}convertContents(e){return this.doesSupportMarkdown()||typeof e=="string"?e:"kind"in e?{kind:"plaintext",value:e.value}:Array.isArray(e)?e.map(t=>typeof t=="string"?t:t.value):e.value}doesSupportMarkdown(){if(!ie(this.supportsMarkdown)){if(!ie(this.clientCapabilities))return this.supportsMarkdown=!0,this.supportsMarkdown;let e=this.clientCapabilities.textDocument&&this.clientCapabilities.textDocument.hover;this.supportsMarkdown=e&&e.contentFormat&&Array.isArray(e.contentFormat)&&e.contentFormat.indexOf(se.Markdown)!==-1}return this.supportsMarkdown}};var Qs=/^\w+:\/\//,Zs=/^data:/,lt=class{constructor(e,t){this.fileSystemProvider=e,this.resolveModuleReferences=t}configure(e){this.defaultSettings=e}findDefinition(e,t,r){let i=new ot(r),s=e.offsetAt(t),a=Hn(r,s);if(!a)return null;let l=i.findSymbolFromNode(a);return l?{uri:e.uri,range:Pe(l.node,e)}:null}findReferences(e,t,r){return this.findDocumentHighlights(e,t,r).map(s=>({uri:e.uri,range:s.range}))}getHighlightNode(e,t,r){let i=e.offsetAt(t),s=Hn(r,i);if(!(!s||s.type===m.Stylesheet||s.type===m.Declarations))return s.type===m.Identifier&&s.parent&&s.parent.type===m.ClassSelector&&(s=s.parent),s}findDocumentHighlights(e,t,r){let i=[],s=this.getHighlightNode(e,t,r);if(!s)return i;let a=new ot(r),l=a.findSymbolFromNode(s),o=s.getText();return r.accept(d=>{if(l){if(a.matchesSymbol(d,l))return i.push({kind:to(d),range:Pe(d,e)}),!1}else s&&s.type===d.type&&d.matches(o)&&i.push({kind:to(d),range:Pe(d,e)});return!0}),i}isRawStringDocumentLinkNode(e){return e.type===m.Import}findDocumentLinks(e,t,r){let i=this.findUnresolvedLinks(e,t),s=[];for(let a of i){let l=a.link,o=l.target;if(!(!o||Zs.test(o)))if(Qs.test(o))s.push(l);else{let d=r.resolveReference(o,e.uri);d&&(l.target=d),s.push(l)}}return s}async findDocumentLinks2(e,t,r){let i=this.findUnresolvedLinks(e,t),s=[];for(let a of i){let l=a.link,o=l.target;if(!(!o||Zs.test(o)))if(Qs.test(o))s.push(l);else{let d=await this.resolveReference(o,e.uri,r,a.isRawLink);d!==void 0&&(l.target=d,s.push(l))}}return s}findUnresolvedLinks(e,t){let r=[],i=s=>{let a=s.getText(),l=Pe(s,e);if(l.start.line===l.end.line&&l.start.character===l.end.character)return;(V(a,"'")||V(a,'"'))&&(a=a.slice(1,-1));let o=s.parent?this.isRawStringDocumentLinkNode(s.parent):!1;r.push({link:{target:a,range:l},isRawLink:o})};return t.accept(s=>{if(s.type===m.URILiteral){let a=s.getChild(0);return a&&i(a),!1}if(s.parent&&this.isRawStringDocumentLinkNode(s.parent)){let a=s.getText();return(V(a,"'")||V(a,'"'))&&i(s),!1}return!0}),r}findSymbolInformations(e,t){let r=[],i=(s,a,l)=>{let o=l instanceof x?Pe(l,e):l,d={name:s||p("<undefined>"),kind:a,location:it.create(e.uri,o)};r.push(d)};return this.collectDocumentSymbols(e,t,i),r}findDocumentSymbols(e,t){let r=[],i=[],s=(a,l,o,d,h)=>{let u=o instanceof x?Pe(o,e):o,w=d instanceof x?Pe(d,e):d;(!w||!eo(u,w))&&(w=R.create(u.start,u.start));let b={name:a||p("<undefined>"),kind:l,range:u,selectionRange:w},y=i.pop();for(;y&&!eo(y[1],u);)y=i.pop();if(y){let E=y[0];E.children||(E.children=[]),E.children.push(b),i.push(y)}else r.push(b);h&&i.push([b,Pe(h,e)])};return this.collectDocumentSymbols(e,t,s),r}collectDocumentSymbols(e,t,r){t.accept(i=>{if(i instanceof ae){for(let s of i.getSelectors().getChildren())if(s instanceof de){let a=R.create(e.positionAt(s.offset),e.positionAt(i.end));r(s.getText(),ge.Class,a,s,i.getDeclarations())}}else if(i instanceof xe)r(i.getName(),ge.Variable,i,i.getVariable(),void 0);else if(i instanceof ue)r(i.getName(),ge.Method,i,i.getIdentifier(),i.getDeclarations());else if(i instanceof De)r(i.getName(),ge.Function,i,i.getIdentifier(),i.getDeclarations());else if(i instanceof mt){let s=p("@keyframes {0}",i.getName());r(s,ge.Class,i,i.getIdentifier(),i.getDeclarations())}else if(i instanceof pt){let s=p("@font-face");r(s,ge.Class,i,void 0,i.getDeclarations())}else if(i instanceof Be){let s=i.getChild(0);if(s instanceof ut){let a="@media "+s.getText();r(a,ge.Module,i,s,i.getDeclarations())}}return!0})}findDocumentColors(e,t){let r=[];return t.accept(i=>{let s=Sa(i,e);return s&&r.push(s),!0}),r}getColorPresentations(e,t,r,i){let s=[],a=Math.round(r.red*255),l=Math.round(r.green*255),o=Math.round(r.blue*255),d;r.alpha===1?d=`rgb(${a}, ${l}, ${o})`:d=`rgba(${a}, ${l}, ${o}, ${r.alpha})`,s.push({label:d,textEdit:_.replace(i,d)}),r.alpha===1?d=`#${at(a)}${at(l)}${at(o)}`:d=`#${at(a)}${at(l)}${at(o)}${at(Math.round(r.alpha*255))}`,s.push({label:d,textEdit:_.replace(i,d)});let h=si(r);h.a===1?d=`hsl(${h.h}, ${Math.round(h.s*100)}%, ${Math.round(h.l*100)}%)`:d=`hsla(${h.h}, ${Math.round(h.s*100)}%, ${Math.round(h.l*100)}%, ${h.a})`,s.push({label:d,textEdit:_.replace(i,d)});let u=Us(r);return u.a===1?d=`hwb(${u.h} ${Math.round(u.w*100)}% ${Math.round(u.b*100)}%)`:d=`hwb(${u.h} ${Math.round(u.w*100)}% ${Math.round(u.b*100)}% / ${u.a})`,s.push({label:d,textEdit:_.replace(i,d)}),s}prepareRename(e,t,r){let i=this.getHighlightNode(e,t,r);if(i)return R.create(e.positionAt(i.offset),e.positionAt(i.end))}doRename(e,t,r,i){let a=this.findDocumentHighlights(e,t,i).map(l=>_.replace(l.range,r));return{changes:{[e.uri]:a}}}async resolveModuleReference(e,t,r){if(V(t,"file://")){let i=Ca(e);if(i&&i!=="."&&i!==".."){let s=r.resolveReference("/",t),a=ar(t),l=await this.resolvePathToModule(i,a,s);if(l){let o=e.substring(i.length+1);return Je(l,o)}}}}async mapReference(e,t){return e}async resolveReference(e,t,r,i=!1,s=this.defaultSettings){if(e[0]==="~"&&e[1]!=="/"&&this.fileSystemProvider)return e=e.substring(1),this.mapReference(await this.resolveModuleReference(e,t,r),i);let a=await this.mapReference(r.resolveReference(e,t),i);if(this.resolveModuleReferences){if(a&&await this.fileExists(a))return a;let l=await this.mapReference(await this.resolveModuleReference(e,t,r),i);if(l)return l}if(a&&!await this.fileExists(a)){let l=r.resolveReference("/",t);if(s&&l){if(e in s)return this.mapReference(Je(l,s[e]),i);let o=e.indexOf("/"),d=`${e.substring(0,o)}/`;if(d in s){let h=s[d].slice(0,-1),u=Je(l,h);return this.mapReference(u=Je(u,e.substring(d.length-1)),i)}}}return a}async resolvePathToModule(e,t,r){let i=Je(t,"node_modules",e,"package.json");if(await this.fileExists(i))return ar(i);if(r&&t.startsWith(r)&&t.length!==r.length)return this.resolvePathToModule(e,ar(t),r)}async fileExists(e){if(!this.fileSystemProvider)return!1;try{let t=await this.fileSystemProvider.stat(e);return!(t.type===st.Unknown&&t.size===-1)}catch{return!1}}};function Sa(n,e){let t=Vs(n);if(t){let r=Pe(n,e);return{color:t,range:r}}return null}function Pe(n,e){return R.create(e.positionAt(n.offset),e.positionAt(n.end))}function eo(n,e){let t=e.start.line,r=e.end.line,i=n.start.line,s=n.end.line;return!(t<i||r<i||t>s||r>s||t===i&&e.start.character<n.start.character||r===s&&e.end.character>n.end.character)}function to(n){if(n.type===m.Selector)return Ge.Write;if(n instanceof G&&n.parent&&n.parent instanceof Ve&&n.isCustomProperty)return Ge.Write;if(n.parent)switch(n.parent.type){case m.FunctionDeclaration:case m.MixinDeclaration:case m.Keyframe:case m.VariableDeclaration:case m.FunctionParameter:return Ge.Write}return Ge.Read}function at(n){let e=n.toString(16);return e.length!==2?"0"+e:e}function Ca(n){let e=n.indexOf("/");if(e===-1)return"";if(n[0]==="@"){let t=n.indexOf("/",e+1);return t===-1?n:n.substring(0,t)}return n.substring(0,e)}var It=ee.Warning,no=ee.Error,be=ee.Ignore,q=class{constructor(e,t,r){this.id=e,this.message=t,this.defaultValue=r}},Ci=class{constructor(e,t,r){this.id=e,this.message=t,this.defaultValue=r}},W={AllVendorPrefixes:new q("compatibleVendorPrefixes",p("When using a vendor-specific prefix make sure to also include all other vendor-specific properties"),be),IncludeStandardPropertyWhenUsingVendorPrefix:new q("vendorPrefix",p("When using a vendor-specific prefix also include the standard property"),It),DuplicateDeclarations:new q("duplicateProperties",p("Do not use duplicate style definitions"),be),EmptyRuleSet:new q("emptyRules",p("Do not use empty rulesets"),It),ImportStatemement:new q("importStatement",p("Import statements do not load in parallel"),be),BewareOfBoxModelSize:new q("boxModel",p("Do not use width or height when using padding or border"),be),UniversalSelector:new q("universalSelector",p("The universal selector (*) is known to be slow"),be),ZeroWithUnit:new q("zeroUnits",p("No unit for zero needed"),be),RequiredPropertiesForFontFace:new q("fontFaceProperties",p("@font-face rule must define 'src' and 'font-family' properties"),It),HexColorLength:new q("hexColorLength",p("Hex colors must consist of three, four, six or eight hex numbers"),no),ArgsInColorFunction:new q("argumentsInColorFunction",p("Invalid number of parameters"),no),UnknownProperty:new q("unknownProperties",p("Unknown property."),It),UnknownAtRules:new q("unknownAtRules",p("Unknown at-rule."),It),IEStarHack:new q("ieHack",p("IE hacks are only necessary when supporting IE7 and older"),be),UnknownVendorSpecificProperty:new q("unknownVendorSpecificProperties",p("Unknown vendor specific property."),be),PropertyIgnoredDueToDisplay:new q("propertyIgnoredDueToDisplay",p("Property is ignored due to the display."),It),AvoidImportant:new q("important",p("Avoid using !important. It is an indication that the specificity of the entire CSS has gotten out of control and needs to be refactored."),be),AvoidFloat:new q("float",p("Avoid using 'float'. Floats lead to fragile CSS that is easy to break if one aspect of the layout changes."),be),AvoidIdSelector:new q("idSelector",p("Selectors should not contain IDs because these rules are too tightly coupled with the HTML."),be)},ro={ValidProperties:new Ci("validProperties",p("A list of properties that are not validated against the `unknownProperties` rule."),[])},mr=class{constructor(e={}){this.conf=e}getRule(e){if(this.conf.hasOwnProperty(e.id)){let t=ka(this.conf[e.id]);if(t)return t}return e.defaultValue}getSetting(e){return this.conf[e.id]}};function ka(n){switch(n){case"ignore":return ee.Ignore;case"warning":return ee.Warning;case"error":return ee.Error}return null}var Dt=class{constructor(e){this.cssDataManager=e}doCodeActions(e,t,r,i){return this.doCodeActions2(e,t,r,i).map(s=>{let a=s.edit&&s.edit.documentChanges&&s.edit.documentChanges[0];return Me.create(s.title,"_css.applyCodeAction",e.uri,e.version,a&&a.edits)})}doCodeActions2(e,t,r,i){let s=[];if(r.diagnostics)for(let a of r.diagnostics)this.appendFixesForMarker(e,i,a,s);return s}getFixesForUnknownProperty(e,t,r,i){let s=t.getName(),a=[];this.cssDataManager.getProperties().forEach(o=>{let d=Hi(s,o.name);d>=s.length/2&&a.push({property:o.name,score:d})}),a.sort((o,d)=>d.score-o.score||o.property.localeCompare(d.property));let l=3;for(let o of a){let d=o.property,h=p("Rename to '{0}'",d),u=_.replace(r.range,d),w=qt.create(e.uri,e.version),b={documentChanges:[St.create(w,[u])]},y=Ht.create(h,b,Gt.QuickFix);if(y.diagnostics=[r],i.push(y),--l<=0)return}}appendFixesForMarker(e,t,r,i){if(r.code!==W.UnknownProperty.id)return;let s=e.offsetAt(r.range.start),a=e.offsetAt(r.range.end),l=vt(t,s);for(let o=l.length-1;o>=0;o--){let d=l[o];if(d instanceof Q){let h=d.getProperty();if(h&&h.offset===s&&h.end===a){this.getFixesForUnknownProperty(e,h,r,i);return}}}}};var ur=class{constructor(e){this.fullPropertyName=e.getFullPropertyName().toLowerCase(),this.node=e}};function on(n,e,t,r){let i=n[e];i.value=t,t&&(gi(i.properties,r)||i.properties.push(r))}function Fa(n,e,t){on(n,"top",e,t),on(n,"right",e,t),on(n,"bottom",e,t),on(n,"left",e,t)}function ne(n,e,t,r){e==="top"||e==="right"||e==="bottom"||e==="left"?on(n,e,t,r):Fa(n,t,r)}function ki(n,e,t){switch(e.length){case 1:ne(n,void 0,e[0],t);break;case 2:ne(n,"top",e[0],t),ne(n,"bottom",e[0],t),ne(n,"right",e[1],t),ne(n,"left",e[1],t);break;case 3:ne(n,"top",e[0],t),ne(n,"right",e[1],t),ne(n,"left",e[1],t),ne(n,"bottom",e[2],t);break;case 4:ne(n,"top",e[0],t),ne(n,"right",e[1],t),ne(n,"bottom",e[2],t),ne(n,"left",e[3],t);break}}function Fi(n,e){for(let t of e)if(n.matches(t))return!0;return!1}function an(n,e=!0){return e&&Fi(n,["initial","unset"])?!1:parseFloat(n.getText())!==0}function io(n,e=!0){return n.map(t=>an(t,e))}function fr(n,e=!0){return!(Fi(n,["none","hidden"])||e&&Fi(n,["initial","unset"]))}function Ea(n,e=!0){return n.map(t=>fr(t,e))}function _a(n){let e=n.getChildren();if(e.length===1){let t=e[0];return an(t)&&fr(t)}for(let t of e){let r=t;if(!an(r,!1)||!fr(r,!1))return!1}return!0}function Ei(n){let e={top:{value:!1,properties:[]},right:{value:!1,properties:[]},bottom:{value:!1,properties:[]},left:{value:!1,properties:[]}};for(let t of n){let r=t.node.value;if(!(typeof r>"u"))switch(t.fullPropertyName){case"box-sizing":return{top:{value:!1,properties:[]},right:{value:!1,properties:[]},bottom:{value:!1,properties:[]},left:{value:!1,properties:[]}};case"width":e.width=t;break;case"height":e.height=t;break;default:let i=t.fullPropertyName.split("-");switch(i[0]){case"border":switch(i[1]){case void 0:case"top":case"right":case"bottom":case"left":switch(i[2]){case void 0:ne(e,i[1],_a(r),t);break;case"width":ne(e,i[1],an(r,!1),t);break;case"style":ne(e,i[1],fr(r,!0),t);break}break;case"width":ki(e,io(r.getChildren(),!1),t);break;case"style":ki(e,Ea(r.getChildren(),!0),t);break}break;case"padding":i.length===1?ki(e,io(r.getChildren(),!0),t):ne(e,i[1],an(r,!0),t);break}break}}return e}var gr=class{constructor(){this.data={}}add(e,t,r){let i=this.data[e];i||(i={nodes:[],names:[]},this.data[e]=i),i.names.push(t),r&&i.nodes.push(r)}},ln=class n{static entries(e,t,r,i,s){let a=new n(t,r,i);return e.acceptVisitor(a),a.completeValidations(),a.getEntries(s)}constructor(e,t,r){this.cssDataManager=r,this.warnings=[],this.settings=t,this.documentText=e.getText(),this.keyframes=new gr,this.validProperties={};let i=t.getSetting(ro.ValidProperties);Array.isArray(i)&&i.forEach(s=>{if(typeof s=="string"){let a=s.trim().toLowerCase();a.length&&(this.validProperties[a]=!0)}})}isValidPropertyDeclaration(e){let t=e.fullPropertyName;return this.validProperties[t]}fetch(e,t){let r=[];for(let i of e)i.fullPropertyName===t&&r.push(i);return r}fetchWithValue(e,t,r){let i=[];for(let s of e)if(s.fullPropertyName===t){let a=s.node.getValue();a&&this.findValueInExpression(a,r)&&i.push(s)}return i}findValueInExpression(e,t){let r=!1;return e.accept(i=>(i.type===m.Identifier&&i.matches(t)&&(r=!0),!r)),r}getEntries(e=ee.Warning|ee.Error){return this.warnings.filter(t=>(t.getLevel()&e)!==0)}addEntry(e,t,r){let i=new wt(e,t,this.settings.getRule(t),r);this.warnings.push(i)}getMissingNames(e,t){let r=e.slice(0);for(let s=0;s<t.length;s++){let a=r.indexOf(t[s]);a!==-1&&(r[a]=null)}let i=null;for(let s=0;s<r.length;s++){let a=r[s];a&&(i===null?i=p("'{0}'",a):i=p("{0}, '{1}'",i,a))}return i}visitNode(e){switch(e.type){case m.UnknownAtRule:return this.visitUnknownAtRule(e);case m.Keyframe:return this.visitKeyframe(e);case m.FontFace:return this.visitFontFace(e);case m.Ruleset:return this.visitRuleSet(e);case m.SimpleSelector:return this.visitSimpleSelector(e);case m.Function:return this.visitFunction(e);case m.NumericValue:return this.visitNumericValue(e);case m.Import:return this.visitImport(e);case m.HexColorValue:return this.visitHexColorValue(e);case m.Prio:return this.visitPrio(e);case m.IdentifierSelector:return this.visitIdentifierSelector(e)}return!0}completeValidations(){this.validateKeyframes()}visitUnknownAtRule(e){let t=e.getChild(0);return!t||this.cssDataManager.getAtDirective(t.getText())?!1:(this.addEntry(t,W.UnknownAtRules,`Unknown at rule ${t.getText()}`),!0)}visitKeyframe(e){let t=e.getKeyword();if(!t)return!1;let r=t.getText();return this.keyframes.add(e.getName(),r,r!=="@keyframes"?t:null),!0}validateKeyframes(){let e=["@-webkit-keyframes","@-moz-keyframes","@-o-keyframes"];for(let t in this.keyframes.data){let r=this.keyframes.data[t].names,i=r.indexOf("@keyframes")===-1;if(!i&&r.length===1)continue;let s=this.getMissingNames(e,r);if(s||i)for(let a of this.keyframes.data[t].nodes){if(i){let l=p("Always define standard rule '@keyframes' when defining keyframes.");this.addEntry(a,W.IncludeStandardPropertyWhenUsingVendorPrefix,l)}if(s){let l=p("Always include all vendor specific rules: Missing: {0}",s);this.addEntry(a,W.AllVendorPrefixes,l)}}}return!0}visitSimpleSelector(e){let t=this.documentText.charAt(e.offset);return e.length===1&&t==="*"&&this.addEntry(e,W.UniversalSelector),!0}visitIdentifierSelector(e){return this.addEntry(e,W.AvoidIdSelector),!0}visitImport(e){return this.addEntry(e,W.ImportStatemement),!0}visitRuleSet(e){let t=e.getDeclarations();if(!t)return!1;t.hasChildren()||this.addEntry(e.getSelectors(),W.EmptyRuleSet);let r=[];for(let o of t.getChildren())o instanceof Q&&r.push(new ur(o));let i=Ei(r);if(i.width){let o=[];if(i.right.value&&(o=Qt(o,i.right.properties)),i.left.value&&(o=Qt(o,i.left.properties)),o.length!==0){for(let d of o)this.addEntry(d.node,W.BewareOfBoxModelSize);this.addEntry(i.width.node,W.BewareOfBoxModelSize)}}if(i.height){let o=[];if(i.top.value&&(o=Qt(o,i.top.properties)),i.bottom.value&&(o=Qt(o,i.bottom.properties)),o.length!==0){for(let d of o)this.addEntry(d.node,W.BewareOfBoxModelSize);this.addEntry(i.height.node,W.BewareOfBoxModelSize)}}let s=this.fetchWithValue(r,"display","inline-block");if(s.length>0){let o=this.fetch(r,"float");for(let d=0;d<o.length;d++){let h=o[d].node,u=h.getValue();u&&!u.matches("none")&&this.addEntry(h,W.PropertyIgnoredDueToDisplay,p("inline-block is ignored due to the float. If 'float' has a value other than 'none', the box is floated and 'display' is treated as 'block'"))}}if(s=this.fetchWithValue(r,"display","block"),s.length>0){let o=this.fetch(r,"vertical-align");for(let d=0;d<o.length;d++)this.addEntry(o[d].node,W.PropertyIgnoredDueToDisplay,p("Property is ignored due to the display. With 'display: block', vertical-align should not be used."))}let a=this.fetch(r,"float");for(let o=0;o<a.length;o++){let d=a[o];this.isValidPropertyDeclaration(d)||this.addEntry(d.node,W.AvoidFloat)}for(let o=0;o<r.length;o++){let d=r[o];if(d.fullPropertyName!=="background"&&!this.validProperties[d.fullPropertyName]){let h=d.node.getValue();if(h&&this.documentText.charAt(h.offset)!=="-"){let u=this.fetch(r,d.fullPropertyName);if(u.length>1)for(let w=0;w<u.length;w++){let b=u[w].node.getValue();b&&this.documentText.charAt(b.offset)!=="-"&&u[w]!==d&&this.addEntry(d.node,W.DuplicateDeclarations)}}}}if(!e.getSelectors().matches(":export")){let o=new gr,d=!1;for(let h of r){let u=h.node;if(this.isCSSDeclaration(u)){let w=h.fullPropertyName,b=w.charAt(0);if(b==="-"){if(w.charAt(1)!=="-"){!this.cssDataManager.isKnownProperty(w)&&!this.validProperties[w]&&this.addEntry(u.getProperty(),W.UnknownVendorSpecificProperty);let y=u.getNonPrefixedPropertyName();o.add(y,w,u.getProperty())}}else{let y=w;(b==="*"||b==="_")&&(this.addEntry(u.getProperty(),W.IEStarHack),w=w.substr(1)),!this.cssDataManager.isKnownProperty(y)&&!this.cssDataManager.isKnownProperty(w)&&(this.validProperties[w]||this.addEntry(u.getProperty(),W.UnknownProperty,p("Unknown property: '{0}'",u.getFullPropertyName()))),o.add(w,w,null)}}else d=!0}if(!d)for(let h in o.data){let u=o.data[h],w=u.names,b=this.cssDataManager.isStandardProperty(h)&&w.indexOf(h)===-1;if(!b&&w.length===1)continue;let y=new Set(b?u.nodes:[]);if(b){let I=this.getContextualVendorSpecificPseudoElements(e);for(let P of u.nodes){let T=P.getName(),j=T.substring(0,T.length-h.length);I.some(X=>X.startsWith(j))&&y.delete(P)}}let E=[];for(let I=0,P=n.prefixes.length;I<P;I++){let T=n.prefixes[I];this.cssDataManager.isStandardProperty(T+h)&&E.push(T+h)}let A=this.getMissingNames(E,w);if(A||b)for(let I of u.nodes){if(b&&y.has(I)){let P=p("Also define the standard property '{0}' for compatibility",h);this.addEntry(I,W.IncludeStandardPropertyWhenUsingVendorPrefix,P)}if(A){let P=p("Always include all vendor specific properties: Missing: {0}",A);this.addEntry(I,W.AllVendorPrefixes,P)}}}}return!0}getContextualVendorSpecificPseudoElements(e){function t(s,a){for(let l of a.getChildren()){if(l.type===m.PseudoSelector){let o=l.getChildren()[0]?.getText();o&&s.add(o)}t(s,l)}}function r(s,a){if(a.type===m.Ruleset)for(let l of a.getSelectors().getChildren())t(s,l);return a.parent?r(s,a.parent):void 0}let i=new Set;return r(i,e),Array.from(i)}visitPrio(e){return this.addEntry(e,W.AvoidImportant),!0}visitNumericValue(e){let t=e.findParent(m.Function);if(t&&t.getName()==="calc")return!0;let r=e.findParent(m.Declaration);if(r&&r.getValue()){let s=e.getValue();if(!s.unit||ir.length.indexOf(s.unit.toLowerCase())===-1)return!0;parseFloat(s.value)===0&&s.unit&&!this.validProperties[r.getFullPropertyName()]&&this.addEntry(e,W.ZeroWithUnit)}return!0}visitFontFace(e){let t=e.getDeclarations();if(!t)return!1;let r=!1,i=!1,s=!1;for(let a of t.getChildren())if(this.isCSSDeclaration(a)){let l=a.getProperty().getName().toLowerCase();l==="src"&&(r=!0),l==="font-family"&&(i=!0)}else s=!0;return!s&&(!r||!i)&&this.addEntry(e,W.RequiredPropertiesForFontFace),!0}isCSSDeclaration(e){if(e instanceof Q){if(!e.getValue())return!1;let t=e.getProperty();if(!t)return!1;let r=t.getIdentifier();return!(!r||r.containsInterpolation())}return!1}visitHexColorValue(e){let t=e.length;return t!==9&&t!==7&&t!==5&&t!==4&&this.addEntry(e,W.HexColorLength),!1}visitFunction(e){let t=e.getName().toLowerCase(),r=-1,i=0;switch(t){case"rgb(":case"hsl(":r=3;break;case"rgba(":case"hsla(":r=4;break}return r!==-1&&(e.getArguments().accept(s=>s instanceof qe?(i+=1,!1):!0),i!==r&&this.addEntry(e,W.ArgsInColorFunction)),!0}};ln.prefixes=["-ms-","-moz-","-o-","-webkit-"];var Rt=class{constructor(e){this.cssDataManager=e}configure(e){this.settings=e}doValidation(e,t,r=this.settings){if(r&&r.validate===!1)return[];let i=[];i.push.apply(i,Gn.entries(t)),i.push.apply(i,ln.entries(t,e,new mr(r&&r.lint),this.cssDataManager));let s=[];for(let l in W)s.push(W[l].id);function a(l){let o=R.create(e.positionAt(l.getOffset()),e.positionAt(l.getOffset()+l.getLength())),d=e.languageId;return{code:l.getRule().id,source:d,message:l.getMessage(),severity:l.getLevel()===ee.Warning?yt.Warning:yt.Error,range:o}}return i.filter(l=>l.getLevel()!==ee.Ignore).map(a)}};var so=47,Ia=10,Da=13,Ra=12,za=36,Ma=35,Ta=123,cn=61,Na=33,Oa=60,Pa=62,_i=46;var Ae=c.CustomToken,br=Ae++,Mt=Ae++,pc=Ae++,Ii=Ae++,Di=Ae++,wr=Ae++,vr=Ae++,dn=Ae++,mc=Ae++,zt=class extends ce{scanNext(e){if(this.stream.advanceIfChar(za)){let t=["$"];if(this.ident(t))return this.finishToken(e,br,t.join(""));this.stream.goBackTo(e)}return this.stream.advanceIfChars([Ma,Ta])?this.finishToken(e,Mt):this.stream.advanceIfChars([cn,cn])?this.finishToken(e,Ii):this.stream.advanceIfChars([Na,cn])?this.finishToken(e,Di):this.stream.advanceIfChar(Oa)?this.stream.advanceIfChar(cn)?this.finishToken(e,vr):this.finishToken(e,c.Delim):this.stream.advanceIfChar(Pa)?this.stream.advanceIfChar(cn)?this.finishToken(e,wr):this.finishToken(e,c.Delim):this.stream.advanceIfChars([_i,_i,_i])?this.finishToken(e,dn):super.scanNext(e)}comment(){return super.comment()?!0:!this.inURL&&this.stream.advanceIfChars([so,so])?(this.stream.advanceWhileChar(e=>{switch(e){case Ia:case Da:case Ra:return!1;default:return!0}}),!0):!1}};var hn=class{constructor(e,t){this.id=e,this.message=t}},yr={FromExpected:new hn("scss-fromexpected",p("'from' expected")),ThroughOrToExpected:new hn("scss-throughexpected",p("'through' or 'to' expected")),InExpected:new hn("scss-fromexpected",p("'in' expected"))};var xr=class extends ke{constructor(){super(new zt)}_parseStylesheetStatement(e=!1){return this.peek(c.AtKeyword)?this._parseWarnAndDebug()||this._parseControlStatement()||this._parseMixinDeclaration()||this._parseMixinContent()||this._parseMixinReference()||this._parseFunctionDeclaration()||this._parseForward()||this._parseUse()||this._parseRuleset(e)||super._parseStylesheetAtStatement(e):this._parseRuleset(!0)||this._parseVariableDeclaration()}_parseImport(){if(!this.peekKeyword("@import"))return null;let e=this.create(je);if(this.consumeToken(),!e.addChild(this._parseURILiteral())&&!e.addChild(this._parseStringLiteral()))return this.finish(e,f.URIOrStringExpected);for(;this.accept(c.Comma);)if(!e.addChild(this._parseURILiteral())&&!e.addChild(this._parseStringLiteral()))return this.finish(e,f.URIOrStringExpected);return this._completeParseImport(e)}_parseVariableDeclaration(e=[]){if(!this.peek(br))return null;let t=this.create(xe);if(!t.setVariable(this._parseVariable()))return null;if(!this.accept(c.Colon))return this.finish(t,f.ColonExpected);if(this.prevToken&&(t.colonPosition=this.prevToken.offset),!t.setValue(this._parseExpr()))return this.finish(t,f.VariableValueExpected,[],e);for(;this.peek(c.Exclamation);)if(!t.addChild(this._tryParsePrio())){if(this.consumeToken(),!this.peekRegExp(c.Ident,/^(default|global)$/))return this.finish(t,f.UnknownKeyword);this.consumeToken()}return this.peek(c.SemiColon)&&(t.semicolonPosition=this.token.offset),this.finish(t)}_parseMediaCondition(){return this._parseInterpolation()||super._parseMediaCondition()}_parseMediaFeatureRangeOperator(){return this.accept(vr)||this.accept(wr)||super._parseMediaFeatureRangeOperator()}_parseMediaFeatureName(){return this._parseModuleMember()||this._parseFunction()||this._parseIdent()||this._parseVariable()}_parseKeyframeSelector(){return this._tryParseKeyframeSelector()||this._parseControlStatement(this._parseKeyframeSelector.bind(this))||this._parseWarnAndDebug()||this._parseMixinReference()||this._parseFunctionDeclaration()||this._parseVariableDeclaration()||this._parseMixinContent()}_parseVariable(){if(!this.peek(br))return null;let e=this.create(Ke);return this.consumeToken(),e}_parseModuleMember(){let e=this.mark(),t=this.create(jt);return t.setIdentifier(this._parseIdent([z.Module]))?this.hasWhitespace()||!this.acceptDelim(".")||this.hasWhitespace()?(this.restoreAtMark(e),null):t.addChild(this._parseVariable()||this._parseFunction())?t:this.finish(t,f.IdentifierOrVariableExpected):null}_parseIdent(e){if(!this.peek(c.Ident)&&!this.peek(Mt)&&!this.peekDelim("-"))return null;let t=this.create(G);t.referenceTypes=e,t.isCustomProperty=this.peekRegExp(c.Ident,/^--/);let r=!1,i=()=>{let s=this.mark();return this.acceptDelim("-")&&(this.hasWhitespace()||this.acceptDelim("-"),this.hasWhitespace())?(this.restoreAtMark(s),null):this._parseInterpolation()};for(;(this.accept(c.Ident)||t.addChild(i())||r&&this.acceptRegexp(/^[\w-]/))&&(r=!0,!this.hasWhitespace()););return r?this.finish(t):null}_parseTermExpression(){return this._parseModuleMember()||this._parseVariable()||this._parseNestingSelector()||super._parseTermExpression()}_parseInterpolation(){if(this.peek(Mt)){let e=this.create(rt);return this.consumeToken(),!e.addChild(this._parseExpr())&&!this._parseNestingSelector()?this.accept(c.CurlyR)?this.finish(e):this.finish(e,f.ExpressionExpected):this.accept(c.CurlyR)?this.finish(e):this.finish(e,f.RightCurlyExpected)}return null}_parseOperator(){if(this.peek(Ii)||this.peek(Di)||this.peek(wr)||this.peek(vr)||this.peekDelim(">")||this.peekDelim("<")||this.peekIdent("and")||this.peekIdent("or")||this.peekDelim("%")){let e=this.createNode(m.Operator);return this.consumeToken(),this.finish(e)}return super._parseOperator()}_parseUnaryOperator(){if(this.peekIdent("not")){let e=this.create(x);return this.consumeToken(),this.finish(e)}return super._parseUnaryOperator()}_parseRuleSetDeclaration(){return this.peek(c.AtKeyword)?this._parseKeyframe()||this._parseImport()||this._parseMedia(!0)||this._parseFontFace()||this._parseWarnAndDebug()||this._parseControlStatement()||this._parseFunctionDeclaration()||this._parseExtends()||this._parseMixinReference()||this._parseMixinContent()||this._parseMixinDeclaration()||this._parseRuleset(!0)||this._parseSupports(!0)||this._parseLayer()||this._parsePropertyAtRule()||this._parseContainer(!0)||this._parseRuleSetDeclarationAtStatement():this._parseVariableDeclaration()||this._tryParseRuleset(!0)||this._parseDeclaration()}_parseDeclaration(e){let t=this._tryParseCustomPropertyDeclaration(e);if(t)return t;let r=this.create(Q);if(!r.setProperty(this._parseProperty()))return null;if(!this.accept(c.Colon))return this.finish(r,f.ColonExpected,[c.Colon],e||[c.SemiColon]);this.prevToken&&(r.colonPosition=this.prevToken.offset);let i=!1;if(r.setValue(this._parseExpr())&&(i=!0,r.addChild(this._parsePrio())),this.peek(c.CurlyL))r.setNestedProperties(this._parseNestedProperties());else if(!i)return this.finish(r,f.PropertyValueExpected);return this.peek(c.SemiColon)&&(r.semicolonPosition=this.token.offset),this.finish(r)}_parseNestedProperties(){let e=this.create(Ut);return this._parseBody(e,this._parseDeclaration.bind(this))}_parseExtends(){if(this.peekKeyword("@extend")){let e=this.create(Se);if(this.consumeToken(),!e.getSelectors().addChild(this._parseSimpleSelector()))return this.finish(e,f.SelectorExpected);for(;this.accept(c.Comma);)e.getSelectors().addChild(this._parseSimpleSelector());return this.accept(c.Exclamation)&&!this.acceptIdent("optional")?this.finish(e,f.UnknownKeyword):this.finish(e)}return null}_parseSimpleSelectorBody(){return this._parseSelectorPlaceholder()||super._parseSimpleSelectorBody()}_parseNestingSelector(){if(this.peekDelim("&")){let e=this.createNode(m.SelectorCombinator);for(this.consumeToken();!this.hasWhitespace()&&(this.acceptDelim("-")||this.accept(c.Num)||this.accept(c.Dimension)||e.addChild(this._parseIdent())||this.acceptDelim("&")););return this.finish(e)}return null}_parseSelectorPlaceholder(){if(this.peekDelim("%")){let e=this.createNode(m.SelectorPlaceholder);return this.consumeToken(),this._parseIdent(),this.finish(e)}else if(this.peekKeyword("@at-root")){let e=this.createNode(m.SelectorPlaceholder);if(this.consumeToken(),this.accept(c.ParenthesisL)){if(!this.acceptIdent("with")&&!this.acceptIdent("without"))return this.finish(e,f.IdentifierExpected);if(!this.accept(c.Colon))return this.finish(e,f.ColonExpected);if(!e.addChild(this._parseIdent()))return this.finish(e,f.IdentifierExpected);if(!this.accept(c.ParenthesisR))return this.finish(e,f.RightParenthesisExpected,[c.CurlyR])}return this.finish(e)}return null}_parseElementName(){let e=this.mark(),t=super._parseElementName();return t&&!this.hasWhitespace()&&this.peek(c.ParenthesisL)?(this.restoreAtMark(e),null):t}_tryParsePseudoIdentifier(){return this._parseInterpolation()||super._tryParsePseudoIdentifier()}_parseWarnAndDebug(){if(!this.peekKeyword("@debug")&&!this.peekKeyword("@warn")&&!this.peekKeyword("@error"))return null;let e=this.createNode(m.Debug);return this.consumeToken(),e.addChild(this._parseExpr()),this.finish(e)}_parseControlStatement(e=this._parseRuleSetDeclaration.bind(this)){return this.peek(c.AtKeyword)?this._parseIfStatement(e)||this._parseForStatement(e)||this._parseEachStatement(e)||this._parseWhileStatement(e):null}_parseIfStatement(e){return this.peekKeyword("@if")?this._internalParseIfStatement(e):null}_internalParseIfStatement(e){let t=this.create(yn);if(this.consumeToken(),!t.setExpression(this._parseExpr(!0)))return this.finish(t,f.ExpressionExpected);if(this._parseBody(t,e),this.acceptKeyword("@else")){if(this.peekIdent("if"))t.setElseClause(this._internalParseIfStatement(e));else if(this.peek(c.CurlyL)){let r=this.create(kn);this._parseBody(r,e),t.setElseClause(r)}}return this.finish(t)}_parseForStatement(e){if(!this.peekKeyword("@for"))return null;let t=this.create(xn);return this.consumeToken(),t.setVariable(this._parseVariable())?this.acceptIdent("from")?t.addChild(this._parseBinaryExpr())?!this.acceptIdent("to")&&!this.acceptIdent("through")?this.finish(t,yr.ThroughOrToExpected,[c.CurlyR]):t.addChild(this._parseBinaryExpr())?this._parseBody(t,e):this.finish(t,f.ExpressionExpected,[c.CurlyR]):this.finish(t,f.ExpressionExpected,[c.CurlyR]):this.finish(t,yr.FromExpected,[c.CurlyR]):this.finish(t,f.VariableNameExpected,[c.CurlyR])}_parseEachStatement(e){if(!this.peekKeyword("@each"))return null;let t=this.create(Sn);this.consumeToken();let r=t.getVariables();if(!r.addChild(this._parseVariable()))return this.finish(t,f.VariableNameExpected,[c.CurlyR]);for(;this.accept(c.Comma);)if(!r.addChild(this._parseVariable()))return this.finish(t,f.VariableNameExpected,[c.CurlyR]);return this.finish(r),this.acceptIdent("in")?t.addChild(this._parseExpr())?this._parseBody(t,e):this.finish(t,f.ExpressionExpected,[c.CurlyR]):this.finish(t,yr.InExpected,[c.CurlyR])}_parseWhileStatement(e){if(!this.peekKeyword("@while"))return null;let t=this.create(Cn);return this.consumeToken(),t.addChild(this._parseBinaryExpr())?this._parseBody(t,e):this.finish(t,f.ExpressionExpected,[c.CurlyR])}_parseFunctionBodyDeclaration(){return this._parseVariableDeclaration()||this._parseReturnStatement()||this._parseWarnAndDebug()||this._parseControlStatement(this._parseFunctionBodyDeclaration.bind(this))}_parseFunctionDeclaration(){if(!this.peekKeyword("@function"))return null;let e=this.create(De);if(this.consumeToken(),!e.setIdentifier(this._parseIdent([z.Function])))return this.finish(e,f.IdentifierExpected,[c.CurlyR]);if(!this.accept(c.ParenthesisL))return this.finish(e,f.LeftParenthesisExpected,[c.CurlyR]);if(e.getParameters().addChild(this._parseParameterDeclaration())){for(;this.accept(c.Comma)&&!this.peek(c.ParenthesisR);)if(!e.getParameters().addChild(this._parseParameterDeclaration()))return this.finish(e,f.VariableNameExpected)}return this.accept(c.ParenthesisR)?this._parseBody(e,this._parseFunctionBodyDeclaration.bind(this)):this.finish(e,f.RightParenthesisExpected,[c.CurlyR])}_parseReturnStatement(){if(!this.peekKeyword("@return"))return null;let e=this.createNode(m.ReturnStatement);return this.consumeToken(),e.addChild(this._parseExpr())?this.finish(e):this.finish(e,f.ExpressionExpected)}_parseMixinDeclaration(){if(!this.peekKeyword("@mixin"))return null;let e=this.create(ue);if(this.consumeToken(),!e.setIdentifier(this._parseIdent([z.Mixin])))return this.finish(e,f.IdentifierExpected,[c.CurlyR]);if(this.accept(c.ParenthesisL)){if(e.getParameters().addChild(this._parseParameterDeclaration())){for(;this.accept(c.Comma)&&!this.peek(c.ParenthesisR);)if(!e.getParameters().addChild(this._parseParameterDeclaration()))return this.finish(e,f.VariableNameExpected)}if(!this.accept(c.ParenthesisR))return this.finish(e,f.RightParenthesisExpected,[c.CurlyR])}return this._parseBody(e,this._parseRuleSetDeclaration.bind(this))}_parseParameterDeclaration(){let e=this.create(ye);return e.setIdentifier(this._parseVariable())?(this.accept(dn),this.accept(c.Colon)&&!e.setDefaultValue(this._parseExpr(!0))?this.finish(e,f.VariableValueExpected,[],[c.Comma,c.ParenthesisR]):this.finish(e)):null}_parseMixinContent(){if(!this.peekKeyword("@content"))return null;let e=this.create(Vn);if(this.consumeToken(),this.accept(c.ParenthesisL)){if(e.getArguments().addChild(this._parseFunctionArgument())){for(;this.accept(c.Comma)&&!this.peek(c.ParenthesisR);)if(!e.getArguments().addChild(this._parseFunctionArgument()))return this.finish(e,f.ExpressionExpected)}if(!this.accept(c.ParenthesisR))return this.finish(e,f.RightParenthesisExpected)}return this.finish(e)}_parseMixinReference(){if(!this.peekKeyword("@include"))return null;let e=this.create(ze);this.consumeToken();let t=this._parseIdent([z.Mixin]);if(!e.setIdentifier(t))return this.finish(e,f.IdentifierExpected,[c.CurlyR]);if(!this.hasWhitespace()&&this.acceptDelim(".")&&!this.hasWhitespace()){let r=this._parseIdent([z.Mixin]);if(!r)return this.finish(e,f.IdentifierExpected,[c.CurlyR]);let i=this.create(jt);t.referenceTypes=[z.Module],i.setIdentifier(t),e.setIdentifier(r),e.addChild(i)}if(this.accept(c.ParenthesisL)){if(e.getArguments().addChild(this._parseFunctionArgument())){for(;this.accept(c.Comma)&&!this.peek(c.ParenthesisR);)if(!e.getArguments().addChild(this._parseFunctionArgument()))return this.finish(e,f.ExpressionExpected)}if(!this.accept(c.ParenthesisR))return this.finish(e,f.RightParenthesisExpected)}return(this.peekIdent("using")||this.peek(c.CurlyL))&&e.setContent(this._parseMixinContentDeclaration()),this.finish(e)}_parseMixinContentDeclaration(){let e=this.create(jn);if(this.acceptIdent("using")){if(!this.accept(c.ParenthesisL))return this.finish(e,f.LeftParenthesisExpected,[c.CurlyL]);if(e.getParameters().addChild(this._parseParameterDeclaration())){for(;this.accept(c.Comma)&&!this.peek(c.ParenthesisR);)if(!e.getParameters().addChild(this._parseParameterDeclaration()))return this.finish(e,f.VariableNameExpected)}if(!this.accept(c.ParenthesisR))return this.finish(e,f.RightParenthesisExpected,[c.CurlyL])}return this.peek(c.CurlyL)&&this._parseBody(e,this._parseMixinReferenceBodyStatement.bind(this)),this.finish(e)}_parseMixinReferenceBodyStatement(){return this._tryParseKeyframeSelector()||this._parseRuleSetDeclaration()}_parseFunctionArgument(){let e=this.create(le),t=this.mark(),r=this._parseVariable();if(r)if(this.accept(c.Colon))e.setIdentifier(r);else{if(this.accept(dn))return e.setValue(r),this.finish(e);this.restoreAtMark(t)}return e.setValue(this._parseExpr(!0))?(this.accept(dn),e.addChild(this._parsePrio()),this.finish(e)):e.setValue(this._tryParsePrio())?this.finish(e):null}_parseURLArgument(){let e=this.mark(),t=super._parseURLArgument();if(!t||!this.peek(c.ParenthesisR)){this.restoreAtMark(e);let r=this.create(x);return r.addChild(this._parseBinaryExpr()),this.finish(r)}return t}_parseOperation(){if(!this.peek(c.ParenthesisL))return null;let e=this.create(x);for(this.consumeToken();e.addChild(this._parseListElement());)this.accept(c.Comma);return this.accept(c.ParenthesisR)?this.finish(e):this.finish(e,f.RightParenthesisExpected)}_parseListElement(){let e=this.create(Bn),t=this._parseBinaryExpr();if(!t)return null;if(this.accept(c.Colon)){if(e.setKey(t),!e.setValue(this._parseBinaryExpr()))return this.finish(e,f.ExpressionExpected)}else e.setValue(t);return this.finish(e)}_parseUse(){if(!this.peekKeyword("@use"))return null;let e=this.create(En);if(this.consumeToken(),!e.addChild(this._parseStringLiteral()))return this.finish(e,f.StringLiteralExpected);if(!this.peek(c.SemiColon)&&!this.peek(c.EOF)){if(!this.peekRegExp(c.Ident,/as|with/))return this.finish(e,f.UnknownKeyword);if(this.acceptIdent("as")&&!e.setIdentifier(this._parseIdent([z.Module]))&&!this.acceptDelim("*"))return this.finish(e,f.IdentifierOrWildcardExpected);if(this.acceptIdent("with")){if(!this.accept(c.ParenthesisL))return this.finish(e,f.LeftParenthesisExpected,[c.ParenthesisR]);if(!e.getParameters().addChild(this._parseModuleConfigDeclaration()))return this.finish(e,f.VariableNameExpected);for(;this.accept(c.Comma)&&!this.peek(c.ParenthesisR);)if(!e.getParameters().addChild(this._parseModuleConfigDeclaration()))return this.finish(e,f.VariableNameExpected);if(!this.accept(c.ParenthesisR))return this.finish(e,f.RightParenthesisExpected)}}return!this.accept(c.SemiColon)&&!this.accept(c.EOF)?this.finish(e,f.SemiColonExpected):this.finish(e)}_parseModuleConfigDeclaration(){let e=this.create(_n);return e.setIdentifier(this._parseVariable())?!this.accept(c.Colon)||!e.setValue(this._parseExpr(!0))?this.finish(e,f.VariableValueExpected,[],[c.Comma,c.ParenthesisR]):this.accept(c.Exclamation)&&(this.hasWhitespace()||!this.acceptIdent("default"))?this.finish(e,f.UnknownKeyword):this.finish(e):null}_parseForward(){if(!this.peekKeyword("@forward"))return null;let e=this.create(In);if(this.consumeToken(),!e.addChild(this._parseStringLiteral()))return this.finish(e,f.StringLiteralExpected);if(this.acceptIdent("as")){let t=this._parseIdent([z.Forward]);if(!e.setIdentifier(t))return this.finish(e,f.IdentifierExpected);if(this.hasWhitespace()||!this.acceptDelim("*"))return this.finish(e,f.WildcardExpected)}if(this.acceptIdent("with")){if(!this.accept(c.ParenthesisL))return this.finish(e,f.LeftParenthesisExpected,[c.ParenthesisR]);if(!e.getParameters().addChild(this._parseModuleConfigDeclaration()))return this.finish(e,f.VariableNameExpected);for(;this.accept(c.Comma)&&!this.peek(c.ParenthesisR);)if(!e.getParameters().addChild(this._parseModuleConfigDeclaration()))return this.finish(e,f.VariableNameExpected);if(!this.accept(c.ParenthesisR))return this.finish(e,f.RightParenthesisExpected)}else if((this.peekIdent("hide")||this.peekIdent("show"))&&!e.addChild(this._parseForwardVisibility()))return this.finish(e,f.IdentifierOrVariableExpected);return!this.accept(c.SemiColon)&&!this.accept(c.EOF)?this.finish(e,f.SemiColonExpected):this.finish(e)}_parseForwardVisibility(){let e=this.create(Dn);for(e.setIdentifier(this._parseIdent());e.addChild(this._parseVariable()||this._parseIdent());)this.accept(c.Comma);return e.getChildren().length>1?e:null}_parseSupportsCondition(){return this._parseInterpolation()||super._parseSupportsCondition()}};var We=p("Sass documentation"),we=class n extends Xe{constructor(e,t){super("$",e,t),oo(n.scssModuleLoaders),oo(n.scssModuleBuiltIns)}isImportPathParent(e){return e===m.Forward||e===m.Use||super.isImportPathParent(e)}getCompletionForImportPath(e,t){let r=e.getParent().type;if(r===m.Forward||r===m.Use)for(let i of n.scssModuleBuiltIns){let s={label:i.label,documentation:i.documentation,textEdit:_.replace(this.getCompletionRange(e),`'${i.label}'`),kind:k.Module};t.items.push(s)}return super.getCompletionForImportPath(e,t)}createReplaceFunction(){let e=1;return(t,r)=>"\\"+r+": ${"+e+++":"+(n.variableDefaults[r]||"")+"}"}createFunctionProposals(e,t,r,i){for(let s of e){let a=s.func.replace(/\[?(\$\w+)\]?/g,this.createReplaceFunction()),o={label:s.func.substr(0,s.func.indexOf("(")),detail:s.func,documentation:s.desc,textEdit:_.replace(this.getCompletionRange(t),a),insertTextFormat:te.Snippet,kind:k.Function};r&&(o.sortText="z"),i.items.push(o)}return i}getCompletionsForSelector(e,t,r){return this.createFunctionProposals(n.selectorFuncs,null,!0,r),super.getCompletionsForSelector(e,t,r)}getTermProposals(e,t,r){let i=n.builtInFuncs;return e&&(i=i.filter(s=>!s.type||!e.restrictions||e.restrictions.indexOf(s.type)!==-1)),this.createFunctionProposals(i,t,!0,r),super.getTermProposals(e,t,r)}getColorProposals(e,t,r){return this.createFunctionProposals(n.colorProposals,t,!1,r),super.getColorProposals(e,t,r)}getCompletionsForDeclarationProperty(e,t){return this.getCompletionForAtDirectives(t),this.getCompletionsForSelector(null,!0,t),super.getCompletionsForDeclarationProperty(e,t)}getCompletionsForExtendsReference(e,t,r){let i=this.getSymbolContext().findSymbolsAtOffset(this.offset,z.Rule);for(let s of i){let a={label:s.name,textEdit:_.replace(this.getCompletionRange(t),s.name),kind:k.Function};r.items.push(a)}return r}getCompletionForAtDirectives(e){return e.items.push(...n.scssAtDirectives),e}getCompletionForTopLevel(e){return this.getCompletionForAtDirectives(e),this.getCompletionForModuleLoaders(e),super.getCompletionForTopLevel(e),e}getCompletionForModuleLoaders(e){return e.items.push(...n.scssModuleLoaders),e}};we.variableDefaults={$red:"1",$green:"2",$blue:"3",$alpha:"1.0",$color:"#000000",$weight:"0.5",$hue:"0",$saturation:"0%",$lightness:"0%",$degrees:"0",$amount:"0",$string:'""',$substring:'"s"',$number:"0",$limit:"1"};we.colorProposals=[{func:"red($color)",desc:p("Gets the red component of a color.")},{func:"green($color)",desc:p("Gets the green component of a color.")},{func:"blue($color)",desc:p("Gets the blue component of a color.")},{func:"mix($color, $color, [$weight])",desc:p("Mixes two colors together.")},{func:"hue($color)",desc:p("Gets the hue component of a color.")},{func:"saturation($color)",desc:p("Gets the saturation component of a color.")},{func:"lightness($color)",desc:p("Gets the lightness component of a color.")},{func:"adjust-hue($color, $degrees)",desc:p("Changes the hue of a color.")},{func:"lighten($color, $amount)",desc:p("Makes a color lighter.")},{func:"darken($color, $amount)",desc:p("Makes a color darker.")},{func:"saturate($color, $amount)",desc:p("Makes a color more saturated.")},{func:"desaturate($color, $amount)",desc:p("Makes a color less saturated.")},{func:"grayscale($color)",desc:p("Converts a color to grayscale.")},{func:"complement($color)",desc:p("Returns the complement of a color.")},{func:"invert($color)",desc:p("Returns the inverse of a color.")},{func:"alpha($color)",desc:p("Gets the opacity component of a color.")},{func:"opacity($color)",desc:"Gets the alpha component (opacity) of a color."},{func:"rgba($color, $alpha)",desc:p("Changes the alpha component for a color.")},{func:"opacify($color, $amount)",desc:p("Makes a color more opaque.")},{func:"fade-in($color, $amount)",desc:p("Makes a color more opaque.")},{func:"transparentize($color, $amount)",desc:p("Makes a color more transparent.")},{func:"fade-out($color, $amount)",desc:p("Makes a color more transparent.")},{func:"adjust-color($color, [$red], [$green], [$blue], [$hue], [$saturation], [$lightness], [$alpha])",desc:p("Increases or decreases one or more components of a color.")},{func:"scale-color($color, [$red], [$green], [$blue], [$saturation], [$lightness], [$alpha])",desc:p("Fluidly scales one or more properties of a color.")},{func:"change-color($color, [$red], [$green], [$blue], [$hue], [$saturation], [$lightness], [$alpha])",desc:p("Changes one or more properties of a color.")},{func:"ie-hex-str($color)",desc:p("Converts a color into the format understood by IE filters.")}];we.selectorFuncs=[{func:"selector-nest($selectors\u2026)",desc:p("Nests selector beneath one another like they would be nested in the stylesheet.")},{func:"selector-append($selectors\u2026)",desc:p("Appends selectors to one another without spaces in between.")},{func:"selector-extend($selector, $extendee, $extender)",desc:p("Extends $extendee with $extender within $selector.")},{func:"selector-replace($selector, $original, $replacement)",desc:p("Replaces $original with $replacement within $selector.")},{func:"selector-unify($selector1, $selector2)",desc:p("Unifies two selectors to produce a selector that matches elements matched by both.")},{func:"is-superselector($super, $sub)",desc:p("Returns whether $super matches all the elements $sub does, and possibly more.")},{func:"simple-selectors($selector)",desc:p("Returns the simple selectors that comprise a compound selector.")},{func:"selector-parse($selector)",desc:p("Parses a selector into the format returned by &.")}];we.builtInFuncs=[{func:"unquote($string)",desc:p("Removes quotes from a string.")},{func:"quote($string)",desc:p("Adds quotes to a string.")},{func:"str-length($string)",desc:p("Returns the number of characters in a string.")},{func:"str-insert($string, $insert, $index)",desc:p("Inserts $insert into $string at $index.")},{func:"str-index($string, $substring)",desc:p("Returns the index of the first occurance of $substring in $string.")},{func:"str-slice($string, $start-at, [$end-at])",desc:p("Extracts a substring from $string.")},{func:"to-upper-case($string)",desc:p("Converts a string to upper case.")},{func:"to-lower-case($string)",desc:p("Converts a string to lower case.")},{func:"percentage($number)",desc:p("Converts a unitless number to a percentage."),type:"percentage"},{func:"round($number)",desc:p("Rounds a number to the nearest whole number.")},{func:"ceil($number)",desc:p("Rounds a number up to the next whole number.")},{func:"floor($number)",desc:p("Rounds a number down to the previous whole number.")},{func:"abs($number)",desc:p("Returns the absolute value of a number.")},{func:"min($numbers)",desc:p("Finds the minimum of several numbers.")},{func:"max($numbers)",desc:p("Finds the maximum of several numbers.")},{func:"random([$limit])",desc:p("Returns a random number.")},{func:"length($list)",desc:p("Returns the length of a list.")},{func:"nth($list, $n)",desc:p("Returns a specific item in a list.")},{func:"set-nth($list, $n, $value)",desc:p("Replaces the nth item in a list.")},{func:"join($list1, $list2, [$separator])",desc:p("Joins together two lists into one.")},{func:"append($list1, $val, [$separator])",desc:p("Appends a single value onto the end of a list.")},{func:"zip($lists)",desc:p("Combines several lists into a single multidimensional list.")},{func:"index($list, $value)",desc:p("Returns the position of a value within a list.")},{func:"list-separator(#list)",desc:p("Returns the separator of a list.")},{func:"map-get($map, $key)",desc:p("Returns the value in a map associated with a given key.")},{func:"map-merge($map1, $map2)",desc:p("Merges two maps together into a new map.")},{func:"map-remove($map, $keys)",desc:p("Returns a new map with keys removed.")},{func:"map-keys($map)",desc:p("Returns a list of all keys in a map.")},{func:"map-values($map)",desc:p("Returns a list of all values in a map.")},{func:"map-has-key($map, $key)",desc:p("Returns whether a map has a value associated with a given key.")},{func:"keywords($args)",desc:p("Returns the keywords passed to a function that takes variable arguments.")},{func:"feature-exists($feature)",desc:p("Returns whether a feature exists in the current Sass runtime.")},{func:"variable-exists($name)",desc:p("Returns whether a variable with the given name exists in the current scope.")},{func:"global-variable-exists($name)",desc:p("Returns whether a variable with the given name exists in the global scope.")},{func:"function-exists($name)",desc:p("Returns whether a function with the given name exists.")},{func:"mixin-exists($name)",desc:p("Returns whether a mixin with the given name exists.")},{func:"inspect($value)",desc:p("Returns the string representation of a value as it would be represented in Sass.")},{func:"type-of($value)",desc:p("Returns the type of a value.")},{func:"unit($number)",desc:p("Returns the unit(s) associated with a number.")},{func:"unitless($number)",desc:p("Returns whether a number has units.")},{func:"comparable($number1, $number2)",desc:p("Returns whether two numbers can be added, subtracted, or compared.")},{func:"call($name, $args\u2026)",desc:p("Dynamically calls a Sass function.")}];we.scssAtDirectives=[{label:"@extend",documentation:p("Inherits the styles of another selector."),kind:k.Keyword},{label:"@at-root",documentation:p("Causes one or more rules to be emitted at the root of the document."),kind:k.Keyword},{label:"@debug",documentation:p("Prints the value of an expression to the standard error output stream. Useful for debugging complicated Sass files."),kind:k.Keyword},{label:"@warn",documentation:p("Prints the value of an expression to the standard error output stream. Useful for libraries that need to warn users of deprecations or recovering from minor mixin usage mistakes. Warnings can be turned off with the `--quiet` command-line option or the `:quiet` Sass option."),kind:k.Keyword},{label:"@error",documentation:p("Throws the value of an expression as a fatal error with stack trace. Useful for validating arguments to mixins and functions."),kind:k.Keyword},{label:"@if",documentation:p("Includes the body if the expression does not evaluate to `false` or `null`."),insertText:`@if \${1:expr} {
	$0
}`,insertTextFormat:te.Snippet,kind:k.Keyword},{label:"@for",documentation:p("For loop that repeatedly outputs a set of styles for each `$var` in the `from/through` or `from/to` clause."),insertText:"@for \\$${1:var} from ${2:start} ${3|to,through|} ${4:end} {\n	$0\n}",insertTextFormat:te.Snippet,kind:k.Keyword},{label:"@each",documentation:p("Each loop that sets `$var` to each item in the list or map, then outputs the styles it contains using that value of `$var`."),insertText:"@each \\$${1:var} in ${2:list} {\n	$0\n}",insertTextFormat:te.Snippet,kind:k.Keyword},{label:"@while",documentation:p("While loop that takes an expression and repeatedly outputs the nested styles until the statement evaluates to `false`."),insertText:`@while \${1:condition} {
	$0
}`,insertTextFormat:te.Snippet,kind:k.Keyword},{label:"@mixin",documentation:p("Defines styles that can be re-used throughout the stylesheet with `@include`."),insertText:`@mixin \${1:name} {
	$0
}`,insertTextFormat:te.Snippet,kind:k.Keyword},{label:"@include",documentation:p("Includes the styles defined by another mixin into the current rule."),kind:k.Keyword},{label:"@function",documentation:p("Defines complex operations that can be re-used throughout stylesheets."),kind:k.Keyword}];we.scssModuleLoaders=[{label:"@use",documentation:p("Loads mixins, functions, and variables from other Sass stylesheets as 'modules', and combines CSS from multiple stylesheets together."),references:[{name:We,url:"https://sass-lang.com/documentation/at-rules/use"}],insertText:"@use $0;",insertTextFormat:te.Snippet,kind:k.Keyword},{label:"@forward",documentation:p("Loads a Sass stylesheet and makes its mixins, functions, and variables available when this stylesheet is loaded with the @use rule."),references:[{name:We,url:"https://sass-lang.com/documentation/at-rules/forward"}],insertText:"@forward $0;",insertTextFormat:te.Snippet,kind:k.Keyword}];we.scssModuleBuiltIns=[{label:"sass:math",documentation:p("Provides functions that operate on numbers."),references:[{name:We,url:"https://sass-lang.com/documentation/modules/math"}]},{label:"sass:string",documentation:p("Makes it easy to combine, search, or split apart strings."),references:[{name:We,url:"https://sass-lang.com/documentation/modules/string"}]},{label:"sass:color",documentation:p("Generates new colors based on existing ones, making it easy to build color themes."),references:[{name:We,url:"https://sass-lang.com/documentation/modules/color"}]},{label:"sass:list",documentation:p("Lets you access and modify values in lists."),references:[{name:We,url:"https://sass-lang.com/documentation/modules/list"}]},{label:"sass:map",documentation:p("Makes it possible to look up the value associated with a key in a map, and much more."),references:[{name:We,url:"https://sass-lang.com/documentation/modules/map"}]},{label:"sass:selector",documentation:p("Provides access to Sass\u2019s powerful selector engine."),references:[{name:We,url:"https://sass-lang.com/documentation/modules/selector"}]},{label:"sass:meta",documentation:p("Exposes the details of Sass\u2019s inner workings."),references:[{name:We,url:"https://sass-lang.com/documentation/modules/meta"}]}];function oo(n){n.forEach(e=>{if(e.documentation&&e.references&&e.references.length>0){let t=typeof e.documentation=="string"?{kind:"markdown",value:e.documentation}:{kind:"markdown",value:e.documentation.value};t.value+=`

`,t.value+=e.references.map(r=>`[${r.name}](${r.url})`).join(" | "),e.documentation=t}})}var ao=47,Wa=10,La=13,$a=12,Ri=96,zi=46,Ua=c.CustomToken,Sr=Ua++,Tt=class extends ce{scanNext(e){let t=this.escapedJavaScript();return t!==null?this.finishToken(e,t):this.stream.advanceIfChars([zi,zi,zi])?this.finishToken(e,Sr):super.scanNext(e)}comment(){return super.comment()?!0:!this.inURL&&this.stream.advanceIfChars([ao,ao])?(this.stream.advanceWhileChar(e=>{switch(e){case Wa:case La:case $a:return!1;default:return!0}}),!0):!1}escapedJavaScript(){return this.stream.peekChar()===Ri?(this.stream.advance(1),this.stream.advanceWhileChar(t=>t!==Ri),this.stream.advanceIfChar(Ri)?c.EscapedJavaScript:c.BadEscapedJavaScript):null}};var Cr=class extends ke{constructor(){super(new Tt)}_parseStylesheetStatement(e=!1){return this.peek(c.AtKeyword)?this._parseVariableDeclaration()||this._parsePlugin()||super._parseStylesheetAtStatement(e):this._tryParseMixinDeclaration()||this._tryParseMixinReference()||this._parseFunction()||this._parseRuleset(!0)}_parseImport(){if(!this.peekKeyword("@import")&&!this.peekKeyword("@import-once"))return null;let e=this.create(je);if(this.consumeToken(),this.accept(c.ParenthesisL)){if(!this.accept(c.Ident))return this.finish(e,f.IdentifierExpected,[c.SemiColon]);do if(!this.accept(c.Comma))break;while(this.accept(c.Ident));if(!this.accept(c.ParenthesisR))return this.finish(e,f.RightParenthesisExpected,[c.SemiColon])}return!e.addChild(this._parseURILiteral())&&!e.addChild(this._parseStringLiteral())?this.finish(e,f.URIOrStringExpected,[c.SemiColon]):(!this.peek(c.SemiColon)&&!this.peek(c.EOF)&&e.setMedialist(this._parseMediaQueryList()),this._completeParseImport(e))}_parsePlugin(){if(!this.peekKeyword("@plugin"))return null;let e=this.createNode(m.Plugin);return this.consumeToken(),e.addChild(this._parseStringLiteral())?this.accept(c.SemiColon)?this.finish(e):this.finish(e,f.SemiColonExpected):this.finish(e,f.StringLiteralExpected)}_parseMediaQuery(){let e=super._parseMediaQuery();if(!e){let t=this.create(ft);return t.addChild(this._parseVariable())?this.finish(t):null}return e}_parseMediaDeclaration(e=!1){return this._tryParseRuleset(e)||this._tryToParseDeclaration()||this._tryParseMixinDeclaration()||this._tryParseMixinReference()||this._parseDetachedRuleSetMixin()||this._parseStylesheetStatement(e)}_parseMediaFeatureName(){return this._parseIdent()||this._parseVariable()}_parseVariableDeclaration(e=[]){let t=this.create(xe),r=this.mark();if(!t.setVariable(this._parseVariable(!0)))return null;if(this.accept(c.Colon)){if(this.prevToken&&(t.colonPosition=this.prevToken.offset),t.setValue(this._parseDetachedRuleSet()))t.needsSemicolon=!1;else if(!t.setValue(this._parseExpr()))return this.finish(t,f.VariableValueExpected,[],e);t.addChild(this._parsePrio())}else return this.restoreAtMark(r),null;return this.peek(c.SemiColon)&&(t.semicolonPosition=this.token.offset),this.finish(t)}_parseDetachedRuleSet(){let e=this.mark();if(this.peekDelim("#")||this.peekDelim("."))if(this.consumeToken(),!this.hasWhitespace()&&this.accept(c.ParenthesisL)){let r=this.create(ue);if(r.getParameters().addChild(this._parseMixinParameter()))for(;(this.accept(c.Comma)||this.accept(c.SemiColon))&&!this.peek(c.ParenthesisR);)r.getParameters().addChild(this._parseMixinParameter())||this.markError(r,f.IdentifierExpected,[],[c.ParenthesisR]);if(!this.accept(c.ParenthesisR))return this.restoreAtMark(e),null}else return this.restoreAtMark(e),null;if(!this.peek(c.CurlyL))return null;let t=this.create(L);return this._parseBody(t,this._parseDetachedRuleSetBody.bind(this)),this.finish(t)}_parseDetachedRuleSetBody(){return this._tryParseKeyframeSelector()||this._parseRuleSetDeclaration()}_addLookupChildren(e){if(!e.addChild(this._parseLookupValue()))return!1;let t=!1;for(;this.peek(c.BracketL)&&(t=!0),!!e.addChild(this._parseLookupValue());)t=!1;return!t}_parseLookupValue(){let e=this.create(x),t=this.mark();return this.accept(c.BracketL)?(e.addChild(this._parseVariable(!1,!0))||e.addChild(this._parsePropertyIdentifier()))&&this.accept(c.BracketR)||this.accept(c.BracketR)?e:(this.restoreAtMark(t),null):(this.restoreAtMark(t),null)}_parseVariable(e=!1,t=!1){let r=!e&&this.peekDelim("$");if(!this.peekDelim("@")&&!r&&!this.peek(c.AtKeyword))return null;let i=this.create(Ke),s=this.mark();for(;this.acceptDelim("@")||!e&&this.acceptDelim("$");)if(this.hasWhitespace())return this.restoreAtMark(s),null;return!this.accept(c.AtKeyword)&&!this.accept(c.Ident)?(this.restoreAtMark(s),null):!t&&this.peek(c.BracketL)&&!this._addLookupChildren(i)?(this.restoreAtMark(s),null):i}_parseTermExpression(){return this._parseVariable()||this._parseEscaped()||super._parseTermExpression()||this._tryParseMixinReference(!1)}_parseEscaped(){if(this.peek(c.EscapedJavaScript)||this.peek(c.BadEscapedJavaScript)){let e=this.createNode(m.EscapedValue);return this.consumeToken(),this.finish(e)}if(this.peekDelim("~")){let e=this.createNode(m.EscapedValue);return this.consumeToken(),this.accept(c.String)||this.accept(c.EscapedJavaScript)?this.finish(e):this.finish(e,f.TermExpected)}return null}_parseOperator(){let e=this._parseGuardOperator();return e||super._parseOperator()}_parseGuardOperator(){if(this.peekDelim(">")){let e=this.createNode(m.Operator);return this.consumeToken(),this.acceptDelim("="),e}else if(this.peekDelim("=")){let e=this.createNode(m.Operator);return this.consumeToken(),this.acceptDelim("<"),e}else if(this.peekDelim("<")){let e=this.createNode(m.Operator);return this.consumeToken(),this.acceptDelim("="),e}return null}_parseRuleSetDeclaration(){return this.peek(c.AtKeyword)?this._parseKeyframe()||this._parseMedia(!0)||this._parseImport()||this._parseSupports(!0)||this._parseLayer()||this._parsePropertyAtRule()||this._parseContainer(!0)||this._parseDetachedRuleSetMixin()||this._parseVariableDeclaration()||this._parseRuleSetDeclarationAtStatement():this._tryParseMixinDeclaration()||this._tryParseRuleset(!0)||this._tryParseMixinReference()||this._parseFunction()||this._parseExtend()||this._parseDeclaration()}_parseKeyframeIdent(){return this._parseIdent([z.Keyframe])||this._parseVariable()}_parseKeyframeSelector(){return this._parseDetachedRuleSetMixin()||super._parseKeyframeSelector()}_parseSelector(e){let t=this.create(de),r=!1;for(e&&(r=t.addChild(this._parseCombinator()));t.addChild(this._parseSimpleSelector());){r=!0;let i=this.mark();if(t.addChild(this._parseGuard())&&this.peek(c.CurlyL))break;this.restoreAtMark(i),t.addChild(this._parseCombinator())}return r?this.finish(t):null}_parseNestingSelector(){if(this.peekDelim("&")){let e=this.createNode(m.SelectorCombinator);for(this.consumeToken();!this.hasWhitespace()&&(this.acceptDelim("-")||this.accept(c.Num)||this.accept(c.Dimension)||e.addChild(this._parseIdent())||this.acceptDelim("&")););return this.finish(e)}return null}_parseSelectorIdent(){if(!this.peekInterpolatedIdent())return null;let e=this.createNode(m.SelectorInterpolation);return this._acceptInterpolatedIdent(e)?this.finish(e):null}_parsePropertyIdentifier(e=!1){let t=/^[\w-]+/;if(!this.peekInterpolatedIdent()&&!this.peekRegExp(this.token.type,t))return null;let r=this.mark(),i=this.create(G);i.isCustomProperty=this.acceptDelim("-")&&this.acceptDelim("-");let s=!1;return e?i.isCustomProperty?s=i.addChild(this._parseIdent()):s=i.addChild(this._parseRegexp(t)):i.isCustomProperty?s=this._acceptInterpolatedIdent(i):s=this._acceptInterpolatedIdent(i,t),s?(!e&&!this.hasWhitespace()&&(this.acceptDelim("+"),this.hasWhitespace()||this.acceptIdent("_")),this.finish(i)):(this.restoreAtMark(r),null)}peekInterpolatedIdent(){return this.peek(c.Ident)||this.peekDelim("@")||this.peekDelim("$")||this.peekDelim("-")}_acceptInterpolatedIdent(e,t){let r=!1,i=()=>{let a=this.mark();return this.acceptDelim("-")&&(this.hasWhitespace()||this.acceptDelim("-"),this.hasWhitespace())?(this.restoreAtMark(a),null):this._parseInterpolation()},s=t?()=>this.acceptRegexp(t):()=>this.accept(c.Ident);for(;(s()||e.addChild(this._parseInterpolation()||this.try(i)))&&(r=!0,!this.hasWhitespace()););return r}_parseInterpolation(){let e=this.mark();if(this.peekDelim("@")||this.peekDelim("$")){let t=this.createNode(m.Interpolation);return this.consumeToken(),this.hasWhitespace()||!this.accept(c.CurlyL)?(this.restoreAtMark(e),null):t.addChild(this._parseIdent())?this.accept(c.CurlyR)?this.finish(t):this.finish(t,f.RightCurlyExpected):this.finish(t,f.IdentifierExpected)}return null}_tryParseMixinDeclaration(){let e=this.mark(),t=this.create(ue);if(!t.setIdentifier(this._parseMixinDeclarationIdentifier())||!this.accept(c.ParenthesisL))return this.restoreAtMark(e),null;if(t.getParameters().addChild(this._parseMixinParameter()))for(;(this.accept(c.Comma)||this.accept(c.SemiColon))&&!this.peek(c.ParenthesisR);)t.getParameters().addChild(this._parseMixinParameter())||this.markError(t,f.IdentifierExpected,[],[c.ParenthesisR]);return this.accept(c.ParenthesisR)?(t.setGuard(this._parseGuard()),this.peek(c.CurlyL)?this._parseBody(t,this._parseMixInBodyDeclaration.bind(this)):(this.restoreAtMark(e),null)):(this.restoreAtMark(e),null)}_parseMixInBodyDeclaration(){return this._parseFontFace()||this._parseRuleSetDeclaration()}_parseMixinDeclarationIdentifier(){let e;if(this.peekDelim("#")||this.peekDelim(".")){if(e=this.create(G),this.consumeToken(),this.hasWhitespace()||!e.addChild(this._parseIdent()))return null}else if(this.peek(c.Hash))e=this.create(G),this.consumeToken();else return null;return e.referenceTypes=[z.Mixin],this.finish(e)}_parsePseudo(){if(!this.peek(c.Colon))return null;let e=this.mark(),t=this.create(Se);return this.consumeToken(),this.acceptIdent("extend")?this._completeExtends(t):(this.restoreAtMark(e),super._parsePseudo())}_parseExtend(){if(!this.peekDelim("&"))return null;let e=this.mark(),t=this.create(Se);return this.consumeToken(),this.hasWhitespace()||!this.accept(c.Colon)||!this.acceptIdent("extend")?(this.restoreAtMark(e),null):this._completeExtends(t)}_completeExtends(e){if(!this.accept(c.ParenthesisL))return this.finish(e,f.LeftParenthesisExpected);let t=e.getSelectors();if(!t.addChild(this._parseSelector(!0)))return this.finish(e,f.SelectorExpected);for(;this.accept(c.Comma);)if(!t.addChild(this._parseSelector(!0)))return this.finish(e,f.SelectorExpected);return this.accept(c.ParenthesisR)?this.finish(e):this.finish(e,f.RightParenthesisExpected)}_parseDetachedRuleSetMixin(){if(!this.peek(c.AtKeyword))return null;let e=this.mark(),t=this.create(ze);return t.addChild(this._parseVariable(!0))&&(this.hasWhitespace()||!this.accept(c.ParenthesisL))?(this.restoreAtMark(e),null):this.accept(c.ParenthesisR)?this.finish(t):this.finish(t,f.RightParenthesisExpected)}_tryParseMixinReference(e=!0){let t=this.mark(),r=this.create(ze),i=this._parseMixinDeclarationIdentifier();for(;i;){this.acceptDelim(">");let a=this._parseMixinDeclarationIdentifier();if(a)r.getNamespaces().addChild(i),i=a;else break}if(!r.setIdentifier(i))return this.restoreAtMark(t),null;let s=!1;if(this.accept(c.ParenthesisL)){if(s=!0,r.getArguments().addChild(this._parseMixinArgument())){for(;(this.accept(c.Comma)||this.accept(c.SemiColon))&&!this.peek(c.ParenthesisR);)if(!r.getArguments().addChild(this._parseMixinArgument()))return this.finish(r,f.ExpressionExpected)}if(!this.accept(c.ParenthesisR))return this.finish(r,f.RightParenthesisExpected);i.referenceTypes=[z.Mixin]}else i.referenceTypes=[z.Mixin,z.Rule];return this.peek(c.BracketL)?e||this._addLookupChildren(r):r.addChild(this._parsePrio()),!s&&!this.peek(c.SemiColon)&&!this.peek(c.CurlyR)&&!this.peek(c.EOF)?(this.restoreAtMark(t),null):this.finish(r)}_parseMixinArgument(){let e=this.create(le),t=this.mark(),r=this._parseVariable();return r&&(this.accept(c.Colon)?e.setIdentifier(r):this.restoreAtMark(t)),e.setValue(this._parseDetachedRuleSet()||this._parseExpr(!0))?this.finish(e):(this.restoreAtMark(t),null)}_parseMixinParameter(){let e=this.create(ye);if(this.peekKeyword("@rest")){let r=this.create(x);return this.consumeToken(),this.accept(Sr)?(e.setIdentifier(this.finish(r)),this.finish(e)):this.finish(e,f.DotExpected,[],[c.Comma,c.ParenthesisR])}if(this.peek(Sr)){let r=this.create(x);return this.consumeToken(),e.setIdentifier(this.finish(r)),this.finish(e)}let t=!1;return e.setIdentifier(this._parseVariable())&&(this.accept(c.Colon),t=!0),!e.setDefaultValue(this._parseDetachedRuleSet()||this._parseExpr(!0))&&!t?null:this.finish(e)}_parseGuard(){if(!this.peekIdent("when"))return null;let e=this.create(qn);if(this.consumeToken(),!e.getConditions().addChild(this._parseGuardCondition()))return this.finish(e,f.ConditionExpected);for(;this.acceptIdent("and")||this.accept(c.Comma);)if(!e.getConditions().addChild(this._parseGuardCondition()))return this.finish(e,f.ConditionExpected);return this.finish(e)}_parseGuardCondition(){let e=this.create(Kn);return e.isNegated=this.acceptIdent("not"),this.accept(c.ParenthesisL)?(e.addChild(this._parseExpr()),this.accept(c.ParenthesisR)?this.finish(e):this.finish(e,f.RightParenthesisExpected)):e.isNegated?this.finish(e,f.LeftParenthesisExpected):null}_parseFunction(){let e=this.mark(),t=this.create(me);if(!t.setIdentifier(this._parseFunctionIdentifier()))return null;if(this.hasWhitespace()||!this.accept(c.ParenthesisL))return this.restoreAtMark(e),null;if(t.getArguments().addChild(this._parseMixinArgument())){for(;(this.accept(c.Comma)||this.accept(c.SemiColon))&&!this.peek(c.ParenthesisR);)if(!t.getArguments().addChild(this._parseMixinArgument()))return this.finish(t,f.ExpressionExpected)}return this.accept(c.ParenthesisR)?this.finish(t):this.finish(t,f.RightParenthesisExpected)}_parseFunctionIdentifier(){if(this.peekDelim("%")){let e=this.create(G);return e.referenceTypes=[z.Function],this.consumeToken(),this.finish(e)}return super._parseFunctionIdentifier()}_parseURLArgument(){let e=this.mark(),t=super._parseURLArgument();if(!t||!this.peek(c.ParenthesisR)){this.restoreAtMark(e);let r=this.create(x);return r.addChild(this._parseBinaryExpr()),this.finish(r)}return t}};var Nt=class n extends Xe{constructor(e,t){super("@",e,t)}createFunctionProposals(e,t,r,i){for(let s of e){let a={label:s.name,detail:s.example,documentation:s.description,textEdit:_.replace(this.getCompletionRange(t),s.name+"($0)"),insertTextFormat:te.Snippet,kind:k.Function};r&&(a.sortText="z"),i.items.push(a)}return i}getTermProposals(e,t,r){let i=n.builtInProposals;return e&&(i=i.filter(s=>!s.type||!e.restrictions||e.restrictions.indexOf(s.type)!==-1)),this.createFunctionProposals(i,t,!0,r),super.getTermProposals(e,t,r)}getColorProposals(e,t,r){return this.createFunctionProposals(n.colorProposals,t,!1,r),super.getColorProposals(e,t,r)}getCompletionsForDeclarationProperty(e,t){return this.getCompletionsForSelector(null,!0,t),super.getCompletionsForDeclarationProperty(e,t)}};Nt.builtInProposals=[{name:"if",example:"if(condition, trueValue [, falseValue]);",description:p("returns one of two values depending on a condition.")},{name:"boolean",example:"boolean(condition);",description:p('"store" a boolean test for later evaluation in a guard or if().')},{name:"length",example:"length(@list);",description:p("returns the number of elements in a value list")},{name:"extract",example:"extract(@list, index);",description:p("returns a value at the specified position in the list")},{name:"range",example:"range([start, ] end [, step]);",description:p("generate a list spanning a range of values")},{name:"each",example:"each(@list, ruleset);",description:p("bind the evaluation of a ruleset to each member of a list.")},{name:"escape",example:"escape(@string);",description:p("URL encodes a string")},{name:"e",example:"e(@string);",description:p("escape string content")},{name:"replace",example:"replace(@string, @pattern, @replacement[, @flags]);",description:p("string replace")},{name:"unit",example:"unit(@dimension, [@unit: '']);",description:p("remove or change the unit of a dimension")},{name:"color",example:"color(@string);",description:p("parses a string to a color"),type:"color"},{name:"convert",example:"convert(@value, unit);",description:p("converts numbers from one type into another")},{name:"data-uri",example:"data-uri([mimetype,] url);",description:p("inlines a resource and falls back to `url()`"),type:"url"},{name:"abs",description:p("absolute value of a number"),example:"abs(number);"},{name:"acos",description:p("arccosine - inverse of cosine function"),example:"acos(number);"},{name:"asin",description:p("arcsine - inverse of sine function"),example:"asin(number);"},{name:"ceil",example:"ceil(@number);",description:p("rounds up to an integer")},{name:"cos",description:p("cosine function"),example:"cos(number);"},{name:"floor",description:p("rounds down to an integer"),example:"floor(@number);"},{name:"percentage",description:p("converts to a %, e.g. 0.5 > 50%"),example:"percentage(@number);",type:"percentage"},{name:"round",description:p("rounds a number to a number of places"),example:"round(number, [places: 0]);"},{name:"sqrt",description:p("calculates square root of a number"),example:"sqrt(number);"},{name:"sin",description:p("sine function"),example:"sin(number);"},{name:"tan",description:p("tangent function"),example:"tan(number);"},{name:"atan",description:p("arctangent - inverse of tangent function"),example:"atan(number);"},{name:"pi",description:p("returns pi"),example:"pi();"},{name:"pow",description:p("first argument raised to the power of the second argument"),example:"pow(@base, @exponent);"},{name:"mod",description:p("first argument modulus second argument"),example:"mod(number, number);"},{name:"min",description:p("returns the lowest of one or more values"),example:"min(@x, @y);"},{name:"max",description:p("returns the lowest of one or more values"),example:"max(@x, @y);"}];Nt.colorProposals=[{name:"argb",example:"argb(@color);",description:p("creates a #AARRGGBB")},{name:"hsl",example:"hsl(@hue, @saturation, @lightness);",description:p("creates a color")},{name:"hsla",example:"hsla(@hue, @saturation, @lightness, @alpha);",description:p("creates a color")},{name:"hsv",example:"hsv(@hue, @saturation, @value);",description:p("creates a color")},{name:"hsva",example:"hsva(@hue, @saturation, @value, @alpha);",description:p("creates a color")},{name:"hue",example:"hue(@color);",description:p("returns the `hue` channel of `@color` in the HSL space")},{name:"saturation",example:"saturation(@color);",description:p("returns the `saturation` channel of `@color` in the HSL space")},{name:"lightness",example:"lightness(@color);",description:p("returns the `lightness` channel of `@color` in the HSL space")},{name:"hsvhue",example:"hsvhue(@color);",description:p("returns the `hue` channel of `@color` in the HSV space")},{name:"hsvsaturation",example:"hsvsaturation(@color);",description:p("returns the `saturation` channel of `@color` in the HSV space")},{name:"hsvvalue",example:"hsvvalue(@color);",description:p("returns the `value` channel of `@color` in the HSV space")},{name:"red",example:"red(@color);",description:p("returns the `red` channel of `@color`")},{name:"green",example:"green(@color);",description:p("returns the `green` channel of `@color`")},{name:"blue",example:"blue(@color);",description:p("returns the `blue` channel of `@color`")},{name:"alpha",example:"alpha(@color);",description:p("returns the `alpha` channel of `@color`")},{name:"luma",example:"luma(@color);",description:p("returns the `luma` value (perceptual brightness) of `@color`")},{name:"saturate",example:"saturate(@color, 10%);",description:p("return `@color` 10% points more saturated")},{name:"desaturate",example:"desaturate(@color, 10%);",description:p("return `@color` 10% points less saturated")},{name:"lighten",example:"lighten(@color, 10%);",description:p("return `@color` 10% points lighter")},{name:"darken",example:"darken(@color, 10%);",description:p("return `@color` 10% points darker")},{name:"fadein",example:"fadein(@color, 10%);",description:p("return `@color` 10% points less transparent")},{name:"fadeout",example:"fadeout(@color, 10%);",description:p("return `@color` 10% points more transparent")},{name:"fade",example:"fade(@color, 50%);",description:p("return `@color` with 50% transparency")},{name:"spin",example:"spin(@color, 10);",description:p("return `@color` with a 10 degree larger in hue")},{name:"mix",example:"mix(@color1, @color2, [@weight: 50%]);",description:p("return a mix of `@color1` and `@color2`")},{name:"greyscale",example:"greyscale(@color);",description:p("returns a grey, 100% desaturated color")},{name:"contrast",example:"contrast(@color1, [@darkcolor: black], [@lightcolor: white], [@threshold: 43%]);",description:p("return `@darkcolor` if `@color1 is> 43% luma` otherwise return `@lightcolor`, see notes")},{name:"multiply",example:"multiply(@color1, @color2);"},{name:"screen",example:"screen(@color1, @color2);"},{name:"overlay",example:"overlay(@color1, @color2);"},{name:"softlight",example:"softlight(@color1, @color2);"},{name:"hardlight",example:"hardlight(@color1, @color2);"},{name:"difference",example:"difference(@color1, @color2);"},{name:"exclusion",example:"exclusion(@color1, @color2);"},{name:"average",example:"average(@color1, @color2);"},{name:"negation",example:"negation(@color1, @color2);"}];function co(n,e){let t=ja(n);return Ba(t,e)}function ja(n){function e(h){return n.positionAt(h.offset).line}function t(h){return n.positionAt(h.offset+h.len).line}function r(){switch(n.languageId){case"scss":return new zt;case"less":return new Tt;default:return new ce}}function i(h,u){let w=e(h),b=t(h);return w!==b?{startLine:w,endLine:b,kind:u}:null}let s=[],a=[],l=r();l.ignoreComment=!1,l.setSource(n.getText());let o=l.scan(),d=null;for(;o.type!==c.EOF;){switch(o.type){case c.CurlyL:case Mt:{a.push({line:e(o),type:"brace",isStart:!0});break}case c.CurlyR:{if(a.length!==0){let h=lo(a,"brace");if(!h)break;let u=t(o);h.type==="brace"&&(d&&t(d)!==u&&u--,h.line!==u&&s.push({startLine:h.line,endLine:u,kind:void 0}))}break}case c.Comment:{let h=b=>b==="#region"?{line:e(o),type:"comment",isStart:!0}:{line:t(o),type:"comment",isStart:!1},w=(b=>{let y=b.text.match(/^\s*\/\*\s*(#region|#endregion)\b\s*(.*?)\s*\*\//);if(y)return h(y[1]);if(n.languageId==="scss"||n.languageId==="less"){let E=b.text.match(/^\s*\/\/\s*(#region|#endregion)\b\s*(.*?)\s*/);if(E)return h(E[1])}return null})(o);if(w)if(w.isStart)a.push(w);else{let b=lo(a,"comment");if(!b)break;b.type==="comment"&&b.line!==w.line&&s.push({startLine:b.line,endLine:w.line,kind:"region"})}else{let b=i(o,"comment");b&&s.push(b)}break}}d=o,o=l.scan()}return s}function lo(n,e){if(n.length===0)return null;for(let t=n.length-1;t>=0;t--)if(n[t].type===e&&n[t].isStart)return n.splice(t,1)[0];return null}function Ba(n,e){let t=e&&e.rangeLimit||Number.MAX_VALUE,r=n.sort((a,l)=>{let o=a.startLine-l.startLine;return o===0&&(o=a.endLine-l.endLine),o}),i=[],s=-1;return r.forEach(a=>{a.startLine<s&&s<a.endLine||(i.push(a),s=a.endLine)}),i.length<t?i:i.slice(0,t)}var ho;(function(){"use strict";var n=[,,function(i){function s(o){this.__parent=o,this.__character_count=0,this.__indent_count=-1,this.__alignment_count=0,this.__wrap_point_index=0,this.__wrap_point_character_count=0,this.__wrap_point_indent_count=-1,this.__wrap_point_alignment_count=0,this.__items=[]}s.prototype.clone_empty=function(){var o=new s(this.__parent);return o.set_indent(this.__indent_count,this.__alignment_count),o},s.prototype.item=function(o){return o<0?this.__items[this.__items.length+o]:this.__items[o]},s.prototype.has_match=function(o){for(var d=this.__items.length-1;d>=0;d--)if(this.__items[d].match(o))return!0;return!1},s.prototype.set_indent=function(o,d){this.is_empty()&&(this.__indent_count=o||0,this.__alignment_count=d||0,this.__character_count=this.__parent.get_indent_size(this.__indent_count,this.__alignment_count))},s.prototype._set_wrap_point=function(){this.__parent.wrap_line_length&&(this.__wrap_point_index=this.__items.length,this.__wrap_point_character_count=this.__character_count,this.__wrap_point_indent_count=this.__parent.next_line.__indent_count,this.__wrap_point_alignment_count=this.__parent.next_line.__alignment_count)},s.prototype._should_wrap=function(){return this.__wrap_point_index&&this.__character_count>this.__parent.wrap_line_length&&this.__wrap_point_character_count>this.__parent.next_line.__character_count},s.prototype._allow_wrap=function(){if(this._should_wrap()){this.__parent.add_new_line();var o=this.__parent.current_line;return o.set_indent(this.__wrap_point_indent_count,this.__wrap_point_alignment_count),o.__items=this.__items.slice(this.__wrap_point_index),this.__items=this.__items.slice(0,this.__wrap_point_index),o.__character_count+=this.__character_count-this.__wrap_point_character_count,this.__character_count=this.__wrap_point_character_count,o.__items[0]===" "&&(o.__items.splice(0,1),o.__character_count-=1),!0}return!1},s.prototype.is_empty=function(){return this.__items.length===0},s.prototype.last=function(){return this.is_empty()?null:this.__items[this.__items.length-1]},s.prototype.push=function(o){this.__items.push(o);var d=o.lastIndexOf(`
`);d!==-1?this.__character_count=o.length-d:this.__character_count+=o.length},s.prototype.pop=function(){var o=null;return this.is_empty()||(o=this.__items.pop(),this.__character_count-=o.length),o},s.prototype._remove_indent=function(){this.__indent_count>0&&(this.__indent_count-=1,this.__character_count-=this.__parent.indent_size)},s.prototype._remove_wrap_indent=function(){this.__wrap_point_indent_count>0&&(this.__wrap_point_indent_count-=1)},s.prototype.trim=function(){for(;this.last()===" ";)this.__items.pop(),this.__character_count-=1},s.prototype.toString=function(){var o="";return this.is_empty()?this.__parent.indent_empty_lines&&(o=this.__parent.get_indent_string(this.__indent_count)):(o=this.__parent.get_indent_string(this.__indent_count,this.__alignment_count),o+=this.__items.join("")),o};function a(o,d){this.__cache=[""],this.__indent_size=o.indent_size,this.__indent_string=o.indent_char,o.indent_with_tabs||(this.__indent_string=new Array(o.indent_size+1).join(o.indent_char)),d=d||"",o.indent_level>0&&(d=new Array(o.indent_level+1).join(this.__indent_string)),this.__base_string=d,this.__base_string_length=d.length}a.prototype.get_indent_size=function(o,d){var h=this.__base_string_length;return d=d||0,o<0&&(h=0),h+=o*this.__indent_size,h+=d,h},a.prototype.get_indent_string=function(o,d){var h=this.__base_string;return d=d||0,o<0&&(o=0,h=""),d+=o*this.__indent_size,this.__ensure_cache(d),h+=this.__cache[d],h},a.prototype.__ensure_cache=function(o){for(;o>=this.__cache.length;)this.__add_column()},a.prototype.__add_column=function(){var o=this.__cache.length,d=0,h="";this.__indent_size&&o>=this.__indent_size&&(d=Math.floor(o/this.__indent_size),o-=d*this.__indent_size,h=new Array(d+1).join(this.__indent_string)),o&&(h+=new Array(o+1).join(" ")),this.__cache.push(h)};function l(o,d){this.__indent_cache=new a(o,d),this.raw=!1,this._end_with_newline=o.end_with_newline,this.indent_size=o.indent_size,this.wrap_line_length=o.wrap_line_length,this.indent_empty_lines=o.indent_empty_lines,this.__lines=[],this.previous_line=null,this.current_line=null,this.next_line=new s(this),this.space_before_token=!1,this.non_breaking_space=!1,this.previous_token_wrapped=!1,this.__add_outputline()}l.prototype.__add_outputline=function(){this.previous_line=this.current_line,this.current_line=this.next_line.clone_empty(),this.__lines.push(this.current_line)},l.prototype.get_line_number=function(){return this.__lines.length},l.prototype.get_indent_string=function(o,d){return this.__indent_cache.get_indent_string(o,d)},l.prototype.get_indent_size=function(o,d){return this.__indent_cache.get_indent_size(o,d)},l.prototype.is_empty=function(){return!this.previous_line&&this.current_line.is_empty()},l.prototype.add_new_line=function(o){return this.is_empty()||!o&&this.just_added_newline()?!1:(this.raw||this.__add_outputline(),!0)},l.prototype.get_code=function(o){this.trim(!0);var d=this.current_line.pop();d&&(d[d.length-1]===`
`&&(d=d.replace(/\n+$/g,"")),this.current_line.push(d)),this._end_with_newline&&this.__add_outputline();var h=this.__lines.join(`
`);return o!==`
`&&(h=h.replace(/[\n]/g,o)),h},l.prototype.set_wrap_point=function(){this.current_line._set_wrap_point()},l.prototype.set_indent=function(o,d){return o=o||0,d=d||0,this.next_line.set_indent(o,d),this.__lines.length>1?(this.current_line.set_indent(o,d),!0):(this.current_line.set_indent(),!1)},l.prototype.add_raw_token=function(o){for(var d=0;d<o.newlines;d++)this.__add_outputline();this.current_line.set_indent(-1),this.current_line.push(o.whitespace_before),this.current_line.push(o.text),this.space_before_token=!1,this.non_breaking_space=!1,this.previous_token_wrapped=!1},l.prototype.add_token=function(o){this.__add_space_before_token(),this.current_line.push(o),this.space_before_token=!1,this.non_breaking_space=!1,this.previous_token_wrapped=this.current_line._allow_wrap()},l.prototype.__add_space_before_token=function(){this.space_before_token&&!this.just_added_newline()&&(this.non_breaking_space||this.set_wrap_point(),this.current_line.push(" "))},l.prototype.remove_indent=function(o){for(var d=this.__lines.length;o<d;)this.__lines[o]._remove_indent(),o++;this.current_line._remove_wrap_indent()},l.prototype.trim=function(o){for(o=o===void 0?!1:o,this.current_line.trim();o&&this.__lines.length>1&&this.current_line.is_empty();)this.__lines.pop(),this.current_line=this.__lines[this.__lines.length-1],this.current_line.trim();this.previous_line=this.__lines.length>1?this.__lines[this.__lines.length-2]:null},l.prototype.just_added_newline=function(){return this.current_line.is_empty()},l.prototype.just_added_blankline=function(){return this.is_empty()||this.current_line.is_empty()&&this.previous_line.is_empty()},l.prototype.ensure_empty_line_above=function(o,d){for(var h=this.__lines.length-2;h>=0;){var u=this.__lines[h];if(u.is_empty())break;if(u.item(0).indexOf(o)!==0&&u.item(-1)!==d){this.__lines.splice(h+1,0,new s(this)),this.previous_line=this.__lines[this.__lines.length-2];break}h--}},i.exports.Output=l},,,,function(i){function s(o,d){this.raw_options=a(o,d),this.disabled=this._get_boolean("disabled"),this.eol=this._get_characters("eol","auto"),this.end_with_newline=this._get_boolean("end_with_newline"),this.indent_size=this._get_number("indent_size",4),this.indent_char=this._get_characters("indent_char"," "),this.indent_level=this._get_number("indent_level"),this.preserve_newlines=this._get_boolean("preserve_newlines",!0),this.max_preserve_newlines=this._get_number("max_preserve_newlines",32786),this.preserve_newlines||(this.max_preserve_newlines=0),this.indent_with_tabs=this._get_boolean("indent_with_tabs",this.indent_char==="	"),this.indent_with_tabs&&(this.indent_char="	",this.indent_size===1&&(this.indent_size=4)),this.wrap_line_length=this._get_number("wrap_line_length",this._get_number("max_char")),this.indent_empty_lines=this._get_boolean("indent_empty_lines"),this.templating=this._get_selection_list("templating",["auto","none","angular","django","erb","handlebars","php","smarty"],["auto"])}s.prototype._get_array=function(o,d){var h=this.raw_options[o],u=d||[];return typeof h=="object"?h!==null&&typeof h.concat=="function"&&(u=h.concat()):typeof h=="string"&&(u=h.split(/[^a-zA-Z0-9_\/\-]+/)),u},s.prototype._get_boolean=function(o,d){var h=this.raw_options[o],u=h===void 0?!!d:!!h;return u},s.prototype._get_characters=function(o,d){var h=this.raw_options[o],u=d||"";return typeof h=="string"&&(u=h.replace(/\\r/,"\r").replace(/\\n/,`
`).replace(/\\t/,"	")),u},s.prototype._get_number=function(o,d){var h=this.raw_options[o];d=parseInt(d,10),isNaN(d)&&(d=0);var u=parseInt(h,10);return isNaN(u)&&(u=d),u},s.prototype._get_selection=function(o,d,h){var u=this._get_selection_list(o,d,h);if(u.length!==1)throw new Error("Invalid Option Value: The option '"+o+`' can only be one of the following values:
`+d+`
You passed in: '`+this.raw_options[o]+"'");return u[0]},s.prototype._get_selection_list=function(o,d,h){if(!d||d.length===0)throw new Error("Selection list cannot be empty.");if(h=h||[d[0]],!this._is_valid_selection(h,d))throw new Error("Invalid Default Value!");var u=this._get_array(o,h);if(!this._is_valid_selection(u,d))throw new Error("Invalid Option Value: The option '"+o+`' can contain only the following values:
`+d+`
You passed in: '`+this.raw_options[o]+"'");return u},s.prototype._is_valid_selection=function(o,d){return o.length&&d.length&&!o.some(function(h){return d.indexOf(h)===-1})};function a(o,d){var h={};o=l(o);var u;for(u in o)u!==d&&(h[u]=o[u]);if(d&&o[d])for(u in o[d])h[u]=o[d][u];return h}function l(o){var d={},h;for(h in o){var u=h.replace(/-/g,"_");d[u]=o[h]}return d}i.exports.Options=s,i.exports.normalizeOpts=l,i.exports.mergeOpts=a},,function(i){var s=RegExp.prototype.hasOwnProperty("sticky");function a(l){this.__input=l||"",this.__input_length=this.__input.length,this.__position=0}a.prototype.restart=function(){this.__position=0},a.prototype.back=function(){this.__position>0&&(this.__position-=1)},a.prototype.hasNext=function(){return this.__position<this.__input_length},a.prototype.next=function(){var l=null;return this.hasNext()&&(l=this.__input.charAt(this.__position),this.__position+=1),l},a.prototype.peek=function(l){var o=null;return l=l||0,l+=this.__position,l>=0&&l<this.__input_length&&(o=this.__input.charAt(l)),o},a.prototype.__match=function(l,o){l.lastIndex=o;var d=l.exec(this.__input);return d&&!(s&&l.sticky)&&d.index!==o&&(d=null),d},a.prototype.test=function(l,o){return o=o||0,o+=this.__position,o>=0&&o<this.__input_length?!!this.__match(l,o):!1},a.prototype.testChar=function(l,o){var d=this.peek(o);return l.lastIndex=0,d!==null&&l.test(d)},a.prototype.match=function(l){var o=this.__match(l,this.__position);return o?this.__position+=o[0].length:o=null,o},a.prototype.read=function(l,o,d){var h="",u;return l&&(u=this.match(l),u&&(h+=u[0])),o&&(u||!l)&&(h+=this.readUntil(o,d)),h},a.prototype.readUntil=function(l,o){var d="",h=this.__position;l.lastIndex=this.__position;var u=l.exec(this.__input);return u?(h=u.index,o&&(h+=u[0].length)):h=this.__input_length,d=this.__input.substring(this.__position,h),this.__position=h,d},a.prototype.readUntilAfter=function(l){return this.readUntil(l,!0)},a.prototype.get_regexp=function(l,o){var d=null,h="g";return o&&s&&(h="y"),typeof l=="string"&&l!==""?d=new RegExp(l,h):l&&(d=new RegExp(l.source,h)),d},a.prototype.get_literal_regexp=function(l){return RegExp(l.replace(/[-\/\\^$*+?.()|[\]{}]/g,"\\$&"))},a.prototype.peekUntilAfter=function(l){var o=this.__position,d=this.readUntilAfter(l);return this.__position=o,d},a.prototype.lookBack=function(l){var o=this.__position-1;return o>=l.length&&this.__input.substring(o-l.length,o).toLowerCase()===l},i.exports.InputScanner=a},,,,,function(i){function s(a,l){a=typeof a=="string"?a:a.source,l=typeof l=="string"?l:l.source,this.__directives_block_pattern=new RegExp(a+/ beautify( \w+[:]\w+)+ /.source+l,"g"),this.__directive_pattern=/ (\w+)[:](\w+)/g,this.__directives_end_ignore_pattern=new RegExp(a+/\sbeautify\signore:end\s/.source+l,"g")}s.prototype.get_directives=function(a){if(!a.match(this.__directives_block_pattern))return null;var l={};this.__directive_pattern.lastIndex=0;for(var o=this.__directive_pattern.exec(a);o;)l[o[1]]=o[2],o=this.__directive_pattern.exec(a);return l},s.prototype.readIgnored=function(a){return a.readUntilAfter(this.__directives_end_ignore_pattern)},i.exports.Directives=s},,function(i,s,a){var l=a(16).Beautifier,o=a(17).Options;function d(h,u){var w=new l(h,u);return w.beautify()}i.exports=d,i.exports.defaultOptions=function(){return new o}},function(i,s,a){var l=a(17).Options,o=a(2).Output,d=a(8).InputScanner,h=a(13).Directives,u=new h(/\/\*/,/\*\//),w=/\r\n|[\r\n]/,b=/\r\n|[\r\n]/g,y=/\s/,E=/(?:\s|\n)+/g,A=/\/\*(?:[\s\S]*?)((?:\*\/)|$)/g,I=/\/\/(?:[^\n\r\u2028\u2029]*)/g;function P(T,j){this._source_text=T||"",this._options=new l(j),this._ch=null,this._input=null,this.NESTED_AT_RULE={page:!0,"font-face":!0,keyframes:!0,media:!0,supports:!0,document:!0},this.CONDITIONAL_GROUP_RULE={media:!0,supports:!0,document:!0},this.NON_SEMICOLON_NEWLINE_PROPERTY=["grid-template-areas","grid-template"]}P.prototype.eatString=function(T){var j="";for(this._ch=this._input.next();this._ch;){if(j+=this._ch,this._ch==="\\")j+=this._input.next();else if(T.indexOf(this._ch)!==-1||this._ch===`
`)break;this._ch=this._input.next()}return j},P.prototype.eatWhitespace=function(T){for(var j=y.test(this._input.peek()),X=0;y.test(this._input.peek());)this._ch=this._input.next(),T&&this._ch===`
`&&(X===0||X<this._options.max_preserve_newlines)&&(X++,this._output.add_new_line(!0));return j},P.prototype.foundNestedPseudoClass=function(){for(var T=0,j=1,X=this._input.peek(j);X;){if(X==="{")return!0;if(X==="(")T+=1;else if(X===")"){if(T===0)return!1;T-=1}else if(X===";"||X==="}")return!1;j++,X=this._input.peek(j)}return!1},P.prototype.print_string=function(T){this._output.set_indent(this._indentLevel),this._output.non_breaking_space=!0,this._output.add_token(T)},P.prototype.preserveSingleSpace=function(T){T&&(this._output.space_before_token=!0)},P.prototype.indent=function(){this._indentLevel++},P.prototype.outdent=function(){this._indentLevel>0&&this._indentLevel--},P.prototype.beautify=function(){if(this._options.disabled)return this._source_text;var T=this._source_text,j=this._options.eol;j==="auto"&&(j=`
`,T&&w.test(T||"")&&(j=T.match(w)[0])),T=T.replace(b,`
`);var X=T.match(/^[\t ]*/)[0];this._output=new o(this._options,X),this._input=new d(T),this._indentLevel=0,this._nestedLevel=0,this._ch=null;for(var Y=0,$e=!1,K=!1,_e=!1,Ie=!1,S=!1,v=this._ch,F=!1,C,N,D;C=this._input.read(E),N=C!=="",D=v,this._ch=this._input.next(),this._ch==="\\"&&this._input.hasNext()&&(this._ch+=this._input.next()),v=this._ch,this._ch;)if(this._ch==="/"&&this._input.peek()==="*"){this._output.add_new_line(),this._input.back();var M=this._input.read(A),oe=u.get_directives(M);oe&&oe.ignore==="start"&&(M+=u.readIgnored(this._input)),this.print_string(M),this.eatWhitespace(!0),this._output.add_new_line()}else if(this._ch==="/"&&this._input.peek()==="/")this._output.space_before_token=!0,this._input.back(),this.print_string(this._input.read(I)),this.eatWhitespace(!0);else if(this._ch==="$"){this.preserveSingleSpace(N),this.print_string(this._ch);var Z=this._input.peekUntilAfter(/[: ,;{}()[\]\/='"]/g);Z.match(/[ :]$/)&&(Z=this.eatString(": ").replace(/\s+$/,""),this.print_string(Z),this._output.space_before_token=!0),Y===0&&Z.indexOf(":")!==-1&&(K=!0,this.indent())}else if(this._ch==="@")if(this.preserveSingleSpace(N),this._input.peek()==="{")this.print_string(this._ch+this.eatString("}"));else{this.print_string(this._ch);var $=this._input.peekUntilAfter(/[: ,;{}()[\]\/='"]/g);$.match(/[ :]$/)&&($=this.eatString(": ").replace(/\s+$/,""),this.print_string($),this._output.space_before_token=!0),Y===0&&$.indexOf(":")!==-1?(K=!0,this.indent()):$ in this.NESTED_AT_RULE?(this._nestedLevel+=1,$ in this.CONDITIONAL_GROUP_RULE&&(_e=!0)):Y===0&&!K&&(Ie=!0)}else if(this._ch==="#"&&this._input.peek()==="{")this.preserveSingleSpace(N),this.print_string(this._ch+this.eatString("}"));else if(this._ch==="{")K&&(K=!1,this.outdent()),Ie=!1,_e?(_e=!1,$e=this._indentLevel>=this._nestedLevel):$e=this._indentLevel>=this._nestedLevel-1,this._options.newline_between_rules&&$e&&this._output.previous_line&&this._output.previous_line.item(-1)!=="{"&&this._output.ensure_empty_line_above("/",","),this._output.space_before_token=!0,this._options.brace_style==="expand"?(this._output.add_new_line(),this.print_string(this._ch),this.indent(),this._output.set_indent(this._indentLevel)):(D==="("?this._output.space_before_token=!1:D!==","&&this.indent(),this.print_string(this._ch)),this.eatWhitespace(!0),this._output.add_new_line();else if(this._ch==="}")this.outdent(),this._output.add_new_line(),D==="{"&&this._output.trim(!0),K&&(this.outdent(),K=!1),this.print_string(this._ch),$e=!1,this._nestedLevel&&this._nestedLevel--,this.eatWhitespace(!0),this._output.add_new_line(),this._options.newline_between_rules&&!this._output.just_added_blankline()&&this._input.peek()!=="}"&&this._output.add_new_line(!0),this._input.peek()===")"&&(this._output.trim(!0),this._options.brace_style==="expand"&&this._output.add_new_line(!0));else if(this._ch===":"){for(var Ue=0;Ue<this.NON_SEMICOLON_NEWLINE_PROPERTY.length;Ue++)if(this._input.lookBack(this.NON_SEMICOLON_NEWLINE_PROPERTY[Ue])){F=!0;break}($e||_e)&&!(this._input.lookBack("&")||this.foundNestedPseudoClass())&&!this._input.lookBack("(")&&!Ie&&Y===0?(this.print_string(":"),K||(K=!0,this._output.space_before_token=!0,this.eatWhitespace(!0),this.indent())):(this._input.lookBack(" ")&&(this._output.space_before_token=!0),this._input.peek()===":"?(this._ch=this._input.next(),this.print_string("::")):this.print_string(":"))}else if(this._ch==='"'||this._ch==="'"){var So=D==='"'||D==="'";this.preserveSingleSpace(So||N),this.print_string(this._ch+this.eatString(this._ch)),this.eatWhitespace(!0)}else if(this._ch===";")F=!1,Y===0?(K&&(this.outdent(),K=!1),Ie=!1,this.print_string(this._ch),this.eatWhitespace(!0),this._input.peek()!=="/"&&this._output.add_new_line()):(this.print_string(this._ch),this.eatWhitespace(!0),this._output.space_before_token=!0);else if(this._ch==="(")if(this._input.lookBack("url"))this.print_string(this._ch),this.eatWhitespace(),Y++,this.indent(),this._ch=this._input.next(),this._ch===")"||this._ch==='"'||this._ch==="'"?this._input.back():this._ch&&(this.print_string(this._ch+this.eatString(")")),Y&&(Y--,this.outdent()));else{var Oi=!1;this._input.lookBack("with")&&(Oi=!0),this.preserveSingleSpace(N||Oi),this.print_string(this._ch),K&&D==="$"&&this._options.selector_separator_newline?(this._output.add_new_line(),S=!0):(this.eatWhitespace(),Y++,this.indent())}else if(this._ch===")")Y&&(Y--,this.outdent()),S&&this._input.peek()===";"&&this._options.selector_separator_newline&&(S=!1,this.outdent(),this._output.add_new_line()),this.print_string(this._ch);else if(this._ch===",")this.print_string(this._ch),this.eatWhitespace(!0),this._options.selector_separator_newline&&(!K||S)&&Y===0&&!Ie?this._output.add_new_line():this._output.space_before_token=!0;else if((this._ch===">"||this._ch==="+"||this._ch==="~")&&!K&&Y===0)this._options.space_around_combinator?(this._output.space_before_token=!0,this.print_string(this._ch),this._output.space_before_token=!0):(this.print_string(this._ch),this.eatWhitespace(),this._ch&&y.test(this._ch)&&(this._ch=""));else if(this._ch==="]")this.print_string(this._ch);else if(this._ch==="[")this.preserveSingleSpace(N),this.print_string(this._ch);else if(this._ch==="=")this.eatWhitespace(),this.print_string("="),y.test(this._ch)&&(this._ch="");else if(this._ch==="!"&&!this._input.lookBack("\\"))this._output.space_before_token=!0,this.print_string(this._ch);else{var Co=D==='"'||D==="'";this.preserveSingleSpace(Co||N),this.print_string(this._ch),!this._output.just_added_newline()&&this._input.peek()===`
`&&F&&this._output.add_new_line()}var ko=this._output.get_code(j);return ko},i.exports.Beautifier=P},function(i,s,a){var l=a(6).Options;function o(d){l.call(this,d,"css"),this.selector_separator_newline=this._get_boolean("selector_separator_newline",!0),this.newline_between_rules=this._get_boolean("newline_between_rules",!0);var h=this._get_boolean("space_around_selector_separator");this.space_around_combinator=this._get_boolean("space_around_combinator")||h;var u=this._get_selection_list("brace_style",["collapse","expand","end-expand","none","preserve-inline"]);this.brace_style="collapse";for(var w=0;w<u.length;w++)u[w]!=="expand"?this.brace_style="collapse":this.brace_style=u[w]}o.prototype=new l,i.exports.Options=o}],e={};function t(i){var s=e[i];if(s!==void 0)return s.exports;var a=e[i]={exports:{}};return n[i](a,a.exports,t),a.exports}var r=t(15);ho=r})();var po=ho;function go(n,e,t){let r=n.getText(),i=!0,s=0,a=!1,l=t.tabSize||4;if(e){let h=n.offsetAt(e.start),u=h;for(;u>0&&fo(r,u-1);)u--;u===0||uo(r,u-1)?h=u:u<h&&(h=u+1);let w=n.offsetAt(e.end),b=w;for(;b<r.length&&fo(r,b);)b++;if((b===r.length||uo(r,b))&&(w=b),e=R.create(n.positionAt(h),n.positionAt(w)),a=Ga(r,h),i=w===r.length,r=r.substring(h,w),h!==0){let y=n.offsetAt(H.create(e.start.line,0));s=Ha(n.getText(),y,t)}a&&(r=`{
${mo(r)}`)}else e=R.create(H.create(0,0),n.positionAt(r.length));let o={indent_size:l,indent_char:t.insertSpaces?" ":"	",end_with_newline:i&&Le(t,"insertFinalNewline",!1),selector_separator_newline:Le(t,"newlineBetweenSelectors",!0),newline_between_rules:Le(t,"newlineBetweenRules",!0),space_around_selector_separator:Le(t,"spaceAroundSelectorSeparator",!1),brace_style:Le(t,"braceStyle","collapse"),indent_empty_lines:Le(t,"indentEmptyLines",!1),max_preserve_newlines:Le(t,"maxPreserveNewLines",void 0),preserve_newlines:Le(t,"preserveNewLines",!0),wrap_line_length:Le(t,"wrapLineLength",void 0),eol:`
`},d=po(r,o);if(a&&(d=mo(d.substring(2))),s>0){let h=t.insertSpaces?Mr(" ",l*s):Mr("	",s);d=d.split(`
`).join(`
`+h),e.start.character===0&&(d=h+d)}return[{range:e,newText:d}]}function mo(n){return n.replace(/^\s+/,"")}var qa=123,Ka=125;function Ga(n,e){for(;e>=0;){let t=n.charCodeAt(e);if(t===qa)return!0;if(t===Ka)return!1;e--}return!1}function Le(n,e,t){if(n&&n.hasOwnProperty(e)){let r=n[e];if(r!==null)return r}return t}function Ha(n,e,t){let r=e,i=0,s=t.tabSize||4;for(;r<n.length;){let a=n.charAt(r);if(a===" ")i++;else if(a==="	")i+=s;else break;r++}return Math.floor(i/s)}function uo(n,e){return`\r
`.indexOf(n.charAt(e))!==-1}function fo(n,e){return" 	".indexOf(n.charAt(e))!==-1}var Mi={version:1.1,properties:[{name:"additive-symbols",browsers:["FF33"],atRule:"@counter-style",syntax:"[ <integer> && <symbol> ]#",relevance:50,description:"@counter-style descriptor. Specifies the symbols used by the marker-construction algorithm specified by the system descriptor. Needs to be specified if the counter system is 'additive'.",restrictions:["integer","string","image","identifier"]},{name:"align-content",browsers:["E12","FF28","S9","C29","IE11","O16"],values:[{name:"center",description:"Lines are packed toward the center of the flex container."},{name:"flex-end",description:"Lines are packed toward the end of the flex container."},{name:"flex-start",description:"Lines are packed toward the start of the flex container."},{name:"space-around",description:"Lines are evenly distributed in the flex container, with half-size spaces on either end."},{name:"space-between",description:"Lines are evenly distributed in the flex container."},{name:"stretch",description:"Lines stretch to take up the remaining space."},{name:"start"},{name:"end"},{name:"normal"},{name:"baseline"},{name:"first baseline"},{name:"last baseline"},{name:"space-around"},{name:"space-between"},{name:"space-evenly"},{name:"stretch"},{name:"safe"},{name:"unsafe"}],syntax:"normal | <baseline-position> | <content-distribution> | <overflow-position>? <content-position>",relevance:66,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/align-content"}],description:"Aligns a flex container's lines within the flex container when there is extra space in the cross-axis, similar to how 'justify-content' aligns individual items within the main-axis.",restrictions:["enum"]},{name:"align-items",browsers:["E12","FF20","S9","C29","IE11","O16"],values:[{name:"baseline",description:"If the flex item's inline axis is the same as the cross axis, this value is identical to 'flex-start'. Otherwise, it participates in baseline alignment."},{name:"center",description:"The flex item's margin box is centered in the cross axis within the line."},{name:"flex-end",description:"The cross-end margin edge of the flex item is placed flush with the cross-end edge of the line."},{name:"flex-start",description:"The cross-start margin edge of the flex item is placed flush with the cross-start edge of the line."},{name:"stretch",description:"If the cross size property of the flex item computes to auto, and neither of the cross-axis margins are auto, the flex item is stretched."},{name:"normal"},{name:"start"},{name:"end"},{name:"self-start"},{name:"self-end"},{name:"first baseline"},{name:"last baseline"},{name:"stretch"},{name:"safe"},{name:"unsafe"}],syntax:"normal | stretch | <baseline-position> | [ <overflow-position>? <self-position> ]",relevance:87,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/align-items"}],description:"Aligns flex items along the cross axis of the current line of the flex container.",restrictions:["enum"]},{name:"justify-items",browsers:["E12","FF20","S9","C52","IE11","O12.1"],values:[{name:"auto"},{name:"normal"},{name:"end"},{name:"start"},{name:"flex-end",description:'"Flex items are packed toward the end of the line."'},{name:"flex-start",description:'"Flex items are packed toward the start of the line."'},{name:"self-end",description:"The item is packed flush to the edge of the alignment container of the end side of the item, in the appropriate axis."},{name:"self-start",description:"The item is packed flush to the edge of the alignment container of the start side of the item, in the appropriate axis.."},{name:"center",description:"The items are packed flush to each other toward the center of the of the alignment container."},{name:"left"},{name:"right"},{name:"baseline"},{name:"first baseline"},{name:"last baseline"},{name:"stretch",description:"If the cross size property of the flex item computes to auto, and neither of the cross-axis margins are auto, the flex item is stretched."},{name:"safe"},{name:"unsafe"},{name:"legacy"}],syntax:"normal | stretch | <baseline-position> | <overflow-position>? [ <self-position> | left | right ] | legacy | legacy && [ left | right | center ]",relevance:53,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/justify-items"}],description:"Defines the default justify-self for all items of the box, giving them the default way of justifying each box along the appropriate axis",restrictions:["enum"]},{name:"justify-self",browsers:["E16","FF45","S10.1","C57","IE10","O44"],values:[{name:"auto"},{name:"normal"},{name:"end"},{name:"start"},{name:"flex-end",description:'"Flex items are packed toward the end of the line."'},{name:"flex-start",description:'"Flex items are packed toward the start of the line."'},{name:"self-end",description:"The item is packed flush to the edge of the alignment container of the end side of the item, in the appropriate axis."},{name:"self-start",description:"The item is packed flush to the edge of the alignment container of the start side of the item, in the appropriate axis.."},{name:"center",description:"The items are packed flush to each other toward the center of the of the alignment container."},{name:"left"},{name:"right"},{name:"baseline"},{name:"first baseline"},{name:"last baseline"},{name:"stretch",description:"If the cross size property of the flex item computes to auto, and neither of the cross-axis margins are auto, the flex item is stretched."},{name:"save"},{name:"unsave"}],syntax:"auto | normal | stretch | <baseline-position> | <overflow-position>? [ <self-position> | left | right ]",relevance:55,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/justify-self"}],description:"Defines the way of justifying a box inside its container along the appropriate axis.",restrictions:["enum"]},{name:"align-self",browsers:["E12","FF20","S9","C29","IE10","O12.1"],values:[{name:"auto",description:"Computes to the value of 'align-items' on the element's parent, or 'stretch' if the element has no parent. On absolutely positioned elements, it computes to itself."},{name:"normal"},{name:"self-end"},{name:"self-start"},{name:"baseline",description:"If the flex item's inline axis is the same as the cross axis, this value is identical to 'flex-start'. Otherwise, it participates in baseline alignment."},{name:"center",description:"The flex item's margin box is centered in the cross axis within the line."},{name:"flex-end",description:"The cross-end margin edge of the flex item is placed flush with the cross-end edge of the line."},{name:"flex-start",description:"The cross-start margin edge of the flex item is placed flush with the cross-start edge of the line."},{name:"stretch",description:"If the cross size property of the flex item computes to auto, and neither of the cross-axis margins are auto, the flex item is stretched."},{name:"baseline"},{name:"first baseline"},{name:"last baseline"},{name:"safe"},{name:"unsafe"}],syntax:"auto | normal | stretch | <baseline-position> | <overflow-position>? <self-position>",relevance:73,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/align-self"}],description:"Allows the default alignment along the cross axis to be overridden for individual flex items.",restrictions:["enum"]},{name:"all",browsers:["E79","FF27","S9.1","C37","O24"],values:[],syntax:"initial | inherit | unset | revert | revert-layer",relevance:53,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/all"}],description:"Shorthand that resets all properties except 'direction' and 'unicode-bidi'.",restrictions:["enum"]},{name:"alt",browsers:["S9"],values:[],relevance:50,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/alt"}],description:"Provides alternative text for assistive technology to replace the generated content of a ::before or ::after element.",restrictions:["string","enum"]},{name:"animation",browsers:["E12","FF16","S9","C43","IE10","O30"],values:[{name:"alternate",description:"The animation cycle iterations that are odd counts are played in the normal direction, and the animation cycle iterations that are even counts are played in a reverse direction."},{name:"alternate-reverse",description:"The animation cycle iterations that are odd counts are played in the reverse direction, and the animation cycle iterations that are even counts are played in a normal direction."},{name:"backwards",description:"The beginning property value (as defined in the first @keyframes at-rule) is applied before the animation is displayed, during the period defined by 'animation-delay'."},{name:"both",description:"Both forwards and backwards fill modes are applied."},{name:"forwards",description:"The final property value (as defined in the last @keyframes at-rule) is maintained after the animation completes."},{name:"infinite",description:"Causes the animation to repeat forever."},{name:"none",description:"No animation is performed"},{name:"normal",description:"Normal playback."},{name:"reverse",description:"All iterations of the animation are played in the reverse direction from the way they were specified."}],syntax:"<single-animation>#",relevance:82,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/animation"}],description:"Shorthand property combines six of the animation properties into a single property.",restrictions:["time","timing-function","enum","identifier","number"]},{name:"animation-delay",browsers:["E12","FF16","S9","C43","IE10","O30"],syntax:"<time>#",relevance:66,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/animation-delay"}],description:"Defines when the animation will start.",restrictions:["time"]},{name:"animation-direction",browsers:["E12","FF16","S9","C43","IE10","O30"],values:[{name:"alternate",description:"The animation cycle iterations that are odd counts are played in the normal direction, and the animation cycle iterations that are even counts are played in a reverse direction."},{name:"alternate-reverse",description:"The animation cycle iterations that are odd counts are played in the reverse direction, and the animation cycle iterations that are even counts are played in a normal direction."},{name:"normal",description:"Normal playback."},{name:"reverse",description:"All iterations of the animation are played in the reverse direction from the way they were specified."}],syntax:"<single-animation-direction>#",relevance:58,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/animation-direction"}],description:"Defines whether or not the animation should play in reverse on alternate cycles.",restrictions:["enum"]},{name:"animation-duration",browsers:["E12","FF16","S9","C43","IE10","O30"],syntax:"<time>#",relevance:72,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/animation-duration"}],description:"Defines the length of time that an animation takes to complete one cycle.",restrictions:["time"]},{name:"animation-fill-mode",browsers:["E12","FF16","S9","C43","IE10","O30"],values:[{name:"backwards",description:"The beginning property value (as defined in the first @keyframes at-rule) is applied before the animation is displayed, during the period defined by 'animation-delay'."},{name:"both",description:"Both forwards and backwards fill modes are applied."},{name:"forwards",description:"The final property value (as defined in the last @keyframes at-rule) is maintained after the animation completes."},{name:"none",description:"There is no change to the property value between the time the animation is applied and the time the animation begins playing or after the animation completes."}],syntax:"<single-animation-fill-mode>#",relevance:65,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/animation-fill-mode"}],description:"Defines what values are applied by the animation outside the time it is executing.",restrictions:["enum"]},{name:"animation-iteration-count",browsers:["E12","FF16","S9","C43","IE10","O30"],values:[{name:"infinite",description:"Causes the animation to repeat forever."}],syntax:"<single-animation-iteration-count>#",relevance:64,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/animation-iteration-count"}],description:"Defines the number of times an animation cycle is played. The default value is one, meaning the animation will play from beginning to end once.",restrictions:["number","enum"]},{name:"animation-name",browsers:["E12","FF16","S9","C43","IE10","O30"],values:[{name:"none",description:"No animation is performed"}],syntax:"[ none | <keyframes-name> ]#",relevance:72,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/animation-name"}],description:"Defines a list of animations that apply. Each name is used to select the keyframe at-rule that provides the property values for the animation.",restrictions:["identifier","enum"]},{name:"animation-play-state",browsers:["E12","FF16","S9","C43","IE10","O30"],values:[{name:"paused",description:"A running animation will be paused."},{name:"running",description:"Resume playback of a paused animation."}],syntax:"<single-animation-play-state>#",relevance:55,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/animation-play-state"}],description:"Defines whether the animation is running or paused.",restrictions:["enum"]},{name:"animation-timing-function",browsers:["E12","FF16","S9","C43","IE10","O30"],syntax:"<easing-function>#",relevance:71,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/animation-timing-function"}],description:"Describes how the animation will progress over one cycle of its duration.",restrictions:["timing-function"]},{name:"backface-visibility",browsers:["E12","FF16","S15.4","C36","IE10","O23"],values:[{name:"hidden",description:"Back side is hidden."},{name:"visible",description:"Back side is visible."}],syntax:"visible | hidden",relevance:60,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/backface-visibility"}],description:"Determines whether or not the 'back' side of a transformed element is visible when facing the viewer. With an identity transform, the front side of an element faces the viewer.",restrictions:["enum"]},{name:"background",browsers:["E12","FF1","S1","C1","IE4","O3.5"],values:[{name:"fixed",description:"The background is fixed with regard to the viewport. In paged media where there is no viewport, a 'fixed' background is fixed with respect to the page box and therefore replicated on every page."},{name:"local",description:"The background is fixed with regard to the element's contents: if the element has a scrolling mechanism, the background scrolls with the element's contents."},{name:"none",description:"A value of 'none' counts as an image layer but draws nothing."},{name:"scroll",description:"The background is fixed with regard to the element itself and does not scroll with its contents. (It is effectively attached to the element's border.)"}],syntax:"[ <bg-layer> , ]* <final-bg-layer>",relevance:93,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/background"}],description:"Shorthand property for setting most background properties at the same place in the style sheet.",restrictions:["enum","image","color","position","length","repeat","percentage","box"]},{name:"background-attachment",browsers:["E12","FF1","S1","C1","IE4","O3.5"],values:[{name:"fixed",description:"The background is fixed with regard to the viewport. In paged media where there is no viewport, a 'fixed' background is fixed with respect to the page box and therefore replicated on every page."},{name:"local",browsers:["E12","FF1","S1","C1","IE4","O3.5"],description:"The background is fixed with regard to the element's contents: if the element has a scrolling mechanism, the background scrolls with the element's contents."},{name:"scroll",description:"The background is fixed with regard to the element itself and does not scroll with its contents. (It is effectively attached to the element's border.)"}],syntax:"<attachment>#",relevance:54,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/background-attachment"}],description:"Specifies whether the background images are fixed with regard to the viewport ('fixed') or scroll along with the element ('scroll') or its contents ('local').",restrictions:["enum"]},{name:"background-blend-mode",browsers:["E79","FF30","S8","C35","O22"],values:[{name:"normal",description:"Default attribute which specifies no blending"},{name:"multiply",description:"The source color is multiplied by the destination color and replaces the destination."},{name:"screen",description:"Multiplies the complements of the backdrop and source color values, then complements the result."},{name:"overlay",description:"Multiplies or screens the colors, depending on the backdrop color value."},{name:"darken",description:"Selects the darker of the backdrop and source colors."},{name:"lighten",description:"Selects the lighter of the backdrop and source colors."},{name:"color-dodge",description:"Brightens the backdrop color to reflect the source color."},{name:"color-burn",description:"Darkens the backdrop color to reflect the source color."},{name:"hard-light",description:"Multiplies or screens the colors, depending on the source color value."},{name:"soft-light",description:"Darkens or lightens the colors, depending on the source color value."},{name:"difference",description:"Subtracts the darker of the two constituent colors from the lighter color.."},{name:"exclusion",description:"Produces an effect similar to that of the Difference mode but lower in contrast."},{name:"hue",browsers:["E79","FF30","S8","C35","O22"],description:"Creates a color with the hue of the source color and the saturation and luminosity of the backdrop color."},{name:"saturation",browsers:["E79","FF30","S8","C35","O22"],description:"Creates a color with the saturation of the source color and the hue and luminosity of the backdrop color."},{name:"color",browsers:["E79","FF30","S8","C35","O22"],description:"Creates a color with the hue and saturation of the source color and the luminosity of the backdrop color."},{name:"luminosity",browsers:["E79","FF30","S8","C35","O22"],description:"Creates a color with the luminosity of the source color and the hue and saturation of the backdrop color."}],syntax:"<blend-mode>#",relevance:52,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/background-blend-mode"}],description:"Defines the blending mode of each background layer.",restrictions:["enum"]},{name:"background-clip",browsers:["E12","FF4","S5","C1","IE9","O10.5"],syntax:"<box>#",relevance:69,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/background-clip"}],description:"Determines the background painting area.",restrictions:["box"]},{name:"background-color",browsers:["E12","FF1","S1","C1","IE4","O3.5"],syntax:"<color>",relevance:94,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/background-color"}],description:"Sets the background color of an element.",restrictions:["color"]},{name:"background-image",browsers:["E12","FF1","S1","C1","IE4","O3.5"],values:[{name:"none",description:"Counts as an image layer but draws nothing."}],syntax:"<bg-image>#",relevance:88,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/background-image"}],description:"Sets the background image(s) of an element.",restrictions:["image","enum"]},{name:"background-origin",browsers:["E12","FF4","S3","C1","IE9","O10.5"],syntax:"<box>#",relevance:53,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/background-origin"}],description:"For elements rendered as a single box, specifies the background positioning area. For elements rendered as multiple boxes (e.g., inline boxes on several lines, boxes on several pages) specifies which boxes 'box-decoration-break' operates on to determine the background positioning area(s).",restrictions:["box"]},{name:"background-position",browsers:["E12","FF1","S1","C1","IE4","O3.5"],syntax:"<bg-position>#",relevance:87,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/background-position"}],description:"Specifies the initial position of the background image(s) (after any resizing) within their corresponding background positioning area.",restrictions:["position","length","percentage"]},{name:"background-position-x",browsers:["E12","FF49","S1","C1","IE6","O15"],values:[{name:"center",description:"Equivalent to '50%' ('left 50%') for the horizontal position if the horizontal position is not otherwise specified, or '50%' ('top 50%') for the vertical position if it is."},{name:"left",description:"Equivalent to '0%' for the horizontal position if one or two values are given, otherwise specifies the left edge as the origin for the next offset."},{name:"right",description:"Equivalent to '100%' for the horizontal position if one or two values are given, otherwise specifies the right edge as the origin for the next offset."}],syntax:"[ center | [ [ left | right | x-start | x-end ]? <length-percentage>? ]! ]#",relevance:55,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/background-position-x"}],description:"If background images have been specified, this property specifies their initial position (after any resizing) within their corresponding background positioning area.",restrictions:["length","percentage"]},{name:"background-position-y",browsers:["E12","FF49","S1","C1","IE6","O15"],values:[{name:"bottom",description:"Equivalent to '100%' for the vertical position if one or two values are given, otherwise specifies the bottom edge as the origin for the next offset."},{name:"center",description:"Equivalent to '50%' ('left 50%') for the horizontal position if the horizontal position is not otherwise specified, or '50%' ('top 50%') for the vertical position if it is."},{name:"top",description:"Equivalent to '0%' for the vertical position if one or two values are given, otherwise specifies the top edge as the origin for the next offset."}],syntax:"[ center | [ [ top | bottom | y-start | y-end ]? <length-percentage>? ]! ]#",relevance:53,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/background-position-y"}],description:"If background images have been specified, this property specifies their initial position (after any resizing) within their corresponding background positioning area.",restrictions:["length","percentage"]},{name:"background-repeat",browsers:["E12","FF1","S1","C1","IE4","O3.5"],values:[],syntax:"<repeat-style>#",relevance:85,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/background-repeat"}],description:"Specifies how background images are tiled after they have been sized and positioned.",restrictions:["repeat"]},{name:"background-size",browsers:["E12","FF4","S5","C3","IE9","O10"],values:[{name:"auto",description:"Resolved by using the image's intrinsic ratio and the size of the other dimension, or failing that, using the image's intrinsic size, or failing that, treating it as 100%."},{name:"contain",description:"Scale the image, while preserving its intrinsic aspect ratio (if any), to the largest size such that both its width and its height can fit inside the background positioning area."},{name:"cover",description:"Scale the image, while preserving its intrinsic aspect ratio (if any), to the smallest size such that both its width and its height can completely cover the background positioning area."}],syntax:"<bg-size>#",relevance:85,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/background-size"}],description:"Specifies the size of the background images.",restrictions:["length","percentage"]},{name:"behavior",browsers:["IE6"],relevance:50,description:"IE only. Used to extend behaviors of the browser.",restrictions:["url"]},{name:"block-size",browsers:["E79","FF41","S12.1","C57","O44"],values:[{name:"auto",description:"Depends on the values of other properties."}],syntax:"<'width'>",relevance:53,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/block-size"}],description:"Size of an element in the direction opposite that of the direction specified by 'writing-mode'.",restrictions:["length","percentage"]},{name:"border",browsers:["E12","FF1","S1","C1","IE4","O3.5"],syntax:"<line-width> || <line-style> || <color>",relevance:95,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/border"}],description:"Shorthand property for setting border width, style, and color.",restrictions:["length","line-width","line-style","color"]},{name:"border-block-end",browsers:["E79","FF41","S12.1","C69","O56"],syntax:"<'border-top-width'> || <'border-top-style'> || <color>",relevance:50,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/border-block-end"}],description:"Logical 'border-bottom'. Mapping depends on the parent element's 'writing-mode', 'direction', and 'text-orientation'.",restrictions:["length","line-width","line-style","color"]},{name:"border-block-start",browsers:["E79","FF41","S12.1","C69","O56"],syntax:"<'border-top-width'> || <'border-top-style'> || <color>",relevance:50,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/border-block-start"}],description:"Logical 'border-top'. Mapping depends on the parent element's 'writing-mode', 'direction', and 'text-orientation'.",restrictions:["length","line-width","line-style","color"]},{name:"border-block-end-color",browsers:["E79","FF41","S12.1","C69","O56"],syntax:"<'border-top-color'>",relevance:50,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/border-block-end-color"}],description:"Logical 'border-bottom-color'. Mapping depends on the parent element's 'writing-mode', 'direction', and 'text-orientation'.",restrictions:["color"]},{name:"border-block-start-color",browsers:["E79","FF41","S12.1","C69","O56"],syntax:"<'border-top-color'>",relevance:50,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/border-block-start-color"}],description:"Logical 'border-top-color'. Mapping depends on the parent element's 'writing-mode', 'direction', and 'text-orientation'.",restrictions:["color"]},{name:"border-block-end-style",browsers:["E79","FF41","S12.1","C69","O56"],syntax:"<'border-top-style'>",relevance:50,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/border-block-end-style"}],description:"Logical 'border-bottom-style'. Mapping depends on the parent element's 'writing-mode', 'direction', and 'text-orientation'.",restrictions:["line-style"]},{name:"border-block-start-style",browsers:["E79","FF41","S12.1","C69","O56"],syntax:"<'border-top-style'>",relevance:50,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/border-block-start-style"}],description:"Logical 'border-top-style'. Mapping depends on the parent element's 'writing-mode', 'direction', and 'text-orientation'.",restrictions:["line-style"]},{name:"border-block-end-width",browsers:["E79","FF41","S12.1","C69","O56"],syntax:"<'border-top-width'>",relevance:50,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/border-block-end-width"}],description:"Logical 'border-bottom-width'. Mapping depends on the parent element's 'writing-mode', 'direction', and 'text-orientation'.",restrictions:["length","line-width"]},{name:"border-block-start-width",browsers:["E79","FF41","S12.1","C69","O56"],syntax:"<'border-top-width'>",relevance:50,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/border-block-start-width"}],description:"Logical 'border-top-width'. Mapping depends on the parent element's 'writing-mode', 'direction', and 'text-orientation'.",restrictions:["length","line-width"]},{name:"border-bottom",browsers:["E12","FF1","S1","C1","IE4","O3.5"],syntax:"<line-width> || <line-style> || <color>",relevance:87,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/border-bottom"}],description:"Shorthand property for setting border width, style and color.",restrictions:["length","line-width","line-style","color"]},{name:"border-bottom-color",browsers:["E12","FF1","S1","C1","IE4","O3.5"],syntax:"<'border-top-color'>",relevance:70,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/border-bottom-color"}],description:"Sets the color of the bottom border.",restrictions:["color"]},{name:"border-bottom-left-radius",browsers:["E12","FF4","S5","C4","IE9","O10.5"],syntax:"<length-percentage>{1,2}",relevance:74,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/border-bottom-left-radius"}],description:"Defines the radii of the bottom left outer border edge.",restrictions:["length","percentage"]},{name:"border-bottom-right-radius",browsers:["E12","FF4","S5","C4","IE9","O10.5"],syntax:"<length-percentage>{1,2}",relevance:74,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/border-bottom-right-radius"}],description:"Defines the radii of the bottom right outer border edge.",restrictions:["length","percentage"]},{name:"border-bottom-style",browsers:["E12","FF1","S1","C1","IE5.5","O9.2"],syntax:"<line-style>",relevance:60,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/border-bottom-style"}],description:"Sets the style of the bottom border.",restrictions:["line-style"]},{name:"border-bottom-width",browsers:["E12","FF1","S1","C1","IE4","O3.5"],syntax:"<line-width>",relevance:65,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/border-bottom-width"}],description:"Sets the thickness of the bottom border.",restrictions:["length","line-width"]},{name:"border-collapse",browsers:["E12","FF1","S1.2","C1","IE5","O4"],values:[{name:"collapse",description:"Selects the collapsing borders model."},{name:"separate",description:"Selects the separated borders border model."}],syntax:"collapse | separate",relevance:71,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/border-collapse"}],description:"Selects a table's border model.",restrictions:["enum"]},{name:"border-color",browsers:["E12","FF1","S1","C1","IE4","O3.5"],values:[],syntax:"<color>{1,4}",relevance:86,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/border-color"}],description:"The color of the border around all four edges of an element.",restrictions:["color"]},{name:"border-image",browsers:["E12","FF15","S6","C16","IE11","O11"],values:[{name:"auto",description:"If 'auto' is specified then the border image width is the intrinsic width or height (whichever is applicable) of the corresponding image slice. If the image does not have the required intrinsic dimension then the corresponding border-width is used instead."},{name:"fill",description:"Causes the middle part of the border-image to be preserved."},{name:"none",description:"Use the border styles."},{name:"repeat",description:"The image is tiled (repeated) to fill the area."},{name:"round",description:"The image is tiled (repeated) to fill the area. If it does not fill the area with a whole number of tiles, the image is rescaled so that it does."},{name:"space",description:"The image is tiled (repeated) to fill the area. If it does not fill the area with a whole number of tiles, the extra space is distributed around the tiles."},{name:"stretch",description:"The image is stretched to fill the area."},{name:"url()"}],syntax:"<'border-image-source'> || <'border-image-slice'> [ / <'border-image-width'> | / <'border-image-width'>? / <'border-image-outset'> ]? || <'border-image-repeat'>",relevance:52,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/border-image"}],description:"Shorthand property for setting 'border-image-source', 'border-image-slice', 'border-image-width', 'border-image-outset' and 'border-image-repeat'. Omitted values are set to their initial values.",restrictions:["length","percentage","number","url","enum"]},{name:"border-image-outset",browsers:["E12","FF15","S6","C15","IE11","O15"],syntax:"[ <length> | <number> ]{1,4}",relevance:50,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/border-image-outset"}],description:"The values specify the amount by which the border image area extends beyond the border box on the top, right, bottom, and left sides respectively. If the fourth value is absent, it is the same as the second. If the third one is also absent, it is the same as the first. If the second one is also absent, it is the same as the first. Numbers represent multiples of the corresponding border-width.",restrictions:["length","number"]},{name:"border-image-repeat",browsers:["E12","FF15","S6","C15","IE11","O15"],values:[{name:"repeat",description:"The image is tiled (repeated) to fill the area."},{name:"round",description:"The image is tiled (repeated) to fill the area. If it does not fill the area with a whole number of tiles, the image is rescaled so that it does."},{name:"space",description:"The image is tiled (repeated) to fill the area. If it does not fill the area with a whole number of tiles, the extra space is distributed around the tiles."},{name:"stretch",description:"The image is stretched to fill the area."}],syntax:"[ stretch | repeat | round | space ]{1,2}",relevance:50,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/border-image-repeat"}],description:"Specifies how the images for the sides and the middle part of the border image are scaled and tiled. If the second keyword is absent, it is assumed to be the same as the first.",restrictions:["enum"]},{name:"border-image-slice",browsers:["E12","FF15","S6","C15","IE11","O15"],values:[{name:"fill",description:"Causes the middle part of the border-image to be preserved."}],syntax:"<number-percentage>{1,4} && fill?",relevance:50,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/border-image-slice"}],description:"Specifies inward offsets from the top, right, bottom, and left edges of the image, dividing it into nine regions: four corners, four edges and a middle.",restrictions:["number","percentage"]},{name:"border-image-source",browsers:["E12","FF15","S6","C15","IE11","O15"],values:[{name:"none",description:"Use the border styles."}],syntax:"none | <image>",relevance:50,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/border-image-source"}],description:"Specifies an image to use instead of the border styles given by the 'border-style' properties and as an additional background layer for the element. If the value is 'none' or if the image cannot be displayed, the border styles will be used.",restrictions:["image"]},{name:"border-image-width",browsers:["E12","FF13","S6","C15","IE11","O15"],values:[{name:"auto",description:"The border image width is the intrinsic width or height (whichever is applicable) of the corresponding image slice. If the image does not have the required intrinsic dimension then the corresponding border-width is used instead."}],syntax:"[ <length-percentage> | <number> | auto ]{1,4}",relevance:50,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/border-image-width"}],description:"The four values of 'border-image-width' specify offsets that are used to divide the border image area into nine parts. They represent inward distances from the top, right, bottom, and left sides of the area, respectively.",restrictions:["length","percentage","number"]},{name:"border-inline-end",browsers:["E79","FF41","S12.1","C69","O56"],syntax:"<'border-top-width'> || <'border-top-style'> || <color>",relevance:50,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/border-inline-end"}],description:"Logical 'border-right'. Mapping depends on the parent element's 'writing-mode', 'direction', and 'text-orientation'.",restrictions:["length","line-width","line-style","color"]},{name:"border-inline-start",browsers:["E79","FF41","S12.1","C69","O56"],syntax:"<'border-top-width'> || <'border-top-style'> || <color>",relevance:50,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/border-inline-start"}],description:"Logical 'border-left'. Mapping depends on the parent element's 'writing-mode', 'direction', and 'text-orientation'.",restrictions:["length","line-width","line-style","color"]},{name:"border-inline-end-color",browsers:["E79","FF41","S12.1","C69","O56"],syntax:"<'border-top-color'>",relevance:50,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/border-inline-end-color"}],description:"Logical 'border-right-color'. Mapping depends on the parent element's 'writing-mode', 'direction', and 'text-orientation'.",restrictions:["color"]},{name:"border-inline-start-color",browsers:["E79","FF41","S12.1","C69","O56"],syntax:"<'border-top-color'>",relevance:50,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/border-inline-start-color"}],description:"Logical 'border-left-color'. Mapping depends on the parent element's 'writing-mode', 'direction', and 'text-orientation'.",restrictions:["color"]},{name:"border-inline-end-style",browsers:["E79","FF41","S12.1","C69","O56"],syntax:"<'border-top-style'>",relevance:50,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/border-inline-end-style"}],description:"Logical 'border-right-style'. Mapping depends on the parent element's 'writing-mode', 'direction', and 'text-orientation'.",restrictions:["line-style"]},{name:"border-inline-start-style",browsers:["E79","FF41","S12.1","C69","O56"],syntax:"<'border-top-style'>",relevance:50,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/border-inline-start-style"}],description:"Logical 'border-left-style'. Mapping depends on the parent element's 'writing-mode', 'direction', and 'text-orientation'.",restrictions:["line-style"]},{name:"border-inline-end-width",browsers:["E79","FF41","S12.1","C69","O56"],syntax:"<'border-top-width'>",relevance:50,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/border-inline-end-width"}],description:"Logical 'border-right-width'. Mapping depends on the parent element's 'writing-mode', 'direction', and 'text-orientation'.",restrictions:["length","line-width"]},{name:"border-inline-start-width",browsers:["E79","FF41","S12.1","C69","O56"],syntax:"<'border-top-width'>",relevance:50,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/border-inline-start-width"}],description:"Logical 'border-left-width'. Mapping depends on the parent element's 'writing-mode', 'direction', and 'text-orientation'.",restrictions:["length","line-width"]},{name:"border-left",browsers:["E12","FF1","S1","C1","IE4","O3.5"],syntax:"<line-width> || <line-style> || <color>",relevance:81,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/border-left"}],description:"Shorthand property for setting border width, style and color",restrictions:["length","line-width","line-style","color"]},{name:"border-left-color",browsers:["E12","FF1","S1","C1","IE4","O3.5"],syntax:"<color>",relevance:67,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/border-left-color"}],description:"Sets the color of the left border.",restrictions:["color"]},{name:"border-left-style",browsers:["E12","FF1","S1","C1","IE5.5","O9.2"],syntax:"<line-style>",relevance:54,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/border-left-style"}],description:"Sets the style of the left border.",restrictions:["line-style"]},{name:"border-left-width",browsers:["E12","FF1","S1","C1","IE4","O3.5"],syntax:"<line-width>",relevance:63,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/border-left-width"}],description:"Sets the thickness of the left border.",restrictions:["length","line-width"]},{name:"border-radius",browsers:["E12","FF4","S5","C4","IE9","O10.5"],syntax:"<length-percentage>{1,4} [ / <length-percentage>{1,4} ]?",relevance:92,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/border-radius"}],description:"Defines the radii of the outer border edge.",restrictions:["length","percentage"]},{name:"border-right",browsers:["E12","FF1","S1","C1","IE5.5","O9.2"],syntax:"<line-width> || <line-style> || <color>",relevance:80,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/border-right"}],description:"Shorthand property for setting border width, style and color",restrictions:["length","line-width","line-style","color"]},{name:"border-right-color",browsers:["E12","FF1","S1","C1","IE4","O3.5"],syntax:"<color>",relevance:66,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/border-right-color"}],description:"Sets the color of the right border.",restrictions:["color"]},{name:"border-right-style",browsers:["E12","FF1","S1","C1","IE5.5","O9.2"],syntax:"<line-style>",relevance:53,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/border-right-style"}],description:"Sets the style of the right border.",restrictions:["line-style"]},{name:"border-right-width",browsers:["E12","FF1","S1","C1","IE4","O3.5"],syntax:"<line-width>",relevance:63,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/border-right-width"}],description:"Sets the thickness of the right border.",restrictions:["length","line-width"]},{name:"border-spacing",browsers:["E12","FF1","S1","C1","IE8","O4"],syntax:"<length> <length>?",relevance:67,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/border-spacing"}],description:"The lengths specify the distance that separates adjoining cell borders. If one length is specified, it gives both the horizontal and vertical spacing. If two are specified, the first gives the horizontal spacing and the second the vertical spacing. Lengths may not be negative.",restrictions:["length"]},{name:"border-style",browsers:["E12","FF1","S1","C1","IE4","O3.5"],values:[],syntax:"<line-style>{1,4}",relevance:79,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/border-style"}],description:"The style of the border around edges of an element.",restrictions:["line-style"]},{name:"border-top",browsers:["E12","FF1","S1","C1","IE4","O3.5"],syntax:"<line-width> || <line-style> || <color>",relevance:86,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/border-top"}],description:"Shorthand property for setting border width, style and color",restrictions:["length","line-width","line-style","color"]},{name:"border-top-color",browsers:["E12","FF1","S1","C1","IE4","O3.5"],syntax:"<color>",relevance:71,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/border-top-color"}],description:"Sets the color of the top border.",restrictions:["color"]},{name:"border-top-left-radius",browsers:["E12","FF4","S5","C4","IE9","O10.5"],syntax:"<length-percentage>{1,2}",relevance:75,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/border-top-left-radius"}],description:"Defines the radii of the top left outer border edge.",restrictions:["length","percentage"]},{name:"border-top-right-radius",browsers:["E12","FF4","S5","C4","IE9","O10.5"],syntax:"<length-percentage>{1,2}",relevance:75,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/border-top-right-radius"}],description:"Defines the radii of the top right outer border edge.",restrictions:["length","percentage"]},{name:"border-top-style",browsers:["E12","FF1","S1","C1","IE5.5","O9.2"],syntax:"<line-style>",relevance:58,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/border-top-style"}],description:"Sets the style of the top border.",restrictions:["line-style"]},{name:"border-top-width",browsers:["E12","FF1","S1","C1","IE4","O3.5"],syntax:"<line-width>",relevance:61,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/border-top-width"}],description:"Sets the thickness of the top border.",restrictions:["length","line-width"]},{name:"border-width",browsers:["E12","FF1","S1","C1","IE4","O3.5"],values:[],syntax:"<line-width>{1,4}",relevance:82,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/border-width"}],description:"Shorthand that sets the four 'border-*-width' properties. If it has four values, they set top, right, bottom and left in that order. If left is missing, it is the same as right; if bottom is missing, it is the same as top; if right is missing, it is the same as top.",restrictions:["length","line-width"]},{name:"bottom",browsers:["E12","FF1","S1","C1","IE5","O6"],values:[{name:"auto",description:"For non-replaced elements, the effect of this value depends on which of related properties have the value 'auto' as well"}],syntax:"<length> | <percentage> | auto",relevance:90,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/bottom"}],description:"Specifies how far an absolutely positioned box's bottom margin edge is offset above the bottom edge of the box's 'containing block'.",restrictions:["length","percentage"]},{name:"box-decoration-break",browsers:["E79","FF32","S7","C22","O15"],values:[{name:"clone",description:"Each box is independently wrapped with the border and padding."},{name:"slice",description:"The effect is as though the element were rendered with no breaks present, and then sliced by the breaks afterward."}],syntax:"slice | clone",relevance:50,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/box-decoration-break"}],description:"Specifies whether individual boxes are treated as broken pieces of one continuous box, or whether each box is individually wrapped with the border and padding.",restrictions:["enum"]},{name:"box-shadow",browsers:["E12","FF4","S5.1","C10","IE9","O10.5"],values:[{name:"inset",description:"Changes the drop shadow from an outer shadow (one that shadows the box onto the canvas, as if it were lifted above the canvas) to an inner shadow (one that shadows the canvas onto the box, as if the box were cut out of the canvas and shifted behind it)."},{name:"none",description:"No shadow."}],syntax:"none | <shadow>#",relevance:90,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/box-shadow"}],description:"Attaches one or more drop-shadows to the box. The property is a comma-separated list of shadows, each specified by 2-4 length values, an optional color, and an optional 'inset' keyword. Omitted lengths are 0; omitted colors are a user agent chosen color.",restrictions:["length","color","enum"]},{name:"box-sizing",browsers:["E12","FF29","S5.1","C10","IE8","O7"],values:[{name:"border-box",description:"The specified width and height (and respective min/max properties) on this element determine the border box of the element."},{name:"content-box",description:"Behavior of width and height as specified by CSS2.1. The specified width and height (and respective min/max properties) apply to the width and height respectively of the content box of the element."}],syntax:"content-box | border-box",relevance:92,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/box-sizing"}],description:"Specifies the behavior of the 'width' and 'height' properties.",restrictions:["enum"]},{name:"break-after",browsers:["E12","FF65","S10","C50","IE10","O37"],values:[{name:"always",description:"Always force a page break before/after the generated box."},{name:"auto",description:"Neither force nor forbid a page/column break before/after the principal box."},{name:"avoid",description:"Avoid a break before/after the principal box."},{name:"avoid-column",description:"Avoid a column break before/after the principal box."},{name:"avoid-page",description:"Avoid a page break before/after the principal box."},{name:"column",description:"Always force a column break before/after the principal box."},{name:"left",description:"Force one or two page breaks before/after the generated box so that the next page is formatted as a left page."},{name:"page",description:"Always force a page break before/after the principal box."},{name:"right",description:"Force one or two page breaks before/after the generated box so that the next page is formatted as a right page."}],syntax:"auto | avoid | always | all | avoid-page | page | left | right | recto | verso | avoid-column | column | avoid-region | region",relevance:50,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/break-after"}],description:"Describes the page/column/region break behavior after the generated box.",restrictions:["enum"]},{name:"break-before",browsers:["E12","FF65","S10","C50","IE10","O37"],values:[{name:"always",description:"Always force a page break before/after the generated box."},{name:"auto",description:"Neither force nor forbid a page/column break before/after the principal box."},{name:"avoid",description:"Avoid a break before/after the principal box."},{name:"avoid-column",description:"Avoid a column break before/after the principal box."},{name:"avoid-page",description:"Avoid a page break before/after the principal box."},{name:"column",description:"Always force a column break before/after the principal box."},{name:"left",description:"Force one or two page breaks before/after the generated box so that the next page is formatted as a left page."},{name:"page",description:"Always force a page break before/after the principal box."},{name:"right",description:"Force one or two page breaks before/after the generated box so that the next page is formatted as a right page."}],syntax:"auto | avoid | always | all | avoid-page | page | left | right | recto | verso | avoid-column | column | avoid-region | region",relevance:50,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/break-before"}],description:"Describes the page/column/region break behavior before the generated box.",restrictions:["enum"]},{name:"break-inside",browsers:["E12","FF65","S10","C50","IE10","O37"],values:[{name:"auto",description:"Impose no additional breaking constraints within the box."},{name:"avoid",description:"Avoid breaks within the box."},{name:"avoid-column",description:"Avoid a column break within the box."},{name:"avoid-page",description:"Avoid a page break within the box."}],syntax:"auto | avoid | avoid-page | avoid-column | avoid-region",relevance:51,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/break-inside"}],description:"Describes the page/column/region break behavior inside the principal box.",restrictions:["enum"]},{name:"caption-side",browsers:["E12","FF1","S1","C1","IE8","O4"],values:[{name:"bottom",description:"Positions the caption box below the table box."},{name:"top",description:"Positions the caption box above the table box."}],syntax:"top | bottom | block-start | block-end | inline-start | inline-end",relevance:52,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/caption-side"}],description:"Specifies the position of the caption box with respect to the table box.",restrictions:["enum"]},{name:"caret-color",browsers:["E79","FF53","S11.1","C57","O44"],values:[{name:"auto",description:"The user agent selects an appropriate color for the caret. This is generally currentcolor, but the user agent may choose a different color to ensure good visibility and contrast with the surrounding content, taking into account the value of currentcolor, the background, shadows, and other factors."}],syntax:"auto | <color>",relevance:53,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/caret-color"}],description:"Controls the color of the text insertion indicator.",restrictions:["color","enum"]},{name:"clear",browsers:["E12","FF1","S1","C1","IE4","O3.5"],values:[{name:"both",description:"The clearance of the generated box is set to the amount necessary to place the top border edge below the bottom outer edge of any right-floating and left-floating boxes that resulted from elements earlier in the source document."},{name:"left",description:"The clearance of the generated box is set to the amount necessary to place the top border edge below the bottom outer edge of any left-floating boxes that resulted from elements earlier in the source document."},{name:"none",description:"No constraint on the box's position with respect to floats."},{name:"right",description:"The clearance of the generated box is set to the amount necessary to place the top border edge below the bottom outer edge of any right-floating boxes that resulted from elements earlier in the source document."}],syntax:"none | left | right | both | inline-start | inline-end",relevance:83,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/clear"}],description:"Indicates which sides of an element's box(es) may not be adjacent to an earlier floating box. The 'clear' property does not consider floats inside the element itself or in other block formatting contexts.",restrictions:["enum"]},{name:"clip",browsers:["E12","FF1","S1","C1","IE4","O7"],values:[{name:"auto",description:"The element does not clip."},{name:"rect()",description:"Specifies offsets from the edges of the border box."}],syntax:"<shape> | auto",relevance:74,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/clip"}],description:"Deprecated. Use the 'clip-path' property when support allows. Defines the visible portion of an element's box.",restrictions:["enum"]},{name:"clip-path",browsers:["E79","FF3.5","S9.1","C55","IE10","O42"],values:[{name:"none",description:"No clipping path gets created."},{name:"url()",description:"References a <clipPath> element to create a clipping path."}],syntax:"<clip-source> | [ <basic-shape> || <geometry-box> ] | none",relevance:64,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/clip-path"}],description:"Specifies a clipping path where everything inside the path is visible and everything outside is clipped out.",restrictions:["url","shape","geometry-box","enum"]},{name:"clip-rule",browsers:["E80","FF72","S13.1","C80","O67"],values:[{name:"evenodd",description:"Determines the 'insideness' of a point on the canvas by drawing a ray from that point to infinity in any direction and counting the number of path segments from the given shape that the ray crosses."},{name:"nonzero",description:"Determines the 'insideness' of a point on the canvas by drawing a ray from that point to infinity in any direction and then examining the places where a segment of the shape crosses the ray."}],relevance:50,description:"Indicates the algorithm which is to be used to determine what parts of the canvas are included inside the shape.",restrictions:["enum"]},{name:"color",browsers:["E12","FF1","S1","C1","IE3","O3.5"],syntax:"<color>",relevance:94,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/color"}],description:"Sets the color of an element's text",restrictions:["color"]},{name:"color-interpolation-filters",browsers:["E80","FF72","S13.1","C80","O67"],values:[{name:"auto",description:"Color operations are not required to occur in a particular color space."},{name:"linearRGB",description:"Color operations should occur in the linearized RGB color space."},{name:"sRGB",description:"Color operations should occur in the sRGB color space."}],relevance:50,description:"Specifies the color space for imaging operations performed via filter effects.",restrictions:["enum"]},{name:"column-count",browsers:["E12","FF52","S9","C50","IE10","O11.1"],values:[{name:"auto",description:"Determines the number of columns by the 'column-width' property and the element width."}],syntax:"<integer> | auto",relevance:53,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/column-count"}],description:"Describes the optimal number of columns into which the content of the element will be flowed.",restrictions:["integer","enum"]},{name:"column-fill",browsers:["E12","FF52","S9","C50","IE10","O37"],values:[{name:"auto",description:"Fills columns sequentially."},{name:"balance",description:"Balance content equally between columns, if possible."}],syntax:"auto | balance | balance-all",relevance:50,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/column-fill"}],description:"In continuous media, this property will only be consulted if the length of columns has been constrained. Otherwise, columns will automatically be balanced.",restrictions:["enum"]},{name:"column-gap",browsers:["E12","FF1.5","S3","C1","IE10","O11.1"],values:[{name:"normal",description:"User agent specific and typically equivalent to 1em."}],syntax:"normal | <length-percentage>",relevance:60,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/column-gap"}],description:"Sets the gap between columns. If there is a column rule between columns, it will appear in the middle of the gap.",restrictions:["length","enum"]},{name:"column-rule",browsers:["E12","FF52","S9","C50","IE10","O11.1"],syntax:"<'column-rule-width'> || <'column-rule-style'> || <'column-rule-color'>",relevance:51,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/column-rule"}],description:"Shorthand for setting 'column-rule-width', 'column-rule-style', and 'column-rule-color' at the same place in the style sheet. Omitted values are set to their initial values.",restrictions:["length","line-width","line-style","color"]},{name:"column-rule-color",browsers:["E12","FF52","S9","C50","IE10","O11.1"],syntax:"<color>",relevance:50,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/column-rule-color"}],description:"Sets the color of the column rule",restrictions:["color"]},{name:"column-rule-style",browsers:["E12","FF52","S9","C50","IE10","O11.1"],syntax:"<'border-style'>",relevance:50,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/column-rule-style"}],description:"Sets the style of the rule between columns of an element.",restrictions:["line-style"]},{name:"column-rule-width",browsers:["E12","FF52","S9","C50","IE10","O11.1"],syntax:"<'border-width'>",relevance:50,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/column-rule-width"}],description:"Sets the width of the rule between columns. Negative values are not allowed.",restrictions:["length","line-width"]},{name:"columns",browsers:["E12","FF52","S9","C50","IE10","O11.1"],values:[{name:"auto",description:"The width depends on the values of other properties."}],syntax:"<'column-width'> || <'column-count'>",relevance:51,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/columns"}],description:"A shorthand property which sets both 'column-width' and 'column-count'.",restrictions:["length","integer","enum"]},{name:"column-span",browsers:["E12","FF71","S9","C50","IE10","O11.1"],values:[{name:"all",description:"The element spans across all columns. Content in the normal flow that appears before the element is automatically balanced across all columns before the element appear."},{name:"none",description:"The element does not span multiple columns."}],syntax:"none | all",relevance:50,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/column-span"}],description:"Describes the page/column break behavior after the generated box.",restrictions:["enum"]},{name:"column-width",browsers:["E12","FF50","S9","C50","IE10","O11.1"],values:[{name:"auto",description:"The width depends on the values of other properties."}],syntax:"<length> | auto",relevance:51,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/column-width"}],description:"Describes the width of columns in multicol elements.",restrictions:["length","enum"]},{name:"contain",browsers:["E79","FF69","S15.4","C52","O39"],values:[{name:"none",description:"Indicates that the property has no effect."},{name:"strict",description:"Turns on all forms of containment for the element."},{name:"content",description:"All containment rules except size are applied to the element."},{name:"size",description:"For properties that can have effects on more than just an element and its descendants, those effects don't escape the containing element."},{name:"layout",description:"Turns on layout containment for the element."},{name:"style",description:"Turns on style containment for the element."},{name:"paint",description:"Turns on paint containment for the element."}],syntax:"none | strict | content | [ [ size || inline-size ] || layout || style || paint ]",relevance:58,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/contain"}],description:"Indicates that an element and its contents are, as much as possible, independent of the rest of the document tree.",restrictions:["enum"]},{name:"content",browsers:["E12","FF1","S1","C1","IE8","O4"],values:[{name:"attr()",description:"The attr(n) function returns as a string the value of attribute n for the subject of the selector."},{name:"counter(name)",description:"Counters are denoted by identifiers (see the 'counter-increment' and 'counter-reset' properties)."},{name:"icon",description:"The (pseudo-)element is replaced in its entirety by the resource referenced by its 'icon' property, and treated as a replaced element."},{name:"none",description:"On elements, this inhibits the children of the element from being rendered as children of this element, as if the element was empty. On pseudo-elements it causes the pseudo-element to have no content."},{name:"normal",description:"See http://www.w3.org/TR/css3-content/#content for computation rules."},{name:"url()"}],syntax:"normal | none | [ <content-replacement> | <content-list> ] [/ [ <string> | <counter> ]+ ]?",relevance:89,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/content"}],description:"Determines which page-based occurrence of a given element is applied to a counter or string value.",restrictions:["string","url"]},{name:"counter-increment",browsers:["E12","FF1","S3","C2","IE8","O9.2"],values:[{name:"none",description:"This element does not alter the value of any counters."}],syntax:"[ <counter-name> <integer>? ]+ | none",relevance:54,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/counter-increment"}],description:"Manipulate the value of existing counters.",restrictions:["identifier","integer"]},{name:"counter-reset",browsers:["E12","FF1","S3","C2","IE8","O9.2"],values:[{name:"none",description:"The counter is not modified."}],syntax:"[ <counter-name> <integer>? | <reversed-counter-name> <integer>? ]+ | none",relevance:54,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/counter-reset"}],description:"Property accepts one or more names of counters (identifiers), each one optionally followed by an integer. The integer gives the value that the counter is set to on each occurrence of the element.",restrictions:["identifier","integer"]},{name:"cursor",browsers:["E12","FF1","S1.2","C1","IE4","O7"],values:[{name:"alias",description:"Indicates an alias of/shortcut to something is to be created. Often rendered as an arrow with a small curved arrow next to it."},{name:"all-scroll",description:"Indicates that the something can be scrolled in any direction. Often rendered as arrows pointing up, down, left, and right with a dot in the middle."},{name:"auto",description:"The UA determines the cursor to display based on the current context."},{name:"cell",description:"Indicates that a cell or set of cells may be selected. Often rendered as a thick plus-sign with a dot in the middle."},{name:"col-resize",description:"Indicates that the item/column can be resized horizontally. Often rendered as arrows pointing left and right with a vertical bar separating them."},{name:"context-menu",description:"A context menu is available for the object under the cursor. Often rendered as an arrow with a small menu-like graphic next to it."},{name:"copy",description:"Indicates something is to be copied. Often rendered as an arrow with a small plus sign next to it."},{name:"crosshair",description:"A simple crosshair (e.g., short line segments resembling a '+' sign). Often used to indicate a two dimensional bitmap selection mode."},{name:"default",description:"The platform-dependent default cursor. Often rendered as an arrow."},{name:"e-resize",description:"Indicates that east edge is to be moved."},{name:"ew-resize",description:"Indicates a bidirectional east-west resize cursor."},{name:"grab",browsers:["E12","FF1","S1.2","C1","IE4","O7"],description:"Indicates that something can be grabbed."},{name:"grabbing",browsers:["E12","FF1","S1.2","C1","IE4","O7"],description:"Indicates that something is being grabbed."},{name:"help",description:"Help is available for the object under the cursor. Often rendered as a question mark or a balloon."},{name:"move",description:"Indicates something is to be moved."},{name:"-moz-grab",browsers:["E12","FF1","S1.2","C1","IE4","O7"],description:"Indicates that something can be grabbed."},{name:"-moz-grabbing",browsers:["E12","FF1","S1.2","C1","IE4","O7"],description:"Indicates that something is being grabbed."},{name:"-moz-zoom-in",browsers:["E12","FF1","S1.2","C1","IE4","O7"],description:"Indicates that something can be zoomed (magnified) in."},{name:"-moz-zoom-out",browsers:["E12","FF1","S1.2","C1","IE4","O7"],description:"Indicates that something can be zoomed (magnified) out."},{name:"ne-resize",description:"Indicates that movement starts from north-east corner."},{name:"nesw-resize",description:"Indicates a bidirectional north-east/south-west cursor."},{name:"no-drop",description:"Indicates that the dragged item cannot be dropped at the current cursor location. Often rendered as a hand or pointer with a small circle with a line through it."},{name:"none",description:"No cursor is rendered for the element."},{name:"not-allowed",description:"Indicates that the requested action will not be carried out. Often rendered as a circle with a line through it."},{name:"n-resize",description:"Indicates that north edge is to be moved."},{name:"ns-resize",description:"Indicates a bidirectional north-south cursor."},{name:"nw-resize",description:"Indicates that movement starts from north-west corner."},{name:"nwse-resize",description:"Indicates a bidirectional north-west/south-east cursor."},{name:"pointer",description:"The cursor is a pointer that indicates a link."},{name:"progress",description:"A progress indicator. The program is performing some processing, but is different from 'wait' in that the user may still interact with the program. Often rendered as a spinning beach ball, or an arrow with a watch or hourglass."},{name:"row-resize",description:"Indicates that the item/row can be resized vertically. Often rendered as arrows pointing up and down with a horizontal bar separating them."},{name:"se-resize",description:"Indicates that movement starts from south-east corner."},{name:"s-resize",description:"Indicates that south edge is to be moved."},{name:"sw-resize",description:"Indicates that movement starts from south-west corner."},{name:"text",description:"Indicates text that may be selected. Often rendered as a vertical I-beam."},{name:"vertical-text",description:"Indicates vertical-text that may be selected. Often rendered as a horizontal I-beam."},{name:"wait",description:"Indicates that the program is busy and the user should wait. Often rendered as a watch or hourglass."},{name:"-webkit-grab",browsers:["E12","FF1","S1.2","C1","IE4","O7"],description:"Indicates that something can be grabbed."},{name:"-webkit-grabbing",browsers:["E12","FF1","S1.2","C1","IE4","O7"],description:"Indicates that something is being grabbed."},{name:"-webkit-zoom-in",browsers:["E12","FF1","S1.2","C1","IE4","O7"],description:"Indicates that something can be zoomed (magnified) in."},{name:"-webkit-zoom-out",browsers:["E12","FF1","S1.2","C1","IE4","O7"],description:"Indicates that something can be zoomed (magnified) out."},{name:"w-resize",description:"Indicates that west edge is to be moved."},{name:"zoom-in",browsers:["E12","FF1","S1.2","C1","IE4","O7"],description:"Indicates that something can be zoomed (magnified) in."},{name:"zoom-out",browsers:["E12","FF1","S1.2","C1","IE4","O7"],description:"Indicates that something can be zoomed (magnified) out."}],syntax:"[ [ <url> [ <x> <y> ]? , ]* [ auto | default | none | context-menu | help | pointer | progress | wait | cell | crosshair | text | vertical-text | alias | copy | move | no-drop | not-allowed | e-resize | n-resize | ne-resize | nw-resize | s-resize | se-resize | sw-resize | w-resize | ew-resize | ns-resize | nesw-resize | nwse-resize | col-resize | row-resize | all-scroll | zoom-in | zoom-out | grab | grabbing ] ]",relevance:91,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/cursor"}],description:"Allows control over cursor appearance in an element",restrictions:["url","number","enum"]},{name:"direction",browsers:["E12","FF1","S1","C2","IE5.5","O9.2"],values:[{name:"ltr",description:"Left-to-right direction."},{name:"rtl",description:"Right-to-left direction."}],syntax:"ltr | rtl",relevance:71,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/direction"}],description:"Specifies the inline base direction or directionality of any bidi paragraph, embedding, isolate, or override established by the box. Note: for HTML content use the 'dir' attribute and 'bdo' element rather than this property.",restrictions:["enum"]},{name:"display",browsers:["E12","FF1","S1","C1","IE4","O7"],values:[{name:"block",description:"The element generates a block-level box"},{name:"contents",browsers:["E12","FF1","S1","C1","IE4","O7"],description:"The element itself does not generate any boxes, but its children and pseudo-elements still generate boxes as normal."},{name:"flex",browsers:["E12","FF1","S1","C1","IE4","O7"],description:"The element generates a principal flex container box and establishes a flex formatting context."},{name:"flexbox",browsers:["E12","FF1","S1","C1","IE4","O7"],description:"The element lays out its contents using flow layout (block-and-inline layout). Standardized as 'flex'."},{name:"flow-root",browsers:["E12","FF1","S1","C1","IE4","O7"],description:"The element generates a block container box, and lays out its contents using flow layout."},{name:"grid",browsers:["E12","FF1","S1","C1","IE4","O7"],description:"The element generates a principal grid container box, and establishes a grid formatting context."},{name:"inline",description:"The element generates an inline-level box."},{name:"inline-block",description:"A block box, which itself is flowed as a single inline box, similar to a replaced element. The inside of an inline-block is formatted as a block box, and the box itself is formatted as an inline box."},{name:"inline-flex",browsers:["E12","FF1","S1","C1","IE4","O7"],description:"Inline-level flex container."},{name:"inline-flexbox",browsers:["E12","FF1","S1","C1","IE4","O7"],description:"Inline-level flex container. Standardized as 'inline-flex'"},{name:"inline-table",description:"Inline-level table wrapper box containing table box."},{name:"list-item",description:"One or more block boxes and one marker box."},{name:"-moz-box",browsers:["E12","FF1","S1","C1","IE4","O7"],description:"The element lays out its contents using flow layout (block-and-inline layout). Standardized as 'flex'."},{name:"-moz-deck",browsers:["E12","FF1","S1","C1","IE4","O7"]},{name:"-moz-grid",browsers:["E12","FF1","S1","C1","IE4","O7"]},{name:"-moz-grid-group",browsers:["E12","FF1","S1","C1","IE4","O7"]},{name:"-moz-grid-line",browsers:["E12","FF1","S1","C1","IE4","O7"]},{name:"-moz-groupbox",browsers:["E12","FF1","S1","C1","IE4","O7"]},{name:"-moz-inline-box",browsers:["E12","FF1","S1","C1","IE4","O7"],description:"Inline-level flex container. Standardized as 'inline-flex'"},{name:"-moz-inline-grid",browsers:["E12","FF1","S1","C1","IE4","O7"]},{name:"-moz-inline-stack",browsers:["E12","FF1","S1","C1","IE4","O7"]},{name:"-moz-marker",browsers:["E12","FF1","S1","C1","IE4","O7"]},{name:"-moz-popup",browsers:["E12","FF1","S1","C1","IE4","O7"]},{name:"-moz-stack",browsers:["E12","FF1","S1","C1","IE4","O7"]},{name:"-ms-flexbox",browsers:["E12","FF1","S1","C1","IE4","O7"],description:"The element lays out its contents using flow layout (block-and-inline layout). Standardized as 'flex'."},{name:"-ms-grid",browsers:["E12","FF1","S1","C1","IE4","O7"],description:"The element generates a principal grid container box, and establishes a grid formatting context."},{name:"-ms-inline-flexbox",browsers:["E12","FF1","S1","C1","IE4","O7"],description:"Inline-level flex container. Standardized as 'inline-flex'"},{name:"-ms-inline-grid",browsers:["E12","FF1","S1","C1","IE4","O7"],description:"Inline-level grid container."},{name:"none",description:"The element and its descendants generates no boxes."},{name:"ruby",description:"The element generates a principal ruby container box, and establishes a ruby formatting context."},{name:"ruby-base"},{name:"ruby-base-container"},{name:"ruby-text"},{name:"ruby-text-container"},{name:"run-in",browsers:["E12","FF1","S1","C1","IE4","O7"],description:"The element generates a run-in box. Run-in elements act like inlines or blocks, depending on the surrounding elements."},{name:"table",description:"The element generates a principal table wrapper box containing an additionally-generated table box, and establishes a table formatting context."},{name:"table-caption"},{name:"table-cell"},{name:"table-column"},{name:"table-column-group"},{name:"table-footer-group"},{name:"table-header-group"},{name:"table-row"},{name:"table-row-group"},{name:"-webkit-box",browsers:["E12","FF1","S1","C1","IE4","O7"],description:"The element lays out its contents using flow layout (block-and-inline layout). Standardized as 'flex'."},{name:"-webkit-flex",browsers:["E12","FF1","S1","C1","IE4","O7"],description:"The element lays out its contents using flow layout (block-and-inline layout)."},{name:"-webkit-inline-box",browsers:["E12","FF1","S1","C1","IE4","O7"],description:"Inline-level flex container. Standardized as 'inline-flex'"},{name:"-webkit-inline-flex",browsers:["E12","FF1","S1","C1","IE4","O7"],description:"Inline-level flex container."}],syntax:"[ <display-outside> || <display-inside> ] | <display-listitem> | <display-internal> | <display-box> | <display-legacy>",relevance:96,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/display"}],description:"In combination with 'float' and 'position', determines the type of box or boxes that are generated for an element.",restrictions:["enum"]},{name:"empty-cells",browsers:["E12","FF1","S1.2","C1","IE8","O4"],values:[{name:"hide",description:"No borders or backgrounds are drawn around/behind empty cells."},{name:"-moz-show-background",browsers:["E12","FF1","S1.2","C1","IE8","O4"]},{name:"show",description:"Borders and backgrounds are drawn around/behind empty cells (like normal cells)."}],syntax:"show | hide",relevance:51,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/empty-cells"}],description:"In the separated borders model, this property controls the rendering of borders and backgrounds around cells that have no visible content.",restrictions:["enum"]},{name:"enable-background",values:[{name:"accumulate",description:"If the ancestor container element has a property of new, then all graphics elements within the current container are rendered both on the parent's background image and onto the target."},{name:"new",description:"Create a new background image canvas. All children of the current container element can access the background, and they will be rendered onto both the parent's background image canvas in addition to the target device."}],relevance:50,description:"Deprecated. Use 'isolation' property instead when support allows. Specifies how the accumulation of the background image is managed.",restrictions:["integer","length","percentage","enum"]},{name:"fallback",browsers:["FF33"],atRule:"@counter-style",syntax:"<counter-style-name>",relevance:50,description:"@counter-style descriptor. Specifies a fallback counter style to be used when the current counter style can't create a representation for a given counter value.",restrictions:["identifier"]},{name:"fill",browsers:["E80","FF72","S13.1","C80","O67"],values:[{name:"url()",description:"A URL reference to a paint server element, which is an element that defines a paint server: 'hatch', 'linearGradient', 'mesh', 'pattern', 'radialGradient' and 'solidcolor'."},{name:"none",description:"No paint is applied in this layer."}],relevance:77,description:"Paints the interior of the given graphical element.",restrictions:["color","enum","url"]},{name:"fill-opacity",browsers:["E80","FF72","S13.1","C80","O67"],relevance:52,description:"Specifies the opacity of the painting operation used to paint the interior the current object.",restrictions:["number(0-1)"]},{name:"fill-rule",browsers:["E80","FF72","S13.1","C80","O67"],values:[{name:"evenodd",description:"Determines the 'insideness' of a point on the canvas by drawing a ray from that point to infinity in any direction and counting the number of path segments from the given shape that the ray crosses."},{name:"nonzero",description:"Determines the 'insideness' of a point on the canvas by drawing a ray from that point to infinity in any direction and then examining the places where a segment of the shape crosses the ray."}],relevance:51,description:"Indicates the algorithm (or winding rule) which is to be used to determine what parts of the canvas are included inside the shape.",restrictions:["enum"]},{name:"filter",browsers:["E12","FF35","S9.1","C53","O40"],values:[{name:"none",description:"No filter effects are applied."},{name:"blur()",description:"Applies a Gaussian blur to the input image."},{name:"brightness()",description:"Applies a linear multiplier to input image, making it appear more or less bright."},{name:"contrast()",description:"Adjusts the contrast of the input."},{name:"drop-shadow()",description:"Applies a drop shadow effect to the input image."},{name:"grayscale()",description:"Converts the input image to grayscale."},{name:"hue-rotate()",description:"Applies a hue rotation on the input image. "},{name:"invert()",description:"Inverts the samples in the input image."},{name:"opacity()",description:"Applies transparency to the samples in the input image."},{name:"saturate()",description:"Saturates the input image."},{name:"sepia()",description:"Converts the input image to sepia."},{name:"url()",browsers:["E12","FF35","S9.1","C53","O40"],description:"A filter reference to a <filter> element."}],syntax:"none | <filter-function-list>",relevance:70,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/filter"}],description:"Processes an element's rendering before it is displayed in the document, by applying one or more filter effects.",restrictions:["enum","url"]},{name:"flex",browsers:["E12","FF20","S9","C29","IE11","O12.1"],values:[{name:"auto",description:"Retrieves the value of the main size property as the used 'flex-basis'."},{name:"content",browsers:["E12","FF20","S9","C29","IE11","O12.1"],description:"Indicates automatic sizing, based on the flex item's content."},{name:"none",description:"Expands to '0 0 auto'."}],syntax:"none | [ <'flex-grow'> <'flex-shrink'>? || <'flex-basis'> ]",relevance:81,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/flex"}],description:"Specifies the components of a flexible length: the flex grow factor and flex shrink factor, and the flex basis.",restrictions:["length","number","percentage"]},{name:"flex-basis",browsers:["E12","FF22","S9","C29","IE11","O12.1"],values:[{name:"auto",description:"Retrieves the value of the main size property as the used 'flex-basis'."},{name:"content",browsers:["E12","FF22","S9","C29","IE11","O12.1"],description:"Indicates automatic sizing, based on the flex item's content."}],syntax:"content | <'width'>",relevance:70,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/flex-basis"}],description:"Sets the flex basis.",restrictions:["length","number","percentage"]},{name:"flex-direction",browsers:["E12","FF81","S9","C29","IE11","O12.1"],values:[{name:"column",description:"The flex container's main axis has the same orientation as the block axis of the current writing mode."},{name:"column-reverse",description:"Same as 'column', except the main-start and main-end directions are swapped."},{name:"row",description:"The flex container's main axis has the same orientation as the inline axis of the current writing mode."},{name:"row-reverse",description:"Same as 'row', except the main-start and main-end directions are swapped."}],syntax:"row | row-reverse | column | column-reverse",relevance:84,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/flex-direction"}],description:"Specifies how flex items are placed in the flex container, by setting the direction of the flex container's main axis.",restrictions:["enum"]},{name:"flex-flow",browsers:["E12","FF28","S9","C29","IE11","O12.1"],values:[{name:"column",description:"The flex container's main axis has the same orientation as the block axis of the current writing mode."},{name:"column-reverse",description:"Same as 'column', except the main-start and main-end directions are swapped."},{name:"nowrap",description:"The flex container is single-line."},{name:"row",description:"The flex container's main axis has the same orientation as the inline axis of the current writing mode."},{name:"row-reverse",description:"Same as 'row', except the main-start and main-end directions are swapped."},{name:"wrap",description:"The flexbox is multi-line."},{name:"wrap-reverse",description:"Same as 'wrap', except the cross-start and cross-end directions are swapped."}],syntax:"<'flex-direction'> || <'flex-wrap'>",relevance:64,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/flex-flow"}],description:"Specifies how flexbox items are placed in the flexbox.",restrictions:["enum"]},{name:"flex-grow",browsers:["E12","FF20","S9","C29","IE11","O12.1"],syntax:"<number>",relevance:77,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/flex-grow"}],description:"Sets the flex grow factor. Negative numbers are invalid.",restrictions:["number"]},{name:"flex-shrink",browsers:["E12","FF20","S9","C29","IE10","O12.1"],syntax:"<number>",relevance:76,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/flex-shrink"}],description:"Sets the flex shrink factor. Negative numbers are invalid.",restrictions:["number"]},{name:"flex-wrap",browsers:["E12","FF28","S9","C29","IE11","O17"],values:[{name:"nowrap",description:"The flex container is single-line."},{name:"wrap",description:"The flexbox is multi-line."},{name:"wrap-reverse",description:"Same as 'wrap', except the cross-start and cross-end directions are swapped."}],syntax:"nowrap | wrap | wrap-reverse",relevance:82,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/flex-wrap"}],description:"Controls whether the flex container is single-line or multi-line, and the direction of the cross-axis, which determines the direction new lines are stacked in.",restrictions:["enum"]},{name:"float",browsers:["E12","FF1","S1","C1","IE4","O7"],values:[{name:"inline-end",browsers:["E12","FF1","S1","C1","IE4","O7"],description:"A keyword indicating that the element must float on the end side of its containing block. That is the right side with ltr scripts, and the left side with rtl scripts."},{name:"inline-start",browsers:["E12","FF1","S1","C1","IE4","O7"],description:"A keyword indicating that the element must float on the start side of its containing block. That is the left side with ltr scripts, and the right side with rtl scripts."},{name:"left",description:"The element generates a block box that is floated to the left. Content flows on the right side of the box, starting at the top (subject to the 'clear' property)."},{name:"none",description:"The box is not floated."},{name:"right",description:"Similar to 'left', except the box is floated to the right, and content flows on the left side of the box, starting at the top."}],syntax:"left | right | none | inline-start | inline-end",relevance:89,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/float"}],description:"Specifies how a box should be floated. It may be set for any element, but only applies to elements that generate boxes that are not absolutely positioned.",restrictions:["enum"]},{name:"flood-color",browsers:["E12","FF3","S6","C5","IE","O15"],relevance:50,description:"Indicates what color to use to flood the current filter primitive subregion.",restrictions:["color"]},{name:"flood-opacity",browsers:["E12","FF3","S6","C5","IE","O15"],relevance:50,description:"Indicates what opacity to use to flood the current filter primitive subregion.",restrictions:["number(0-1)","percentage"]},{name:"font",browsers:["E12","FF1","S1","C1","IE3","O3.5"],values:[{name:"100",description:"Thin"},{name:"200",description:"Extra Light (Ultra Light)"},{name:"300",description:"Light"},{name:"400",description:"Normal"},{name:"500",description:"Medium"},{name:"600",description:"Semi Bold (Demi Bold)"},{name:"700",description:"Bold"},{name:"800",description:"Extra Bold (Ultra Bold)"},{name:"900",description:"Black (Heavy)"},{name:"bold",description:"Same as 700"},{name:"bolder",description:"Specifies the weight of the face bolder than the inherited value."},{name:"caption",description:"The font used for captioned controls (e.g., buttons, drop-downs, etc.)."},{name:"icon",description:"The font used to label icons."},{name:"italic",description:"Selects a font that is labeled 'italic', or, if that is not available, one labeled 'oblique'."},{name:"large"},{name:"larger"},{name:"lighter",description:"Specifies the weight of the face lighter than the inherited value."},{name:"medium"},{name:"menu",description:"The font used in menus (e.g., dropdown menus and menu lists)."},{name:"message-box",description:"The font used in dialog boxes."},{name:"normal",description:"Specifies a face that is not labeled as a small-caps font."},{name:"oblique",description:"Selects a font that is labeled 'oblique'."},{name:"small"},{name:"small-caps",description:"Specifies a font that is labeled as a small-caps font. If a genuine small-caps font is not available, user agents should simulate a small-caps font."},{name:"small-caption",description:"The font used for labeling small controls."},{name:"smaller"},{name:"status-bar",description:"The font used in window status bars."},{name:"x-large"},{name:"x-small"},{name:"xx-large"},{name:"xx-small"}],syntax:"[ [ <'font-style'> || <font-variant-css21> || <'font-weight'> || <'font-stretch'> ]? <'font-size'> [ / <'line-height'> ]? <'font-family'> ] | caption | icon | menu | message-box | small-caption | status-bar",relevance:83,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/font"}],description:"Shorthand property for setting 'font-style', 'font-variant', 'font-weight', 'font-size', 'line-height', and 'font-family', at the same place in the style sheet. The syntax of this property is based on a traditional typographical shorthand notation to set multiple properties related to fonts.",restrictions:["font"]},{name:"font-family",browsers:["E12","FF1","S1","C1","IE3","O3.5"],values:[{name:"system-ui, -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, Oxygen, Ubuntu, Cantarell, 'Open Sans', 'Helvetica Neue', sans-serif"},{name:"Arial, Helvetica, sans-serif"},{name:"Cambria, Cochin, Georgia, Times, 'Times New Roman', serif"},{name:"'Courier New', Courier, monospace"},{name:"cursive"},{name:"fantasy"},{name:"'Franklin Gothic Medium', 'Arial Narrow', Arial, sans-serif"},{name:"Georgia, 'Times New Roman', Times, serif"},{name:"'Gill Sans', 'Gill Sans MT', Calibri, 'Trebuchet MS', sans-serif"},{name:"Impact, Haettenschweiler, 'Arial Narrow Bold', sans-serif"},{name:"'Lucida Sans', 'Lucida Sans Regular', 'Lucida Grande', 'Lucida Sans Unicode', Geneva, Verdana, sans-serif"},{name:"monospace"},{name:"sans-serif"},{name:"'Segoe UI', Tahoma, Geneva, Verdana, sans-serif"},{name:"serif"},{name:"'Times New Roman', Times, serif"},{name:"'Trebuchet MS', 'Lucida Sans Unicode', 'Lucida Grande', 'Lucida Sans', Arial, sans-serif"},{name:"Verdana, Geneva, Tahoma, sans-serif"}],atRule:"@font-face",syntax:"<family-name>",relevance:93,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/font-family"}],description:"Specifies a prioritized list of font family names or generic family names. A user agent iterates through the list of family names until it matches an available font that contains a glyph for the character to be rendered.",restrictions:["font"]},{name:"font-feature-settings",browsers:["E15","FF34","S9.1","C48","IE10","O35"],values:[{name:'"aalt"',description:"Access All Alternates."},{name:'"abvf"',description:"Above-base Forms. Required in Khmer script."},{name:'"abvm"',description:"Above-base Mark Positioning. Required in Indic scripts."},{name:'"abvs"',description:"Above-base Substitutions. Required in Indic scripts."},{name:'"afrc"',description:"Alternative Fractions."},{name:'"akhn"',description:"Akhand. Required in most Indic scripts."},{name:'"blwf"',description:"Below-base Form. Required in a number of Indic scripts."},{name:'"blwm"',description:"Below-base Mark Positioning. Required in Indic scripts."},{name:'"blws"',description:"Below-base Substitutions. Required in Indic scripts."},{name:'"calt"',description:"Contextual Alternates."},{name:'"case"',description:"Case-Sensitive Forms. Applies only to European scripts; particularly prominent in Spanish-language setting."},{name:'"ccmp"',description:"Glyph Composition/Decomposition."},{name:'"cfar"',description:"Conjunct Form After Ro. Required in Khmer scripts."},{name:'"cjct"',description:"Conjunct Forms. Required in Indic scripts that show similarity to Devanagari."},{name:'"clig"',description:"Contextual Ligatures."},{name:'"cpct"',description:"Centered CJK Punctuation. Used primarily in Chinese fonts."},{name:'"cpsp"',description:"Capital Spacing. Should not be used in connecting scripts (e.g. most Arabic)."},{name:'"cswh"',description:"Contextual Swash."},{name:'"curs"',description:"Cursive Positioning. Can be used in any cursive script."},{name:'"c2pc"',description:"Petite Capitals From Capitals. Applies only to bicameral scripts."},{name:'"c2sc"',description:"Small Capitals From Capitals. Applies only to bicameral scripts."},{name:'"dist"',description:"Distances. Required in Indic scripts."},{name:'"dlig"',description:"Discretionary ligatures."},{name:'"dnom"',description:"Denominators."},{name:'"dtls"',description:"Dotless Forms. Applied to math formula layout."},{name:'"expt"',description:"Expert Forms. Applies only to Japanese."},{name:'"falt"',description:"Final Glyph on Line Alternates. Can be used in any cursive script."},{name:'"fin2"',description:"Terminal Form #2. Used only with the Syriac script."},{name:'"fin3"',description:"Terminal Form #3. Used only with the Syriac script."},{name:'"fina"',description:"Terminal Forms. Can be used in any alphabetic script."},{name:'"flac"',description:"Flattened ascent forms. Applied to math formula layout."},{name:'"frac"',description:"Fractions."},{name:'"fwid"',description:"Full Widths. Applies to any script which can use monospaced forms."},{name:'"half"',description:"Half Forms. Required in Indic scripts that show similarity to Devanagari."},{name:'"haln"',description:"Halant Forms. Required in Indic scripts."},{name:'"halt"',description:"Alternate Half Widths. Used only in CJKV fonts."},{name:'"hist"',description:"Historical Forms."},{name:'"hkna"',description:"Horizontal Kana Alternates. Applies only to fonts that support kana (hiragana and katakana)."},{name:'"hlig"',description:"Historical Ligatures."},{name:'"hngl"',description:"Hangul. Korean only."},{name:'"hojo"',description:"Hojo Kanji Forms (JIS X 0212-1990 Kanji Forms). Used only with Kanji script."},{name:'"hwid"',description:"Half Widths. Generally used only in CJKV fonts."},{name:'"init"',description:"Initial Forms. Can be used in any alphabetic script."},{name:'"isol"',description:"Isolated Forms. Can be used in any cursive script."},{name:'"ital"',description:"Italics. Applies mostly to Latin; note that many non-Latin fonts contain Latin as well."},{name:'"jalt"',description:"Justification Alternates. Can be used in any cursive script."},{name:'"jp78"',description:"JIS78 Forms. Applies only to Japanese."},{name:'"jp83"',description:"JIS83 Forms. Applies only to Japanese."},{name:'"jp90"',description:"JIS90 Forms. Applies only to Japanese."},{name:'"jp04"',description:"JIS2004 Forms. Applies only to Japanese."},{name:'"kern"',description:"Kerning."},{name:'"lfbd"',description:"Left Bounds."},{name:'"liga"',description:"Standard Ligatures."},{name:'"ljmo"',description:"Leading Jamo Forms. Required for Hangul script when Ancient Hangul writing system is supported."},{name:'"lnum"',description:"Lining Figures."},{name:'"locl"',description:"Localized Forms."},{name:'"ltra"',description:"Left-to-right glyph alternates."},{name:'"ltrm"',description:"Left-to-right mirrored forms."},{name:'"mark"',description:"Mark Positioning."},{name:'"med2"',description:"Medial Form #2. Used only with the Syriac script."},{name:'"medi"',description:"Medial Forms."},{name:'"mgrk"',description:"Mathematical Greek."},{name:'"mkmk"',description:"Mark to Mark Positioning."},{name:'"nalt"',description:"Alternate Annotation Forms."},{name:'"nlck"',description:"NLC Kanji Forms. Used only with Kanji script."},{name:'"nukt"',description:"Nukta Forms. Required in Indic scripts.."},{name:'"numr"',description:"Numerators."},{name:'"onum"',description:"Oldstyle Figures."},{name:'"opbd"',description:"Optical Bounds."},{name:'"ordn"',description:"Ordinals. Applies mostly to Latin script."},{name:'"ornm"',description:"Ornaments."},{name:'"palt"',description:"Proportional Alternate Widths. Used mostly in CJKV fonts."},{name:'"pcap"',description:"Petite Capitals."},{name:'"pkna"',description:"Proportional Kana. Generally used only in Japanese fonts."},{name:'"pnum"',description:"Proportional Figures."},{name:'"pref"',description:"Pre-base Forms. Required in Khmer and Myanmar (Burmese) scripts and southern Indic scripts that may display a pre-base form of Ra."},{name:'"pres"',description:"Pre-base Substitutions. Required in Indic scripts."},{name:'"pstf"',description:"Post-base Forms. Required in scripts of south and southeast Asia that have post-base forms for consonants eg: Gurmukhi, Malayalam, Khmer."},{name:'"psts"',description:"Post-base Substitutions."},{name:'"pwid"',description:"Proportional Widths."},{name:'"qwid"',description:"Quarter Widths. Generally used only in CJKV fonts."},{name:'"rand"',description:"Randomize."},{name:'"rclt"',description:"Required Contextual Alternates. May apply to any script, but is especially important for many styles of Arabic."},{name:'"rlig"',description:"Required Ligatures. Applies to Arabic and Syriac. May apply to some other scripts."},{name:'"rkrf"',description:"Rakar Forms. Required in Devanagari and Gujarati scripts."},{name:'"rphf"',description:"Reph Form. Required in Indic scripts. E.g. Devanagari, Kannada."},{name:'"rtbd"',description:"Right Bounds."},{name:'"rtla"',description:"Right-to-left alternates."},{name:'"rtlm"',description:"Right-to-left mirrored forms."},{name:'"ruby"',description:"Ruby Notation Forms. Applies only to Japanese."},{name:'"salt"',description:"Stylistic Alternates."},{name:'"sinf"',description:"Scientific Inferiors."},{name:'"size"',description:"Optical size."},{name:'"smcp"',description:"Small Capitals. Applies only to bicameral scripts."},{name:'"smpl"',description:"Simplified Forms. Applies only to Chinese and Japanese."},{name:'"ssty"',description:"Math script style alternates."},{name:'"stch"',description:"Stretching Glyph Decomposition."},{name:'"subs"',description:"Subscript."},{name:'"sups"',description:"Superscript."},{name:'"swsh"',description:"Swash. Does not apply to ideographic scripts."},{name:'"titl"',description:"Titling."},{name:'"tjmo"',description:"Trailing Jamo Forms. Required for Hangul script when Ancient Hangul writing system is supported."},{name:'"tnam"',description:"Traditional Name Forms. Applies only to Japanese."},{name:'"tnum"',description:"Tabular Figures."},{name:'"trad"',description:"Traditional Forms. Applies only to Chinese and Japanese."},{name:'"twid"',description:"Third Widths. Generally used only in CJKV fonts."},{name:'"unic"',description:"Unicase."},{name:'"valt"',description:"Alternate Vertical Metrics. Applies only to scripts with vertical writing modes."},{name:'"vatu"',description:"Vattu Variants. Used for Indic scripts. E.g. Devanagari."},{name:'"vert"',description:"Vertical Alternates. Applies only to scripts with vertical writing modes."},{name:'"vhal"',description:"Alternate Vertical Half Metrics. Used only in CJKV fonts."},{name:'"vjmo"',description:"Vowel Jamo Forms. Required for Hangul script when Ancient Hangul writing system is supported."},{name:'"vkna"',description:"Vertical Kana Alternates. Applies only to fonts that support kana (hiragana and katakana)."},{name:'"vkrn"',description:"Vertical Kerning."},{name:'"vpal"',description:"Proportional Alternate Vertical Metrics. Used mostly in CJKV fonts."},{name:'"vrt2"',description:"Vertical Alternates and Rotation. Applies only to scripts with vertical writing modes."},{name:'"zero"',description:"Slashed Zero."},{name:"normal",description:"No change in glyph substitution or positioning occurs."},{name:"off",description:"Disable feature."},{name:"on",description:"Enable feature."}],atRule:"@font-face",syntax:"normal | <feature-tag-value>#",relevance:57,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/font-feature-settings"}],description:"Provides low-level control over OpenType font features. It is intended as a way of providing access to font features that are not widely used but are needed for a particular use case.",restrictions:["string","integer"]},{name:"font-kerning",browsers:["E79","FF32","S9","C33","O20"],values:[{name:"auto",description:"Specifies that kerning is applied at the discretion of the user agent."},{name:"none",description:"Specifies that kerning is not applied."},{name:"normal",description:"Specifies that kerning is applied."}],syntax:"auto | normal | none",relevance:50,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/font-kerning"}],description:"Kerning is the contextual adjustment of inter-glyph spacing. This property controls metric kerning, kerning that utilizes adjustment data contained in the font.",restrictions:["enum"]},{name:"font-language-override",browsers:["FF34"],values:[{name:"normal",description:"Implies that when rendering with OpenType fonts the language of the document is used to infer the OpenType language system, used to select language specific features when rendering."}],syntax:"normal | <string>",relevance:50,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/font-language-override"}],description:"The value of 'normal' implies that when rendering with OpenType fonts the language of the document is used to infer the OpenType language system, used to select language specific features when rendering.",restrictions:["string"]},{name:"font-size",browsers:["E12","FF1","S1","C1","IE5.5","O7"],values:[{name:"large"},{name:"larger"},{name:"medium"},{name:"small"},{name:"smaller"},{name:"x-large"},{name:"x-small"},{name:"xx-large"},{name:"xx-small"}],syntax:"<absolute-size> | <relative-size> | <length-percentage>",relevance:94,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/font-size"}],description:"Indicates the desired height of glyphs from the font. For scalable fonts, the font-size is a scale factor applied to the EM unit of the font. (Note that certain glyphs may bleed outside their EM box.) For non-scalable fonts, the font-size is converted into absolute units and matched against the declared font-size of the font, using the same absolute coordinate space for both of the matched values.",restrictions:["length","percentage"]},{name:"font-size-adjust",browsers:["FF3","S16.4"],values:[{name:"none",description:"Do not preserve the font's x-height."}],syntax:"none | [ ex-height | cap-height | ch-width | ic-width | ic-height ]? [ from-font | <number> ]",relevance:50,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/font-size-adjust"}],description:"Preserves the readability of text when font fallback occurs by adjusting the font-size so that the x-height is the same regardless of the font used.",restrictions:["number"]},{name:"font-stretch",browsers:["E12","FF9","S11","C60","IE9","O47"],values:[{name:"condensed"},{name:"expanded"},{name:"extra-condensed"},{name:"extra-expanded"},{name:"narrower",browsers:["E12","FF9","S11","C60","IE9","O47"],description:"Indicates a narrower value relative to the width of the parent element."},{name:"normal"},{name:"semi-condensed"},{name:"semi-expanded"},{name:"ultra-condensed"},{name:"ultra-expanded"},{name:"wider",browsers:["E12","FF9","S11","C60","IE9","O47"],description:"Indicates a wider value relative to the width of the parent element."}],atRule:"@font-face",syntax:"<font-stretch-absolute>{1,2}",relevance:56,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/font-stretch"}],description:"Selects a normal, condensed, or expanded face from a font family.",restrictions:["enum"]},{name:"font-style",browsers:["E12","FF1","S1","C1","IE4","O7"],values:[{name:"italic",description:"Selects a font that is labeled as an 'italic' face, or an 'oblique' face if one is not"},{name:"normal",description:"Selects a face that is classified as 'normal'."},{name:"oblique",description:"Selects a font that is labeled as an 'oblique' face, or an 'italic' face if one is not."}],atRule:"@font-face",syntax:"normal | italic | oblique <angle>{0,2}",relevance:89,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/font-style"}],description:"Allows italic or oblique faces to be selected. Italic forms are generally cursive in nature while oblique faces are typically sloped versions of the regular face.",restrictions:["enum"]},{name:"font-synthesis",browsers:["E97","FF34","S9","C97","O83"],values:[{name:"none",description:"Disallow all synthetic faces."},{name:"style",description:"Allow synthetic italic faces."},{name:"weight",description:"Allow synthetic bold faces."}],syntax:"none | [ weight || style || small-caps || position]",relevance:50,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/font-synthesis"}],description:"Controls whether user agents are allowed to synthesize bold or oblique font faces when a font family lacks bold or italic faces.",restrictions:["enum"]},{name:"font-variant",browsers:["E12","FF1","S1","C1","IE4","O3.5"],values:[{name:"normal",description:"Specifies a face that is not labeled as a small-caps font."},{name:"small-caps",description:"Specifies a font that is labeled as a small-caps font. If a genuine small-caps font is not available, user agents should simulate a small-caps font."}],syntax:"normal | none | [ <common-lig-values> || <discretionary-lig-values> || <historical-lig-values> || <contextual-alt-values> || stylistic( <feature-value-name> ) || historical-forms || styleset( <feature-value-name># ) || character-variant( <feature-value-name># ) || swash( <feature-value-name> ) || ornaments( <feature-value-name> ) || annotation( <feature-value-name> ) || [ small-caps | all-small-caps | petite-caps | all-petite-caps | unicase | titling-caps ] || <numeric-figure-values> || <numeric-spacing-values> || <numeric-fraction-values> || ordinal || slashed-zero || <east-asian-variant-values> || <east-asian-width-values> || ruby ]",relevance:64,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/font-variant"}],description:"Specifies variant representations of the font",restrictions:["enum"]},{name:"font-variant-alternates",browsers:["E111","FF34","S9.1","C111","O97"],values:[{name:"annotation()",description:"Enables display of alternate annotation forms."},{name:"character-variant()",description:"Enables display of specific character variants."},{name:"historical-forms",description:"Enables display of historical forms."},{name:"normal",description:"None of the features are enabled."},{name:"ornaments()",description:"Enables replacement of default glyphs with ornaments, if provided in the font."},{name:"styleset()",description:"Enables display with stylistic sets."},{name:"stylistic()",description:"Enables display of stylistic alternates."},{name:"swash()",description:"Enables display of swash glyphs."}],syntax:"normal | [ stylistic( <feature-value-name> ) || historical-forms || styleset( <feature-value-name># ) || character-variant( <feature-value-name># ) || swash( <feature-value-name> ) || ornaments( <feature-value-name> ) || annotation( <feature-value-name> ) ]",relevance:50,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/font-variant-alternates"}],description:"For any given character, fonts can provide a variety of alternate glyphs in addition to the default glyph for that character. This property provides control over the selection of these alternate glyphs.",restrictions:["enum"]},{name:"font-variant-caps",browsers:["E79","FF34","S9.1","C52","O39"],values:[{name:"all-petite-caps",description:"Enables display of petite capitals for both upper and lowercase letters."},{name:"all-small-caps",description:"Enables display of small capitals for both upper and lowercase letters."},{name:"normal",description:"None of the features are enabled."},{name:"petite-caps",description:"Enables display of petite capitals."},{name:"small-caps",description:"Enables display of small capitals. Small-caps glyphs typically use the form of uppercase letters but are reduced to the size of lowercase letters."},{name:"titling-caps",description:"Enables display of titling capitals."},{name:"unicase",description:"Enables display of mixture of small capitals for uppercase letters with normal lowercase letters."}],syntax:"normal | small-caps | all-small-caps | petite-caps | all-petite-caps | unicase | titling-caps",relevance:50,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/font-variant-caps"}],description:"Specifies control over capitalized forms.",restrictions:["enum"]},{name:"font-variant-east-asian",browsers:["E79","FF34","S9.1","C63","O50"],values:[{name:"full-width",description:"Enables rendering of full-width variants."},{name:"jis04",description:"Enables rendering of JIS04 forms."},{name:"jis78",description:"Enables rendering of JIS78 forms."},{name:"jis83",description:"Enables rendering of JIS83 forms."},{name:"jis90",description:"Enables rendering of JIS90 forms."},{name:"normal",description:"None of the features are enabled."},{name:"proportional-width",description:"Enables rendering of proportionally-spaced variants."},{name:"ruby",description:"Enables display of ruby variant glyphs."},{name:"simplified",description:"Enables rendering of simplified forms."},{name:"traditional",description:"Enables rendering of traditional forms."}],syntax:"normal | [ <east-asian-variant-values> || <east-asian-width-values> || ruby ]",relevance:50,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/font-variant-east-asian"}],description:"Allows control of glyph substitute and positioning in East Asian text.",restrictions:["enum"]},{name:"font-variant-ligatures",browsers:["E79","FF34","S9.1","C34","O21"],values:[{name:"additional-ligatures",description:"Enables display of additional ligatures."},{name:"common-ligatures",description:"Enables display of common ligatures."},{name:"contextual",browsers:["E79","FF34","S9.1","C34","O21"],description:"Enables display of contextual alternates."},{name:"discretionary-ligatures",description:"Enables display of discretionary ligatures."},{name:"historical-ligatures",description:"Enables display of historical ligatures."},{name:"no-additional-ligatures",description:"Disables display of additional ligatures."},{name:"no-common-ligatures",description:"Disables display of common ligatures."},{name:"no-contextual",browsers:["E79","FF34","S9.1","C34","O21"],description:"Disables display of contextual alternates."},{name:"no-discretionary-ligatures",description:"Disables display of discretionary ligatures."},{name:"no-historical-ligatures",description:"Disables display of historical ligatures."},{name:"none",browsers:["E79","FF34","S9.1","C34","O21"],description:"Disables all ligatures."},{name:"normal",description:"Implies that the defaults set by the font are used."}],syntax:"normal | none | [ <common-lig-values> || <discretionary-lig-values> || <historical-lig-values> || <contextual-alt-values> ]",relevance:52,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/font-variant-ligatures"}],description:"Specifies control over which ligatures are enabled or disabled. A value of 'normal' implies that the defaults set by the font are used.",restrictions:["enum"]},{name:"font-variant-numeric",browsers:["E79","FF34","S9.1","C52","O39"],values:[{name:"diagonal-fractions",description:"Enables display of lining diagonal fractions."},{name:"lining-nums",description:"Enables display of lining numerals."},{name:"normal",description:"None of the features are enabled."},{name:"oldstyle-nums",description:"Enables display of old-style numerals."},{name:"ordinal",description:"Enables display of letter forms used with ordinal numbers."},{name:"proportional-nums",description:"Enables display of proportional numerals."},{name:"slashed-zero",description:"Enables display of slashed zeros."},{name:"stacked-fractions",description:"Enables display of lining stacked fractions."},{name:"tabular-nums",description:"Enables display of tabular numerals."}],syntax:"normal | [ <numeric-figure-values> || <numeric-spacing-values> || <numeric-fraction-values> || ordinal || slashed-zero ]",relevance:51,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/font-variant-numeric"}],description:"Specifies control over numerical forms.",restrictions:["enum"]},{name:"font-variant-position",browsers:["E117","FF34","S9.1","C117","O103"],values:[{name:"normal",description:"None of the features are enabled."},{name:"sub",description:"Enables display of subscript variants (OpenType feature: subs)."},{name:"super",description:"Enables display of superscript variants (OpenType feature: sups)."}],syntax:"normal | sub | super",relevance:50,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/font-variant-position"}],description:"Specifies the vertical position",restrictions:["enum"]},{name:"font-weight",browsers:["E12","FF1","S1","C2","IE3","O3.5"],values:[{name:"100",description:"Thin"},{name:"200",description:"Extra Light (Ultra Light)"},{name:"300",description:"Light"},{name:"400",description:"Normal"},{name:"500",description:"Medium"},{name:"600",description:"Semi Bold (Demi Bold)"},{name:"700",description:"Bold"},{name:"800",description:"Extra Bold (Ultra Bold)"},{name:"900",description:"Black (Heavy)"},{name:"bold",description:"Same as 700"},{name:"bolder",description:"Specifies the weight of the face bolder than the inherited value."},{name:"lighter",description:"Specifies the weight of the face lighter than the inherited value."},{name:"normal",description:"Same as 400"}],atRule:"@font-face",syntax:"<font-weight-absolute>{1,2}",relevance:93,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/font-weight"}],description:"Specifies weight of glyphs in the font, their degree of blackness or stroke thickness.",restrictions:["enum"]},{name:"glyph-orientation-horizontal",relevance:50,description:"Controls glyph orientation when the inline-progression-direction is horizontal.",restrictions:["angle","number"]},{name:"glyph-orientation-vertical",browsers:["S13.1"],values:[{name:"auto",description:"Sets the orientation based on the fullwidth or non-fullwidth characters and the most common orientation."}],relevance:50,description:"Controls glyph orientation when the inline-progression-direction is vertical.",restrictions:["angle","number","enum"]},{name:"grid-area",browsers:["E16","FF52","S10.1","C57","O44"],values:[{name:"auto",description:"The property contributes nothing to the grid item's placement, indicating auto-placement, an automatic span, or a default span of one."},{name:"span",description:"Contributes a grid span to the grid item's placement such that the corresponding edge of the grid item's grid area is N lines from its opposite edge."}],syntax:"<grid-line> [ / <grid-line> ]{0,3}",relevance:57,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/grid-area"}],description:"Determine a grid item's size and location within the grid by contributing a line, a span, or nothing (automatic) to its grid placement. Shorthand for 'grid-row-start', 'grid-column-start', 'grid-row-end', and 'grid-column-end'.",restrictions:["identifier","integer"]},{name:"grid",browsers:["E16","FF52","S10.1","C57","O44"],syntax:"<'grid-template'> | <'grid-template-rows'> / [ auto-flow && dense? ] <'grid-auto-columns'>? | [ auto-flow && dense? ] <'grid-auto-rows'>? / <'grid-template-columns'>",relevance:50,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/grid"}],description:"The grid CSS property is a shorthand property that sets all of the explicit grid properties ('grid-template-rows', 'grid-template-columns', and 'grid-template-areas'), and all the implicit grid properties ('grid-auto-rows', 'grid-auto-columns', and 'grid-auto-flow'), in a single declaration.",restrictions:["identifier","length","percentage","string","enum"]},{name:"grid-auto-columns",browsers:["E16","FF70","S10.1","C57","IE10","O44"],values:[{name:"min-content",description:"Represents the largest min-content contribution of the grid items occupying the grid track."},{name:"max-content",description:"Represents the largest max-content contribution of the grid items occupying the grid track."},{name:"auto",description:"As a maximum, identical to 'max-content'. As a minimum, represents the largest minimum size (as specified by min-width/min-height) of the grid items occupying the grid track."},{name:"minmax()",description:"Defines a size range greater than or equal to min and less than or equal to max."}],syntax:"<track-size>+",relevance:51,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/grid-auto-columns"}],description:"Specifies the size of implicitly created columns.",restrictions:["length","percentage"]},{name:"grid-auto-flow",browsers:["E16","FF52","S10.1","C57","O44"],values:[{name:"row",description:"The auto-placement algorithm places items by filling each row in turn, adding new rows as necessary."},{name:"column",description:"The auto-placement algorithm places items by filling each column in turn, adding new columns as necessary."},{name:"dense",description:'If specified, the auto-placement algorithm uses a "dense" packing algorithm, which attempts to fill in holes earlier in the grid if smaller items come up later.'}],syntax:"[ row | column ] || dense",relevance:53,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/grid-auto-flow"}],description:"Controls how the auto-placement algorithm works, specifying exactly how auto-placed items get flowed into the grid.",restrictions:["enum"]},{name:"grid-auto-rows",browsers:["E16","FF70","S10.1","C57","IE10","O44"],values:[{name:"min-content",description:"Represents the largest min-content contribution of the grid items occupying the grid track."},{name:"max-content",description:"Represents the largest max-content contribution of the grid items occupying the grid track."},{name:"auto",description:"As a maximum, identical to 'max-content'. As a minimum, represents the largest minimum size (as specified by min-width/min-height) of the grid items occupying the grid track."},{name:"minmax()",description:"Defines a size range greater than or equal to min and less than or equal to max."}],syntax:"<track-size>+",relevance:52,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/grid-auto-rows"}],description:"Specifies the size of implicitly created rows.",restrictions:["length","percentage"]},{name:"grid-column",browsers:["E16","FF52","S10.1","C57","O44"],values:[{name:"auto",description:"The property contributes nothing to the grid item's placement, indicating auto-placement, an automatic span, or a default span of one."},{name:"span",description:"Contributes a grid span to the grid item's placement such that the corresponding edge of the grid item's grid area is N lines from its opposite edge."}],syntax:"<grid-line> [ / <grid-line> ]?",relevance:56,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/grid-column"}],description:"Shorthand for 'grid-column-start' and 'grid-column-end'.",restrictions:["identifier","integer","enum"]},{name:"grid-column-end",browsers:["E16","FF52","S10.1","C57","O44"],values:[{name:"auto",description:"The property contributes nothing to the grid item's placement, indicating auto-placement, an automatic span, or a default span of one."},{name:"span",description:"Contributes a grid span to the grid item's placement such that the corresponding edge of the grid item's grid area is N lines from its opposite edge."}],syntax:"<grid-line>",relevance:51,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/grid-column-end"}],description:"Determine a grid item's size and location within the grid by contributing a line, a span, or nothing (automatic) to its grid placement.",restrictions:["identifier","integer","enum"]},{name:"grid-column-gap",browsers:["FF52","C57","S10.1","O44"],status:"obsolete",syntax:"<length-percentage>",relevance:4,description:"Specifies the gutters between grid columns. Replaced by 'column-gap' property.",restrictions:["length"]},{name:"grid-column-start",browsers:["E16","FF52","S10.1","C57","O44"],values:[{name:"auto",description:"The property contributes nothing to the grid item's placement, indicating auto-placement, an automatic span, or a default span of one."},{name:"span",description:"Contributes a grid span to the grid item's placement such that the corresponding edge of the grid item's grid area is N lines from its opposite edge."}],syntax:"<grid-line>",relevance:51,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/grid-column-start"}],description:"Determine a grid item's size and location within the grid by contributing a line, a span, or nothing (automatic) to its grid placement.",restrictions:["identifier","integer","enum"]},{name:"grid-gap",browsers:["FF52","C57","S10.1","O44"],status:"obsolete",syntax:"<'grid-row-gap'> <'grid-column-gap'>?",relevance:5,description:"Shorthand that specifies the gutters between grid columns and grid rows in one declaration. Replaced by 'gap' property.",restrictions:["length"]},{name:"grid-row",browsers:["E16","FF52","S10.1","C57","O44"],values:[{name:"auto",description:"The property contributes nothing to the grid item's placement, indicating auto-placement, an automatic span, or a default span of one."},{name:"span",description:"Contributes a grid span to the grid item's placement such that the corresponding edge of the grid item's grid area is N lines from its opposite edge."}],syntax:"<grid-line> [ / <grid-line> ]?",relevance:54,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/grid-row"}],description:"Shorthand for 'grid-row-start' and 'grid-row-end'.",restrictions:["identifier","integer","enum"]},{name:"grid-row-end",browsers:["E16","FF52","S10.1","C57","O44"],values:[{name:"auto",description:"The property contributes nothing to the grid item's placement, indicating auto-placement, an automatic span, or a default span of one."},{name:"span",description:"Contributes a grid span to the grid item's placement such that the corresponding edge of the grid item's grid area is N lines from its opposite edge."}],syntax:"<grid-line>",relevance:51,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/grid-row-end"}],description:"Determine a grid item's size and location within the grid by contributing a line, a span, or nothing (automatic) to its grid placement.",restrictions:["identifier","integer","enum"]},{name:"grid-row-gap",browsers:["FF52","C57","S10.1","O44"],status:"obsolete",syntax:"<length-percentage>",relevance:2,description:"Specifies the gutters between grid rows. Replaced by 'row-gap' property.",restrictions:["length"]},{name:"grid-row-start",browsers:["E16","FF52","S10.1","C57","O44"],values:[{name:"auto",description:"The property contributes nothing to the grid item's placement, indicating auto-placement, an automatic span, or a default span of one."},{name:"span",description:"Contributes a grid span to the grid item's placement such that the corresponding edge of the grid item's grid area is N lines from its opposite edge."}],syntax:"<grid-line>",relevance:51,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/grid-row-start"}],description:"Determine a grid item's size and location within the grid by contributing a line, a span, or nothing (automatic) to its grid placement.",restrictions:["identifier","integer","enum"]},{name:"grid-template",browsers:["E16","FF52","S10.1","C57","O44"],values:[{name:"none",description:"Sets all three properties to their initial values."},{name:"min-content",description:"Represents the largest min-content contribution of the grid items occupying the grid track."},{name:"max-content",description:"Represents the largest max-content contribution of the grid items occupying the grid track."},{name:"auto",description:"As a maximum, identical to 'max-content'. As a minimum, represents the largest minimum size (as specified by min-width/min-height) of the grid items occupying the grid track."},{name:"subgrid",description:"Sets 'grid-template-rows' and 'grid-template-columns' to 'subgrid', and 'grid-template-areas' to its initial value."},{name:"minmax()",description:"Defines a size range greater than or equal to min and less than or equal to max."},{name:"repeat()",description:"Represents a repeated fragment of the track list, allowing a large number of columns or rows that exhibit a recurring pattern to be written in a more compact form."}],syntax:"none | [ <'grid-template-rows'> / <'grid-template-columns'> ] | [ <line-names>? <string> <track-size>? <line-names>? ]+ [ / <explicit-track-list> ]?",relevance:50,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/grid-template"}],description:"Shorthand for setting grid-template-columns, grid-template-rows, and grid-template-areas in a single declaration.",restrictions:["identifier","length","percentage","string","enum"]},{name:"grid-template-areas",browsers:["E16","FF52","S10.1","C57","O44"],values:[{name:"none",description:"The grid container doesn't define any named grid areas."}],syntax:"none | <string>+",relevance:54,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/grid-template-areas"}],description:"Specifies named grid areas, which are not associated with any particular grid item, but can be referenced from the grid-placement properties.",restrictions:["string"]},{name:"grid-template-columns",browsers:["E16","FF52","S10.1","C57","IE10","O44"],values:[{name:"none",description:"There is no explicit grid; any rows/columns will be implicitly generated."},{name:"min-content",description:"Represents the largest min-content contribution of the grid items occupying the grid track."},{name:"max-content",description:"Represents the largest max-content contribution of the grid items occupying the grid track."},{name:"auto",description:"As a maximum, identical to 'max-content'. As a minimum, represents the largest minimum size (as specified by min-width/min-height) of the grid items occupying the grid track."},{name:"subgrid",description:"Indicates that the grid will align to its parent grid in that axis."},{name:"minmax()",description:"Defines a size range greater than or equal to min and less than or equal to max."},{name:"repeat()",description:"Represents a repeated fragment of the track list, allowing a large number of columns or rows that exhibit a recurring pattern to be written in a more compact form."}],syntax:"none | <track-list> | <auto-track-list> | subgrid <line-name-list>?",relevance:64,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/grid-template-columns"}],description:"specifies, as a space-separated track list, the line names and track sizing functions of the grid.",restrictions:["identifier","length","percentage","enum"]},{name:"grid-template-rows",browsers:["E16","FF52","S10.1","C57","IE10","O44"],values:[{name:"none",description:"There is no explicit grid; any rows/columns will be implicitly generated."},{name:"min-content",description:"Represents the largest min-content contribution of the grid items occupying the grid track."},{name:"max-content",description:"Represents the largest max-content contribution of the grid items occupying the grid track."},{name:"auto",description:"As a maximum, identical to 'max-content'. As a minimum, represents the largest minimum size (as specified by min-width/min-height) of the grid items occupying the grid track."},{name:"subgrid",description:"Indicates that the grid will align to its parent grid in that axis."},{name:"minmax()",description:"Defines a size range greater than or equal to min and less than or equal to max."},{name:"repeat()",description:"Represents a repeated fragment of the track list, allowing a large number of columns or rows that exhibit a recurring pattern to be written in a more compact form."}],syntax:"none | <track-list> | <auto-track-list> | subgrid <line-name-list>?",relevance:57,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/grid-template-rows"}],description:"specifies, as a space-separated track list, the line names and track sizing functions of the grid.",restrictions:["identifier","length","percentage","string","enum"]},{name:"height",browsers:["E12","FF1","S1","C1","IE4","O7"],values:[{name:"auto",description:"The height depends on the values of other properties."},{name:"fit-content",browsers:["E12","FF1","S1","C1","IE4","O7"],description:"Use the fit-content inline size or fit-content block size, as appropriate to the writing mode."},{name:"max-content",browsers:["E12","FF1","S1","C1","IE4","O7"],description:"Use the max-content inline size or max-content block size, as appropriate to the writing mode."},{name:"min-content",browsers:["E12","FF1","S1","C1","IE4","O7"],description:"Use the min-content inline size or min-content block size, as appropriate to the writing mode."}],syntax:"auto | <length> | <percentage> | min-content | max-content | fit-content | fit-content(<length-percentage>)",relevance:96,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/height"}],description:"Specifies the height of the content area, padding area or border area (depending on 'box-sizing') of certain boxes.",restrictions:["length","percentage"]},{name:"hyphens",browsers:["E79","FF43","S17","C55","IE10","O42"],values:[{name:"auto",description:"Conditional hyphenation characters inside a word, if present, take priority over automatic resources when determining hyphenation points within the word."},{name:"manual",description:"Words are only broken at line breaks where there are characters inside the word that suggest line break opportunities"},{name:"none",description:"Words are not broken at line breaks, even if characters inside the word suggest line break points."}],syntax:"none | manual | auto",relevance:56,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/hyphens"}],description:"Controls whether hyphenation is allowed to create more break opportunities within a line of text.",restrictions:["enum"]},{name:"image-orientation",browsers:["E81","FF26","S13.1","C81","O67"],values:[{name:"flip",description:"After rotating by the precededing angle, the image is flipped horizontally. Defaults to 0deg if the angle is ommitted."},{name:"from-image",description:"If the image has an orientation specified in its metadata, such as EXIF, this value computes to the angle that the metadata specifies is necessary to correctly orient the image."}],syntax:"from-image | <angle> | [ <angle>? flip ]",relevance:50,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/image-orientation"}],description:"Specifies an orthogonal rotation to be applied to an image before it is laid out.",restrictions:["angle"]},{name:"image-rendering",browsers:["E79","FF3.6","S6","C13","O15"],values:[{name:"auto",description:"The image should be scaled with an algorithm that maximizes the appearance of the image."},{name:"crisp-edges",description:"The image must be scaled with an algorithm that preserves contrast and edges in the image, and which does not smooth colors or introduce blur to the image in the process."},{name:"-moz-crisp-edges",browsers:["E79","FF3.6","S6","C13","O15"]},{name:"optimizeQuality",description:"Deprecated."},{name:"optimizeSpeed",description:"Deprecated."},{name:"pixelated",description:"When scaling the image up, the 'nearest neighbor' or similar algorithm must be used, so that the image appears to be simply composed of very large pixels."}],syntax:"auto | crisp-edges | pixelated",relevance:54,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/image-rendering"}],description:"Provides a hint to the user-agent about what aspects of an image are most important to preserve when the image is scaled, to aid the user-agent in the choice of an appropriate scaling algorithm.",restrictions:["enum"]},{name:"ime-mode",browsers:["E12","FF3","IE5"],values:[{name:"active",description:"The input method editor is initially active; text entry is performed using it unless the user specifically dismisses it."},{name:"auto",description:"No change is made to the current input method editor state. This is the default."},{name:"disabled",description:"The input method editor is disabled and may not be activated by the user."},{name:"inactive",description:"The input method editor is initially inactive, but the user may activate it if they wish."},{name:"normal",description:"The IME state should be normal; this value can be used in a user style sheet to override the page setting."}],status:"obsolete",syntax:"auto | normal | active | inactive | disabled",relevance:0,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/ime-mode"}],description:"Controls the state of the input method editor for text fields.",restrictions:["enum"]},{name:"inline-size",browsers:["E79","FF41","S12.1","C57","O44"],values:[{name:"auto",description:"Depends on the values of other properties."}],syntax:"<'width'>",relevance:54,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/inline-size"}],description:"Size of an element in the direction specified by 'writing-mode'.",restrictions:["length","percentage"]},{name:"isolation",browsers:["E79","FF36","S8","C41","O30"],values:[{name:"auto",description:"Elements are not isolated unless an operation is applied that causes the creation of a stacking context."},{name:"isolate",description:"In CSS will turn the element into a stacking context."}],syntax:"auto | isolate",relevance:54,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/isolation"}],description:"In CSS setting to 'isolate' will turn the element into a stacking context. In SVG, it defines whether an element is isolated or not.",restrictions:["enum"]},{name:"justify-content",browsers:["E12","FF20","S9","C29","IE11","O12.1"],values:[{name:"center",description:"Flex items are packed toward the center of the line."},{name:"start",description:"The items are packed flush to each other toward the start edge of the alignment container in the main axis."},{name:"end",description:"The items are packed flush to each other toward the end edge of the alignment container in the main axis."},{name:"left",description:"The items are packed flush to each other toward the left edge of the alignment container in the main axis."},{name:"right",description:"The items are packed flush to each other toward the right edge of the alignment container in the main axis."},{name:"safe",description:"If the size of the item overflows the alignment container, the item is instead aligned as if the alignment mode were start."},{name:"unsafe",description:"Regardless of the relative sizes of the item and alignment container, the given alignment value is honored."},{name:"stretch",description:"If the combined size of the alignment subjects is less than the size of the alignment container, any auto-sized alignment subjects have their size increased equally (not proportionally), while still respecting the constraints imposed by max-height/max-width (or equivalent functionality), so that the combined size exactly fills the alignment container."},{name:"space-evenly",description:"The items are evenly distributed within the alignment container along the main axis."},{name:"flex-end",description:"Flex items are packed toward the end of the line."},{name:"flex-start",description:"Flex items are packed toward the start of the line."},{name:"space-around",description:"Flex items are evenly distributed in the line, with half-size spaces on either end."},{name:"space-between",description:"Flex items are evenly distributed in the line."},{name:"baseline",description:"Specifies participation in first-baseline alignment."},{name:"first baseline",description:"Specifies participation in first-baseline alignment."},{name:"last baseline",description:"Specifies participation in last-baseline alignment."}],syntax:"normal | <content-distribution> | <overflow-position>? [ <content-position> | left | right ]",relevance:87,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/justify-content"}],description:"Aligns flex items along the main axis of the current line of the flex container.",restrictions:["enum"]},{name:"kerning",values:[{name:"auto",description:"Indicates that the user agent should adjust inter-glyph spacing based on kerning tables that are included in the font that will be used."}],relevance:50,description:"Indicates whether the user agent should adjust inter-glyph spacing based on kerning tables that are included in the relevant font or instead disable auto-kerning and set inter-character spacing to a specific length.",restrictions:["length","enum"]},{name:"left",browsers:["E12","FF1","S1","C1","IE5.5","O5"],values:[{name:"auto",description:"For non-replaced elements, the effect of this value depends on which of related properties have the value 'auto' as well"}],syntax:"<length> | <percentage> | auto",relevance:94,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/left"}],description:"Specifies how far an absolutely positioned box's left margin edge is offset to the right of the left edge of the box's 'containing block'.",restrictions:["length","percentage"]},{name:"letter-spacing",browsers:["E12","FF1","S1","C1","IE4","O3.5"],values:[{name:"normal",description:"The spacing is the normal spacing for the current font. It is typically zero-length."}],syntax:"normal | <length>",relevance:81,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/letter-spacing"}],description:"Specifies the minimum, maximum, and optimal spacing between grapheme clusters.",restrictions:["length"]},{name:"lighting-color",browsers:["E12","FF3","S6","C5","IE","O15"],relevance:50,description:"Defines the color of the light source for filter primitives 'feDiffuseLighting' and 'feSpecularLighting'.",restrictions:["color"]},{name:"line-break",browsers:["E14","FF69","S11","C58","IE5.5","O45"],values:[{name:"auto",description:"The UA determines the set of line-breaking restrictions to use for CJK scripts, and it may vary the restrictions based on the length of the line; e.g., use a less restrictive set of line-break rules for short lines."},{name:"loose",description:"Breaks text using the least restrictive set of line-breaking rules. Typically used for short lines, such as in newspapers."},{name:"normal",description:"Breaks text using the most common set of line-breaking rules."},{name:"strict",description:"Breaks CJK scripts using a more restrictive set of line-breaking rules than 'normal'."},{name:"anywhere",description:"There is a soft wrap opportunity around every typographic character unit, including around any punctuation character or preserved white spaces, or in the middle of words, disregarding any prohibition against line breaks, even those introduced by characters with the GL, WJ, or ZWJ line breaking classes or mandated by the word-break property."}],syntax:"auto | loose | normal | strict | anywhere",relevance:52,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/line-break"}],description:"Specifies what set of line breaking restrictions are in effect within the element.",restrictions:["enum"]},{name:"line-height",browsers:["E12","FF1","S1","C1","IE4","O7"],values:[{name:"normal",description:"Tells user agents to set the computed value to a 'reasonable' value based on the font size of the element."}],syntax:"normal | <number> | <length> | <percentage>",relevance:92,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/line-height"}],description:"Determines the block-progression dimension of the text content area of an inline box.",restrictions:["number","length","percentage"]},{name:"list-style",browsers:["E12","FF1","S1","C1","IE4","O7"],values:[{name:"armenian"},{name:"circle",description:"A hollow circle."},{name:"decimal"},{name:"decimal-leading-zero"},{name:"disc",description:"A filled circle."},{name:"georgian"},{name:"inside",description:"The marker box is outside the principal block box, as described in the section on the ::marker pseudo-element below."},{name:"lower-alpha"},{name:"lower-greek"},{name:"lower-latin"},{name:"lower-roman"},{name:"none"},{name:"outside",description:"The ::marker pseudo-element is an inline element placed immediately before all ::before pseudo-elements in the principal block box, after which the element's content flows."},{name:"square",description:"A filled square."},{name:"symbols()",browsers:["E12","FF1","S1","C1","IE4","O7"],description:"Allows a counter style to be defined inline."},{name:"upper-alpha"},{name:"upper-latin"},{name:"upper-roman"},{name:"url()"}],syntax:"<'list-style-type'> || <'list-style-position'> || <'list-style-image'>",relevance:83,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/list-style"}],description:"Shorthand for setting 'list-style-type', 'list-style-position' and 'list-style-image'",restrictions:["image","enum","url"]},{name:"list-style-image",browsers:["E12","FF1","S1","C1","IE4","O7"],values:[{name:"none",description:"The default contents of the of the list item's marker are given by 'list-style-type' instead."}],syntax:"<image> | none",relevance:52,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/list-style-image"}],description:"Sets the image that will be used as the list item marker. When the image is available, it will replace the marker set with the 'list-style-type' marker.",restrictions:["image"]},{name:"list-style-position",browsers:["E12","FF1","S1","C1","IE4","O3.5"],values:[{name:"inside",description:"The marker box is outside the principal block box, as described in the section on the ::marker pseudo-element below."},{name:"outside",description:"The ::marker pseudo-element is an inline element placed immediately before all ::before pseudo-elements in the principal block box, after which the element's content flows."}],syntax:"inside | outside",relevance:55,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/list-style-position"}],description:"Specifies the position of the '::marker' pseudo-element's box in the list item.",restrictions:["enum"]},{name:"list-style-type",browsers:["E12","FF1","S1","C1","IE4","O3.5"],values:[{name:"armenian",description:"Traditional uppercase Armenian numbering."},{name:"circle",description:"A hollow circle."},{name:"decimal",description:"Western decimal numbers."},{name:"decimal-leading-zero",description:"Decimal numbers padded by initial zeros."},{name:"disc",description:"A filled circle."},{name:"georgian",description:"Traditional Georgian numbering."},{name:"lower-alpha",description:"Lowercase ASCII letters."},{name:"lower-greek",description:"Lowercase classical Greek."},{name:"lower-latin",description:"Lowercase ASCII letters."},{name:"lower-roman",description:"Lowercase ASCII Roman numerals."},{name:"none",description:"No marker"},{name:"square",description:"A filled square."},{name:"symbols()",browsers:["E12","FF1","S1","C1","IE4","O3.5"],description:"Allows a counter style to be defined inline."},{name:"upper-alpha",description:"Uppercase ASCII letters."},{name:"upper-latin",description:"Uppercase ASCII letters."},{name:"upper-roman",description:"Uppercase ASCII Roman numerals."}],syntax:"<counter-style> | <string> | none",relevance:73,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/list-style-type"}],description:"Used to construct the default contents of a list item's marker",restrictions:["enum","string"]},{name:"margin",browsers:["E12","FF1","S1","C1","IE3","O3.5"],values:[{name:"auto"}],syntax:"[ <length> | <percentage> | auto ]{1,4}",relevance:95,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/margin"}],description:"Shorthand property to set values for the thickness of the margin area. If left is omitted, it is the same as right. If bottom is omitted it is the same as top, if right is omitted it is the same as top. Negative values for margin properties are allowed, but there may be implementation-specific limits.",restrictions:["length","percentage"]},{name:"margin-block-end",browsers:["E79","FF41","S12.1","C69","O56"],values:[{name:"auto"}],syntax:"<'margin-left'>",relevance:55,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/margin-block-end"}],description:"Logical 'margin-bottom'. Mapping depends on the parent element's 'writing-mode', 'direction', and 'text-orientation'.",restrictions:["length","percentage"]},{name:"margin-block-start",browsers:["E79","FF41","S12.1","C69","O56"],values:[{name:"auto"}],syntax:"<'margin-left'>",relevance:56,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/margin-block-start"}],description:"Logical 'margin-top'. Mapping depends on the parent element's 'writing-mode', 'direction', and 'text-orientation'.",restrictions:["length","percentage"]},{name:"margin-bottom",browsers:["E12","FF1","S1","C1","IE3","O3.5"],values:[{name:"auto"}],syntax:"<length> | <percentage> | auto",relevance:91,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/margin-bottom"}],description:"Shorthand property to set values for the thickness of the margin area. If left is omitted, it is the same as right. If bottom is omitted it is the same as top, if right is omitted it is the same as top. Negative values for margin properties are allowed, but there may be implementation-specific limits..",restrictions:["length","percentage"]},{name:"margin-inline-end",browsers:["E79","FF41","S12.1","C69","O56"],values:[{name:"auto"}],syntax:"<'margin-left'>",relevance:58,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/margin-inline-end"}],description:"Logical 'margin-right'. Mapping depends on the parent element's 'writing-mode', 'direction', and 'text-orientation'.",restrictions:["length","percentage"]},{name:"margin-inline-start",browsers:["E79","FF41","S12.1","C69","O56"],values:[{name:"auto"}],syntax:"<'margin-left'>",relevance:59,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/margin-inline-start"}],description:"Logical 'margin-left'. Mapping depends on the parent element's 'writing-mode', 'direction', and 'text-orientation'.",restrictions:["length","percentage"]},{name:"margin-left",browsers:["E12","FF1","S1","C1","IE3","O3.5"],values:[{name:"auto"}],syntax:"<length> | <percentage> | auto",relevance:91,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/margin-left"}],description:"Shorthand property to set values for the thickness of the margin area. If left is omitted, it is the same as right. If bottom is omitted it is the same as top, if right is omitted it is the same as top. Negative values for margin properties are allowed, but there may be implementation-specific limits..",restrictions:["length","percentage"]},{name:"margin-right",browsers:["E12","FF1","S1","C1","IE3","O3.5"],values:[{name:"auto"}],syntax:"<length> | <percentage> | auto",relevance:91,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/margin-right"}],description:"Shorthand property to set values for the thickness of the margin area. If left is omitted, it is the same as right. If bottom is omitted it is the same as top, if right is omitted it is the same as top. Negative values for margin properties are allowed, but there may be implementation-specific limits..",restrictions:["length","percentage"]},{name:"margin-top",browsers:["E12","FF1","S1","C1","IE3","O3.5"],values:[{name:"auto"}],syntax:"<length> | <percentage> | auto",relevance:94,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/margin-top"}],description:"Shorthand property to set values for the thickness of the margin area. If left is omitted, it is the same as right. If bottom is omitted it is the same as top, if right is omitted it is the same as top. Negative values for margin properties are allowed, but there may be implementation-specific limits..",restrictions:["length","percentage"]},{name:"marker",browsers:["E80","FF72","S13.1","C80","O67"],values:[{name:"none",description:"Indicates that no marker symbol will be drawn at the given vertex or vertices."},{name:"url()",description:"Indicates that the <marker> element referenced will be used."}],relevance:50,description:"Specifies the marker symbol that shall be used for all points on the sets the value for all vertices on the given 'path' element or basic shape.",restrictions:["url"]},{name:"marker-end",browsers:["E80","FF72","S13.1","C80","O67"],values:[{name:"none",description:"Indicates that no marker symbol will be drawn at the given vertex or vertices."},{name:"url()",description:"Indicates that the <marker> element referenced will be used."}],relevance:50,description:"Specifies the marker that will be drawn at the last vertices of the given markable element.",restrictions:["url"]},{name:"marker-mid",browsers:["E80","FF72","S13.1","C80","O67"],values:[{name:"none",description:"Indicates that no marker symbol will be drawn at the given vertex or vertices."},{name:"url()",description:"Indicates that the <marker> element referenced will be used."}],relevance:50,description:"Specifies the marker that will be drawn at all vertices except the first and last.",restrictions:["url"]},{name:"marker-start",browsers:["E80","FF72","S13.1","C80","O67"],values:[{name:"none",description:"Indicates that no marker symbol will be drawn at the given vertex or vertices."},{name:"url()",description:"Indicates that the <marker> element referenced will be used."}],relevance:50,description:"Specifies the marker that will be drawn at the first vertices of the given markable element.",restrictions:["url"]},{name:"mask-image",browsers:["E79","FF53","S15.4","C120","O15"],values:[{name:"none",description:"Counts as a transparent black image layer."},{name:"url()",description:"Reference to a <mask element or to a CSS image."}],syntax:"<mask-reference>#",relevance:57,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/mask-image"}],description:"Sets the mask layer image of an element.",restrictions:["url","image","enum"]},{name:"mask-mode",browsers:["E120","FF53","S15.4","C120","O106"],values:[{name:"alpha",description:"Alpha values of the mask layer image should be used as the mask values."},{name:"auto",description:"Use alpha values if 'mask-image' is an image, luminance if a <mask> element or a CSS image."},{name:"luminance",description:"Luminance values of the mask layer image should be used as the mask values."}],syntax:"<masking-mode>#",relevance:50,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/mask-mode"}],description:"Indicates whether the mask layer image is treated as luminance mask or alpha mask.",restrictions:["url","image","enum"]},{name:"mask-origin",browsers:["E120","FF53","S15.4","C120","O106"],syntax:"<geometry-box>#",relevance:50,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/mask-origin"}],description:"Specifies the mask positioning area.",restrictions:["geometry-box","enum"]},{name:"mask-position",browsers:["E79","FF53","S15.4","C120","O106"],syntax:"<position>#",relevance:52,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/mask-position"}],description:"Specifies how mask layer images are positioned.",restrictions:["position","length","percentage"]},{name:"mask-repeat",browsers:["E79","FF53","S15.4","C120","O106"],syntax:"<repeat-style>#",relevance:53,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/mask-repeat"}],description:"Specifies how mask layer images are tiled after they have been sized and positioned.",restrictions:["repeat"]},{name:"mask-size",browsers:["E79","FF53","S15.4","C120","O106"],values:[{name:"auto",description:"Resolved by using the image's intrinsic ratio and the size of the other dimension, or failing that, using the image's intrinsic size, or failing that, treating it as 100%."},{name:"contain",description:"Scale the image, while preserving its intrinsic aspect ratio (if any), to the largest size such that both its width and its height can fit inside the background positioning area."},{name:"cover",description:"Scale the image, while preserving its intrinsic aspect ratio (if any), to the smallest size such that both its width and its height can completely cover the background positioning area."}],syntax:"<bg-size>#",relevance:54,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/mask-size"}],description:"Specifies the size of the mask layer images.",restrictions:["length","percentage","enum"]},{name:"mask-type",browsers:["E79","FF35","S7","C24","O15"],values:[{name:"alpha",description:"Indicates that the alpha values of the mask should be used."},{name:"luminance",description:"Indicates that the luminance values of the mask should be used."}],syntax:"luminance | alpha",relevance:50,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/mask-type"}],description:"Defines whether the content of the <mask> element is treated as as luminance mask or alpha mask.",restrictions:["enum"]},{name:"max-block-size",browsers:["E79","FF41","S12.1","C57","O44"],values:[{name:"none",description:"No limit on the width of the box."}],syntax:"<'max-width'>",relevance:53,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/max-block-size"}],description:"Maximum size of an element in the direction opposite that of the direction specified by 'writing-mode'.",restrictions:["length","percentage"]},{name:"max-height",browsers:["E12","FF1","S1.3","C18","IE7","O7"],values:[{name:"none",description:"No limit on the height of the box."},{name:"fit-content",browsers:["E12","FF1","S1.3","C18","IE7","O7"],description:"Use the fit-content inline size or fit-content block size, as appropriate to the writing mode."},{name:"max-content",browsers:["E12","FF1","S1.3","C18","IE7","O7"],description:"Use the max-content inline size or max-content block size, as appropriate to the writing mode."},{name:"min-content",browsers:["E12","FF1","S1.3","C18","IE7","O7"],description:"Use the min-content inline size or min-content block size, as appropriate to the writing mode."}],syntax:"none | <length-percentage> | min-content | max-content | fit-content | fit-content(<length-percentage>)",relevance:85,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/max-height"}],description:"Allows authors to constrain content height to a certain range.",restrictions:["length","percentage"]},{name:"max-inline-size",browsers:["E79","FF41","S12.1","C57","O44"],values:[{name:"none",description:"No limit on the height of the box."}],syntax:"<'max-width'>",relevance:54,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/max-inline-size"}],description:"Maximum size of an element in the direction specified by 'writing-mode'.",restrictions:["length","percentage"]},{name:"max-width",browsers:["E12","FF1","S1","C1","IE7","O4"],values:[{name:"none",description:"No limit on the width of the box."},{name:"fit-content",browsers:["E12","FF1","S1","C1","IE7","O4"],description:"Use the fit-content inline size or fit-content block size, as appropriate to the writing mode."},{name:"max-content",browsers:["E12","FF1","S1","C1","IE7","O4"],description:"Use the max-content inline size or max-content block size, as appropriate to the writing mode."},{name:"min-content",browsers:["E12","FF1","S1","C1","IE7","O4"],description:"Use the min-content inline size or min-content block size, as appropriate to the writing mode."}],syntax:"none | <length-percentage> | min-content | max-content | fit-content | fit-content(<length-percentage>)",relevance:91,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/max-width"}],description:"Allows authors to constrain content width to a certain range.",restrictions:["length","percentage"]},{name:"min-block-size",browsers:["E79","FF41","S12.1","C57","O44"],syntax:"<'min-width'>",relevance:53,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/min-block-size"}],description:"Minimal size of an element in the direction opposite that of the direction specified by 'writing-mode'.",restrictions:["length","percentage"]},{name:"min-height",browsers:["E12","FF3","S1.3","C1","IE7","O4"],values:[{name:"auto",browsers:["E12","FF3","S1.3","C1","IE7","O4"]},{name:"fit-content",browsers:["E12","FF3","S1.3","C1","IE7","O4"],description:"Use the fit-content inline size or fit-content block size, as appropriate to the writing mode."},{name:"max-content",browsers:["E12","FF3","S1.3","C1","IE7","O4"],description:"Use the max-content inline size or max-content block size, as appropriate to the writing mode."},{name:"min-content",browsers:["E12","FF3","S1.3","C1","IE7","O4"],description:"Use the min-content inline size or min-content block size, as appropriate to the writing mode."}],syntax:"auto | <length> | <percentage> | min-content | max-content | fit-content | fit-content(<length-percentage>)",relevance:89,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/min-height"}],description:"Allows authors to constrain content height to a certain range.",restrictions:["length","percentage"]},{name:"min-inline-size",browsers:["E79","FF41","S12.1","C57","O44"],syntax:"<'min-width'>",relevance:54,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/min-inline-size"}],description:"Minimal size of an element in the direction specified by 'writing-mode'.",restrictions:["length","percentage"]},{name:"min-width",browsers:["E12","FF1","S1","C1","IE7","O4"],values:[{name:"auto",browsers:["E12","FF1","S1","C1","IE7","O4"]},{name:"fit-content",browsers:["E12","FF1","S1","C1","IE7","O4"],description:"Use the fit-content inline size or fit-content block size, as appropriate to the writing mode."},{name:"max-content",browsers:["E12","FF1","S1","C1","IE7","O4"],description:"Use the max-content inline size or max-content block size, as appropriate to the writing mode."},{name:"min-content",browsers:["E12","FF1","S1","C1","IE7","O4"],description:"Use the min-content inline size or min-content block size, as appropriate to the writing mode."}],syntax:"auto | <length> | <percentage> | min-content | max-content | fit-content | fit-content(<length-percentage>)",relevance:88,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/min-width"}],description:"Allows authors to constrain content width to a certain range.",restrictions:["length","percentage"]},{name:"mix-blend-mode",browsers:["E79","FF32","S8","C41","O28"],values:[{name:"normal",description:"Default attribute which specifies no blending"},{name:"multiply",description:"The source color is multiplied by the destination color and replaces the destination."},{name:"screen",description:"Multiplies the complements of the backdrop and source color values, then complements the result."},{name:"overlay",description:"Multiplies or screens the colors, depending on the backdrop color value."},{name:"darken",description:"Selects the darker of the backdrop and source colors."},{name:"lighten",description:"Selects the lighter of the backdrop and source colors."},{name:"color-dodge",description:"Brightens the backdrop color to reflect the source color."},{name:"color-burn",description:"Darkens the backdrop color to reflect the source color."},{name:"hard-light",description:"Multiplies or screens the colors, depending on the source color value."},{name:"soft-light",description:"Darkens or lightens the colors, depending on the source color value."},{name:"difference",description:"Subtracts the darker of the two constituent colors from the lighter color.."},{name:"exclusion",description:"Produces an effect similar to that of the Difference mode but lower in contrast."},{name:"hue",browsers:["E79","FF32","S8","C41","O28"],description:"Creates a color with the hue of the source color and the saturation and luminosity of the backdrop color."},{name:"saturation",browsers:["E79","FF32","S8","C41","O28"],description:"Creates a color with the saturation of the source color and the hue and luminosity of the backdrop color."},{name:"color",browsers:["E79","FF32","S8","C41","O28"],description:"Creates a color with the hue and saturation of the source color and the luminosity of the backdrop color."},{name:"luminosity",browsers:["E79","FF32","S8","C41","O28"],description:"Creates a color with the luminosity of the source color and the hue and saturation of the backdrop color."}],syntax:"<blend-mode> | plus-lighter",relevance:54,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/mix-blend-mode"}],description:"Defines the formula that must be used to mix the colors with the backdrop.",restrictions:["enum"]},{name:"motion",browsers:["C46","O33"],values:[{name:"none",description:"No motion path gets created."},{name:"path()",description:"Defines an SVG path as a string, with optional 'fill-rule' as the first argument."},{name:"auto",description:"Indicates that the object is rotated by the angle of the direction of the motion path."},{name:"reverse",description:"Indicates that the object is rotated by the angle of the direction of the motion path plus 180 degrees."}],relevance:50,description:"Shorthand property for setting 'motion-path', 'motion-offset' and 'motion-rotation'.",restrictions:["url","length","percentage","angle","shape","geometry-box","enum"]},{name:"motion-offset",browsers:["C46","O33"],relevance:50,description:"A distance that describes the position along the specified motion path.",restrictions:["length","percentage"]},{name:"motion-path",browsers:["C46","O33"],values:[{name:"none",description:"No motion path gets created."},{name:"path()",description:"Defines an SVG path as a string, with optional 'fill-rule' as the first argument."}],relevance:50,description:"Specifies the motion path the element gets positioned at.",restrictions:["url","shape","geometry-box","enum"]},{name:"motion-rotation",browsers:["C46","O33"],values:[{name:"auto",description:"Indicates that the object is rotated by the angle of the direction of the motion path."},{name:"reverse",description:"Indicates that the object is rotated by the angle of the direction of the motion path plus 180 degrees."}],relevance:50,description:"Defines the direction of the element while positioning along the motion path.",restrictions:["angle"]},{name:"-moz-animation",browsers:["FF9"],values:[{name:"alternate",description:"The animation cycle iterations that are odd counts are played in the normal direction, and the animation cycle iterations that are even counts are played in a reverse direction."},{name:"alternate-reverse",description:"The animation cycle iterations that are odd counts are played in the reverse direction, and the animation cycle iterations that are even counts are played in a normal direction."},{name:"backwards",description:"The beginning property value (as defined in the first @keyframes at-rule) is applied before the animation is displayed, during the period defined by 'animation-delay'."},{name:"both",description:"Both forwards and backwards fill modes are applied."},{name:"forwards",description:"The final property value (as defined in the last @keyframes at-rule) is maintained after the animation completes."},{name:"infinite",description:"Causes the animation to repeat forever."},{name:"none",description:"No animation is performed"},{name:"normal",description:"Normal playback."},{name:"reverse",description:"All iterations of the animation are played in the reverse direction from the way they were specified."}],relevance:50,description:"Shorthand property combines six of the animation properties into a single property.",restrictions:["time","enum","timing-function","identifier","number"]},{name:"-moz-animation-delay",browsers:["FF9"],relevance:50,description:"Defines when the animation will start.",restrictions:["time"]},{name:"-moz-animation-direction",browsers:["FF9"],values:[{name:"alternate",description:"The animation cycle iterations that are odd counts are played in the normal direction, and the animation cycle iterations that are even counts are played in a reverse direction."},{name:"alternate-reverse",description:"The animation cycle iterations that are odd counts are played in the reverse direction, and the animation cycle iterations that are even counts are played in a normal direction."},{name:"normal",description:"Normal playback."},{name:"reverse",description:"All iterations of the animation are played in the reverse direction from the way they were specified."}],relevance:50,description:"Defines whether or not the animation should play in reverse on alternate cycles.",restrictions:["enum"]},{name:"-moz-animation-duration",browsers:["FF9"],relevance:50,description:"Defines the length of time that an animation takes to complete one cycle.",restrictions:["time"]},{name:"-moz-animation-iteration-count",browsers:["FF9"],values:[{name:"infinite",description:"Causes the animation to repeat forever."}],relevance:50,description:"Defines the number of times an animation cycle is played. The default value is one, meaning the animation will play from beginning to end once.",restrictions:["number","enum"]},{name:"-moz-animation-name",browsers:["FF9"],values:[{name:"none",description:"No animation is performed"}],relevance:50,description:"Defines a list of animations that apply. Each name is used to select the keyframe at-rule that provides the property values for the animation.",restrictions:["identifier","enum"]},{name:"-moz-animation-play-state",browsers:["FF9"],values:[{name:"paused",description:"A running animation will be paused."},{name:"running",description:"Resume playback of a paused animation."}],relevance:50,description:"Defines whether the animation is running or paused.",restrictions:["enum"]},{name:"-moz-animation-timing-function",browsers:["FF9"],relevance:50,description:"Describes how the animation will progress over one cycle of its duration. See the 'transition-timing-function'.",restrictions:["timing-function"]},{name:"-moz-appearance",browsers:["FF1"],values:[{name:"button"},{name:"button-arrow-down"},{name:"button-arrow-next"},{name:"button-arrow-previous"},{name:"button-arrow-up"},{name:"button-bevel"},{name:"checkbox"},{name:"checkbox-container"},{name:"checkbox-label"},{name:"dialog"},{name:"groupbox"},{name:"listbox"},{name:"menuarrow"},{name:"menuimage"},{name:"menuitem"},{name:"menuitemtext"},{name:"menulist"},{name:"menulist-button"},{name:"menulist-text"},{name:"menulist-textfield"},{name:"menupopup"},{name:"menuradio"},{name:"menuseparator"},{name:"-moz-mac-unified-toolbar"},{name:"-moz-win-borderless-glass"},{name:"-moz-win-browsertabbar-toolbox"},{name:"-moz-win-communications-toolbox"},{name:"-moz-win-glass"},{name:"-moz-win-media-toolbox"},{name:"none"},{name:"progressbar"},{name:"progresschunk"},{name:"radio"},{name:"radio-container"},{name:"radio-label"},{name:"radiomenuitem"},{name:"resizer"},{name:"resizerpanel"},{name:"scrollbarbutton-down"},{name:"scrollbarbutton-left"},{name:"scrollbarbutton-right"},{name:"scrollbarbutton-up"},{name:"scrollbar-small"},{name:"scrollbartrack-horizontal"},{name:"scrollbartrack-vertical"},{name:"separator"},{name:"spinner"},{name:"spinner-downbutton"},{name:"spinner-textfield"},{name:"spinner-upbutton"},{name:"statusbar"},{name:"statusbarpanel"},{name:"tab"},{name:"tabpanels"},{name:"tab-scroll-arrow-back"},{name:"tab-scroll-arrow-forward"},{name:"textfield"},{name:"textfield-multiline"},{name:"toolbar"},{name:"toolbox"},{name:"tooltip"},{name:"treeheadercell"},{name:"treeheadersortarrow"},{name:"treeitem"},{name:"treetwistyopen"},{name:"treeview"},{name:"treewisty"},{name:"window"}],status:"nonstandard",syntax:"none | button | button-arrow-down | button-arrow-next | button-arrow-previous | button-arrow-up | button-bevel | button-focus | caret | checkbox | checkbox-container | checkbox-label | checkmenuitem | dualbutton | groupbox | listbox | listitem | menuarrow | menubar | menucheckbox | menuimage | menuitem | menuitemtext | menulist | menulist-button | menulist-text | menulist-textfield | menupopup | menuradio | menuseparator | meterbar | meterchunk | progressbar | progressbar-vertical | progresschunk | progresschunk-vertical | radio | radio-container | radio-label | radiomenuitem | range | range-thumb | resizer | resizerpanel | scale-horizontal | scalethumbend | scalethumb-horizontal | scalethumbstart | scalethumbtick | scalethumb-vertical | scale-vertical | scrollbarbutton-down | scrollbarbutton-left | scrollbarbutton-right | scrollbarbutton-up | scrollbarthumb-horizontal | scrollbarthumb-vertical | scrollbartrack-horizontal | scrollbartrack-vertical | searchfield | separator | sheet | spinner | spinner-downbutton | spinner-textfield | spinner-upbutton | splitter | statusbar | statusbarpanel | tab | tabpanel | tabpanels | tab-scroll-arrow-back | tab-scroll-arrow-forward | textfield | textfield-multiline | toolbar | toolbarbutton | toolbarbutton-dropdown | toolbargripper | toolbox | tooltip | treeheader | treeheadercell | treeheadersortarrow | treeitem | treeline | treetwisty | treetwistyopen | treeview | -moz-mac-unified-toolbar | -moz-win-borderless-glass | -moz-win-browsertabbar-toolbox | -moz-win-communicationstext | -moz-win-communications-toolbox | -moz-win-exclude-glass | -moz-win-glass | -moz-win-mediatext | -moz-win-media-toolbox | -moz-window-button-box | -moz-window-button-box-maximized | -moz-window-button-close | -moz-window-button-maximize | -moz-window-button-minimize | -moz-window-button-restore | -moz-window-frame-bottom | -moz-window-frame-left | -moz-window-frame-right | -moz-window-titlebar | -moz-window-titlebar-maximized",relevance:0,description:"Used in Gecko (Firefox) to display an element using a platform-native styling based on the operating system's theme.",restrictions:["enum"]},{name:"-moz-backface-visibility",browsers:["FF10"],values:[{name:"hidden"},{name:"visible"}],relevance:50,description:"Determines whether or not the 'back' side of a transformed element is visible when facing the viewer. With an identity transform, the front side of an element faces the viewer.",restrictions:["enum"]},{name:"-moz-background-clip",browsers:["FF1-3.6"],values:[{name:"padding"}],relevance:50,description:"Determines the background painting area.",restrictions:["box","enum"]},{name:"-moz-background-inline-policy",browsers:["FF1"],values:[{name:"bounding-box"},{name:"continuous"},{name:"each-box"}],relevance:50,description:"In Gecko-based applications like Firefox, the -moz-background-inline-policy CSS property specifies how the background image of an inline element is determined when the content of the inline element wraps onto multiple lines. The choice of position has significant effects on repetition.",restrictions:["enum"]},{name:"-moz-background-origin",browsers:["FF1"],relevance:50,description:"For elements rendered as a single box, specifies the background positioning area. For elements rendered as multiple boxes (e.g., inline boxes on several lines, boxes on several pages) specifies which boxes 'box-decoration-break' operates on to determine the background positioning area(s).",restrictions:["box"]},{name:"-moz-border-bottom-colors",browsers:["FF1"],status:"nonstandard",syntax:"<color>+ | none",relevance:0,description:"Sets a list of colors for the bottom border.",restrictions:["color"]},{name:"-moz-border-image",browsers:["FF3.6"],values:[{name:"auto",description:"If 'auto' is specified then the border image width is the intrinsic width or height (whichever is applicable) of the corresponding image slice. If the image does not have the required intrinsic dimension then the corresponding border-width is used instead."},{name:"fill",description:"Causes the middle part of the border-image to be preserved."},{name:"none"},{name:"repeat",description:"The image is tiled (repeated) to fill the area."},{name:"round",description:"The image is tiled (repeated) to fill the area. If it does not fill the area with a whole number of tiles, the image is rescaled so that it does."},{name:"space",description:"The image is tiled (repeated) to fill the area. If it does not fill the area with a whole number of tiles, the extra space is distributed around the tiles."},{name:"stretch",description:"The image is stretched to fill the area."},{name:"url()"}],relevance:50,description:"Shorthand property for setting 'border-image-source', 'border-image-slice', 'border-image-width', 'border-image-outset' and 'border-image-repeat'. Omitted values are set to their initial values.",restrictions:["length","percentage","number","url","enum"]},{name:"-moz-border-left-colors",browsers:["FF1"],status:"nonstandard",syntax:"<color>+ | none",relevance:0,description:"Sets a list of colors for the bottom border.",restrictions:["color"]},{name:"-moz-border-right-colors",browsers:["FF1"],status:"nonstandard",syntax:"<color>+ | none",relevance:0,description:"Sets a list of colors for the bottom border.",restrictions:["color"]},{name:"-moz-border-top-colors",browsers:["FF1"],status:"nonstandard",syntax:"<color>+ | none",relevance:0,description:"Ske Firefox, -moz-border-bottom-colors sets a list of colors for the bottom border.",restrictions:["color"]},{name:"-moz-box-align",browsers:["FF1"],values:[{name:"baseline",description:"If this box orientation is inline-axis or horizontal, all children are placed with their baselines aligned, and extra space placed before or after as necessary. For block flows, the baseline of the first non-empty line box located within the element is used. For tables, the baseline of the first cell is used."},{name:"center",description:"Any extra space is divided evenly, with half placed above the child and the other half placed after the child."},{name:"end",description:"For normal direction boxes, the bottom edge of each child is placed along the bottom of the box. Extra space is placed above the element. For reverse direction boxes, the top edge of each child is placed along the top of the box. Extra space is placed below the element."},{name:"start",description:"For normal direction boxes, the top edge of each child is placed along the top of the box. Extra space is placed below the element. For reverse direction boxes, the bottom edge of each child is placed along the bottom of the box. Extra space is placed above the element."},{name:"stretch",description:"The height of each child is adjusted to that of the containing block."}],relevance:50,description:"Specifies how a XUL box aligns its contents across (perpendicular to) the direction of its layout. The effect of this is only visible if there is extra space in the box.",restrictions:["enum"]},{name:"-moz-box-direction",browsers:["FF1"],values:[{name:"normal",description:"A box with a computed value of horizontal for box-orient displays its children from left to right. A box with a computed value of vertical displays its children from top to bottom."},{name:"reverse",description:"A box with a computed value of horizontal for box-orient displays its children from right to left. A box with a computed value of vertical displays its children from bottom to top."}],relevance:50,description:"Specifies whether a box lays out its contents normally (from the top or left edge), or in reverse (from the bottom or right edge).",restrictions:["enum"]},{name:"-moz-box-flex",browsers:["FF1"],relevance:50,description:"Specifies how a box grows to fill the box that contains it, in the direction of the containing box's layout.",restrictions:["number"]},{name:"-moz-box-flexgroup",browsers:["FF1"],relevance:50,description:"Flexible elements can be assigned to flex groups using the 'box-flex-group' property.",restrictions:["integer"]},{name:"-moz-box-ordinal-group",browsers:["FF1"],relevance:50,description:"Indicates the ordinal group the element belongs to. Elements with a lower ordinal group are displayed before those with a higher ordinal group.",restrictions:["integer"]},{name:"-moz-box-orient",browsers:["FF1"],values:[{name:"block-axis",description:"Elements are oriented along the box's axis."},{name:"horizontal",description:"The box displays its children from left to right in a horizontal line."},{name:"inline-axis",description:"Elements are oriented vertically."},{name:"vertical",description:"The box displays its children from stacked from top to bottom vertically."}],relevance:50,description:"In Mozilla applications, -moz-box-orient specifies whether a box lays out its contents horizontally or vertically.",restrictions:["enum"]},{name:"-moz-box-pack",browsers:["FF1"],values:[{name:"center",description:"The extra space is divided evenly, with half placed before the first child and the other half placed after the last child."},{name:"end",description:"For normal direction boxes, the right edge of the last child is placed at the right side, with all extra space placed before the first child. For reverse direction boxes, the left edge of the first child is placed at the left side, with all extra space placed after the last child."},{name:"justify",description:"The space is divided evenly in-between each child, with none of the extra space placed before the first child or after the last child. If there is only one child, treat the pack value as if it were start."},{name:"start",description:"For normal direction boxes, the left edge of the first child is placed at the left side, with all extra space placed after the last child. For reverse direction boxes, the right edge of the last child is placed at the right side, with all extra space placed before the first child."}],relevance:50,description:"Specifies how a box packs its contents in the direction of its layout. The effect of this is only visible if there is extra space in the box.",restrictions:["enum"]},{name:"-moz-box-sizing",browsers:["FF1"],values:[{name:"border-box",description:"The specified width and height (and respective min/max properties) on this element determine the border box of the element."},{name:"content-box",description:"Behavior of width and height as specified by CSS2.1. The specified width and height (and respective min/max properties) apply to the width and height respectively of the content box of the element."},{name:"padding-box",description:"The specified width and height (and respective min/max properties) on this element determine the padding box of the element."}],relevance:50,description:"Box Model addition in CSS3.",restrictions:["enum"]},{name:"-moz-column-count",browsers:["FF3.5"],values:[{name:"auto",description:"Determines the number of columns by the 'column-width' property and the element width."}],relevance:50,description:"Describes the optimal number of columns into which the content of the element will be flowed.",restrictions:["integer"]},{name:"-moz-column-gap",browsers:["FF3.5"],values:[{name:"normal",description:"User agent specific and typically equivalent to 1em."}],relevance:50,description:"Sets the gap between columns. If there is a column rule between columns, it will appear in the middle of the gap.",restrictions:["length"]},{name:"-moz-column-rule",browsers:["FF3.5"],relevance:50,description:"Shorthand for setting 'column-rule-width', 'column-rule-style', and 'column-rule-color' at the same place in the style sheet. Omitted values are set to their initial values.",restrictions:["length","line-width","line-style","color"]},{name:"-moz-column-rule-color",browsers:["FF3.5"],relevance:50,description:"Sets the color of the column rule",restrictions:["color"]},{name:"-moz-column-rule-style",browsers:["FF3.5"],relevance:50,description:"Sets the style of the rule between columns of an element.",restrictions:["line-style"]},{name:"-moz-column-rule-width",browsers:["FF3.5"],relevance:50,description:"Sets the width of the rule between columns. Negative values are not allowed.",restrictions:["length","line-width"]},{name:"-moz-columns",browsers:["FF9"],values:[{name:"auto",description:"The width depends on the values of other properties."}],relevance:50,description:"A shorthand property which sets both 'column-width' and 'column-count'.",restrictions:["length","integer"]},{name:"-moz-column-width",browsers:["FF3.5"],values:[{name:"auto",description:"The width depends on the values of other properties."}],relevance:50,description:"This property describes the width of columns in multicol elements.",restrictions:["length"]},{name:"-moz-font-feature-settings",browsers:["FF4"],values:[{name:'"c2cs"'},{name:'"dlig"'},{name:'"kern"'},{name:'"liga"'},{name:'"lnum"'},{name:'"onum"'},{name:'"smcp"'},{name:'"swsh"'},{name:'"tnum"'},{name:"normal",description:"No change in glyph substitution or positioning occurs."},{name:"off",browsers:["FF4"]},{name:"on",browsers:["FF4"]}],relevance:50,description:"Provides low-level control over OpenType font features. It is intended as a way of providing access to font features that are not widely used but are needed for a particular use case.",restrictions:["string","integer"]},{name:"-moz-hyphens",browsers:["FF9"],values:[{name:"auto",description:"Conditional hyphenation characters inside a word, if present, take priority over automatic resources when determining hyphenation points within the word."},{name:"manual",description:"Words are only broken at line breaks where there are characters inside the word that suggest line break opportunities"},{name:"none",description:"Words are not broken at line breaks, even if characters inside the word suggest line break points."}],relevance:50,description:"Controls whether hyphenation is allowed to create more break opportunities within a line of text.",restrictions:["enum"]},{name:"-moz-perspective",browsers:["FF10"],values:[{name:"none",description:"No perspective transform is applied."}],relevance:50,description:"Applies the same transform as the perspective(<number>) transform function, except that it applies only to the positioned or transformed children of the element, not to the transform on the element itself.",restrictions:["length"]},{name:"-moz-perspective-origin",browsers:["FF10"],relevance:50,description:"Establishes the origin for the perspective property. It effectively sets the X and Y position at which the viewer appears to be looking at the children of the element.",restrictions:["position","percentage","length"]},{name:"-moz-text-align-last",browsers:["FF12"],values:[{name:"auto"},{name:"center",description:"The inline contents are centered within the line box."},{name:"justify",description:"The text is justified according to the method specified by the 'text-justify' property."},{name:"left",description:"The inline contents are aligned to the left edge of the line box. In vertical text, 'left' aligns to the edge of the line box that would be the start edge for left-to-right text."},{name:"right",description:"The inline contents are aligned to the right edge of the line box. In vertical text, 'right' aligns to the edge of the line box that would be the end edge for left-to-right text."}],relevance:50,description:"Describes how the last line of a block or a line right before a forced line break is aligned when 'text-align' is set to 'justify'.",restrictions:["enum"]},{name:"-moz-text-decoration-color",browsers:["FF6"],relevance:50,description:"Specifies the color of text decoration (underlines overlines, and line-throughs) set on the element with text-decoration-line.",restrictions:["color"]},{name:"-moz-text-decoration-line",browsers:["FF6"],values:[{name:"line-through",description:"Each line of text has a line through the middle."},{name:"none",description:"Neither produces nor inhibits text decoration."},{name:"overline",description:"Each line of text has a line above it."},{name:"underline",description:"Each line of text is underlined."}],relevance:50,description:"Specifies what line decorations, if any, are added to the element.",restrictions:["enum"]},{name:"-moz-text-decoration-style",browsers:["FF6"],values:[{name:"dashed",description:"Produces a dashed line style."},{name:"dotted",description:"Produces a dotted line."},{name:"double",description:"Produces a double line."},{name:"none",description:"Produces no line."},{name:"solid",description:"Produces a solid line."},{name:"wavy",description:"Produces a wavy line."}],relevance:50,description:"Specifies the line style for underline, line-through and overline text decoration.",restrictions:["enum"]},{name:"-moz-text-size-adjust",browsers:["FF"],values:[{name:"auto",description:"Renderers must use the default size adjustment when displaying on a small device."},{name:"none",description:"Renderers must not do size adjustment when displaying on a small device."}],relevance:50,description:"Specifies a size adjustment for displaying text content in mobile browsers.",restrictions:["enum","percentage"]},{name:"-moz-transform",browsers:["FF3.5"],values:[{name:"matrix()",description:"Specifies a 2D transformation in the form of a transformation matrix of six values. matrix(a,b,c,d,e,f) is equivalent to applying the transformation matrix [a b c d e f]"},{name:"matrix3d()",description:"Specifies a 3D transformation as a 4x4 homogeneous matrix of 16 values in column-major order."},{name:"none"},{name:"perspective",description:"Specifies a perspective projection matrix."},{name:"rotate()",description:"Specifies a 2D rotation by the angle specified in the parameter about the origin of the element, as defined by the transform-origin property."},{name:"rotate3d()",description:"Specifies a clockwise 3D rotation by the angle specified in last parameter about the [x,y,z] direction vector described by the first 3 parameters."},{name:"rotateX('angle')",description:"Specifies a clockwise rotation by the given angle about the X axis."},{name:"rotateY('angle')",description:"Specifies a clockwise rotation by the given angle about the Y axis."},{name:"rotateZ('angle')",description:"Specifies a clockwise rotation by the given angle about the Z axis."},{name:"scale()",description:"Specifies a 2D scale operation by the [sx,sy] scaling vector described by the 2 parameters. If the second parameter is not provided, it is takes a value equal to the first."},{name:"scale3d()",description:"Specifies a 3D scale operation by the [sx,sy,sz] scaling vector described by the 3 parameters."},{name:"scaleX()",description:"Specifies a scale operation using the [sx,1] scaling vector, where sx is given as the parameter."},{name:"scaleY()",description:"Specifies a scale operation using the [sy,1] scaling vector, where sy is given as the parameter."},{name:"scaleZ()",description:"Specifies a scale operation using the [1,1,sz] scaling vector, where sz is given as the parameter."},{name:"skew()",description:"Specifies a skew transformation along the X and Y axes. The first angle parameter specifies the skew on the X axis. The second angle parameter specifies the skew on the Y axis. If the second parameter is not given then a value of 0 is used for the Y angle (ie: no skew on the Y axis)."},{name:"skewX()",description:"Specifies a skew transformation along the X axis by the given angle."},{name:"skewY()",description:"Specifies a skew transformation along the Y axis by the given angle."},{name:"translate()",description:"Specifies a 2D translation by the vector [tx, ty], where tx is the first translation-value parameter and ty is the optional second translation-value parameter."},{name:"translate3d()",description:"Specifies a 3D translation by the vector [tx,ty,tz], with tx, ty and tz being the first, second and third translation-value parameters respectively."},{name:"translateX()",description:"Specifies a translation by the given amount in the X direction."},{name:"translateY()",description:"Specifies a translation by the given amount in the Y direction."},{name:"translateZ()",description:"Specifies a translation by the given amount in the Z direction. Note that percentage values are not allowed in the translateZ translation-value, and if present are evaluated as 0."}],relevance:50,description:"A two-dimensional transformation is applied to an element through the 'transform' property. This property contains a list of transform functions similar to those allowed by SVG.",restrictions:["enum"]},{name:"-moz-transform-origin",browsers:["FF3.5"],relevance:50,description:"Establishes the origin of transformation for an element.",restrictions:["position","length","percentage"]},{name:"-moz-transition",browsers:["FF4"],values:[{name:"all",description:"Every property that is able to undergo a transition will do so."},{name:"none",description:"No property will transition."}],relevance:50,description:"Shorthand property combines four of the transition properties into a single property.",restrictions:["time","property","timing-function","enum"]},{name:"-moz-transition-delay",browsers:["FF4"],relevance:50,description:"Defines when the transition will start. It allows a transition to begin execution some period of time from when it is applied.",restrictions:["time"]},{name:"-moz-transition-duration",browsers:["FF4"],relevance:50,description:"Specifies how long the transition from the old value to the new value should take.",restrictions:["time"]},{name:"-moz-transition-property",browsers:["FF4"],values:[{name:"all",description:"Every property that is able to undergo a transition will do so."},{name:"none",description:"No property will transition."}],relevance:50,description:"Specifies the name of the CSS property to which the transition is applied.",restrictions:["property"]},{name:"-moz-transition-timing-function",browsers:["FF4"],relevance:50,description:"Describes how the intermediate values used during a transition will be calculated.",restrictions:["timing-function"]},{name:"-moz-user-focus",browsers:["FF1"],values:[{name:"ignore"},{name:"normal"}],status:"nonstandard",syntax:"ignore | normal | select-after | select-before | select-menu | select-same | select-all | none",relevance:0,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/-moz-user-focus"}],description:"Used to indicate whether the element can have focus."},{name:"-moz-user-select",browsers:["FF1.5"],values:[{name:"all"},{name:"element"},{name:"elements"},{name:"-moz-all"},{name:"-moz-none"},{name:"none"},{name:"text"},{name:"toggle"}],relevance:50,description:"Controls the appearance of selection.",restrictions:["enum"]},{name:"-ms-accelerator",browsers:["E","IE10"],values:[{name:"false",description:"The element does not contain an accelerator key sequence."},{name:"true",description:"The element contains an accelerator key sequence."}],status:"nonstandard",syntax:"false | true",relevance:0,description:"IE only. Has the ability to turn off its system underlines for accelerator keys until the ALT key is pressed",restrictions:["enum"]},{name:"-ms-behavior",browsers:["IE8"],relevance:50,description:"IE only. Used to extend behaviors of the browser",restrictions:["url"]},{name:"-ms-block-progression",browsers:["IE8"],values:[{name:"bt",description:"Bottom-to-top block flow. Layout is horizontal."},{name:"lr",description:"Left-to-right direction. The flow orientation is vertical."},{name:"rl",description:"Right-to-left direction. The flow orientation is vertical."},{name:"tb",description:"Top-to-bottom direction. The flow orientation is horizontal."}],status:"nonstandard",syntax:"tb | rl | bt | lr",relevance:0,description:"Sets the block-progression value and the flow orientation",restrictions:["enum"]},{name:"-ms-content-zoom-chaining",browsers:["E","IE10"],values:[{name:"chained",description:"The nearest zoomable parent element begins zooming when the user hits a zoom limit during a manipulation. No bounce effect is shown."},{name:"none",description:"A bounce effect is shown when the user hits a zoom limit during a manipulation."}],status:"nonstandard",syntax:"none | chained",relevance:0,description:"Specifies the zoom behavior that occurs when a user hits the zoom limit during a manipulation."},{name:"-ms-content-zooming",browsers:["E","IE10"],values:[{name:"none",description:"The element is not zoomable."},{name:"zoom",description:"The element is zoomable."}],status:"nonstandard",syntax:"none | zoom",relevance:0,description:"Specifies whether zooming is enabled.",restrictions:["enum"]},{name:"-ms-content-zoom-limit",browsers:["E","IE10"],status:"nonstandard",syntax:"<'-ms-content-zoom-limit-min'> <'-ms-content-zoom-limit-max'>",relevance:0,description:"Shorthand property for the -ms-content-zoom-limit-min and -ms-content-zoom-limit-max properties.",restrictions:["percentage"]},{name:"-ms-content-zoom-limit-max",browsers:["E","IE10"],status:"nonstandard",syntax:"<percentage>",relevance:0,description:"Specifies the maximum zoom factor.",restrictions:["percentage"]},{name:"-ms-content-zoom-limit-min",browsers:["E","IE10"],status:"nonstandard",syntax:"<percentage>",relevance:0,description:"Specifies the minimum zoom factor.",restrictions:["percentage"]},{name:"-ms-content-zoom-snap",browsers:["E","IE10"],values:[{name:"mandatory",description:"Indicates that the motion of the content after the contact is picked up is always adjusted so that it lands on a snap-point."},{name:"none",description:"Indicates that zooming is unaffected by any defined snap-points."},{name:"proximity",description:'Indicates that the motion of the content after the contact is picked up may be adjusted if the content would normally stop "close enough" to a snap-point.'},{name:"snapInterval(100%, 100%)",description:"Specifies where the snap-points will be placed."},{name:"snapList()",description:"Specifies the position of individual snap-points as a comma-separated list of zoom factors."}],status:"nonstandard",syntax:"<'-ms-content-zoom-snap-type'> || <'-ms-content-zoom-snap-points'>",relevance:0,description:"Shorthand property for the -ms-content-zoom-snap-type and -ms-content-zoom-snap-points properties."},{name:"-ms-content-zoom-snap-points",browsers:["E","IE10"],values:[{name:"snapInterval(100%, 100%)",description:"Specifies where the snap-points will be placed."},{name:"snapList()",description:"Specifies the position of individual snap-points as a comma-separated list of zoom factors."}],status:"nonstandard",syntax:"snapInterval( <percentage>, <percentage> ) | snapList( <percentage># )",relevance:0,description:"Defines where zoom snap-points are located."},{name:"-ms-content-zoom-snap-type",browsers:["E","IE10"],values:[{name:"mandatory",description:"Indicates that the motion of the content after the contact is picked up is always adjusted so that it lands on a snap-point."},{name:"none",description:"Indicates that zooming is unaffected by any defined snap-points."},{name:"proximity",description:'Indicates that the motion of the content after the contact is picked up may be adjusted if the content would normally stop "close enough" to a snap-point.'}],status:"nonstandard",syntax:"none | proximity | mandatory",relevance:0,description:"Specifies how zooming is affected by defined snap-points.",restrictions:["enum"]},{name:"-ms-filter",browsers:["IE8-9"],status:"nonstandard",syntax:"<string>",relevance:0,description:"IE only. Used to produce visual effects.",restrictions:["string"]},{name:"-ms-flex",browsers:["IE10"],values:[{name:"auto",description:"Retrieves the value of the main size property as the used 'flex-basis'."},{name:"none",description:"Expands to '0 0 auto'."}],relevance:50,description:"specifies the parameters of a flexible length: the positive and negative flexibility, and the preferred size.",restrictions:["length","number","percentage"]},{name:"-ms-flex-align",browsers:["IE10"],values:[{name:"baseline",description:"If the flex item's inline axis is the same as the cross axis, this value is identical to 'flex-start'. Otherwise, it participates in baseline alignment."},{name:"center",description:"The flex item's margin box is centered in the cross axis within the line."},{name:"end",description:"The cross-end margin edge of the flex item is placed flush with the cross-end edge of the line."},{name:"start",description:"The cross-start margin edge of the flexbox item is placed flush with the cross-start edge of the line."},{name:"stretch",description:"If the cross size property of the flexbox item is anything other than 'auto', this value is identical to 'start'."}],relevance:50,description:"Aligns flex items along the cross axis of the current line of the flex container.",restrictions:["enum"]},{name:"-ms-flex-direction",browsers:["IE10"],values:[{name:"column",description:"The flex container's main axis has the same orientation as the block axis of the current writing mode."},{name:"column-reverse",description:"Same as 'column', except the main-start and main-end directions are swapped."},{name:"row",description:"The flex container's main axis has the same orientation as the inline axis of the current writing mode."},{name:"row-reverse",description:"Same as 'row', except the main-start and main-end directions are swapped."}],relevance:50,description:"Specifies how flex items are placed in the flex container, by setting the direction of the flex container's main axis.",restrictions:["enum"]},{name:"-ms-flex-flow",browsers:["IE10"],values:[{name:"column",description:"The flex container's main axis has the same orientation as the block axis of the current writing mode."},{name:"column-reverse",description:"Same as 'column', except the main-start and main-end directions are swapped."},{name:"nowrap",description:"The flex container is single-line."},{name:"row",description:"The flex container's main axis has the same orientation as the inline axis of the current writing mode."},{name:"wrap",description:"The flexbox is multi-line."},{name:"wrap-reverse",description:"Same as 'wrap', except the cross-start and cross-end directions are swapped."}],relevance:50,description:"Specifies how flexbox items are placed in the flexbox.",restrictions:["enum"]},{name:"-ms-flex-item-align",browsers:["IE10"],values:[{name:"auto",description:"Computes to the value of 'align-items' on the element's parent, or 'stretch' if the element has no parent. On absolutely positioned elements, it computes to itself."},{name:"baseline",description:"If the flex item's inline axis is the same as the cross axis, this value is identical to 'flex-start'. Otherwise, it participates in baseline alignment."},{name:"center",description:"The flex item's margin box is centered in the cross axis within the line."},{name:"end",description:"The cross-end margin edge of the flex item is placed flush with the cross-end edge of the line."},{name:"start",description:"The cross-start margin edge of the flex item is placed flush with the cross-start edge of the line."},{name:"stretch",description:"If the cross size property of the flex item computes to auto, and neither of the cross-axis margins are auto, the flex item is stretched."}],relevance:50,description:"Allows the default alignment along the cross axis to be overridden for individual flex items.",restrictions:["enum"]},{name:"-ms-flex-line-pack",browsers:["IE10"],values:[{name:"center",description:"Lines are packed toward the center of the flex container."},{name:"distribute",description:"Lines are evenly distributed in the flex container, with half-size spaces on either end."},{name:"end",description:"Lines are packed toward the end of the flex container."},{name:"justify",description:"Lines are evenly distributed in the flex container."},{name:"start",description:"Lines are packed toward the start of the flex container."},{name:"stretch",description:"Lines stretch to take up the remaining space."}],relevance:50,description:"Aligns a flex container's lines within the flex container when there is extra space in the cross-axis, similar to how 'justify-content' aligns individual items within the main-axis.",restrictions:["enum"]},{name:"-ms-flex-order",browsers:["IE10"],relevance:50,description:"Controls the order in which children of a flex container appear within the flex container, by assigning them to ordinal groups.",restrictions:["integer"]},{name:"-ms-flex-pack",browsers:["IE10"],values:[{name:"center",description:"Flex items are packed toward the center of the line."},{name:"distribute",description:"Flex items are evenly distributed in the line, with half-size spaces on either end."},{name:"end",description:"Flex items are packed toward the end of the line."},{name:"justify",description:"Flex items are evenly distributed in the line."},{name:"start",description:"Flex items are packed toward the start of the line."}],relevance:50,description:"Aligns flex items along the main axis of the current line of the flex container.",restrictions:["enum"]},{name:"-ms-flex-wrap",browsers:["IE10"],values:[{name:"nowrap",description:"The flex container is single-line."},{name:"wrap",description:"The flexbox is multi-line."},{name:"wrap-reverse",description:"Same as 'wrap', except the cross-start and cross-end directions are swapped."}],relevance:50,description:"Controls whether the flex container is single-line or multi-line, and the direction of the cross-axis, which determines the direction new lines are stacked in.",restrictions:["enum"]},{name:"-ms-flow-from",browsers:["E","IE10"],values:[{name:"none",description:"The block container is not a CSS Region."}],status:"nonstandard",syntax:"[ none | <custom-ident> ]#",relevance:0,description:"Makes a block container a region and associates it with a named flow.",restrictions:["identifier"]},{name:"-ms-flow-into",browsers:["E","IE10"],values:[{name:"none",description:"The element is not moved to a named flow and normal CSS processing takes place."}],status:"nonstandard",syntax:"[ none | <custom-ident> ]#",relevance:0,description:"Places an element or its contents into a named flow.",restrictions:["identifier"]},{name:"-ms-grid-column",browsers:["E","IE10"],values:[{name:"auto"},{name:"end"},{name:"start"}],relevance:50,description:"Used to place grid items and explicitly defined grid cells in the Grid.",restrictions:["integer","string","enum"]},{name:"-ms-grid-column-align",browsers:["E","IE10"],values:[{name:"center",description:"Places the center of the Grid Item's margin box at the center of the Grid Item's column."},{name:"end",description:"Aligns the end edge of the Grid Item's margin box to the end edge of the Grid Item's column."},{name:"start",description:"Aligns the starting edge of the Grid Item's margin box to the starting edge of the Grid Item's column."},{name:"stretch",description:"Ensures that the Grid Item's margin box is equal to the size of the Grid Item's column."}],relevance:50,description:"Aligns the columns in a grid.",restrictions:["enum"]},{name:"-ms-grid-columns",browsers:["E","IE10"],status:"nonstandard",syntax:"none | <track-list> | <auto-track-list>",relevance:0,description:"Lays out the columns of the grid."},{name:"-ms-grid-column-span",browsers:["E","IE10"],relevance:50,description:"Specifies the number of columns to span.",restrictions:["integer"]},{name:"-ms-grid-layer",browsers:["E","IE10"],relevance:50,description:"Grid-layer is similar in concept to z-index, but avoids overloading the meaning of the z-index property, which is applicable only to positioned elements.",restrictions:["integer"]},{name:"-ms-grid-row",browsers:["E","IE10"],values:[{name:"auto"},{name:"end"},{name:"start"}],relevance:50,description:"grid-row is used to place grid items and explicitly defined grid cells in the Grid.",restrictions:["integer","string","enum"]},{name:"-ms-grid-row-align",browsers:["E","IE10"],values:[{name:"center",description:"Places the center of the Grid Item's margin box at the center of the Grid Item's row."},{name:"end",description:"Aligns the end edge of the Grid Item's margin box to the end edge of the Grid Item's row."},{name:"start",description:"Aligns the starting edge of the Grid Item's margin box to the starting edge of the Grid Item's row."},{name:"stretch",description:"Ensures that the Grid Item's margin box is equal to the size of the Grid Item's row."}],relevance:50,description:"Aligns the rows in a grid.",restrictions:["enum"]},{name:"-ms-grid-rows",browsers:["E","IE10"],status:"nonstandard",syntax:"none | <track-list> | <auto-track-list>",relevance:0,description:"Lays out the columns of the grid."},{name:"-ms-grid-row-span",browsers:["E","IE10"],relevance:50,description:"Specifies the number of rows to span.",restrictions:["integer"]},{name:"-ms-high-contrast-adjust",browsers:["E","IE10"],values:[{name:"auto",description:"Properties will be adjusted as applicable."},{name:"none",description:"No adjustments will be applied."}],status:"nonstandard",syntax:"auto | none",relevance:0,description:"Specifies if properties should be adjusted in high contrast mode.",restrictions:["enum"]},{name:"-ms-hyphenate-limit-chars",browsers:["E","IE10"],values:[{name:"auto",description:"The user agent chooses a value that adapts to the current layout."}],status:"nonstandard",syntax:"auto | <integer>{1,3}",relevance:0,description:"Specifies the minimum number of characters in a hyphenated word.",restrictions:["integer"]},{name:"-ms-hyphenate-limit-lines",browsers:["E","IE10"],values:[{name:"no-limit",description:"There is no limit."}],status:"nonstandard",syntax:"no-limit | <integer>",relevance:0,description:"Indicates the maximum number of successive hyphenated lines in an element.",restrictions:["integer"]},{name:"-ms-hyphenate-limit-zone",browsers:["E","IE10"],status:"nonstandard",syntax:"<percentage> | <length>",relevance:0,description:"Specifies the maximum amount of unfilled space (before justification) that may be left in the line box before hyphenation is triggered to pull part of a word from the next line back up into the current line.",restrictions:["percentage","length"]},{name:"-ms-hyphens",browsers:["E","IE10"],values:[{name:"auto",description:"Conditional hyphenation characters inside a word, if present, take priority over automatic resources when determining hyphenation points within the word."},{name:"manual",description:"Words are only broken at line breaks where there are characters inside the word that suggest line break opportunities"},{name:"none",description:"Words are not broken at line breaks, even if characters inside the word suggest line break points."}],relevance:50,description:"Controls whether hyphenation is allowed to create more break opportunities within a line of text.",restrictions:["enum"]},{name:"-ms-ime-mode",browsers:["IE10"],values:[{name:"active",description:"The input method editor is initially active; text entry is performed using it unless the user specifically dismisses it."},{name:"auto",description:"No change is made to the current input method editor state. This is the default."},{name:"disabled",description:"The input method editor is disabled and may not be activated by the user."},{name:"inactive",description:"The input method editor is initially inactive, but the user may activate it if they wish."},{name:"normal",description:"The IME state should be normal; this value can be used in a user style sheet to override the page setting."}],relevance:50,description:"Controls the state of the input method editor for text fields.",restrictions:["enum"]},{name:"-ms-interpolation-mode",browsers:["IE7"],values:[{name:"bicubic"},{name:"nearest-neighbor"}],relevance:50,description:"Gets or sets the interpolation (resampling) method used to stretch images.",restrictions:["enum"]},{name:"-ms-layout-grid",browsers:["E","IE10"],values:[{name:"char",description:"Any of the range of character values available to the -ms-layout-grid-char property."},{name:"line",description:"Any of the range of line values available to the -ms-layout-grid-line property."},{name:"mode",description:"Any of the range of mode values available to the -ms-layout-grid-mode property."},{name:"type",description:"Any of the range of type values available to the -ms-layout-grid-type property."}],relevance:50,description:"Sets or retrieves the composite document grid properties that specify the layout of text characters."},{name:"-ms-layout-grid-char",browsers:["E","IE10"],values:[{name:"auto",description:"Largest character in the font of the element is used to set the character grid."},{name:"none",description:"Default. No character grid is set."}],relevance:50,description:"Sets or retrieves the size of the character grid used for rendering the text content of an element.",restrictions:["enum","length","percentage"]},{name:"-ms-layout-grid-line",browsers:["E","IE10"],values:[{name:"auto",description:"Largest character in the font of the element is used to set the character grid."},{name:"none",description:"Default. No grid line is set."}],relevance:50,description:"Sets or retrieves the gridline value used for rendering the text content of an element.",restrictions:["length"]},{name:"-ms-layout-grid-mode",browsers:["E","IE10"],values:[{name:"both",description:"Default. Both the char and line grid modes are enabled. This setting is necessary to fully enable the layout grid on an element."},{name:"char",description:"Only a character grid is used. This is recommended for use with block-level elements, such as a blockquote, where the line grid is intended to be disabled."},{name:"line",description:"Only a line grid is used. This is recommended for use with inline elements, such as a span, to disable the horizontal grid on runs of text that act as a single entity in the grid layout."},{name:"none",description:"No grid is used."}],relevance:50,description:"Gets or sets whether the text layout grid uses two dimensions.",restrictions:["enum"]},{name:"-ms-layout-grid-type",browsers:["E","IE10"],values:[{name:"fixed",description:"Grid used for monospaced layout. All noncursive characters are treated as equal; every character is centered within a single grid space by default."},{name:"loose",description:"Default. Grid used for Japanese and Korean characters."},{name:"strict",description:"Grid used for Chinese, as well as Japanese (Genko) and Korean characters. Only the ideographs, kanas, and wide characters are snapped to the grid."}],relevance:50,description:"Sets or retrieves the type of grid used for rendering the text content of an element.",restrictions:["enum"]},{name:"-ms-line-break",browsers:["E","IE10"],values:[{name:"auto",description:"The UA determines the set of line-breaking restrictions to use for CJK scripts, and it may vary the restrictions based on the length of the line; e.g., use a less restrictive set of line-break rules for short lines."},{name:"keep-all",description:"Sequences of CJK characters can no longer break on implied break points. This option should only be used where the presence of word separator characters still creates line-breaking opportunities, as in Korean."},{name:"newspaper",description:"Breaks CJK scripts using the least restrictive set of line-breaking rules. Typically used for short lines, such as in newspapers."},{name:"normal",description:"Breaks CJK scripts using a normal set of line-breaking rules."},{name:"strict",description:"Breaks CJK scripts using a more restrictive set of line-breaking rules than 'normal'."}],relevance:50,description:"Specifies what set of line breaking restrictions are in effect within the element.",restrictions:["enum"]},{name:"-ms-overflow-style",browsers:["E","IE10"],values:[{name:"auto",description:"No preference, UA should use the first scrolling method in the list that it supports."},{name:"-ms-autohiding-scrollbar",description:"Indicates the element displays auto-hiding scrollbars during mouse interactions and panning indicators during touch and keyboard interactions."},{name:"none",description:"Indicates the element does not display scrollbars or panning indicators, even when its content overflows."},{name:"scrollbar",description:'Scrollbars are typically narrow strips inserted on one or two edges of an element and which often have arrows to click on and a "thumb" to drag up and down (or left and right) to move the contents of the element.'}],status:"nonstandard",syntax:"auto | none | scrollbar | -ms-autohiding-scrollbar",relevance:0,description:"Specify whether content is clipped when it overflows the element's content area.",restrictions:["enum"]},{name:"-ms-perspective",browsers:["IE10"],values:[{name:"none",description:"No perspective transform is applied."}],relevance:50,description:"Applies the same transform as the perspective(<number>) transform function, except that it applies only to the positioned or transformed children of the element, not to the transform on the element itself.",restrictions:["length"]},{name:"-ms-perspective-origin",browsers:["IE10"],relevance:50,description:"Establishes the origin for the perspective property. It effectively sets the X and Y position at which the viewer appears to be looking at the children of the element.",restrictions:["position","percentage","length"]},{name:"-ms-perspective-origin-x",browsers:["IE10"],relevance:50,description:"Establishes the origin for the perspective property. It effectively sets the X  position at which the viewer appears to be looking at the children of the element.",restrictions:["position","percentage","length"]},{name:"-ms-perspective-origin-y",browsers:["IE10"],relevance:50,description:"Establishes the origin for the perspective property. It effectively sets the Y position at which the viewer appears to be looking at the children of the element.",restrictions:["position","percentage","length"]},{name:"-ms-progress-appearance",browsers:["IE10"],values:[{name:"bar"},{name:"ring"}],relevance:50,description:"Gets or sets a value that specifies whether a progress control displays as a bar or a ring.",restrictions:["enum"]},{name:"-ms-scrollbar-3dlight-color",browsers:["IE8"],status:"nonstandard",syntax:"<color>",relevance:0,description:"Determines the color of the top and left edges of the scroll box and scroll arrows of a scroll bar.",restrictions:["color"]},{name:"-ms-scrollbar-arrow-color",browsers:["IE8"],status:"nonstandard",syntax:"<color>",relevance:0,description:"Determines the color of the arrow elements of a scroll arrow.",restrictions:["color"]},{name:"-ms-scrollbar-base-color",browsers:["IE8"],status:"nonstandard",syntax:"<color>",relevance:0,description:"Determines the color of the main elements of a scroll bar, which include the scroll box, track, and scroll arrows.",restrictions:["color"]},{name:"-ms-scrollbar-darkshadow-color",browsers:["IE8"],status:"nonstandard",syntax:"<color>",relevance:0,description:"Determines the color of the gutter of a scroll bar.",restrictions:["color"]},{name:"-ms-scrollbar-face-color",browsers:["IE8"],status:"nonstandard",syntax:"<color>",relevance:0,description:"Determines the color of the scroll box and scroll arrows of a scroll bar.",restrictions:["color"]},{name:"-ms-scrollbar-highlight-color",browsers:["IE8"],status:"nonstandard",syntax:"<color>",relevance:0,description:"Determines the color of the top and left edges of the scroll box and scroll arrows of a scroll bar.",restrictions:["color"]},{name:"-ms-scrollbar-shadow-color",browsers:["IE8"],status:"nonstandard",syntax:"<color>",relevance:0,description:"Determines the color of the bottom and right edges of the scroll box and scroll arrows of a scroll bar.",restrictions:["color"]},{name:"-ms-scrollbar-track-color",browsers:["IE8"],status:"nonstandard",syntax:"<color>",relevance:0,description:"Determines the color of the track element of a scroll bar.",restrictions:["color"]},{name:"-ms-scroll-chaining",browsers:["E","IE10"],values:[{name:"chained"},{name:"none"}],status:"nonstandard",syntax:"chained | none",relevance:0,description:"Gets or sets a value that indicates the scrolling behavior that occurs when a user hits the content boundary during a manipulation.",restrictions:["enum","length"]},{name:"-ms-scroll-limit",browsers:["E","IE10"],values:[{name:"auto"}],status:"nonstandard",syntax:"<'-ms-scroll-limit-x-min'> <'-ms-scroll-limit-y-min'> <'-ms-scroll-limit-x-max'> <'-ms-scroll-limit-y-max'>",relevance:0,description:"Gets or sets a shorthand value that sets values for the -ms-scroll-limit-x-min, -ms-scroll-limit-y-min, -ms-scroll-limit-x-max, and -ms-scroll-limit-y-max properties.",restrictions:["length"]},{name:"-ms-scroll-limit-x-max",browsers:["E","IE10"],values:[{name:"auto"}],status:"nonstandard",syntax:"auto | <length>",relevance:0,description:"Gets or sets a value that specifies the maximum value for the scrollLeft property.",restrictions:["length"]},{name:"-ms-scroll-limit-x-min",browsers:["E","IE10"],status:"nonstandard",syntax:"<length>",relevance:0,description:"Gets or sets a value that specifies the minimum value for the scrollLeft property.",restrictions:["length"]},{name:"-ms-scroll-limit-y-max",browsers:["E","IE10"],values:[{name:"auto"}],status:"nonstandard",syntax:"auto | <length>",relevance:0,description:"Gets or sets a value that specifies the maximum value for the scrollTop property.",restrictions:["length"]},{name:"-ms-scroll-limit-y-min",browsers:["E","IE10"],status:"nonstandard",syntax:"<length>",relevance:0,description:"Gets or sets a value that specifies the minimum value for the scrollTop property.",restrictions:["length"]},{name:"-ms-scroll-rails",browsers:["E","IE10"],values:[{name:"none"},{name:"railed"}],status:"nonstandard",syntax:"none | railed",relevance:0,description:"Gets or sets a value that indicates whether or not small motions perpendicular to the primary axis of motion will result in either changes to both the scrollTop and scrollLeft properties or a change to the primary axis (for instance, either the scrollTop or scrollLeft properties will change, but not both).",restrictions:["enum","length"]},{name:"-ms-scroll-snap-points-x",browsers:["E","IE10"],values:[{name:"snapInterval(100%, 100%)"},{name:"snapList()"}],status:"nonstandard",syntax:"snapInterval( <length-percentage>, <length-percentage> ) | snapList( <length-percentage># )",relevance:0,description:"Gets or sets a value that defines where snap-points will be located along the x-axis.",restrictions:["enum"]},{name:"-ms-scroll-snap-points-y",browsers:["E","IE10"],values:[{name:"snapInterval(100%, 100%)"},{name:"snapList()"}],status:"nonstandard",syntax:"snapInterval( <length-percentage>, <length-percentage> ) | snapList( <length-percentage># )",relevance:0,description:"Gets or sets a value that defines where snap-points will be located along the y-axis.",restrictions:["enum"]},{name:"-ms-scroll-snap-type",browsers:["E","IE10"],values:[{name:"none",description:"The visual viewport of this scroll container must ignore snap points, if any, when scrolled."},{name:"mandatory",description:"The visual viewport of this scroll container is guaranteed to rest on a snap point when there are no active scrolling operations."},{name:"proximity",description:"The visual viewport of this scroll container may come to rest on a snap point at the termination of a scroll at the discretion of the UA given the parameters of the scroll."}],status:"nonstandard",syntax:"none | proximity | mandatory",relevance:0,description:"Gets or sets a value that defines what type of snap-point should be used for the current element. There are two type of snap-points, with the primary difference being whether or not the user is guaranteed to always stop on a snap-point.",restrictions:["enum"]},{name:"-ms-scroll-snap-x",browsers:["E","IE10"],values:[{name:"mandatory"},{name:"none"},{name:"proximity"},{name:"snapInterval(100%, 100%)"},{name:"snapList()"}],status:"nonstandard",syntax:"<'-ms-scroll-snap-type'> <'-ms-scroll-snap-points-x'>",relevance:0,description:"Gets or sets a shorthand value that sets values for the -ms-scroll-snap-type and -ms-scroll-snap-points-x properties.",restrictions:["enum"]},{name:"-ms-scroll-snap-y",browsers:["E","IE10"],values:[{name:"mandatory"},{name:"none"},{name:"proximity"},{name:"snapInterval(100%, 100%)"},{name:"snapList()"}],status:"nonstandard",syntax:"<'-ms-scroll-snap-type'> <'-ms-scroll-snap-points-y'>",relevance:0,description:"Gets or sets a shorthand value that sets values for the -ms-scroll-snap-type and -ms-scroll-snap-points-y properties.",restrictions:["enum"]},{name:"-ms-scroll-translation",browsers:["E","IE10"],values:[{name:"none"},{name:"vertical-to-horizontal"}],status:"nonstandard",syntax:"none | vertical-to-horizontal",relevance:0,description:"Gets or sets a value that specifies whether vertical-to-horizontal scroll wheel translation occurs on the specified element.",restrictions:["enum"]},{name:"-ms-text-align-last",browsers:["E","IE8"],values:[{name:"auto"},{name:"center",description:"The inline contents are centered within the line box."},{name:"justify",description:"The text is justified according to the method specified by the 'text-justify' property."},{name:"left",description:"The inline contents are aligned to the left edge of the line box. In vertical text, 'left' aligns to the edge of the line box that would be the start edge for left-to-right text."},{name:"right",description:"The inline contents are aligned to the right edge of the line box. In vertical text, 'right' aligns to the edge of the line box that would be the end edge for left-to-right text."}],relevance:50,description:"Describes how the last line of a block or a line right before a forced line break is aligned when 'text-align' is set to 'justify'.",restrictions:["enum"]},{name:"-ms-text-autospace",browsers:["E","IE8"],values:[{name:"ideograph-alpha",description:"Creates 1/4em extra spacing between runs of ideographic letters and non-ideographic letters, such as Latin-based, Cyrillic, Greek, Arabic or Hebrew."},{name:"ideograph-numeric",description:"Creates 1/4em extra spacing between runs of ideographic letters and numeric glyphs."},{name:"ideograph-parenthesis",description:"Creates extra spacing between normal (non wide) parenthesis and ideographs."},{name:"ideograph-space",description:"Extends the width of the space character while surrounded by ideographs."},{name:"none",description:"No extra space is created."},{name:"punctuation",description:"Creates extra non-breaking spacing around punctuation as required by language-specific typographic conventions."}],status:"nonstandard",syntax:"none | ideograph-alpha | ideograph-numeric | ideograph-parenthesis | ideograph-space",relevance:0,description:"Determines whether or not a full-width punctuation mark character should be trimmed if it appears at the beginning of a line, so that its 'ink' lines up with the first glyph in the line above and below.",restrictions:["enum"]},{name:"-ms-text-combine-horizontal",browsers:["E","IE11"],values:[{name:"all",description:"Attempt to typeset horizontally all consecutive characters within the box such that they take up the space of a single character within the vertical line box."},{name:"digits",description:"Attempt to typeset horizontally each maximal sequence of consecutive ASCII digits (U+0030-U+0039) that has as many or fewer characters than the specified integer such that it takes up the space of a single character within the vertical line box."},{name:"none",description:"No special processing."}],relevance:50,description:"This property specifies the combination of multiple characters into the space of a single character.",restrictions:["enum","integer"]},{name:"-ms-text-justify",browsers:["E","IE8"],values:[{name:"auto",description:"The UA determines the justification algorithm to follow, based on a balance between performance and adequate presentation quality."},{name:"distribute",description:"Justification primarily changes spacing both at word separators and at grapheme cluster boundaries in all scripts except those in the connected and cursive groups. This value is sometimes used in e.g. Japanese, often with the 'text-align-last' property."},{name:"inter-cluster",description:"Justification primarily changes spacing at word separators and at grapheme cluster boundaries in clustered scripts. This value is typically used for Southeast Asian scripts such as Thai."},{name:"inter-ideograph",description:"Justification primarily changes spacing at word separators and at inter-graphemic boundaries in scripts that use no word spaces. This value is typically used for CJK languages."},{name:"inter-word",description:"Justification primarily changes spacing at word separators. This value is typically used for languages that separate words using spaces, like English or (sometimes) Korean."},{name:"kashida",description:"Justification primarily stretches Arabic and related scripts through the use of kashida or other calligraphic elongation."}],relevance:50,description:"Selects the justification algorithm used when 'text-align' is set to 'justify'. The property applies to block containers, but the UA may (but is not required to) also support it on inline elements.",restrictions:["enum"]},{name:"-ms-text-kashida-space",browsers:["E","IE10"],relevance:50,description:"Sets or retrieves the ratio of kashida expansion to white space expansion when justifying lines of text in the object.",restrictions:["percentage"]},{name:"-ms-text-overflow",browsers:["IE10"],values:[{name:"clip",description:"Clip inline content that overflows. Characters may be only partially rendered."},{name:"ellipsis",description:"Render an ellipsis character (U+2026) to represent clipped inline content."}],relevance:50,description:"Text can overflow for example when it is prevented from wrapping",restrictions:["enum"]},{name:"-ms-text-size-adjust",browsers:["E","IE10"],values:[{name:"auto",description:"Renderers must use the default size adjustment when displaying on a small device."},{name:"none",description:"Renderers must not do size adjustment when displaying on a small device."}],relevance:50,description:"Specifies a size adjustment for displaying text content in mobile browsers.",restrictions:["enum","percentage"]},{name:"-ms-text-underline-position",browsers:["E","IE10"],values:[{name:"alphabetic",description:"The underline is aligned with the alphabetic baseline. In this case the underline is likely to cross some descenders."},{name:"auto",description:"The user agent may use any algorithm to determine the underline's position. In horizontal line layout, the underline should be aligned as for alphabetic. In vertical line layout, if the language is set to Japanese or Korean, the underline should be aligned as for over."},{name:"over",description:"The underline is aligned with the 'top' (right in vertical writing) edge of the element's em-box. In this mode, an overline also switches sides."},{name:"under",description:"The underline is aligned with the 'bottom' (left in vertical writing) edge of the element's em-box. In this case the underline usually does not cross the descenders. This is sometimes called 'accounting' underline."}],relevance:50,description:"Sets the position of an underline specified on the same element: it does not affect underlines specified by ancestor elements.This property is typically used in vertical writing contexts such as in Japanese documents where it often desired to have the underline appear 'over' (to the right of) the affected run of text",restrictions:["enum"]},{name:"-ms-touch-action",browsers:["IE10"],values:[{name:"auto",description:"The element is a passive element, with several exceptions."},{name:"double-tap-zoom",description:"The element will zoom on double-tap."},{name:"manipulation",description:"The element is a manipulation-causing element."},{name:"none",description:"The element is a manipulation-blocking element."},{name:"pan-x",description:"The element permits touch-driven panning on the horizontal axis. The touch pan is performed on the nearest ancestor with horizontally scrollable content."},{name:"pan-y",description:"The element permits touch-driven panning on the vertical axis. The touch pan is performed on the nearest ancestor with vertically scrollable content."},{name:"pinch-zoom",description:"The element permits pinch-zooming. The pinch-zoom is performed on the nearest ancestor with zoomable content."}],relevance:50,description:"Gets or sets a value that indicates whether and how a given region can be manipulated by the user.",restrictions:["enum"]},{name:"-ms-touch-select",browsers:["E","IE10"],values:[{name:"grippers",description:"Grippers are always on."},{name:"none",description:"Grippers are always off."}],status:"nonstandard",syntax:"grippers | none",relevance:0,description:"Gets or sets a value that toggles the 'gripper' visual elements that enable touch text selection.",restrictions:["enum"]},{name:"-ms-transform",browsers:["IE9-9"],values:[{name:"matrix()",description:"Specifies a 2D transformation in the form of a transformation matrix of six values. matrix(a,b,c,d,e,f) is equivalent to applying the transformation matrix [a b c d e f]"},{name:"matrix3d()",description:"Specifies a 3D transformation as a 4x4 homogeneous matrix of 16 values in column-major order."},{name:"none"},{name:"rotate()",description:"Specifies a 2D rotation by the angle specified in the parameter about the origin of the element, as defined by the transform-origin property."},{name:"rotate3d()",description:"Specifies a clockwise 3D rotation by the angle specified in last parameter about the [x,y,z] direction vector described by the first 3 parameters."},{name:"rotateX('angle')",description:"Specifies a clockwise rotation by the given angle about the X axis."},{name:"rotateY('angle')",description:"Specifies a clockwise rotation by the given angle about the Y axis."},{name:"rotateZ('angle')",description:"Specifies a clockwise rotation by the given angle about the Z axis."},{name:"scale()",description:"Specifies a 2D scale operation by the [sx,sy] scaling vector described by the 2 parameters. If the second parameter is not provided, it is takes a value equal to the first."},{name:"scale3d()",description:"Specifies a 3D scale operation by the [sx,sy,sz] scaling vector described by the 3 parameters."},{name:"scaleX()",description:"Specifies a scale operation using the [sx,1] scaling vector, where sx is given as the parameter."},{name:"scaleY()",description:"Specifies a scale operation using the [sy,1] scaling vector, where sy is given as the parameter."},{name:"scaleZ()",description:"Specifies a scale operation using the [1,1,sz] scaling vector, where sz is given as the parameter."},{name:"skew()",description:"Specifies a skew transformation along the X and Y axes. The first angle parameter specifies the skew on the X axis. The second angle parameter specifies the skew on the Y axis. If the second parameter is not given then a value of 0 is used for the Y angle (ie: no skew on the Y axis)."},{name:"skewX()",description:"Specifies a skew transformation along the X axis by the given angle."},{name:"skewY()",description:"Specifies a skew transformation along the Y axis by the given angle."},{name:"translate()",description:"Specifies a 2D translation by the vector [tx, ty], where tx is the first translation-value parameter and ty is the optional second translation-value parameter."},{name:"translate3d()",description:"Specifies a 3D translation by the vector [tx,ty,tz], with tx, ty and tz being the first, second and third translation-value parameters respectively."},{name:"translateX()",description:"Specifies a translation by the given amount in the X direction."},{name:"translateY()",description:"Specifies a translation by the given amount in the Y direction."},{name:"translateZ()",description:"Specifies a translation by the given amount in the Z direction. Note that percentage values are not allowed in the translateZ translation-value, and if present are evaluated as 0."}],relevance:50,description:"A two-dimensional transformation is applied to an element through the 'transform' property. This property contains a list of transform functions similar to those allowed by SVG.",restrictions:["enum"]},{name:"-ms-transform-origin",browsers:["IE9-9"],relevance:50,description:"Establishes the origin of transformation for an element.",restrictions:["position","length","percentage"]},{name:"-ms-transform-origin-x",browsers:["IE10"],relevance:50,description:"The x coordinate of the origin for transforms applied to an element with respect to its border box.",restrictions:["length","percentage"]},{name:"-ms-transform-origin-y",browsers:["IE10"],relevance:50,description:"The y coordinate of the origin for transforms applied to an element with respect to its border box.",restrictions:["length","percentage"]},{name:"-ms-transform-origin-z",browsers:["IE10"],relevance:50,description:"The z coordinate of the origin for transforms applied to an element with respect to its border box.",restrictions:["length","percentage"]},{name:"-ms-user-select",browsers:["E","IE10"],values:[{name:"element"},{name:"none"},{name:"text"}],status:"nonstandard",syntax:"none | element | text",relevance:0,description:"Controls the appearance of selection.",restrictions:["enum"]},{name:"-ms-word-break",browsers:["IE8"],values:[{name:"break-all",description:"Lines may break between any two grapheme clusters for non-CJK scripts."},{name:"keep-all",description:"Block characters can no longer create implied break points."},{name:"normal",description:"Breaks non-CJK scripts according to their own rules."}],relevance:50,description:"Specifies line break opportunities for non-CJK scripts.",restrictions:["enum"]},{name:"-ms-word-wrap",browsers:["IE8"],values:[{name:"break-word",description:"An unbreakable 'word' may be broken at an arbitrary point if there are no otherwise-acceptable break points in the line."},{name:"normal",description:"Lines may break only at allowed break points."}],relevance:50,description:"Specifies whether the UA may break within a word to prevent overflow when an otherwise-unbreakable string is too long to fit.",restrictions:["enum"]},{name:"-ms-wrap-flow",browsers:["E","IE10"],values:[{name:"auto",description:"For floats an exclusion is created, for all other elements an exclusion is not created."},{name:"both",description:"Inline flow content can flow on all sides of the exclusion."},{name:"clear",description:"Inline flow content can only wrap on top and bottom of the exclusion and must leave the areas to the start and end edges of the exclusion box empty."},{name:"end",description:"Inline flow content can wrap on the end side of the exclusion area but must leave the area to the start edge of the exclusion area empty."},{name:"maximum",description:"Inline flow content can wrap on the side of the exclusion with the largest available space for the given line, and must leave the other side of the exclusion empty."},{name:"minimum",description:"Inline flow content can flow around the edge of the exclusion with the smallest available space within the flow content's containing block, and must leave the other edge of the exclusion empty."},{name:"start",description:"Inline flow content can wrap on the start edge of the exclusion area but must leave the area to end edge of the exclusion area empty."}],status:"nonstandard",syntax:"auto | both | start | end | maximum | clear",relevance:0,description:"An element becomes an exclusion when its 'wrap-flow' property has a computed value other than 'auto'.",restrictions:["enum"]},{name:"-ms-wrap-margin",browsers:["E","IE10"],status:"nonstandard",syntax:"<length>",relevance:0,description:"Gets or sets a value that is used to offset the inner wrap shape from other shapes.",restrictions:["length","percentage"]},{name:"-ms-wrap-through",browsers:["E","IE10"],values:[{name:"none",description:"The exclusion element does not inherit its parent node's wrapping context. Its descendants are only subject to exclusion shapes defined inside the element."},{name:"wrap",description:"The exclusion element inherits its parent node's wrapping context. Its descendant inline content wraps around exclusions defined outside the element."}],status:"nonstandard",syntax:"wrap | none",relevance:0,description:"Specifies if an element inherits its parent wrapping context. In other words if it is subject to the exclusions defined outside the element.",restrictions:["enum"]},{name:"-ms-writing-mode",browsers:["IE8"],values:[{name:"bt-lr"},{name:"bt-rl"},{name:"lr-bt"},{name:"lr-tb"},{name:"rl-bt"},{name:"rl-tb"},{name:"tb-lr"},{name:"tb-rl"}],relevance:50,description:"Shorthand property for both 'direction' and 'block-progression'.",restrictions:["enum"]},{name:"-ms-zoom",browsers:["IE8"],values:[{name:"normal"}],relevance:50,description:"Sets or retrieves the magnification scale of the object.",restrictions:["enum","integer","number","percentage"]},{name:"-ms-zoom-animation",browsers:["IE10"],values:[{name:"default"},{name:"none"}],relevance:50,description:"Gets or sets a value that indicates whether an animation is used when zooming.",restrictions:["enum"]},{name:"nav-down",browsers:["O9.5"],values:[{name:"auto",description:"The user agent automatically determines which element to navigate the focus to in response to directional navigational input."},{name:"current",description:"Indicates that the user agent should target the frame that the element is in."},{name:"root",description:"Indicates that the user agent should target the full window."}],relevance:50,description:"Provides an way to control directional focus navigation.",restrictions:["enum","identifier","string"]},{name:"nav-index",browsers:["O9.5"],values:[{name:"auto",description:"The element's sequential navigation order is assigned automatically by the user agent."}],relevance:50,description:"Provides an input-method-neutral way of specifying the sequential navigation order (also known as 'tabbing order').",restrictions:["number"]},{name:"nav-left",browsers:["O9.5"],values:[{name:"auto",description:"The user agent automatically determines which element to navigate the focus to in response to directional navigational input."},{name:"current",description:"Indicates that the user agent should target the frame that the element is in."},{name:"root",description:"Indicates that the user agent should target the full window."}],relevance:50,description:"Provides an way to control directional focus navigation.",restrictions:["enum","identifier","string"]},{name:"nav-right",browsers:["O9.5"],values:[{name:"auto",description:"The user agent automatically determines which element to navigate the focus to in response to directional navigational input."},{name:"current",description:"Indicates that the user agent should target the frame that the element is in."},{name:"root",description:"Indicates that the user agent should target the full window."}],relevance:50,description:"Provides an way to control directional focus navigation.",restrictions:["enum","identifier","string"]},{name:"nav-up",browsers:["O9.5"],values:[{name:"auto",description:"The user agent automatically determines which element to navigate the focus to in response to directional navigational input."},{name:"current",description:"Indicates that the user agent should target the frame that the element is in."},{name:"root",description:"Indicates that the user agent should target the full window."}],relevance:50,description:"Provides an way to control directional focus navigation.",restrictions:["enum","identifier","string"]},{name:"negative",browsers:["FF33"],atRule:"@counter-style",syntax:"<symbol> <symbol>?",relevance:50,description:"@counter-style descriptor. Defines how to alter the representation when the counter value is negative.",restrictions:["image","identifier","string"]},{name:"-o-animation",browsers:["O12"],values:[{name:"alternate",description:"The animation cycle iterations that are odd counts are played in the normal direction, and the animation cycle iterations that are even counts are played in a reverse direction."},{name:"alternate-reverse",description:"The animation cycle iterations that are odd counts are played in the reverse direction, and the animation cycle iterations that are even counts are played in a normal direction."},{name:"backwards",description:"The beginning property value (as defined in the first @keyframes at-rule) is applied before the animation is displayed, during the period defined by 'animation-delay'."},{name:"both",description:"Both forwards and backwards fill modes are applied."},{name:"forwards",description:"The final property value (as defined in the last @keyframes at-rule) is maintained after the animation completes."},{name:"infinite",description:"Causes the animation to repeat forever."},{name:"none",description:"No animation is performed"},{name:"normal",description:"Normal playback."},{name:"reverse",description:"All iterations of the animation are played in the reverse direction from the way they were specified."}],relevance:50,description:"Shorthand property combines six of the animation properties into a single property.",restrictions:["time","enum","timing-function","identifier","number"]},{name:"-o-animation-delay",browsers:["O12"],relevance:50,description:"Defines when the animation will start.",restrictions:["time"]},{name:"-o-animation-direction",browsers:["O12"],values:[{name:"alternate",description:"The animation cycle iterations that are odd counts are played in the normal direction, and the animation cycle iterations that are even counts are played in a reverse direction."},{name:"alternate-reverse",description:"The animation cycle iterations that are odd counts are played in the reverse direction, and the animation cycle iterations that are even counts are played in a normal direction."},{name:"normal",description:"Normal playback."},{name:"reverse",description:"All iterations of the animation are played in the reverse direction from the way they were specified."}],relevance:50,description:"Defines whether or not the animation should play in reverse on alternate cycles.",restrictions:["enum"]},{name:"-o-animation-duration",browsers:["O12"],relevance:50,description:"Defines the length of time that an animation takes to complete one cycle.",restrictions:["time"]},{name:"-o-animation-fill-mode",browsers:["O12"],values:[{name:"backwards",description:"The beginning property value (as defined in the first @keyframes at-rule) is applied before the animation is displayed, during the period defined by 'animation-delay'."},{name:"both",description:"Both forwards and backwards fill modes are applied."},{name:"forwards",description:"The final property value (as defined in the last @keyframes at-rule) is maintained after the animation completes."},{name:"none",description:"There is no change to the property value between the time the animation is applied and the time the animation begins playing or after the animation completes."}],relevance:50,description:"Defines what values are applied by the animation outside the time it is executing.",restrictions:["enum"]},{name:"-o-animation-iteration-count",browsers:["O12"],values:[{name:"infinite",description:"Causes the animation to repeat forever."}],relevance:50,description:"Defines the number of times an animation cycle is played. The default value is one, meaning the animation will play from beginning to end once.",restrictions:["number","enum"]},{name:"-o-animation-name",browsers:["O12"],values:[{name:"none",description:"No animation is performed"}],relevance:50,description:"Defines a list of animations that apply. Each name is used to select the keyframe at-rule that provides the property values for the animation.",restrictions:["identifier","enum"]},{name:"-o-animation-play-state",browsers:["O12"],values:[{name:"paused",description:"A running animation will be paused."},{name:"running",description:"Resume playback of a paused animation."}],relevance:50,description:"Defines whether the animation is running or paused.",restrictions:["enum"]},{name:"-o-animation-timing-function",browsers:["O12"],relevance:50,description:"Describes how the animation will progress over one cycle of its duration. See the 'transition-timing-function'.",restrictions:["timing-function"]},{name:"object-fit",browsers:["E79","FF36","S10","C32","O19"],values:[{name:"contain",description:"The replaced content is sized to maintain its aspect ratio while fitting within the element's content box: its concrete object size is resolved as a contain constraint against the element's used width and height."},{name:"cover",description:"The replaced content is sized to maintain its aspect ratio while filling the element's entire content box: its concrete object size is resolved as a cover constraint against the element's used width and height."},{name:"fill",description:"The replaced content is sized to fill the element's content box: the object's concrete object size is the element's used width and height."},{name:"none",description:"The replaced content is not resized to fit inside the element's content box"},{name:"scale-down",description:"Size the content as if 'none' or 'contain' were specified, whichever would result in a smaller concrete object size."}],syntax:"fill | contain | cover | none | scale-down",relevance:72,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/object-fit"}],description:"Specifies how the contents of a replaced element should be scaled relative to the box established by its used height and width.",restrictions:["enum"]},{name:"object-position",browsers:["E79","FF36","S10","C32","O19"],syntax:"<position>",relevance:57,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/object-position"}],description:"Determines the alignment of the replaced element inside its box.",restrictions:["position","length","percentage"]},{name:"-o-border-image",browsers:["O11.6"],values:[{name:"auto",description:"If 'auto' is specified then the border image width is the intrinsic width or height (whichever is applicable) of the corresponding image slice. If the image does not have the required intrinsic dimension then the corresponding border-width is used instead."},{name:"fill",description:"Causes the middle part of the border-image to be preserved."},{name:"none"},{name:"repeat",description:"The image is tiled (repeated) to fill the area."},{name:"round",description:"The image is tiled (repeated) to fill the area. If it does not fill the area with a whole number of tiles, the image is rescaled so that it does."},{name:"space",description:"The image is tiled (repeated) to fill the area. If it does not fill the area with a whole number of tiles, the extra space is distributed around the tiles."},{name:"stretch",description:"The image is stretched to fill the area."}],relevance:50,description:"Shorthand property for setting 'border-image-source', 'border-image-slice', 'border-image-width', 'border-image-outset' and 'border-image-repeat'. Omitted values are set to their initial values.",restrictions:["length","percentage","number","image","enum"]},{name:"-o-object-fit",browsers:["O10.6"],values:[{name:"contain",description:"The replaced content is sized to maintain its aspect ratio while fitting within the element's content box: its concrete object size is resolved as a contain constraint against the element's used width and height."},{name:"cover",description:"The replaced content is sized to maintain its aspect ratio while filling the element's entire content box: its concrete object size is resolved as a cover constraint against the element's used width and height."},{name:"fill",description:"The replaced content is sized to fill the element's content box: the object's concrete object size is the element's used width and height."},{name:"none",description:"The replaced content is not resized to fit inside the element's content box"},{name:"scale-down",description:"Size the content as if 'none' or 'contain' were specified, whichever would result in a smaller concrete object size."}],relevance:50,description:"Specifies how the contents of a replaced element should be scaled relative to the box established by its used height and width.",restrictions:["enum"]},{name:"-o-object-position",browsers:["O10.6"],relevance:50,description:"Determines the alignment of the replaced element inside its box.",restrictions:["position","length","percentage"]},{name:"opacity",browsers:["E12","FF1","S2","C1","IE9","O9"],syntax:"<alpha-value>",relevance:92,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/opacity"}],description:"Opacity of an element's text, where 1 is opaque and 0 is entirely transparent.",restrictions:["number(0-1)"]},{name:"order",browsers:["E12","FF20","S9","C29","IE11","O12.1"],syntax:"<integer>",relevance:67,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/order"}],description:"Controls the order in which children of a flex container appear within the flex container, by assigning them to ordinal groups.",restrictions:["integer"]},{name:"orphans",browsers:["E12","S1.3","C25","IE8","O9.2"],syntax:"<integer>",relevance:51,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/orphans"}],description:"Specifies the minimum number of line boxes in a block container that must be left in a fragment before a fragmentation break.",restrictions:["integer"]},{name:"-o-table-baseline",browsers:["O9.6"],relevance:50,description:"Determines which row of a inline-table should be used as baseline of inline-table.",restrictions:["integer"]},{name:"-o-tab-size",browsers:["O10.6"],relevance:50,description:"This property determines the width of the tab character (U+0009), in space characters (U+0020), when rendered.",restrictions:["integer","length"]},{name:"-o-text-overflow",browsers:["O10"],values:[{name:"clip",description:"Clip inline content that overflows. Characters may be only partially rendered."},{name:"ellipsis",description:"Render an ellipsis character (U+2026) to represent clipped inline content."}],relevance:50,description:"Text can overflow for example when it is prevented from wrapping",restrictions:["enum"]},{name:"-o-transform",browsers:["O10.5"],values:[{name:"matrix()",description:"Specifies a 2D transformation in the form of a transformation matrix of six values. matrix(a,b,c,d,e,f) is equivalent to applying the transformation matrix [a b c d e f]"},{name:"matrix3d()",description:"Specifies a 3D transformation as a 4x4 homogeneous matrix of 16 values in column-major order."},{name:"none"},{name:"rotate()",description:"Specifies a 2D rotation by the angle specified in the parameter about the origin of the element, as defined by the transform-origin property."},{name:"rotate3d()",description:"Specifies a clockwise 3D rotation by the angle specified in last parameter about the [x,y,z] direction vector described by the first 3 parameters."},{name:"rotateX('angle')",description:"Specifies a clockwise rotation by the given angle about the X axis."},{name:"rotateY('angle')",description:"Specifies a clockwise rotation by the given angle about the Y axis."},{name:"rotateZ('angle')",description:"Specifies a clockwise rotation by the given angle about the Z axis."},{name:"scale()",description:"Specifies a 2D scale operation by the [sx,sy] scaling vector described by the 2 parameters. If the second parameter is not provided, it is takes a value equal to the first."},{name:"scale3d()",description:"Specifies a 3D scale operation by the [sx,sy,sz] scaling vector described by the 3 parameters."},{name:"scaleX()",description:"Specifies a scale operation using the [sx,1] scaling vector, where sx is given as the parameter."},{name:"scaleY()",description:"Specifies a scale operation using the [sy,1] scaling vector, where sy is given as the parameter."},{name:"scaleZ()",description:"Specifies a scale operation using the [1,1,sz] scaling vector, where sz is given as the parameter."},{name:"skew()",description:"Specifies a skew transformation along the X and Y axes. The first angle parameter specifies the skew on the X axis. The second angle parameter specifies the skew on the Y axis. If the second parameter is not given then a value of 0 is used for the Y angle (ie: no skew on the Y axis)."},{name:"skewX()",description:"Specifies a skew transformation along the X axis by the given angle."},{name:"skewY()",description:"Specifies a skew transformation along the Y axis by the given angle."},{name:"translate()",description:"Specifies a 2D translation by the vector [tx, ty], where tx is the first translation-value parameter and ty is the optional second translation-value parameter."},{name:"translate3d()",description:"Specifies a 3D translation by the vector [tx,ty,tz], with tx, ty and tz being the first, second and third translation-value parameters respectively."},{name:"translateX()",description:"Specifies a translation by the given amount in the X direction."},{name:"translateY()",description:"Specifies a translation by the given amount in the Y direction."},{name:"translateZ()",description:"Specifies a translation by the given amount in the Z direction. Note that percentage values are not allowed in the translateZ translation-value, and if present are evaluated as 0."}],relevance:50,description:"A two-dimensional transformation is applied to an element through the 'transform' property. This property contains a list of transform functions similar to those allowed by SVG.",restrictions:["enum"]},{name:"-o-transform-origin",browsers:["O10.5"],relevance:50,description:"Establishes the origin of transformation for an element.",restrictions:["positon","length","percentage"]},{name:"-o-transition",browsers:["O11.5"],values:[{name:"all",description:"Every property that is able to undergo a transition will do so."},{name:"none",description:"No property will transition."}],relevance:50,description:"Shorthand property combines four of the transition properties into a single property.",restrictions:["time","property","timing-function","enum"]},{name:"-o-transition-delay",browsers:["O11.5"],relevance:50,description:"Defines when the transition will start. It allows a transition to begin execution some period of time from when it is applied.",restrictions:["time"]},{name:"-o-transition-duration",browsers:["O11.5"],relevance:50,description:"Specifies how long the transition from the old value to the new value should take.",restrictions:["time"]},{name:"-o-transition-property",browsers:["O11.5"],values:[{name:"all",description:"Every property that is able to undergo a transition will do so."},{name:"none",description:"No property will transition."}],relevance:50,description:"Specifies the name of the CSS property to which the transition is applied.",restrictions:["property"]},{name:"-o-transition-timing-function",browsers:["O11.5"],relevance:50,description:"Describes how the intermediate values used during a transition will be calculated.",restrictions:["timing-function"]},{name:"offset-block-end",browsers:["FF41"],values:[{name:"auto",description:"For non-replaced elements, the effect of this value depends on which of related properties have the value 'auto' as well."}],relevance:50,description:"Logical 'bottom'. Mapping depends on the parent element's 'writing-mode', 'direction', and 'text-orientation'.",restrictions:["length","percentage"]},{name:"offset-block-start",browsers:["FF41"],values:[{name:"auto",description:"For non-replaced elements, the effect of this value depends on which of related properties have the value 'auto' as well."}],relevance:50,description:"Logical 'top'. Mapping depends on the parent element's 'writing-mode', 'direction', and 'text-orientation'.",restrictions:["length","percentage"]},{name:"offset-inline-end",browsers:["FF41"],values:[{name:"auto",description:"For non-replaced elements, the effect of this value depends on which of related properties have the value 'auto' as well."}],relevance:50,description:"Logical 'right'. Mapping depends on the parent element's 'writing-mode', 'direction', and 'text-orientation'.",restrictions:["length","percentage"]},{name:"offset-inline-start",browsers:["FF41"],values:[{name:"auto",description:"For non-replaced elements, the effect of this value depends on which of related properties have the value 'auto' as well."}],relevance:50,description:"Logical 'left'. Mapping depends on the parent element's 'writing-mode', 'direction', and 'text-orientation'.",restrictions:["length","percentage"]},{name:"outline",browsers:["E94","FF88","S16.4","C94","IE8","O80"],values:[{name:"auto",description:"Permits the user agent to render a custom outline style, typically the default platform style."},{name:"invert",browsers:["E94","FF88","S16.4","C94","IE8","O80"],description:"Performs a color inversion on the pixels on the screen."}],syntax:"[ <'outline-color'> || <'outline-style'> || <'outline-width'> ]",relevance:88,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/outline"}],description:"Shorthand property for 'outline-style', 'outline-width', and 'outline-color'.",restrictions:["length","line-width","line-style","color","enum"]},{name:"outline-color",browsers:["E12","FF1.5","S1.2","C1","IE8","O7"],values:[{name:"invert",browsers:["E12","FF1.5","S1.2","C1","IE8","O7"],description:"Performs a color inversion on the pixels on the screen."}],syntax:"auto | <color>",relevance:61,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/outline-color"}],description:"The color of the outline.",restrictions:["enum","color"]},{name:"outline-offset",browsers:["E15","FF1.5","S1.2","C1","O9.5"],syntax:"<length>",relevance:69,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/outline-offset"}],description:"Offset the outline and draw it beyond the border edge.",restrictions:["length"]},{name:"outline-style",browsers:["E12","FF1.5","S1.2","C1","IE8","O7"],values:[{name:"auto",description:"Permits the user agent to render a custom outline style, typically the default platform style."}],syntax:"auto | <'border-style'>",relevance:61,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/outline-style"}],description:"Style of the outline.",restrictions:["line-style","enum"]},{name:"outline-width",browsers:["E12","FF1.5","S1.2","C1","IE8","O7"],syntax:"<line-width>",relevance:62,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/outline-width"}],description:"Width of the outline.",restrictions:["length","line-width"]},{name:"overflow",browsers:["E12","FF1","S1","C1","IE4","O7"],values:[{name:"auto",description:"The behavior of the 'auto' value is UA-dependent, but should cause a scrolling mechanism to be provided for overflowing boxes."},{name:"hidden",description:"Content is clipped and no scrolling mechanism should be provided to view the content outside the clipping region."},{name:"-moz-hidden-unscrollable",browsers:["E12","FF1","S1","C1","IE4","O7"],description:"Same as the standardized 'clip', except doesn't establish a block formatting context."},{name:"scroll",description:"Content is clipped and if the user agent uses a scrolling mechanism that is visible on the screen (such as a scroll bar or a panner), that mechanism should be displayed for a box whether or not any of its content is clipped."},{name:"visible",description:"Content is not clipped, i.e., it may be rendered outside the content box."}],syntax:"[ visible | hidden | clip | scroll | auto ]{1,2}",relevance:93,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/overflow"}],description:"Shorthand for setting 'overflow-x' and 'overflow-y'.",restrictions:["enum"]},{name:"overflow-wrap",browsers:["E18","FF49","S7","C23","IE5.5","O12.1"],values:[{name:"break-word",description:"An otherwise unbreakable sequence of characters may be broken at an arbitrary point if there are no otherwise-acceptable break points in the line."},{name:"normal",description:"Lines may break only at allowed break points."}],syntax:"normal | break-word | anywhere",relevance:65,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/overflow-wrap"}],description:"Specifies whether the UA may break within a word to prevent overflow when an otherwise-unbreakable string is too long to fit within the line box.",restrictions:["enum"]},{name:"overflow-x",browsers:["E12","FF3.5","S3","C1","IE5","O9.5"],values:[{name:"auto",description:"The behavior of the 'auto' value is UA-dependent, but should cause a scrolling mechanism to be provided for overflowing boxes."},{name:"hidden",description:"Content is clipped and no scrolling mechanism should be provided to view the content outside the clipping region."},{name:"scroll",description:"Content is clipped and if the user agent uses a scrolling mechanism that is visible on the screen (such as a scroll bar or a panner), that mechanism should be displayed for a box whether or not any of its content is clipped."},{name:"visible",description:"Content is not clipped, i.e., it may be rendered outside the content box."}],syntax:"visible | hidden | clip | scroll | auto",relevance:81,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/overflow-x"}],description:"Specifies the handling of overflow in the horizontal direction.",restrictions:["enum"]},{name:"overflow-y",browsers:["E12","FF3.5","S3","C1","IE5","O9.5"],values:[{name:"auto",description:"The behavior of the 'auto' value is UA-dependent, but should cause a scrolling mechanism to be provided for overflowing boxes."},{name:"hidden",description:"Content is clipped and no scrolling mechanism should be provided to view the content outside the clipping region."},{name:"scroll",description:"Content is clipped and if the user agent uses a scrolling mechanism that is visible on the screen (such as a scroll bar or a panner), that mechanism should be displayed for a box whether or not any of its content is clipped."},{name:"visible",description:"Content is not clipped, i.e., it may be rendered outside the content box."}],syntax:"visible | hidden | clip | scroll | auto",relevance:82,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/overflow-y"}],description:"Specifies the handling of overflow in the vertical direction.",restrictions:["enum"]},{name:"pad",browsers:["FF33"],atRule:"@counter-style",syntax:"<integer> && <symbol>",relevance:50,description:'@counter-style descriptor. Specifies a "fixed-width" counter style, where representations shorter than the pad value are padded with a particular <symbol>',restrictions:["integer","image","string","identifier"]},{name:"padding",browsers:["E12","FF1","S1","C1","IE4","O3.5"],values:[],syntax:"[ <length> | <percentage> ]{1,4}",relevance:95,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/padding"}],description:"Shorthand property to set values for the thickness of the padding area. If left is omitted, it is the same as right. If bottom is omitted it is the same as top, if right is omitted it is the same as top. The value may not be negative.",restrictions:["length","percentage"]},{name:"padding-bottom",browsers:["E12","FF1","S1","C1","IE4","O3.5"],syntax:"<length> | <percentage>",relevance:88,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/padding-bottom"}],description:"Shorthand property to set values for the thickness of the padding area. If left is omitted, it is the same as right. If bottom is omitted it is the same as top, if right is omitted it is the same as top. The value may not be negative.",restrictions:["length","percentage"]},{name:"padding-block-end",browsers:["E79","FF41","S12.1","C69","O56"],syntax:"<'padding-left'>",relevance:50,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/padding-block-end"}],description:"Logical 'padding-bottom'. Mapping depends on the parent element's 'writing-mode', 'direction', and 'text-orientation'.",restrictions:["length","percentage"]},{name:"padding-block-start",browsers:["E79","FF41","S12.1","C69","O56"],syntax:"<'padding-left'>",relevance:50,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/padding-block-start"}],description:"Logical 'padding-top'. Mapping depends on the parent element's 'writing-mode', 'direction', and 'text-orientation'.",restrictions:["length","percentage"]},{name:"padding-inline-end",browsers:["E79","FF41","S12.1","C69","O56"],syntax:"<'padding-left'>",relevance:55,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/padding-inline-end"}],description:"Logical 'padding-right'. Mapping depends on the parent element's 'writing-mode', 'direction', and 'text-orientation'.",restrictions:["length","percentage"]},{name:"padding-inline-start",browsers:["E79","FF41","S12.1","C69","O56"],syntax:"<'padding-left'>",relevance:56,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/padding-inline-start"}],description:"Logical 'padding-left'. Mapping depends on the parent element's 'writing-mode', 'direction', and 'text-orientation'.",restrictions:["length","percentage"]},{name:"padding-left",browsers:["E12","FF1","S1","C1","IE4","O3.5"],syntax:"<length> | <percentage>",relevance:89,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/padding-left"}],description:"Shorthand property to set values for the thickness of the padding area. If left is omitted, it is the same as right. If bottom is omitted it is the same as top, if right is omitted it is the same as top. The value may not be negative.",restrictions:["length","percentage"]},{name:"padding-right",browsers:["E12","FF1","S1","C1","IE4","O3.5"],syntax:"<length> | <percentage>",relevance:88,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/padding-right"}],description:"Shorthand property to set values for the thickness of the padding area. If left is omitted, it is the same as right. If bottom is omitted it is the same as top, if right is omitted it is the same as top. The value may not be negative.",restrictions:["length","percentage"]},{name:"padding-top",browsers:["E12","FF1","S1","C1","IE4","O3.5"],syntax:"<length> | <percentage>",relevance:89,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/padding-top"}],description:"Shorthand property to set values for the thickness of the padding area. If left is omitted, it is the same as right. If bottom is omitted it is the same as top, if right is omitted it is the same as top. The value may not be negative.",restrictions:["length","percentage"]},{name:"page-break-after",browsers:["E12","FF1","S1.2","C1","IE4","O7"],values:[{name:"always",description:"Always force a page break after the generated box."},{name:"auto",description:"Neither force nor forbid a page break after generated box."},{name:"avoid",description:"Avoid a page break after the generated box."},{name:"left",description:"Force one or two page breaks after the generated box so that the next page is formatted as a left page."},{name:"right",description:"Force one or two page breaks after the generated box so that the next page is formatted as a right page."}],syntax:"auto | always | avoid | left | right | recto | verso",relevance:52,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/page-break-after"}],description:"Defines rules for page breaks after an element.",restrictions:["enum"]},{name:"page-break-before",browsers:["E12","FF1","S1.2","C1","IE4","O7"],values:[{name:"always",description:"Always force a page break before the generated box."},{name:"auto",description:"Neither force nor forbid a page break before the generated box."},{name:"avoid",description:"Avoid a page break before the generated box."},{name:"left",description:"Force one or two page breaks before the generated box so that the next page is formatted as a left page."},{name:"right",description:"Force one or two page breaks before the generated box so that the next page is formatted as a right page."}],syntax:"auto | always | avoid | left | right | recto | verso",relevance:50,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/page-break-before"}],description:"Defines rules for page breaks before an element.",restrictions:["enum"]},{name:"page-break-inside",browsers:["E12","FF19","S1.3","C1","IE8","O7"],values:[{name:"auto",description:"Neither force nor forbid a page break inside the generated box."},{name:"avoid",description:"Avoid a page break inside the generated box."}],syntax:"auto | avoid",relevance:53,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/page-break-inside"}],description:"Defines rules for page breaks inside an element.",restrictions:["enum"]},{name:"paint-order",browsers:["E79","FF60","S11","C35","O22"],values:[{name:"fill"},{name:"markers"},{name:"normal",description:"The element is painted with the standard order of painting operations: the 'fill' is painted first, then its 'stroke' and finally its markers."},{name:"stroke"}],syntax:"normal | [ fill || stroke || markers ]",relevance:50,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/paint-order"}],description:"Controls the order that the three paint operations that shapes and text are rendered with: their fill, their stroke and any markers they might have.",restrictions:["enum"]},{name:"perspective",browsers:["E12","FF16","S9","C36","IE10","O23"],values:[{name:"none",description:"No perspective transform is applied."}],syntax:"none | <length>",relevance:55,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/perspective"}],description:"Applies the same transform as the perspective(<number>) transform function, except that it applies only to the positioned or transformed children of the element, not to the transform on the element itself.",restrictions:["length","enum"]},{name:"perspective-origin",browsers:["E12","FF16","S9","C36","IE10","O23"],syntax:"<position>",relevance:51,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/perspective-origin"}],description:"Establishes the origin for the perspective property. It effectively sets the X and Y position at which the viewer appears to be looking at the children of the element.",restrictions:["position","percentage","length"]},{name:"pointer-events",browsers:["E12","FF1.5","S4","C1","IE11","O9"],values:[{name:"all",description:"The given element can be the target element for pointer events whenever the pointer is over either the interior or the perimeter of the element."},{name:"fill",description:"The given element can be the target element for pointer events whenever the pointer is over the interior of the element."},{name:"none",description:"The given element does not receive pointer events."},{name:"painted",description:'The given element can be the target element for pointer events when the pointer is over a "painted" area. '},{name:"stroke",description:"The given element can be the target element for pointer events whenever the pointer is over the perimeter of the element."},{name:"visible",description:"The given element can be the target element for pointer events when the 'visibility' property is set to visible and the pointer is over either the interior or the perimeter of the element."},{name:"visibleFill",description:"The given element can be the target element for pointer events when the 'visibility' property is set to visible and when the pointer is over the interior of the element."},{name:"visiblePainted",description:"The given element can be the target element for pointer events when the 'visibility' property is set to visible and when the pointer is over a 'painted' area."},{name:"visibleStroke",description:"The given element can be the target element for pointer events when the 'visibility' property is set to visible and when the pointer is over the perimeter of the element."}],syntax:"auto | none | visiblePainted | visibleFill | visibleStroke | visible | painted | fill | stroke | all | inherit",relevance:82,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/pointer-events"}],description:"Specifies under what circumstances a given element can be the target element for a pointer event.",restrictions:["enum"]},{name:"position",browsers:["E12","FF1","S1","C1","IE4","O4"],values:[{name:"absolute",description:"The box's position (and possibly size) is specified with the 'top', 'right', 'bottom', and 'left' properties. These properties specify offsets with respect to the box's 'containing block'."},{name:"fixed",description:"The box's position is calculated according to the 'absolute' model, but in addition, the box is fixed with respect to some reference. As with the 'absolute' model, the box's margins do not collapse with any other margins."},{name:"-ms-page",browsers:["E12","FF1","S1","C1","IE4","O4"],description:"The box's position is calculated according to the 'absolute' model."},{name:"relative",description:"The box's position is calculated according to the normal flow (this is called the position in normal flow). Then the box is offset relative to its normal position."},{name:"static",description:"The box is a normal box, laid out according to the normal flow. The 'top', 'right', 'bottom', and 'left' properties do not apply."},{name:"sticky",browsers:["E12","FF1","S1","C1","IE4","O4"],description:"The box's position is calculated according to the normal flow. Then the box is offset relative to its flow root and containing block and in all cases, including table elements, does not affect the position of any following boxes."},{name:"-webkit-sticky",browsers:["E12","FF1","S1","C1","IE4","O4"],description:"The box's position is calculated according to the normal flow. Then the box is offset relative to its flow root and containing block and in all cases, including table elements, does not affect the position of any following boxes."}],syntax:"static | relative | absolute | sticky | fixed",relevance:95,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/position"}],description:"The position CSS property sets how an element is positioned in a document. The top, right, bottom, and left properties determine the final location of positioned elements.",restrictions:["enum"]},{name:"prefix",browsers:["FF33"],atRule:"@counter-style",syntax:"<symbol>",relevance:50,description:"@counter-style descriptor. Specifies a <symbol> that is prepended to the marker representation.",restrictions:["image","string","identifier"]},{name:"quotes",browsers:["E12","FF1.5","S9","C11","IE8","O4"],values:[{name:"none",description:"The 'open-quote' and 'close-quote' values of the 'content' property produce no quotations marks, as if they were 'no-open-quote' and 'no-close-quote' respectively."}],syntax:"none | auto | [ <string> <string> ]+",relevance:53,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/quotes"}],description:"Specifies quotation marks for any number of embedded quotations.",restrictions:["string"]},{name:"range",browsers:["FF33"],values:[{name:"auto",description:"The range depends on the counter system."},{name:"infinite",description:"If used as the first value in a range, it represents negative infinity; if used as the second value, it represents positive infinity."}],atRule:"@counter-style",syntax:"[ [ <integer> | infinite ]{2} ]# | auto",relevance:50,description:"@counter-style descriptor. Defines the ranges over which the counter style is defined.",restrictions:["integer","enum"]},{name:"resize",browsers:["E79","FF4","S3","C1","O12.1"],values:[{name:"both",description:"The UA presents a bidirectional resizing mechanism to allow the user to adjust both the height and the width of the element."},{name:"horizontal",description:"The UA presents a unidirectional horizontal resizing mechanism to allow the user to adjust only the width of the element."},{name:"none",description:"The UA does not present a resizing mechanism on the element, and the user is given no direct manipulation mechanism to resize the element."},{name:"vertical",description:"The UA presents a unidirectional vertical resizing mechanism to allow the user to adjust only the height of the element."}],syntax:"none | both | horizontal | vertical | block | inline",relevance:66,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/resize"}],description:"Specifies whether or not an element is resizable by the user, and if so, along which axis/axes.",restrictions:["enum"]},{name:"right",browsers:["E12","FF1","S1","C1","IE5.5","O5"],values:[{name:"auto",description:"For non-replaced elements, the effect of this value depends on which of related properties have the value 'auto' as well"}],syntax:"<length> | <percentage> | auto",relevance:91,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/right"}],description:"Specifies how far an absolutely positioned box's right margin edge is offset to the left of the right edge of the box's 'containing block'.",restrictions:["length","percentage"]},{name:"ruby-align",browsers:["FF38","Spreview"],values:[{name:"auto",browsers:["FF38","Spreview"],description:"The user agent determines how the ruby contents are aligned. This is the initial value."},{name:"center",description:"The ruby content is centered within its box."},{name:"distribute-letter",browsers:["FF38","Spreview"],description:"If the width of the ruby text is smaller than that of the base, then the ruby text contents are evenly distributed across the width of the base, with the first and last ruby text glyphs lining up with the corresponding first and last base glyphs. If the width of the ruby text is at least the width of the base, then the letters of the base are evenly distributed across the width of the ruby text."},{name:"distribute-space",browsers:["FF38","Spreview"],description:"If the width of the ruby text is smaller than that of the base, then the ruby text contents are evenly distributed across the width of the base, with a certain amount of white space preceding the first and following the last character in the ruby text. That amount of white space is normally equal to half the amount of inter-character space of the ruby text."},{name:"left",description:"The ruby text content is aligned with the start edge of the base."},{name:"line-edge",browsers:["FF38","Spreview"],description:"If the ruby text is not adjacent to a line edge, it is aligned as in 'auto'. If it is adjacent to a line edge, then it is still aligned as in auto, but the side of the ruby text that touches the end of the line is lined up with the corresponding edge of the base."},{name:"right",browsers:["FF38","Spreview"],description:"The ruby text content is aligned with the end edge of the base."},{name:"start",browsers:["FF38","Spreview"],description:"The ruby text content is aligned with the start edge of the base."},{name:"space-between",browsers:["FF38","Spreview"],description:"The ruby content expands as defined for normal text justification (as defined by 'text-justify'),"},{name:"space-around",browsers:["FF38","Spreview"],description:"As for 'space-between' except that there exists an extra justification opportunities whose space is distributed half before and half after the ruby content."}],status:"experimental",syntax:"start | center | space-between | space-around",relevance:50,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/ruby-align"}],description:"Specifies how text is distributed within the various ruby boxes when their contents do not exactly fill their respective boxes.",restrictions:["enum"]},{name:"ruby-overhang",browsers:["FF10","IE5"],values:[{name:"auto",description:"The ruby text can overhang text adjacent to the base on either side. This is the initial value."},{name:"end",description:"The ruby text can overhang the text that follows it."},{name:"none",description:"The ruby text cannot overhang any text adjacent to its base, only its own base."},{name:"start",description:"The ruby text can overhang the text that precedes it."}],relevance:50,description:"Determines whether, and on which side, ruby text is allowed to partially overhang any adjacent text in addition to its own base, when the ruby text is wider than the ruby base.",restrictions:["enum"]},{name:"ruby-position",browsers:["E84","FF38","S7","C84","O70"],values:[{name:"after",description:"The ruby text appears after the base. This is a relatively rare setting used in ideographic East Asian writing systems, most easily found in educational text."},{name:"before",description:"The ruby text appears before the base. This is the most common setting used in ideographic East Asian writing systems."},{name:"inline"},{name:"right",description:"The ruby text appears on the right of the base. Unlike 'before' and 'after', this value is not relative to the text flow direction."}],syntax:"[ alternate || [ over | under ] ] | inter-character",relevance:50,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/ruby-position"}],description:"Used by the parent of elements with display: ruby-text to control the position of the ruby text with respect to its base.",restrictions:["enum"]},{name:"ruby-span",browsers:["FF10"],values:[{name:"attr(x)",description:"The value of attribute 'x' is a string value. The string value is evaluated as a <number> to determine the number of ruby base elements to be spanned by the annotation element."},{name:"none",description:"No spanning. The computed value is '1'."}],relevance:50,description:"Determines whether, and on which side, ruby text is allowed to partially overhang any adjacent text in addition to its own base, when the ruby text is wider than the ruby base.",restrictions:["enum"]},{name:"scrollbar-3dlight-color",browsers:["IE5"],relevance:50,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/scrollbar-3dlight-color"}],description:"Determines the color of the top and left edges of the scroll box and scroll arrows of a scroll bar.",restrictions:["color"]},{name:"scrollbar-arrow-color",browsers:["IE5"],relevance:50,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/scrollbar-arrow-color"}],description:"Determines the color of the arrow elements of a scroll arrow.",restrictions:["color"]},{name:"scrollbar-base-color",browsers:["IE5"],relevance:50,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/scrollbar-base-color"}],description:"Determines the color of the main elements of a scroll bar, which include the scroll box, track, and scroll arrows.",restrictions:["color"]},{name:"scrollbar-darkshadow-color",browsers:["IE5"],relevance:50,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/scrollbar-darkshadow-color"}],description:"Determines the color of the gutter of a scroll bar.",restrictions:["color"]},{name:"scrollbar-face-color",browsers:["IE5"],relevance:50,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/scrollbar-face-color"}],description:"Determines the color of the scroll box and scroll arrows of a scroll bar.",restrictions:["color"]},{name:"scrollbar-highlight-color",browsers:["IE5"],relevance:50,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/scrollbar-highlight-color"}],description:"Determines the color of the top and left edges of the scroll box and scroll arrows of a scroll bar.",restrictions:["color"]},{name:"scrollbar-shadow-color",browsers:["IE5"],relevance:50,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/scrollbar-shadow-color"}],description:"Determines the color of the bottom and right edges of the scroll box and scroll arrows of a scroll bar.",restrictions:["color"]},{name:"scrollbar-track-color",browsers:["IE6"],relevance:50,description:"Determines the color of the track element of a scroll bar.",restrictions:["color"]},{name:"scroll-behavior",browsers:["E79","FF36","S15.4","C61","O48"],values:[{name:"auto",description:"Scrolls in an instant fashion."},{name:"smooth",description:"Scrolls in a smooth fashion using a user-agent-defined timing function and time period."}],syntax:"auto | smooth",relevance:55,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/scroll-behavior"}],description:"Specifies the scrolling behavior for a scrolling box, when scrolling happens due to navigation or CSSOM scrolling APIs.",restrictions:["enum"]},{name:"scroll-snap-coordinate",browsers:["FF39"],values:[{name:"none",description:"Specifies that this element does not contribute a snap point."}],status:"obsolete",syntax:"none | <position>#",relevance:0,description:"Defines the x and y coordinate within the element which will align with the nearest ancestor scroll container's snap-destination for the respective axis.",restrictions:["position","length","percentage","enum"]},{name:"scroll-snap-destination",browsers:["FF39"],status:"obsolete",syntax:"<position>",relevance:0,description:"Define the x and y coordinate within the scroll container's visual viewport which element snap points will align with.",restrictions:["position","length","percentage"]},{name:"scroll-snap-points-x",browsers:["FF39"],values:[{name:"none",description:"No snap points are defined by this scroll container."},{name:"repeat()",description:"Defines an interval at which snap points are defined, starting from the container's relevant start edge."}],status:"obsolete",syntax:"none | repeat( <length-percentage> )",relevance:0,description:"Defines the positioning of snap points along the x axis of the scroll container it is applied to.",restrictions:["enum"]},{name:"scroll-snap-points-y",browsers:["FF39"],values:[{name:"none",description:"No snap points are defined by this scroll container."},{name:"repeat()",description:"Defines an interval at which snap points are defined, starting from the container's relevant start edge."}],status:"obsolete",syntax:"none | repeat( <length-percentage> )",relevance:0,description:"Defines the positioning of snap points along the y axis of the scroll container it is applied to.",restrictions:["enum"]},{name:"scroll-snap-type",browsers:["E79","FF99","S11","C69","IE10","O56"],values:[{name:"none",description:"The visual viewport of this scroll container must ignore snap points, if any, when scrolled."},{name:"mandatory",description:"The visual viewport of this scroll container is guaranteed to rest on a snap point when there are no active scrolling operations."},{name:"proximity",description:"The visual viewport of this scroll container may come to rest on a snap point at the termination of a scroll at the discretion of the UA given the parameters of the scroll."}],syntax:"none | [ x | y | block | inline | both ] [ mandatory | proximity ]?",relevance:53,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/scroll-snap-type"}],description:"Defines how strictly snap points are enforced on the scroll container.",restrictions:["enum"]},{name:"shape-image-threshold",browsers:["E79","FF62","S10.1","C37","O24"],syntax:"<alpha-value>",relevance:50,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/shape-image-threshold"}],description:"Defines the alpha channel threshold used to extract the shape using an image. A value of 0.5 means that the shape will enclose all the pixels that are more than 50% opaque.",restrictions:["number"]},{name:"shape-margin",browsers:["E79","FF62","S10.1","C37","O24"],syntax:"<length-percentage>",relevance:50,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/shape-margin"}],description:"Adds a margin to a 'shape-outside'. This defines a new shape that is the smallest contour that includes all the points that are the 'shape-margin' distance outward in the perpendicular direction from a point on the underlying shape.",restrictions:["url","length","percentage"]},{name:"shape-outside",browsers:["E79","FF62","S10.1","C37","O24"],values:[{name:"margin-box",description:"The background is painted within (clipped to) the margin box."},{name:"none",description:"The float area is unaffected."}],syntax:"none | [ <shape-box> || <basic-shape> ] | <image>",relevance:50,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/shape-outside"}],description:"Specifies an orthogonal rotation to be applied to an image before it is laid out.",restrictions:["image","box","shape","enum"]},{name:"shape-rendering",browsers:["E80","FF72","S13.1","C80","O67"],values:[{name:"auto",description:"Suppresses aural rendering."},{name:"crispEdges",description:"Emphasize the contrast between clean edges of artwork over rendering speed and geometric precision."},{name:"geometricPrecision",description:"Emphasize geometric precision over speed and crisp edges."},{name:"optimizeSpeed",description:"Emphasize rendering speed over geometric precision and crisp edges."}],relevance:50,description:"Provides hints about what tradeoffs to make as it renders vector graphics elements such as <path> elements and basic shapes such as circles and rectangles.",restrictions:["enum"]},{name:"size",browsers:["C","O8"],atRule:"@page",syntax:"<length>{1,2} | auto | [ <page-size> || [ portrait | landscape ] ]",relevance:53,description:"The size CSS at-rule descriptor, used with the @page at-rule, defines the size and orientation of the box which is used to represent a page. Most of the time, this size corresponds to the target size of the printed page if applicable.",restrictions:["length"]},{name:"src",values:[{name:"url()",description:"Reference font by URL"},{name:"format()",description:"Optional hint describing the format of the font resource."},{name:"local()",description:"Format-specific string that identifies a locally available copy of a given font."}],atRule:"@font-face",syntax:"[ <url> [ format( <string># ) ]? | local( <family-name> ) ]#",relevance:86,description:"@font-face descriptor. Specifies the resource containing font data. It is required, whether the font is downloadable or locally installed.",restrictions:["enum","url","identifier"]},{name:"stop-color",browsers:["E80","FF72","S13.1","C80","O67"],relevance:50,description:"Indicates what color to use at that gradient stop.",restrictions:["color"]},{name:"stop-opacity",browsers:["E80","FF72","S13.1","C80","O67"],relevance:50,description:"Defines the opacity of a given gradient stop.",restrictions:["number(0-1)"]},{name:"stroke",browsers:["E80","FF72","S13.1","C80","O67"],values:[{name:"url()",description:"A URL reference to a paint server element, which is an element that defines a paint server: 'hatch', 'linearGradient', 'mesh', 'pattern', 'radialGradient' and 'solidcolor'."},{name:"none",description:"No paint is applied in this layer."}],relevance:67,description:"Paints along the outline of the given graphical element.",restrictions:["color","enum","url"]},{name:"stroke-dasharray",browsers:["E80","FF72","S13.1","C80","O67"],values:[{name:"none",description:"Indicates that no dashing is used."}],relevance:61,description:"Controls the pattern of dashes and gaps used to stroke paths.",restrictions:["length","percentage","number","enum"]},{name:"stroke-dashoffset",browsers:["E80","FF72","S13.1","C80","O67"],relevance:62,description:"Specifies the distance into the dash pattern to start the dash.",restrictions:["percentage","length"]},{name:"stroke-linecap",browsers:["E80","FF72","S13.1","C80","O67"],values:[{name:"butt",description:"Indicates that the stroke for each subpath does not extend beyond its two endpoints."},{name:"round",description:"Indicates that at each end of each subpath, the shape representing the stroke will be extended by a half circle with a radius equal to the stroke width."},{name:"square",description:"Indicates that at the end of each subpath, the shape representing the stroke will be extended by a rectangle with the same width as the stroke width and whose length is half of the stroke width."}],relevance:53,description:"Specifies the shape to be used at the end of open subpaths when they are stroked.",restrictions:["enum"]},{name:"stroke-linejoin",browsers:["E80","FF72","S13.1","C80","O67"],values:[{name:"bevel",description:"Indicates that a bevelled corner is to be used to join path segments."},{name:"miter",description:"Indicates that a sharp corner is to be used to join path segments."},{name:"round",description:"Indicates that a round corner is to be used to join path segments."}],relevance:51,description:"Specifies the shape to be used at the corners of paths or basic shapes when they are stroked.",restrictions:["enum"]},{name:"stroke-miterlimit",browsers:["E80","FF72","S13.1","C80","O67"],relevance:51,description:"When two line segments meet at a sharp angle and miter joins have been specified for 'stroke-linejoin', it is possible for the miter to extend far beyond the thickness of the line stroking the path.",restrictions:["number"]},{name:"stroke-opacity",browsers:["E80","FF72","S13.1","C80","O67"],relevance:52,description:"Specifies the opacity of the painting operation used to stroke the current object.",restrictions:["number(0-1)"]},{name:"stroke-width",browsers:["E80","FF72","S13.1","C80","O67"],relevance:64,description:"Specifies the width of the stroke on the current object.",restrictions:["percentage","length"]},{name:"suffix",browsers:["FF33"],atRule:"@counter-style",syntax:"<symbol>",relevance:50,description:"@counter-style descriptor. Specifies a <symbol> that is appended to the marker representation.",restrictions:["image","string","identifier"]},{name:"system",browsers:["FF33"],values:[{name:"additive",description:'Represents "sign-value" numbering systems, which, rather than using reusing digits in different positions to change their value, define additional digits with much larger values, so that the value of the number can be obtained by adding all the digits together.'},{name:"alphabetic",description:'Interprets the list of counter symbols as digits to an alphabetic numbering system, similar to the default lower-alpha counter style, which wraps from "a", "b", "c", to "aa", "ab", "ac".'},{name:"cyclic",description:"Cycles repeatedly through its provided symbols, looping back to the beginning when it reaches the end of the list."},{name:"extends",description:"Use the algorithm of another counter style, but alter other aspects."},{name:"fixed",description:"Runs through its list of counter symbols once, then falls back."},{name:"numeric",description:`interprets the list of counter symbols as digits to a "place-value" numbering system, similar to the default 'decimal' counter style.`},{name:"symbolic",description:"Cycles repeatedly through its provided symbols, doubling, tripling, etc. the symbols on each successive pass through the list."}],atRule:"@counter-style",syntax:"cyclic | numeric | alphabetic | symbolic | additive | [ fixed <integer>? ] | [ extends <counter-style-name> ]",relevance:50,description:"@counter-style descriptor. Specifies which algorithm will be used to construct the counter's representation based on the counter value.",restrictions:["enum","integer"]},{name:"symbols",browsers:["FF33"],atRule:"@counter-style",syntax:"<symbol>+",relevance:50,description:"@counter-style descriptor. Specifies the symbols used by the marker-construction algorithm specified by the system descriptor.",restrictions:["image","string","identifier"]},{name:"table-layout",browsers:["E12","FF1","S1","C14","IE5","O7"],values:[{name:"auto",description:"Use any automatic table layout algorithm."},{name:"fixed",description:"Use the fixed table layout algorithm."}],syntax:"auto | fixed",relevance:58,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/table-layout"}],description:"Controls the algorithm used to lay out the table cells, rows, and columns.",restrictions:["enum"]},{name:"tab-size",browsers:["E79","FF91","S7","C21","O15"],syntax:"<integer> | <length>",relevance:53,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/tab-size"}],description:"Determines the width of the tab character (U+0009), in space characters (U+0020), when rendered.",restrictions:["integer","length"]},{name:"text-align",browsers:["E12","FF1","S1","C1","IE3","O3.5"],values:[{name:"center",description:"The inline contents are centered within the line box."},{name:"end",browsers:["E12","FF1","S1","C1","IE3","O3.5"],description:"The inline contents are aligned to the end edge of the line box."},{name:"justify",description:"The text is justified according to the method specified by the 'text-justify' property."},{name:"left",description:"The inline contents are aligned to the left edge of the line box. In vertical text, 'left' aligns to the edge of the line box that would be the start edge for left-to-right text."},{name:"right",description:"The inline contents are aligned to the right edge of the line box. In vertical text, 'right' aligns to the edge of the line box that would be the end edge for left-to-right text."},{name:"start",browsers:["E12","FF1","S1","C1","IE3","O3.5"],description:"The inline contents are aligned to the start edge of the line box."}],syntax:"start | end | left | right | center | justify | match-parent",relevance:93,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/text-align"}],description:"Describes how inline contents of a block are horizontally aligned if the contents do not completely fill the line box.",restrictions:["string"]},{name:"text-align-last",browsers:["E12","FF49","S16","C47","IE5.5","O34"],values:[{name:"auto",description:"Content on the affected line is aligned per 'text-align' unless 'text-align' is set to 'justify', in which case it is 'start-aligned'."},{name:"center",description:"The inline contents are centered within the line box."},{name:"justify",description:"The text is justified according to the method specified by the 'text-justify' property."},{name:"left",description:"The inline contents are aligned to the left edge of the line box. In vertical text, 'left' aligns to the edge of the line box that would be the start edge for left-to-right text."},{name:"right",description:"The inline contents are aligned to the right edge of the line box. In vertical text, 'right' aligns to the edge of the line box that would be the end edge for left-to-right text."}],syntax:"auto | start | end | left | right | center | justify",relevance:51,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/text-align-last"}],description:"Describes how the last line of a block or a line right before a forced line break is aligned when 'text-align' is set to 'justify'.",restrictions:["enum"]},{name:"text-anchor",browsers:["E80","FF72","S13.1","C80","O67"],values:[{name:"end",description:"The rendered characters are aligned such that the end of the resulting rendered text is at the initial current text position."},{name:"middle",description:"The rendered characters are aligned such that the geometric middle of the resulting rendered text is at the initial current text position."},{name:"start",description:"The rendered characters are aligned such that the start of the resulting rendered text is at the initial current text position."}],relevance:50,description:"Used to align (start-, middle- or end-alignment) a string of text relative to a given point.",restrictions:["enum"]},{name:"text-decoration",browsers:["E12","FF1","S1","C1","IE3","O3.5"],values:[{name:"dashed",description:"Produces a dashed line style."},{name:"dotted",description:"Produces a dotted line."},{name:"double",description:"Produces a double line."},{name:"line-through",description:"Each line of text has a line through the middle."},{name:"none",description:"Produces no line."},{name:"overline",description:"Each line of text has a line above it."},{name:"solid",description:"Produces a solid line."},{name:"underline",description:"Each line of text is underlined."},{name:"wavy",description:"Produces a wavy line."}],syntax:"<'text-decoration-line'> || <'text-decoration-style'> || <'text-decoration-color'> || <'text-decoration-thickness'>",relevance:91,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/text-decoration"}],description:"Decorations applied to font used for an element's text.",restrictions:["enum","color"]},{name:"text-decoration-color",browsers:["E79","FF36","S12.1","C57","O44"],syntax:"<color>",relevance:55,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/text-decoration-color"}],description:"Specifies the color of text decoration (underlines overlines, and line-throughs) set on the element with text-decoration-line.",restrictions:["color"]},{name:"text-decoration-line",browsers:["E79","FF36","S12.1","C57","O44"],values:[{name:"line-through",description:"Each line of text has a line through the middle."},{name:"none",description:"Neither produces nor inhibits text decoration."},{name:"overline",description:"Each line of text has a line above it."},{name:"underline",description:"Each line of text is underlined."}],syntax:"none | [ underline || overline || line-through || blink ] | spelling-error | grammar-error",relevance:57,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/text-decoration-line"}],description:"Specifies what line decorations, if any, are added to the element.",restrictions:["enum"]},{name:"text-decoration-style",browsers:["E79","FF36","S12.1","C57","O44"],values:[{name:"dashed",description:"Produces a dashed line style."},{name:"dotted",description:"Produces a dotted line."},{name:"double",description:"Produces a double line."},{name:"none",description:"Produces no line."},{name:"solid",description:"Produces a solid line."},{name:"wavy",description:"Produces a wavy line."}],syntax:"solid | double | dotted | dashed | wavy",relevance:51,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/text-decoration-style"}],description:"Specifies the line style for underline, line-through and overline text decoration.",restrictions:["enum"]},{name:"text-indent",browsers:["E12","FF1","S1","C1","IE3","O3.5"],values:[],syntax:"<length-percentage> && hanging? && each-line?",relevance:67,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/text-indent"}],description:"Specifies the indentation applied to lines of inline content in a block. The indentation only affects the first line of inline content in the block unless the 'hanging' keyword is specified, in which case it affects all lines except the first.",restrictions:["percentage","length"]},{name:"text-justify",browsers:["E79","FF55","C32","IE11","O19"],values:[{name:"auto",description:"The UA determines the justification algorithm to follow, based on a balance between performance and adequate presentation quality."},{name:"distribute",description:"Justification primarily changes spacing both at word separators and at grapheme cluster boundaries in all scripts except those in the connected and cursive groups. This value is sometimes used in e.g. Japanese, often with the 'text-align-last' property."},{name:"distribute-all-lines"},{name:"inter-cluster",description:"Justification primarily changes spacing at word separators and at grapheme cluster boundaries in clustered scripts. This value is typically used for Southeast Asian scripts such as Thai."},{name:"inter-ideograph",description:"Justification primarily changes spacing at word separators and at inter-graphemic boundaries in scripts that use no word spaces. This value is typically used for CJK languages."},{name:"inter-word",description:"Justification primarily changes spacing at word separators. This value is typically used for languages that separate words using spaces, like English or (sometimes) Korean."},{name:"kashida",description:"Justification primarily stretches Arabic and related scripts through the use of kashida or other calligraphic elongation."},{name:"newspaper"}],syntax:"auto | inter-character | inter-word | none",relevance:50,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/text-justify"}],description:"Selects the justification algorithm used when 'text-align' is set to 'justify'. The property applies to block containers, but the UA may (but is not required to) also support it on inline elements.",restrictions:["enum"]},{name:"text-orientation",browsers:["E79","FF41","S14","C48","O35"],values:[{name:"sideways",browsers:["E79","FF41","S14","C48","O35"],description:"This value is equivalent to 'sideways-right' in 'vertical-rl' writing mode and equivalent to 'sideways-left' in 'vertical-lr' writing mode."},{name:"sideways-right",browsers:["E79","FF41","S14","C48","O35"],description:"In vertical writing modes, this causes text to be set as if in a horizontal layout, but rotated 90\xB0 clockwise."},{name:"upright",description:"In vertical writing modes, characters from horizontal-only scripts are rendered upright, i.e. in their standard horizontal orientation."}],syntax:"mixed | upright | sideways",relevance:50,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/text-orientation"}],description:"Specifies the orientation of text within a line.",restrictions:["enum"]},{name:"text-overflow",browsers:["E12","FF7","S1.3","C1","IE6","O11"],values:[{name:"clip",description:"Clip inline content that overflows. Characters may be only partially rendered."},{name:"ellipsis",description:"Render an ellipsis character (U+2026) to represent clipped inline content."}],syntax:"[ clip | ellipsis | <string> ]{1,2}",relevance:82,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/text-overflow"}],description:"Text can overflow for example when it is prevented from wrapping.",restrictions:["enum","string"]},{name:"text-rendering",browsers:["E79","FF1","S5","C4","O15"],values:[{name:"auto"},{name:"geometricPrecision",description:"Indicates that the user agent shall emphasize geometric precision over legibility and rendering speed."},{name:"optimizeLegibility",description:"Indicates that the user agent shall emphasize legibility over rendering speed and geometric precision."},{name:"optimizeSpeed",description:"Indicates that the user agent shall emphasize rendering speed over legibility and geometric precision."}],syntax:"auto | optimizeSpeed | optimizeLegibility | geometricPrecision",relevance:68,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/text-rendering"}],description:"The creator of SVG content might want to provide a hint to the implementation about what tradeoffs to make as it renders text. The 'text-rendering' property provides these hints.",restrictions:["enum"]},{name:"text-shadow",browsers:["E12","FF3.5","S1.1","C2","IE10","O9.5"],values:[{name:"none",description:"No shadow."}],syntax:"none | <shadow-t>#",relevance:73,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/text-shadow"}],description:"Enables shadow effects to be applied to the text of the element.",restrictions:["length","color"]},{name:"text-transform",browsers:["E12","FF1","S1","C1","IE4","O7"],values:[{name:"capitalize",description:"Puts the first typographic letter unit of each word in titlecase."},{name:"lowercase",description:"Puts all letters in lowercase."},{name:"none",description:"No effects."},{name:"uppercase",description:"Puts all letters in uppercase."}],syntax:"none | capitalize | uppercase | lowercase | full-width | full-size-kana",relevance:86,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/text-transform"}],description:"Controls capitalization effects of an element's text.",restrictions:["enum"]},{name:"text-underline-position",browsers:["E12","FF74","S12.1","C33","IE6","O20"],values:[{name:"above"},{name:"auto",description:"The user agent may use any algorithm to determine the underline's position. In horizontal line layout, the underline should be aligned as for alphabetic. In vertical line layout, if the language is set to Japanese or Korean, the underline should be aligned as for over."},{name:"below",description:"The underline is aligned with the under edge of the element's content box."}],syntax:"auto | from-font | [ under || [ left | right ] ]",relevance:50,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/text-underline-position"}],description:"Sets the position of an underline specified on the same element: it does not affect underlines specified by ancestor elements. This property is typically used in vertical writing contexts such as in Japanese documents where it often desired to have the underline appear 'over' (to the right of) the affected run of text",restrictions:["enum"]},{name:"top",browsers:["E12","FF1","S1","C1","IE5","O6"],values:[{name:"auto",description:"For non-replaced elements, the effect of this value depends on which of related properties have the value 'auto' as well"}],syntax:"<length> | <percentage> | auto",relevance:95,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/top"}],description:"Specifies how far an absolutely positioned box's top margin edge is offset below the top edge of the box's 'containing block'.",restrictions:["length","percentage"]},{name:"touch-action",browsers:["E12","FF52","S13","C36","IE11","O23"],values:[{name:"auto",description:"The user agent may determine any permitted touch behaviors for touches that begin on the element."},{name:"cross-slide-x",browsers:["E12","FF52","S13","C36","IE11","O23"]},{name:"cross-slide-y",browsers:["E12","FF52","S13","C36","IE11","O23"]},{name:"double-tap-zoom",browsers:["E12","FF52","S13","C36","IE11","O23"]},{name:"manipulation",description:"The user agent may consider touches that begin on the element only for the purposes of scrolling and continuous zooming."},{name:"none",description:"Touches that begin on the element must not trigger default touch behaviors."},{name:"pan-x",description:"The user agent may consider touches that begin on the element only for the purposes of horizontally scrolling the element's nearest ancestor with horizontally scrollable content."},{name:"pan-y",description:"The user agent may consider touches that begin on the element only for the purposes of vertically scrolling the element's nearest ancestor with vertically scrollable content."},{name:"pinch-zoom",browsers:["E12","FF52","S13","C36","IE11","O23"]}],syntax:"auto | none | [ [ pan-x | pan-left | pan-right ] || [ pan-y | pan-up | pan-down ] || pinch-zoom ] | manipulation",relevance:69,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/touch-action"}],description:"Determines whether touch input may trigger default behavior supplied by user agent.",restrictions:["enum"]},{name:"transform",browsers:["E12","FF16","S9","C36","IE10","O23"],values:[{name:"matrix()",description:"Specifies a 2D transformation in the form of a transformation matrix of six values. matrix(a,b,c,d,e,f) is equivalent to applying the transformation matrix [a b c d e f]"},{name:"matrix3d()",description:"Specifies a 3D transformation as a 4x4 homogeneous matrix of 16 values in column-major order."},{name:"none"},{name:"perspective()",description:"Specifies a perspective projection matrix."},{name:"rotate()",description:"Specifies a 2D rotation by the angle specified in the parameter about the origin of the element, as defined by the transform-origin property."},{name:"rotate3d()",description:"Specifies a clockwise 3D rotation by the angle specified in last parameter about the [x,y,z] direction vector described by the first 3 parameters."},{name:"rotateX('angle')",description:"Specifies a clockwise rotation by the given angle about the X axis."},{name:"rotateY('angle')",description:"Specifies a clockwise rotation by the given angle about the Y axis."},{name:"rotateZ('angle')",description:"Specifies a clockwise rotation by the given angle about the Z axis."},{name:"scale()",description:"Specifies a 2D scale operation by the [sx,sy] scaling vector described by the 2 parameters. If the second parameter is not provided, it is takes a value equal to the first."},{name:"scale3d()",description:"Specifies a 3D scale operation by the [sx,sy,sz] scaling vector described by the 3 parameters."},{name:"scaleX()",description:"Specifies a scale operation using the [sx,1] scaling vector, where sx is given as the parameter."},{name:"scaleY()",description:"Specifies a scale operation using the [sy,1] scaling vector, where sy is given as the parameter."},{name:"scaleZ()",description:"Specifies a scale operation using the [1,1,sz] scaling vector, where sz is given as the parameter."},{name:"skew()",description:"Specifies a skew transformation along the X and Y axes. The first angle parameter specifies the skew on the X axis. The second angle parameter specifies the skew on the Y axis. If the second parameter is not given then a value of 0 is used for the Y angle (ie: no skew on the Y axis)."},{name:"skewX()",description:"Specifies a skew transformation along the X axis by the given angle."},{name:"skewY()",description:"Specifies a skew transformation along the Y axis by the given angle."},{name:"translate()",description:"Specifies a 2D translation by the vector [tx, ty], where tx is the first translation-value parameter and ty is the optional second translation-value parameter."},{name:"translate3d()",description:"Specifies a 3D translation by the vector [tx,ty,tz], with tx, ty and tz being the first, second and third translation-value parameters respectively."},{name:"translateX()",description:"Specifies a translation by the given amount in the X direction."},{name:"translateY()",description:"Specifies a translation by the given amount in the Y direction."},{name:"translateZ()",description:"Specifies a translation by the given amount in the Z direction. Note that percentage values are not allowed in the translateZ translation-value, and if present are evaluated as 0."}],syntax:"none | <transform-list>",relevance:90,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/transform"}],description:"A two-dimensional transformation is applied to an element through the 'transform' property. This property contains a list of transform functions similar to those allowed by SVG.",restrictions:["enum"]},{name:"transform-origin",browsers:["E12","FF16","S9","C36","IE10","O23"],syntax:"[ <length-percentage> | left | center | right | top | bottom ] | [ [ <length-percentage> | left | center | right ] && [ <length-percentage> | top | center | bottom ] ] <length>?",relevance:76,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/transform-origin"}],description:"Establishes the origin of transformation for an element.",restrictions:["position","length","percentage"]},{name:"transform-style",browsers:["E12","FF16","S9","C36","O23"],values:[{name:"flat",description:"All children of this element are rendered flattened into the 2D plane of the element."},{name:"preserve-3d",browsers:["E12","FF16","S9","C36","O23"],description:"Flattening is not performed, so children maintain their position in 3D space."}],syntax:"flat | preserve-3d",relevance:56,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/transform-style"}],description:"Defines how nested elements are rendered in 3D space.",restrictions:["enum"]},{name:"transition",browsers:["E12","FF16","S9","C26","IE10","O12.1"],values:[{name:"all",description:"Every property that is able to undergo a transition will do so."},{name:"none",description:"No property will transition."}],syntax:"<single-transition>#",relevance:89,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/transition"}],description:"Shorthand property combines four of the transition properties into a single property.",restrictions:["time","property","timing-function","enum"]},{name:"transition-delay",browsers:["E12","FF16","S9","C26","IE10","O12.1"],syntax:"<time>#",relevance:64,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/transition-delay"}],description:"Defines when the transition will start. It allows a transition to begin execution some period of time from when it is applied.",restrictions:["time"]},{name:"transition-duration",browsers:["E12","FF16","S9","C26","IE10","O12.1"],syntax:"<time>#",relevance:68,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/transition-duration"}],description:"Specifies how long the transition from the old value to the new value should take.",restrictions:["time"]},{name:"transition-property",browsers:["E12","FF16","S9","C26","IE10","O12.1"],values:[{name:"all",description:"Every property that is able to undergo a transition will do so."},{name:"none",description:"No property will transition."}],syntax:"none | <single-transition-property>#",relevance:68,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/transition-property"}],description:"Specifies the name of the CSS property to which the transition is applied.",restrictions:["property"]},{name:"transition-timing-function",browsers:["E12","FF16","S9","C26","IE10","O12.1"],syntax:"<easing-function>#",relevance:65,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/transition-timing-function"}],description:"Describes how the intermediate values used during a transition will be calculated.",restrictions:["timing-function"]},{name:"unicode-bidi",browsers:["E12","FF1","S1.3","C2","IE5.5","O9.2"],values:[{name:"bidi-override",description:"Inside the element, reordering is strictly in sequence according to the 'direction' property; the implicit part of the bidirectional algorithm is ignored."},{name:"embed",description:"If the element is inline-level, this value opens an additional level of embedding with respect to the bidirectional algorithm. The direction of this embedding level is given by the 'direction' property."},{name:"isolate",browsers:["E12","FF1","S1.3","C2","IE5.5","O9.2"],description:"The contents of the element are considered to be inside a separate, independent paragraph."},{name:"isolate-override",browsers:["E12","FF1","S1.3","C2","IE5.5","O9.2"],description:"This combines the isolation behavior of 'isolate' with the directional override behavior of 'bidi-override'"},{name:"normal",description:"The element does not open an additional level of embedding with respect to the bidirectional algorithm. For inline-level elements, implicit reordering works across element boundaries."},{name:"plaintext",browsers:["E12","FF1","S1.3","C2","IE5.5","O9.2"],description:"For the purposes of the Unicode bidirectional algorithm, the base directionality of each bidi paragraph for which the element forms the containing block is determined not by the element's computed 'direction'."}],syntax:"normal | embed | isolate | bidi-override | isolate-override | plaintext",relevance:56,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/unicode-bidi"}],description:"The level of embedding with respect to the bidirectional algorithm.",restrictions:["enum"]},{name:"unicode-range",values:[{name:"U+26",description:"Ampersand."},{name:"U+20-24F, U+2B0-2FF, U+370-4FF, U+1E00-1EFF, U+2000-20CF, U+2100-23FF, U+2500-26FF, U+E000-F8FF, U+FB00-FB4F",description:"WGL4 character set (Pan-European)."},{name:"U+20-17F, U+2B0-2FF, U+2000-206F, U+20A0-20CF, U+2100-21FF, U+2600-26FF",description:"The Multilingual European Subset No. 1. Latin. Covers ~44 languages."},{name:"U+20-2FF, U+370-4FF, U+1E00-20CF, U+2100-23FF, U+2500-26FF, U+FB00-FB4F, U+FFF0-FFFD",description:"The Multilingual European Subset No. 2. Latin, Greek, and Cyrillic. Covers ~128 language."},{name:"U+20-4FF, U+530-58F, U+10D0-10FF, U+1E00-23FF, U+2440-245F, U+2500-26FF, U+FB00-FB4F, U+FE20-FE2F, U+FFF0-FFFD",description:"The Multilingual European Subset No. 3. Covers all characters belonging to European scripts."},{name:"U+00-7F",description:"Basic Latin (ASCII)."},{name:"U+80-FF",description:"Latin-1 Supplement. Accented characters for Western European languages, common punctuation characters, multiplication and division signs."},{name:"U+100-17F",description:"Latin Extended-A. Accented characters for for Czech, Dutch, Polish, and Turkish."},{name:"U+180-24F",description:"Latin Extended-B. Croatian, Slovenian, Romanian, Non-European and historic latin, Khoisan, Pinyin, Livonian, Sinology."},{name:"U+1E00-1EFF",description:"Latin Extended Additional. Vietnamese, German captial sharp s, Medievalist, Latin general use."},{name:"U+250-2AF",description:"International Phonetic Alphabet Extensions."},{name:"U+370-3FF",description:"Greek and Coptic."},{name:"U+1F00-1FFF",description:"Greek Extended. Accented characters for polytonic Greek."},{name:"U+400-4FF",description:"Cyrillic."},{name:"U+500-52F",description:"Cyrillic Supplement. Extra letters for Komi, Khanty, Chukchi, Mordvin, Kurdish, Aleut, Chuvash, Abkhaz, Azerbaijani, and Orok."},{name:"U+00-52F, U+1E00-1FFF, U+2200-22FF",description:"Latin, Greek, Cyrillic, some punctuation and symbols."},{name:"U+530-58F",description:"Armenian."},{name:"U+590-5FF",description:"Hebrew."},{name:"U+600-6FF",description:"Arabic."},{name:"U+750-77F",description:"Arabic Supplement. Additional letters for African languages, Khowar, Torwali, Burushaski, and early Persian."},{name:"U+8A0-8FF",description:"Arabic Extended-A. Additional letters for African languages, European and Central Asian languages, Rohingya, Tamazight, Arwi, and Koranic annotation signs."},{name:"U+700-74F",description:"Syriac."},{name:"U+900-97F",description:"Devanagari."},{name:"U+980-9FF",description:"Bengali."},{name:"U+A00-A7F",description:"Gurmukhi."},{name:"U+A80-AFF",description:"Gujarati."},{name:"U+B00-B7F",description:"Oriya."},{name:"U+B80-BFF",description:"Tamil."},{name:"U+C00-C7F",description:"Telugu."},{name:"U+C80-CFF",description:"Kannada."},{name:"U+D00-D7F",description:"Malayalam."},{name:"U+D80-DFF",description:"Sinhala."},{name:"U+118A0-118FF",description:"Warang Citi."},{name:"U+E00-E7F",description:"Thai."},{name:"U+1A20-1AAF",description:"Tai Tham."},{name:"U+AA80-AADF",description:"Tai Viet."},{name:"U+E80-EFF",description:"Lao."},{name:"U+F00-FFF",description:"Tibetan."},{name:"U+1000-109F",description:"Myanmar (Burmese)."},{name:"U+10A0-10FF",description:"Georgian."},{name:"U+1200-137F",description:"Ethiopic."},{name:"U+1380-139F",description:"Ethiopic Supplement. Extra Syllables for Sebatbeit, and Tonal marks"},{name:"U+2D80-2DDF",description:"Ethiopic Extended. Extra Syllables for Me'en, Blin, and Sebatbeit."},{name:"U+AB00-AB2F",description:"Ethiopic Extended-A. Extra characters for Gamo-Gofa-Dawro, Basketo, and Gumuz."},{name:"U+1780-17FF",description:"Khmer."},{name:"U+1800-18AF",description:"Mongolian."},{name:"U+1B80-1BBF",description:"Sundanese."},{name:"U+1CC0-1CCF",description:"Sundanese Supplement. Punctuation."},{name:"U+4E00-9FD5",description:"CJK (Chinese, Japanese, Korean) Unified Ideographs. Most common ideographs for modern Chinese and Japanese."},{name:"U+3400-4DB5",description:"CJK Unified Ideographs Extension A. Rare ideographs."},{name:"U+2F00-2FDF",description:"Kangxi Radicals."},{name:"U+2E80-2EFF",description:"CJK Radicals Supplement. Alternative forms of Kangxi Radicals."},{name:"U+1100-11FF",description:"Hangul Jamo."},{name:"U+AC00-D7AF",description:"Hangul Syllables."},{name:"U+3040-309F",description:"Hiragana."},{name:"U+30A0-30FF",description:"Katakana."},{name:"U+A5, U+4E00-9FFF, U+30??, U+FF00-FF9F",description:"Japanese Kanji, Hiragana and Katakana characters plus Yen/Yuan symbol."},{name:"U+A4D0-A4FF",description:"Lisu."},{name:"U+A000-A48F",description:"Yi Syllables."},{name:"U+A490-A4CF",description:"Yi Radicals."},{name:"U+2000-206F",description:"General Punctuation."},{name:"U+3000-303F",description:"CJK Symbols and Punctuation."},{name:"U+2070-209F",description:"Superscripts and Subscripts."},{name:"U+20A0-20CF",description:"Currency Symbols."},{name:"U+2100-214F",description:"Letterlike Symbols."},{name:"U+2150-218F",description:"Number Forms."},{name:"U+2190-21FF",description:"Arrows."},{name:"U+2200-22FF",description:"Mathematical Operators."},{name:"U+2300-23FF",description:"Miscellaneous Technical."},{name:"U+E000-F8FF",description:"Private Use Area."},{name:"U+FB00-FB4F",description:"Alphabetic Presentation Forms. Ligatures for latin, Armenian, and Hebrew."},{name:"U+FB50-FDFF",description:"Arabic Presentation Forms-A. Contextual forms / ligatures for Persian, Urdu, Sindhi, Central Asian languages, etc, Arabic pedagogical symbols, word ligatures."},{name:"U+1F600-1F64F",description:"Emoji: Emoticons."},{name:"U+2600-26FF",description:"Emoji: Miscellaneous Symbols."},{name:"U+1F300-1F5FF",description:"Emoji: Miscellaneous Symbols and Pictographs."},{name:"U+1F900-1F9FF",description:"Emoji: Supplemental Symbols and Pictographs."},{name:"U+1F680-1F6FF",description:"Emoji: Transport and Map Symbols."}],atRule:"@font-face",syntax:"<unicode-range>#",relevance:72,description:"@font-face descriptor. Defines the set of Unicode codepoints that may be supported by the font face for which it is declared.",restrictions:["unicode-range"]},{name:"user-select",browsers:["E79","FF69","S3","C54","IE10","O41"],values:[{name:"all",description:"The content of the element must be selected atomically"},{name:"auto"},{name:"contain",description:"UAs must not allow a selection which is started in this element to be extended outside of this element."},{name:"none",description:"The UA must not allow selections to be started in this element."},{name:"text",description:"The element imposes no constraint on the selection."}],syntax:"auto | text | none | contain | all",relevance:82,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/user-select"}],description:"Controls the appearance of selection.",restrictions:["enum"]},{name:"vertical-align",browsers:["E12","FF1","S1","C1","IE4","O4"],values:[{name:"auto",description:"Align the dominant baseline of the parent box with the equivalent, or heuristically reconstructed, baseline of the element inline box."},{name:"baseline",description:"Align the 'alphabetic' baseline of the element with the 'alphabetic' baseline of the parent element."},{name:"bottom",description:"Align the after edge of the extended inline box with the after-edge of the line box."},{name:"middle",description:"Align the 'middle' baseline of the inline element with the middle baseline of the parent."},{name:"sub",description:"Lower the baseline of the box to the proper position for subscripts of the parent's box. (This value has no effect on the font size of the element's text.)"},{name:"super",description:"Raise the baseline of the box to the proper position for superscripts of the parent's box. (This value has no effect on the font size of the element's text.)"},{name:"text-bottom",description:"Align the bottom of the box with the after-edge of the parent element's font."},{name:"text-top",description:"Align the top of the box with the before-edge of the parent element's font."},{name:"top",description:"Align the before edge of the extended inline box with the before-edge of the line box."},{name:"-webkit-baseline-middle",browsers:["E12","FF1","S1","C1","IE4","O4"]}],syntax:"baseline | sub | super | text-top | text-bottom | middle | top | bottom | <percentage> | <length>",relevance:90,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/vertical-align"}],description:"Affects the vertical positioning of the inline boxes generated by an inline-level element inside a line box.",restrictions:["percentage","length"]},{name:"visibility",browsers:["E12","FF1","S1","C1","IE4","O4"],values:[{name:"collapse",description:"Table-specific. If used on elements other than rows, row groups, columns, or column groups, 'collapse' has the same meaning as 'hidden'."},{name:"hidden",description:"The generated box is invisible (fully transparent, nothing is drawn), but still affects layout."},{name:"visible",description:"The generated box is visible."}],syntax:"visible | hidden | collapse",relevance:87,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/visibility"}],description:"Specifies whether the boxes generated by an element are rendered. Invisible boxes still affect layout (set the 'display' property to 'none' to suppress box generation altogether).",restrictions:["enum"]},{name:"-webkit-animation",browsers:["C","S5"],values:[{name:"alternate",description:"The animation cycle iterations that are odd counts are played in the normal direction, and the animation cycle iterations that are even counts are played in a reverse direction."},{name:"alternate-reverse",description:"The animation cycle iterations that are odd counts are played in the reverse direction, and the animation cycle iterations that are even counts are played in a normal direction."},{name:"backwards",description:"The beginning property value (as defined in the first @keyframes at-rule) is applied before the animation is displayed, during the period defined by 'animation-delay'."},{name:"both",description:"Both forwards and backwards fill modes are applied."},{name:"forwards",description:"The final property value (as defined in the last @keyframes at-rule) is maintained after the animation completes."},{name:"infinite",description:"Causes the animation to repeat forever."},{name:"none",description:"No animation is performed"},{name:"normal",description:"Normal playback."},{name:"reverse",description:"All iterations of the animation are played in the reverse direction from the way they were specified."}],relevance:50,description:"Shorthand property combines six of the animation properties into a single property.",restrictions:["time","enum","timing-function","identifier","number"]},{name:"-webkit-animation-delay",browsers:["C","S5"],relevance:50,description:"Defines when the animation will start.",restrictions:["time"]},{name:"-webkit-animation-direction",browsers:["C","S5"],values:[{name:"alternate",description:"The animation cycle iterations that are odd counts are played in the normal direction, and the animation cycle iterations that are even counts are played in a reverse direction."},{name:"alternate-reverse",description:"The animation cycle iterations that are odd counts are played in the reverse direction, and the animation cycle iterations that are even counts are played in a normal direction."},{name:"normal",description:"Normal playback."},{name:"reverse",description:"All iterations of the animation are played in the reverse direction from the way they were specified."}],relevance:50,description:"Defines whether or not the animation should play in reverse on alternate cycles.",restrictions:["enum"]},{name:"-webkit-animation-duration",browsers:["C","S5"],relevance:50,description:"Defines the length of time that an animation takes to complete one cycle.",restrictions:["time"]},{name:"-webkit-animation-fill-mode",browsers:["C","S5"],values:[{name:"backwards",description:"The beginning property value (as defined in the first @keyframes at-rule) is applied before the animation is displayed, during the period defined by 'animation-delay'."},{name:"both",description:"Both forwards and backwards fill modes are applied."},{name:"forwards",description:"The final property value (as defined in the last @keyframes at-rule) is maintained after the animation completes."},{name:"none",description:"There is no change to the property value between the time the animation is applied and the time the animation begins playing or after the animation completes."}],relevance:50,description:"Defines what values are applied by the animation outside the time it is executing.",restrictions:["enum"]},{name:"-webkit-animation-iteration-count",browsers:["C","S5"],values:[{name:"infinite",description:"Causes the animation to repeat forever."}],relevance:50,description:"Defines the number of times an animation cycle is played. The default value is one, meaning the animation will play from beginning to end once.",restrictions:["number","enum"]},{name:"-webkit-animation-name",browsers:["C","S5"],values:[{name:"none",description:"No animation is performed"}],relevance:50,description:"Defines a list of animations that apply. Each name is used to select the keyframe at-rule that provides the property values for the animation.",restrictions:["identifier","enum"]},{name:"-webkit-animation-play-state",browsers:["C","S5"],values:[{name:"paused",description:"A running animation will be paused."},{name:"running",description:"Resume playback of a paused animation."}],relevance:50,description:"Defines whether the animation is running or paused.",restrictions:["enum"]},{name:"-webkit-animation-timing-function",browsers:["C","S5"],relevance:50,description:"Describes how the animation will progress over one cycle of its duration. See the 'transition-timing-function'.",restrictions:["timing-function"]},{name:"-webkit-appearance",browsers:["C","S3"],values:[{name:"button"},{name:"button-bevel"},{name:"caps-lock-indicator"},{name:"caret"},{name:"checkbox"},{name:"default-button"},{name:"listbox"},{name:"listitem"},{name:"media-fullscreen-button"},{name:"media-mute-button"},{name:"media-play-button"},{name:"media-seek-back-button"},{name:"media-seek-forward-button"},{name:"media-slider"},{name:"media-sliderthumb"},{name:"menulist"},{name:"menulist-button"},{name:"menulist-text"},{name:"menulist-textfield"},{name:"none"},{name:"push-button"},{name:"radio"},{name:"scrollbarbutton-down"},{name:"scrollbarbutton-left"},{name:"scrollbarbutton-right"},{name:"scrollbarbutton-up"},{name:"scrollbargripper-horizontal"},{name:"scrollbargripper-vertical"},{name:"scrollbarthumb-horizontal"},{name:"scrollbarthumb-vertical"},{name:"scrollbartrack-horizontal"},{name:"scrollbartrack-vertical"},{name:"searchfield"},{name:"searchfield-cancel-button"},{name:"searchfield-decoration"},{name:"searchfield-results-button"},{name:"searchfield-results-decoration"},{name:"slider-horizontal"},{name:"sliderthumb-horizontal"},{name:"sliderthumb-vertical"},{name:"slider-vertical"},{name:"square-button"},{name:"textarea"},{name:"textfield"}],status:"nonstandard",syntax:"none | button | button-bevel | caret | checkbox | default-button | inner-spin-button | listbox | listitem | media-controls-background | media-controls-fullscreen-background | media-current-time-display | media-enter-fullscreen-button | media-exit-fullscreen-button | media-fullscreen-button | media-mute-button | media-overlay-play-button | media-play-button | media-seek-back-button | media-seek-forward-button | media-slider | media-sliderthumb | media-time-remaining-display | media-toggle-closed-captions-button | media-volume-slider | media-volume-slider-container | media-volume-sliderthumb | menulist | menulist-button | menulist-text | menulist-textfield | meter | progress-bar | progress-bar-value | push-button | radio | searchfield | searchfield-cancel-button | searchfield-decoration | searchfield-results-button | searchfield-results-decoration | slider-horizontal | slider-vertical | sliderthumb-horizontal | sliderthumb-vertical | square-button | textarea | textfield | -apple-pay-button",relevance:0,description:"Changes the appearance of buttons and other controls to resemble native controls.",restrictions:["enum"]},{name:"-webkit-backdrop-filter",browsers:["S9"],values:[{name:"none",description:"No filter effects are applied."},{name:"blur()",description:"Applies a Gaussian blur to the input image."},{name:"brightness()",description:"Applies a linear multiplier to input image, making it appear more or less bright."},{name:"contrast()",description:"Adjusts the contrast of the input."},{name:"drop-shadow()",description:"Applies a drop shadow effect to the input image."},{name:"grayscale()",description:"Converts the input image to grayscale."},{name:"hue-rotate()",description:"Applies a hue rotation on the input image. "},{name:"invert()",description:"Inverts the samples in the input image."},{name:"opacity()",description:"Applies transparency to the samples in the input image."},{name:"saturate()",description:"Saturates the input image."},{name:"sepia()",description:"Converts the input image to sepia."},{name:"url()",description:"A filter reference to a <filter> element."}],relevance:50,description:"Applies a filter effect where the first filter in the list takes the element's background image as the input image.",restrictions:["enum","url"]},{name:"-webkit-backface-visibility",browsers:["C","S5"],values:[{name:"hidden"},{name:"visible"}],relevance:50,description:"Determines whether or not the 'back' side of a transformed element is visible when facing the viewer. With an identity transform, the front side of an element faces the viewer.",restrictions:["enum"]},{name:"-webkit-background-clip",browsers:["C","S3"],relevance:50,description:"Determines the background painting area.",restrictions:["box"]},{name:"-webkit-background-composite",browsers:["C","S3"],values:[{name:"border"},{name:"padding"}],relevance:50,restrictions:["enum"]},{name:"-webkit-background-origin",browsers:["C","S3"],relevance:50,description:"For elements rendered as a single box, specifies the background positioning area. For elements rendered as multiple boxes (e.g., inline boxes on several lines, boxes on several pages) specifies which boxes 'box-decoration-break' operates on to determine the background positioning area(s).",restrictions:["box"]},{name:"-webkit-border-image",browsers:["C","S5"],values:[{name:"auto",description:"If 'auto' is specified then the border image width is the intrinsic width or height (whichever is applicable) of the corresponding image slice. If the image does not have the required intrinsic dimension then the corresponding border-width is used instead."},{name:"fill",description:"Causes the middle part of the border-image to be preserved."},{name:"none"},{name:"repeat",description:"The image is tiled (repeated) to fill the area."},{name:"round",description:"The image is tiled (repeated) to fill the area. If it does not fill the area with a whole number of tiles, the image is rescaled so that it does."},{name:"space",description:"The image is tiled (repeated) to fill the area. If it does not fill the area with a whole number of tiles, the extra space is distributed around the tiles."},{name:"stretch",description:"The image is stretched to fill the area."},{name:"url()"}],relevance:50,description:"Shorthand property for setting 'border-image-source', 'border-image-slice', 'border-image-width', 'border-image-outset' and 'border-image-repeat'. Omitted values are set to their initial values.",restrictions:["length","percentage","number","url","enum"]},{name:"-webkit-box-align",browsers:["C","S3"],values:[{name:"baseline",description:"If this box orientation is inline-axis or horizontal, all children are placed with their baselines aligned, and extra space placed before or after as necessary. For block flows, the baseline of the first non-empty line box located within the element is used. For tables, the baseline of the first cell is used."},{name:"center",description:"Any extra space is divided evenly, with half placed above the child and the other half placed after the child."},{name:"end",description:"For normal direction boxes, the bottom edge of each child is placed along the bottom of the box. Extra space is placed above the element. For reverse direction boxes, the top edge of each child is placed along the top of the box. Extra space is placed below the element."},{name:"start",description:"For normal direction boxes, the top edge of each child is placed along the top of the box. Extra space is placed below the element. For reverse direction boxes, the bottom edge of each child is placed along the bottom of the box. Extra space is placed above the element."},{name:"stretch",description:"The height of each child is adjusted to that of the containing block."}],relevance:50,description:"Specifies the alignment of nested elements within an outer flexible box element.",restrictions:["enum"]},{name:"-webkit-box-direction",browsers:["C","S3"],values:[{name:"normal",description:"A box with a computed value of horizontal for box-orient displays its children from left to right. A box with a computed value of vertical displays its children from top to bottom."},{name:"reverse",description:"A box with a computed value of horizontal for box-orient displays its children from right to left. A box with a computed value of vertical displays its children from bottom to top."}],relevance:50,description:"In webkit applications, -webkit-box-direction specifies whether a box lays out its contents normally (from the top or left edge), or in reverse (from the bottom or right edge).",restrictions:["enum"]},{name:"-webkit-box-flex",browsers:["C","S3"],relevance:50,description:"Specifies an element's flexibility.",restrictions:["number"]},{name:"-webkit-box-flex-group",browsers:["C","S3"],relevance:50,description:"Flexible elements can be assigned to flex groups using the 'box-flex-group' property.",restrictions:["integer"]},{name:"-webkit-box-ordinal-group",browsers:["C","S3"],relevance:50,description:"Indicates the ordinal group the element belongs to. Elements with a lower ordinal group are displayed before those with a higher ordinal group.",restrictions:["integer"]},{name:"-webkit-box-orient",browsers:["C","S3"],values:[{name:"block-axis",description:"Elements are oriented along the box's axis."},{name:"horizontal",description:"The box displays its children from left to right in a horizontal line."},{name:"inline-axis",description:"Elements are oriented vertically."},{name:"vertical",description:"The box displays its children from stacked from top to bottom vertically."}],relevance:50,description:"In webkit applications, -webkit-box-orient specifies whether a box lays out its contents horizontally or vertically.",restrictions:["enum"]},{name:"-webkit-box-pack",browsers:["C","S3"],values:[{name:"center",description:"The extra space is divided evenly, with half placed before the first child and the other half placed after the last child."},{name:"end",description:"For normal direction boxes, the right edge of the last child is placed at the right side, with all extra space placed before the first child. For reverse direction boxes, the left edge of the first child is placed at the left side, with all extra space placed after the last child."},{name:"justify",description:"The space is divided evenly in-between each child, with none of the extra space placed before the first child or after the last child. If there is only one child, treat the pack value as if it were start."},{name:"start",description:"For normal direction boxes, the left edge of the first child is placed at the left side, with all extra space placed after the last child. For reverse direction boxes, the right edge of the last child is placed at the right side, with all extra space placed before the first child."}],relevance:50,description:"Specifies alignment of child elements within the current element in the direction of orientation.",restrictions:["enum"]},{name:"-webkit-box-reflect",browsers:["E79","S4","C4","O15"],values:[{name:"above",description:"The reflection appears above the border box."},{name:"below",description:"The reflection appears below the border box."},{name:"left",description:"The reflection appears to the left of the border box."},{name:"right",description:"The reflection appears to the right of the border box."}],status:"nonstandard",syntax:"[ above | below | right | left ]? <length>? <image>?",relevance:0,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/-webkit-box-reflect"}],description:"Defines a reflection of a border box."},{name:"-webkit-box-sizing",browsers:["C","S3"],values:[{name:"border-box",description:"The specified width and height (and respective min/max properties) on this element determine the border box of the element."},{name:"content-box",description:"Behavior of width and height as specified by CSS2.1. The specified width and height (and respective min/max properties) apply to the width and height respectively of the content box of the element."}],relevance:50,description:"Box Model addition in CSS3.",restrictions:["enum"]},{name:"-webkit-break-after",browsers:["S7"],values:[{name:"always",description:"Always force a page break before/after the generated box."},{name:"auto",description:"Neither force nor forbid a page/column break before/after the generated box."},{name:"avoid",description:"Avoid a page/column break before/after the generated box."},{name:"avoid-column",description:"Avoid a column break before/after the generated box."},{name:"avoid-page",description:"Avoid a page break before/after the generated box."},{name:"avoid-region"},{name:"column",description:"Always force a column break before/after the generated box."},{name:"left",description:"Force one or two page breaks before/after the generated box so that the next page is formatted as a left page."},{name:"page",description:"Always force a page break before/after the generated box."},{name:"region"},{name:"right",description:"Force one or two page breaks before/after the generated box so that the next page is formatted as a right page."}],relevance:50,description:"Describes the page/column break behavior before the generated box.",restrictions:["enum"]},{name:"-webkit-break-before",browsers:["S7"],values:[{name:"always",description:"Always force a page break before/after the generated box."},{name:"auto",description:"Neither force nor forbid a page/column break before/after the generated box."},{name:"avoid",description:"Avoid a page/column break before/after the generated box."},{name:"avoid-column",description:"Avoid a column break before/after the generated box."},{name:"avoid-page",description:"Avoid a page break before/after the generated box."},{name:"avoid-region"},{name:"column",description:"Always force a column break before/after the generated box."},{name:"left",description:"Force one or two page breaks before/after the generated box so that the next page is formatted as a left page."},{name:"page",description:"Always force a page break before/after the generated box."},{name:"region"},{name:"right",description:"Force one or two page breaks before/after the generated box so that the next page is formatted as a right page."}],relevance:50,description:"Describes the page/column break behavior before the generated box.",restrictions:["enum"]},{name:"-webkit-break-inside",browsers:["S7"],values:[{name:"auto",description:"Neither force nor forbid a page/column break inside the generated box."},{name:"avoid",description:"Avoid a page/column break inside the generated box."},{name:"avoid-column",description:"Avoid a column break inside the generated box."},{name:"avoid-page",description:"Avoid a page break inside the generated box."},{name:"avoid-region"}],relevance:50,description:"Describes the page/column break behavior inside the generated box.",restrictions:["enum"]},{name:"-webkit-column-break-after",browsers:["E80","S13.1","C80","O67"],values:[{name:"always",description:"Always force a page break before/after the generated box."},{name:"auto",description:"Neither force nor forbid a page/column break before/after the generated box."},{name:"avoid",description:"Avoid a page/column break before/after the generated box."},{name:"avoid-column",description:"Avoid a column break before/after the generated box."},{name:"avoid-page",description:"Avoid a page break before/after the generated box."},{name:"avoid-region"},{name:"column",description:"Always force a column break before/after the generated box."},{name:"left",description:"Force one or two page breaks before/after the generated box so that the next page is formatted as a left page."},{name:"page",description:"Always force a page break before/after the generated box."},{name:"region"},{name:"right",description:"Force one or two page breaks before/after the generated box so that the next page is formatted as a right page."}],relevance:50,description:"Describes the page/column break behavior before the generated box.",restrictions:["enum"]},{name:"-webkit-column-break-before",browsers:["E80","S13.1","C80","O67"],values:[{name:"always",description:"Always force a page break before/after the generated box."},{name:"auto",description:"Neither force nor forbid a page/column break before/after the generated box."},{name:"avoid",description:"Avoid a page/column break before/after the generated box."},{name:"avoid-column",description:"Avoid a column break before/after the generated box."},{name:"avoid-page",description:"Avoid a page break before/after the generated box."},{name:"avoid-region"},{name:"column",description:"Always force a column break before/after the generated box."},{name:"left",description:"Force one or two page breaks before/after the generated box so that the next page is formatted as a left page."},{name:"page",description:"Always force a page break before/after the generated box."},{name:"region"},{name:"right",description:"Force one or two page breaks before/after the generated box so that the next page is formatted as a right page."}],relevance:50,description:"Describes the page/column break behavior before the generated box.",restrictions:["enum"]},{name:"-webkit-column-break-inside",browsers:["E80","S13.1","C80","O67"],values:[{name:"auto",description:"Neither force nor forbid a page/column break inside the generated box."},{name:"avoid",description:"Avoid a page/column break inside the generated box."},{name:"avoid-column",description:"Avoid a column break inside the generated box."},{name:"avoid-page",description:"Avoid a page break inside the generated box."},{name:"avoid-region"}],relevance:50,description:"Describes the page/column break behavior inside the generated box.",restrictions:["enum"]},{name:"-webkit-column-count",browsers:["C","S3"],values:[{name:"auto",description:"Determines the number of columns by the 'column-width' property and the element width."}],relevance:50,description:"Describes the optimal number of columns into which the content of the element will be flowed.",restrictions:["integer"]},{name:"-webkit-column-gap",browsers:["C","S3"],values:[{name:"normal",description:"User agent specific and typically equivalent to 1em."}],relevance:50,description:"Sets the gap between columns. If there is a column rule between columns, it will appear in the middle of the gap.",restrictions:["length"]},{name:"-webkit-column-rule",browsers:["C","S3"],relevance:50,description:"This property is a shorthand for setting 'column-rule-width', 'column-rule-style', and 'column-rule-color' at the same place in the style sheet. Omitted values are set to their initial values.",restrictions:["length","line-width","line-style","color"]},{name:"-webkit-column-rule-color",browsers:["C","S3"],relevance:50,description:"Sets the color of the column rule",restrictions:["color"]},{name:"-webkit-column-rule-style",browsers:["C","S3"],relevance:50,description:"Sets the style of the rule between columns of an element.",restrictions:["line-style"]},{name:"-webkit-column-rule-width",browsers:["C","S3"],relevance:50,description:"Sets the width of the rule between columns. Negative values are not allowed.",restrictions:["length","line-width"]},{name:"-webkit-columns",browsers:["C","S3"],values:[{name:"auto",description:"The width depends on the values of other properties."}],relevance:50,description:"A shorthand property which sets both 'column-width' and 'column-count'.",restrictions:["length","integer"]},{name:"-webkit-column-span",browsers:["C","S3"],values:[{name:"all",description:"The element spans across all columns. Content in the normal flow that appears before the element is automatically balanced across all columns before the element appear."},{name:"none",description:"The element does not span multiple columns."}],relevance:50,description:"Describes the page/column break behavior after the generated box.",restrictions:["enum"]},{name:"-webkit-column-width",browsers:["C","S3"],values:[{name:"auto",description:"The width depends on the values of other properties."}],relevance:50,description:"This property describes the width of columns in multicol elements.",restrictions:["length"]},{name:"-webkit-filter",browsers:["C18","O15","S6"],values:[{name:"none",description:"No filter effects are applied."},{name:"blur()",description:"Applies a Gaussian blur to the input image."},{name:"brightness()",description:"Applies a linear multiplier to input image, making it appear more or less bright."},{name:"contrast()",description:"Adjusts the contrast of the input."},{name:"drop-shadow()",description:"Applies a drop shadow effect to the input image."},{name:"grayscale()",description:"Converts the input image to grayscale."},{name:"hue-rotate()",description:"Applies a hue rotation on the input image. "},{name:"invert()",description:"Inverts the samples in the input image."},{name:"opacity()",description:"Applies transparency to the samples in the input image."},{name:"saturate()",description:"Saturates the input image."},{name:"sepia()",description:"Converts the input image to sepia."},{name:"url()",description:"A filter reference to a <filter> element."}],relevance:50,description:"Processes an element's rendering before it is displayed in the document, by applying one or more filter effects.",restrictions:["enum","url"]},{name:"-webkit-flow-from",browsers:["S6.1"],values:[{name:"none",description:"The block container is not a CSS Region."}],relevance:50,description:"Makes a block container a region and associates it with a named flow.",restrictions:["identifier"]},{name:"-webkit-flow-into",browsers:["S6.1"],values:[{name:"none",description:"The element is not moved to a named flow and normal CSS processing takes place."}],relevance:50,description:"Places an element or its contents into a named flow.",restrictions:["identifier"]},{name:"-webkit-font-feature-settings",browsers:["C16"],values:[{name:'"c2cs"'},{name:'"dlig"'},{name:'"kern"'},{name:'"liga"'},{name:'"lnum"'},{name:'"onum"'},{name:'"smcp"'},{name:'"swsh"'},{name:'"tnum"'},{name:"normal",description:"No change in glyph substitution or positioning occurs."},{name:"off"},{name:"on"}],relevance:50,description:"This property provides low-level control over OpenType font features. It is intended as a way of providing access to font features that are not widely used but are needed for a particular use case.",restrictions:["string","integer"]},{name:"-webkit-hyphens",browsers:["S5.1"],values:[{name:"auto",description:"Conditional hyphenation characters inside a word, if present, take priority over automatic resources when determining hyphenation points within the word."},{name:"manual",description:"Words are only broken at line breaks where there are characters inside the word that suggest line break opportunities"},{name:"none",description:"Words are not broken at line breaks, even if characters inside the word suggest line break points."}],relevance:50,description:"Controls whether hyphenation is allowed to create more break opportunities within a line of text.",restrictions:["enum"]},{name:"-webkit-line-break",browsers:["C","S3"],values:[{name:"after-white-space"},{name:"normal"}],relevance:50,description:"Specifies line-breaking rules for CJK (Chinese, Japanese, and Korean) text."},{name:"-webkit-margin-bottom-collapse",browsers:["C","S3"],values:[{name:"collapse"},{name:"discard"},{name:"separate"}],relevance:50,restrictions:["enum"]},{name:"-webkit-margin-collapse",browsers:["C","S3"],values:[{name:"collapse"},{name:"discard"},{name:"separate"}],relevance:50,restrictions:["enum"]},{name:"-webkit-margin-start",browsers:["C","S3"],values:[{name:"auto"}],relevance:50,restrictions:["percentage","length"]},{name:"-webkit-margin-top-collapse",browsers:["C","S3"],values:[{name:"collapse"},{name:"discard"},{name:"separate"}],relevance:50,restrictions:["enum"]},{name:"-webkit-mask-clip",browsers:["C","O15","S4"],status:"nonstandard",syntax:"[ <box> | border | padding | content | text ]#",relevance:0,description:"Determines the mask painting area, which determines the area that is affected by the mask.",restrictions:["box"]},{name:"-webkit-mask-image",browsers:["C","O15","S4"],values:[{name:"none",description:"Counts as a transparent black image layer."},{name:"url()",description:"Reference to a <mask element or to a CSS image."}],status:"nonstandard",syntax:"<mask-reference>#",relevance:0,description:"Sets the mask layer image of an element.",restrictions:["url","image","enum"]},{name:"-webkit-mask-origin",browsers:["C","O15","S4"],status:"nonstandard",syntax:"[ <box> | border | padding | content ]#",relevance:0,description:"Specifies the mask positioning area.",restrictions:["box"]},{name:"-webkit-mask-repeat",browsers:["C","O15","S4"],status:"nonstandard",syntax:"<repeat-style>#",relevance:0,description:"Specifies how mask layer images are tiled after they have been sized and positioned.",restrictions:["repeat"]},{name:"-webkit-mask-size",browsers:["C","O15","S4"],values:[{name:"auto",description:"Resolved by using the image's intrinsic ratio and the size of the other dimension, or failing that, using the image's intrinsic size, or failing that, treating it as 100%."},{name:"contain",description:"Scale the image, while preserving its intrinsic aspect ratio (if any), to the largest size such that both its width and its height can fit inside the background positioning area."},{name:"cover",description:"Scale the image, while preserving its intrinsic aspect ratio (if any), to the smallest size such that both its width and its height can completely cover the background positioning area."}],status:"nonstandard",syntax:"<bg-size>#",relevance:0,description:"Specifies the size of the mask layer images.",restrictions:["length","percentage","enum"]},{name:"-webkit-nbsp-mode",browsers:["S13.1"],values:[{name:"normal"},{name:"space"}],relevance:50,description:"Defines the behavior of nonbreaking spaces within text."},{name:"-webkit-overflow-scrolling",browsers:["C","S5"],values:[{name:"auto"},{name:"touch"}],status:"nonstandard",syntax:"auto | touch",relevance:0,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/-webkit-overflow-scrolling"}],description:"Specifies whether to use native-style scrolling in an overflow:scroll element."},{name:"-webkit-padding-start",browsers:["C","S3"],relevance:50,restrictions:["percentage","length"]},{name:"-webkit-perspective",browsers:["C","S4"],values:[{name:"none",description:"No perspective transform is applied."}],relevance:50,description:"Applies the same transform as the perspective(<number>) transform function, except that it applies only to the positioned or transformed children of the element, not to the transform on the element itself.",restrictions:["length"]},{name:"-webkit-perspective-origin",browsers:["C","S4"],relevance:50,description:"Establishes the origin for the perspective property. It effectively sets the X and Y position at which the viewer appears to be looking at the children of the element.",restrictions:["position","percentage","length"]},{name:"-webkit-region-fragment",browsers:["S7"],values:[{name:"auto",description:"Content flows as it would in a regular content box."},{name:"break",description:"If the content fits within the CSS Region, then this property has no effect."}],relevance:50,description:"The 'region-fragment' property controls the behavior of the last region associated with a named flow.",restrictions:["enum"]},{name:"-webkit-tap-highlight-color",browsers:["E12","C16","O15"],status:"nonstandard",syntax:"<color>",relevance:0,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/-webkit-tap-highlight-color"}],restrictions:["color"]},{name:"-webkit-text-fill-color",browsers:["E12","FF49","S3","C1","O15"],syntax:"<color>",relevance:50,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/-webkit-text-fill-color"}],restrictions:["color"]},{name:"-webkit-text-size-adjust",browsers:["E","C","S3"],values:[{name:"auto",description:"Renderers must use the default size adjustment when displaying on a small device."},{name:"none",description:"Renderers must not do size adjustment when displaying on a small device."}],relevance:50,description:"Specifies a size adjustment for displaying text content in mobile browsers.",restrictions:["percentage"]},{name:"-webkit-text-stroke",browsers:["E15","FF49","S3","C4","O15"],syntax:"<length> || <color>",relevance:50,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/-webkit-text-stroke"}],restrictions:["length","line-width","color","percentage"]},{name:"-webkit-text-stroke-color",browsers:["E15","FF49","S3","C1","O15"],syntax:"<color>",relevance:50,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/-webkit-text-stroke-color"}],restrictions:["color"]},{name:"-webkit-text-stroke-width",browsers:["E15","FF49","S3","C1","O15"],syntax:"<length>",relevance:50,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/-webkit-text-stroke-width"}],restrictions:["length","line-width","percentage"]},{name:"-webkit-touch-callout",browsers:["S3"],values:[{name:"none"}],status:"nonstandard",syntax:"default | none",relevance:0,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/-webkit-touch-callout"}],restrictions:["enum"]},{name:"-webkit-transform",browsers:["C","O12","S3.1"],values:[{name:"matrix()",description:"Specifies a 2D transformation in the form of a transformation matrix of six values. matrix(a,b,c,d,e,f) is equivalent to applying the transformation matrix [a b c d e f]"},{name:"matrix3d()",description:"Specifies a 3D transformation as a 4x4 homogeneous matrix of 16 values in column-major order."},{name:"none"},{name:"perspective()",description:"Specifies a perspective projection matrix."},{name:"rotate()",description:"Specifies a 2D rotation by the angle specified in the parameter about the origin of the element, as defined by the transform-origin property."},{name:"rotate3d()",description:"Specifies a clockwise 3D rotation by the angle specified in last parameter about the [x,y,z] direction vector described by the first 3 parameters."},{name:"rotateX('angle')",description:"Specifies a clockwise rotation by the given angle about the X axis."},{name:"rotateY('angle')",description:"Specifies a clockwise rotation by the given angle about the Y axis."},{name:"rotateZ('angle')",description:"Specifies a clockwise rotation by the given angle about the Z axis."},{name:"scale()",description:"Specifies a 2D scale operation by the [sx,sy] scaling vector described by the 2 parameters. If the second parameter is not provided, it is takes a value equal to the first."},{name:"scale3d()",description:"Specifies a 3D scale operation by the [sx,sy,sz] scaling vector described by the 3 parameters."},{name:"scaleX()",description:"Specifies a scale operation using the [sx,1] scaling vector, where sx is given as the parameter."},{name:"scaleY()",description:"Specifies a scale operation using the [sy,1] scaling vector, where sy is given as the parameter."},{name:"scaleZ()",description:"Specifies a scale operation using the [1,1,sz] scaling vector, where sz is given as the parameter."},{name:"skew()",description:"Specifies a skew transformation along the X and Y axes. The first angle parameter specifies the skew on the X axis. The second angle parameter specifies the skew on the Y axis. If the second parameter is not given then a value of 0 is used for the Y angle (ie: no skew on the Y axis)."},{name:"skewX()",description:"Specifies a skew transformation along the X axis by the given angle."},{name:"skewY()",description:"Specifies a skew transformation along the Y axis by the given angle."},{name:"translate()",description:"Specifies a 2D translation by the vector [tx, ty], where tx is the first translation-value parameter and ty is the optional second translation-value parameter."},{name:"translate3d()",description:"Specifies a 3D translation by the vector [tx,ty,tz], with tx, ty and tz being the first, second and third translation-value parameters respectively."},{name:"translateX()",description:"Specifies a translation by the given amount in the X direction."},{name:"translateY()",description:"Specifies a translation by the given amount in the Y direction."},{name:"translateZ()",description:"Specifies a translation by the given amount in the Z direction. Note that percentage values are not allowed in the translateZ translation-value, and if present are evaluated as 0."}],relevance:50,description:"A two-dimensional transformation is applied to an element through the 'transform' property. This property contains a list of transform functions similar to those allowed by SVG.",restrictions:["enum"]},{name:"-webkit-transform-origin",browsers:["C","O15","S3.1"],relevance:50,description:"Establishes the origin of transformation for an element.",restrictions:["position","length","percentage"]},{name:"-webkit-transform-origin-x",browsers:["E80","S13.1","C80","O67"],relevance:50,description:"The x coordinate of the origin for transforms applied to an element with respect to its border box.",restrictions:["length","percentage"]},{name:"-webkit-transform-origin-y",browsers:["E80","S13.1","C80","O67"],relevance:50,description:"The y coordinate of the origin for transforms applied to an element with respect to its border box.",restrictions:["length","percentage"]},{name:"-webkit-transform-origin-z",browsers:["E80","S13.1","C80","O67"],relevance:50,description:"The z coordinate of the origin for transforms applied to an element with respect to its border box.",restrictions:["length","percentage"]},{name:"-webkit-transform-style",browsers:["C","S4"],values:[{name:"flat",description:"All children of this element are rendered flattened into the 2D plane of the element."}],relevance:50,description:"Defines how nested elements are rendered in 3D space.",restrictions:["enum"]},{name:"-webkit-transition",browsers:["C","O12","S5"],values:[{name:"all",description:"Every property that is able to undergo a transition will do so."},{name:"none",description:"No property will transition."}],relevance:50,description:"Shorthand property combines four of the transition properties into a single property.",restrictions:["time","property","timing-function","enum"]},{name:"-webkit-transition-delay",browsers:["C","O12","S5"],relevance:50,description:"Defines when the transition will start. It allows a transition to begin execution some period of time from when it is applied.",restrictions:["time"]},{name:"-webkit-transition-duration",browsers:["C","O12","S5"],relevance:50,description:"Specifies how long the transition from the old value to the new value should take.",restrictions:["time"]},{name:"-webkit-transition-property",browsers:["C","O12","S5"],values:[{name:"all",description:"Every property that is able to undergo a transition will do so."},{name:"none",description:"No property will transition."}],relevance:50,description:"Specifies the name of the CSS property to which the transition is applied.",restrictions:["property"]},{name:"-webkit-transition-timing-function",browsers:["C","O12","S5"],relevance:50,description:"Describes how the intermediate values used during a transition will be calculated.",restrictions:["timing-function"]},{name:"-webkit-user-drag",browsers:["E80","S13.1","C80","O67"],values:[{name:"auto"},{name:"element"},{name:"none"}],relevance:50,restrictions:["enum"]},{name:"-webkit-user-modify",browsers:["E80","S13.1","C80","O67"],values:[{name:"read-only"},{name:"read-write"},{name:"read-write-plaintext-only"}],syntax:"read-only | read-write | read-write-plaintext-only",relevance:50,description:"Determines whether a user can edit the content of an element.",restrictions:["enum"]},{name:"-webkit-user-select",browsers:["C","S3"],values:[{name:"auto"},{name:"none"},{name:"text"}],relevance:50,description:"Controls the appearance of selection.",restrictions:["enum"]},{name:"widows",browsers:["E12","S1.3","C25","IE8","O9.2"],syntax:"<integer>",relevance:51,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/widows"}],description:"Specifies the minimum number of line boxes of a block container that must be left in a fragment after a break.",restrictions:["integer"]},{name:"width",browsers:["E12","FF1","S1","C1","IE4","O3.5"],values:[{name:"auto",description:"The width depends on the values of other properties."},{name:"fit-content",browsers:["E12","FF1","S1","C1","IE4","O3.5"],description:"Use the fit-content inline size or fit-content block size, as appropriate to the writing mode."},{name:"max-content",browsers:["E12","FF1","S1","C1","IE4","O3.5"],description:"Use the max-content inline size or max-content block size, as appropriate to the writing mode."},{name:"min-content",browsers:["E12","FF1","S1","C1","IE4","O3.5"],description:"Use the min-content inline size or min-content block size, as appropriate to the writing mode."}],syntax:"auto | <length> | <percentage> | min-content | max-content | fit-content | fit-content(<length-percentage>)",relevance:96,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/width"}],description:"Specifies the width of the content area, padding area or border area (depending on 'box-sizing') of certain boxes.",restrictions:["length","percentage"]},{name:"will-change",browsers:["E79","FF36","S9.1","C36","O24"],values:[{name:"auto",description:"Expresses no particular intent."},{name:"contents",description:"Indicates that the author expects to animate or change something about the element's contents in the near future."},{name:"scroll-position",description:"Indicates that the author expects to animate or change the scroll position of the element in the near future."}],syntax:"auto | <animateable-feature>#",relevance:65,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/will-change"}],description:"Provides a rendering hint to the user agent, stating what kinds of changes the author expects to perform on the element.",restrictions:["enum","identifier"]},{name:"word-break",browsers:["E12","FF15","S3","C1","IE5.5","O15"],values:[{name:"break-all",description:"Lines may break between any two grapheme clusters for non-CJK scripts."},{name:"keep-all",description:"Block characters can no longer create implied break points."},{name:"normal",description:"Breaks non-CJK scripts according to their own rules."}],syntax:"normal | break-all | keep-all | break-word",relevance:76,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/word-break"}],description:"Specifies line break opportunities for non-CJK scripts.",restrictions:["enum"]},{name:"word-spacing",browsers:["E12","FF1","S1","C1","IE6","O3.5"],values:[{name:"normal",description:"No additional spacing is applied. Computes to zero."}],syntax:"normal | <length>",relevance:57,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/word-spacing"}],description:'Specifies additional spacing between "words".',restrictions:["length","percentage"]},{name:"word-wrap",browsers:["E80","FF72","S13.1","C80","O67"],values:[{name:"break-word",description:"An otherwise unbreakable sequence of characters may be broken at an arbitrary point if there are no otherwise-acceptable break points in the line."},{name:"normal",description:"Lines may break only at allowed break points."}],syntax:"normal | break-word",relevance:77,description:"Specifies whether the UA may break within a word to prevent overflow when an otherwise-unbreakable string is too long to fit.",restrictions:["enum"]},{name:"writing-mode",browsers:["E12","FF41","S10.1","C48","IE9","O35"],values:[{name:"horizontal-tb",description:"Top-to-bottom block flow direction. The writing mode is horizontal."},{name:"sideways-lr",browsers:["E12","FF41","S10.1","C48","IE9","O35"],description:"Left-to-right block flow direction. The writing mode is vertical, while the typographic mode is horizontal."},{name:"sideways-rl",browsers:["E12","FF41","S10.1","C48","IE9","O35"],description:"Right-to-left block flow direction. The writing mode is vertical, while the typographic mode is horizontal."},{name:"vertical-lr",description:"Left-to-right block flow direction. The writing mode is vertical."},{name:"vertical-rl",description:"Right-to-left block flow direction. The writing mode is vertical."}],syntax:"horizontal-tb | vertical-rl | vertical-lr | sideways-rl | sideways-lr",relevance:50,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/writing-mode"}],description:"This is a shorthand property for both 'direction' and 'block-progression'.",restrictions:["enum"]},{name:"z-index",browsers:["E12","FF1","S1","C1","IE4","O4"],values:[{name:"auto",description:"The stack level of the generated box in the current stacking context is 0. The box does not establish a new stacking context unless it is the root element."}],syntax:"auto | <integer>",relevance:92,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/z-index"}],description:"For a positioned box, the 'z-index' property specifies the stack level of the box in the current stacking context and whether the box establishes a local stacking context.",restrictions:["integer"]},{name:"zoom",browsers:["E12","FFpreview","S3.1","C1","IE5.5","O15"],values:[{name:"normal"}],status:"nonstandard",syntax:"normal | reset | <number> | <percentage>",relevance:15,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/zoom"}],description:"Non-standard. Specifies the magnification scale of the object. See 'transform: scale()' for a standards-based alternative.",restrictions:["enum","integer","number","percentage"]},{name:"-ms-ime-align",status:"nonstandard",syntax:"auto | after",values:[{name:"auto"},{name:"after"}],relevance:0,description:"Aligns the Input Method Editor (IME) candidate window box relative to the element on which the IME composition is active."},{name:"-moz-binding",status:"nonstandard",syntax:"<url> | none",relevance:0,description:"The -moz-binding CSS property is used by Mozilla-based applications to attach an XBL binding to a DOM element."},{name:"-moz-context-properties",status:"nonstandard",syntax:"none | [ fill | fill-opacity | stroke | stroke-opacity ]#",relevance:0,description:`If you reference an SVG image in a webpage (such as with the <img> element or as a background image), the SVG image can coordinate with the embedding element (its context) to have the image adopt property values set on the embedding element. To do this the embedding element needs to list the properties that are to be made available to the image by listing them as values of the -moz-context-properties property, and the image needs to opt in to using those properties by using values such as the context-fill value.

This feature is available since Firefox 55, but is only currently supported with SVG images loaded via chrome:// or resource:// URLs. To experiment with the feature in SVG on the Web it is necessary to set the svg.context-properties.content.enabled pref to true.`},{name:"-moz-float-edge",status:"obsolete",syntax:"border-box | content-box | margin-box | padding-box",values:[{name:"border-box"},{name:"content-box"},{name:"margin-box"},{name:"padding-box"}],relevance:0,browsers:["FF1"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/-moz-float-edge"}],description:"The non-standard -moz-float-edge CSS property specifies whether the height and width properties of the element include the margin, border, or padding thickness."},{name:"-moz-force-broken-image-icon",status:"obsolete",syntax:"0 | 1",values:[{name:"0"},{name:"1"}],relevance:0,browsers:["FF1"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/-moz-force-broken-image-icon"}],description:"The -moz-force-broken-image-icon extended CSS property can be used to force the broken image icon to be shown even when a broken image has an alt attribute."},{name:"-moz-image-region",status:"nonstandard",syntax:"<shape> | auto",relevance:0,browsers:["FF1"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/-moz-image-region"}],description:"For certain XUL elements and pseudo-elements that use an image from the list-style-image property, this property specifies a region of the image that is used in place of the whole image. This allows elements to use different pieces of the same image to improve performance."},{name:"-moz-orient",status:"nonstandard",syntax:"inline | block | horizontal | vertical",values:[{name:"inline"},{name:"block"},{name:"horizontal"},{name:"vertical"}],relevance:0,browsers:["FF6"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/-moz-orient"}],description:"The -moz-orient CSS property specifies the orientation of the element to which it's applied."},{name:"-moz-outline-radius",status:"nonstandard",syntax:"<outline-radius>{1,4} [ / <outline-radius>{1,4} ]?",relevance:0,description:"In Mozilla applications like Firefox, the -moz-outline-radius CSS property can be used to give an element's outline rounded corners."},{name:"-moz-outline-radius-bottomleft",status:"nonstandard",syntax:"<outline-radius>",relevance:0,description:"In Mozilla applications, the -moz-outline-radius-bottomleft CSS property can be used to round the bottom-left corner of an element's outline."},{name:"-moz-outline-radius-bottomright",status:"nonstandard",syntax:"<outline-radius>",relevance:0,description:"In Mozilla applications, the -moz-outline-radius-bottomright CSS property can be used to round the bottom-right corner of an element's outline."},{name:"-moz-outline-radius-topleft",status:"nonstandard",syntax:"<outline-radius>",relevance:0,description:"In Mozilla applications, the -moz-outline-radius-topleft CSS property can be used to round the top-left corner of an element's outline."},{name:"-moz-outline-radius-topright",status:"nonstandard",syntax:"<outline-radius>",relevance:0,description:"In Mozilla applications, the -moz-outline-radius-topright CSS property can be used to round the top-right corner of an element's outline."},{name:"-moz-stack-sizing",status:"nonstandard",syntax:"ignore | stretch-to-fit",values:[{name:"ignore"},{name:"stretch-to-fit"}],relevance:0,description:"-moz-stack-sizing is an extended CSS property. Normally, a stack will change its size so that all of its child elements are completely visible. For example, moving a child of the stack far to the right will widen the stack so the child remains visible."},{name:"-moz-text-blink",status:"nonstandard",syntax:"none | blink",values:[{name:"none"},{name:"blink"}],relevance:0,description:"The -moz-text-blink non-standard Mozilla CSS extension specifies the blink mode."},{name:"-moz-user-input",status:"obsolete",syntax:"auto | none | enabled | disabled",values:[{name:"auto"},{name:"none"},{name:"enabled"},{name:"disabled"}],relevance:0,browsers:["FF1"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/-moz-user-input"}],description:"In Mozilla applications, -moz-user-input determines if an element will accept user input."},{name:"-moz-user-modify",status:"nonstandard",syntax:"read-only | read-write | write-only",values:[{name:"read-only"},{name:"read-write"},{name:"write-only"}],relevance:0,description:"The -moz-user-modify property has no effect. It was originally planned to determine whether or not the content of an element can be edited by a user."},{name:"-moz-window-dragging",status:"nonstandard",syntax:"drag | no-drag",values:[{name:"drag"},{name:"no-drag"}],relevance:0,description:"The -moz-window-dragging CSS property specifies whether a window is draggable or not. It only works in Chrome code, and only on Mac OS X."},{name:"-moz-window-shadow",status:"nonstandard",syntax:"default | menu | tooltip | sheet | none",values:[{name:"default"},{name:"menu"},{name:"tooltip"},{name:"sheet"},{name:"none"}],relevance:0,description:"The -moz-window-shadow CSS property specifies whether a window will have a shadow. It only works on Mac OS X."},{name:"-webkit-border-before",status:"nonstandard",syntax:"<'border-width'> || <'border-style'> || <color>",relevance:0,browsers:["E79","S5.1","C8","O15"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/-webkit-border-before"}],description:"The -webkit-border-before CSS property is a shorthand property for setting the individual logical block start border property values in a single place in the style sheet."},{name:"-webkit-border-before-color",status:"nonstandard",syntax:"<color>",relevance:0,description:"The -webkit-border-before-color CSS property sets the color of the individual logical block start border in a single place in the style sheet."},{name:"-webkit-border-before-style",status:"nonstandard",syntax:"<'border-style'>",relevance:0,description:"The -webkit-border-before-style CSS property sets the style of the individual logical block start border in a single place in the style sheet."},{name:"-webkit-border-before-width",status:"nonstandard",syntax:"<'border-width'>",relevance:0,description:"The -webkit-border-before-width CSS property sets the width of the individual logical block start border in a single place in the style sheet."},{name:"-webkit-line-clamp",syntax:"none | <integer>",relevance:50,browsers:["E17","FF68","S5","C6","O15"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/-webkit-line-clamp"}],description:"The -webkit-line-clamp CSS property allows limiting of the contents of a block container to the specified number of lines."},{name:"-webkit-mask",status:"nonstandard",syntax:"[ <mask-reference> || <position> [ / <bg-size> ]? || <repeat-style> || [ <box> | border | padding | content | text ] || [ <box> | border | padding | content ] ]#",relevance:0,description:"The mask CSS property alters the visibility of an element by either partially or fully hiding it. This is accomplished by either masking or clipping the image at specific points."},{name:"-webkit-mask-attachment",status:"nonstandard",syntax:"<attachment>#",relevance:0,browsers:["S4","C1"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/-webkit-mask-attachment"}],description:"If a -webkit-mask-image is specified, -webkit-mask-attachment determines whether the mask image's position is fixed within the viewport, or scrolls along with its containing block."},{name:"-webkit-mask-composite",status:"nonstandard",syntax:"<composite-style>#",relevance:0,browsers:["E18","S3.1","C1","O15"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/-webkit-mask-composite"}],description:"The -webkit-mask-composite property specifies the manner in which multiple mask images applied to the same element are composited with one another. Mask images are composited in the opposite order that they are declared with the -webkit-mask-image property."},{name:"-webkit-mask-position",status:"nonstandard",syntax:"<position>#",relevance:0,description:"The mask-position CSS property sets the initial position, relative to the mask position layer defined by mask-origin, for each defined mask image."},{name:"-webkit-mask-position-x",status:"nonstandard",syntax:"[ <length-percentage> | left | center | right ]#",relevance:0,browsers:["E18","FF49","S3.1","C1","O15"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/-webkit-mask-position-x"}],description:"The -webkit-mask-position-x CSS property sets the initial horizontal position of a mask image."},{name:"-webkit-mask-position-y",status:"nonstandard",syntax:"[ <length-percentage> | top | center | bottom ]#",relevance:0,browsers:["E18","FF49","S3.1","C1","O15"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/-webkit-mask-position-y"}],description:"The -webkit-mask-position-y CSS property sets the initial vertical position of a mask image."},{name:"-webkit-mask-repeat-x",status:"nonstandard",syntax:"repeat | no-repeat | space | round",values:[{name:"repeat"},{name:"no-repeat"},{name:"space"},{name:"round"}],relevance:0,browsers:["E79","S5","C3","O15"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/-webkit-mask-repeat-x"}],description:"The -webkit-mask-repeat-x property specifies whether and how a mask image is repeated (tiled) horizontally."},{name:"-webkit-mask-repeat-y",status:"nonstandard",syntax:"repeat | no-repeat | space | round",values:[{name:"repeat"},{name:"no-repeat"},{name:"space"},{name:"round"}],relevance:0,browsers:["E79","S5","C3","O15"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/-webkit-mask-repeat-y"}],description:"The -webkit-mask-repeat-y property specifies whether and how a mask image is repeated (tiled) vertically."},{name:"accent-color",syntax:"auto | <color>",relevance:50,browsers:["E93","FF92","S15.4","C93","O79"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/accent-color"}],description:"Sets the color of the elements accent"},{name:"align-tracks",status:"experimental",syntax:"[ normal | <baseline-position> | <content-distribution> | <overflow-position>? <content-position> ]#",relevance:50,browsers:["FF77"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/align-tracks"}],description:"The align-tracks CSS property sets the alignment in the masonry axis for grid containers that have masonry in their block axis."},{name:"animation-composition",syntax:"<single-animation-composition>#",relevance:50,browsers:["E112","FF115","S16","C112","O98"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/animation-composition"}],description:"The composite operation to use when multiple animations affect the same property."},{name:"animation-range",status:"experimental",syntax:"[ <'animation-range-start'> <'animation-range-end'>? ]#",relevance:50,browsers:["E115","C115","O101"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/animation-range"}],description:"The animation-range CSS shorthand property is used to set the start and end of an animation's attachment range along its timeline, i.e. where along the timeline an animation will start and end."},{name:"animation-range-end",status:"experimental",syntax:"[ normal | <length-percentage> | <timeline-range-name> <length-percentage>? ]#",relevance:50,browsers:["E115","C115","O101"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/animation-range-end"}],description:"The animation-range-end CSS property is used to set the end of an animation's attachment range along its timeline, i.e. where along the timeline an animation will end."},{name:"animation-range-start",status:"experimental",syntax:"[ normal | <length-percentage> | <timeline-range-name> <length-percentage>? ]#",relevance:50,browsers:["E115","C115","O101"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/animation-range-start"}],description:"The animation-range-start CSS property is used to set the start of an animation's attachment range along its timeline, i.e. where along the timeline an animation will start."},{name:"animation-timeline",status:"experimental",syntax:"<single-animation-timeline>#",relevance:50,browsers:["E115","FF110","C115","O101"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/animation-timeline"}],description:"Specifies the names of one or more @scroll-timeline at-rules to describe the element's scroll animations."},{name:"appearance",syntax:"none | auto | textfield | menulist-button | <compat-auto>",relevance:69,browsers:["E84","FF80","S15.4","C84","O70"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/appearance"}],description:"Changes the appearance of buttons and other controls to resemble native controls."},{name:"aspect-ratio",syntax:"auto | <ratio>",relevance:60,browsers:["E88","FF89","S15","C88","O74"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/aspect-ratio"}],description:"The aspect-ratio   CSS property sets a preferred aspect ratio for the box, which will be used in the calculation of auto sizes and some other layout functions."},{name:"azimuth",status:"obsolete",syntax:"<angle> | [ [ left-side | far-left | left | center-left | center | center-right | right | far-right | right-side ] || behind ] | leftwards | rightwards",relevance:0,description:"In combination with elevation, the azimuth CSS property enables different audio sources to be positioned spatially for aural presentation. This is important in that it provides a natural way to tell several voices apart, as each can be positioned to originate at a different location on the sound stage. Stereo output produce a lateral sound stage, while binaural headphones and multi-speaker setups allow for a fully three-dimensional stage."},{name:"backdrop-filter",syntax:"none | <filter-function-list>",relevance:58,browsers:["E17","FF103","S9","C76","O63"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/backdrop-filter"}],description:"The backdrop-filter CSS property lets you apply graphical effects such as blurring or color shifting to the area behind an element. Because it applies to everything behind the element, to see the effect you must make the element or its background at least partially transparent."},{name:"border-block",syntax:"<'border-top-width'> || <'border-top-style'> || <color>",relevance:50,browsers:["E87","FF66","S14.1","C87","O73"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/border-block"}],description:"The border-block CSS property is a shorthand property for setting the individual logical block border property values in a single place in the style sheet."},{name:"border-block-color",syntax:"<'border-top-color'>{1,2}",relevance:50,browsers:["E87","FF66","S14.1","C87","O73"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/border-block-color"}],description:"The border-block-color CSS property defines the color of the logical block borders of an element, which maps to a physical border color depending on the element's writing mode, directionality, and text orientation. It corresponds to the border-top-color and border-bottom-color, or border-right-color and border-left-color property depending on the values defined for writing-mode, direction, and text-orientation."},{name:"border-block-style",syntax:"<'border-top-style'>",relevance:50,browsers:["E87","FF66","S14.1","C87","O73"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/border-block-style"}],description:"The border-block-style CSS property defines the style of the logical block borders of an element, which maps to a physical border style depending on the element's writing mode, directionality, and text orientation. It corresponds to the border-top-style and border-bottom-style, or border-left-style and border-right-style properties depending on the values defined for writing-mode, direction, and text-orientation."},{name:"border-block-width",syntax:"<'border-top-width'>",relevance:50,browsers:["E87","FF66","S14.1","C87","O73"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/border-block-width"}],description:"The border-block-width CSS property defines the width of the logical block borders of an element, which maps to a physical border width depending on the element's writing mode, directionality, and text orientation. It corresponds to the border-top-width and border-bottom-width, or border-left-width, and border-right-width property depending on the values defined for writing-mode, direction, and text-orientation."},{name:"border-end-end-radius",syntax:"<length-percentage>{1,2}",relevance:53,browsers:["E89","FF66","S15","C89","O75"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/border-end-end-radius"}],description:"The border-end-end-radius CSS property defines a logical border radius on an element, which maps to a physical border radius that depends on on the element's writing-mode, direction, and text-orientation."},{name:"border-end-start-radius",syntax:"<length-percentage>{1,2}",relevance:53,browsers:["E89","FF66","S15","C89","O75"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/border-end-start-radius"}],description:"The border-end-start-radius CSS property defines a logical border radius on an element, which maps to a physical border radius depending on the element's writing-mode, direction, and text-orientation."},{name:"border-inline",syntax:"<'border-top-width'> || <'border-top-style'> || <color>",relevance:50,browsers:["E87","FF66","S14.1","C87","O73"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/border-inline"}],description:"The border-inline CSS property is a shorthand property for setting the individual logical inline border property values in a single place in the style sheet."},{name:"border-inline-color",syntax:"<'border-top-color'>{1,2}",relevance:50,browsers:["E87","FF66","S14.1","C87","O73"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/border-inline-color"}],description:"The border-inline-color CSS property defines the color of the logical inline borders of an element, which maps to a physical border color depending on the element's writing mode, directionality, and text orientation. It corresponds to the border-top-color and border-bottom-color, or border-right-color and border-left-color property depending on the values defined for writing-mode, direction, and text-orientation."},{name:"border-inline-style",syntax:"<'border-top-style'>",relevance:50,browsers:["E87","FF66","S14.1","C87","O73"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/border-inline-style"}],description:"The border-inline-style CSS property defines the style of the logical inline borders of an element, which maps to a physical border style depending on the element's writing mode, directionality, and text orientation. It corresponds to the border-top-style and border-bottom-style, or border-left-style and border-right-style properties depending on the values defined for writing-mode, direction, and text-orientation."},{name:"border-inline-width",syntax:"<'border-top-width'>",relevance:50,browsers:["E87","FF66","S14.1","C87","O73"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/border-inline-width"}],description:"The border-inline-width CSS property defines the width of the logical inline borders of an element, which maps to a physical border width depending on the element's writing mode, directionality, and text orientation. It corresponds to the border-top-width and border-bottom-width, or border-left-width, and border-right-width property depending on the values defined for writing-mode, direction, and text-orientation."},{name:"border-start-end-radius",syntax:"<length-percentage>{1,2}",relevance:53,browsers:["E89","FF66","S15","C89","O75"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/border-start-end-radius"}],description:"The border-start-end-radius CSS property defines a logical border radius on an element, which maps to a physical border radius depending on the element's writing-mode, direction, and text-orientation."},{name:"border-start-start-radius",syntax:"<length-percentage>{1,2}",relevance:53,browsers:["E89","FF66","S15","C89","O75"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/border-start-start-radius"}],description:"The border-start-start-radius CSS property defines a logical border radius on an element, which maps to a physical border radius that depends on the element's writing-mode, direction, and text-orientation."},{name:"box-align",status:"obsolete",syntax:"start | center | end | baseline | stretch",values:[{name:"start"},{name:"center"},{name:"end"},{name:"baseline"},{name:"stretch"}],relevance:0,browsers:["E12","FF49","S3","C1","O15"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/box-align"}],description:"The box-align CSS property specifies how an element aligns its contents across its layout in a perpendicular direction. The effect of the property is only visible if there is extra space in the box."},{name:"box-direction",status:"obsolete",syntax:"normal | reverse | inherit",values:[{name:"normal"},{name:"reverse"},{name:"inherit"}],relevance:0,browsers:["E12","FF49","S3","C1","O15"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/box-direction"}],description:"The box-direction CSS property specifies whether a box lays out its contents normally (from the top or left edge), or in reverse (from the bottom or right edge)."},{name:"box-flex",status:"obsolete",syntax:"<number>",relevance:0,browsers:["E12","FF49","S3","C1","O15"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/box-flex"}],description:"The -moz-box-flex and -webkit-box-flex CSS properties specify how a -moz-box or -webkit-box grows to fill the box that contains it, in the direction of the containing box's layout."},{name:"box-flex-group",status:"obsolete",syntax:"<integer>",relevance:0,browsers:["S3","C1","O15"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/box-flex-group"}],description:"The box-flex-group CSS property assigns the flexbox's child elements to a flex group."},{name:"box-lines",status:"obsolete",syntax:"single | multiple",values:[{name:"single"},{name:"multiple"}],relevance:0,browsers:["S3","C1","O15"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/box-lines"}],description:"The box-lines CSS property determines whether the box may have a single or multiple lines (rows for horizontally oriented boxes, columns for vertically oriented boxes)."},{name:"box-ordinal-group",status:"obsolete",syntax:"<integer>",relevance:0,browsers:["E12","FF49","S3","C1","O15"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/box-ordinal-group"}],description:"The box-ordinal-group CSS property assigns the flexbox's child elements to an ordinal group."},{name:"box-orient",status:"obsolete",syntax:"horizontal | vertical | inline-axis | block-axis | inherit",values:[{name:"horizontal"},{name:"vertical"},{name:"inline-axis"},{name:"block-axis"},{name:"inherit"}],relevance:0,browsers:["E12","FF49","S3","C1","O15"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/box-orient"}],description:"The box-orient CSS property specifies whether an element lays out its contents horizontally or vertically."},{name:"box-pack",status:"obsolete",syntax:"start | center | end | justify",values:[{name:"start"},{name:"center"},{name:"end"},{name:"justify"}],relevance:0,browsers:["E12","FF49","S3","C1","O15"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/box-pack"}],description:"The -moz-box-pack and -webkit-box-pack CSS properties specify how a -moz-box or -webkit-box packs its contents in the direction of its layout. The effect of this is only visible if there is extra space in the box."},{name:"caret",syntax:"<'caret-color'> || <'caret-shape'>",relevance:50,description:"Shorthand for setting caret-color and caret-shape."},{name:"caret-shape",syntax:"auto | bar | block | underscore",values:[{name:"auto"},{name:"bar"},{name:"block"},{name:"underscore"}],relevance:50,description:"Specifies the desired shape of the text insertion caret."},{name:"color-scheme",syntax:"normal | [ light | dark | <custom-ident> ]+ && only?",relevance:57,browsers:["E81","FF96","S13","C81","O68"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/color-scheme"}],description:"The color-scheme CSS property allows an element to indicate which color schemes it can comfortably be rendered in."},{name:"contain-intrinsic-size",syntax:"[ auto? [ none | <length> ] ]{1,2}",relevance:50,browsers:["E83","FF107","S17","C83","O69"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/contain-intrinsic-size"}],description:"Size of an element when the element is subject to size containment."},{name:"contain-intrinsic-block-size",syntax:"auto? [ none | <length> ]",relevance:50,browsers:["E95","FF107","S17","C95","O81"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/contain-intrinsic-contain-intrinsic-block-size"}],description:"Block size of an element when the element is subject to size containment."},{name:"contain-intrinsic-height",syntax:"auto? [ none | <length> ]",relevance:50,browsers:["E95","FF107","S17","C95","O81"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/contain-intrinsic-height"}],description:"Height of an element when the element is subject to size containment."},{name:"contain-intrinsic-inline-size",syntax:"auto? [ none | <length> ]",relevance:50,browsers:["E95","FF107","S17","C95","O81"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/contain-intrinsic-contain-intrinsic-inline-size"}],description:"Inline size of an element when the element is subject to size containment."},{name:"contain-intrinsic-width",syntax:"auto? [ none | <length> ]",relevance:50,browsers:["E95","FF107","S17","C95","O81"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/contain-intrinsic-width"}],description:"Width of an element when the element is subject to size containment."},{name:"container",syntax:"<'container-name'> [ / <'container-type'> ]?",relevance:53,browsers:["E105","FF110","S16","C105","O91"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/container"}],description:"The container shorthand CSS property establishes the element as a query container and specifies the name or name for the containment context used in a container query."},{name:"container-name",syntax:"none | <custom-ident>+",relevance:50,browsers:["E105","FF110","S16","C105","O91"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/container-name"}],description:"The container-name CSS property specifies a list of query container names used by the @container at-rule in a container query."},{name:"container-type",syntax:"normal | size | inline-size",values:[{name:"normal"},{name:"size"},{name:"inline-size"}],relevance:50,browsers:["E105","FF110","S16","C105","O91"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/container-type"}],description:"The container-type CSS property is used to define the type of containment used in a container query."},{name:"content-visibility",syntax:"visible | auto | hidden",values:[{name:"visible"},{name:"auto"},{name:"hidden"}],relevance:52,browsers:["E85","FFpreview","Spreview","C85","O71"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/content-visibility"}],description:"Controls whether or not an element renders its contents at all, along with forcing a strong set of containments, allowing user agents to potentially omit large swathes of layout and rendering work until it becomes needed."},{name:"counter-set",syntax:"[ <counter-name> <integer>? ]+ | none",relevance:50,browsers:["E85","FF68","S17.2","C85","O71"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/counter-set"}],description:"The counter-set CSS property sets a CSS counter to a given value. It manipulates the value of existing counters, and will only create new counters if there isn't already a counter of the given name on the element."},{name:"font-optical-sizing",syntax:"auto | none",values:[{name:"auto"},{name:"none"}],relevance:50,browsers:["E17","FF62","S11","C79","O66"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/font-optical-sizing"}],description:"The font-optical-sizing CSS property allows developers to control whether browsers render text with slightly differing visual representations to optimize viewing at different sizes, or not. This only works for fonts that have an optical size variation axis."},{name:"font-palette",syntax:"normal | light | dark | <palette-identifier>",relevance:50,browsers:["E101","FF107","S15.4","C101","O87"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/font-palette"}],description:"The font-palette CSS property allows specifying one of the many palettes contained in a font that a user agent should use for the font. Users can also override the values in a palette or create a new palette by using the @font-palette-values at-rule."},{name:"font-variation-settings",atRule:"@font-face",syntax:"normal | [ <string> <number> ]#",relevance:51,browsers:["E17","FF62","S11","C62","O49"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/font-variation-settings"}],description:"The font-variation-settings CSS property provides low-level control over OpenType or TrueType font variations, by specifying the four letter axis names of the features you want to vary, along with their variation values."},{name:"font-smooth",status:"nonstandard",syntax:"auto | never | always | <absolute-size> | <length>",relevance:0,browsers:["E79","FF25","S4","C5","O15"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/font-smooth"}],description:"The font-smooth CSS property controls the application of anti-aliasing when fonts are rendered."},{name:"font-synthesis-position",syntax:"auto | none",values:[{name:"auto"},{name:"none"}],relevance:50,browsers:["FF118"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/font-synthesis-position"}],description:'The font-synthesis-position CSS property lets you specify whether or not a browser may synthesize the subscript and superscript "position" typefaces when they are missing in a font family, while using font-variant-position to set the positions.'},{name:"font-synthesis-small-caps",syntax:"auto | none",values:[{name:"auto"},{name:"none"}],relevance:50,browsers:["E97","FF111","S16.4","C97","O83"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/font-synthesis-small-caps"}],description:"The font-synthesis-small-caps CSS property lets you specify whether or not the browser may synthesize small-caps typeface when it is missing in a font family. Small-caps glyphs typically use the form of uppercase letters but are reduced to the size of lowercase letters."},{name:"font-synthesis-style",syntax:"auto | none",values:[{name:"auto"},{name:"none"}],relevance:50,browsers:["E97","FF111","S16.4","C97","O83"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/font-synthesis-style"}],description:"The font-synthesis-style CSS property lets you specify whether or not the browser may synthesize the oblique typeface when it is missing in a font family."},{name:"font-synthesis-weight",syntax:"auto | none",values:[{name:"auto"},{name:"none"}],relevance:50,browsers:["E97","FF111","S16.4","C97","O83"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/font-synthesis-weight"}],description:"The font-synthesis-weight CSS property lets you specify whether or not the browser may synthesize the bold typeface when it is missing in a font family."},{name:"font-variant-emoji",syntax:"normal | text | emoji | unicode",values:[{name:"normal"},{name:"text"},{name:"emoji"},{name:"unicode"}],relevance:50,browsers:["FF108"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/font-variant-emoji"}],description:"The font-variant-emoji CSS property specifies the default presentation style for displaying emojis."},{name:"forced-color-adjust",syntax:"auto | none",values:[{name:"auto"},{name:"none"}],relevance:57,browsers:["E79","FF113","C89","IE10","O75"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/forced-color-adjust"}],description:"Allows authors to opt certain elements out of forced colors mode. This then restores the control of those values to CSS"},{name:"gap",syntax:"<'row-gap'> <'column-gap'>?",relevance:70,browsers:["E16","FF52","S10.1","C57","O44"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/gap"}],description:"The gap CSS property is a shorthand property for row-gap and column-gap specifying the gutters between grid rows and columns."},{name:"hanging-punctuation",syntax:"none | [ first || [ force-end | allow-end ] || last ]",relevance:50,browsers:["S10"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/hanging-punctuation"}],description:"The hanging-punctuation CSS property specifies whether a punctuation mark should hang at the start or end of a line of text. Hanging punctuation may be placed outside the line box."},{name:"hyphenate-character",syntax:"auto | <string>",relevance:50,browsers:["E106","FF98","S17","C106","O92"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/hyphenate-character"}],description:"A hyphenate character used at the end of a line."},{name:"hyphenate-limit-chars",syntax:"[ auto | <integer> ]{1,3}",relevance:50,browsers:["E109","C109","O95"],description:"The hyphenate-limit-chars CSS property specifies the minimum word length to allow hyphenation of words as well as the minimum number of characters before and after the hyphen."},{name:"image-resolution",status:"experimental",syntax:"[ from-image || <resolution> ] && snap?",relevance:50,description:"The image-resolution property specifies the intrinsic resolution of all raster images used in or on the element. It affects both content images (e.g. replaced elements and generated content) and decorative images (such as background-image). The intrinsic resolution of an image is used to determine the image\u2019s intrinsic dimensions."},{name:"initial-letter",status:"experimental",syntax:"normal | [ <number> <integer>? ]",relevance:50,browsers:["E110","S9","C110","O96"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/initial-letter"}],description:"The initial-letter CSS property specifies styling for dropped, raised, and sunken initial letters."},{name:"initial-letter-align",status:"experimental",syntax:"[ auto | alphabetic | hanging | ideographic ]",relevance:50,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/initial-letter-align"}],description:"The initial-letter-align CSS property specifies the alignment of initial letters within a paragraph."},{name:"input-security",syntax:"auto | none",values:[{name:"auto"},{name:"none"}],relevance:50,description:"Enables or disables the obscuring a sensitive test input."},{name:"inset",syntax:"<'top'>{1,4}",relevance:58,browsers:["E87","FF66","S14.1","C87","O73"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/inset"}],description:"The inset CSS property defines the logical block and inline start and end offsets of an element, which map to physical offsets depending on the element's writing mode, directionality, and text orientation. It corresponds to the top and bottom, or right and left properties depending on the values defined for writing-mode, direction, and text-orientation."},{name:"inset-block",syntax:"<'top'>{1,2}",relevance:53,browsers:["E87","FF63","S14.1","C87","O73"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/inset-block"}],description:"The inset-block CSS property defines the logical block start and end offsets of an element, which maps to physical offsets depending on the element's writing mode, directionality, and text orientation. It corresponds to the top and bottom, or right and left properties depending on the values defined for writing-mode, direction, and text-orientation."},{name:"inset-block-end",syntax:"<'top'>",relevance:50,browsers:["E87","FF63","S14.1","C87","O73"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/inset-block-end"}],description:"The inset-block-end CSS property defines the logical block end offset of an element, which maps to a physical offset depending on the element's writing mode, directionality, and text orientation. It corresponds to the top, right, bottom, or left property depending on the values defined for writing-mode, direction, and text-orientation."},{name:"inset-block-start",syntax:"<'top'>",relevance:53,browsers:["E87","FF63","S14.1","C87","O73"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/inset-block-start"}],description:"The inset-block-start CSS property defines the logical block start offset of an element, which maps to a physical offset depending on the element's writing mode, directionality, and text orientation. It corresponds to the top, right, bottom, or left property depending on the values defined for writing-mode, direction, and text-orientation."},{name:"inset-inline",syntax:"<'top'>{1,2}",relevance:53,browsers:["E87","FF63","S14.1","C87","O73"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/inset-inline"}],description:"The inset-inline CSS property defines the logical block start and end offsets of an element, which maps to physical offsets depending on the element's writing mode, directionality, and text orientation. It corresponds to the top and bottom, or right and left properties depending on the values defined for writing-mode, direction, and text-orientation."},{name:"inset-inline-end",syntax:"<'top'>",relevance:51,browsers:["E87","FF63","S14.1","C87","O73"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/inset-inline-end"}],description:"The inset-inline-end CSS property defines the logical inline end inset of an element, which maps to a physical inset depending on the element's writing mode, directionality, and text orientation. It corresponds to the top, right, bottom, or left property depending on the values defined for writing-mode, direction, and text-orientation."},{name:"inset-inline-start",syntax:"<'top'>",relevance:54,browsers:["E87","FF63","S14.1","C87","O73"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/inset-inline-start"}],description:"The inset-inline-start CSS property defines the logical inline start inset of an element, which maps to a physical offset depending on the element's writing mode, directionality, and text orientation. It corresponds to the top, right, bottom, or left property depending on the values defined for writing-mode, direction, and text-orientation."},{name:"justify-tracks",status:"experimental",syntax:"[ normal | <content-distribution> | <overflow-position>? [ <content-position> | left | right ] ]#",relevance:50,browsers:["FF77"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/justify-tracks"}],description:"The justify-tracks CSS property sets the alignment in the masonry axis for grid containers that have masonry in their inline axis"},{name:"line-clamp",status:"experimental",syntax:"none | <integer>",relevance:50,description:"The line-clamp property allows limiting the contents of a block container to the specified number of lines; remaining content is fragmented away and neither rendered nor measured. Optionally, it also allows inserting content into the last line box to indicate the continuity of truncated/interrupted content."},{name:"line-height-step",status:"experimental",syntax:"<length>",relevance:50,browsers:["E79","C60","O47"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/line-height-step"}],description:"The line-height-step CSS property defines the step units for line box heights. When the step unit is positive, line box heights are rounded up to the closest multiple of the unit. Negative values are invalid."},{name:"margin-block",syntax:"<'margin-left'>{1,2}",relevance:54,browsers:["E87","FF66","S14.1","C87","O73"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/margin-block"}],description:"The margin-block CSS property defines the logical block start and end margins of an element, which maps to physical margins depending on the element's writing mode, directionality, and text orientation."},{name:"margin-inline",syntax:"<'margin-left'>{1,2}",relevance:54,browsers:["E87","FF66","S14.1","C87","O73"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/margin-inline"}],description:"The margin-inline CSS property defines the logical inline start and end margins of an element, which maps to physical margins depending on the element's writing mode, directionality, and text orientation."},{name:"margin-trim",status:"experimental",syntax:"none | in-flow | all",values:[{name:"none"},{name:"in-flow"},{name:"all"}],relevance:50,browsers:["S16.4"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/margin-trim"}],description:"The margin-trim property allows the container to trim the margins of its children where they adjoin the container\u2019s edges."},{name:"mask",syntax:"<mask-layer>#",relevance:55,browsers:["E79","FF53","S15.4","C1","O15"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/mask"}],description:"The mask CSS property alters the visibility of an element by either partially or fully hiding it. This is accomplished by either masking or clipping the image at specific points."},{name:"mask-border",syntax:"<'mask-border-source'> || <'mask-border-slice'> [ / <'mask-border-width'>? [ / <'mask-border-outset'> ]? ]? || <'mask-border-repeat'> || <'mask-border-mode'>",relevance:50,browsers:["E79","S17.2","C1","O15"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/mask-border"}],description:`The mask-border CSS property lets you create a mask along the edge of an element's border.

This property is a shorthand for mask-border-source, mask-border-slice, mask-border-width, mask-border-outset, mask-border-repeat, and mask-border-mode. As with all shorthand properties, any omitted sub-values will be set to their initial value.`},{name:"mask-border-mode",syntax:"luminance | alpha",values:[{name:"luminance"},{name:"alpha"}],relevance:50,description:"The mask-border-mode CSS property specifies the blending mode used in a mask border."},{name:"mask-border-outset",syntax:"[ <length> | <number> ]{1,4}",relevance:50,browsers:["E79","S17.2","C1","O15"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/mask-border-outset"}],description:"The mask-border-outset CSS property specifies the distance by which an element's mask border is set out from its border box."},{name:"mask-border-repeat",syntax:"[ stretch | repeat | round | space ]{1,2}",relevance:50,browsers:["E79","S17.2","C1","O15"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/mask-border-repeat"}],description:"The mask-border-repeat CSS property defines how the edge regions of a source image are adjusted to fit the dimensions of an element's mask border."},{name:"mask-border-slice",syntax:"<number-percentage>{1,4} fill?",relevance:50,browsers:["E79","S17.2","C1","O15"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/mask-border-slice"}],description:"The mask-border-slice CSS property divides the image specified by mask-border-source into regions. These regions are used to form the components of an element's mask border."},{name:"mask-border-source",syntax:"none | <image>",relevance:50,browsers:["E79","S17.2","C1","O15"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/mask-border-source"}],description:`The mask-border-source CSS property specifies the source image used to create an element's mask border.

The mask-border-slice property is used to divide the source image into regions, which are then dynamically applied to the final mask border.`},{name:"mask-border-width",syntax:"[ <length-percentage> | <number> | auto ]{1,4}",relevance:50,browsers:["E79","S17.2","C1","O15"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/mask-border-width"}],description:"The mask-border-width CSS property specifies the width of an element's mask border."},{name:"mask-clip",syntax:"[ <geometry-box> | no-clip ]#",relevance:50,browsers:["E120","FF53","S15.4","C120","O106"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/mask-clip"}],description:"The mask-clip CSS property determines the area, which is affected by a mask. The painted content of an element must be restricted to this area."},{name:"mask-composite",syntax:"<compositing-operator>#",relevance:50,browsers:["E18","FF53","S15.4","C120","O106"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/mask-composite"}],description:"The mask-composite CSS property represents a compositing operation used on the current mask layer with the mask layers below it."},{name:"masonry-auto-flow",status:"experimental",syntax:"[ pack | next ] || [ definite-first | ordered ]",relevance:50,browsers:["Spreview"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/masonry-auto-flow"}],description:"The masonry-auto-flow CSS property modifies how items are placed when using masonry in CSS Grid Layout."},{name:"math-depth",syntax:"auto-add | add(<integer>) | <integer>",relevance:50,browsers:["E109","FF117","C109","O95"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/math-depth"}],description:'Describe a notion of "depth" for each element of a mathematical formula, with respect to the top-level container of that formula.'},{name:"math-shift",syntax:"normal | compact",values:[{name:"normal"},{name:"compact"}],relevance:50,browsers:["E109","C109","O95"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/math-shift"}],description:"Used for positioning superscript during the layout of MathML scripted elements."},{name:"math-style",syntax:"normal | compact",values:[{name:"normal"},{name:"compact"}],relevance:50,browsers:["E109","FF117","S14.1","C109","O95"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/math-style"}],description:"The math-style property indicates whether MathML equations should render with normal or compact height."},{name:"max-lines",status:"experimental",syntax:"none | <integer>",relevance:50,description:"The max-lines property forces a break after a set number of lines"},{name:"offset",syntax:"[ <'offset-position'>? [ <'offset-path'> [ <'offset-distance'> || <'offset-rotate'> ]? ]? ]! [ / <'offset-anchor'> ]?",relevance:50,browsers:["E79","FF72","S16","C55","O42"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/offset"}],description:"The offset CSS property is a shorthand property for animating an element along a defined path."},{name:"offset-anchor",syntax:"auto | <position>",relevance:50,browsers:["E116","FF72","S16","C116","O102"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/offset-anchor"}],description:"Defines an anchor point of the box positioned along the path. The anchor point specifies the point of the box which is to be considered as the point that is moved along the path."},{name:"offset-distance",syntax:"<length-percentage>",relevance:50,browsers:["E79","FF72","S16","C55","O42"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/offset-distance"}],description:"The offset-distance CSS property specifies a position along an offset-path."},{name:"offset-path",syntax:"none | <offset-path> || <coord-box>",relevance:50,browsers:["E79","FF72","S15.4","C55","O45"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/offset-path"}],description:`The offset-path CSS property specifies the offset path where the element gets positioned. The exact element\u2019s position on the offset path is determined by the offset-distance property. An offset path is either a specified path with one or multiple sub-paths or the geometry of a not-styled basic shape. Each shape or path must define an initial position for the computed value of "0" for offset-distance and an initial direction which specifies the rotation of the object to the initial position.

In this specification, a direction (or rotation) of 0 degrees is equivalent to the direction of the positive x-axis in the object\u2019s local coordinate system. In other words, a rotation of 0 degree points to the right side of the UA if the object and its ancestors have no transformation applied.`},{name:"offset-position",syntax:"normal | auto | <position>",relevance:50,browsers:["E116","FF122","S16","C116","O102"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/offset-position"}],description:"Specifies the initial position of the offset path. If position is specified with static, offset-position would be ignored."},{name:"offset-rotate",syntax:"[ auto | reverse ] || <angle>",relevance:50,browsers:["E79","FF72","S16","C56","O43"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/offset-rotate"}],description:"The offset-rotate CSS property defines the direction of the element while positioning along the offset path."},{name:"overflow-anchor",syntax:"auto | none",values:[{name:"auto"},{name:"none"}],relevance:52,browsers:["E79","FF66","Spreview","C56","O43"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/overflow-anchor"}],description:"The overflow-anchor CSS property provides a way to opt out browser scroll anchoring behavior which adjusts scroll position to minimize content shifts."},{name:"overflow-block",syntax:"visible | hidden | clip | scroll | auto",values:[{name:"visible"},{name:"hidden"},{name:"clip"},{name:"scroll"},{name:"auto"}],relevance:50,browsers:["FF69"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/overflow-block"}],description:"The overflow-block CSS media feature can be used to test how the output device handles content that overflows the initial containing block along the block axis."},{name:"overflow-clip-box",status:"nonstandard",syntax:"padding-box | content-box",values:[{name:"padding-box"},{name:"content-box"}],relevance:0,description:"The overflow-clip-box CSS property specifies relative to which box the clipping happens when there is an overflow. It is short hand for the overflow-clip-box-inline and overflow-clip-box-block properties."},{name:"overflow-clip-margin",syntax:"<visual-box> || <length [0,\u221E]>",relevance:50,browsers:["E90","FF102","C90","O76"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/overflow-clip-margin"}],description:"The overflow-clip-margin CSS property determines how far outside its bounds an element with overflow: clip may be painted before being clipped."},{name:"overflow-inline",syntax:"visible | hidden | clip | scroll | auto",values:[{name:"visible"},{name:"hidden"},{name:"clip"},{name:"scroll"},{name:"auto"}],relevance:50,browsers:["FF69"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/overflow-inline"}],description:"The overflow-inline CSS media feature can be used to test how the output device handles content that overflows the initial containing block along the inline axis."},{name:"overlay",status:"experimental",syntax:"none | auto",values:[{name:"none"},{name:"auto"}],relevance:50,browsers:["E117","C117","O103"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/overlay"}],description:'The overlay CSS property specifies whether an element appearing in the top layer (for example, a shown popover or modal {{htmlelement("dialog")}} element) is actually rendered in the top layer. This property is only relevant within a list of transition-property values, and only if allow-discrete is set as the transition-behavior.'},{name:"overscroll-behavior",syntax:"[ contain | none | auto ]{1,2}",relevance:50,browsers:["E18","FF59","S16","C63","O50"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/overscroll-behavior"}],description:"The overscroll-behavior CSS property is shorthand for the overscroll-behavior-x and overscroll-behavior-y properties, which allow you to control the browser's scroll overflow behavior \u2014 what happens when the boundary of a scrolling area is reached."},{name:"overscroll-behavior-block",syntax:"contain | none | auto",values:[{name:"contain"},{name:"none"},{name:"auto"}],relevance:50,browsers:["E79","FF73","S16","C77","O64"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/overscroll-behavior-block"}],description:"The overscroll-behavior-block CSS property sets the browser's behavior when the block direction boundary of a scrolling area is reached."},{name:"overscroll-behavior-inline",syntax:"contain | none | auto",values:[{name:"contain"},{name:"none"},{name:"auto"}],relevance:50,browsers:["E79","FF73","S16","C77","O64"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/overscroll-behavior-inline"}],description:"The overscroll-behavior-inline CSS property sets the browser's behavior when the inline direction boundary of a scrolling area is reached."},{name:"overscroll-behavior-x",syntax:"contain | none | auto",values:[{name:"contain"},{name:"none"},{name:"auto"}],relevance:50,browsers:["E18","FF59","S16","C63","O50"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/overscroll-behavior-x"}],description:"The overscroll-behavior-x CSS property is allows you to control the browser's scroll overflow behavior \u2014 what happens when the boundary of a scrolling area is reached \u2014 in the x axis direction."},{name:"overscroll-behavior-y",syntax:"contain | none | auto",values:[{name:"contain"},{name:"none"},{name:"auto"}],relevance:50,browsers:["E18","FF59","S16","C63","O50"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/overscroll-behavior-y"}],description:"The overscroll-behavior-y CSS property is allows you to control the browser's scroll overflow behavior \u2014 what happens when the boundary of a scrolling area is reached \u2014 in the y axis direction."},{name:"padding-block",syntax:"<'padding-left'>{1,2}",relevance:54,browsers:["E87","FF66","S14.1","C87","O73"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/padding-block"}],description:"The padding-block CSS property defines the logical block start and end padding of an element, which maps to physical padding properties depending on the element's writing mode, directionality, and text orientation."},{name:"padding-inline",syntax:"<'padding-left'>{1,2}",relevance:54,browsers:["E87","FF66","S14.1","C87","O73"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/padding-inline"}],description:"The padding-inline CSS property defines the logical inline start and end padding of an element, which maps to physical padding properties depending on the element's writing mode, directionality, and text orientation."},{name:"page",syntax:"auto | <custom-ident>",relevance:50,browsers:["E85","FF110","S13.1","C85","O71"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/page"}],description:"The page CSS property is used to specify the named page, a specific type of page defined by the @page at-rule."},{name:"place-content",syntax:"<'align-content'> <'justify-content'>?",relevance:51,browsers:["E79","FF45","S9","C59","O46"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/place-content"}],description:"The place-content CSS shorthand property sets both the align-content and justify-content properties."},{name:"place-items",syntax:"<'align-items'> <'justify-items'>?",relevance:51,browsers:["E79","FF45","S11","C59","O46"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/place-items"}],description:"The CSS place-items shorthand property sets both the align-items and justify-items properties. The first value is the align-items property value, the second the justify-items one. If the second value is not present, the first value is also used for it."},{name:"place-self",syntax:"<'align-self'> <'justify-self'>?",relevance:50,browsers:["E79","FF45","S11","C59","O46"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/place-self"}],description:"The place-self CSS property is a shorthand property sets both the align-self and justify-self properties. The first value is the align-self property value, the second the justify-self one. If the second value is not present, the first value is also used for it."},{name:"print-color-adjust",syntax:"economy | exact",values:[{name:"economy"},{name:"exact"}],relevance:50,browsers:["E79","FF97","S15.4","C17","O15"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/print-color-adjust"}],description:"Defines what optimization the user agent is allowed to do when adjusting the appearance for an output device."},{name:"rotate",syntax:"none | <angle> | [ x | y | z | <number>{3} ] && <angle>",relevance:50,browsers:["E104","FF72","S14.1","C104","O90"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/rotate"}],description:"The rotate CSS property allows you to specify rotation transforms individually and independently of the transform property. This maps better to typical user interface usage, and saves having to remember the exact order of transform functions to specify in the transform value."},{name:"row-gap",syntax:"normal | <length-percentage>",relevance:58,browsers:["E16","FF52","S10.1","C47","O34"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/row-gap"}],description:"The row-gap CSS property specifies the gutter between grid rows."},{name:"ruby-merge",status:"experimental",syntax:"separate | collapse | auto",values:[{name:"separate"},{name:"collapse"},{name:"auto"}],relevance:50,description:"This property controls how ruby annotation boxes should be rendered when there are more than one in a ruby container box: whether each pair should be kept separate, the annotations should be collapsed and rendered as a group, or the separation should be determined based on the space available."},{name:"scale",syntax:"none | <number>{1,3}",relevance:51,browsers:["E104","FF72","S14.1","C104","O90"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/scale"}],description:"The scale CSS property allows you to specify scale transforms individually and independently of the transform property. This maps better to typical user interface usage, and saves having to remember the exact order of transform functions to specify in the transform value."},{name:"scrollbar-color",syntax:"auto | <color>{2}",relevance:52,browsers:["E121","FF64","C121"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/scrollbar-color"}],description:"The scrollbar-color CSS property sets the color of the scrollbar track and thumb."},{name:"scrollbar-gutter",syntax:"auto | stable && both-edges?",relevance:50,browsers:["E94","FF97","S17","C94","O80"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/scrollbar-gutter"}],description:"The scrollbar-gutter CSS property allows authors to reserve space for the scrollbar, preventing unwanted layout changes as the content grows while also avoiding unnecessary visuals when scrolling isn't needed."},{name:"scrollbar-width",syntax:"auto | thin | none",values:[{name:"auto"},{name:"thin"},{name:"none"}],relevance:63,browsers:["E121","FF64","C121"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/scrollbar-width"}],description:"The scrollbar-width property allows the author to set the maximum thickness of an element\u2019s scrollbars when they are shown. "},{name:"scroll-margin",syntax:"<length>{1,4}",relevance:50,browsers:["E79","FF90","S14.1","C69","O56"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/scroll-margin"}],description:"The scroll-margin property is a shorthand property which sets all of the scroll-margin longhands, assigning values much like the margin property does for the margin-* longhands."},{name:"scroll-margin-block",syntax:"<length>{1,2}",relevance:50,browsers:["E79","FF68","S15","C69","O56"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/scroll-margin-block"}],description:"The scroll-margin-block property is a shorthand property which sets the scroll-margin longhands in the block dimension."},{name:"scroll-margin-block-start",syntax:"<length>",relevance:50,browsers:["E79","FF68","S15","C69","O56"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/scroll-margin-block-start"}],description:"The scroll-margin-block-start property defines the margin of the scroll snap area at the start of the block dimension that is used for snapping this box to the snapport. The scroll snap area is determined by taking the transformed border box, finding its rectangular bounding box (axis-aligned in the scroll container\u2019s coordinate space), then adding the specified outsets."},{name:"scroll-margin-block-end",syntax:"<length>",relevance:50,browsers:["E79","FF68","S15","C69","O56"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/scroll-margin-block-end"}],description:"The scroll-margin-block-end property defines the margin of the scroll snap area at the end of the block dimension that is used for snapping this box to the snapport. The scroll snap area is determined by taking the transformed border box, finding its rectangular bounding box (axis-aligned in the scroll container\u2019s coordinate space), then adding the specified outsets."},{name:"scroll-margin-bottom",syntax:"<length>",relevance:50,browsers:["E79","FF68","S14.1","C69","O56"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/scroll-margin-bottom"}],description:"The scroll-margin-bottom property defines the bottom margin of the scroll snap area that is used for snapping this box to the snapport. The scroll snap area is determined by taking the transformed border box, finding its rectangular bounding box (axis-aligned in the scroll container\u2019s coordinate space), then adding the specified outsets."},{name:"scroll-margin-inline",syntax:"<length>{1,2}",relevance:50,browsers:["E79","FF68","S15","C69","O56"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/scroll-margin-inline"}],description:"The scroll-margin-inline property is a shorthand property which sets the scroll-margin longhands in the inline dimension."},{name:"scroll-margin-inline-start",syntax:"<length>",relevance:50,browsers:["E79","FF68","S15","C69","O56"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/scroll-margin-inline-start"}],description:"The scroll-margin-inline-start property defines the margin of the scroll snap area at the start of the inline dimension that is used for snapping this box to the snapport. The scroll snap area is determined by taking the transformed border box, finding its rectangular bounding box (axis-aligned in the scroll container\u2019s coordinate space), then adding the specified outsets."},{name:"scroll-margin-inline-end",syntax:"<length>",relevance:50,browsers:["E79","FF68","S15","C69","O56"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/scroll-margin-inline-end"}],description:"The scroll-margin-inline-end property defines the margin of the scroll snap area at the end of the inline dimension that is used for snapping this box to the snapport. The scroll snap area is determined by taking the transformed border box, finding its rectangular bounding box (axis-aligned in the scroll container\u2019s coordinate space), then adding the specified outsets."},{name:"scroll-margin-left",syntax:"<length>",relevance:50,browsers:["E79","FF68","S14.1","C69","O56"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/scroll-margin-left"}],description:"The scroll-margin-left property defines the left margin of the scroll snap area that is used for snapping this box to the snapport. The scroll snap area is determined by taking the transformed border box, finding its rectangular bounding box (axis-aligned in the scroll container\u2019s coordinate space), then adding the specified outsets."},{name:"scroll-margin-right",syntax:"<length>",relevance:50,browsers:["E79","FF68","S14.1","C69","O56"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/scroll-margin-right"}],description:"The scroll-margin-right property defines the right margin of the scroll snap area that is used for snapping this box to the snapport. The scroll snap area is determined by taking the transformed border box, finding its rectangular bounding box (axis-aligned in the scroll container\u2019s coordinate space), then adding the specified outsets."},{name:"scroll-margin-top",syntax:"<length>",relevance:50,browsers:["E79","FF68","S14.1","C69","O56"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/scroll-margin-top"}],description:"The scroll-margin-top property defines the top margin of the scroll snap area that is used for snapping this box to the snapport. The scroll snap area is determined by taking the transformed border box, finding its rectangular bounding box (axis-aligned in the scroll container\u2019s coordinate space), then adding the specified outsets."},{name:"scroll-padding",syntax:"[ auto | <length-percentage> ]{1,4}",relevance:50,browsers:["E79","FF68","S14.1","C69","O56"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/scroll-padding"}],description:"The scroll-padding property is a shorthand property which sets all of the scroll-padding longhands, assigning values much like the padding property does for the padding-* longhands."},{name:"scroll-padding-block",syntax:"[ auto | <length-percentage> ]{1,2}",relevance:50,browsers:["E79","FF68","S15","C69","O56"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/scroll-padding-block"}],description:"The scroll-padding-block property is a shorthand property which sets the scroll-padding longhands for the block dimension."},{name:"scroll-padding-block-start",syntax:"auto | <length-percentage>",relevance:50,browsers:["E79","FF68","S15","C69","O56"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/scroll-padding-block-start"}],description:"The scroll-padding-block-start property defines offsets for the start edge in the block dimension of the optimal viewing region of the scrollport: the region used as the target region for placing things in view of the user. This allows the author to exclude regions of the scrollport that are obscured by other content (such as fixed-positioned toolbars or sidebars) or simply to put more breathing room between a targeted element and the edges of the scrollport."},{name:"scroll-padding-block-end",syntax:"auto | <length-percentage>",relevance:50,browsers:["E79","FF68","S15","C69","O56"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/scroll-padding-block-end"}],description:"The scroll-padding-block-end property defines offsets for the end edge in the block dimension of the optimal viewing region of the scrollport: the region used as the target region for placing things in view of the user. This allows the author to exclude regions of the scrollport that are obscured by other content (such as fixed-positioned toolbars or sidebars) or simply to put more breathing room between a targeted element and the edges of the scrollport."},{name:"scroll-padding-bottom",syntax:"auto | <length-percentage>",relevance:50,browsers:["E79","FF68","S14.1","C69","O56"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/scroll-padding-bottom"}],description:"The scroll-padding-bottom property defines offsets for the bottom of the optimal viewing region of the scrollport: the region used as the target region for placing things in view of the user. This allows the author to exclude regions of the scrollport that are obscured by other content (such as fixed-positioned toolbars or sidebars) or simply to put more breathing room between a targeted element and the edges of the scrollport."},{name:"scroll-padding-inline",syntax:"[ auto | <length-percentage> ]{1,2}",relevance:50,browsers:["E79","FF68","S15","C69","O56"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/scroll-padding-inline"}],description:"The scroll-padding-inline property is a shorthand property which sets the scroll-padding longhands for the inline dimension."},{name:"scroll-padding-inline-start",syntax:"auto | <length-percentage>",relevance:50,browsers:["E79","FF68","S15","C69","O56"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/scroll-padding-inline-start"}],description:"The scroll-padding-inline-start property defines offsets for the start edge in the inline dimension of the optimal viewing region of the scrollport: the region used as the target region for placing things in view of the user. This allows the author to exclude regions of the scrollport that are obscured by other content (such as fixed-positioned toolbars or sidebars) or simply to put more breathing room between a targeted element and the edges of the scrollport."},{name:"scroll-padding-inline-end",syntax:"auto | <length-percentage>",relevance:50,browsers:["E79","FF68","S15","C69","O56"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/scroll-padding-inline-end"}],description:"The scroll-padding-inline-end property defines offsets for the end edge in the inline dimension of the optimal viewing region of the scrollport: the region used as the target region for placing things in view of the user. This allows the author to exclude regions of the scrollport that are obscured by other content (such as fixed-positioned toolbars or sidebars) or simply to put more breathing room between a targeted element and the edges of the scrollport."},{name:"scroll-padding-left",syntax:"auto | <length-percentage>",relevance:50,browsers:["E79","FF68","S14.1","C69","O56"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/scroll-padding-left"}],description:"The scroll-padding-left property defines offsets for the left of the optimal viewing region of the scrollport: the region used as the target region for placing things in view of the user. This allows the author to exclude regions of the scrollport that are obscured by other content (such as fixed-positioned toolbars or sidebars) or simply to put more breathing room between a targeted element and the edges of the scrollport."},{name:"scroll-padding-right",syntax:"auto | <length-percentage>",relevance:50,browsers:["E79","FF68","S14.1","C69","O56"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/scroll-padding-right"}],description:"The scroll-padding-right property defines offsets for the right of the optimal viewing region of the scrollport: the region used as the target region for placing things in view of the user. This allows the author to exclude regions of the scrollport that are obscured by other content (such as fixed-positioned toolbars or sidebars) or simply to put more breathing room between a targeted element and the edges of the scrollport."},{name:"scroll-padding-top",syntax:"auto | <length-percentage>",relevance:50,browsers:["E79","FF68","S14.1","C69","O56"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/scroll-padding-top"}],description:"The scroll-padding-top property defines offsets for the top of the optimal viewing region of the scrollport: the region used as the target region for placing things in view of the user. This allows the author to exclude regions of the scrollport that are obscured by other content (such as fixed-positioned toolbars or sidebars) or simply to put more breathing room between a targeted element and the edges of the scrollport."},{name:"scroll-snap-align",syntax:"[ none | start | end | center ]{1,2}",relevance:53,browsers:["E79","FF68","S11","C69","O56"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/scroll-snap-align"}],description:"The scroll-snap-align property specifies the box\u2019s snap position as an alignment of its snap area (as the alignment subject) within its snap container\u2019s snapport (as the alignment container). The two values specify the snapping alignment in the block axis and inline axis, respectively. If only one value is specified, the second value defaults to the same value."},{name:"scroll-snap-stop",syntax:"normal | always",values:[{name:"normal"},{name:"always"}],relevance:51,browsers:["E79","FF103","S15","C75","O62"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/scroll-snap-stop"}],description:'The scroll-snap-stop CSS property defines whether the scroll container is allowed to "pass over" possible snap positions.'},{name:"scroll-snap-type-x",status:"obsolete",syntax:"none | mandatory | proximity",values:[{name:"none"},{name:"mandatory"},{name:"proximity"}],relevance:0,description:`The scroll-snap-type-x CSS property defines how strictly snap points are enforced on the horizontal axis of the scroll container in case there is one.

Specifying any precise animations or physics used to enforce those snap points is not covered by this property but instead left up to the user agent.`},{name:"scroll-snap-type-y",status:"obsolete",syntax:"none | mandatory | proximity",values:[{name:"none"},{name:"mandatory"},{name:"proximity"}],relevance:0,description:`The scroll-snap-type-y CSS property defines how strictly snap points are enforced on the vertical axis of the scroll container in case there is one.

Specifying any precise animations or physics used to enforce those snap points is not covered by this property but instead left up to the user agent.`},{name:"scroll-timeline",status:"experimental",syntax:"[ <'scroll-timeline-name'> <'scroll-timeline-axis'>? ]#",relevance:50,browsers:["E115","FF111","C115","O101"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/scroll-timeline"}],description:"Defines a name that can be used to identify the source element of a scroll timeline, along with the scrollbar axis that should provide the timeline."},{name:"scroll-timeline-axis",status:"experimental",syntax:"[ block | inline | x | y ]#",relevance:50,browsers:["E115","FF111","C115","O101"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/scroll-timeline-axis"}],description:"Specifies the scrollbar that will be used to provide the timeline for a scroll-timeline animation"},{name:"scroll-timeline-name",status:"experimental",syntax:"none | <dashed-ident>#",relevance:50,browsers:["E115","FF111","C115","O101"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/scroll-timeline-name"}],description:"Defines a name that can be used to identify an element as the source of a scroll-timeline."},{name:"text-combine-upright",syntax:"none | all | [ digits <integer>? ]",relevance:50,browsers:["E79","FF48","S15.4","C48","IE11","O35"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/text-combine-upright"}],description:`The text-combine-upright CSS property specifies the combination of multiple characters into the space of a single character. If the combined text is wider than 1em, the user agent must fit the contents within 1em. The resulting composition is treated as a single upright glyph for layout and decoration. This property only has an effect in vertical writing modes.

This is used to produce an effect that is known as tate-ch\u016B-yoko (\u7E26\u4E2D\u6A2A) in Japanese, or as \u76F4\u66F8\u6A6B\u5411 in Chinese.`},{name:"text-decoration-skip",status:"experimental",syntax:"none | [ objects || [ spaces | [ leading-spaces || trailing-spaces ] ] || edges || box-decoration ]",relevance:52,browsers:["S12.1","C57","O44"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/text-decoration-skip"}],description:"The text-decoration-skip CSS property specifies what parts of the element\u2019s content any text decoration affecting the element must skip over. It controls all text decoration lines drawn by the element and also any text decoration lines drawn by its ancestors."},{name:"text-decoration-skip-ink",syntax:"auto | all | none",values:[{name:"auto"},{name:"all"},{name:"none"}],relevance:51,browsers:["E79","FF70","S15.4","C64","O50"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/text-decoration-skip-ink"}],description:"The text-decoration-skip-ink CSS property specifies how overlines and underlines are drawn when they pass over glyph ascenders and descenders."},{name:"text-decoration-thickness",syntax:"auto | from-font | <length> | <percentage> ",relevance:50,browsers:["E89","FF70","S12.1","C89","O75"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/text-decoration-thickness"}],description:"The text-decoration-thickness CSS property sets the thickness, or width, of the decoration line that is used on text in an element, such as a line-through, underline, or overline."},{name:"text-emphasis",syntax:"<'text-emphasis-style'> || <'text-emphasis-color'>",relevance:50,browsers:["E99","FF46","S7","C99","O85"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/text-emphasis"}],description:"The text-emphasis CSS property is a shorthand property for setting text-emphasis-style and text-emphasis-color in one declaration. This property will apply the specified emphasis mark to each character of the element's text, except separator characters, like spaces,  and control characters."},{name:"text-emphasis-color",syntax:"<color>",relevance:50,browsers:["E99","FF46","S7","C99","O85"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/text-emphasis-color"}],description:"The text-emphasis-color CSS property defines the color used to draw emphasis marks on text being rendered in the HTML document. This value can also be set and reset using the text-emphasis shorthand."},{name:"text-emphasis-position",syntax:"[ over | under ] && [ right | left ]",relevance:50,browsers:["E99","FF46","S7","C99","O85"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/text-emphasis-position"}],description:"The text-emphasis-position CSS property describes where emphasis marks are drawn at. The effect of emphasis marks on the line height is the same as for ruby text: if there isn't enough place, the line height is increased."},{name:"text-emphasis-style",syntax:"none | [ [ filled | open ] || [ dot | circle | double-circle | triangle | sesame ] ] | <string>",relevance:50,browsers:["E99","FF46","S7","C99","O85"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/text-emphasis-style"}],description:"The text-emphasis-style CSS property defines the type of emphasis used. It can also be set, and reset, using the text-emphasis shorthand."},{name:"text-size-adjust",status:"experimental",syntax:"none | auto | <percentage>",relevance:57,browsers:["E79","C54","O41"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/text-size-adjust"}],description:"The text-size-adjust CSS property controls the text inflation algorithm used on some smartphones and tablets. Other browsers will ignore this property."},{name:"text-underline-offset",syntax:"auto | <length> | <percentage> ",relevance:51,browsers:["E87","FF70","S12.1","C87","O73"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/text-underline-offset"}],description:"The text-underline-offset CSS property sets the offset distance of an underline text decoration line (applied using text-decoration) from its original position."},{name:"text-wrap",syntax:"wrap | nowrap | balance | stable | pretty",values:[{name:"wrap"},{name:"nowrap"},{name:"balance"},{name:"stable"},{name:"pretty"}],relevance:54,browsers:["E114","FF121","Spreview","C114","O100"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/text-wrap"}],description:"The text-wrap CSS property controls how text inside an element is wrapped."},{name:"timeline-scope",status:"experimental",syntax:"none | <dashed-ident>#",relevance:50,browsers:["E116","C116","O102"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/timeline-scope"}],description:"The timeline-scope CSS property modifies the scope of a named animation timeline."},{name:"transform-box",syntax:"content-box | border-box | fill-box | stroke-box | view-box",values:[{name:"content-box"},{name:"border-box"},{name:"fill-box"},{name:"stroke-box"},{name:"view-box"}],relevance:50,browsers:["E79","FF55","S11","C64","O51"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/transform-box"}],description:"The transform-box CSS property defines the layout box to which the transform and transform-origin properties relate."},{name:"transition-behavior",status:"experimental",syntax:"<transition-behavior-value>#",relevance:50,browsers:["E117","C117","O103"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/transition-behavior"}],description:"The transition-behavior CSS property specifies whether transitions will be started for properties whose animation behavior is discrete."},{name:"translate",syntax:"none | <length-percentage> [ <length-percentage> <length>? ]?",relevance:50,browsers:["E104","FF72","S14.1","C104","O90"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/translate"}],description:"The translate CSS property allows you to specify translation transforms individually and independently of the transform property. This maps better to typical user interface usage, and saves having to remember the exact order of transform functions to specify in the transform value."},{name:"view-timeline",status:"experimental",syntax:"[ <'view-timeline-name'> <'view-timeline-axis'>? ]#",relevance:50,browsers:["E115","FF114","C115","O101"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/view-timeline"}],description:"The view-timeline CSS shorthand property is used to define a named view progress timeline, which is progressed through based on the change in visibility of an element (known as the subject) inside a scrollable element (scroller). view-timeline is set on the subject."},{name:"view-timeline-axis",status:"experimental",syntax:"[ block | inline | x | y ]#",relevance:50,browsers:["E115","FF114","C115","O101"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/view-timeline-axis"}],description:"The view-timeline-axis CSS property is used to specify the scrollbar direction that will be used to provide the timeline for a named view progress timeline animation, which is progressed through based on the change in visibility of an element (known as the subject) inside a scrollable element (scroller). view-timeline-axis is set on the subject. See CSS scroll-driven animations for more details."},{name:"view-timeline-inset",status:"experimental",syntax:"[ [ auto | <length-percentage> ]{1,2} ]#",relevance:50,browsers:["E115","C115","O101"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/view-timeline-inset"}],description:"The view-timeline-inset CSS property is used to specify one or two values representing an adjustment to the position of the scrollport (see Scroll container for more details) in which the subject element of a named view progress timeline animation is deemed to be visible. Put another way, this allows you to specify start and/or end inset (or outset) values that offset the position of the timeline."},{name:"view-timeline-name",status:"experimental",syntax:"none | <dashed-ident>#",relevance:50,browsers:["E115","FF111","C115","O101"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/view-timeline-name"}],description:"The view-timeline-name CSS property is used to define the name of a named view progress timeline, which is progressed through based on the change in visibility of an element (known as the subject) inside a scrollable element (scroller). view-timeline is set on the subject."},{name:"view-transition-name",status:"experimental",syntax:"none | <custom-ident>",relevance:50,browsers:["E111","C111","O97"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/view-transition-name"}],description:"The view-transition-name CSS property provides the selected element with a distinct identifying name (a custom-ident) and causes it to participate in a separate view transition from the root view transition \u2014 or no view transition if the none value is specified."},{name:"white-space",syntax:"normal | pre | nowrap | pre-wrap | pre-line | break-spaces | [ <'white-space-collapse'> || <'text-wrap'> || <'white-space-trim'> ]",relevance:89,browsers:["E12","FF1","S1","C1","IE5.5","O4"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/white-space"}],description:"Specifies how whitespace is handled in an element."},{name:"white-space-collapse",syntax:"collapse | discard | preserve | preserve-breaks | preserve-spaces | break-spaces",values:[{name:"collapse"},{name:"discard"},{name:"preserve"},{name:"preserve-breaks"},{name:"preserve-spaces"},{name:"break-spaces"}],relevance:50,browsers:["E114","Spreview","C114","O100"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/white-space-collapse"}],description:"The white-space-collapse CSS property controls how white space inside an element is collapsed."},{name:"speak-as",atRule:"@counter-style",syntax:"auto | bullets | numbers | words | spell-out | <counter-style-name>",relevance:50,browsers:["S11.1"],description:"The speak-as descriptor specifies how a counter symbol constructed with a given @counter-style will be represented in the spoken form. For example, an author can specify a counter symbol to be either spoken as its numerical value or just represented with an audio cue."},{name:"base-palette",atRule:"@font-palette-values",syntax:"light | dark | <integer [0,\u221E]>",relevance:50,description:"The base-palette CSS descriptor is used to specify the name or index of a pre-defined palette to be used for creating a new palette. If the specified base-palette does not exist, then the palette defined at index 0 will be used."},{name:"override-colors",atRule:"@font-palette-values",syntax:"[ <integer [0,\u221E]> <absolute-color-base> ]#",relevance:50,description:"The override-colors CSS descriptor is used to override colors in the chosen base-palette for a color font."},{name:"ascent-override",atRule:"@font-face",status:"experimental",syntax:"normal | <percentage>",relevance:50,description:"Describes the ascent metric of a font."},{name:"descent-override",atRule:"@font-face",status:"experimental",syntax:"normal | <percentage>",relevance:50,description:"Describes the descent metric of a font."},{name:"font-display",atRule:"@font-face",status:"experimental",syntax:"[ auto | block | swap | fallback | optional ]",relevance:74,description:"The font-display descriptor determines how a font face is displayed based on whether and when it is downloaded and ready to use."},{name:"line-gap-override",atRule:"@font-face",status:"experimental",syntax:"normal | <percentage>",relevance:50,description:"Describes the line-gap metric of a font."},{name:"size-adjust",atRule:"@font-face",status:"experimental",syntax:"<percentage>",relevance:50,description:"A multiplier for glyph outlines and metrics of a font."},{name:"bleed",atRule:"@page",syntax:"auto | <length>",relevance:50,description:"The bleed CSS at-rule descriptor, used with the @page at-rule, specifies the extent of the page bleed area outside the page box. This property only has effect if crop marks are enabled using the marks property."},{name:"marks",atRule:"@page",syntax:"none | [ crop || cross ]",relevance:50,description:"The marks CSS at-rule descriptor, used with the @page at-rule, adds crop and/or cross marks to the presentation of the document. Crop marks indicate where the page should be cut. Cross marks are used to align sheets."},{name:"page-orientation",atRule:"@page",syntax:"upright | rotate-left | rotate-right ",relevance:50,description:"The page-orientation CSS descriptor for the @page at-rule controls the rotation of a printed page. It handles the flow of content across pages when the orientation of a page is changed. This behavior differs from the size descriptor in that a user can define the direction in which to rotate the page."},{name:"syntax",atRule:"@property",status:"experimental",syntax:"<string>",relevance:50,description:"Specifies the syntax of the custom property registration represented by the @property rule, controlling how the property\u2019s value is parsed at computed value time."},{name:"inherits",atRule:"@property",status:"experimental",syntax:"true | false",values:[{name:"true"},{name:"false"}],relevance:50,description:"Specifies the inherit flag of the custom property registration represented by the @property rule, controlling whether or not the property inherits by default."},{name:"initial-value",atRule:"@property",status:"experimental",syntax:"<declaration-value>?",relevance:50,description:"Specifies the initial value of the custom property registration represented by the @property rule, controlling the property\u2019s initial value."}],atDirectives:[{name:"@charset",browsers:["E12","FF1.5","S4","C2","IE5.5","O9"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/@charset"}],description:"Defines character set of the document."},{name:"@counter-style",browsers:["E91","FF33","S17","C91","O77"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/@counter-style"}],description:"Defines a custom counter style."},{name:"@font-face",browsers:["E12","FF3.5","S3.1","C1","IE4","O10"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/@font-face"}],description:"Allows for linking to fonts that are automatically activated when needed. This permits authors to work around the limitation of 'web-safe' fonts, allowing for consistent rendering independent of the fonts available in a given user's environment."},{name:"@font-feature-values",browsers:["E111","FF34","S9.1","C111","O97"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/@font-feature-values"}],description:"Defines named values for the indices used to select alternate glyphs for a given font family."},{name:"@import",browsers:["E12","FF1","S1","C1","IE5.5","O3.5"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/@import"}],description:"Includes content of another file."},{name:"@keyframes",browsers:["E12","FF16","S9","C43","IE10","O30"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/@keyframes"}],description:"Defines set of animation key frames."},{name:"@layer",browsers:["E99","FF97","S15.4","C99","O85"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/@layer"}],description:"Declare a cascade layer and the order of precedence in case of multiple cascade layers."},{name:"@media",browsers:["E12","FF1","S3","C1","IE6","O9.2"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/@media"}],description:"Defines a stylesheet for a particular media type."},{name:"@-moz-document",browsers:["FF1.8"],description:"Gecko-specific at-rule that restricts the style rules contained within it based on the URL of the document."},{name:"@-moz-keyframes",browsers:["FF5"],description:"Defines set of animation key frames."},{name:"@-ms-viewport",browsers:["E","IE10"],description:"Specifies the size, zoom factor, and orientation of the viewport."},{name:"@namespace",browsers:["E12","FF1","S1","C1","IE9","O8"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/@namespace"}],description:"Declares a prefix and associates it with a namespace name."},{name:"@-o-keyframes",browsers:["O12"],description:"Defines set of animation key frames."},{name:"@-o-viewport",browsers:["O11"],description:"Specifies the size, zoom factor, and orientation of the viewport."},{name:"@page",browsers:["E12","FF19","S13.1","C2","IE8","O6"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/@page"}],description:"Directive defines various page parameters."},{name:"@property",browsers:["E85","FFpreview","S16.4","C85","O71"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/@property"}],description:"Describes the aspect of custom properties and variables."},{name:"@supports",browsers:["E12","FF22","S9","C28","O12.1"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/@supports"}],description:"A conditional group rule whose condition tests whether the user agent supports CSS property:value pairs."},{name:"@-webkit-keyframes",browsers:["C","S4"],description:"Defines set of animation key frames."}],pseudoClasses:[{name:":active",browsers:["E12","FF1","S1","C1","IE4","O5"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/:active"}],description:"Applies while an element is being activated by the user. For example, between the times the user presses the mouse button and releases it."},{name:":any-link",browsers:["E79","FF50","S9","C65","O52"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/:any-link"}],description:"Represents an element that acts as the source anchor of a hyperlink. Applies to both visited and unvisited links."},{name:":checked",browsers:["E12","FF1","S3.1","C1","IE9","O9"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/:checked"}],description:"Radio and checkbox elements can be toggled by the user. Some menu items are 'checked' when the user selects them. When such elements are toggled 'on' the :checked pseudo-class applies."},{name:":corner-present",browsers:["C","S5"],description:"Non-standard. Indicates whether or not a scrollbar corner is present."},{name:":decrement",browsers:["C","S5"],description:"Non-standard. Applies to buttons and track pieces. Indicates whether or not the button or track piece will decrement the view's position when used."},{name:":default",browsers:["E79","FF4","S5","C10","O10"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/:default"}],description:"Applies to the one or more UI elements that are the default among a set of similar elements. Typically applies to context menu items, buttons, and select lists/menus."},{name:":disabled",browsers:["E12","FF1","S3.1","C1","IE9","O9"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/:disabled"}],description:"Represents user interface elements that are in a disabled state; such elements have a corresponding enabled state."},{name:":double-button",browsers:["C","S5"],description:"Non-standard. Applies to buttons and track pieces. Applies when both buttons are displayed together at the same end of the scrollbar."},{name:":empty",browsers:["E12","FF1","S3.1","C1","IE9","O9.5"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/:empty"}],description:"Represents an element that has no children at all."},{name:":enabled",browsers:["E12","FF1","S3.1","C1","IE9","O9"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/:enabled"}],description:"Represents user interface elements that are in an enabled state; such elements have a corresponding disabled state."},{name:":end",browsers:["C","S5"],description:"Non-standard. Applies to buttons and track pieces. Indicates whether the object is placed after the thumb."},{name:":first",browsers:["E12","FF116","S6","C18","IE8","O9.2"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/:first"}],description:"When printing double-sided documents, the page boxes on left and right pages may be different. This can be expressed through CSS pseudo-classes defined in the  page context."},{name:":first-child",browsers:["E12","FF3","S3.1","C4","IE7","O9.5"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/:first-child"}],description:"Same as :nth-child(1). Represents an element that is the first child of some other element."},{name:":first-of-type",browsers:["E12","FF3.5","S3.1","C1","IE9","O9.5"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/:first-of-type"}],description:"Same as :nth-of-type(1). Represents an element that is the first sibling of its type in the list of children of its parent element."},{name:":focus",browsers:["E12","FF1","S1","C1","IE8","O7"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/:focus"}],description:"Applies while an element has the focus (accepts keyboard or mouse events, or other forms of input)."},{name:":fullscreen",browsers:["E12","FF64","S16.4","C71","IE11","O58"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/:fullscreen"}],description:"Matches any element that has its fullscreen flag set."},{name:":future",browsers:["E79","S7","C23","O15"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/:future"}],description:"Represents any element that is defined to occur entirely after a :current element."},{name:":horizontal",browsers:["C","S5"],description:"Non-standard. Applies to any scrollbar pieces that have a horizontal orientation."},{name:":host",browsers:["E79","FF63","S10","C54","O41"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/:host"}],description:"When evaluated in the context of a shadow tree, matches the shadow tree's host element."},{name:":host()",browsers:["C35","O22"],description:"When evaluated in the context of a shadow tree, it matches the shadow tree's host element if the host element, in its normal context, matches the selector argument."},{name:":host-context()",browsers:["C35","O22"],description:"Tests whether there is an ancestor, outside the shadow tree, which matches a particular selector."},{name:":hover",browsers:["E12","FF1","S2","C1","IE4","O4"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/:hover"}],description:"Applies while the user designates an element with a pointing device, but does not necessarily activate it. For example, a visual user agent could apply this pseudo-class when the cursor (mouse pointer) hovers over a box generated by the element."},{name:":increment",browsers:["C","S5"],description:"Non-standard. Applies to buttons and track pieces. Indicates whether or not the button or track piece will increment the view's position when used."},{name:":indeterminate",browsers:["E12","FF2","S3","C1","IE10","O9"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/:indeterminate"}],description:"Applies to UI elements whose value is in an indeterminate state."},{name:":in-range",browsers:["E13","FF29","S5.1","C10","O11"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/:in-range"}],description:"Used in conjunction with the min and max attributes, whether on a range input, a number field, or any other types that accept those attributes."},{name:":invalid",browsers:["E12","FF4","S5","C10","IE10","O10"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/:invalid"}],description:"An element is :valid or :invalid when it is, respectively, valid or invalid with respect to data validity semantics defined by a different specification."},{name:":lang()",browsers:["E","C","FF1","IE8","O8","S3"],description:"Represents an element that is in language specified."},{name:":last-child",browsers:["E12","FF1","S3.1","C1","IE9","O9.5"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/:last-child"}],description:"Same as :nth-last-child(1). Represents an element that is the last child of some other element."},{name:":last-of-type",browsers:["E12","FF3.5","S3.1","C1","IE9","O9.5"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/:last-of-type"}],description:"Same as :nth-last-of-type(1). Represents an element that is the last sibling of its type in the list of children of its parent element."},{name:":left",browsers:["E12","S5","C6","IE8","O9.2"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/:left"}],description:"When printing double-sided documents, the page boxes on left and right pages may be different. This can be expressed through CSS pseudo-classes defined in the  page context."},{name:":link",browsers:["E12","FF1","S1","C1","IE3","O3.5"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/:link"}],description:"Applies to links that have not yet been visited."},{name:":matches()",browsers:["S9"],description:"Takes a selector list as its argument. It represents an element that is represented by its argument."},{name:":-moz-any()",browsers:["FF4"],description:"Represents an element that is represented by the selector list passed as its argument. Standardized as :matches()."},{name:":-moz-any-link",browsers:["FF1"],description:"Represents an element that acts as the source anchor of a hyperlink. Applies to both visited and unvisited links."},{name:":-moz-broken",browsers:["FF3"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/:-moz-broken"}],description:"Non-standard. Matches elements representing broken images."},{name:":-moz-drag-over",browsers:["FF1"],description:"Non-standard. Matches elements when a drag-over event applies to it."},{name:":-moz-first-node",browsers:["FF72"],description:"Non-standard. Represents an element that is the first child node of some other element."},{name:":-moz-focusring",browsers:["FF4"],description:"Non-standard. Matches an element that has focus and focus ring drawing is enabled in the browser."},{name:":-moz-full-screen",browsers:["FF9"],description:"Matches any element that has its fullscreen flag set. Standardized as :fullscreen."},{name:":-moz-last-node",browsers:["FF72"],description:"Non-standard. Represents an element that is the last child node of some other element."},{name:":-moz-loading",browsers:["FF3"],description:"Non-standard. Matches elements, such as images, that haven't started loading yet."},{name:":-moz-only-whitespace",browsers:["FF1"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/:-moz-only-whitespace"}],description:"The same as :empty, except that it additionally matches elements that only contain code points affected by whitespace processing. Standardized as :blank."},{name:":-moz-placeholder",browsers:["FF4"],description:"Deprecated. Represents placeholder text in an input field. Use ::-moz-placeholder for Firefox 19+."},{name:":-moz-submit-invalid",browsers:["FF88"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/:-moz-submit-invalid"}],description:"Non-standard. Represents any submit button when the contents of the associated form are not valid."},{name:":-moz-suppressed",browsers:["FF3"],description:"Non-standard. Matches elements representing images that have been blocked from loading."},{name:":-moz-ui-invalid",browsers:["FF4"],description:"Non-standard. Represents any validated form element whose value isn't valid "},{name:":-moz-ui-valid",browsers:["FF4"],description:"Non-standard. Represents any validated form element whose value is valid "},{name:":-moz-user-disabled",browsers:["FF3"],description:"Non-standard. Matches elements representing images that have been disabled due to the user's preferences."},{name:":-moz-window-inactive",browsers:["FF4"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/:-moz-window-inactive"}],description:"Non-standard. Matches elements in an inactive window."},{name:":-ms-fullscreen",browsers:["IE11"],description:"Matches any element that has its fullscreen flag set."},{name:":-ms-input-placeholder",browsers:["IE10"],description:"Represents placeholder text in an input field. Note: for Edge use the pseudo-element ::-ms-input-placeholder. Standardized as ::placeholder."},{name:":-ms-keyboard-active",browsers:["IE10"],description:"Windows Store apps only. Applies one or more styles to an element when it has focus and the user presses the space bar."},{name:":-ms-lang()",browsers:["E","IE10"],description:"Represents an element that is in the language specified. Accepts a comma separated list of language tokens."},{name:":no-button",browsers:["C","S5"],description:"Non-standard. Applies to track pieces. Applies when there is no button at that end of the track."},{name:":not()",browsers:["E","C","FF1","IE9","O9.5","S2"],description:"The negation pseudo-class, :not(X), is a functional notation taking a simple selector (excluding the negation pseudo-class itself) as an argument. It represents an element that is not represented by its argument."},{name:":nth-child()",browsers:["E","C","FF3.5","IE9","O9.5","S3.1"],description:"Represents an element that has an+b-1 siblings before it in the document tree, for any positive integer or zero value of n, and has a parent element."},{name:":nth-last-child()",browsers:["E","C","FF3.5","IE9","O9.5","S3.1"],description:"Represents an element that has an+b-1 siblings after it in the document tree, for any positive integer or zero value of n, and has a parent element."},{name:":nth-last-of-type()",browsers:["E","C","FF3.5","IE9","O9.5","S3.1"],description:"Represents an element that has an+b-1 siblings with the same expanded element name after it in the document tree, for any zero or positive integer value of n, and has a parent element."},{name:":nth-of-type()",browsers:["E","C","FF3.5","IE9","O9.5","S3.1"],description:"Represents an element that has an+b-1 siblings with the same expanded element name before it in the document tree, for any zero or positive integer value of n, and has a parent element."},{name:":only-child",browsers:["E12","FF1.5","S3.1","C2","IE9","O9.5"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/:only-child"}],description:"Represents an element that has a parent element and whose parent element has no other element children. Same as :first-child:last-child or :nth-child(1):nth-last-child(1), but with a lower specificity."},{name:":only-of-type",browsers:["E12","FF3.5","S3.1","C1","IE9","O9.5"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/:only-of-type"}],description:"Matches every element that is the only child of its type, of its parent. Same as :first-of-type:last-of-type or :nth-of-type(1):nth-last-of-type(1), but with a lower specificity."},{name:":optional",browsers:["E12","FF4","S5","C10","IE10","O10"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/:optional"}],description:"A form element is :required or :optional if a value for it is, respectively, required or optional before the form it belongs to is submitted. Elements that are not form elements are neither required nor optional."},{name:":out-of-range",browsers:["E13","FF29","S5.1","C10","O11"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/:out-of-range"}],description:"Used in conjunction with the min and max attributes, whether on a range input, a number field, or any other types that accept those attributes."},{name:":past",browsers:["E79","S7","C23","O15"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/:past"}],description:"Represents any element that is defined to occur entirely prior to a :current element."},{name:":read-only",browsers:["E13","FF78","S4","C1","O9"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/:read-only"}],description:"An element whose contents are not user-alterable is :read-only. However, elements whose contents are user-alterable (such as text input fields) are considered to be in a :read-write state. In typical documents, most elements are :read-only."},{name:":read-write",browsers:["E13","FF78","S4","C1","O9"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/:read-write"}],description:"An element whose contents are not user-alterable is :read-only. However, elements whose contents are user-alterable (such as text input fields) are considered to be in a :read-write state. In typical documents, most elements are :read-only."},{name:":required",browsers:["E12","FF4","S5","C10","IE10","O10"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/:required"}],description:"A form element is :required or :optional if a value for it is, respectively, required or optional before the form it belongs to is submitted. Elements that are not form elements are neither required nor optional."},{name:":right",browsers:["E12","S5","C6","IE8","O9.2"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/:right"}],description:"When printing double-sided documents, the page boxes on left and right pages may be different. This can be expressed through CSS pseudo-classes defined in the  page context."},{name:":root",browsers:["E12","FF1","S1","C1","IE9","O9.5"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/:root"}],description:"Represents an element that is the root of the document. In HTML 4, this is always the HTML element."},{name:":scope",browsers:["E79","FF32","S7","C27","O15"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/:scope"}],description:"Represents any element that is in the contextual reference element set."},{name:":single-button",browsers:["C","S5"],description:"Non-standard. Applies to buttons and track pieces. Applies when both buttons are displayed separately at either end of the scrollbar."},{name:":start",browsers:["C","S5"],description:"Non-standard. Applies to buttons and track pieces. Indicates whether the object is placed before the thumb."},{name:":target",browsers:["E12","FF1","S1.3","C1","IE9","O9.5"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/:target"}],description:"Some URIs refer to a location within a resource. This kind of URI ends with a 'number sign' (#) followed by an anchor identifier (called the fragment identifier)."},{name:":valid",browsers:["E12","FF4","S5","C10","IE10","O10"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/:valid"}],description:"An element is :valid or :invalid when it is, respectively, valid or invalid with respect to data validity semantics defined by a different specification."},{name:":vertical",browsers:["C","S5"],description:"Non-standard. Applies to any scrollbar pieces that have a vertical orientation."},{name:":visited",browsers:["E12","FF1","S1","C1","IE4","O3.5"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/:visited"}],description:"Applies once the link has been visited by the user."},{name:":-webkit-any()",browsers:["C","S5"],description:"Represents an element that is represented by the selector list passed as its argument. Standardized as :matches()."},{name:":-webkit-full-screen",browsers:["C","S6"],description:"Matches any element that has its fullscreen flag set. Standardized as :fullscreen."},{name:":window-inactive",browsers:["C","S3"],description:"Non-standard. Applies to all scrollbar pieces. Indicates whether or not the window containing the scrollbar is currently active."},{name:":current",status:"experimental",description:"The :current CSS pseudo-class selector is a time-dimensional pseudo-class that represents the element, or an ancestor of the element, that is currently being displayed"},{name:":blank",status:"experimental",references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/:blank"}],description:"The :blank CSS pseudo-class selects empty user input elements (eg. <input> or <textarea>)."},{name:":defined",status:"experimental",browsers:["E79","FF63","S10","C54","O41"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/:defined"}],description:"The :defined CSS pseudo-class represents any element that has been defined. This includes any standard element built in to the browser, and custom elements that have been successfully defined (i.e. with the CustomElementRegistry.define() method)."},{name:":dir",browsers:["E120","FF49","S16.4","C120","O106"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/:dir"}],description:"The :dir() CSS pseudo-class matches elements based on the directionality of the text contained in them."},{name:":focus-visible",browsers:["E86","FF85","S15.4","C86","O72"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/:focus-visible"}],description:"The :focus-visible pseudo-class applies while an element matches the :focus pseudo-class and the UA determines via heuristics that the focus should be made evident on the element."},{name:":focus-within",browsers:["E79","FF52","S10.1","C60","O47"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/:focus-within"}],description:"The :focus-within pseudo-class applies to any element for which the :focus pseudo class applies as well as to an element whose descendant in the flat tree (including non-element nodes, such as text nodes) matches the conditions for matching :focus."},{name:":has",status:"experimental",browsers:["E105","FF121","S15.4","C105","O91"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/:has"}],description:":The :has() CSS pseudo-class represents an element if any of the selectors passed as parameters (relative to the :scope of the given element), match at least one element."},{name:":is",status:"experimental",browsers:["E88","FF78","S14","C88","O74"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/:is"}],description:"The :is() CSS pseudo-class function takes a selector list as its argument, and selects any element that can be selected by one of the selectors in that list. This is useful for writing large selectors in a more compact form."},{name:":local-link",status:"experimental",description:"The :local-link CSS pseudo-class represents an link to the same document"},{name:":paused",status:"experimental",browsers:["S15.4"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/:paused"}],description:"The :paused CSS pseudo-class selector is a resource state pseudo-class that will match an audio, video, or similar resource that is capable of being \u201Cplayed\u201D or \u201Cpaused\u201D, when that element is \u201Cpaused\u201D."},{name:":placeholder-shown",status:"experimental",browsers:["E79","FF51","S9","C47","IE10","O34"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/:placeholder-shown"}],description:"The :placeholder-shown CSS pseudo-class represents any <input> or <textarea> element that is currently displaying placeholder text."},{name:":playing",status:"experimental",browsers:["S15.4"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/:playing"}],description:"The :playing CSS pseudo-class selector is a resource state pseudo-class that will match an audio, video, or similar resource that is capable of being \u201Cplayed\u201D or \u201Cpaused\u201D, when that element is \u201Cplaying\u201D. "},{name:":target-within",status:"experimental",references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/:target-within"}],description:"The :target-within CSS pseudo-class represents an element that is a target element or contains an element that is a target. A target element is a unique element with an id matching the URL's fragment."},{name:":user-invalid",status:"experimental",browsers:["E119","FF88","S16.5","C119","O105"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/:user-invalid"}],description:"The :user-invalid CSS pseudo-class represents any validated form element whose value isn't valid based on their validation constraints, after the user has interacted with it."},{name:":user-valid",status:"experimental",browsers:["E119","FF88","S16.5","C119","O105"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/:user-valid"}],description:"The :user-valid CSS pseudo-class represents any validated form element whose value validates correctly based on its validation constraints. However, unlike :valid it only matches once the user has interacted with it."},{name:":where",status:"experimental",browsers:["E88","FF78","S14","C88","O74"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/:where"}],description:"The :where() CSS pseudo-class function takes a selector list as its argument, and selects any element that can be selected by one of the selectors in that list."},{name:":picture-in-picture",status:"experimental",browsers:["E110","S13.1","C110","O96"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/:picture-in-picture"}],description:"The :picture-in-picture CSS pseudo-class matches the element which is currently in picture-in-picture mode."}],pseudoElements:[{name:"::after",browsers:["E12","FF1.5","S4","C1","IE9","O7"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/::after"}],description:"Represents a styleable child pseudo-element immediately after the originating element's actual content."},{name:"::backdrop",browsers:["E79","FF47","S15.4","C37","IE11","O24"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/::backdrop"}],description:"Used to create a backdrop that hides the underlying document for an element in a top layer (such as an element that is displayed fullscreen)."},{name:"::before",browsers:["E12","FF1.5","S4","C1","IE9","O7"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/::before"}],description:"Represents a styleable child pseudo-element immediately before the originating element's actual content."},{name:"::content",browsers:["C35","O22"],description:"Deprecated. Matches the distribution list itself, on elements that have one. Use ::slotted for forward compatibility."},{name:"::cue",browsers:["E79","FF55","S7","C26","O15"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/::cue"}]},{name:"::cue()",browsers:["C","O16","S6"]},{name:"::cue-region",browsers:["C","O16","S6"]},{name:"::cue-region()",browsers:["C","O16","S6"]},{name:"::first-letter",browsers:["E12","FF1","S1","C1","IE9","O7"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/::first-letter"}],description:"Represents the first letter of an element, if it is not preceded by any other content (such as images or inline tables) on its line."},{name:"::first-line",browsers:["E12","FF1","S1","C1","IE9","O7"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/::first-line"}],description:"Describes the contents of the first formatted line of its originating element."},{name:"::-moz-focus-inner",browsers:["FF72"]},{name:"::-moz-focus-outer",browsers:["FF4"]},{name:"::-moz-list-bullet",browsers:["FF72"],description:"Used to style the bullet of a list element. Similar to the standardized ::marker."},{name:"::-moz-list-number",browsers:["FF72"],description:"Used to style the numbers of a list element. Similar to the standardized ::marker."},{name:"::-moz-placeholder",browsers:["FF19"],description:"Represents placeholder text in an input field"},{name:"::-moz-progress-bar",browsers:["FF72"],description:"Represents the bar portion of a progress bar."},{name:"::-moz-selection",browsers:["FF1"],description:"Represents the portion of a document that has been highlighted by the user."},{name:"::-ms-backdrop",browsers:["IE11"],description:"Used to create a backdrop that hides the underlying document for an element in a top layer (such as an element that is displayed fullscreen)."},{name:"::-ms-browse",browsers:["E","IE10"],description:"Represents the browse button of an input type=file control."},{name:"::-ms-check",browsers:["E","IE10"],description:"Represents the check of a checkbox or radio button input control."},{name:"::-ms-clear",browsers:["E","IE10"],description:"Represents the clear button of a text input control"},{name:"::-ms-expand",browsers:["E","IE10"],description:"Represents the drop-down button of a select control."},{name:"::-ms-fill",browsers:["E","IE10"],description:"Represents the bar portion of a progress bar."},{name:"::-ms-fill-lower",browsers:["E","IE10"],description:"Represents the portion of the slider track from its smallest value up to the value currently selected by the thumb. In a left-to-right layout, this is the portion of the slider track to the left of the thumb."},{name:"::-ms-fill-upper",browsers:["E","IE10"],description:"Represents the portion of the slider track from the value currently selected by the thumb up to the slider's largest value. In a left-to-right layout, this is the portion of the slider track to the right of the thumb."},{name:"::-ms-reveal",browsers:["E","IE10"],description:"Represents the password reveal button of an input type=password control."},{name:"::-ms-thumb",browsers:["E","IE10"],description:"Represents the portion of range input control (also known as a slider control) that the user drags."},{name:"::-ms-ticks-after",browsers:["E","IE10"],description:"Represents the tick marks of a slider that begin just after the thumb and continue up to the slider's largest value. In a left-to-right layout, these are the ticks to the right of the thumb."},{name:"::-ms-ticks-before",browsers:["E","IE10"],description:"Represents the tick marks of a slider that represent its smallest values up to the value currently selected by the thumb. In a left-to-right layout, these are the ticks to the left of the thumb."},{name:"::-ms-tooltip",browsers:["E","IE10"],description:"Represents the tooltip of a slider (input type=range)."},{name:"::-ms-track",browsers:["E","IE10"],description:"Represents the track of a slider."},{name:"::-ms-value",browsers:["E","IE10"],description:"Represents the content of a text or password input control, or a select control."},{name:"::selection",browsers:["E12","FF62","S1.1","C1","IE9","O9.5"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/::selection"}],description:"Represents the portion of a document that has been highlighted by the user."},{name:"::shadow",browsers:["C35","O22"],description:"Matches the shadow root if an element has a shadow tree."},{name:"::-webkit-file-upload-button",browsers:["C","O","S6"]},{name:"::-webkit-inner-spin-button",browsers:["E79","S5","C6","O15"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/::-webkit-inner-spin-button"}]},{name:"::-webkit-input-placeholder",browsers:["C","S4"]},{name:"::-webkit-keygen-select",browsers:["C","O","S6"]},{name:"::-webkit-meter-bar",browsers:["E79","S5.1","C12","O15"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/::-webkit-meter-bar"}]},{name:"::-webkit-meter-even-less-good-value",browsers:["E79","S5.1","C12","O15"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/::-webkit-meter-even-less-good-value"}]},{name:"::-webkit-meter-optimum-value",browsers:["E79","S5.1","C12","O15"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/::-webkit-meter-optimum-value"}]},{name:"::-webkit-meter-suboptimum-value",browsers:["E79","S5.1","C12","O15"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/::-webkit-meter-suboptimum-value"}]},{name:"::-webkit-outer-spin-button",browsers:["C","O","S6"]},{name:"::-webkit-progress-bar",browsers:["E79","S7","C25","O15"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/::-webkit-progress-bar"}]},{name:"::-webkit-progress-inner-element",browsers:["E79","S7","C23","O15"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/::-webkit-progress-inner-element"}]},{name:"::-webkit-progress-value",browsers:["E79","S7","C25","O15"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/::-webkit-progress-value"}]},{name:"::-webkit-resizer",browsers:["E79","S4","C2","O15"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/::-webkit-scrollbar"}]},{name:"::-webkit-scrollbar",browsers:["E79","S4","C2","O15"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/::-webkit-scrollbar"}]},{name:"::-webkit-scrollbar-button",browsers:["E79","S4","C2","O15"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/::-webkit-scrollbar"}]},{name:"::-webkit-scrollbar-corner",browsers:["E79","S4","C2","O15"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/::-webkit-scrollbar"}]},{name:"::-webkit-scrollbar-thumb",browsers:["E79","S4","C2","O15"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/::-webkit-scrollbar"}]},{name:"::-webkit-scrollbar-track",browsers:["E79","S4","C2","O15"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/::-webkit-scrollbar"}]},{name:"::-webkit-scrollbar-track-piece",browsers:["E79","S4","C2","O15"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/::-webkit-scrollbar"}]},{name:"::-webkit-search-cancel-button",browsers:["E79","S3","C1","O15"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/::-webkit-search-cancel-button"}]},{name:"::-webkit-search-decoration",browsers:["C","S4"]},{name:"::-webkit-search-results-button",browsers:["E79","S3","C1","O15"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/::-webkit-search-results-button"}]},{name:"::-webkit-search-results-decoration",browsers:["C","S4"]},{name:"::-webkit-slider-runnable-track",browsers:["E83","C83","O69"]},{name:"::-webkit-slider-thumb",browsers:["E83","C83","O69"]},{name:"::-webkit-textfield-decoration-container",browsers:["C","O","S6"]},{name:"::-webkit-validation-bubble",browsers:["C","O","S6"]},{name:"::-webkit-validation-bubble-arrow",browsers:["C","O","S6"]},{name:"::-webkit-validation-bubble-arrow-clipper",browsers:["C","O","S6"]},{name:"::-webkit-validation-bubble-heading",browsers:["C","O","S6"]},{name:"::-webkit-validation-bubble-message",browsers:["C","O","S6"]},{name:"::-webkit-validation-bubble-text-block",browsers:["C","O","S6"]},{name:"::target-text",status:"experimental",browsers:["E89","C89","O75"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/::target-text"}],description:"The ::target-text CSS pseudo-element represents the text that has been scrolled to if the browser supports scroll-to-text fragments. It allows authors to choose how to highlight that section of text."},{name:"::-moz-range-progress",status:"nonstandard",browsers:["FF22"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/::-moz-range-progress"}],description:'The ::-moz-range-progress CSS pseudo-element is a Mozilla extension that represents the lower portion of the track (i.e., groove) in which the indicator slides in an <input> of type="range". This portion corresponds to values lower than the value currently selected by the thumb (i.e., virtual knob).'},{name:"::-moz-range-thumb",status:"nonstandard",browsers:["FF21"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/::-moz-range-thumb"}],description:`The ::-moz-range-thumb CSS pseudo-element is a Mozilla extension that represents the thumb (i.e., virtual knob) of an <input> of type="range". The user can move the thumb along the input's track to alter its numerical value.`},{name:"::-moz-range-track",status:"nonstandard",browsers:["FF21"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/::-moz-range-track"}],description:'The ::-moz-range-track CSS pseudo-element is a Mozilla extension that represents the track (i.e., groove) in which the indicator slides in an <input> of type="range".'},{name:"::-webkit-progress-inner-value",status:"nonstandard",description:`The ::-webkit-progress-value CSS pseudo-element represents the filled-in portion of the bar of a <progress> element. It is a child of the ::-webkit-progress-bar pseudo-element.

In order to let ::-webkit-progress-value take effect, -webkit-appearance needs to be set to none on the <progress> element.`},{name:"::grammar-error",status:"experimental",browsers:["E121","Spreview","C121"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/::grammar-error"}],description:"The ::grammar-error CSS pseudo-element represents a text segment which the user agent has flagged as grammatically incorrect."},{name:"::marker",browsers:["E86","FF68","S11.1","C86","O72"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/::marker"}],description:"The ::marker CSS pseudo-element selects the marker box of a list item, which typically contains a bullet or number. It works on any element or pseudo-element set to display: list-item, such as the <li> and <summary> elements."},{name:"::part",status:"experimental",browsers:["E79","FF72","S13.1","C73","O60"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/::part"}],description:"The ::part CSS pseudo-element represents any element within a shadow tree that has a matching part attribute."},{name:"::placeholder",browsers:["E79","FF51","S10.1","C57","O44"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/::placeholder"}],description:"The ::placeholder CSS pseudo-element represents the placeholder text of a form element."},{name:"::slotted",browsers:["E79","FF63","S10","C50","O37"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/::slotted"}],description:"The :slotted() CSS pseudo-element represents any element that has been placed into a slot inside an HTML template."},{name:"::spelling-error",status:"experimental",browsers:["E121","Spreview","C121"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/::spelling-error"}],description:"The ::spelling-error CSS pseudo-element represents a text segment which the user agent has flagged as incorrectly spelled."},{name:"::view-transition",status:"experimental",browsers:["E109","C109","O95"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/::view-transition"}],description:"The ::view-transition CSS pseudo-element represents the root of the view transitions overlay, which contains all view transitions and sits over the top of all other page content."},{name:"::view-transition-group",status:"experimental",browsers:["E109","C109","O95"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/::view-transition-group"}],description:"The ::view-transition-group CSS pseudo-element represents a single view transition group."},{name:"::view-transition-image-pair",status:"experimental",browsers:["E109","C109","O95"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/::view-transition-image-pair"}],description:`The ::view-transition-image-pair CSS pseudo-element represents a container for a view transition's "old" and "new" view states \u2014 before and after the transition.`},{name:"::view-transition-new",status:"experimental",browsers:["E109","C109","O95"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/::view-transition-new"}],description:'The ::view-transition-new CSS pseudo-element represents the "new" view state of a view transition \u2014 a live representation of the new view, after the transition.'},{name:"::view-transition-old",status:"experimental",browsers:["E109","C109","O95"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/::view-transition-old"}],description:'The ::view-transition-old CSS pseudo-element represents the "old" view state of a view transition \u2014 a static screenshot of the old view, before the transition.'}]};var Ot=class{constructor(e){this._properties=[],this._atDirectives=[],this._pseudoClasses=[],this._pseudoElements=[],this.addData(e)}provideProperties(){return this._properties}provideAtDirectives(){return this._atDirectives}providePseudoClasses(){return this._pseudoClasses}providePseudoElements(){return this._pseudoElements}addData(e){if(Array.isArray(e.properties))for(let t of e.properties)Ja(t)&&this._properties.push(t);if(Array.isArray(e.atDirectives))for(let t of e.atDirectives)Xa(t)&&this._atDirectives.push(t);if(Array.isArray(e.pseudoClasses))for(let t of e.pseudoClasses)Ya(t)&&this._pseudoClasses.push(t);if(Array.isArray(e.pseudoElements))for(let t of e.pseudoElements)Qa(t)&&this._pseudoElements.push(t)}};function Ja(n){return typeof n.name=="string"}function Xa(n){return typeof n.name=="string"}function Ya(n){return typeof n.name=="string"}function Qa(n){return typeof n.name=="string"}var Pt=class{constructor(e){this.dataProviders=[],this._propertySet={},this._atDirectiveSet={},this._pseudoClassSet={},this._pseudoElementSet={},this._properties=[],this._atDirectives=[],this._pseudoClasses=[],this._pseudoElements=[],this.setDataProviders(e?.useDefaultDataProvider!==!1,e?.customDataProviders||[])}setDataProviders(e,t){this.dataProviders=[],e&&this.dataProviders.push(new Ot(Mi)),this.dataProviders.push(...t),this.collectData()}collectData(){this._propertySet={},this._atDirectiveSet={},this._pseudoClassSet={},this._pseudoElementSet={},this.dataProviders.forEach(e=>{e.provideProperties().forEach(t=>{this._propertySet[t.name]||(this._propertySet[t.name]=t)}),e.provideAtDirectives().forEach(t=>{this._atDirectiveSet[t.name]||(this._atDirectiveSet[t.name]=t)}),e.providePseudoClasses().forEach(t=>{this._pseudoClassSet[t.name]||(this._pseudoClassSet[t.name]=t)}),e.providePseudoElements().forEach(t=>{this._pseudoElementSet[t.name]||(this._pseudoElementSet[t.name]=t)})}),this._properties=Yt(this._propertySet),this._atDirectives=Yt(this._atDirectiveSet),this._pseudoClasses=Yt(this._pseudoClassSet),this._pseudoElements=Yt(this._pseudoElementSet)}getProperty(e){return this._propertySet[e]}getAtDirective(e){return this._atDirectiveSet[e]}getPseudoClass(e){return this._pseudoClassSet[e]}getPseudoElement(e){return this._pseudoElementSet[e]}getProperties(){return this._properties}getAtDirectives(){return this._atDirectives}getPseudoClasses(){return this._pseudoClasses}getPseudoElements(){return this._pseudoElements}isKnownProperty(e){return e.toLowerCase()in this._propertySet}isStandardProperty(e){return this.isKnownProperty(e)&&(!this._propertySet[e.toLowerCase()].status||this._propertySet[e.toLowerCase()].status==="standard")}};function bo(n,e,t){function r(s){let a=i(s),l;for(let o=a.length-1;o>=0;o--)l=kt.create(R.create(n.positionAt(a[o][0]),n.positionAt(a[o][1])),l);return l||(l=kt.create(R.create(s,s))),l}return e.map(r);function i(s){let a=n.offsetAt(s),l=t.findChildAtOffset(a,!0);if(!l)return[];let o=[];for(;l;){if(l.parent&&l.offset===l.parent.offset&&l.end===l.parent.end){l=l.parent;continue}l.type===m.Declarations&&a>l.offset&&a<l.end&&o.push([l.offset+1,l.end-1]),o.push([l.offset,l.end]),l=l.parent}return o}}var kr=class extends lt{constructor(e){super(e,!0)}isRawStringDocumentLinkNode(e){return super.isRawStringDocumentLinkNode(e)||e.type===m.Use||e.type===m.Forward}async mapReference(e,t){if(this.fileSystemProvider&&e&&t){let r=Za(e);for(let i of r)if(await this.fileExists(i))return i}return e}async resolveReference(e,t,r,i=!1){if(!V(e,"sass:"))return super.resolveReference(e,t,r,i)}};function Za(n){if(n.endsWith(".css"))return[n];if(n.endsWith("/"))return[n+"index.scss",n+"_index.scss"];let e=Zt.parse(n.replace(/\.scss$/,"")),t=Fe.basename(e),r=Fe.dirname(e);return t.startsWith("_")?[Fe.joinPath(r,t+".scss").toString(!0)]:[Fe.joinPath(r,t+".scss").toString(!0),Fe.joinPath(r,"_"+t+".scss").toString(!0),n+"/index.scss",n+"/_index.scss",Fe.joinPath(r,t+".css").toString(!0)]}function wo(n){return new Ot(n)}function Ti(n,e,t,r,i,s,a){return{configure:l=>{s.configure(l),e.configure(l?.completion),t.configure(l?.hover),r.configure(l?.importAliases)},setDataProviders:a.setDataProviders.bind(a),doValidation:s.doValidation.bind(s),parseStylesheet:n.parseStylesheet.bind(n),doComplete:e.doComplete.bind(e),doComplete2:e.doComplete2.bind(e),setCompletionParticipants:e.setCompletionParticipants.bind(e),doHover:t.doHover.bind(t),format:go,findDefinition:r.findDefinition.bind(r),findReferences:r.findReferences.bind(r),findDocumentHighlights:r.findDocumentHighlights.bind(r),findDocumentLinks:r.findDocumentLinks.bind(r),findDocumentLinks2:r.findDocumentLinks2.bind(r),findDocumentSymbols:r.findSymbolInformations.bind(r),findDocumentSymbols2:r.findDocumentSymbols.bind(r),doCodeActions:i.doCodeActions.bind(i),doCodeActions2:i.doCodeActions2.bind(i),findDocumentColors:r.findDocumentColors.bind(r),getColorPresentations:r.getColorPresentations.bind(r),prepareRename:r.prepareRename.bind(r),doRename:r.doRename.bind(r),getFoldingRanges:co,getSelectionRanges:bo}}var Ni={};function vo(n=Ni){let e=new Pt(n);return Ti(new ke,new Xe(null,n,e),new _t(n&&n.clientCapabilities,e),new lt(n&&n.fileSystemProvider,!1),new Dt(e),new Rt(e),e)}function yo(n=Ni){let e=new Pt(n);return Ti(new xr,new we(n,e),new _t(n&&n.clientCapabilities,e),new kr(n&&n.fileSystemProvider),new Dt(e),new Rt(e),e)}function xo(n=Ni){let e=new Pt(n);return Ti(new Cr,new Nt(n,e),new _t(n&&n.clientCapabilities,e),new lt(n&&n.fileSystemProvider,!0),new Dt(e),new Rt(e),e)}var Fr=class{constructor(e,t){this._ctx=e,this._languageSettings=t.options,this._languageId=t.languageId;let r=t.options.data,i=r?.useDefaultDataProvider,s=[];if(r?.dataProviders)for(let l in r.dataProviders)s.push(wo(r.dataProviders[l]));let a={customDataProviders:s,useDefaultDataProvider:i};switch(this._languageId){case"css":this._languageService=vo(a);break;case"less":this._languageService=xo(a);break;case"scss":this._languageService=yo(a);break;default:throw new Error("Invalid language id: "+this._languageId)}this._languageService.configure(this._languageSettings)}async doValidation(e){let t=this._getTextDocument(e);if(t){let r=this._languageService.parseStylesheet(t),i=this._languageService.doValidation(t,r);return Promise.resolve(i)}return Promise.resolve([])}async doComplete(e,t){let r=this._getTextDocument(e);if(!r)return null;let i=this._languageService.parseStylesheet(r),s=this._languageService.doComplete(r,t,i);return Promise.resolve(s)}async doHover(e,t){let r=this._getTextDocument(e);if(!r)return null;let i=this._languageService.parseStylesheet(r),s=this._languageService.doHover(r,t,i);return Promise.resolve(s)}async findDefinition(e,t){let r=this._getTextDocument(e);if(!r)return null;let i=this._languageService.parseStylesheet(r),s=this._languageService.findDefinition(r,t,i);return Promise.resolve(s)}async findReferences(e,t){let r=this._getTextDocument(e);if(!r)return[];let i=this._languageService.parseStylesheet(r),s=this._languageService.findReferences(r,t,i);return Promise.resolve(s)}async findDocumentHighlights(e,t){let r=this._getTextDocument(e);if(!r)return[];let i=this._languageService.parseStylesheet(r),s=this._languageService.findDocumentHighlights(r,t,i);return Promise.resolve(s)}async findDocumentSymbols(e){let t=this._getTextDocument(e);if(!t)return[];let r=this._languageService.parseStylesheet(t),i=this._languageService.findDocumentSymbols(t,r);return Promise.resolve(i)}async doCodeActions(e,t,r){let i=this._getTextDocument(e);if(!i)return[];let s=this._languageService.parseStylesheet(i),a=this._languageService.doCodeActions(i,t,r,s);return Promise.resolve(a)}async findDocumentColors(e){let t=this._getTextDocument(e);if(!t)return[];let r=this._languageService.parseStylesheet(t),i=this._languageService.findDocumentColors(t,r);return Promise.resolve(i)}async getColorPresentations(e,t,r){let i=this._getTextDocument(e);if(!i)return[];let s=this._languageService.parseStylesheet(i),a=this._languageService.getColorPresentations(i,s,t,r);return Promise.resolve(a)}async getFoldingRanges(e,t){let r=this._getTextDocument(e);if(!r)return[];let i=this._languageService.getFoldingRanges(r,t);return Promise.resolve(i)}async getSelectionRanges(e,t){let r=this._getTextDocument(e);if(!r)return[];let i=this._languageService.parseStylesheet(r),s=this._languageService.getSelectionRanges(r,t,i);return Promise.resolve(s)}async doRename(e,t,r){let i=this._getTextDocument(e);if(!i)return null;let s=this._languageService.parseStylesheet(i),a=this._languageService.doRename(i,t,r,s);return Promise.resolve(a)}async format(e,t,r){let i=this._getTextDocument(e);if(!i)return[];let s={...this._languageSettings.format,...r},a=this._languageService.format(i,t,s);return Promise.resolve(a)}_getTextDocument(e){let t=this._ctx.getMirrorModels();for(let r of t)if(r.uri.toString()===e)return Jt.create(e,this._languageId,r.version,r.getValue());return null}};function tl(n,e){return new Fr(n,e)}return Ro(nl);})();
return moduleExports;
});
