"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.createInstallInfoFile = exports.getWindowsCompliantVersion = void 0;
const fs = require("fs-extra");
const semver = require("semver");
const fs_helper_1 = require("./fs-helper");
function isWindowsCompliant(version) {
    const versionArray = version.split(".");
    if (versionArray.length !== 4) {
        return false;
    }
    for (let i = 0; i < 4; i++) {
        if (isNaN(Number(versionArray[i]))) {
            return false;
        }
    }
    return true;
}
function getBuildNumber(version) {
    let ret = "0";
    if (version) {
        if (version.build) {
            for (const build of version.build) {
                const buildNum = Number(build);
                if (!isNaN(buildNum) && Number.isInteger(buildNum)) {
                    ret = build;
                    break;
                }
            }
        }
    }
    return ret;
}
function getWindowsCompliantVersion(input) {
    const winVer = input.replace("+", ".");
    if (isWindowsCompliant(winVer)) {
        return winVer;
    }
    const parsed = semver.parse(input);
    if (parsed) {
        const build = getBuildNumber(parsed);
        return `${parsed.major}.${parsed.minor}.${parsed.patch}.${build}`;
    }
    else {
        throw new Error("Could not parse semantic version input string");
    }
}
exports.getWindowsCompliantVersion = getWindowsCompliantVersion;
function createInstallInfoFile(manufacturer, appName, productCode, installVersion, arch) {
    const { tempFilePath } = (0, fs_helper_1.getTempFilePath)(".installInfo", "json");
    fs.writeJSONSync(tempFilePath, {
        manufacturer,
        appName,
        productCode,
        arch,
        installVersion,
    });
    return tempFilePath;
}
exports.createInstallInfoFile = createInstallInfoFile;
//# sourceMappingURL=version-util.js.map