"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LOCALES_DIR = exports.CURRENT_LOCALES = void 0;
var fs = _interopRequireWildcard(require("fs"));
var path = _interopRequireWildcard(require("path"));
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright 2025 The Kubernetes Authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

// Get the path to the frontend locales directory
let frontendLocalesPath;
const isDev = process.env.ELECTRON_DEV || false;
// Check if we're running in a normal Node.js process (for i18next-parser)
// or in an Electron environment
const isRunningInNode = !process.resourcesPath;
if (isDev || isRunningInNode) {
  // When running as a normal Node.js process (i18next parser) or in dev mode
  frontendLocalesPath = path.resolve(__dirname, '../../frontend/src/i18n/locales');
} else {
  // When running in Electron production mode
  frontendLocalesPath = path.join(process.resourcesPath, 'frontend/i18n/locales');
}

// Read available locales from the frontend locales directory
const currentLocales = [];
if (fs.existsSync(frontendLocalesPath)) {
  fs.readdirSync(frontendLocalesPath).forEach(file => {
    // Only include directories, not files
    if (fs.statSync(path.join(frontendLocalesPath, file)).isDirectory()) {
      currentLocales.push(file);
    }
  });
}

// If no locales found, default to English
const CURRENT_LOCALES = exports.CURRENT_LOCALES = currentLocales.length > 0 ? currentLocales : ['en'];
const LOCALES_DIR = exports.LOCALES_DIR = frontendLocalesPath;