/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.s3a;

import java.util.Collection;
import java.util.Locale;
import javax.annotation.Nullable;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public enum S3AInputPolicy {
    Normal("default", false, true),
    Random("random", true, false),
    Sequential("sequential", false, false);

    private final String policy;
    private final boolean randomIO;
    private final boolean adaptive;

    private S3AInputPolicy(String policy, boolean randomIO, boolean adaptive) {
        this.policy = policy;
        this.randomIO = randomIO;
        this.adaptive = adaptive;
    }

    public String toString() {
        return this.policy;
    }

    String getPolicy() {
        return this.policy;
    }

    boolean isRandomIO() {
        return this.randomIO;
    }

    boolean isAdaptive() {
        return this.adaptive;
    }

    public static S3AInputPolicy getPolicy(String name, @Nullable S3AInputPolicy defaultPolicy) {
        String trimmed;
        switch (trimmed = name.trim().toLowerCase(Locale.ENGLISH)) {
            case "adaptive": 
            case "default": 
            case "normal": {
                return Normal;
            }
            case "hbase": 
            case "random": 
            case "vector": {
                return Random;
            }
            case "columnar": 
            case "orc": 
            case "parquet": {
                return Random;
            }
            case "avro": 
            case "csv": 
            case "json": 
            case "sequential": 
            case "whole-file": {
                return Sequential;
            }
        }
        return defaultPolicy;
    }

    public static S3AInputPolicy getFirstSupportedPolicy(Collection<String> policies, @Nullable S3AInputPolicy defaultPolicy) {
        for (String s : policies) {
            S3AInputPolicy nextPolicy = S3AInputPolicy.getPolicy(s, null);
            if (nextPolicy == null) continue;
            return nextPolicy;
        }
        return defaultPolicy;
    }
}

