/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.timelineservice.storage.apptoflow;

import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.yarn.server.timelineservice.storage.apptoflow.AppToFlowColumnFamily;
import org.apache.hadoop.yarn.server.timelineservice.storage.apptoflow.AppToFlowTable;
import org.apache.hadoop.yarn.server.timelineservice.storage.common.Column;
import org.apache.hadoop.yarn.server.timelineservice.storage.common.ColumnFamily;
import org.apache.hadoop.yarn.server.timelineservice.storage.common.GenericConverter;
import org.apache.hadoop.yarn.server.timelineservice.storage.common.Separator;
import org.apache.hadoop.yarn.server.timelineservice.storage.common.ValueConverter;
import org.apache.hadoop.yarn.server.timelineservice.storage.flow.Attribute;

public enum AppToFlowColumn implements Column<AppToFlowTable>
{
    FLOW_ID(AppToFlowColumnFamily.MAPPING, "flow_id"),
    FLOW_RUN_ID(AppToFlowColumnFamily.MAPPING, "flow_run_id"),
    USER_ID(AppToFlowColumnFamily.MAPPING, "user_id");

    private final ColumnFamily<AppToFlowTable> columnFamily;
    private final String columnQualifier;
    private final byte[] columnQualifierBytes;
    private final ValueConverter valueConverter;

    private AppToFlowColumn(ColumnFamily<AppToFlowTable> columnFamily, String columnQualifier) {
        this.columnFamily = columnFamily;
        this.columnQualifier = columnQualifier;
        this.columnQualifierBytes = Bytes.toBytes((String)Separator.SPACE.encode(columnQualifier));
        this.valueConverter = GenericConverter.getInstance();
    }

    private String getColumnQualifier() {
        return this.columnQualifier;
    }

    @Override
    public byte[] getColumnQualifierBytes() {
        return (byte[])this.columnQualifierBytes.clone();
    }

    @Override
    public byte[] getColumnFamilyBytes() {
        return this.columnFamily.getBytes();
    }

    @Override
    public ValueConverter getValueConverter() {
        return this.valueConverter;
    }

    @Override
    public Attribute[] getCombinedAttrsWithAggr(Attribute ... attributes) {
        return attributes;
    }

    @Override
    public boolean supplementCellTimestamp() {
        return false;
    }
}

