/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.federation.metrics;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.server.federation.MiniRouterDFSCluster;
import org.apache.hadoop.hdfs.server.federation.MockResolver;
import org.apache.hadoop.hdfs.server.federation.RouterConfigBuilder;
import org.apache.hadoop.hdfs.server.federation.router.Router;
import org.apache.hadoop.metrics2.MetricsRecordBuilder;
import org.apache.hadoop.test.MetricsAsserts;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestNameserviceRPCMetrics {
    private static final Configuration CONF = new HdfsConfiguration();
    private static final int NUM_SUBCLUSTERS = 2;
    private static final int NUM_DNS = 3;
    private static MiniRouterDFSCluster cluster;
    private MiniRouterDFSCluster.RouterContext routerContext;
    private Router router;
    private FileSystem routerFS;
    private FileSystem nnFS;

    @BeforeClass
    public static void globalSetUp() throws Exception {
        cluster = new MiniRouterDFSCluster(false, 2);
        cluster.setNumDatanodesPerNameservice(3);
        cluster.startCluster();
        Configuration routerConf = new RouterConfigBuilder().metrics().rpc().quota().build();
        cluster.addRouterOverrides(routerConf);
        cluster.startRouters();
        cluster.registerNamenodes();
        cluster.waitNamenodeRegistration();
    }

    @Before
    public void testSetup() throws Exception {
        cluster.installMockLocations();
        cluster.deleteAllFiles();
        cluster.createTestDirectoriesNamenode();
        Thread.sleep(100L);
        this.routerContext = cluster.getRouters().get(0);
        this.routerFS = this.routerContext.getFileSystem();
        this.router = this.routerContext.getRouter();
        MockResolver resolver = (MockResolver)this.router.getSubclusterResolver();
        resolver.addLocation("/target-ns0", cluster.getNameservices().get(0), "/target-ns0");
        resolver.addLocation("/target-ns1", cluster.getNameservices().get(1), "/target-ns1");
    }

    @AfterClass
    public static void tearDown() throws Exception {
        cluster.shutdown();
    }

    @Test
    public void testProxyOp() throws IOException {
        this.routerFS.listStatus(new Path("/target-ns0"));
        MetricsAsserts.assertCounter((String)"ProxyOp", (long)1L, (MetricsRecordBuilder)MetricsAsserts.getMetrics((String)"NameserviceActivity-ns0"));
        MetricsAsserts.assertCounter((String)"ProxyOp", (long)0L, (MetricsRecordBuilder)MetricsAsserts.getMetrics((String)"NameserviceActivity-ns1"));
        this.routerFS.listStatus(new Path("/target-ns1"));
        MetricsAsserts.assertCounter((String)"ProxyOp", (long)1L, (MetricsRecordBuilder)MetricsAsserts.getMetrics((String)"NameserviceActivity-ns0"));
        MetricsAsserts.assertCounter((String)"ProxyOp", (long)1L, (MetricsRecordBuilder)MetricsAsserts.getMetrics((String)"NameserviceActivity-ns1"));
    }

    @Test
    public void testProxyOpCompleteConcurrent() throws IOException {
        long ns0ProxyOpBefore = MetricsAsserts.getLongCounter((String)"ProxyOp", (MetricsRecordBuilder)MetricsAsserts.getMetrics((String)"NameserviceActivity-ns0"));
        long ns1ProxyOpBefore = MetricsAsserts.getLongCounter((String)"ProxyOp", (MetricsRecordBuilder)MetricsAsserts.getMetrics((String)"NameserviceActivity-ns1"));
        long concurrentProxyOpBefore = MetricsAsserts.getLongCounter((String)"ProxyOp", (MetricsRecordBuilder)MetricsAsserts.getMetrics((String)"NameserviceActivity-concurrent"));
        this.router.getRpcServer().setBalancerBandwidth(0x100000L);
        MetricsAsserts.assertCounter((String)"ProxyOp", (long)(ns0ProxyOpBefore + 1L), (MetricsRecordBuilder)MetricsAsserts.getMetrics((String)"NameserviceActivity-ns0"));
        MetricsAsserts.assertCounter((String)"ProxyOp", (long)(ns1ProxyOpBefore + 1L), (MetricsRecordBuilder)MetricsAsserts.getMetrics((String)"NameserviceActivity-ns1"));
        MetricsAsserts.assertCounter((String)"ProxyOp", (long)(concurrentProxyOpBefore + 1L), (MetricsRecordBuilder)MetricsAsserts.getMetrics((String)"NameserviceActivity-concurrent"));
    }

    static {
        CONF.setLong("dfs.blocksize", 100L);
        CONF.setInt("dfs.bytes-per-checksum", 1);
        CONF.setLong("dfs.heartbeat.interval", 1L);
        CONF.setInt("dfs.namenode.redundancy.interval.seconds", 1);
    }
}

