/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.oss.crypto;

import com.aliyun.oss.ClientException;
import com.aliyun.oss.common.auth.Credentials;
import com.aliyun.oss.common.auth.CredentialsProvider;
import com.aliyun.oss.common.utils.BinaryUtil;
import com.aliyun.oss.crypto.ContentCryptoMaterialRW;
import com.aliyun.oss.crypto.EncryptionMaterials;
import com.aliyuncs.AcsRequest;
import com.aliyuncs.DefaultAcsClient;
import com.aliyuncs.http.FormatType;
import com.aliyuncs.http.MethodType;
import com.aliyuncs.http.ProtocolType;
import com.aliyuncs.kms.model.v20160120.DecryptRequest;
import com.aliyuncs.kms.model.v20160120.DecryptResponse;
import com.aliyuncs.kms.model.v20160120.EncryptRequest;
import com.aliyuncs.kms.model.v20160120.EncryptResponse;
import com.aliyuncs.profile.DefaultProfile;
import com.aliyuncs.profile.IClientProfile;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;

public class KmsEncryptionMaterials
implements EncryptionMaterials {
    private static final String KEY_WRAP_ALGORITHM = "KMS/ALICLOUD";
    private String region;
    private String cmk;
    CredentialsProvider credentialsProvider;
    private final Map<String, String> desc;
    private final LinkedHashMap<KmsClientSuite, Map<String, String>> kmsDescMaterials = new LinkedHashMap();

    public KmsEncryptionMaterials(String region, String cmk) {
        this.assertParameterNotNull(region, "kms region");
        this.assertParameterNotNull(region, "kms cmk");
        this.region = region;
        this.cmk = cmk;
        this.desc = new HashMap<String, String>();
    }

    public KmsEncryptionMaterials(String region, String cmk, Map<String, String> desc) {
        this.assertParameterNotNull(region, "kms region");
        this.assertParameterNotNull(region, "kms cmk");
        this.region = region;
        this.cmk = cmk;
        this.desc = desc == null ? new HashMap<String, String>() : new HashMap<String, String>(desc);
    }

    public void setKmsCredentialsProvider(CredentialsProvider credentialsProvider) {
        this.credentialsProvider = credentialsProvider;
        this.kmsDescMaterials.put(new KmsClientSuite(this.region, credentialsProvider), this.desc);
    }

    private DefaultAcsClient createKmsClient(String region, CredentialsProvider credentialsPorvider) {
        Credentials credentials = credentialsPorvider.getCredentials();
        DefaultProfile profile = DefaultProfile.getProfile((String)region, (String)credentials.getAccessKeyId(), (String)credentials.getSecretAccessKey(), (String)credentials.getSecurityToken());
        return new DefaultAcsClient((IClientProfile)profile);
    }

    private EncryptResponse encryptPlainText(String keyId, String plainText) throws ClientException {
        EncryptResponse encResponse;
        DefaultAcsClient kmsClient = this.createKmsClient(this.region, this.credentialsProvider);
        EncryptRequest encReq = new EncryptRequest();
        encReq.setSysProtocol(ProtocolType.HTTPS);
        encReq.setAcceptFormat(FormatType.JSON);
        encReq.setSysMethod(MethodType.POST);
        encReq.setKeyId(keyId);
        encReq.setPlaintext(plainText);
        try {
            encResponse = (EncryptResponse)kmsClient.getAcsResponse((AcsRequest)encReq);
        }
        catch (Exception e) {
            throw new ClientException("the kms client encrypt data failed." + e.getMessage(), e);
        }
        return encResponse;
    }

    private DecryptResponse decryptCipherBlob(KmsClientSuite kmsClientSuite, String cipherBlob) throws ClientException {
        DecryptResponse decResponse;
        DefaultAcsClient kmsClient = this.createKmsClient(kmsClientSuite.region, kmsClientSuite.credentialsProvider);
        DecryptRequest decReq = new DecryptRequest();
        decReq.setSysProtocol(ProtocolType.HTTPS);
        decReq.setAcceptFormat(FormatType.JSON);
        decReq.setSysMethod(MethodType.POST);
        decReq.setCiphertextBlob(cipherBlob);
        try {
            decResponse = (DecryptResponse)kmsClient.getAcsResponse((AcsRequest)decReq);
        }
        catch (Exception e) {
            throw new ClientException("The kms client decrypt data faild." + e.getMessage(), e);
        }
        return decResponse;
    }

    public void addKmsDescMaterial(String region, Map<String, String> description) {
        this.addKmsDescMaterial(region, this.credentialsProvider, description);
    }

    public synchronized void addKmsDescMaterial(String region, CredentialsProvider credentialsProvider, Map<String, String> description) {
        this.assertParameterNotNull(region, "region");
        this.assertParameterNotNull(credentialsProvider, "credentialsProvider");
        KmsClientSuite kmsClientSuite = new KmsClientSuite(region, credentialsProvider);
        if (description != null) {
            this.kmsDescMaterials.put(kmsClientSuite, new HashMap<String, String>(description));
        } else {
            this.kmsDescMaterials.put(kmsClientSuite, new HashMap());
        }
    }

    private KmsClientSuite findKmsClientSuiteByDescription(Map<String, String> desc) {
        if (desc == null) {
            return null;
        }
        for (Map.Entry<KmsClientSuite, Map<String, String>> entry : this.kmsDescMaterials.entrySet()) {
            if (!desc.equals(entry.getValue())) continue;
            return entry.getKey();
        }
        return null;
    }

    private <K, V> Map.Entry<K, V> getTailByReflection(LinkedHashMap<K, V> map) throws NoSuchFieldException, IllegalAccessException {
        Field tail = map.getClass().getDeclaredField("tail");
        tail.setAccessible(true);
        return (Map.Entry)tail.get(map);
    }

    @Override
    public void encryptCEK(ContentCryptoMaterialRW contentMaterialRW) {
        try {
            this.assertParameterNotNull(contentMaterialRW, "contentMaterialRW");
            this.assertParameterNotNull(contentMaterialRW.getIV(), "contentMaterialRW#getIV");
            this.assertParameterNotNull(contentMaterialRW.getCEK(), "contentMaterialRW#getCEK");
            byte[] iv = contentMaterialRW.getIV();
            EncryptResponse encryptresponse = this.encryptPlainText(this.cmk, BinaryUtil.toBase64String(iv));
            byte[] encryptedIV = BinaryUtil.fromBase64String(encryptresponse.getCiphertextBlob());
            SecretKey cek = contentMaterialRW.getCEK();
            encryptresponse = this.encryptPlainText(this.cmk, BinaryUtil.toBase64String(cek.getEncoded()));
            byte[] encryptedCEK = BinaryUtil.fromBase64String(encryptresponse.getCiphertextBlob());
            contentMaterialRW.setEncryptedCEK(encryptedCEK);
            contentMaterialRW.setEncryptedIV(encryptedIV);
            contentMaterialRW.setKeyWrapAlgorithm(KEY_WRAP_ALGORITHM);
            contentMaterialRW.setMaterialsDescription(this.desc);
        }
        catch (Exception e) {
            throw new ClientException("Kms encrypt CEK IV error. Please check your cmk, region, accessKeyId and accessSecretId." + e.getMessage(), e);
        }
    }

    @Override
    public void decryptCEK(ContentCryptoMaterialRW contentMaterialRW) {
        this.assertParameterNotNull(contentMaterialRW, "ContentCryptoMaterialRW");
        this.assertParameterNotNull(contentMaterialRW.getEncryptedCEK(), "ContentCryptoMaterialRW#getEncryptedCEK");
        this.assertParameterNotNull(contentMaterialRW.getEncryptedIV(), "ContentCryptoMaterialRW#getEncryptedIV");
        this.assertParameterNotNull(contentMaterialRW.getKeyWrapAlgorithm(), "ContentCryptoMaterialRW#getKeyWrapAlgorithm");
        if (!contentMaterialRW.getKeyWrapAlgorithm().toLowerCase().equals(KEY_WRAP_ALGORITHM.toLowerCase())) {
            throw new ClientException("Unrecognize your object key wrap algorithm: " + contentMaterialRW.getKeyWrapAlgorithm());
        }
        try {
            KmsClientSuite kmsClientSuite = this.findKmsClientSuiteByDescription(contentMaterialRW.getMaterialsDescription());
            if (kmsClientSuite == null) {
                Map.Entry<KmsClientSuite, Map<String, String>> entry = this.getTailByReflection(this.kmsDescMaterials);
                kmsClientSuite = entry.getKey();
            }
            DecryptResponse decryptIvResp = this.decryptCipherBlob(kmsClientSuite, BinaryUtil.toBase64String(contentMaterialRW.getEncryptedIV()));
            byte[] iv = BinaryUtil.fromBase64String(decryptIvResp.getPlaintext());
            DecryptResponse decryptCEKResp = this.decryptCipherBlob(kmsClientSuite, BinaryUtil.toBase64String(contentMaterialRW.getEncryptedCEK()));
            byte[] cekBytes = BinaryUtil.fromBase64String(decryptCEKResp.getPlaintext());
            SecretKeySpec cek = new SecretKeySpec(cekBytes, "");
            contentMaterialRW.setCEK(cek);
            contentMaterialRW.setIV(iv);
        }
        catch (Exception e) {
            throw new ClientException("Unable to decrypt content secured key and iv. Please check your kms region and materails description." + e.getMessage(), e);
        }
    }

    private void assertParameterNotNull(Object parameterValue, String errorMessage) {
        if (parameterValue == null) {
            throw new IllegalArgumentException(errorMessage);
        }
    }

    private final class KmsClientSuite {
        private String region;
        private CredentialsProvider credentialsProvider;

        KmsClientSuite(String region, CredentialsProvider credentialsProvider) {
            this.region = region;
            this.credentialsProvider = credentialsProvider;
        }
    }
}

