/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.webproxy;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.ipc.RPC;
import org.apache.hadoop.yarn.api.ApplicationClientProtocol;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.client.ClientRMProxy;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.exceptions.YarnRuntimeException;
import org.apache.hadoop.yarn.server.webproxy.AppReportFetcher;
import org.apache.hadoop.yarn.util.StringHelper;
import org.apache.hadoop.yarn.webapp.util.WebAppUtils;

public class DefaultAppReportFetcher
extends AppReportFetcher {
    private final ApplicationClientProtocol applicationsManager;
    private String rmAppPageUrlBase;

    public DefaultAppReportFetcher(Configuration conf) {
        super(conf);
        this.rmAppPageUrlBase = StringHelper.pjoin((Object[])new Object[]{WebAppUtils.getResolvedRMWebAppURLWithScheme((Configuration)conf), "cluster", "app"});
        try {
            this.applicationsManager = (ApplicationClientProtocol)ClientRMProxy.createRMProxy((Configuration)conf, ApplicationClientProtocol.class);
        }
        catch (IOException e) {
            throw new YarnRuntimeException((Throwable)e);
        }
    }

    public DefaultAppReportFetcher(Configuration conf, ApplicationClientProtocol applicationsManager) {
        super(conf);
        this.rmAppPageUrlBase = StringHelper.pjoin((Object[])new Object[]{WebAppUtils.getResolvedRMWebAppURLWithScheme((Configuration)conf), "cluster", "app"});
        this.applicationsManager = applicationsManager;
    }

    @Override
    public AppReportFetcher.FetchedAppReport getApplicationReport(ApplicationId appId) throws YarnException, IOException {
        return super.getApplicationReport(this.applicationsManager, appId);
    }

    @Override
    public String getRmAppPageUrlBase(ApplicationId appId) throws YarnException, IOException {
        return this.rmAppPageUrlBase;
    }

    @Override
    public void stop() {
        super.stop();
        if (this.applicationsManager != null) {
            RPC.stopProxy((Object)this.applicationsManager);
        }
    }
}

