/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.security.http;

import java.io.IOException;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.security.token.delegation.AbstractDelegationTokenSecretManager;
import org.apache.hadoop.security.token.delegation.web.DelegationTokenAuthenticationFilter;
import org.apache.hadoop.shaded.javax.servlet.FilterChain;
import org.apache.hadoop.shaded.javax.servlet.FilterConfig;
import org.apache.hadoop.shaded.javax.servlet.ServletException;
import org.apache.hadoop.shaded.javax.servlet.ServletRequest;
import org.apache.hadoop.shaded.javax.servlet.ServletResponse;
import org.apache.hadoop.shaded.javax.servlet.http.HttpServletRequest;
import org.apache.hadoop.shaded.javax.servlet.http.HttpServletRequestWrapper;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class RMAuthenticationFilter
extends DelegationTokenAuthenticationFilter {
    private static AbstractDelegationTokenSecretManager<?> manager;
    private static final String OLD_HEADER = "Hadoop-YARN-Auth-Delegation-Token";

    public void init(FilterConfig filterConfig) throws ServletException {
        filterConfig.getServletContext().setAttribute("hadoop.http.delegation-token-secret-manager", manager);
        super.init(filterConfig);
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain filterChain) throws IOException, ServletException {
        String oldHeader;
        HttpServletRequest req = (HttpServletRequest)request;
        String newHeader = req.getHeader("X-Hadoop-Delegation-Token");
        if ((newHeader == null || newHeader.isEmpty()) && (oldHeader = req.getHeader(OLD_HEADER)) != null && !oldHeader.isEmpty()) {
            request = new HttpServletRequestWrapper(req){

                public String getHeader(String name) {
                    if (name.equals("X-Hadoop-Delegation-Token")) {
                        return oldHeader;
                    }
                    return super.getHeader(name);
                }
            };
        }
        super.doFilter(request, response, filterChain);
    }

    public static void setDelegationTokenSecretManager(AbstractDelegationTokenSecretManager<?> manager) {
        RMAuthenticationFilter.manager = manager;
    }
}

