/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler;

import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.api.records.ResourceUtilization;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.SchedulerNode;

@InterfaceAudience.Private
@InterfaceStability.Stable
public class SchedulerNodeReport {
    private final Resource used;
    private final Resource avail;
    private final ResourceUtilization utilization;
    private final int num;

    public SchedulerNodeReport(SchedulerNode node) {
        this.used = node.getAllocatedResource();
        this.avail = node.getUnallocatedResource();
        this.num = node.getNumContainers();
        this.utilization = node.getNodeUtilization();
    }

    public Resource getUsedResource() {
        return this.used;
    }

    public Resource getAvailableResource() {
        return this.avail;
    }

    public int getNumContainers() {
        return this.num;
    }

    public ResourceUtilization getUtilization() {
        return this.utilization;
    }
}

