/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.org.nustaq.offheap;

import org.apache.hadoop.shaded.org.nustaq.offheap.FSTSerializedOffheapMap;
import org.apache.hadoop.shaded.org.nustaq.offheap.bytez.ByteSource;
import org.apache.hadoop.shaded.org.nustaq.offheap.bytez.bytesource.LeftCutStringByteSource;
import org.apache.hadoop.shaded.org.nustaq.serialization.simpleapi.DefaultCoder;
import org.apache.hadoop.shaded.org.nustaq.serialization.simpleapi.FSTCoder;

public class FSTAsciiStringOffheapMap<V>
extends FSTSerializedOffheapMap<String, V> {
    LeftCutStringByteSource tmpKey;

    public FSTAsciiStringOffheapMap(int keyLen, long sizeMemBytes, int numberOfEleems, FSTCoder coder) {
        super(keyLen, sizeMemBytes, numberOfEleems, coder);
        this.tmpKey = new LeftCutStringByteSource(null, 0, keyLen);
    }

    public FSTAsciiStringOffheapMap(int keyLen, long sizeMemBytes, int numberOfEleems) {
        super(keyLen, sizeMemBytes, numberOfEleems, new DefaultCoder());
        this.tmpKey = new LeftCutStringByteSource(null, 0, keyLen);
    }

    public FSTAsciiStringOffheapMap(String mappedFile, int keyLen, long sizeMemBytes, int numberOfElems, FSTCoder coder) throws Exception {
        super(mappedFile, keyLen, sizeMemBytes, numberOfElems, coder);
        this.tmpKey = new LeftCutStringByteSource(null, 0, keyLen);
    }

    public FSTAsciiStringOffheapMap(String file, int keylen, long size, int numelem) throws Exception {
        this(file, keylen, size, numelem, new DefaultCoder());
    }

    @Override
    public ByteSource encodeKey(String key) {
        if ((long)key.length() > this.tmpKey.length()) {
            int length = (int)this.tmpKey.length();
            StringBuilder buf = new StringBuilder(length);
            for (int i = 0; i < length; ++i) {
                char c = key.charAt(i);
                if (i + length < key.length()) {
                    c = (char)((c + key.charAt(i + length)) / 2);
                }
                buf.append(c);
            }
            key = buf.toString();
        }
        this.tmpKey.setString(key);
        return this.tmpKey;
    }
}

