/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.blockmanagement;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.classification.VisibleForTesting;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.server.blockmanagement.SlowPeerJsonReport;
import org.apache.hadoop.hdfs.server.blockmanagement.SlowPeerLatencyWithReportingNode;
import org.apache.hadoop.hdfs.server.protocol.OutlierMetrics;
import org.apache.hadoop.shaded.com.fasterxml.jackson.core.JsonProcessingException;
import org.apache.hadoop.shaded.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.hadoop.shaded.com.fasterxml.jackson.databind.ObjectWriter;
import org.apache.hadoop.thirdparty.com.google.common.collect.ImmutableMap;
import org.apache.hadoop.thirdparty.com.google.common.primitives.Ints;
import org.apache.hadoop.util.Timer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class SlowPeerTracker {
    public static final Logger LOG = LoggerFactory.getLogger(SlowPeerTracker.class);
    private final long reportValidityMs;
    private final Timer timer;
    private static final ObjectWriter WRITER = new ObjectMapper().writer();
    private volatile int maxNodesToReport;
    private final ConcurrentMap<String, ConcurrentMap<String, LatencyWithLastReportTime>> allReports;

    public SlowPeerTracker(Configuration conf, Timer timer) {
        this.timer = timer;
        this.allReports = new ConcurrentHashMap<String, ConcurrentMap<String, LatencyWithLastReportTime>>();
        this.reportValidityMs = conf.getTimeDuration("dfs.datanode.outliers.report.interval", "30m", TimeUnit.MILLISECONDS) * 3L;
        this.setMaxSlowPeersToReport(conf.getInt("dfs.datanode.max.nodes.to.report", 5));
    }

    public boolean isSlowPeerTrackerEnabled() {
        return true;
    }

    public void addReport(String slowNode, String reportingNode, OutlierMetrics slowNodeMetrics) {
        ConcurrentMap nodeEntries = (ConcurrentMap)this.allReports.get(slowNode);
        if (nodeEntries == null) {
            this.allReports.putIfAbsent(slowNode, new ConcurrentHashMap());
            nodeEntries = (ConcurrentMap)this.allReports.get(slowNode);
        }
        nodeEntries.put(reportingNode, new LatencyWithLastReportTime(this.timer.monotonicNow(), slowNodeMetrics));
    }

    public Set<SlowPeerLatencyWithReportingNode> getReportsForNode(String slowNode) {
        ConcurrentMap nodeEntries = (ConcurrentMap)this.allReports.get(slowNode);
        if (nodeEntries == null || nodeEntries.isEmpty()) {
            return Collections.emptySet();
        }
        return this.filterNodeReports(nodeEntries, this.timer.monotonicNow());
    }

    public Map<String, SortedSet<SlowPeerLatencyWithReportingNode>> getReportsForAllDataNodes() {
        if (this.allReports.isEmpty()) {
            return ImmutableMap.of();
        }
        HashMap<String, SortedSet<SlowPeerLatencyWithReportingNode>> allNodesValidReports = new HashMap<String, SortedSet<SlowPeerLatencyWithReportingNode>>();
        long now = this.timer.monotonicNow();
        for (Map.Entry entry : this.allReports.entrySet()) {
            SortedSet<SlowPeerLatencyWithReportingNode> validReports = this.filterNodeReports((ConcurrentMap)entry.getValue(), now);
            if (validReports.isEmpty()) continue;
            allNodesValidReports.put((String)entry.getKey(), validReports);
        }
        return allNodesValidReports;
    }

    private SortedSet<SlowPeerLatencyWithReportingNode> filterNodeReports(ConcurrentMap<String, LatencyWithLastReportTime> reports, long now) {
        TreeSet<SlowPeerLatencyWithReportingNode> validReports = new TreeSet<SlowPeerLatencyWithReportingNode>();
        for (Map.Entry entry : reports.entrySet()) {
            if (now - ((LatencyWithLastReportTime)entry.getValue()).getTime() >= this.reportValidityMs) continue;
            OutlierMetrics outlierMetrics = ((LatencyWithLastReportTime)entry.getValue()).getLatency();
            validReports.add(new SlowPeerLatencyWithReportingNode((String)entry.getKey(), outlierMetrics.getActualLatency(), outlierMetrics.getMedian(), outlierMetrics.getMad(), outlierMetrics.getUpperLimitLatency()));
        }
        return validReports;
    }

    public String getJson() {
        Collection<SlowPeerJsonReport> validReports = this.getJsonReports(this.maxNodesToReport);
        try {
            return WRITER.writeValueAsString(validReports);
        }
        catch (JsonProcessingException e) {
            LOG.debug("Failed to serialize statistics" + (Object)((Object)e));
            return null;
        }
    }

    public List<String> getSlowNodes(int numNodes) {
        Collection<SlowPeerJsonReport> jsonReports = this.getJsonReports(numNodes);
        ArrayList<String> slowNodes = new ArrayList<String>();
        for (SlowPeerJsonReport jsonReport : jsonReports) {
            slowNodes.add(jsonReport.getSlowNode());
        }
        if (!slowNodes.isEmpty()) {
            LOG.warn("Slow nodes list: " + slowNodes);
        }
        return slowNodes;
    }

    private Collection<SlowPeerJsonReport> getJsonReports(int numNodes) {
        if (this.allReports.isEmpty()) {
            return Collections.emptyList();
        }
        PriorityQueue<SlowPeerJsonReport> topNReports = new PriorityQueue<SlowPeerJsonReport>(this.allReports.size(), (o1, o2) -> Ints.compare((int)o1.getSlowPeerLatencyWithReportingNodes().size(), (int)o2.getSlowPeerLatencyWithReportingNodes().size()));
        long now = this.timer.monotonicNow();
        for (Map.Entry entry : this.allReports.entrySet()) {
            SortedSet<SlowPeerLatencyWithReportingNode> validReports = this.filterNodeReports((ConcurrentMap)entry.getValue(), now);
            if (validReports.isEmpty()) continue;
            if (topNReports.size() < numNodes) {
                topNReports.add(new SlowPeerJsonReport((String)entry.getKey(), validReports));
                continue;
            }
            if (topNReports.peek() == null || topNReports.peek().getSlowPeerLatencyWithReportingNodes().size() >= validReports.size()) continue;
            topNReports.poll();
            topNReports.add(new SlowPeerJsonReport((String)entry.getKey(), validReports));
        }
        return topNReports;
    }

    @VisibleForTesting
    long getReportValidityMs() {
        return this.reportValidityMs;
    }

    public synchronized void setMaxSlowPeersToReport(int maxSlowPeersToReport) {
        this.maxNodesToReport = maxSlowPeersToReport;
    }

    private static class LatencyWithLastReportTime {
        private final Long time;
        private final OutlierMetrics latency;

        LatencyWithLastReportTime(Long time, OutlierMetrics latency) {
            this.time = time;
            this.latency = latency;
        }

        public Long getTime() {
            return this.time;
        }

        public OutlierMetrics getLatency() {
            return this.latency;
        }
    }
}

