/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.contract;

import java.nio.charset.StandardCharsets;
import org.apache.hadoop.fs.EtagSource;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocatedFileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.contract.AbstractFSContractTestBase;
import org.apache.hadoop.fs.contract.ContractTestUtils;
import org.apache.hadoop.shaded.org.assertj.core.api.AbstractBooleanAssert;
import org.apache.hadoop.shaded.org.assertj.core.api.AbstractComparableAssert;
import org.apache.hadoop.shaded.org.assertj.core.api.AbstractStringAssert;
import org.apache.hadoop.shaded.org.assertj.core.api.Assertions;
import org.apache.hadoop.shaded.org.assertj.core.api.ObjectArrayAssert;
import org.junit.Assume;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractContractEtagTest
extends AbstractFSContractTestBase {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractContractEtagTest.class);

    @Test
    public void testEtagConsistencyAcrossListAndHead() throws Throwable {
        this.describe("Etag values must be non-empty and consistent across LIST and HEAD Calls.");
        Path path = this.methodPath();
        FileSystem fs = this.getFileSystem();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)fs.hasPathCapability(path, "fs.capability.etags.available")).describedAs("path capability %s of %s", new Object[]{"fs.capability.etags.available", path})).isTrue();
        ContractTestUtils.touch(fs, path);
        FileStatus st = fs.getFileStatus(path);
        String etag = this.etagFromStatus(st);
        LOG.info("etag of empty file is \"{}\"", (Object)etag);
        Object[] statuses = fs.listStatus(path);
        ((ObjectArrayAssert)Assertions.assertThat((Object[])statuses).describedAs("List(%s)", new Object[]{path})).hasSize(1);
        Object lsStatus = statuses[0];
        ((AbstractStringAssert)Assertions.assertThat((String)this.etagFromStatus((FileStatus)lsStatus)).describedAs("etag of list status (%s) compared to HEAD value of %s", new Object[]{lsStatus, st})).isEqualTo((Object)etag);
    }

    String etagFromStatus(FileStatus st) {
        ((AbstractComparableAssert)Assertions.assertThat((Comparable)st).describedAs("FileStatus %s", new Object[]{st})).isInstanceOf(EtagSource.class);
        String etag = ((EtagSource)st).getEtag();
        ((AbstractStringAssert)Assertions.assertThat((String)etag).describedAs("Etag of %s", new Object[]{st})).isNotBlank();
        return etag;
    }

    @Test
    public void testEtagsOfDifferentDataDifferent() throws Throwable {
        this.describe("Verify that two different blocks of data written have different tags");
        Path path = this.methodPath();
        FileSystem fs = this.getFileSystem();
        Path src = new Path(path, "src");
        ContractTestUtils.createFile(fs, src, true, "data1234".getBytes(StandardCharsets.UTF_8));
        FileStatus srcStatus = fs.getFileStatus(src);
        String srcTag = this.etagFromStatus(srcStatus);
        LOG.info("etag of file 1 is \"{}\"", (Object)srcTag);
        ContractTestUtils.createFile(fs, src, true, "1234data".getBytes(StandardCharsets.UTF_8));
        String tag2 = this.etagFromStatus(fs.getFileStatus(src));
        LOG.info("etag of file 2 is \"{}\"", (Object)tag2);
        ((AbstractStringAssert)Assertions.assertThat((String)tag2).describedAs("etag of updated file", new Object[0])).isNotEqualTo((Object)srcTag);
    }

    @Test
    public void testEtagConsistencyAcrossRename() throws Throwable {
        this.describe("Verify that when a file is renamed, the etag remains unchanged");
        Path path = this.methodPath();
        FileSystem fs = this.getFileSystem();
        Assume.assumeTrue((String)"Filesystem does not declare that etags are preserved across renames", (boolean)fs.hasPathCapability(path, "fs.capability.etags.preserved.in.rename"));
        Path src = new Path(path, "src");
        Path dest = new Path(path, "dest");
        ContractTestUtils.createFile(fs, src, true, "sample data".getBytes(StandardCharsets.UTF_8));
        FileStatus srcStatus = fs.getFileStatus(src);
        LOG.info("located file status string value " + srcStatus);
        String srcTag = this.etagFromStatus(srcStatus);
        LOG.info("etag of short file is \"{}\"", (Object)srcTag);
        ((AbstractStringAssert)Assertions.assertThat((String)srcTag).describedAs("Etag of %s", new Object[]{srcStatus})).isNotBlank();
        fs.rename(src, dest);
        FileStatus destStatus = fs.getFileStatus(dest);
        String destTag = this.etagFromStatus(destStatus);
        ((AbstractStringAssert)Assertions.assertThat((String)destTag).describedAs("etag of list status (%s) compared to HEAD value of %s", new Object[]{destStatus, srcStatus})).isEqualTo((Object)srcTag);
    }

    @Test
    public void testLocatedStatusAlsoHasEtag() throws Throwable {
        this.describe("verify that listLocatedStatus() and listFiles() are etag sources");
        Path path = this.methodPath();
        FileSystem fs = this.getFileSystem();
        Path src = new Path(path, "src");
        ContractTestUtils.createFile(fs, src, true, "sample data".getBytes(StandardCharsets.UTF_8));
        FileStatus srcStatus = fs.getFileStatus(src);
        String srcTag = this.etagFromStatus(srcStatus);
        LocatedFileStatus entry = (LocatedFileStatus)fs.listLocatedStatus(path).next();
        LOG.info("located file status string value " + entry);
        String listTag = this.etagFromStatus((FileStatus)entry);
        ((AbstractStringAssert)Assertions.assertThat((String)listTag).describedAs("etag of listLocatedStatus (%s) compared to HEAD value of %s", new Object[]{entry, srcStatus})).isEqualTo((Object)srcTag);
        LocatedFileStatus entry2 = (LocatedFileStatus)fs.listFiles(path, false).next();
        ((AbstractStringAssert)Assertions.assertThat((String)this.etagFromStatus((FileStatus)entry2)).describedAs("etag of listFiles (%s) compared to HEAD value of %s", new Object[]{entry, srcStatus})).isEqualTo((Object)srcTag);
    }
}

