/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import java.io.IOException;
import java.text.ParseException;
import java.util.Date;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FsShell;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.shell.TouchCommands;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.test.GenericTestUtils;
import org.apache.hadoop.util.StringUtils;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.Assertions;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestDFSShellTouch {
    private static final Logger LOG = LoggerFactory.getLogger(TestDFSShellTouch.class);
    private static MiniDFSCluster miniCluster;
    private static DistributedFileSystem dfs;
    private static FsShell shell;

    @BeforeClass
    public static void setup() throws IOException {
        Configuration conf = new Configuration();
        conf.set("hdfs.minidfs.basedir", GenericTestUtils.getTestDir((String)"TestDFSShellTouch").getAbsolutePath());
        miniCluster = new MiniDFSCluster.Builder(conf).numDataNodes(2).build();
        miniCluster.waitActive();
        dfs = miniCluster.getFileSystem();
        shell = new FsShell(dfs.getConf());
    }

    @AfterClass
    public static void tearDown() {
        if (miniCluster != null) {
            miniCluster.shutdown(true, true);
        }
    }

    @Test
    public void testTouch() throws Exception {
        String newFileName = "newFile1";
        Path newFile = new Path("newFile1");
        dfs.delete(newFile, true);
        Assertions.assertThat((boolean)dfs.exists(newFile)).isFalse();
        dfs.create(newFile);
        Assertions.assertThat((boolean)dfs.exists(newFile)).isTrue();
        String strTime = this.formatTimestamp(System.currentTimeMillis());
        Date dateObj = this.parseTimestamp(strTime);
        ((AbstractIntegerAssert)Assertions.assertThat((int)this.shellRun("-touch", "-t", strTime, "newFile1")).as("Expected successful touch on a new file with a specified timestamp", new Object[0])).isEqualTo(0);
        FileStatus newStatus = dfs.getFileStatus(newFile);
        Assertions.assertThat((long)newStatus.getAccessTime()).isEqualTo(dateObj.getTime());
        Assertions.assertThat((long)newStatus.getModificationTime()).isEqualTo(dateObj.getTime());
        FileStatus fileStatus = dfs.getFileStatus(newFile);
        Thread.sleep(500L);
        strTime = this.formatTimestamp(System.currentTimeMillis());
        dateObj = this.parseTimestamp(strTime);
        ((AbstractIntegerAssert)Assertions.assertThat((int)this.shellRun("-touch", "-a", "-t", strTime, "newFile1")).as("Expected successful touch with a specified access time", new Object[0])).isEqualTo(0);
        newStatus = dfs.getFileStatus(newFile);
        Assertions.assertThat((long)newStatus.getAccessTime()).isEqualTo(dateObj.getTime());
        Assertions.assertThat((long)newStatus.getModificationTime()).isEqualTo(fileStatus.getModificationTime());
        fileStatus = dfs.getFileStatus(newFile);
        Thread.sleep(500L);
        strTime = this.formatTimestamp(System.currentTimeMillis());
        dateObj = this.parseTimestamp(strTime);
        ((AbstractIntegerAssert)Assertions.assertThat((int)this.shellRun("-touch", "-m", "-t", strTime, "newFile1")).as("Expected successful touch with a specified modification time", new Object[0])).isEqualTo(0);
        newStatus = dfs.getFileStatus(newFile);
        Assertions.assertThat((long)newStatus.getAccessTime()).isEqualTo(fileStatus.getAccessTime());
        Assertions.assertThat((long)newStatus.getModificationTime()).isEqualTo(dateObj.getTime());
        strTime = this.formatTimestamp(System.currentTimeMillis());
        dateObj = this.parseTimestamp(strTime);
        ((AbstractIntegerAssert)Assertions.assertThat((int)this.shellRun("-touch", "-t", strTime, "newFile1")).as("Expected successful touch with a specified timestamp", new Object[0])).isEqualTo(0);
        newStatus = dfs.getFileStatus(newFile);
        Assertions.assertThat((long)newStatus.getAccessTime()).isEqualTo(dateObj.getTime());
        Assertions.assertThat((long)newStatus.getModificationTime()).isEqualTo(dateObj.getTime());
        strTime = this.formatTimestamp(System.currentTimeMillis());
        dateObj = this.parseTimestamp(strTime);
        ((AbstractIntegerAssert)Assertions.assertThat((int)this.shellRun("-touch", "-a", "-m", "-t", strTime, "newFile1")).as("Expected successful touch with a specified timestamp", new Object[0])).isEqualTo(0);
        newStatus = dfs.getFileStatus(newFile);
        Assertions.assertThat((long)newStatus.getAccessTime()).isEqualTo(dateObj.getTime());
        Assertions.assertThat((long)newStatus.getModificationTime()).isEqualTo(dateObj.getTime());
        ((AbstractIntegerAssert)Assertions.assertThat((int)this.shellRun("-touch", "-t", "newFile1")).as("Expected failed touch with a missing timestamp", new Object[0])).isNotEqualTo(0);
        strTime = this.formatTimestamp(System.currentTimeMillis());
        dateObj = this.parseTimestamp(strTime);
        ((AbstractIntegerAssert)Assertions.assertThat((int)this.shellRun("-touch", "-c", "-t", strTime, "newFile1")).as("Expected successful touch on a non-existent file with -c option", new Object[0])).isEqualTo(0);
        fileStatus = dfs.getFileStatus(newFile);
        Assertions.assertThat((long)fileStatus.getAccessTime()).isEqualTo(dateObj.getTime());
        Assertions.assertThat((long)fileStatus.getModificationTime()).isEqualTo(dateObj.getTime());
        dfs.delete(newFile, true);
        Assertions.assertThat((boolean)dfs.exists(newFile)).isFalse();
    }

    @Test
    public void testTouchDirs() throws IOException, ParseException, InterruptedException {
        String newFileName = "dir2/newFile2";
        Path newFile = new Path("dir2/newFile2");
        Path dirPath = new Path("dir2");
        dfs.mkdirs(dirPath);
        dfs.delete(newFile, true);
        Assertions.assertThat((boolean)dfs.exists(newFile)).isFalse();
        String strTime = this.formatTimestamp(System.currentTimeMillis());
        Date dateObj = this.parseTimestamp(strTime);
        ((AbstractIntegerAssert)Assertions.assertThat((int)this.shellRun("-touch", "-t", strTime, "dir2/newFile2")).as("Expected successful touch on a new file with a specified timestamp", new Object[0])).isEqualTo(0);
        FileStatus newStatus = dfs.getFileStatus(newFile);
        Assertions.assertThat((long)newStatus.getAccessTime()).isEqualTo(dateObj.getTime());
        Assertions.assertThat((long)newStatus.getModificationTime()).isEqualTo(dateObj.getTime());
        Thread.sleep(500L);
        strTime = this.formatTimestamp(System.currentTimeMillis());
        dateObj = this.parseTimestamp(strTime);
        ((AbstractIntegerAssert)Assertions.assertThat((int)this.shellRun("-touch", "-m", "-a", "-t", strTime, "dir2")).as("Expected successful touch with a specified modification time", new Object[0])).isEqualTo(0);
        newStatus = dfs.getFileStatus(dirPath);
        Assertions.assertThat((long)newStatus.getAccessTime()).isEqualTo(dateObj.getTime());
        Assertions.assertThat((long)newStatus.getModificationTime()).isEqualTo(dateObj.getTime());
        FileStatus fileStatus = dfs.getFileStatus(dirPath);
        Thread.sleep(500L);
        strTime = this.formatTimestamp(System.currentTimeMillis());
        dateObj = this.parseTimestamp(strTime);
        ((AbstractIntegerAssert)Assertions.assertThat((int)this.shellRun("-touch", "-m", "-t", strTime, "dir2")).as("Expected successful touch with a specified modification time", new Object[0])).isEqualTo(0);
        newStatus = dfs.getFileStatus(dirPath);
        Assertions.assertThat((long)newStatus.getAccessTime()).isEqualTo(fileStatus.getAccessTime());
        Assertions.assertThat((long)newStatus.getModificationTime()).isEqualTo(dateObj.getTime());
        fileStatus = dfs.getFileStatus(dirPath);
        Thread.sleep(500L);
        strTime = this.formatTimestamp(System.currentTimeMillis());
        dateObj = this.parseTimestamp(strTime);
        ((AbstractIntegerAssert)Assertions.assertThat((int)this.shellRun("-touch", "-a", "-t", strTime, "dir2")).as("Expected successful touch with a specified modification time", new Object[0])).isEqualTo(0);
        newStatus = dfs.getFileStatus(dirPath);
        Assertions.assertThat((long)newStatus.getAccessTime()).isEqualTo(dateObj.getTime());
        Assertions.assertThat((long)newStatus.getModificationTime()).isEqualTo(fileStatus.getModificationTime());
        dfs.delete(newFile, true);
        dfs.delete(dirPath, true);
        Assertions.assertThat((boolean)dfs.exists(newFile)).isFalse();
        Assertions.assertThat((boolean)dfs.exists(dirPath)).isFalse();
    }

    private int shellRun(String ... args) {
        int exitCode = shell.run(args);
        LOG.info("exit " + exitCode + " - " + StringUtils.join((CharSequence)" ", (String[])args));
        return exitCode;
    }

    private String formatTimestamp(long timeInMillis) {
        return new TouchCommands.Touch().getDateFormat().format(new Date(timeInMillis));
    }

    private Date parseTimestamp(String tstamp) throws ParseException {
        return new TouchCommands.Touch().getDateFormat().parse(tstamp);
    }
}

