/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Random;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.StorageType;
import org.apache.hadoop.hdfs.DFSClient;
import org.apache.hadoop.hdfs.DFSInputStream;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.client.HdfsClientConfigKeys;
import org.apache.hadoop.hdfs.client.impl.DfsClientConf;
import org.apache.hadoop.hdfs.protocol.DatanodeID;
import org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import org.apache.hadoop.hdfs.protocol.DatanodeInfoWithStorage;
import org.apache.hadoop.hdfs.protocol.LocatedBlock;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeDescriptor;
import org.apache.hadoop.net.unix.DomainSocket;
import org.apache.hadoop.net.unix.TemporarySocketDirectory;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Test;
import org.mockito.Mockito;

public class TestDFSInputStream {
    private void testSkipInner(MiniDFSCluster cluster) throws IOException {
        DistributedFileSystem fs = cluster.getFileSystem();
        DFSClient client = fs.dfs;
        Path file = new Path("/testfile");
        int fileLength = 0x400000;
        byte[] fileContent = new byte[fileLength];
        for (int i = 0; i < fileLength; ++i) {
            fileContent[i] = (byte)(i % 133);
        }
        FSDataOutputStream fout = fs.create(file);
        fout.write(fileContent);
        fout.close();
        Random random = new Random();
        for (int i = 3; i < 18; ++i) {
            DFSInputStream fin = client.open("/testfile");
            for (long pos = 0L; pos < (long)fileLength; ++pos) {
                long skip = random.nextInt(1 << i) + 1;
                long skipped = fin.skip(skip);
                if (pos + skip >= (long)fileLength) {
                    Assert.assertEquals((long)fileLength, (long)(pos + skipped));
                    break;
                }
                Assert.assertEquals((long)skip, (long)skipped);
                int data = fin.read();
                Assert.assertEquals((long)((pos += skipped) % 133L), (long)data);
            }
            fin.close();
        }
    }

    @Test(timeout=60000L)
    public void testSkipWithRemoteBlockReader() throws IOException {
        Configuration conf = new Configuration();
        MiniDFSCluster cluster = new MiniDFSCluster.Builder(conf).build();
        try {
            this.testSkipInner(cluster);
        }
        finally {
            cluster.shutdown();
        }
    }

    @Test(timeout=60000L)
    public void testSkipWithRemoteBlockReader2() throws IOException {
        Configuration conf = new Configuration();
        MiniDFSCluster cluster = new MiniDFSCluster.Builder(conf).build();
        try {
            this.testSkipInner(cluster);
        }
        finally {
            cluster.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=60000L)
    public void testSkipWithLocalBlockReader() throws IOException {
        Assume.assumeThat((Object)DomainSocket.getLoadingFailureReason(), (Matcher)CoreMatchers.equalTo(null));
        TemporarySocketDirectory sockDir = new TemporarySocketDirectory();
        DomainSocket.disableBindPathValidation();
        Configuration conf = new Configuration();
        conf.setBoolean(HdfsClientConfigKeys.Read.ShortCircuit.KEY, true);
        conf.set("dfs.domain.socket.path", new File(sockDir.getDir(), "TestShortCircuitLocalRead._PORT.sock").getAbsolutePath());
        MiniDFSCluster cluster = new MiniDFSCluster.Builder(conf).build();
        try {
            DFSInputStream.tcpReadsDisabledForTesting = true;
            this.testSkipInner(cluster);
        }
        finally {
            DFSInputStream.tcpReadsDisabledForTesting = false;
            cluster.shutdown();
            sockDir.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=60000L)
    public void testSeekToNewSource() throws IOException {
        Configuration conf = new Configuration();
        MiniDFSCluster cluster = new MiniDFSCluster.Builder(conf).numDataNodes(3).build();
        DistributedFileSystem fs = cluster.getFileSystem();
        Path path = new Path("/testfile");
        DFSTestUtil.createFile((FileSystem)fs, path, 1024L, (short)3, 0L);
        DFSInputStream fin = fs.dfs.open("/testfile");
        try {
            fin.seekToNewSource(100L);
            Assert.assertEquals((long)100L, (long)fin.getPos());
            DatanodeInfo firstNode = fin.getCurrentDatanode();
            Assert.assertNotNull((Object)firstNode);
            fin.seekToNewSource(100L);
            Assert.assertEquals((long)100L, (long)fin.getPos());
            Assert.assertFalse((boolean)firstNode.equals((Object)fin.getCurrentDatanode()));
        }
        finally {
            fin.close();
            cluster.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=60000L)
    public void testOpenInfo() throws IOException {
        Configuration conf = new Configuration();
        conf.setInt("dfs.client.retry.times.get-last-block-length", 0);
        MiniDFSCluster cluster = new MiniDFSCluster.Builder(conf).build();
        cluster.waitActive();
        try {
            DistributedFileSystem fs = cluster.getFileSystem();
            int chunkSize = 512;
            Random r = new Random(12345L);
            byte[] data = new byte[chunkSize];
            r.nextBytes(data);
            Path file = new Path("/testfile");
            try (FSDataOutputStream fout = fs.create(file);){
                fout.write(data);
            }
            DfsClientConf dcconf = new DfsClientConf(conf);
            int retryTimesForGetLastBlockLength = dcconf.getRetryTimesForGetLastBlockLength();
            Assert.assertEquals((long)0L, (long)retryTimesForGetLastBlockLength);
            try (DFSInputStream fin = fs.dfs.open("/testfile");){
                long flen = fin.getFileLength();
                Assert.assertEquals((long)chunkSize, (long)flen);
                long lastBlockBeingWrittenLength = fin.getlastBlockBeingWrittenLengthForTesting();
                Assert.assertEquals((long)0L, (long)lastBlockBeingWrittenLength);
            }
        }
        finally {
            cluster.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testNullCheckSumWhenDNRestarted() throws IOException, InterruptedException {
        Configuration conf = new Configuration();
        conf.set("dfs.checksum.type", "NULL");
        MiniDFSCluster cluster = new MiniDFSCluster.Builder(conf).numDataNodes(2).build();
        cluster.waitActive();
        try {
            DistributedFileSystem fs = cluster.getFileSystem();
            int chunkSize = 512;
            Random r = new Random(12345L);
            byte[] data = new byte[chunkSize];
            r.nextBytes(data);
            Path file = new Path("/testfile");
            try (FSDataOutputStream fout = fs.create(file);){
                fout.write(data);
                fout.hflush();
                cluster.restartDataNode(0, true, true);
            }
            Thread.sleep(1000L);
            ArrayList live = new ArrayList();
            cluster.getNameNode().getNamesystem().getBlockManager().getDatanodeManager().fetchDatanodes(live, null, false);
            Assert.assertTrue((String)"DN start should be success and live dn should be 2", (live.size() == 2 ? 1 : 0) != 0);
            Assert.assertTrue((String)("File size should be " + chunkSize), (fs.getFileStatus(file).getLen() == (long)chunkSize ? 1 : 0) != 0);
        }
        finally {
            cluster.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testReadWithPreferredCachingReplica() throws IOException {
        Configuration conf = new Configuration();
        conf.setBoolean("dfs.client.read.use.cache.priority", true);
        MiniDFSCluster cluster = new MiniDFSCluster.Builder(conf).numDataNodes(3).build();
        cluster.waitActive();
        DistributedFileSystem fs = null;
        Path filePath = new Path("/testReadPreferredCachingReplica");
        try {
            fs = cluster.getFileSystem();
            FSDataOutputStream out = fs.create(filePath, true, 4096, (short)3, 512L);
            DFSInputStream dfsInputStream = (DFSInputStream)fs.open(filePath).getWrappedStream();
            LocatedBlock lb = (LocatedBlock)Mockito.mock(LocatedBlock.class);
            Mockito.when((Object)lb.getCachedLocations()).thenReturn((Object)DatanodeInfo.EMPTY_ARRAY);
            DatanodeID nodeId = new DatanodeID("localhost", "localhost", "dn0", 1111, 1112, 1113, 1114);
            DatanodeDescriptor dnInfo = new DatanodeDescriptor(nodeId);
            Mockito.when((Object)lb.getCachedLocations()).thenReturn((Object)new DatanodeInfo[]{dnInfo});
            DatanodeInfo retDNInfo = dfsInputStream.getBestNodeDNAddrPair((LocatedBlock)lb, null).info;
            Assert.assertEquals((Object)dnInfo, (Object)retDNInfo);
        }
        finally {
            fs.delete(filePath, true);
            cluster.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testReadWithoutPreferredCachingReplica() throws IOException {
        Configuration conf = new Configuration();
        conf.setBoolean("dfs.client.read.use.cache.priority", false);
        MiniDFSCluster cluster = new MiniDFSCluster.Builder(conf).numDataNodes(3).build();
        cluster.waitActive();
        DistributedFileSystem fs = null;
        Path filePath = new Path("/testReadWithoutPreferredCachingReplica");
        try {
            fs = cluster.getFileSystem();
            FSDataOutputStream out = fs.create(filePath, true, 4096, (short)3, 512L);
            DFSInputStream dfsInputStream = (DFSInputStream)fs.open(filePath).getWrappedStream();
            LocatedBlock lb = (LocatedBlock)Mockito.mock(LocatedBlock.class);
            Mockito.when((Object)lb.getCachedLocations()).thenReturn((Object)DatanodeInfo.EMPTY_ARRAY);
            DatanodeID nodeId = new DatanodeID("localhost", "localhost", "dn0", 1111, 1112, 1113, 1114);
            DatanodeDescriptor dnInfo = new DatanodeDescriptor(nodeId);
            DatanodeInfoWithStorage dnInfoStorage = new DatanodeInfoWithStorage((DatanodeInfo)dnInfo, "DISK", StorageType.DISK);
            Mockito.when((Object)lb.getLocations()).thenReturn((Object)new DatanodeInfoWithStorage[]{dnInfoStorage});
            DatanodeInfo retDNInfo = dfsInputStream.getBestNodeDNAddrPair((LocatedBlock)lb, null).info;
            Assert.assertEquals((Object)dnInfo, (Object)retDNInfo);
        }
        finally {
            fs.delete(filePath, true);
            cluster.shutdown();
        }
    }
}

