/*
 * Decompiled with CFR 0.152.
 */
package com.github.davidmoten.rx.testing;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.junit.Assert;
import rx.Observable;
import rx.Producer;
import rx.Subscriber;
import rx.Subscription;
import rx.functions.Action0;
import rx.functions.Func1;
import rx.observers.TestSubscriber;

public class TestSubscriber2<T>
extends Subscriber<T> {
    private final TestSubscriber<T> ts;

    private TestSubscriber2(TestSubscriber<T> ts) {
        this.ts = ts;
    }

    public static <T> TestSubscriber2<T> createWithRequest(long initialRequest) {
        TestSubscriber t1 = new TestSubscriber(initialRequest);
        TestSubscriber2<T> t2 = new TestSubscriber2<T>(t1);
        t2.add((Subscription)t1);
        return t2;
    }

    static <T> Func1<Observable<T>, TestSubscriber2<T>> test() {
        return TestSubscriber2.testWithRequest(Long.MAX_VALUE);
    }

    static <T> Func1<Observable<T>, TestSubscriber2<T>> testWithRequest(final long initialRequest) {
        return new Func1<Observable<T>, TestSubscriber2<T>>(){

            public TestSubscriber2<T> call(Observable<T> o) {
                TestSubscriber2 ts2 = TestSubscriber2.createWithRequest(initialRequest);
                o.subscribe((Subscriber)ts2.ts);
                return ts2;
            }
        };
    }

    public void onStart() {
        this.ts.onStart();
    }

    public void onCompleted() {
        this.ts.onCompleted();
    }

    public void setProducer(Producer p) {
        this.ts.setProducer(p);
    }

    public final int getCompletions() {
        return this.ts.getCompletions();
    }

    public void onError(Throwable e) {
        this.ts.onError(e);
    }

    public List<Throwable> getOnErrorEvents() {
        return this.ts.getOnErrorEvents();
    }

    public void onNext(T t) {
        this.ts.onNext(t);
    }

    public String toString() {
        return this.ts.toString();
    }

    public final int getValueCount() {
        return this.ts.getValueCount();
    }

    public TestSubscriber2<T> requestMore(long n) {
        this.ts.requestMore(n);
        return this;
    }

    public List<T> getOnNextEvents() {
        return this.ts.getOnNextEvents();
    }

    public TestSubscriber2<T> assertReceivedOnNext(List<T> items) {
        this.ts.assertReceivedOnNext(items);
        return this;
    }

    public final boolean awaitValueCount(int expected, long timeout, TimeUnit unit) {
        return this.ts.awaitValueCount(expected, timeout, unit);
    }

    public TestSubscriber2<T> assertTerminalEvent() {
        this.ts.assertTerminalEvent();
        return this;
    }

    public TestSubscriber2<T> assertUnsubscribed() {
        this.ts.assertUnsubscribed();
        return this;
    }

    public TestSubscriber2<T> assertNoErrors() {
        this.ts.assertNoErrors();
        return this;
    }

    public TestSubscriber2<T> awaitTerminalEvent() {
        this.ts.awaitTerminalEvent();
        return this;
    }

    public TestSubscriber2<T> awaitTerminalEvent(long timeout, TimeUnit unit) {
        this.ts.awaitTerminalEvent(timeout, unit);
        return this;
    }

    public TestSubscriber2<T> awaitTerminalEventAndUnsubscribeOnTimeout(long timeout, TimeUnit unit) {
        this.ts.awaitTerminalEventAndUnsubscribeOnTimeout(timeout, unit);
        return this;
    }

    public Thread getLastSeenThread() {
        return this.ts.getLastSeenThread();
    }

    public TestSubscriber2<T> assertCompleted() {
        this.ts.assertCompleted();
        return this;
    }

    public TestSubscriber2<T> assertNotCompleted() {
        this.ts.assertNotCompleted();
        return this;
    }

    public TestSubscriber2<T> assertError(Class<? extends Throwable> clazz) {
        this.ts.assertError(clazz);
        return this;
    }

    public TestSubscriber2<T> assertError(Throwable throwable) {
        this.ts.assertError(throwable);
        return this;
    }

    public TestSubscriber2<T> assertNoTerminalEvent() {
        this.ts.assertNoTerminalEvent();
        return this;
    }

    public TestSubscriber2<T> assertNoValues() {
        this.ts.assertNoValues();
        return this;
    }

    public TestSubscriber2<T> assertValueCount(int count) {
        this.ts.assertValueCount(count);
        return this;
    }

    public TestSubscriber2<T> assertValues(T ... values) {
        this.ts.assertValues((Object[])values);
        return this;
    }

    public TestSubscriber2<T> assertValue(T value) {
        this.ts.assertValue(value);
        return this;
    }

    public final TestSubscriber2<T> assertValuesAndClear(T expectedFirstValue, T ... expectedRestValues) {
        this.ts.assertValuesAndClear(expectedFirstValue, (Object[])expectedRestValues);
        return this;
    }

    public final TestSubscriber2<T> perform(Action0 action) {
        action.call();
        return this;
    }

    public TestSubscriber2<T> assertValuesSet(T ... values) {
        Assert.assertEquals(new HashSet<T>(Arrays.asList(values)), new HashSet(this.ts.getOnNextEvents()));
        return this;
    }
}

