/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.cosmosdb.rx.internal.query;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.github.davidmoten.rx.Transformers;
import com.microsoft.azure.cosmosdb.QueryMetrics;
import com.microsoft.azure.cosmosdb.Resource;
import com.microsoft.azure.cosmosdb.internal.RequestChargeTracker;
import com.microsoft.azure.cosmosdb.internal.ResourceId;
import com.microsoft.azure.cosmosdb.internal.query.ItemComparator;
import com.microsoft.azure.cosmosdb.internal.query.QueryItem;
import com.microsoft.azure.cosmosdb.internal.query.SortOrder;
import com.microsoft.azure.cosmosdb.internal.query.orderbyquery.OrderByRowResult;
import com.microsoft.azure.cosmosdb.internal.query.orderbyquery.OrderbyRowComparer;
import com.microsoft.azure.cosmosdb.rx.internal.BadRequestException;
import com.microsoft.azure.cosmosdb.rx.internal.query.DocumentProducer;
import com.microsoft.azure.cosmosdb.rx.internal.query.OrderByContinuationToken;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.Pair;
import rx.Observable;

class OrderByUtils {
    OrderByUtils() {
    }

    public static <T extends Resource> Observable<OrderByRowResult<T>> orderedMerge(Class<T> klass, OrderbyRowComparer<T> consumeComparer, RequestChargeTracker tracker, List<DocumentProducer<T>> documentProducers, Map<String, QueryMetrics> queryMetricsMap, Map<String, OrderByContinuationToken> targetRangeToOrderByContinuationTokenMap) {
        return OrderByUtils.toOrderByQueryResultObservable(klass, documentProducers.get(0), tracker, queryMetricsMap, targetRangeToOrderByContinuationTokenMap, consumeComparer.getSortOrders()).compose(Transformers.orderedMergeWith((Collection)documentProducers.subList(1, documentProducers.size()).stream().map(producer -> OrderByUtils.toOrderByQueryResultObservable(klass, producer, tracker, queryMetricsMap, targetRangeToOrderByContinuationTokenMap, consumeComparer.getSortOrders())).collect(Collectors.toList()), consumeComparer, (boolean)false, (int)1));
    }

    private static <T extends Resource> Observable<OrderByRowResult<T>> toOrderByQueryResultObservable(Class<T> klass, DocumentProducer<T> producer, RequestChargeTracker tracker, Map<String, QueryMetrics> queryMetricsMap, Map<String, OrderByContinuationToken> targetRangeToOrderByContinuationTokenMap, List<SortOrder> sortOrders) {
        return producer.produceAsync().compose(new PageToItemTransformer<T>(klass, tracker, queryMetricsMap, targetRangeToOrderByContinuationTokenMap, sortOrders));
    }

    private static class PageToItemTransformer<T extends Resource>
    implements Observable.Transformer<DocumentProducer.DocumentProducerFeedResponse, OrderByRowResult<T>> {
        private final RequestChargeTracker tracker;
        private final Class<T> klass;
        private final Map<String, QueryMetrics> queryMetricsMap;
        private final Map<String, OrderByContinuationToken> targetRangeToOrderByContinuationTokenMap;
        private final List<SortOrder> sortOrders;

        public PageToItemTransformer(Class<T> klass, RequestChargeTracker tracker, Map<String, QueryMetrics> queryMetricsMap, Map<String, OrderByContinuationToken> targetRangeToOrderByContinuationTokenMap, List<SortOrder> sortOrders) {
            this.klass = klass;
            this.tracker = tracker;
            this.queryMetricsMap = queryMetricsMap;
            this.targetRangeToOrderByContinuationTokenMap = targetRangeToOrderByContinuationTokenMap;
            this.sortOrders = sortOrders;
        }

        public Observable<OrderByRowResult<T>> call(Observable<DocumentProducer.DocumentProducerFeedResponse> source) {
            return source.flatMap(documentProducerFeedResponse -> {
                for (String key : documentProducerFeedResponse.pageResult.getQueryMetrics().keySet()) {
                    if (this.queryMetricsMap.containsKey(key)) {
                        QueryMetrics qm = (QueryMetrics)documentProducerFeedResponse.pageResult.getQueryMetrics().get(key);
                        this.queryMetricsMap.get(key).add(new QueryMetrics[]{qm});
                        continue;
                    }
                    this.queryMetricsMap.put(key, (QueryMetrics)documentProducerFeedResponse.pageResult.getQueryMetrics().get(key));
                }
                List results = documentProducerFeedResponse.pageResult.getResults();
                OrderByContinuationToken orderByContinuationToken = this.targetRangeToOrderByContinuationTokenMap.get(documentProducerFeedResponse.sourcePartitionKeyRange.getId());
                if (orderByContinuationToken != null) {
                    Pair booleanResourceIdPair = ResourceId.tryParse((String)orderByContinuationToken.getRid());
                    if (!((Boolean)booleanResourceIdPair.getLeft()).booleanValue()) {
                        return Observable.error((Throwable)new BadRequestException(String.format("Invalid Rid in the continuation token %s for OrderBy~Context.", orderByContinuationToken.getCompositeContinuationToken().getToken())));
                    }
                    ResourceId continuationTokenRid = (ResourceId)booleanResourceIdPair.getRight();
                    results = results.stream().filter(tOrderByRowResult -> {
                        ArrayList<QueryItem> queryItems = new ArrayList<QueryItem>();
                        ArrayNode arrayNode = (ArrayNode)tOrderByRowResult.get("orderByItems");
                        for (JsonNode jsonNode : arrayNode) {
                            QueryItem queryItem = new QueryItem(jsonNode.toString());
                            queryItems.add(queryItem);
                        }
                        long cmp = 0L;
                        for (int i = 0; i < this.sortOrders.size(); ++i) {
                            cmp = ItemComparator.getInstance().compare(orderByContinuationToken.getOrderByItems()[i].getItem(), ((QueryItem)((Object)((Object)((Object)queryItems.get(i))))).getItem());
                            if (cmp == 0L) continue;
                            cmp = this.sortOrders.get(i).equals((Object)SortOrder.Descending) ? -cmp : cmp;
                            break;
                        }
                        if (cmp == 0L) {
                            cmp = continuationTokenRid.getDocument() - ((ResourceId)ResourceId.tryParse((String)tOrderByRowResult.getResourceId()).getRight()).getDocument();
                            if (this.sortOrders.iterator().next().equals((Object)SortOrder.Descending)) {
                                cmp = -cmp;
                            }
                            return cmp <= 0L;
                        }
                        return true;
                    }).collect(Collectors.toList());
                }
                this.tracker.addCharge(documentProducerFeedResponse.pageResult.getRequestCharge());
                Observable x = Observable.from((Iterable)results);
                return x.map(r -> new OrderByRowResult<T>(this.klass, r.toJson(), documentProducerFeedResponse.sourcePartitionKeyRange, documentProducerFeedResponse.pageResult.getResponseContinuation()));
            }, 1);
        }
    }
}

