/*
 * Decompiled with CFR 0.152.
 */
package com.xk72.proxy.websocket;

import java.io.Serializable;
import java.util.Date;

public class WebSocketFrame
implements Serializable {
    private static final long serialVersionUID = 0L;
    private final byte[] header;
    private final byte[] payload;
    private final Date start;
    private final Date end;

    public WebSocketFrame(Date date, Date date2, byte[] byArray, byte[] byArray2) {
        this.start = date;
        this.end = date2;
        this.header = byArray;
        this.payload = byArray2;
    }

    public Date getStart() {
        return this.start;
    }

    public Date getEnd() {
        return this.end;
    }

    public boolean isFin() {
        return (this.header[0] & 0x80) != 0;
    }

    public boolean isRSV1() {
        return (this.header[0] & 0x40) != 0;
    }

    public boolean isRSV2() {
        return (this.header[0] & 0x20) != 0;
    }

    public boolean isRSV3() {
        return (this.header[0] & 0x10) != 0;
    }

    public int getOpcode() {
        return this.header[0] & 0xF;
    }

    public boolean isMasked() {
        return (this.header[1] & 0x80) != 0;
    }

    public byte[] getMask() {
        if (this.isMasked()) {
            byte[] byArray = new byte[4];
            System.arraycopy(this.header, this.header.length - 4, byArray, 0, 4);
            return byArray;
        }
        return null;
    }

    public byte[] getHeader() {
        return this.header;
    }

    public byte[] getPayload() {
        return this.payload;
    }
}

