/*
 * Decompiled with CFR 0.152.
 */
package com.xk72.charles.lib;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;

public class SortedArrayList<E>
extends ArrayList<E> {
    private static final long serialVersionUID = -1625652366555197719L;
    private final Comparator<E> comparator;

    public SortedArrayList(Comparator<E> comparator) {
        this.comparator = comparator;
    }

    public Comparator<E> getComparator() {
        return this.comparator;
    }

    @Override
    public boolean add(E e) {
        this.addSorted(e);
        return true;
    }

    @Override
    public boolean addAll(Collection<? extends E> collection) {
        boolean bl = super.addAll(collection);
        if (bl) {
            Collections.sort(this, this.comparator);
        }
        return bl;
    }

    public int addSorted(E e) {
        int n = this.AmNw(e, false);
        this.add(n, e);
        return n;
    }

    public int addSortedIfAbsent(E e) {
        int n = this.AmNw(e, false);
        int n2 = this.AmNw(e, 0, this.size(), n);
        if (n2 < 0) {
            this.add(n, e);
            return n;
        }
        return -1;
    }

    @Override
    public boolean remove(Object object) {
        return this.remove(this.indexOf(object)) != null;
    }

    public int removeSorted(Object object) {
        int n = this.indexOf(object);
        if (n != -1) {
            this.remove(n);
            return n;
        }
        return -1;
    }

    @Override
    public int indexOf(Object object) {
        return this.AmNw(object, true);
    }

    private int AmNw(E e, boolean bl) {
        int n = 0;
        int n2 = this.size();
        if (!bl && n2 > 0 && this.comparator.compare(e, this.get(n2 - 1)) >= 0) {
            return n2;
        }
        while (n < n2) {
            int n3 = n + (n2 - n) / 2;
            Object e2 = this.get(n3);
            int n4 = this.comparator.compare(e, e2);
            if (n4 < 0) {
                n2 = n3;
                continue;
            }
            if (n4 > 0) {
                n = n3 + 1;
                continue;
            }
            if (bl) {
                return this.AmNw(e, n, n2, n3);
            }
            return n3;
        }
        if (bl) {
            return -1;
        }
        return n;
    }

    private int AmNw(E e, int n, int n2, int n3) {
        Object e2;
        int n4;
        if (n3 >= n && n3 < n2 && e.equals(this.get(n3))) {
            return n3;
        }
        for (n4 = n3 + 1; n4 < n2 && this.comparator.compare(e, e2 = this.get(n4)) == 0; ++n4) {
            if (!e.equals(e2)) continue;
            return n4;
        }
        for (n4 = n3 - 1; n4 >= n && this.comparator.compare(e, e2 = this.get(n4)) == 0; --n4) {
            if (!e.equals(e2)) continue;
            return n4;
        }
        return -1;
    }
}

