/*
 * Decompiled with CFR 0.152.
 */
package com.google.protobuf;

import com.google.protobuf.ByteString;
import com.google.protobuf.Descriptors;
import com.google.protobuf.TextFormat;
import java.io.IOException;

public class FzFK {
    public static String AmNw(Descriptors.FieldDescriptor fieldDescriptor, Object object) {
        if (fieldDescriptor.getType() == Descriptors.FieldDescriptor.Type.ENUM && ((Descriptors.EnumValueDescriptor)object).getIndex() < 0) {
            return String.valueOf(((Descriptors.EnumValueDescriptor)object).getNumber());
        }
        StringBuffer stringBuffer = new StringBuffer();
        try {
            TextFormat.printer().printFieldValue(fieldDescriptor, object, (Appendable)stringBuffer);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if ((fieldDescriptor.getType() == Descriptors.FieldDescriptor.Type.STRING || fieldDescriptor.getType() == Descriptors.FieldDescriptor.Type.BYTES) && stringBuffer.length() > 1 && stringBuffer.charAt(0) == '\"' && stringBuffer.charAt(stringBuffer.length() - 1) == '\"') {
            return stringBuffer.substring(1, stringBuffer.length() - 1);
        }
        return stringBuffer.toString();
    }

    public static Object AmNw(Descriptors.FieldDescriptor fieldDescriptor) {
        switch (fieldDescriptor.getJavaType()) {
            case ENUM: {
                return fieldDescriptor.getEnumType().getValues().get(0);
            }
            case INT: {
                return 0;
            }
            case LONG: {
                return 0L;
            }
            case FLOAT: {
                return Float.valueOf(0.0f);
            }
            case DOUBLE: {
                return 0.0;
            }
            case BOOLEAN: {
                return Boolean.FALSE;
            }
            case STRING: {
                return "";
            }
            case BYTE_STRING: {
                return ByteString.EMPTY;
            }
        }
        throw new IllegalArgumentException();
    }

    public static Object AmNw(Descriptors.FieldDescriptor fieldDescriptor, String string) {
        switch (fieldDescriptor.getType()) {
            case INT32: 
            case SINT32: 
            case SFIXED32: {
                return TextFormat.parseInt32((String)string);
            }
            case UINT32: 
            case FIXED32: {
                return TextFormat.parseUInt32((String)string);
            }
            case INT64: 
            case SINT64: 
            case SFIXED64: {
                return TextFormat.parseInt64((String)string);
            }
            case UINT64: 
            case FIXED64: {
                return TextFormat.parseUInt64((String)string);
            }
            case FLOAT: {
                if (string.equals("inf")) {
                    return Float.valueOf(Float.POSITIVE_INFINITY);
                }
                if (string.equals("-inf")) {
                    return Float.valueOf(Float.NEGATIVE_INFINITY);
                }
                if (string.equals("nan")) {
                    return Float.valueOf(Float.NaN);
                }
                return Float.valueOf(string);
            }
            case DOUBLE: {
                if (string.equals("inf")) {
                    return Double.POSITIVE_INFINITY;
                }
                if (string.equals("-inf")) {
                    return Double.NEGATIVE_INFINITY;
                }
                if (string.equals("nan")) {
                    return Double.NaN;
                }
                return Double.valueOf(string);
            }
            case BOOL: {
                return Boolean.valueOf(string);
            }
            case STRING: {
                try {
                    return TextFormat.unescapeText((String)string);
                }
                catch (TextFormat.InvalidEscapeSequenceException invalidEscapeSequenceException) {
                    throw new RuntimeException(invalidEscapeSequenceException);
                }
            }
            case BYTES: {
                try {
                    return TextFormat.unescapeBytes((CharSequence)string);
                }
                catch (TextFormat.InvalidEscapeSequenceException invalidEscapeSequenceException) {
                    throw new RuntimeException(invalidEscapeSequenceException);
                }
            }
            case ENUM: {
                Descriptors.EnumValueDescriptor enumValueDescriptor = fieldDescriptor.getEnumType().findValueByName(string);
                if (enumValueDescriptor == null && fieldDescriptor.getFile().supportsUnknownEnumValue()) {
                    try {
                        int n = Integer.parseInt(string);
                        enumValueDescriptor = fieldDescriptor.getEnumType().findValueByNumberCreatingIfUnknown(n);
                    }
                    catch (RuntimeException runtimeException) {
                        // empty catch block
                    }
                }
                if (enumValueDescriptor == null) {
                    throw new RuntimeException("Unknown enum value: \"" + string + "\"");
                }
                return enumValueDescriptor;
            }
        }
        throw new RuntimeException("Shouldn't get here.");
    }
}

