/*
 * Decompiled with CFR 0.152.
 */
package org.bounce.text.xml;

import java.io.IOException;
import javax.swing.text.Document;
import org.bounce.text.DocumentInputReader;
import org.bounce.text.SyntaxHighlightingScanner;
import org.bounce.xml.XMLChar;

public class XMLScanner
extends SyntaxHighlightingScanner {
    private Scanner tagScanner = null;
    private final AttributeScanner ATTRIBUTE_SCANNER = new AttributeScanner();
    private final AttributeNameScanner ATTRIBUTE_NAME_SCANNER = new AttributeNameScanner();
    private final AttributeValueScanner ATTRIBUTE_VALUE_SCANNER = new AttributeValueScanner("attribute-value");
    private final AttributeValueScanner NAMESPACE_VALUE_SCANNER = new AttributeValueScanner("namespace-value");
    private final EntityReferenceScanner ENTITY_REFERENCE_SCANNER = new EntityReferenceScanner();
    private final WhitespaceScanner WHITESPACE_SCANNER = new WhitespaceScanner();
    private final ElementEndScanner ELEMENT_END_SCANNER = new ElementEndScanner();
    private final TagEndScanner TAG_END_SCANNER = new TagEndScanner();
    private final ElementStartScanner ELEMENT_START_SCANNER = new ElementStartScanner();
    private final ElementNameScanner ELEMENT_NAME_SCANNER = new ElementNameScanner();
    private final ContentScanner CONTENT_SCANNER = new ContentScanner();
    private final EntityTagScanner ENTITY_TAG_SCANNER = new EntityTagScanner();
    private final CommentScanner COMMENT_SCANNER = new CommentScanner();
    private final CDATAScanner CDATA_SCANNER = new CDATAScanner();
    private final TagScanner TAG_SCANNER = new TagScanner();

    public XMLScanner(Document document) throws IOException {
        super(document);
    }

    public int getEventType() {
        if (this.tagScanner == this.TAG_SCANNER) {
            if (this.TAG_SCANNER.scanner == this.ELEMENT_START_SCANNER) {
                if (this.ELEMENT_START_SCANNER.scanner == this.TAG_END_SCANNER && this.TAG_END_SCANNER.emptyElement) {
                    return 2;
                }
                return 1;
            }
            if (this.TAG_SCANNER.scanner == this.ELEMENT_END_SCANNER) {
                return 2;
            }
            if (this.TAG_SCANNER.scanner == this.COMMENT_SCANNER) {
                return 5;
            }
            if (this.TAG_SCANNER.scanner == this.CDATA_SCANNER) {
                return 12;
            }
        } else if (this.tagScanner == this.CONTENT_SCANNER) {
            return 4;
        }
        if (this.getStartOffset() == 0) {
            return 7;
        }
        return 8;
    }

    public int getNextTag() throws IOException {
        do {
            this.scan();
            if (this.token == "element-name") {
                return this.getEventType();
            }
            if (this.tagScanner != this.TAG_SCANNER || this.TAG_SCANNER.scanner != this.ELEMENT_START_SCANNER || this.ELEMENT_START_SCANNER.scanner != this.TAG_END_SCANNER || !this.TAG_END_SCANNER.emptyElement) continue;
            return 2;
        } while (this.in.getLastChar() != -1);
        return this.getEventType();
    }

    @Override
    public void setRange(int start, int end) throws IOException {
        this.tagScanner = null;
        super.setRange(start, end);
    }

    @Override
    public long scan() throws IOException {
        long l;
        block7: {
            int character = this.in.getLastChar();
            if (this.error && (character == 60 || character == -1)) {
                this.tagScanner = null;
                this.token = null;
            }
            this.error = false;
            if (this.tagScanner != null && this.tagScanner.isFinished()) {
                this.tagScanner = null;
                this.token = null;
            }
            l = this.pos;
            this.pos = this.in.pos;
            while (true) {
                if (this.tagScanner != null) {
                    this.token = this.tagScanner.scan(this.in);
                    character = this.in.getLastChar();
                    if (this.getEndOffset() <= this.getStartOffset() && character != -1) {
                        if (character != 60) continue;
                        character = this.in.read();
                        continue;
                    }
                    break block7;
                }
                if (character == 60) {
                    character = this.in.read();
                    this.tagScanner = this.TAG_SCANNER;
                    this.tagScanner.reset();
                    continue;
                }
                if (!XMLScanner.isContent(character) && character != 38) break;
                this.tagScanner = this.CONTENT_SCANNER;
                this.tagScanner.reset();
            }
            this.token = null;
            this.error = true;
        }
        if (this.error && this.in.getLastChar() == -1 && this.getStartOffset() == this.getEndOffset()) {
            this.token = null;
            this.tagScanner = null;
        }
        return l;
    }

    private static boolean isNameStart(int character) {
        if (character == -1 || character == 58) {
            return false;
        }
        return XMLChar.isNameStart(character);
    }

    private static boolean isName(int character) {
        if (character == -1 || character == 58) {
            return false;
        }
        return XMLChar.isName(character);
    }

    private static boolean isCharacterRef(int character, boolean hex) {
        if (character == -1) {
            return false;
        }
        if (character > 48 && character < 57) {
            return true;
        }
        return hex && (character == 97 || character == 65 || character == 98 || character == 66 || character == 99 || character == 67 || character == 100 || character == 68 || character == 101 || character == 69 || character == 102 || character == 70);
    }

    private static boolean isSpace(int character) {
        if (character == -1) {
            return false;
        }
        return XMLChar.isSpace(character);
    }

    private static boolean isContent(int character) {
        if (character == -1) {
            return false;
        }
        if (XMLChar.isContent(character)) {
            return true;
        }
        if (character == 93) {
            return true;
        }
        return XMLChar.isSpace(character);
    }

    abstract class Scanner {
        private boolean finished = false;

        Scanner() {
        }

        public abstract String scan(DocumentInputReader var1) throws IOException;

        protected void finished() {
            this.finished = true;
        }

        public boolean isFinished() {
            return this.finished;
        }

        public void reset() {
            this.finished = false;
        }
    }

    private class EntityReferenceScanner
    extends Scanner {
        private boolean characterReference = false;
        private boolean hexadecimal = false;

        private EntityReferenceScanner() {
        }

        @Override
        public String scan(DocumentInputReader in) throws IOException {
            int character = in.read();
            if (XMLScanner.isNameStart(character)) {
                character = in.read();
            } else if (character == 35) {
                character = in.read();
                this.characterReference = true;
                if (character == 120) {
                    character = in.read();
                    this.hexadecimal = true;
                }
            } else {
                XMLScanner.this.error = true;
                if (character == 60 || character == -1) {
                    this.finished();
                    return "EntityReference";
                }
                character = in.read();
            }
            while (true) {
                if (this.characterReference && XMLScanner.isCharacterRef(character, this.hexadecimal)) {
                    character = in.read();
                    continue;
                }
                if (!this.characterReference && XMLScanner.isName(character)) {
                    character = in.read();
                    continue;
                }
                if (character == 59) {
                    character = in.read();
                    this.finished();
                    return "EntityReference";
                }
                XMLScanner.this.error = true;
                if (character == 60 || character == -1) {
                    this.finished();
                    return "EntityReference";
                }
                character = in.read();
            }
        }

        @Override
        public void reset() {
            super.reset();
            this.characterReference = false;
            this.hexadecimal = false;
        }
    }

    private class ContentScanner
    extends Scanner {
        private Scanner scanner = null;

        private ContentScanner() {
        }

        @Override
        public String scan(DocumentInputReader in) throws IOException {
            if (this.scanner != null && !this.scanner.isFinished()) {
                return this.scanner.scan(in);
            }
            int character = in.getLastChar();
            while (true) {
                if (XMLScanner.isContent(character)) {
                    character = in.read();
                    continue;
                }
                if (character == 38) {
                    this.scanner = XMLScanner.this.ENTITY_REFERENCE_SCANNER;
                    this.scanner.reset();
                    return "element-value";
                }
                if (character == 60 || character == -1) {
                    this.finished();
                    return "element-value";
                }
                XMLScanner.this.error = true;
                if (character == 60 || character == -1) {
                    this.finished();
                    return "element-value";
                }
                character = in.read();
            }
        }

        @Override
        public void reset() {
            super.reset();
        }
    }

    private class AttributeValueScanner
    extends Scanner {
        private Scanner scanner = null;
        private String style = null;
        private int start = -1;

        public AttributeValueScanner(String style) {
            this.style = style;
        }

        @Override
        public String scan(DocumentInputReader in) throws IOException {
            if (this.scanner != null && !this.scanner.isFinished()) {
                return this.scanner.scan(in);
            }
            int character = in.getLastChar();
            if (this.start == -1) {
                this.start = character;
                character = in.read();
            }
            while (true) {
                if (character == this.start) {
                    character = in.read();
                    this.finished();
                    return this.style;
                }
                if (XMLScanner.isContent(character)) {
                    character = in.read();
                    continue;
                }
                if (character == 38) {
                    this.scanner = XMLScanner.this.ENTITY_REFERENCE_SCANNER;
                    this.scanner.reset();
                    return this.style;
                }
                XMLScanner.this.error = true;
                if (character == 60 || character == -1) {
                    this.finished();
                    return this.style;
                }
                character = in.read();
            }
        }

        @Override
        public void reset() {
            super.reset();
            this.start = -1;
        }
    }

    private class AttributeNameScanner
    extends Scanner {
        private boolean prefix = false;
        private boolean firstTime = true;
        private boolean namespace = false;
        private boolean nameStart = false;

        private AttributeNameScanner() {
        }

        @Override
        public String scan(DocumentInputReader in) throws IOException {
            int character = in.getLastChar();
            if (this.firstTime) {
                this.firstTime = false;
                if (XMLScanner.isNameStart(character)) {
                    if (character == 120 && (character = in.read()) == 109 && (character = in.read()) == 108 && (character = in.read()) == 110 && (character = in.read()) == 115) {
                        character = in.read();
                        this.namespace = true;
                    }
                } else {
                    XMLScanner.this.error = true;
                    if (character == 60 || character == -1) {
                        this.finished();
                        return "attribute-name";
                    }
                    character = in.read();
                }
            }
            while (true) {
                if (this.nameStart) {
                    this.nameStart = false;
                    if (XMLScanner.isNameStart(character)) {
                        character = in.read();
                        continue;
                    }
                    XMLScanner.this.error = true;
                    if (character == 60 || character == -1) {
                        this.finished();
                        if (this.namespace && this.prefix) {
                            return "namespace-prefix";
                        }
                        if (this.namespace) {
                            return "namespace-name";
                        }
                        return "attribute-name";
                    }
                    character = in.read();
                    continue;
                }
                if (character == 58) {
                    if (this.prefix) {
                        character = in.read();
                        this.nameStart = true;
                        return "Special";
                    }
                    if (this.namespace) {
                        this.prefix = true;
                        return "namespace-name";
                    }
                    this.prefix = true;
                    return "attribute-prefix";
                }
                if (XMLScanner.isSpace(character) || character == 61) {
                    this.finished();
                    if (this.namespace && this.prefix) {
                        return "namespace-prefix";
                    }
                    if (this.namespace) {
                        return "namespace-name";
                    }
                    return "attribute-name";
                }
                if (XMLScanner.isName(character)) {
                    character = in.read();
                    continue;
                }
                XMLScanner.this.error = true;
                if (character == 60 || character == -1) {
                    this.finished();
                    if (this.namespace && this.prefix) {
                        return "namespace-prefix";
                    }
                    if (this.namespace) {
                        return "namespace-name";
                    }
                    return "attribute-name";
                }
                character = in.read();
            }
        }

        @Override
        public void reset() {
            super.reset();
            this.prefix = false;
            this.firstTime = true;
            this.namespace = false;
            this.nameStart = false;
        }
    }

    private class AttributeScanner
    extends Scanner {
        private Scanner scanner;
        boolean foundEquals;

        private AttributeScanner() {
            this.scanner = XMLScanner.this.ATTRIBUTE_NAME_SCANNER;
            this.foundEquals = false;
        }

        @Override
        public String scan(DocumentInputReader in) throws IOException {
            String token = null;
            int ch = in.getLastChar();
            if (ch == 61) {
                in.read();
                this.foundEquals = true;
                token = "Special";
            } else {
                token = this.scanner.scan(in);
            }
            if (this.scanner.isFinished()) {
                if (this.scanner == XMLScanner.this.ATTRIBUTE_VALUE_SCANNER || this.scanner == XMLScanner.this.NAMESPACE_VALUE_SCANNER) {
                    this.finished();
                } else {
                    ch = in.getLastChar();
                    if (XMLScanner.isSpace((char)ch)) {
                        this.scanner = XMLScanner.this.WHITESPACE_SCANNER;
                        this.scanner.reset();
                    } else if (ch == 39 || ch == 34) {
                        this.scanner = XMLScanner.this.ATTRIBUTE_NAME_SCANNER.namespace ? XMLScanner.this.NAMESPACE_VALUE_SCANNER : XMLScanner.this.ATTRIBUTE_VALUE_SCANNER;
                        this.scanner.reset();
                        if (!this.foundEquals) {
                            XMLScanner.this.error = true;
                        }
                    } else if (ch != 61) {
                        XMLScanner.this.error = true;
                        this.finished();
                    }
                }
            }
            return token;
        }

        @Override
        public void reset() {
            super.reset();
            this.foundEquals = false;
            this.scanner = XMLScanner.this.ATTRIBUTE_NAME_SCANNER;
            this.scanner.reset();
        }
    }

    private class TagEndScanner
    extends Scanner {
        boolean emptyElement = false;

        private TagEndScanner() {
        }

        @Override
        public String scan(DocumentInputReader in) throws IOException {
            int character = in.getLastChar();
            while (true) {
                if (character == 47) {
                    this.emptyElement = true;
                    character = in.read();
                    continue;
                }
                if (character == 62) {
                    character = in.read();
                    this.finished();
                    return "Special";
                }
                if (character == 60 || character == -1) {
                    this.finished();
                    return "Special";
                }
                character = in.read();
                XMLScanner.this.error = true;
            }
        }

        @Override
        public void reset() {
            super.reset();
            this.emptyElement = false;
        }
    }

    private class ElementNameScanner
    extends Scanner {
        private boolean prefix = false;
        private boolean first = true;
        private boolean nameStart = false;

        private ElementNameScanner() {
        }

        @Override
        public String scan(DocumentInputReader in) throws IOException {
            int character = in.getLastChar();
            if (this.first) {
                this.first = false;
                if (!XMLScanner.isNameStart(character)) {
                    XMLScanner.this.error = true;
                    if (character == 60 || character == -1) {
                        this.finished();
                        return "element-name";
                    }
                }
                character = in.read();
            }
            while (true) {
                if (this.nameStart) {
                    this.nameStart = false;
                    if (XMLScanner.isNameStart(character)) {
                        character = in.read();
                        continue;
                    }
                    XMLScanner.this.error = true;
                    if (character == 60 || character == -1) {
                        this.finished();
                        return "element-name";
                    }
                    character = in.read();
                    continue;
                }
                if (character == 58) {
                    if (this.prefix) {
                        character = in.read();
                        this.nameStart = true;
                        return "Special";
                    }
                    this.prefix = true;
                    return "element-prefix";
                }
                if (XMLScanner.isName(character)) {
                    character = in.read();
                    continue;
                }
                if (XMLScanner.isSpace(character) || character == 47 || character == 62) {
                    this.finished();
                    return "element-name";
                }
                XMLScanner.this.error = true;
                if (character == 60 || character == -1) {
                    this.finished();
                    return "element-name";
                }
                character = in.read();
            }
        }

        @Override
        public void reset() {
            super.reset();
            this.prefix = false;
            this.first = true;
            this.nameStart = false;
        }
    }

    private class WhitespaceScanner
    extends Scanner {
        private WhitespaceScanner() {
        }

        @Override
        public String scan(DocumentInputReader in) throws IOException {
            while (XMLScanner.isSpace((char)in.read())) {
            }
            this.finished();
            return "Whitespace";
        }
    }

    private class ElementStartScanner
    extends Scanner {
        private Scanner scanner;

        private ElementStartScanner() {
            this.scanner = XMLScanner.this.ELEMENT_NAME_SCANNER;
        }

        @Override
        public String scan(DocumentInputReader in) throws IOException {
            String token = this.scanner.scan(in);
            if (this.scanner.isFinished()) {
                if (this.scanner == XMLScanner.this.TAG_END_SCANNER) {
                    this.finished();
                } else {
                    int ch = in.getLastChar();
                    if (ch == 47 || ch == 62) {
                        this.scanner = XMLScanner.this.TAG_END_SCANNER;
                        this.scanner.reset();
                    } else if (XMLScanner.isSpace((char)ch)) {
                        this.scanner = XMLScanner.this.WHITESPACE_SCANNER;
                        this.scanner.reset();
                    } else if (ch == 60) {
                        XMLScanner.this.error = true;
                        this.finished();
                    } else {
                        this.scanner = XMLScanner.this.ATTRIBUTE_SCANNER;
                        this.scanner.reset();
                    }
                }
            }
            return token;
        }

        @Override
        public void reset() {
            super.reset();
            this.scanner = XMLScanner.this.ELEMENT_NAME_SCANNER;
            this.scanner.reset();
        }
    }

    private class ElementEndScanner
    extends Scanner {
        private Scanner scanner;

        private ElementEndScanner() {
            this.scanner = XMLScanner.this.ELEMENT_NAME_SCANNER;
        }

        @Override
        public String scan(DocumentInputReader in) throws IOException {
            String token = this.scanner.scan(in);
            if (this.scanner.isFinished()) {
                if (this.scanner == XMLScanner.this.TAG_END_SCANNER) {
                    this.finished();
                } else {
                    int character = in.getLastChar();
                    if (character == 62) {
                        this.scanner = XMLScanner.this.TAG_END_SCANNER;
                        this.scanner.reset();
                    } else if (XMLScanner.isSpace((char)character)) {
                        this.scanner = XMLScanner.this.WHITESPACE_SCANNER;
                        this.scanner.reset();
                    } else {
                        XMLScanner.this.error = true;
                        if (character == 60 || character == -1) {
                            this.finished();
                        } else {
                            int n = in.read();
                        }
                    }
                }
            }
            return token;
        }

        @Override
        public void reset() {
            super.reset();
            this.scanner = XMLScanner.this.ELEMENT_NAME_SCANNER;
            this.scanner.reset();
        }
    }

    private class CDATAScanner
    extends Scanner {
        private CDATAScanner() {
        }

        @Override
        public String scan(DocumentInputReader in) throws IOException {
            int character = in.read();
            block4: while (true) {
                switch (character) {
                    case -1: {
                        this.finished();
                        return "CDATA";
                    }
                    case 93: {
                        character = in.read();
                        if (character != 93 || (character = in.read()) != 62) continue block4;
                        character = in.read();
                        this.finished();
                        XMLScanner.this.tagScanner.finished();
                        return "CDATA";
                    }
                }
                character = in.read();
            }
        }

        @Override
        public void reset() {
            super.reset();
        }
    }

    private class CommentScanner
    extends Scanner {
        private CommentScanner() {
        }

        @Override
        public String scan(DocumentInputReader in) throws IOException {
            int character = in.read();
            block4: while (true) {
                switch (character) {
                    case -1: {
                        this.finished();
                        return "Comment";
                    }
                    case 45: {
                        character = in.read();
                        if (character != 45 || (character = in.read()) != 62) continue block4;
                        character = in.read();
                        this.finished();
                        XMLScanner.this.tagScanner.finished();
                        return "Comment";
                    }
                }
                character = in.read();
            }
        }

        @Override
        public void reset() {
            super.reset();
        }
    }

    private class EntityTagScanner
    extends Scanner {
        private EntityTagScanner() {
        }

        @Override
        public String scan(DocumentInputReader in) throws IOException {
            int character = in.read();
            while (true) {
                switch (character) {
                    case -1: {
                        this.finished();
                        return "Entity";
                    }
                    case 62: {
                        this.finished();
                        return "Entity";
                    }
                }
                character = in.read();
            }
        }

        @Override
        public void reset() {
            super.reset();
        }
    }

    private class TagScanner
    extends Scanner {
        private Scanner scanner = null;

        private TagScanner() {
        }

        @Override
        public boolean isFinished() {
            return this.scanner != null && this.scanner.isFinished();
        }

        @Override
        public String scan(DocumentInputReader in) throws IOException {
            int character;
            if (this.scanner != null) {
                if (this.scanner.isFinished()) {
                    this.scanner = null;
                } else {
                    return this.scanner.scan(in);
                }
            }
            if ((character = in.getLastChar()) == 33) {
                character = in.read();
                if (character == 45 && (character = in.read()) == 45) {
                    character = in.read();
                    this.scanner = XMLScanner.this.COMMENT_SCANNER;
                    this.scanner.reset();
                    return "Comment";
                }
                if (character == 91 && (character = in.read()) == 67 && (character = in.read()) == 68 && (character = in.read()) == 65 && (character = in.read()) == 84 && (character = in.read()) == 65 && (character = in.read()) == 91) {
                    character = in.read();
                    this.scanner = XMLScanner.this.CDATA_SCANNER;
                    this.scanner.reset();
                    return "CDATA";
                }
                if (this.scanner == null) {
                    this.scanner = XMLScanner.this.ENTITY_TAG_SCANNER;
                }
                this.scanner.reset();
                return "Special";
            }
            if (character == 63) {
                character = in.read();
                this.scanner = XMLScanner.this.ENTITY_TAG_SCANNER;
                this.scanner.reset();
                return "Special";
            }
            if (character == 47) {
                character = in.read();
                this.scanner = XMLScanner.this.ELEMENT_END_SCANNER;
                this.scanner.reset();
                return "Special";
            }
            if (character == 62) {
                character = in.read();
                this.finished();
                return "Special";
            }
            if (character == 60) {
                this.scanner = XMLScanner.this.ELEMENT_START_SCANNER;
                this.scanner.reset();
                XMLScanner.this.error = true;
                this.finished();
                return "Special";
            }
            this.scanner = XMLScanner.this.ELEMENT_START_SCANNER;
            this.scanner.reset();
            return "Special";
        }

        @Override
        public void reset() {
            super.reset();
            this.scanner = null;
        }
    }
}

