/*
 * Decompiled with CFR 0.152.
 */
package org.bounce.plaf;

import java.awt.Component;
import java.awt.event.FocusEvent;
import java.awt.event.MouseEvent;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.SwingUtilities;
import javax.swing.plaf.basic.BasicButtonListener;
import org.bounce.QButton;

class BounceButtonListener
extends BasicButtonListener {
    public BounceButtonListener(AbstractButton b) {
        super(b);
    }

    @Override
    public void mousePressed(MouseEvent e) {
        QButton b = (QButton)e.getSource();
        if (!b.isDoubleClick()) {
            super.mousePressed(e);
        } else if (SwingUtilities.isLeftMouseButton(e) && e.getClickCount() == 2) {
            if (b.isDoubleClick() && b.contains(e.getX(), e.getY())) {
                ButtonModel model = b.getModel();
                if (!model.isEnabled()) {
                    return;
                }
                if (!model.isArmed()) {
                    model.setArmed(true);
                }
                model.setPressed(true);
                if (!b.hasFocus()) {
                    b.requestFocus();
                }
            }
        } else if (!b.hasFocus()) {
            b.requestFocus();
        }
    }

    @Override
    public void focusGained(FocusEvent e) {
        Component c = (Component)e.getSource();
        c.repaint();
    }
}

