/*
 * Decompiled with CFR 0.152.
 */
package org.bounce;

import java.awt.AlphaComposite;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.io.Serializable;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.UIManager;
import javax.swing.plaf.UIResource;
import org.bounce.ThreeStateCheckBox;

public class ThreeStateCheckBox2
extends JCheckBox {
    private static final long serialVersionUID = -1842373249474550802L;
    public static final String NOT_SELECTED = "NOT_SELECTED";
    public static final String SELECTED = "SELECTED";
    public static final String DONT_CARE = "DONT_CARE";
    private String state = "DONT_CARE";

    public ThreeStateCheckBox2(String aString) {
        this(aString, DONT_CARE);
    }

    public ThreeStateCheckBox2(String aString, String state) {
        super(aString);
        Icon icon = UIManager.getIcon("CheckBox.icon");
        ThreeStateCheckBoxIcon threeStateCheckBoxIcon = new ThreeStateCheckBoxIcon(icon);
        this.setIcon(threeStateCheckBoxIcon);
        this.setSelected(state);
    }

    public String getSelected() {
        return this.state;
    }

    @Override
    public void setSelected(boolean selected) {
        this.state = selected ? SELECTED : NOT_SELECTED;
        super.setSelected(selected);
    }

    public void setSelected(String state) {
        this.state = state;
        super.setSelected(SELECTED.equals(state) || DONT_CARE.equals(state));
        this.repaint();
    }

    private static class ThreeStateCheckBoxIcon
    implements Icon,
    UIResource,
    Serializable {
        private Icon icon;

        public ThreeStateCheckBoxIcon(Icon icon) {
            this.icon = icon;
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            ThreeStateCheckBox cb = (ThreeStateCheckBox)c;
            if (ThreeStateCheckBox2.DONT_CARE.equals(cb.getSelected())) {
                Graphics2D g2d = (Graphics2D)g;
                Composite composite = g2d.getComposite();
                AlphaComposite alphaComposite = AlphaComposite.getInstance(3, 0.5f);
                g2d.setComposite(alphaComposite);
                this.icon.paintIcon(c, g, x, y);
                g2d.setComposite(composite);
            } else {
                this.icon.paintIcon(c, g, x, y);
            }
        }

        @Override
        public int getIconWidth() {
            return this.icon.getIconWidth();
        }

        @Override
        public int getIconHeight() {
            return this.icon.getIconWidth();
        }
    }
}

