/*
 * Decompiled with CFR 0.152.
 */
package org.bounce;

import java.awt.Component;
import java.awt.Graphics;
import java.io.Serializable;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.metal.MetalLookAndFeel;

public class ThreeStateCheckBox
extends JCheckBox {
    private static final long serialVersionUID = -6262164294612004192L;
    public static final String NOT_SELECTED = "NOT_SELECTED";
    public static final String SELECTED = "SELECTED";
    public static final String DONT_CARE = "DONT_CARE";
    private String state = "DONT_CARE";

    public ThreeStateCheckBox(String aString) {
        this(aString, DONT_CARE);
    }

    public ThreeStateCheckBox(String aString, String state) {
        super(aString, new ThreeStateCheckBoxIcon());
        this.setSelected(state);
    }

    public String getSelected() {
        return this.state;
    }

    @Override
    public void setSelected(boolean selected) {
        this.state = selected ? SELECTED : NOT_SELECTED;
        super.setSelected(selected);
    }

    public void setSelected(String state) {
        this.state = state;
        super.setSelected(state == SELECTED);
        this.repaint();
    }

    private static class ThreeStateCheckBoxIcon
    implements Icon,
    UIResource,
    Serializable {
        private static final long serialVersionUID = -1699947264495219246L;

        private ThreeStateCheckBoxIcon() {
        }

        protected int getControlSize() {
            return 13;
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            ThreeStateCheckBox cb = (ThreeStateCheckBox)c;
            int controlSize = this.getControlSize();
            if (cb.isEnabled()) {
                if (cb.getModel().isPressed() && cb.getModel().isArmed()) {
                    g.setColor(MetalLookAndFeel.getControlShadow());
                    g.fillRect(x, y, controlSize - 1, controlSize - 1);
                    this.drawPressed3DBorder(g, x, y, controlSize, controlSize);
                } else {
                    this.drawFlush3DBorder(g, x, y, controlSize, controlSize);
                }
                g.setColor(MetalLookAndFeel.getControlInfo());
            } else {
                g.setColor(MetalLookAndFeel.getControlShadow());
                g.drawRect(x, y, controlSize - 1, controlSize - 1);
            }
            if (cb.getSelected() == ThreeStateCheckBox.DONT_CARE) {
                this.drawRect(c, g, x, y);
            }
            if (cb.getSelected() == ThreeStateCheckBox.SELECTED) {
                if (cb.isBorderPaintedFlat()) {
                    ++x;
                }
                this.drawCheck(c, g, x, y);
            }
        }

        protected void drawRect(Component c, Graphics g, int x, int y) {
            int controlSize = this.getControlSize();
            g.fillRect(x + 3, y + 3, controlSize - 7, controlSize - 7);
        }

        protected void drawCheck(Component c, Graphics g, int x, int y) {
            int controlSize = this.getControlSize();
            g.fillRect(x + 3, y + 5, 2, controlSize - 8);
            g.drawLine(x + (controlSize - 4), y + 3, x + 5, y + (controlSize - 6));
            g.drawLine(x + (controlSize - 4), y + 4, x + 5, y + (controlSize - 5));
        }

        private void drawFlush3DBorder(Graphics g, int x, int y, int w, int h) {
            g.translate(x, y);
            g.setColor(MetalLookAndFeel.getControlDarkShadow());
            g.drawRect(0, 0, w - 2, h - 2);
            g.setColor(MetalLookAndFeel.getControlHighlight());
            g.drawRect(1, 1, w - 2, h - 2);
            g.setColor(MetalLookAndFeel.getControl());
            g.drawLine(0, h - 1, 1, h - 2);
            g.drawLine(w - 1, 0, w - 2, 1);
            g.translate(-x, -y);
        }

        private void drawPressed3DBorder(Graphics g, int x, int y, int w, int h) {
            g.translate(x, y);
            this.drawFlush3DBorder(g, 0, 0, w, h);
            g.setColor(MetalLookAndFeel.getControlShadow());
            g.drawLine(1, 1, 1, h - 2);
            g.drawLine(1, 1, w - 2, 1);
            g.translate(-x, -y);
        }

        @Override
        public int getIconWidth() {
            return this.getControlSize();
        }

        @Override
        public int getIconHeight() {
            return this.getControlSize();
        }
    }
}

