/*
 * Decompiled with CFR 0.152.
 */
package com.xk72.proxy.http2;

import com.xk72.proxy.http.HttpFields;
import com.xk72.proxy.io.MhBt;
import java.io.ByteArrayOutputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;

public class Http2Fields
extends HttpFields {
    private static final long serialVersionUID = 1L;
    private static final String Zigd = "://";
    public static final String aXgD = ":status";
    public static final String rnqJ = ":method";
    public static final String eLhd = ":scheme";
    public static final String gJOp = ":authority";
    public static final String OBgP = ":path";
    private static final String Dlah = "; ";
    protected Set<String> sensitiveFields = new HashSet<String>();
    private boolean pushPromise = false;
    private transient boolean fUWl = false;

    public static boolean AmNw(String string) {
        return aXgD.equals(string) || rnqJ.equals(string) || eLhd.equals(string) || gJOp.equals(string) || OBgP.equals(string);
    }

    @Override
    public void addField(String string, String string2) {
        super.addField(string.toLowerCase(), string2);
    }

    @Override
    public void reset() {
        super.reset();
    }

    @Override
    public Http2Fields clone() {
        Http2Fields http2Fields = new Http2Fields();
        http2Fields.pushPromise = this.pushPromise;
        http2Fields.fieldNames = new ArrayList(this.fieldNames);
        http2Fields.fieldValues = new ArrayList(this.fieldValues);
        http2Fields.sensitiveFields = new HashSet<String>(this.sensitiveFields);
        return http2Fields;
    }

    public void setPushPromise(boolean bl) {
        this.pushPromise = bl;
    }

    public boolean isPushPromise() {
        return this.pushPromise;
    }

    public void setStatus(int n) {
        if (n < 0) {
            this.removeField(aXgD);
        } else {
            this.setField(aXgD, String.valueOf(n));
        }
    }

    public void setMethod(String string) {
        this.AmNw(rnqJ, string);
    }

    public void setScheme(String string) {
        this.AmNw(eLhd, string);
    }

    public void setAuthority(String string) {
        this.AmNw(gJOp, string);
    }

    @Override
    public String getHost() {
        return this.getField(gJOp);
    }

    @Override
    public void setHost(String string) {
        this.setAuthority(string);
    }

    @Override
    public String getCookies() {
        String[] stringArray = this.getFieldValues("Cookie");
        if (stringArray == null) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = true;
        for (String string : stringArray) {
            if (bl) {
                bl = false;
            } else {
                stringBuilder.append(Dlah);
            }
            stringBuilder.append(string);
        }
        return stringBuilder.toString();
    }

    @Override
    public void setCookies(String string) {
        this.removeField("Cookie");
        if (string != null) {
            for (String string2 : string.split(";")) {
                this.addField("Cookie".toLowerCase(), string2.trim());
            }
        }
    }

    public void setPath(String string) {
        this.AmNw(OBgP, string);
    }

    private void AmNw(String string, String string2) {
        if (string2 == null) {
            this.removeField(string);
        } else {
            this.setField(string, string2);
        }
    }

    @Override
    public String getFirstLine() {
        int n = this.getResponseStatus();
        if (n >= 0) {
            return "HTTP/2.0 " + n;
        }
        String string = this.getField(rnqJ);
        if (string == null) {
            return null;
        }
        return string + " " + this.AmNw(this.fUWl) + " HTTP/2.0";
    }

    public String getDisplayString() {
        int n = this.getResponseStatus();
        if (n >= 0) {
            return "HTTP/2.0 " + n;
        }
        String string = this.getField(rnqJ);
        if (string == null) {
            return "<empty>";
        }
        return string + " " + this.getRequestString() + " HTTP/2.0";
    }

    @Override
    public void setFirstLine(String string) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getRequestMethod() {
        return this.getField(rnqJ);
    }

    @Override
    public String getRequestString() {
        return this.AmNw(true);
    }

    private String AmNw(boolean bl) {
        String string = this.getField(eLhd);
        String string2 = this.getField(gJOp);
        String string3 = this.getField(OBgP);
        if (string2 == null || "*".equals(string3)) {
            return string3;
        }
        if (string == null && string3 == null) {
            return string2;
        }
        if (bl) {
            return string + Zigd + string2 + string3;
        }
        return string3;
    }

    @Override
    public String getRequestProtocolVersion() {
        return "HTTP/2.0";
    }

    @Override
    public String getResponseProtocolVersion() {
        return "HTTP/2.0";
    }

    @Override
    public int getResponseStatus() {
        String string = this.getField(aXgD);
        if (string == null) {
            return -1;
        }
        try {
            return Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            return -1;
        }
    }

    @Override
    public String getResponseStatusDescription() {
        return null;
    }

    @Override
    public void setResponseStatus(String string, int n, String string2) {
        this.setStatus(n);
    }

    @Override
    public void setConnect(String string, int n, String string2) {
        this.setMethod("CONNECT");
        this.setAuthority(string + ":" + (n < 0 ? 443 : n));
        this.setScheme(null);
        this.setPath(null);
    }

    @Override
    public void setRequestFields(String string, String string2, String string3, int n, String string4, String string5, boolean bl) {
        this.fUWl = bl;
        this.setMethod(string);
        this.setScheme(string2);
        this.setPath(string4);
        if (bl) {
            this.setAuthority(string3 + (String)(n < 0 ? "" : ":" + n));
        }
    }

    @Override
    public double getHttpVersion() {
        return 2.0;
    }

    public void addField(String string, String string2, boolean bl) {
        super.addField(string, string2);
        if (bl) {
            String string3 = this.MOou(string, string2);
            this.sensitiveFields.add(string3);
        }
    }

    public boolean isSensitive(String string, String string2) {
        return this.sensitiveFields.contains(this.MOou(string, string2));
    }

    private String MOou(String string, String string2) {
        if (string == null || string2 == null) {
            return string;
        }
        if (string.equalsIgnoreCase("Cookie")) {
            int n = string2.indexOf(61);
            String string3 = n < 0 ? string2 : string2.substring(0, n);
            return string + ":" + string3.trim();
        }
        return string;
    }

    @Override
    public boolean isEmpty() {
        return this.fieldNames.isEmpty() && this.fieldValues.isEmpty();
    }

    @Override
    protected void writeFirstLine(ByteArrayOutputStream byteArrayOutputStream) {
    }

    @Override
    protected boolean readFirstLine(MhBt mhBt, boolean bl) {
        return true;
    }
}

