/*
 * Decompiled with CFR 0.152.
 */
package com.xk72.charles.gui.transaction.lib;

import java.awt.Font;
import javax.swing.JTextArea;
import javax.swing.plaf.FontUIResource;

public class HexAsciiTextPane
extends JTextArea {
    public HexAsciiTextPane() {
        this.setTabSize(4);
    }

    @Override
    public void setFont(Font font) {
        if (font instanceof FontUIResource) {
            super.setFont(new FontUIResource("Monospaced", font.getStyle(), font.getSize()));
        } else {
            super.setFont(new Font("Monospaced", font.getStyle(), font.getSize()));
        }
    }

    public void clear() {
        this.setText("");
    }

    public void setBytes(byte[] byArray) {
        int n = byArray.length;
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < n; i += 16) {
            int n2;
            stringBuffer.append(HexAsciiTextPane.AmNw(Integer.toHexString(i), 8));
            stringBuffer.append("  ");
            for (n2 = 0; n2 < 16; ++n2) {
                if (i + n2 < n) {
                    stringBuffer.append(HexAsciiTextPane.AmNw(byArray[i + n2]));
                    stringBuffer.append(' ');
                    continue;
                }
                stringBuffer.append("   ");
            }
            stringBuffer.append("  ");
            for (n2 = 0; n2 < 16; ++n2) {
                if (i + n2 < n) {
                    byte by = byArray[i + n2];
                    if (by > 32) {
                        stringBuffer.append((char)by);
                        continue;
                    }
                    stringBuffer.append(' ');
                    continue;
                }
                stringBuffer.append(' ');
            }
            stringBuffer.append('\n');
        }
        super.setText(stringBuffer.toString());
    }

    public static String AmNw(int n) {
        if (n < 0) {
            n = 256 + n;
        }
        if (n < 16) {
            return "0" + Integer.toHexString(n);
        }
        return Integer.toHexString(n);
    }

    public static String AmNw(String string, int n) {
        StringBuffer stringBuffer = new StringBuffer(string);
        while (stringBuffer.length() < n) {
            stringBuffer.insert(0, "0");
        }
        return stringBuffer.toString();
    }
}

