/*
 * Decompiled with CFR 0.152.
 */
package com.xk72.charles.gui.settings;

import com.xk72.charles.CharlesContext;
import com.xk72.charles.config.ProxyConfiguration;
import com.xk72.charles.gui.lib.EnableAwareJPanel;
import com.xk72.charles.gui.lib.FormUtils;
import com.xk72.charles.gui.settings.ImportCertificateHelper;
import com.xk72.charles.gui.settings.RootSSLCertificateSettingsPanel$1;
import com.xk72.charles.gui.settings.RootSSLCertificateSettingsPanel$2;
import com.xk72.charles.gui.settings.RootSSLCertificateSettingsPanel$3;
import com.xk72.charles.gui.settings.SettingsPanel;
import com.xk72.charles.gui.settings.vBKw;
import com.xk72.charles.ssl.CertificateConfiguration;
import com.xk72.charles.ssl.SSLCertificateStore;
import com.xk72.charles.ssl.XDSj;
import java.awt.Component;
import java.awt.LayoutManager;
import java.io.IOException;
import java.security.GeneralSecurityException;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import net.miginfocom.swing.MigLayout;

class RootSSLCertificateSettingsPanel
extends SettingsPanel {
    private static final String AmNw = "Using automatically generated root certificate";
    private final JLabel certificateName;
    private final JButton removeButton;
    private CertificateConfiguration rootCertificate;

    public RootSSLCertificateSettingsPanel() {
        super(CharlesContext.getInstance().getBundle().getString("settings.serverSSLCertificates.name"));
        this.setHelp(this.ctx.getBundle().getString("settings.serverSSLCertificates.help"));
        XDSj xDSj = this.ctx.getSSLManager();
        SSLCertificateStore sSLCertificateStore = xDSj.MOou();
        JPanel jPanel = new JPanel((LayoutManager)new MigLayout("wrap, ins 0, fillx", "[fill]"));
        jPanel.add(FormUtils.aXgD(this.ctx.getBundle().getString("settings.serverSSLCertificates.blurb")));
        EnableAwareJPanel enableAwareJPanel = new EnableAwareJPanel((LayoutManager)new MigLayout("wrap,fill,ins 0,hidemode 2", "[fill,grow][][][]"));
        jPanel.add(enableAwareJPanel);
        this.certificateName = new JLabel();
        enableAwareJPanel.add((Component)this.certificateName, "wmin 10");
        enableAwareJPanel.add(new JButton(new RootSSLCertificateSettingsPanel$1(this, "Import PEM", sSLCertificateStore)));
        enableAwareJPanel.add(new JButton(new RootSSLCertificateSettingsPanel$2(this, "Import P12", sSLCertificateStore)));
        this.removeButton = new JButton(new RootSSLCertificateSettingsPanel$3(this, "Remove"));
        enableAwareJPanel.add(this.removeButton);
        this.add((Component)ImportCertificateHelper.AmNw(sSLCertificateStore, jPanel), "grow,push");
        ProxyConfiguration proxyConfiguration = this.ctx.getConfiguration().getProxyConfiguration();
        this.AmNw(proxyConfiguration.getSSLRootCertificate());
        jPanel.addComponentListener(new vBKw(this, proxyConfiguration));
    }

    private void AmNw(CertificateConfiguration certificateConfiguration) {
        this.rootCertificate = certificateConfiguration;
        if (this.rootCertificate != null) {
            this.certificateName.setText(this.rootCertificate.getName());
            this.removeButton.setVisible(true);
        } else {
            this.certificateName.setText(AmNw);
            this.removeButton.setVisible(false);
        }
    }

    @Override
    public boolean save() {
        ProxyConfiguration proxyConfiguration = this.ctx.getConfiguration().getProxyConfiguration();
        CertificateConfiguration certificateConfiguration = proxyConfiguration.getSSLRootCertificate();
        if (this.rootCertificate != certificateConfiguration) {
            if (certificateConfiguration != null) {
                if (certificateConfiguration.getFileAlias() != null) {
                    this.ctx.getFileStore().MOou(certificateConfiguration.getFileAlias());
                }
                if (certificateConfiguration.getStoreAlias() != null) {
                    try {
                        this.ctx.getSSLManager().MOou().AmNw(certificateConfiguration.getStoreAlias());
                    }
                    catch (IOException | GeneralSecurityException exception) {
                        // empty catch block
                    }
                }
            }
            proxyConfiguration.setSSLRootCertificate(this.rootCertificate);
        }
        return true;
    }
}

