/*
 * Decompiled with CFR 0.152.
 */
package com.xk72.charles.gui.lib;

import com.xk72.charles.CharlesContext;
import com.xk72.charles.gui.lib.AVYQ;
import com.xk72.charles.gui.lib.EDty;
import com.xk72.charles.gui.lib.LBrm;
import com.xk72.charles.gui.lib.MemoryJTable$ColumnStates;
import com.xk72.charles.gui.lib.WevH;
import com.xk72.charles.gui.lib.jkvC;
import com.xk72.charles.gui.lib.wphe;
import com.xk72.charles.gui.lib.xwwh;
import java.awt.Rectangle;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JTable;
import javax.swing.RowSorter;
import javax.swing.event.TableColumnModelListener;
import javax.swing.event.TableModelEvent;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;

public abstract class MemoryJTable
extends JTable {
    private static final Logger AmNw = Logger.getLogger("com.xk72.charles.gui.lib.MemoryJTable");
    private final TableColumnModelListener columnModelListener = new xwwh(this);
    private final WevH listener = new AVYQ(this);
    private boolean[] fixedWidthColumns;
    private int prevWidth;
    private final String columnStatesProperty;
    private TableColumn[] columns;
    private MemoryJTable$ColumnStates columnStates;
    private boolean changingColumns;
    private boolean resizingColumns;
    private volatile boolean sorted = false;

    public MemoryJTable(String string) {
        this(null, null, null, string);
    }

    public MemoryJTable(TableModel tableModel, String string) {
        this(tableModel, null, null, string);
    }

    public MemoryJTable(TableModel tableModel, boolean[] blArray, String string) {
        this(tableModel, blArray, null, string);
    }

    public MemoryJTable(TableModel tableModel, RowSorter<? extends TableModel> rowSorter, String string) {
        this(tableModel, null, rowSorter, string);
    }

    public MemoryJTable(TableModel tableModel, boolean[] blArray, RowSorter<? extends TableModel> rowSorter, String string) {
        super(tableModel);
        this.fixedWidthColumns = blArray;
        this.columnStatesProperty = string;
        this.setAutoResizeMode(3);
        if (rowSorter != null) {
            rowSorter.addRowSorterListener(new EDty(this, rowSorter));
            this.setRowSorter(rowSorter);
        }
        this.getTableHeader().addMouseListener(new jkvC(this, rowSorter));
    }

    public boolean isSorted() {
        return this.sorted;
    }

    protected int getDefaultWidth(int n) {
        return this.getCellRenderer((int)0, (int)n).getTableCellRendererComponent((JTable)this, null, (boolean)false, (boolean)false, (int)0, (int)0).getPreferredSize().width;
    }

    public void scrollRowToVisible(int n) {
        Rectangle rectangle = new Rectangle(0, n * this.getRowHeight(), 1, this.getRowHeight());
        this.scrollRectToVisible(rectangle);
    }

    @Override
    public void tableChanged(TableModelEvent tableModelEvent) {
        if (tableModelEvent == null || tableModelEvent.getFirstRow() == -1) {
            this.aXgD();
            JTableHeader jTableHeader = this.getTableHeader();
            if (jTableHeader != null) {
                jTableHeader.setDraggedColumn(null);
            }
            super.tableChanged(tableModelEvent);
            this.AmNw();
            this.MOou();
        } else {
            super.tableChanged(tableModelEvent);
        }
    }

    private void AmNw() {
        this.columns = new TableColumn[this.getModel().getColumnCount()];
        for (int i = 0; i < this.getColumnCount(); ++i) {
            TableColumn tableColumn;
            this.columns[tableColumn.getModelIndex()] = tableColumn = this.getColumnModel().getColumn(i);
            this.MOou(tableColumn);
        }
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.MOou();
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        this.aXgD();
    }

    private void MOou() {
        if (this.columnStatesProperty == null || this.getModel().getColumnCount() == 0 || this.columnStates != null) {
            return;
        }
        this.columnStates = this.getColumnStates();
        this.columnStates.addListener(this.listener);
        this.AmNw(this.columnStates);
        this.getColumnModel().addColumnModelListener(this.columnModelListener);
    }

    private void aXgD() {
        if (this.columnStates != null) {
            this.columnStates.removeListener(this.listener);
            this.columnStates = null;
        }
        this.getColumnModel().removeColumnModelListener(this.columnModelListener);
    }

    @Override
    public TableColumn getColumn(Object object) {
        if (this.columns != null) {
            for (TableColumn tableColumn : this.columns) {
                if (!tableColumn.getIdentifier().equals(object)) continue;
                return tableColumn;
            }
        }
        return super.getColumn(object);
    }

    protected MemoryJTable$ColumnStates getColumnStates() {
        MemoryJTable$ColumnStates memoryJTable$ColumnStates = CharlesContext.getInstance().getConfiguration().getUserInterfaceConfiguration().getProperty(this.columnStatesProperty, MemoryJTable$ColumnStates.class);
        if (memoryJTable$ColumnStates == null || memoryJTable$ColumnStates.isInitialised() && memoryJTable$ColumnStates.getLength() != this.getModel().getColumnCount()) {
            memoryJTable$ColumnStates = new MemoryJTable$ColumnStates();
            CharlesContext.getInstance().getConfiguration().getUserInterfaceConfiguration().setProperty(this.columnStatesProperty, memoryJTable$ColumnStates);
        }
        if (memoryJTable$ColumnStates.isInitialised()) {
            int n = this.getWidth() == 0 ? 800 : this.getWidth();
            for (int i = 0; i < memoryJTable$ColumnStates.sizes.length; ++i) {
                if (!(memoryJTable$ColumnStates.sizes[i] > 0.0) || !(memoryJTable$ColumnStates.sizes[i] < 1.0)) continue;
                memoryJTable$ColumnStates.sizes[i] = memoryJTable$ColumnStates.sizes[i] * (double)n;
            }
        }
        return memoryJTable$ColumnStates;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void AmNw(MemoryJTable$ColumnStates memoryJTable$ColumnStates) {
        this.changingColumns = true;
        try {
            if (memoryJTable$ColumnStates.isInitialised()) {
                this.AmNw(memoryJTable$ColumnStates.positions);
                this.MOou(memoryJTable$ColumnStates.positions);
            } else {
                int[] nArray;
                TableModel tableModel = this.getModel();
                if (tableModel instanceof wphe) {
                    nArray = ((wphe)tableModel).getInitialPositions();
                } else {
                    nArray = new int[this.getModel().getColumnCount()];
                    for (int i = 0; i < nArray.length; ++i) {
                        nArray[i] = i;
                    }
                }
                this.AmNw(nArray);
                this.MOou(nArray);
            }
        }
        finally {
            this.changingColumns = false;
        }
        this.prevWidth = -1;
        this.doLayout();
    }

    @Override
    public void doLayout() {
        if (this.getWidth() != this.prevWidth) {
            this.prevWidth = this.getWidth();
            if (this.columnStates.isInitialised()) {
                this.AmNw(this.fixedWidthColumns, this.columnStates.sizes);
            } else {
                this.layoutColumns();
            }
            super.doLayout();
        } else {
            super.doLayout();
        }
    }

    private void AmNw(int[] nArray) {
        for (int i = 0; i < nArray.length; ++i) {
            int n = this.convertColumnIndexToView(i);
            if (nArray[i] < 0 && n >= 0) {
                this.getColumnModel().removeColumn(this.getColumnModel().getColumn(n));
                continue;
            }
            if (nArray[i] < 0 || n >= 0) continue;
            this.getColumnModel().addColumn(this.AmNw(i));
        }
    }

    private TableColumn AmNw(int n) {
        TableColumn tableColumn;
        if (this.columns[n] == null) {
            tableColumn = new TableColumn(n);
            this.MOou(tableColumn);
        } else {
            tableColumn = this.columns[n];
        }
        return tableColumn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void AmNw(boolean[] blArray, double[] dArray) {
        int n = this.getAutoResizeMode();
        this.setAutoResizeMode(0);
        try {
            TableColumn tableColumn;
            int n2;
            int n3 = this.getWidth();
            double d = 0.0;
            for (n2 = 0; n2 < this.getColumnCount(); ++n2) {
                tableColumn = this.getColumnModel().getColumn(n2);
                if (blArray != null && tableColumn.getModelIndex() < blArray.length && blArray[tableColumn.getModelIndex()]) {
                    int n4 = (int)Math.round(dArray[tableColumn.getModelIndex()]);
                    tableColumn.setPreferredWidth(n4);
                    n3 -= n4;
                    continue;
                }
                d += dArray[tableColumn.getModelIndex()];
            }
            for (n2 = 0; n2 < this.getColumnCount(); ++n2) {
                tableColumn = this.getColumnModel().getColumn(n2);
                if (blArray != null && tableColumn.getModelIndex() < blArray.length && blArray[tableColumn.getModelIndex()]) continue;
                tableColumn.setPreferredWidth((int)Math.round(dArray[tableColumn.getModelIndex()] / d * (double)n3));
            }
        }
        finally {
            this.setAutoResizeMode(n);
        }
    }

    public void resetColumns() {
        this.columnStates.reset();
        this.columnStates.fireStateChange(null);
    }

    private void MOou(int[] nArray) {
        try {
            int n = 0;
            do {
                ++n;
                boolean bl = true;
                for (int i = 0; i < this.getColumnCount(); ++i) {
                    TableColumn tableColumn = this.getColumnModel().getColumn(i);
                    if (nArray[tableColumn.getModelIndex()] == i) continue;
                    this.getColumnModel().moveColumn(i, nArray[tableColumn.getModelIndex()]);
                    bl = false;
                }
                if (!bl) continue;
                return;
            } while (n < this.getColumnCount());
            AmNw.info("Gave up trying to move " + this.columnStatesProperty + " columns to postions: " + Arrays.toString(nArray));
        }
        catch (RuntimeException runtimeException) {
            AmNw.log(Level.INFO, "Unexpected error moving " + this.columnStatesProperty + " columns to postions: " + Arrays.toString(nArray), runtimeException);
        }
    }

    private void AmNw(TableColumn tableColumn) {
        if (!this.columnStates.isInitialised()) {
            this.columnStates.init(this);
        }
        this.columnStates.sizes[tableColumn.getModelIndex()] = tableColumn.getPreferredWidth();
        this.columnStates.fireStateChange(this.getColumnModel());
    }

    private void MOou(TableColumn tableColumn) {
        tableColumn.addPropertyChangeListener(new LBrm(this, tableColumn));
    }

    protected abstract void layoutColumns();
}

