/*
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 * Changes may cause incorrect behavior and will be lost if the code is
 * regenerated.
 */
import { __extends } from "tslib";
import * as msRestAzure from "@azure/ms-rest-azure-js";
var packageName = "@azure/arm-subscriptions";
var packageVersion = "3.1.2";
var SubscriptionClientContext = /** @class */ (function (_super) {
    __extends(SubscriptionClientContext, _super);
    /**
     * Initializes a new instance of the SubscriptionClient class.
     * @param credentials Credentials needed for the client to connect to Azure. Credentials
     * implementing the TokenCredential interface from the @azure/identity package are recommended. For
     * more information about these credentials, see
     * {@link https://www.npmjs.com/package/@azure/identity}. Credentials implementing the
     * ServiceClientCredentials interface from the older packages @azure/ms-rest-nodeauth and
     * @azure/ms-rest-browserauth are also supported.
     * @param [options] The parameter options
     */
    function SubscriptionClientContext(credentials, options) {
        var _this = this;
        if (credentials == undefined) {
            throw new Error('\'credentials\' cannot be null.');
        }
        if (!options) {
            options = {};
        }
        if (!options.userAgent) {
            var defaultUserAgent = msRestAzure.getDefaultUserAgentValue();
            options.userAgent = packageName + "/" + packageVersion + " " + defaultUserAgent;
        }
        _this = _super.call(this, credentials, options) || this;
        _this.acceptLanguage = 'en-US';
        _this.longRunningOperationRetryTimeout = 30;
        _this.baseUri = options.baseUri || _this.baseUri || "https://management.azure.com";
        _this.requestContentType = "application/json; charset=utf-8";
        _this.credentials = credentials;
        if (options.acceptLanguage !== null && options.acceptLanguage !== undefined) {
            _this.acceptLanguage = options.acceptLanguage;
        }
        if (options.longRunningOperationRetryTimeout !== null && options.longRunningOperationRetryTimeout !== undefined) {
            _this.longRunningOperationRetryTimeout = options.longRunningOperationRetryTimeout;
        }
        return _this;
    }
    return SubscriptionClientContext;
}(msRestAzure.AzureServiceClient));
export { SubscriptionClientContext };
//# sourceMappingURL=subscriptionClientContext.js.map