/*
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 * Changes may cause incorrect behavior and will be lost if the code is
 * regenerated.
 */
import * as msRest from "@azure/ms-rest-js";
import * as Mappers from "../models/subscriptionsMappers";
import * as Parameters from "../models/parameters";
/** Class representing a Subscriptions. */
var Subscriptions = /** @class */ (function () {
    /**
     * Create a Subscriptions.
     * @param {SubscriptionClientContext} client Reference to the service client.
     */
    function Subscriptions(client) {
        this.client = client;
    }
    Subscriptions.prototype.listLocations = function (subscriptionId, options, callback) {
        return this.client.sendOperationRequest({
            subscriptionId: subscriptionId,
            options: options
        }, listLocationsOperationSpec, callback);
    };
    Subscriptions.prototype.get = function (subscriptionId, options, callback) {
        return this.client.sendOperationRequest({
            subscriptionId: subscriptionId,
            options: options
        }, getOperationSpec, callback);
    };
    Subscriptions.prototype.list = function (options, callback) {
        return this.client.sendOperationRequest({
            options: options
        }, listOperationSpec, callback);
    };
    Subscriptions.prototype.listNext = function (nextPageLink, options, callback) {
        return this.client.sendOperationRequest({
            nextPageLink: nextPageLink,
            options: options
        }, listNextOperationSpec, callback);
    };
    return Subscriptions;
}());
export { Subscriptions };
// Operation Specifications
var serializer = new msRest.Serializer(Mappers);
var listLocationsOperationSpec = {
    httpMethod: "GET",
    path: "subscriptions/{subscriptionId}/locations",
    urlParameters: [
        Parameters.subscriptionId
    ],
    queryParameters: [
        Parameters.apiVersion0
    ],
    headerParameters: [
        Parameters.acceptLanguage
    ],
    responses: {
        200: {
            bodyMapper: Mappers.LocationListResult
        },
        default: {
            bodyMapper: Mappers.CloudError
        }
    },
    serializer: serializer
};
var getOperationSpec = {
    httpMethod: "GET",
    path: "subscriptions/{subscriptionId}",
    urlParameters: [
        Parameters.subscriptionId
    ],
    queryParameters: [
        Parameters.apiVersion0
    ],
    headerParameters: [
        Parameters.acceptLanguage
    ],
    responses: {
        200: {
            bodyMapper: Mappers.Subscription
        },
        default: {
            bodyMapper: Mappers.CloudError
        }
    },
    serializer: serializer
};
var listOperationSpec = {
    httpMethod: "GET",
    path: "subscriptions",
    queryParameters: [
        Parameters.apiVersion0
    ],
    headerParameters: [
        Parameters.acceptLanguage
    ],
    responses: {
        200: {
            bodyMapper: Mappers.SubscriptionListResult
        },
        default: {
            bodyMapper: Mappers.CloudError
        }
    },
    serializer: serializer
};
var listNextOperationSpec = {
    httpMethod: "GET",
    baseUrl: "https://management.azure.com",
    path: "{nextLink}",
    urlParameters: [
        Parameters.nextPageLink
    ],
    headerParameters: [
        Parameters.acceptLanguage
    ],
    responses: {
        200: {
            bodyMapper: Mappers.SubscriptionListResult
        },
        default: {
            bodyMapper: Mappers.CloudError
        }
    },
    serializer: serializer
};
//# sourceMappingURL=subscriptions.js.map