import * as Models from "./models";
import * as msRest from "@azure/ms-rest-js";
import { TokenCredential } from "@azure/core-auth";
import * as msRestAzure from "@azure/ms-rest-azure-js";
export declare class SubscriptionClientContext extends msRestAzure.AzureServiceClient {
    credentials: msRest.ServiceClientCredentials | TokenCredential;
    /**
     * Initializes a new instance of the SubscriptionClient class.
     * @param credentials Credentials needed for the client to connect to Azure. Credentials
     * implementing the TokenCredential interface from the @azure/identity package are recommended. For
     * more information about these credentials, see
     * {@link https://www.npmjs.com/package/@azure/identity}. Credentials implementing the
     * ServiceClientCredentials interface from the older packages @azure/ms-rest-nodeauth and
     * @azure/ms-rest-browserauth are also supported.
     * @param [options] The parameter options
     */
    constructor(credentials: msRest.ServiceClientCredentials | TokenCredential, options?: Models.SubscriptionClientOptions);
}
//# sourceMappingURL=subscriptionClientContext.d.ts.map