import * as msRest from "@azure/ms-rest-js";
import * as Models from "../models";
import { SubscriptionClientContext } from "../subscriptionClientContext";
/** Class representing a Operations. */
export declare class Operations {
    private readonly client;
    /**
     * Create a Operations.
     * @param {SubscriptionClientContext} client Reference to the service client.
     */
    constructor(client: SubscriptionClientContext);
    /**
     * Lists all of the available Microsoft.Subscription API operations.
     * @param [options] The optional parameters
     * @returns Promise<Models.OperationsListResponse>
     */
    list(options?: msRest.RequestOptionsBase): Promise<Models.OperationsListResponse>;
    /**
     * @param callback The callback
     */
    list(callback: msRest.ServiceCallback<Models.OperationListResult>): void;
    /**
     * @param options The optional parameters
     * @param callback The callback
     */
    list(options: msRest.RequestOptionsBase, callback: msRest.ServiceCallback<Models.OperationListResult>): void;
}
//# sourceMappingURL=operations.d.ts.map