/*
 * Copyright (c) Microsoft Corporation.
 * Licensed under the MIT License.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 * Changes may cause incorrect behavior and will be lost if the code is
 * regenerated.
 */

import * as msRest from "@azure/ms-rest-js";
import { TokenCredential } from "@azure/core-auth";
import * as Models from "./models";
import * as Mappers from "./models/mappers";
import * as Parameters from "./models/parameters";
import * as operations from "./operations";
import { ResourceGraphClientContext } from "./resourceGraphClientContext";

class ResourceGraphClient extends ResourceGraphClientContext {
  // Operation groups
  operations: operations.Operations;

  /**
   * Initializes a new instance of the ResourceGraphClient class.
   * @param credentials Credentials needed for the client to connect to Azure. Credentials
   * implementing the TokenCredential interface from the @azure/identity package are recommended. For
   * more information about these credentials, see
   * {@link https://www.npmjs.com/package/@azure/identity}. Credentials implementing the
   * ServiceClientCredentials interface from the older packages @azure/ms-rest-nodeauth and
   * @azure/ms-rest-browserauth are also supported.
   * @param [options] The parameter options
   */
  constructor(
    credentials: msRest.ServiceClientCredentials | TokenCredential,
    options?: Models.ResourceGraphClientOptions
  ) {
    super(credentials, options);
    this.operations = new operations.Operations(this);
  }

  /**
   * List changes to a resource for a given time interval.
   * @param parameters the parameters for this request for changes.
   * @param [options] The optional parameters
   * @returns Promise<Models.ResourceChangesResponse>
   */
  resourceChanges(
    parameters: Models.ResourceChangesRequestParameters,
    options?: msRest.RequestOptionsBase
  ): Promise<Models.ResourceChangesResponse>;
  /**
   * @param parameters the parameters for this request for changes.
   * @param callback The callback
   */
  resourceChanges(
    parameters: Models.ResourceChangesRequestParameters,
    callback: msRest.ServiceCallback<Models.ResourceChangeList>
  ): void;
  /**
   * @param parameters the parameters for this request for changes.
   * @param options The optional parameters
   * @param callback The callback
   */
  resourceChanges(
    parameters: Models.ResourceChangesRequestParameters,
    options: msRest.RequestOptionsBase,
    callback: msRest.ServiceCallback<Models.ResourceChangeList>
  ): void;
  resourceChanges(
    parameters: Models.ResourceChangesRequestParameters,
    options?: msRest.RequestOptionsBase | msRest.ServiceCallback<Models.ResourceChangeList>,
    callback?: msRest.ServiceCallback<Models.ResourceChangeList>
  ): Promise<Models.ResourceChangesResponse> {
    return this.sendOperationRequest(
      {
        parameters,
        options
      },
      resourceChangesOperationSpec,
      callback
    ) as Promise<Models.ResourceChangesResponse>;
  }

  /**
   * Get resource change details.
   * @param parameters The parameters for this request for resource change details.
   * @param [options] The optional parameters
   * @returns Promise<Models.ResourceChangeDetailsResponse>
   */
  resourceChangeDetails(
    parameters: Models.ResourceChangeDetailsRequestParameters,
    options?: msRest.RequestOptionsBase
  ): Promise<Models.ResourceChangeDetailsResponse>;
  /**
   * @param parameters The parameters for this request for resource change details.
   * @param callback The callback
   */
  resourceChangeDetails(
    parameters: Models.ResourceChangeDetailsRequestParameters,
    callback: msRest.ServiceCallback<Models.ResourceChangeData[]>
  ): void;
  /**
   * @param parameters The parameters for this request for resource change details.
   * @param options The optional parameters
   * @param callback The callback
   */
  resourceChangeDetails(
    parameters: Models.ResourceChangeDetailsRequestParameters,
    options: msRest.RequestOptionsBase,
    callback: msRest.ServiceCallback<Models.ResourceChangeData[]>
  ): void;
  resourceChangeDetails(
    parameters: Models.ResourceChangeDetailsRequestParameters,
    options?: msRest.RequestOptionsBase | msRest.ServiceCallback<Models.ResourceChangeData[]>,
    callback?: msRest.ServiceCallback<Models.ResourceChangeData[]>
  ): Promise<Models.ResourceChangeDetailsResponse> {
    return this.sendOperationRequest(
      {
        parameters,
        options
      },
      resourceChangeDetailsOperationSpec,
      callback
    ) as Promise<Models.ResourceChangeDetailsResponse>;
  }

  /**
   * Queries the resources managed by Azure Resource Manager for scopes specified in the request.
   * @param query Request specifying query and its options.
   * @param [options] The optional parameters
   * @returns Promise<Models.ResourcesResponse>
   */
  resources(
    query: Models.QueryRequest,
    options?: msRest.RequestOptionsBase
  ): Promise<Models.ResourcesResponse>;
  /**
   * @param query Request specifying query and its options.
   * @param callback The callback
   */
  resources(
    query: Models.QueryRequest,
    callback: msRest.ServiceCallback<Models.QueryResponse>
  ): void;
  /**
   * @param query Request specifying query and its options.
   * @param options The optional parameters
   * @param callback The callback
   */
  resources(
    query: Models.QueryRequest,
    options: msRest.RequestOptionsBase,
    callback: msRest.ServiceCallback<Models.QueryResponse>
  ): void;
  resources(
    query: Models.QueryRequest,
    options?: msRest.RequestOptionsBase | msRest.ServiceCallback<Models.QueryResponse>,
    callback?: msRest.ServiceCallback<Models.QueryResponse>
  ): Promise<Models.ResourcesResponse> {
    return this.sendOperationRequest(
      {
        query,
        options
      },
      resourcesOperationSpec,
      callback
    ) as Promise<Models.ResourcesResponse>;
  }

  /**
   * List all snapshots of a resource for a given time interval.
   * @param request
   * @param [options] The optional parameters
   * @returns Promise<Models.ResourcesHistoryResponse>
   */
  resourcesHistory(
    request: Models.ResourcesHistoryRequest,
    options?: msRest.RequestOptionsBase
  ): Promise<Models.ResourcesHistoryResponse>;
  /**
   * @param request
   * @param callback The callback
   */
  resourcesHistory(
    request: Models.ResourcesHistoryRequest,
    callback: msRest.ServiceCallback<any>
  ): void;
  /**
   * @param request
   * @param options The optional parameters
   * @param callback The callback
   */
  resourcesHistory(
    request: Models.ResourcesHistoryRequest,
    options: msRest.RequestOptionsBase,
    callback: msRest.ServiceCallback<any>
  ): void;
  resourcesHistory(
    request: Models.ResourcesHistoryRequest,
    options?: msRest.RequestOptionsBase | msRest.ServiceCallback<any>,
    callback?: msRest.ServiceCallback<any>
  ): Promise<Models.ResourcesHistoryResponse> {
    return this.sendOperationRequest(
      {
        request,
        options
      },
      resourcesHistoryOperationSpec,
      callback
    ) as Promise<Models.ResourcesHistoryResponse>;
  }
}

// Operation Specifications
const serializer = new msRest.Serializer(Mappers);
const resourceChangesOperationSpec: msRest.OperationSpec = {
  httpMethod: "POST",
  path: "providers/Microsoft.ResourceGraph/resourceChanges",
  queryParameters: [Parameters.apiVersion0],
  headerParameters: [Parameters.acceptLanguage],
  requestBody: {
    parameterPath: "parameters",
    mapper: {
      ...Mappers.ResourceChangesRequestParameters,
      required: true
    }
  },
  responses: {
    200: {
      bodyMapper: Mappers.ResourceChangeList
    },
    default: {
      bodyMapper: Mappers.ErrorResponse
    }
  },
  serializer
};

const resourceChangeDetailsOperationSpec: msRest.OperationSpec = {
  httpMethod: "POST",
  path: "providers/Microsoft.ResourceGraph/resourceChangeDetails",
  queryParameters: [Parameters.apiVersion0],
  headerParameters: [Parameters.acceptLanguage],
  requestBody: {
    parameterPath: "parameters",
    mapper: {
      ...Mappers.ResourceChangeDetailsRequestParameters,
      required: true
    }
  },
  responses: {
    200: {
      bodyMapper: {
        serializedName: "parsedResponse",
        type: {
          name: "Sequence",
          element: {
            type: {
              name: "Composite",
              className: "ResourceChangeData"
            }
          }
        }
      }
    },
    default: {
      bodyMapper: Mappers.ErrorResponse
    }
  },
  serializer
};

const resourcesOperationSpec: msRest.OperationSpec = {
  httpMethod: "POST",
  path: "providers/Microsoft.ResourceGraph/resources",
  queryParameters: [Parameters.apiVersion1],
  headerParameters: [Parameters.acceptLanguage],
  requestBody: {
    parameterPath: "query",
    mapper: {
      ...Mappers.QueryRequest,
      required: true
    }
  },
  responses: {
    200: {
      bodyMapper: Mappers.QueryResponse
    },
    default: {
      bodyMapper: Mappers.ErrorResponse
    }
  },
  serializer
};

const resourcesHistoryOperationSpec: msRest.OperationSpec = {
  httpMethod: "POST",
  path: "providers/Microsoft.ResourceGraph/resourcesHistory",
  queryParameters: [Parameters.apiVersion2],
  headerParameters: [Parameters.acceptLanguage],
  requestBody: {
    parameterPath: "request",
    mapper: {
      ...Mappers.ResourcesHistoryRequest,
      required: true
    }
  },
  responses: {
    200: {
      bodyMapper: {
        serializedName: "parsedResponse",
        type: {
          name: "Object"
        }
      }
    },
    default: {
      bodyMapper: Mappers.ErrorResponse
    }
  },
  serializer
};

export {
  ResourceGraphClient,
  ResourceGraphClientContext,
  Models as ResourceGraphModels,
  Mappers as ResourceGraphMappers
};
export * from "./operations";
