import * as msRest from "@azure/ms-rest-js";
import * as Models from "../models";
import { SubscriptionClientContext } from "../subscriptionClientContext";
/** Class representing a Tenants. */
export declare class Tenants {
    private readonly client;
    /**
     * Create a Tenants.
     * @param {SubscriptionClientContext} client Reference to the service client.
     */
    constructor(client: SubscriptionClientContext);
    /**
     * Gets the tenants for your account.
     * @param [options] The optional parameters
     * @returns Promise<Models.TenantsListResponse>
     */
    list(options?: msRest.RequestOptionsBase): Promise<Models.TenantsListResponse>;
    /**
     * @param callback The callback
     */
    list(callback: msRest.ServiceCallback<Models.TenantListResult>): void;
    /**
     * @param options The optional parameters
     * @param callback The callback
     */
    list(options: msRest.RequestOptionsBase, callback: msRest.ServiceCallback<Models.TenantListResult>): void;
    /**
     * Gets the tenants for your account.
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @param [options] The optional parameters
     * @returns Promise<Models.TenantsListNextResponse>
     */
    listNext(nextPageLink: string, options?: msRest.RequestOptionsBase): Promise<Models.TenantsListNextResponse>;
    /**
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @param callback The callback
     */
    listNext(nextPageLink: string, callback: msRest.ServiceCallback<Models.TenantListResult>): void;
    /**
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @param options The optional parameters
     * @param callback The callback
     */
    listNext(nextPageLink: string, options: msRest.RequestOptionsBase, callback: msRest.ServiceCallback<Models.TenantListResult>): void;
}
//# sourceMappingURL=tenants.d.ts.map