/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult$TypeCheckSuccess$;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.ImplicitCastInputTypes;
import org.apache.spark.sql.catalyst.expressions.QuaternaryExpression;
import org.apache.spark.sql.catalyst.expressions.WidthBucket$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.util.TypeUtils$;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DayTimeIntervalType;
import org.apache.spark.sql.types.DayTimeIntervalType$;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.TypeCollection$;
import org.apache.spark.sql.types.YearMonthIntervalType;
import org.apache.spark.sql.types.YearMonthIntervalType$;
import scala.Function4;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Tuple3;
import scala.Tuple4;
import scala.collection.Iterator;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ExpressionDescription(usage="\n    _FUNC_(value, min_value, max_value, num_bucket) - Returns the bucket number to which\n      `value` would be assigned in an equiwidth histogram with `num_bucket` buckets,\n      in the range `min_value` to `max_value`.\"\n  ", examples="\n    Examples:\n      > SELECT _FUNC_(5.3, 0.2, 10.6, 5);\n       3\n      > SELECT _FUNC_(-2.1, 1.3, 3.4, 3);\n       0\n      > SELECT _FUNC_(8.1, 0.0, 5.7, 4);\n       5\n      > SELECT _FUNC_(-0.9, 5.2, 0.5, 2);\n       3\n      > SELECT _FUNC_(INTERVAL '0' YEAR, INTERVAL '0' YEAR, INTERVAL '10' YEAR, 10);\n       1\n      > SELECT _FUNC_(INTERVAL '1' YEAR, INTERVAL '0' YEAR, INTERVAL '10' YEAR, 10);\n       2\n      > SELECT _FUNC_(INTERVAL '0' DAY, INTERVAL '0' DAY, INTERVAL '10' DAY, 10);\n       1\n      > SELECT _FUNC_(INTERVAL '1' DAY, INTERVAL '0' DAY, INTERVAL '10' DAY, 10);\n       2\n  ", since="3.1.0", group="math_funcs")
@ScalaSignature(bytes="\u0006\u0005\t=t!\u0002\u0017.\u0011\u0003Qd!\u0002\u001f.\u0011\u0003i\u0004\"\u0002'\u0002\t\u0003i\u0005\"\u0002(\u0002\t\u0003y\u0005\"B2\u0002\t\u0003!\u0007\"\u00027\u0002\t\u0003i\u0007b\u0002:\u0002\u0003\u0003%\ti\u001d\u0005\n\u0005#\n\u0011\u0011!CA\u0005'B\u0011B!\u001a\u0002\u0003\u0003%IAa\u001a\u0007\tqj\u0003)\u001e\u0005\n/&\u0011)\u001a!C\u0001\u0003+A!\"!\b\n\u0005#\u0005\u000b\u0011BA\f\u0011)\ty\"\u0003BK\u0002\u0013\u0005\u0011Q\u0003\u0005\u000b\u0003CI!\u0011#Q\u0001\n\u0005]\u0001BCA\u0012\u0013\tU\r\u0011\"\u0001\u0002\u0016!Q\u0011QE\u0005\u0003\u0012\u0003\u0006I!a\u0006\t\u0013\u0001L!Q3A\u0005\u0002\u0005U\u0001BCA\u0014\u0013\tE\t\u0015!\u0003\u0002\u0018!1A*\u0003C\u0001\u0003SAq!a\r\n\t\u0003\n)\u0004C\u0004\u00028%!\t%!\u000f\t\u000f\u00055\u0013\u0002\"\u0011\u0002P!9\u0011QL\u0005\u0005B\u0005}\u0003bBA4\u0013\u0011\u0005\u0013Q\u0007\u0005\b\u0003SJA\u0011IA6\u0011\u001d\ti(\u0003C)\u0003\u007fBq!!%\n\t\u0003\n\u0019\nC\u0004\u00020&!\t%!\u0006\t\u000f\u0005E\u0016\u0002\"\u0011\u0002\u0016!9\u00111W\u0005\u0005B\u0005U\u0001bBA[\u0013\u0011\u0005\u0013Q\u0003\u0005\b\u0003oKA\u0011KA]\u0011%\t\u0019-CA\u0001\n\u0003\t)\rC\u0005\u0002P&\t\n\u0011\"\u0001\u0002R\"I\u0011q]\u0005\u0012\u0002\u0013\u0005\u0011\u0011\u001b\u0005\n\u0003SL\u0011\u0013!C\u0001\u0003#D\u0011\"a;\n#\u0003%\t!!5\t\u0013\u00055\u0018\"!A\u0005B\u0005=\b\"CA{\u0013\u0005\u0005I\u0011AA|\u0011%\ty0CA\u0001\n\u0003\u0011\t\u0001C\u0005\u0003\b%\t\t\u0011\"\u0011\u0003\n!I!qC\u0005\u0002\u0002\u0013\u0005!\u0011\u0004\u0005\n\u0005;I\u0011\u0011!C!\u0005?A\u0011Ba\t\n\u0003\u0003%\tE!\n\u0002\u0017]KG\r\u001e5Ck\u000e\\W\r\u001e\u0006\u0003]=\n1\"\u001a=qe\u0016\u001c8/[8og*\u0011\u0001'M\u0001\tG\u0006$\u0018\r\\=ti*\u0011!gM\u0001\u0004gFd'B\u0001\u001b6\u0003\u0015\u0019\b/\u0019:l\u0015\t1t'\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002q\u0005\u0019qN]4\u0004\u0001A\u00111(A\u0007\u0002[\tYq+\u001b3uQ\n+8m[3u'\r\ta\b\u0012\t\u0003\u007f\tk\u0011\u0001\u0011\u0006\u0002\u0003\u0006)1oY1mC&\u00111\t\u0011\u0002\u0007\u0003:L(+\u001a4\u0011\u0005\u0015SU\"\u0001$\u000b\u0005\u001dC\u0015AA5p\u0015\u0005I\u0015\u0001\u00026bm\u0006L!a\u0013$\u0003\u0019M+'/[1mSj\f'\r\\3\u0002\rqJg.\u001b;?)\u0005Q\u0014aE2p[B,H/\u001a\"vG.,GOT;nE\u0016\u0014H#\u0002)W7v{\u0006CA)U\u001b\u0005\u0011&BA*I\u0003\u0011a\u0017M\\4\n\u0005U\u0013&\u0001\u0002'p]\u001eDQaV\u0002A\u0002a\u000bQA^1mk\u0016\u0004\"aP-\n\u0005i\u0003%A\u0002#pk\ndW\rC\u0003]\u0007\u0001\u0007\u0001,A\u0002nS:DQAX\u0002A\u0002a\u000b1!\\1y\u0011\u0015\u00017\u00011\u0001b\u0003%qW/\u001c\"vG.,G\u000f\u0005\u0002@E&\u0011Q\u000bQ\u0001\u0007SNtU\u000f\u001c7\u0015\u000b\u0015D\u0017N[6\u0011\u0005}2\u0017BA4A\u0005\u001d\u0011un\u001c7fC:DQa\u0016\u0003A\u0002aCQ\u0001\u0018\u0003A\u0002aCQA\u0018\u0003A\u0002aCQ\u0001\u0019\u0003A\u0002\u0005\f!dY8naV$XMQ;dW\u0016$h*^7cKJtu\u000e\u001e(vY2$R\u0001\u00158paFDQaV\u0003A\u0002aCQ\u0001X\u0003A\u0002aCQAX\u0003A\u0002aCQ\u0001Y\u0003A\u0002\u0005\fQ!\u00199qYf$\u0012\u0002\u001eB%\u0005\u0017\u0012iEa\u0014\u0011\u0005mJ1#B\u0005wsr|\bCA\u001ex\u0013\tAXF\u0001\u000bRk\u0006$XM\u001d8bef,\u0005\u0010\u001d:fgNLwN\u001c\t\u0003wiL!a_\u0017\u0003-%k\u0007\u000f\\5dSR\u001c\u0015m\u001d;J]B,H\u000fV=qKN\u0004\"aP?\n\u0005y\u0004%a\u0002)s_\u0012,8\r\u001e\t\u0005\u0003\u0003\t\tB\u0004\u0003\u0002\u0004\u00055a\u0002BA\u0003\u0003\u0017i!!a\u0002\u000b\u0007\u0005%\u0011(\u0001\u0004=e>|GOP\u0005\u0002\u0003&\u0019\u0011q\u0002!\u0002\u000fA\f7m[1hK&\u00191*a\u0005\u000b\u0007\u0005=\u0001)\u0006\u0002\u0002\u0018A\u00191(!\u0007\n\u0007\u0005mQF\u0001\u0006FqB\u0014Xm]:j_:\faA^1mk\u0016\u0004\u0013\u0001C7j]Z\u000bG.^3\u0002\u00135LgNV1mk\u0016\u0004\u0013\u0001C7bqZ\u000bG.^3\u0002\u00135\f\u0007PV1mk\u0016\u0004\u0013A\u00038v[\n+8m[3uAQIA/a\u000b\u0002.\u0005=\u0012\u0011\u0007\u0005\u0007/J\u0001\r!a\u0006\t\u000f\u0005}!\u00031\u0001\u0002\u0018!9\u00111\u0005\nA\u0002\u0005]\u0001B\u00021\u0013\u0001\u0004\t9\"\u0001\bok2d\u0017J\u001c;pY\u0016\u0014\u0018M\u001c;\u0016\u0003\u0015\f!\"\u001b8qkR$\u0016\u0010]3t+\t\tY\u0004\u0005\u0004\u0002\u0002\u0005u\u0012\u0011I\u0005\u0005\u0003\u007f\t\u0019BA\u0002TKF\u0004B!a\u0011\u0002J5\u0011\u0011Q\t\u0006\u0004\u0003\u000f\n\u0014!\u0002;za\u0016\u001c\u0018\u0002BA&\u0003\u000b\u0012\u0001#\u00112tiJ\f7\r\u001e#bi\u0006$\u0016\u0010]3\u0002'\rDWmY6J]B,H\u000fR1uCRK\b/Z:\u0015\u0005\u0005E\u0003\u0003BA*\u00033j!!!\u0016\u000b\u0007\u0005]s&\u0001\u0005b]\u0006d\u0017p]5t\u0013\u0011\tY&!\u0016\u0003\u001fQK\b/Z\"iK\u000e\\'+Z:vYR\f\u0001\u0002Z1uCRK\b/Z\u000b\u0003\u0003C\u0002B!a\u0011\u0002d%!\u0011QMA#\u0005!!\u0015\r^1UsB,\u0017\u0001\u00038vY2\f'\r\\3\u0002\u0015A\u0014X\r\u001e;z\u001d\u0006lW-\u0006\u0002\u0002nA!\u0011qNA<\u001d\u0011\t\t(a\u001d\u0011\u0007\u0005\u0015\u0001)C\u0002\u0002v\u0001\u000ba\u0001\u0015:fI\u00164\u0017\u0002BA=\u0003w\u0012aa\u0015;sS:<'bAA;\u0001\u0006aa.\u001e7m'\u00064W-\u0012<bYRQ\u0011\u0011QAD\u0003\u0017\u000bi)a$\u0011\u0007}\n\u0019)C\u0002\u0002\u0006\u0002\u00131!\u00118z\u0011\u001d\tI)\u0007a\u0001\u0003\u0003\u000bQ!\u001b8qkRDa\u0001X\rA\u0002\u0005\u0005\u0005B\u00020\u001a\u0001\u0004\t\t\t\u0003\u0004a3\u0001\u0007\u0011\u0011Q\u0001\nI><UM\\\"pI\u0016$b!!&\u0002\"\u0006-\u0006\u0003BAL\u0003;k!!!'\u000b\u0007\u0005mU&A\u0004d_\u0012,w-\u001a8\n\t\u0005}\u0015\u0011\u0014\u0002\t\u000bb\u0004(oQ8eK\"9\u00111\u0015\u000eA\u0002\u0005\u0015\u0016aA2uqB!\u0011qSAT\u0013\u0011\tI+!'\u0003\u001d\r{G-Z4f]\u000e{g\u000e^3yi\"9\u0011Q\u0016\u000eA\u0002\u0005U\u0015AA3w\u0003\u00151\u0017N]:u\u0003\u0019\u0019XmY8oI\u0006)A\u000f[5sI\u00061am\\;si\"\fqc^5uQ:+wo\u00115jY\u0012\u0014XM\\%oi\u0016\u0014h.\u00197\u0015\u0013Q\fY,!0\u0002@\u0006\u0005\u0007bBAX?\u0001\u0007\u0011q\u0003\u0005\b\u0003c{\u0002\u0019AA\f\u0011\u001d\t\u0019l\ba\u0001\u0003/Aq!!. \u0001\u0004\t9\"\u0001\u0003d_BLH#\u0003;\u0002H\u0006%\u00171ZAg\u0011!9\u0006\u0005%AA\u0002\u0005]\u0001\"CA\u0010AA\u0005\t\u0019AA\f\u0011%\t\u0019\u0003\tI\u0001\u0002\u0004\t9\u0002\u0003\u0005aAA\u0005\t\u0019AA\f\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIE*\"!a5+\t\u0005]\u0011Q[\u0016\u0003\u0003/\u0004B!!7\u0002d6\u0011\u00111\u001c\u0006\u0005\u0003;\fy.A\u0005v]\u000eDWmY6fI*\u0019\u0011\u0011\u001d!\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0002f\u0006m'!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\u0012\u0014AD2paf$C-\u001a4bk2$HeM\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00135\u00035\u0001(o\u001c3vGR\u0004&/\u001a4jqV\u0011\u0011\u0011\u001f\t\u0004#\u0006M\u0018bAA=%\u0006a\u0001O]8ek\u000e$\u0018I]5usV\u0011\u0011\u0011 \t\u0004\u007f\u0005m\u0018bAA\u007f\u0001\n\u0019\u0011J\u001c;\u0002\u001dA\u0014x\u000eZ;di\u0016cW-\\3oiR!\u0011\u0011\u0011B\u0002\u0011%\u0011)aJA\u0001\u0002\u0004\tI0A\u0002yIE\nq\u0002\u001d:pIV\u001cG/\u0013;fe\u0006$xN]\u000b\u0003\u0005\u0017\u0001bA!\u0004\u0003\u0014\u0005\u0005UB\u0001B\b\u0015\r\u0011\t\u0002Q\u0001\u000bG>dG.Z2uS>t\u0017\u0002\u0002B\u000b\u0005\u001f\u0011\u0001\"\u0013;fe\u0006$xN]\u0001\tG\u0006tW)];bYR\u0019QMa\u0007\t\u0013\t\u0015\u0011&!AA\u0002\u0005\u0005\u0015A\u00059s_\u0012,8\r^#mK6,g\u000e\u001e(b[\u0016$B!!=\u0003\"!I!Q\u0001\u0016\u0002\u0002\u0003\u0007\u0011\u0011`\u0001\u0007KF,\u0018\r\\:\u0015\u0007\u0015\u00149\u0003C\u0005\u0003\u0006-\n\t\u00111\u0001\u0002\u0002\"\u001a\u0012Ba\u000b\u00032\tM\"q\u0007B\u001d\u0005{\u0011yDa\u0011\u0003FA\u00191H!\f\n\u0007\t=RFA\u000bFqB\u0014Xm]:j_:$Um]2sSB$\u0018n\u001c8\u0002\u000bU\u001c\u0018mZ3\"\u0005\tU\u0012!a1\u000bA\u0001\u0002\u0003e\u0018$V\u001d\u000e{\u0006F^1mk\u0016d\u0003%\\5o?Z\fG.^3-A5\f\u0007p\u0018<bYV,G\u0006\t8v[~\u0013WoY6fi&\u0002S\u0006\t*fiV\u0014hn\u001d\u0011uQ\u0016\u0004#-^2lKR\u0004c.^7cKJ\u0004Co\u001c\u0011xQ&\u001c\u0007N\u0003\u0011!A\u0001\u0002\u0003\u0005\u0019<bYV,\u0007\rI<pk2$\u0007EY3!CN\u001c\u0018n\u001a8fI\u0002Jg\u000eI1oA\u0015\fX/[<jIRD\u0007\u0005[5ti><'/Y7!o&$\b\u000e\t1ok6|&-^2lKR\u0004\u0007EY;dW\u0016$8\u000f\f\u0006!A\u0001\u0002\u0003\u0005I5oAQDW\r\t:b]\u001e,\u0007\u0005Y7j]~3\u0018\r\\;fA\u0002\"x\u000e\t1nCb|f/\u00197vK\u0002t#E\u0003\u0011!\u0003!)\u00070Y7qY\u0016\u001c\u0018E\u0001B\u001e\u0003\u0011u%\u0002\t\u0011!A\u0015C\u0018-\u001c9mKNT$\u0002\t\u0011!A\u0001\u0002c\bI*F\u0019\u0016\u001bE\u000bI0G+:\u001bu\fK\u001b/g1\u0002\u0003G\f\u001a-AE\u0002dF\u000e\u0017!k%Z$\u0002\t\u0011!A\u0001\u0002\u0003e\r\u0006!A\u0001\u0002\u0003\u0005\t !'\u0016cUi\u0011+!?\u001a+fjQ0)[Ir\u0013\u0007\f\u00112]Mb\u0003e\r\u00185Y\u0001\u001a\u0014f\u000f\u0006!A\u0001\u0002\u0003\u0005\t\u00111\u0015\u0001\u0002\u0003\u0005\t\u0011!}\u0001\u001aV\tT#D)\u0002zf)\u0016(D?\"Bd&\r\u0017!a9\u0002D\u0006I\u001b/o1\u0002C'K\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011!k)\u0001\u0003\u0005\t\u0011!Ay\u00023+\u0012'F\u0007R\u0003sLR+O\u0007~CS\u0006\r\u0018:Y\u0001*dF\r\u0017!a9*D\u0006\t\u001a*w)\u0001\u0003\u0005\t\u0011!A\u0001\u001a$\u0002\t\u0011!A\u0001\u0002c\bI*F\u0019\u0016\u001bE\u000bI0G+:\u001bu\fK%O)\u0016\u0013f+\u0011'!OA:\u0003%W#B%2\u0002\u0013J\u0014+F%Z\u000bE\nI\u00141O\u0001JV)\u0011*-A%sE+\u0012*W\u00032\u0003s%\r\u0019(Ae+\u0015I\u0015\u0017!cAJ3H\u0003\u0011!A\u0001\u0002\u0003\u0005I\u0019\u000bA\u0001\u0002\u0003\u0005\t\u0011?AM+E*R\"UA}3UKT\"`Q%sE+\u0012*W\u00032\u0003s%M\u0014!3\u0016\u000b%\u000b\f\u0011J\u001dR+%KV!MA\u001d\u0002t\u0005I-F\u0003Jc\u0003%\u0013(U\u000bJ3\u0016\t\u0014\u0011(cA:\u0003%W#B%2\u0002\u0013\u0007M\u0015<\u0015\u0001\u0002\u0003\u0005\t\u0011!AIR\u0001\u0005\t\u0011!A\u0001r\u0004eU#M\u000b\u000e#\u0006e\u0018$V\u001d\u000e{\u0006&\u0013(U\u000bJ3\u0016\t\u0014\u0011(a\u001d\u0002C)Q--A%sE+\u0012*W\u00032\u0003s\u0005M\u0014!\t\u0006KF\u0006I%O)\u0016\u0013f+\u0011'!OE\u0002t\u0005\t#B32\u0002\u0013\u0007M\u0015<\u0015\u0001\u0002\u0003\u0005\t\u0011!AER\u0001\u0005\t\u0011!A\u0001r\u0004eU#M\u000b\u000e#\u0006e\u0018$V\u001d\u000e{\u0006&\u0013(U\u000bJ3\u0016\t\u0014\u0011(c\u001d\u0002C)Q--A%sE+\u0012*W\u00032\u0003s\u0005M\u0014!\t\u0006KF\u0006I%O)\u0016\u0013f+\u0011'!OE\u0002t\u0005\t#B32\u0002\u0013\u0007M\u0015<\u0015\u0001\u0002\u0003\u0005\t\u0011!AIR\u0001\u0005I\u0001\u0006g&t7-Z\u0011\u0003\u0005\u0003\nQa\r\u00182]A\nQa\u001a:pkB\f#Aa\u0012\u0002\u00155\fG\u000f[0gk:\u001c7\u000f\u0003\u0004X\r\u0001\u0007\u0011q\u0003\u0005\b\u0003?1\u0001\u0019AA\f\u0011\u001d\t\u0019C\u0002a\u0001\u0003/Aa\u0001\u0019\u0004A\u0002\u0005]\u0011aB;oCB\u0004H.\u001f\u000b\u0005\u0005+\u0012\t\u0007E\u0003@\u0005/\u0012Y&C\u0002\u0003Z\u0001\u0013aa\u00149uS>t\u0007cC \u0003^\u0005]\u0011qCA\f\u0003/I1Aa\u0018A\u0005\u0019!V\u000f\u001d7fi!A!1M\u0004\u0002\u0002\u0003\u0007A/A\u0002yIA\nAb\u001e:ji\u0016\u0014V\r\u001d7bG\u0016$\"A!\u001b\u0011\u0007E\u0013Y'C\u0002\u0003nI\u0013aa\u00142kK\u000e$\b")
public class WidthBucket
extends QuaternaryExpression
implements ImplicitCastInputTypes,
Serializable {
    private final Expression value;
    private final Expression minValue;
    private final Expression maxValue;
    private final Expression numBucket;

    public static Option<Tuple4<Expression, Expression, Expression, Expression>> unapply(WidthBucket x$0) {
        return WidthBucket$.MODULE$.unapply(x$0);
    }

    public static Long computeBucketNumberNotNull(double value, double min, double max, long numBucket) {
        return WidthBucket$.MODULE$.computeBucketNumberNotNull(value, min, max, numBucket);
    }

    public static boolean isNull(double value, double min, double max, long numBucket) {
        return WidthBucket$.MODULE$.isNull(value, min, max, numBucket);
    }

    public static Long computeBucketNumber(double value, double min, double max, long numBucket) {
        return WidthBucket$.MODULE$.computeBucketNumber(value, min, max, numBucket);
    }

    public Expression value() {
        return this.value;
    }

    public Expression minValue() {
        return this.minValue;
    }

    public Expression maxValue() {
        return this.maxValue;
    }

    public Expression numBucket() {
        return this.numBucket;
    }

    @Override
    public boolean nullIntolerant() {
        return true;
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return new .colon.colon((Object)TypeCollection$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AbstractDataType[]{DoubleType$.MODULE$, YearMonthIntervalType$.MODULE$, DayTimeIntervalType$.MODULE$})), (List)new .colon.colon((Object)TypeCollection$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AbstractDataType[]{DoubleType$.MODULE$, YearMonthIntervalType$.MODULE$, DayTimeIntervalType$.MODULE$})), (List)new .colon.colon((Object)TypeCollection$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AbstractDataType[]{DoubleType$.MODULE$, YearMonthIntervalType$.MODULE$, DayTimeIntervalType$.MODULE$})), (List)new .colon.colon((Object)LongType$.MODULE$, (List)Nil$.MODULE$))));
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        TypeCheckResult typeCheckResult = ExpectsInputTypes.checkInputDataTypes$(this);
        if (TypeCheckResult$TypeCheckSuccess$.MODULE$.equals(typeCheckResult)) {
            Tuple3 tuple3 = new Tuple3((Object)this.value().dataType(), (Object)this.minValue().dataType(), (Object)this.maxValue().dataType());
            if (tuple3 != null && tuple3._1() instanceof YearMonthIntervalType && tuple3._2() instanceof YearMonthIntervalType && tuple3._3() instanceof YearMonthIntervalType) {
                return TypeCheckResult$TypeCheckSuccess$.MODULE$;
            }
            if (tuple3 != null && tuple3._1() instanceof DayTimeIntervalType && tuple3._2() instanceof DayTimeIntervalType && tuple3._3() instanceof DayTimeIntervalType) {
                return TypeCheckResult$TypeCheckSuccess$.MODULE$;
            }
            .colon.colon types = new .colon.colon((Object)this.value().dataType(), (List)new .colon.colon((Object)this.minValue().dataType(), (List)new .colon.colon((Object)this.maxValue().dataType(), (List)Nil$.MODULE$)));
            return TypeUtils$.MODULE$.checkForSameTypeInputExpr((Seq<DataType>)types, this.prettyName());
        }
        return typeCheckResult;
    }

    @Override
    public DataType dataType() {
        return LongType$.MODULE$;
    }

    @Override
    public boolean nullable() {
        return true;
    }

    @Override
    public String prettyName() {
        return "width_bucket";
    }

    @Override
    public Object nullSafeEval(Object input, Object min, Object max, Object numBucket) {
        return WidthBucket$.MODULE$.computeBucketNumber(((Number)input).doubleValue(), ((Number)min).doubleValue(), ((Number)max).doubleValue(), BoxesRunTime.unboxToLong((Object)numBucket));
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        return this.nullSafeCodeGen(ctx, ev, (Function4<String, String, String, String, String>)(Function4 & Serializable)(input, min, max, numBucket) -> StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(ev.isNull() + " = org.apache.spark.sql.catalyst.expressions.WidthBucket\n         |  .isNull(" + input + ", " + min + ", " + max + ", " + numBucket + ");\n         |if (!" + ev.isNull() + ") {\n         |  " + ev.value() + " = org.apache.spark.sql.catalyst.expressions.WidthBucket\n         |    .computeBucketNumberNotNull(" + input + ", " + min + ", " + max + ", " + numBucket + ");\n         |}")));
    }

    @Override
    public Expression first() {
        return this.value();
    }

    @Override
    public Expression second() {
        return this.minValue();
    }

    @Override
    public Expression third() {
        return this.maxValue();
    }

    @Override
    public Expression fourth() {
        return this.numBucket();
    }

    @Override
    public WidthBucket withNewChildrenInternal(Expression first, Expression second, Expression third, Expression fourth) {
        return this.copy(first, second, third, fourth);
    }

    public WidthBucket copy(Expression value, Expression minValue, Expression maxValue, Expression numBucket) {
        return new WidthBucket(value, minValue, maxValue, numBucket);
    }

    public Expression copy$default$1() {
        return this.value();
    }

    public Expression copy$default$2() {
        return this.minValue();
    }

    public Expression copy$default$3() {
        return this.maxValue();
    }

    public Expression copy$default$4() {
        return this.numBucket();
    }

    @Override
    public String productPrefix() {
        return "WidthBucket";
    }

    public int productArity() {
        return 4;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return this.value();
            }
            case 1: {
                return this.minValue();
            }
            case 2: {
                return this.maxValue();
            }
            case 3: {
                return this.numBucket();
            }
        }
        return Statics.ioobe((int)x$1);
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof WidthBucket;
    }

    @Override
    public String productElementName(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return "value";
            }
            case 1: {
                return "minValue";
            }
            case 2: {
                return "maxValue";
            }
            case 3: {
                return "numBucket";
            }
        }
        return (String)Statics.ioobe((int)x$1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof WidthBucket)) return false;
        boolean bl = true;
        if (!bl) return false;
        WidthBucket widthBucket = (WidthBucket)x$1;
        Expression expression = this.value();
        Expression expression2 = widthBucket.value();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.minValue();
        Expression expression4 = widthBucket.minValue();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        Expression expression5 = this.maxValue();
        Expression expression6 = widthBucket.maxValue();
        if (expression5 == null) {
            if (expression6 != null) {
                return false;
            }
        } else if (!expression5.equals(expression6)) return false;
        Expression expression7 = this.numBucket();
        Expression expression8 = widthBucket.numBucket();
        if (expression7 == null) {
            if (expression8 != null) {
                return false;
            }
        } else if (!expression7.equals(expression8)) return false;
        if (!widthBucket.canEqual(this)) return false;
        return true;
    }

    public WidthBucket(Expression value, Expression minValue, Expression maxValue, Expression numBucket) {
        this.value = value;
        this.minValue = minValue;
        this.maxValue = maxValue;
        this.numBucket = numBucket;
        ExpectsInputTypes.$init$(this);
    }
}

