/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.ImplicitCastInputTypes;
import org.apache.spark.sql.catalyst.expressions.NonSQLExpression;
import org.apache.spark.sql.catalyst.expressions.SessionWindow$;
import org.apache.spark.sql.catalyst.expressions.Unevaluable;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.trees.TreePattern$;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.AnyDataType$;
import org.apache.spark.sql.types.AnyTimestampType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructField$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.TimestampNTZType$;
import org.apache.spark.sql.types.TimestampType$;
import org.apache.spark.sql.types.TypeCollection$;
import scala.Enumeration;
import scala.Option;
import scala.Product;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ExpressionDescription(usage="\n    _FUNC_(time_column, gap_duration) - Generates session window given a timestamp specifying column and gap duration.\n      See <a href=\"https://spark.apache.org/docs/latest/structured-streaming-programming-guide.html#types-of-time-windows\">'Types of time windows'</a> in Structured Streaming guide doc for detailed explanation and examples.\n  ", arguments="\n    Arguments:\n      * time_column - The column or the expression to use as the timestamp for windowing by time. The time column must be of TimestampType.\n      * gap_duration - A string specifying the timeout of the session represented as \"interval value\"\n        (See <a href=\"https://spark.apache.org/docs/latest/sql-ref-literals.html#interval-literal\">Interval Literal</a> for more details.) for the fixed gap duration, or\n        an expression which is applied for each input and evaluated to the \"interval value\" for the dynamic gap duration.\n  ", examples="\n    Examples:\n      > SELECT a, session_window.start, session_window.end, count(*) as cnt FROM VALUES ('A1', '2021-01-01 00:00:00'), ('A1', '2021-01-01 00:04:30'), ('A1', '2021-01-01 00:10:00'), ('A2', '2021-01-01 00:01:00') AS tab(a, b) GROUP by a, _FUNC_(b, '5 minutes') ORDER BY a, start;\n        A1\t2021-01-01 00:00:00\t2021-01-01 00:09:30\t2\n        A1\t2021-01-01 00:10:00\t2021-01-01 00:15:00\t1\n        A2\t2021-01-01 00:01:00\t2021-01-01 00:06:00\t1\n      > SELECT a, session_window.start, session_window.end, count(*) as cnt FROM VALUES ('A1', '2021-01-01 00:00:00'), ('A1', '2021-01-01 00:04:30'), ('A1', '2021-01-01 00:10:00'), ('A2', '2021-01-01 00:01:00'), ('A2', '2021-01-01 00:04:30') AS tab(a, b) GROUP by a, _FUNC_(b, CASE WHEN a = 'A1' THEN '5 minutes' WHEN a = 'A2' THEN '1 minute' ELSE '10 minutes' END) ORDER BY a, start;\n        A1\t2021-01-01 00:00:00\t2021-01-01 00:09:30\t2\n        A1\t2021-01-01 00:10:00\t2021-01-01 00:15:00\t1\n        A2\t2021-01-01 00:01:00\t2021-01-01 00:02:00\t1\n        A2\t2021-01-01 00:04:30\t2021-01-01 00:05:30\t1\n  ", group="datetime_funcs", since="3.2.0")
@ScalaSignature(bytes="\u0006\u0005\t\u0005a\u0001B\u0011#\u0001>B\u0001b\u0014\u0001\u0003\u0016\u0004%\t\u0001\u0015\u0005\t#\u0002\u0011\t\u0012)A\u0005a!A!\u000b\u0001BK\u0002\u0013\u0005\u0001\u000b\u0003\u0005T\u0001\tE\t\u0015!\u00031\u0011\u0015!\u0006\u0001\"\u0001V\u0011\u0015I\u0006\u0001\"\u0003[\u0011\u0015\t\u0007\u0001\"\u0011c\u0011\u00151\u0007\u0001\"\u0011h\u0011\u0015I\u0007\u0001\"\u0011k\u0011\u001dq\u0007A1A\u0005F=Dq!!\u0004\u0001A\u00035\u0001\u000f\u0003\u0006\u0002\u0010\u0001A)\u0019!C!\u0003#Aq!!\u0007\u0001\t\u0003\n\t\u0002C\u0004\u0002\u001c\u0001!\t&!\b\t\u0013\u0005%\u0002!!A\u0005\u0002\u0005-\u0002\"CA\u0019\u0001E\u0005I\u0011AA\u001a\u0011%\tI\u0005AI\u0001\n\u0003\t\u0019\u0004C\u0005\u0002L\u0001\t\t\u0011\"\u0011\u0002N!I\u0011q\f\u0001\u0002\u0002\u0013\u0005\u0011\u0011\r\u0005\n\u0003S\u0002\u0011\u0011!C\u0001\u0003WB\u0011\"a\u001e\u0001\u0003\u0003%\t%!\u001f\t\u0013\u0005\u001d\u0005!!A\u0005\u0002\u0005%\u0005\"CAG\u0001\u0005\u0005I\u0011IAH\u0011%\t\u0019\nAA\u0001\n\u0003\n)jB\u0004\u0002@\nB\t!!1\u0007\r\u0005\u0012\u0003\u0012AAb\u0011\u0019!&\u0004\"\u0001\u0002V\"I\u0011q\u001b\u000eC\u0002\u0013\u0005\u0011Q\n\u0005\t\u00033T\u0002\u0015!\u0003\u0002P!I\u00111\u001c\u000e\u0002\u0002\u0013\u0005\u0015Q\u001c\u0005\n\u0003GT\u0012\u0011!CA\u0003KD\u0011\"a>\u001b\u0003\u0003%I!!?\u0003\u001bM+7o]5p]^Kg\u000eZ8x\u0015\t\u0019C%A\u0006fqB\u0014Xm]:j_:\u001c(BA\u0013'\u0003!\u0019\u0017\r^1msN$(BA\u0014)\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003S)\nQa\u001d9be.T!a\u000b\u0017\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005i\u0013aA8sO\u000e\u00011c\u0002\u00011i]RTh\u0011\t\u0003cIj\u0011AI\u0005\u0003g\t\u0012!\"\u0012=qe\u0016\u001c8/[8o!\t\tT'\u0003\u00027E\t1\u0012*\u001c9mS\u000eLGoQ1ti&s\u0007/\u001e;UsB,7\u000f\u0005\u00022q%\u0011\u0011H\t\u0002\f+:,g/\u00197vC\ndW\r\u0005\u00022w%\u0011AH\t\u0002\u0011\u001d>t7+\u0015'FqB\u0014Xm]:j_:\u0004\"AP!\u000e\u0003}R\u0011\u0001Q\u0001\u0006g\u000e\fG.Y\u0005\u0003\u0005~\u0012q\u0001\u0015:pIV\u001cG\u000f\u0005\u0002E\u0019:\u0011QI\u0013\b\u0003\r&k\u0011a\u0012\u0006\u0003\u0011:\na\u0001\u0010:p_Rt\u0014\"\u0001!\n\u0005-{\u0014a\u00029bG.\fw-Z\u0005\u0003\u001b:\u0013AbU3sS\u0006d\u0017N_1cY\u0016T!aS \u0002\u0015QLW.Z\"pYVlg.F\u00011\u0003-!\u0018.\\3D_2,XN\u001c\u0011\u0002\u0017\u001d\f\u0007\u000fR;sCRLwN\\\u0001\rO\u0006\u0004H)\u001e:bi&|g\u000eI\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0007Y;\u0006\f\u0005\u00022\u0001!)q*\u0002a\u0001a!)!+\u0002a\u0001a\u0005)\u0012N\u001c9viRK\b/Z(o)&lWmQ8mk6tW#A.\u0011\u0005q{V\"A/\u000b\u0005y3\u0013!\u0002;za\u0016\u001c\u0018B\u00011^\u0005A\t%m\u001d;sC\u000e$H)\u0019;b)f\u0004X-\u0001\u0005dQ&dGM]3o+\u0005\u0019\u0007c\u0001#ea%\u0011QM\u0014\u0002\u0004'\u0016\f\u0018AC5oaV$H+\u001f9fgV\t\u0001\u000eE\u0002EIn\u000b\u0001\u0002Z1uCRK\b/Z\u000b\u0002WB\u0011A\f\\\u0005\u0003[v\u0013\u0001\u0002R1uCRK\b/Z\u0001\r]>$W\rU1ui\u0016\u0014hn]\u000b\u0002aB\u0019A\tZ9\u0011\u0007I\f9AD\u0002t\u0003\u0003q!\u0001\u001e@\u000f\u0005UlhB\u0001<}\u001d\t98P\u0004\u0002yu:\u0011a)_\u0005\u0002[%\u00111\u0006L\u0005\u0003S)J!a\n\u0015\n\u0005\u00152\u0013BA@%\u0003\u0015!(/Z3t\u0013\u0011\t\u0019!!\u0002\u0002\u0017Q\u0013X-\u001a)biR,'O\u001c\u0006\u0003\u007f\u0012JA!!\u0003\u0002\f\tYAK]3f!\u0006$H/\u001a:o\u0015\u0011\t\u0019!!\u0002\u0002\u001b9|G-\u001a)biR,'O\\:!\u0003!\u0011Xm]8mm\u0016$WCAA\n!\rq\u0014QC\u0005\u0004\u0003/y$a\u0002\"p_2,\u0017M\\\u0001\t]VdG.\u00192mK\u00069r/\u001b;i\u001d\u0016<8\t[5mIJ,g.\u00138uKJt\u0017\r\u001c\u000b\u0004a\u0005}\u0001bBA\u0011\u001d\u0001\u0007\u00111E\u0001\f]\u0016<8\t[5mIJ,g\u000e\u0005\u0003E\u0003K\u0001\u0014bAA\u0014\u001d\nQ\u0011J\u001c3fq\u0016$7+Z9\u0002\t\r|\u0007/\u001f\u000b\u0006-\u00065\u0012q\u0006\u0005\b\u001f>\u0001\n\u00111\u00011\u0011\u001d\u0011v\u0002%AA\u0002A\nabY8qs\u0012\"WMZ1vYR$\u0013'\u0006\u0002\u00026)\u001a\u0001'a\u000e,\u0005\u0005e\u0002\u0003BA\u001e\u0003\u000bj!!!\u0010\u000b\t\u0005}\u0012\u0011I\u0001\nk:\u001c\u0007.Z2lK\u0012T1!a\u0011@\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0003\u000f\niDA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\fabY8qs\u0012\"WMZ1vYR$#'A\u0007qe>$Wo\u0019;Qe\u00164\u0017\u000e_\u000b\u0003\u0003\u001f\u0002B!!\u0015\u0002\\5\u0011\u00111\u000b\u0006\u0005\u0003+\n9&\u0001\u0003mC:<'BAA-\u0003\u0011Q\u0017M^1\n\t\u0005u\u00131\u000b\u0002\u0007'R\u0014\u0018N\\4\u0002\u0019A\u0014x\u000eZ;di\u0006\u0013\u0018\u000e^=\u0016\u0005\u0005\r\u0004c\u0001 \u0002f%\u0019\u0011qM \u0003\u0007%sG/\u0001\bqe>$Wo\u0019;FY\u0016lWM\u001c;\u0015\t\u00055\u00141\u000f\t\u0004}\u0005=\u0014bAA9\u007f\t\u0019\u0011I\\=\t\u0013\u0005UD#!AA\u0002\u0005\r\u0014a\u0001=%c\u0005y\u0001O]8ek\u000e$\u0018\n^3sCR|'/\u0006\u0002\u0002|A1\u0011QPAB\u0003[j!!a \u000b\u0007\u0005\u0005u(\u0001\u0006d_2dWm\u0019;j_:LA!!\"\u0002\u0000\tA\u0011\n^3sCR|'/\u0001\u0005dC:,\u0015/^1m)\u0011\t\u0019\"a#\t\u0013\u0005Ud#!AA\u0002\u00055\u0014A\u00059s_\u0012,8\r^#mK6,g\u000e\u001e(b[\u0016$B!a\u0014\u0002\u0012\"I\u0011QO\f\u0002\u0002\u0003\u0007\u00111M\u0001\u0007KF,\u0018\r\\:\u0015\t\u0005M\u0011q\u0013\u0005\n\u0003kB\u0012\u0011!a\u0001\u0003[Bs\u0003AAN\u0003C\u000b\u0019+a*\u0002*\u00065\u0016qVAZ\u0003k\u000bI,a/\u0011\u0007E\ni*C\u0002\u0002 \n\u0012Q#\u0012=qe\u0016\u001c8/[8o\t\u0016\u001c8M]5qi&|g.A\u0003vg\u0006<W-\t\u0002\u0002&\u0006\u0011)L\u0003\u0011!A\u0001zf)\u0016(D?\"\"\u0018.\\3`G>dW/\u001c8-A\u001d\f\u0007o\u00183ve\u0006$\u0018n\u001c8*A5\u0002s)\u001a8fe\u0006$Xm\u001d\u0011tKN\u001c\u0018n\u001c8!o&tGm\\<!O&4XM\u001c\u0011bAQLW.Z:uC6\u0004\be\u001d9fG&4\u00170\u001b8hA\r|G.^7oA\u0005tG\rI4ba\u0002\"WO]1uS>tgF\u0003\u0011!A\u0001\u0002\u0003eU3fAq\n\u0007\u0005\u001b:fMv\u0012\u0003\u000e\u001e;qgjzsf\u001d9be.t\u0013\r]1dQ\u0016tsN]40I>\u001c7o\f7bi\u0016\u001cHoL:ueV\u001cG/\u001e:fI6\u001aHO]3b[&tw-\f9s_\u001e\u0014\u0018-\\7j]\u001els-^5eK:BG/\u001c7$if\u0004Xm]\u0017pM6\"\u0018.\\3.o&tGm\\<tEy:C+\u001f9fg\u0002zg\r\t;j[\u0016\u0004s/\u001b8e_^\u001cx\u0005P\u0018b}\u0001Jg\u000eI*ueV\u001cG/\u001e:fI\u0002\u001aFO]3b[&tw\rI4vS\u0012,\u0007\u0005Z8dA\u0019|'\u000f\t3fi\u0006LG.\u001a3!Kb\u0004H.\u00198bi&|g\u000eI1oI\u0002*\u00070Y7qY\u0016\u001chF\u0003\u0011!\u0003%\t'oZ;nK:$8/\t\u0002\u0002,\u0006!\tF\u0003\u0011!A\u0001\n%oZ;nK:$8O\u000f\u0006!A\u0001\u0002\u0003\u0005\t\u0016!i&lWmX2pYVlg\u000eI\u0017!)\",\u0007eY8mk6t\u0007e\u001c:!i\",\u0007%\u001a=qe\u0016\u001c8/[8oAQ|\u0007%^:fA\u0005\u001c\b\u0005\u001e5fAQLW.Z:uC6\u0004\bEZ8sA]Lg\u000eZ8xS:<\u0007EY=!i&lWM\f\u0011UQ\u0016\u0004C/[7fA\r|G.^7oA5,8\u000f\u001e\u0011cK\u0002zg\r\t+j[\u0016\u001cH/Y7q)f\u0004XM\f\u0006!A\u0001\u0002\u0003\u0005\t\u0016!O\u0006\u0004x\fZ;sCRLwN\u001c\u0011.A\u0005\u00033\u000f\u001e:j]\u001e\u00043\u000f]3dS\u001aL\u0018N\\4!i\",\u0007\u0005^5nK>,H\u000fI8gAQDW\rI:fgNLwN\u001c\u0011sKB\u0014Xm]3oi\u0016$\u0007%Y:!E%tG/\u001a:wC2\u0004c/\u00197vK\nR\u0001\u0005\t\u0011!A\u0001\u0002\u0003\u0005K*fK\u0002b\u0014\r\t5sK\u001al$\u0005\u001b;uaNTtfL:qCJ\\g&\u00199bG\",gf\u001c:h_\u0011|7m]\u0018mCR,7\u000f^\u0018tc2l#/\u001a4.Y&$XM]1mg:BG/\u001c7$S:$XM\u001d<bY6b\u0017\u000e^3sC2\u0014c(\u00138uKJ4\u0018\r\u001c\u0011MSR,'/\u00197=_\u0005t\u0004EZ8sA5|'/\u001a\u0011eKR\f\u0017\u000e\\:/S\u00012wN\u001d\u0011uQ\u0016\u0004c-\u001b=fI\u0002:\u0017\r\u001d\u0011ekJ\fG/[8oY\u0001z'O\u0003\u0011!A\u0001\u0002\u0003\u0005\t\u0011b]\u0002*\u0007\u0010\u001d:fgNLwN\u001c\u0011xQ&\u001c\u0007\u000eI5tA\u0005\u0004\b\u000f\\5fI\u00022wN\u001d\u0011fC\u000eD\u0007%\u001b8qkR\u0004\u0013M\u001c3!KZ\fG.^1uK\u0012\u0004Co\u001c\u0011uQ\u0016\u0004#%\u001b8uKJ4\u0018\r\u001c\u0011wC2,XM\t\u0011g_J\u0004C\u000f[3!Ift\u0017-\\5dA\u001d\f\u0007\u000f\t3ve\u0006$\u0018n\u001c8/\u0015\u0001\u0002\u0013\u0001C3yC6\u0004H.Z:\"\u0005\u0005E\u0016\u0001c\u000e\u000bA\u0001\u0002\u0003%\u0012=b[BdWm\u001d\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011?AM+E*R\"UA\u0005d\u0003e]3tg&|gnX<j]\u0012|wOL:uCJ$H\u0006I:fgNLwN\\0xS:$wn\u001e\u0018f]\u0012d\u0003eY8v]RD#&\u000b\u0011bg\u0002\u001ag\u000e\u001e\u0011G%>k\u0005EV!M+\u0016\u001b\u0006\u0005K\u0014Bc\u001db\u0003e\n\u001a1eEj\u0003'M\u00171c\u0001\u0002\u0004G\u000f\u00191uA\u0002t%\u000b\u0017!Q\u001d\n\u0015g\n\u0017!OI\u0002$'M\u00171c5\u0002\u0014\u0007\t\u00191uA\"$h\r\u0019(S1\u0002\u0003fJ!2O1\u0002sE\r\u00193c5\u0002\u0014'\f\u00192AA\u0002$(\r\u0019;aA:\u0013\u0006\f\u0011)O\u0005\u0013t\u0005\f\u0011(eA\u0012\u0014'\f\u00192[A\n\u0004\u0005\r\u0019;aER\u0004\u0007M\u0014*A\u0005\u001b\u0006\u0005^1cQ\u0005d\u0003EY\u0015!\u000fJ{U\u000b\u0015\u0011cs\u0002\nG\u0006I0G+:\u001bu\f\u000b2-A\u001d*\u0004%\\5okR,7oJ\u0015!\u001fJ#UI\u0015\u0011C3\u0002\nG\u0006I:uCJ$8H\u0003\u0011!A\u0001\u0002\u0003\u0005\t\u0011Bc%\u0011\u0004GM\u0019.aEj\u0003'\r\u00111ai\u0002\u0004G\u000f\u00191\u0013I\u0002$'M\u00171c5\u0002\u0014\u0007\t\u00191uAJ$h\r\u0019\ne)\u0001\u0003\u0005\t\u0011!A\u0001\u0002\u0013)M\u00053aI\nT\u0006M\u0019.aE\u0002\u0003\u0007\r\u001e2ai\u0002\u0004'\u0003\u001a1eEj\u0003'M\u00171c\u0001\u0002\u0004GO\u00196uA\u0002\u0014\"\r\u0006!A\u0001\u0002\u0003\u0005\t\u0011!\u0003JJ!\u0007\r\u001a2[A\nT\u0006M\u0019!aAR\u0004'\r\u001e1a%\u0011\u0004GM\u0019.aEj\u0003'\r\u00111ai\u0002dG\u000f\u00191\u0013ER\u0001\u0005\t\u0011!A\u0001r\u0004eU#M\u000b\u000e#\u0006%\u0019\u0017!g\u0016\u001c8/[8o?^Lg\u000eZ8x]M$\u0018M\u001d;-AM,7o]5p]~;\u0018N\u001c3po:*g\u000e\u001a\u0017!G>,h\u000e\u001e\u0015+S\u0001\n7\u000fI2oi\u00022%kT'!-\u0006cU+R*!Q\u001d\n\u0015g\n\u0017!OI\u0002$'M\u00171c5\u0002\u0014\u0007\t\u00191uA\u0002$\b\r\u0019(S1\u0002\u0003fJ!2O1\u0002sE\r\u00193c5\u0002\u0014'\f\u00192AA\u0002$\b\r\u001b;gA:\u0013\u0006\f\u0011)O\u0005\u000bt\u0005\f\u0011(eA\u0012\u0014'\f\u00192[A\n\u0004\u0005\r\u0019;cAR\u0004\u0007M\u0014*Y\u0001Bs%\u0011\u001a(Y\u0001:#\u0007\r\u001a2[A\nT\u0006M\u0019!aAR\u0004'\r\u001e1a\u001dJC\u0006\t\u0015(\u0003J:C\u0006I\u00143aI\nT\u0006M\u0019.aE\u0002\u0003\u0007\r\u001e1ii\u001a\u0004gJ\u0015!\u0003N\u0003C/\u00192)C2\u0002#-\u000b\u0011H%>+\u0006\u000b\t2zA\u0005d\u0003e\u0018$V\u001d\u000e{\u0006F\u0019\u0017!\u0007\u0006\u001bV\tI,I\u000b:\u0003\u0013\rI\u001f!O\u0005\u000bt\u0005\t+I\u000b:\u0003s%\u000e\u0011nS:,H/Z:(A]CUI\u0014\u0011bAu\u0002s%\u0011\u001a(AQCUI\u0014\u0011(c\u0001j\u0017N\\;uK\u001e\u0002S\tT*FA\u001d\n\u0004\u0007I7j]V$Xm]\u0014!\u000b:#\u0015\u0006I(S\t\u0016\u0013\u0006EQ-!C2\u00023\u000f^1sinR\u0001\u0005\t\u0011!A\u0001\u0002\u0003%Q\u0019\neA\u0012\u0014'\f\u00192[A\n\u0004\u0005\r\u0019;aAR\u0004\u0007M\u00053aI\nT\u0006M\u0019.aE\u0002\u0003\u0007\r\u001e1si\u001a\u0004'\u0003\u001a\u000bA\u0001\u0002\u0003\u0005\t\u0011!A\u0005\u000b\u0014B\r\u00193c5\u0002\u0014'\f\u00192AA\u0002$(\r\u0019;aAJ!\u0007\r\u001a2[A\nT\u0006M\u0019!aAR\u0014'\u000e\u001e1a%\t$\u0002\t\u0011!A\u0001\u0002\u0003\u0005I!3\u0013I\u0002$'M\u00171c5\u0002\u0014\u0007\t\u00191uA\n$\b\r\u0019\neA\u0012\u0014'\f\u00192[A\n\u0004\u0005\r\u0019;aIR\u0004\u0007M\u00052\u0015\u0001\u0002\u0003\u0005\t\u0011!A\u0001\n%'\u0003\u001a1eEj\u0003'M\u00171c\u0001\u0002\u0004G\u000f\u00195uM\u0002\u0014B\r\u00193c5\u0002\u0014'\f\u00192AA\u0002$\bM\u001b;gAJ\u0011G\u0003\u0011!\u0003\u00159'o\\;qC\t\t9,\u0001\beCR,G/[7f?\u001a,hnY:\u0002\u000bMLgnY3\"\u0005\u0005u\u0016!B\u001a/e9\u0002\u0014!D*fgNLwN\\,j]\u0012|w\u000f\u0005\u000225M)!$!2\u0002LB\u0019a(a2\n\u0007\u0005%wH\u0001\u0004B]f\u0014VM\u001a\t\u0005\u0003\u001b\f\u0019.\u0004\u0002\u0002P*!\u0011\u0011[A,\u0003\tIw.C\u0002N\u0003\u001f$\"!!1\u0002\r5\f'o[3s\u0003\u001di\u0017M]6fe\u0002\nQ!\u00199qYf$RAVAp\u0003CDQa\u0014\u0010A\u0002ABQA\u0015\u0010A\u0002A\nq!\u001e8baBd\u0017\u0010\u0006\u0003\u0002h\u0006M\b#\u0002 \u0002j\u00065\u0018bAAv\u007f\t1q\n\u001d;j_:\u0004RAPAxaAJ1!!=@\u0005\u0019!V\u000f\u001d7fe!A\u0011Q_\u0010\u0002\u0002\u0003\u0007a+A\u0002yIA\nAb\u001e:ji\u0016\u0014V\r\u001d7bG\u0016$\"!a?\u0011\t\u0005E\u0013Q`\u0005\u0005\u0003\u007f\f\u0019F\u0001\u0004PE*,7\r\u001e")
public class SessionWindow
extends Expression
implements ImplicitCastInputTypes,
Unevaluable,
NonSQLExpression,
Serializable {
    private boolean resolved;
    private final Expression timeColumn;
    private final Expression gapDuration;
    private final Seq<Enumeration.Value> nodePatterns;
    private volatile boolean bitmap$0;

    public static Option<Tuple2<Expression, Expression>> unapply(SessionWindow x$0) {
        return SessionWindow$.MODULE$.unapply(x$0);
    }

    public static String marker() {
        return SessionWindow$.MODULE$.marker();
    }

    @Override
    public final String sql() {
        return NonSQLExpression.sql$(this);
    }

    @Override
    public final boolean foldable() {
        return Unevaluable.foldable$(this);
    }

    @Override
    public Object eval(InternalRow input) {
        return Unevaluable.eval$(this, input);
    }

    @Override
    public InternalRow eval$default$1() {
        return Unevaluable.eval$default$1$(this);
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        return Unevaluable.doGenCode$(this, ctx, ev);
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes.checkInputDataTypes$(this);
    }

    public Expression timeColumn() {
        return this.timeColumn;
    }

    public Expression gapDuration() {
        return this.gapDuration;
    }

    private AbstractDataType inputTypeOnTimeColumn() {
        return TypeCollection$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AbstractDataType[]{AnyTimestampType$.MODULE$, new StructType().add(new StructField("start", (DataType)TimestampType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4())).add(new StructField("end", (DataType)TimestampType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4())), new StructType().add(new StructField("start", (DataType)TimestampNTZType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4())).add(new StructField("end", (DataType)TimestampNTZType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()))}));
    }

    @Override
    public Seq<Expression> children() {
        return new .colon.colon((Object)this.timeColumn(), (List)new .colon.colon((Object)this.gapDuration(), (List)Nil$.MODULE$));
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return new .colon.colon((Object)this.inputTypeOnTimeColumn(), (List)new .colon.colon((Object)AnyDataType$.MODULE$, (List)Nil$.MODULE$));
    }

    @Override
    public DataType dataType() {
        return new StructType().add(new StructField("start", ((Expression)this.children().head()).dataType(), StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4())).add(new StructField("end", ((Expression)this.children().head()).dataType(), StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()));
    }

    @Override
    public final Seq<Enumeration.Value> nodePatterns() {
        return this.nodePatterns;
    }

    private boolean resolved$lzycompute() {
        SessionWindow sessionWindow = this;
        synchronized (sessionWindow) {
            if (!this.bitmap$0) {
                this.resolved = false;
                this.bitmap$0 = true;
            }
        }
        return this.resolved;
    }

    @Override
    public boolean resolved() {
        if (!this.bitmap$0) {
            return this.resolved$lzycompute();
        }
        return this.resolved;
    }

    @Override
    public boolean nullable() {
        return false;
    }

    @Override
    public Expression withNewChildrenInternal(IndexedSeq<Expression> newChildren) {
        return this.copy((Expression)newChildren.apply(0), (Expression)newChildren.apply(1));
    }

    public SessionWindow copy(Expression timeColumn, Expression gapDuration) {
        return new SessionWindow(timeColumn, gapDuration);
    }

    public Expression copy$default$1() {
        return this.timeColumn();
    }

    public Expression copy$default$2() {
        return this.gapDuration();
    }

    @Override
    public String productPrefix() {
        return "SessionWindow";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return this.timeColumn();
            }
            case 1: {
                return this.gapDuration();
            }
        }
        return Statics.ioobe((int)x$1);
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof SessionWindow;
    }

    @Override
    public String productElementName(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return "timeColumn";
            }
            case 1: {
                return "gapDuration";
            }
        }
        return (String)Statics.ioobe((int)x$1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof SessionWindow)) return false;
        boolean bl = true;
        if (!bl) return false;
        SessionWindow sessionWindow = (SessionWindow)x$1;
        Expression expression = this.timeColumn();
        Expression expression2 = sessionWindow.timeColumn();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.gapDuration();
        Expression expression4 = sessionWindow.gapDuration();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        if (!sessionWindow.canEqual(this)) return false;
        return true;
    }

    public SessionWindow(Expression timeColumn, Expression gapDuration) {
        this.timeColumn = timeColumn;
        this.gapDuration = gapDuration;
        ExpectsInputTypes.$init$(this);
        Unevaluable.$init$(this);
        NonSQLExpression.$init$(this);
        this.nodePatterns = new .colon.colon((Object)TreePattern$.MODULE$.SESSION_WINDOW(), (List)Nil$.MODULE$);
    }
}

