/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.examples.ml;

import java.io.Serializable;
import org.apache.spark.examples.ml.ALSExample;
import org.apache.spark.examples.ml.ALSExample$;
import org.apache.spark.ml.evaluation.RegressionEvaluator;
import org.apache.spark.ml.recommendation.ALS;
import org.apache.spark.ml.recommendation.ALSModel;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.SparkSession$;
import scala.Array;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.StringOps$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.reflect.runtime.package$;

public final class ALSExample$ {
    public static final ALSExample$ MODULE$ = new ALSExample$();

    public ALSExample.Rating parseRating(String str) {
        String[] fields = str.split("::");
        Predef$.MODULE$.assert(ArrayOps$.MODULE$.size$extension(Predef$.MODULE$.refArrayOps((Object[])fields)) == 4);
        return new ALSExample.Rating(StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(fields[0])), StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(fields[1])), StringOps$.MODULE$.toFloat$extension(Predef$.MODULE$.augmentString(fields[2])), StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(fields[3])));
    }

    public void main(String[] args) {
        Object object;
        SparkSession spark = SparkSession$.MODULE$.builder().appName("ALSExample").getOrCreate();
        JavaUniverse $u = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
        public final class Org_apache_spark_examples_ml_ALSExample$$typecreator5$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $m.staticClass("org.apache.spark.examples.ml.ALSExample.Rating").asType().toTypeConstructor();
            }

            public Org_apache_spark_examples_ml_ALSExample$$typecreator5$1() {
            }
        }
        Dataset ratings = spark.read().textFile("data/mllib/als/sample_movielens_ratings.txt").map((Function1 & Serializable)str -> MODULE$.parseRating((String)str), spark.implicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_examples_ml_ALSExample$$typecreator5$1()))).toDF();
        Dataset[] datasetArray = ratings.randomSplit(new double[]{0.8, 0.2});
        if (datasetArray == null || Array.UnapplySeqWrapper$.MODULE$.isEmpty$extension(object = Array$.MODULE$.unapplySeq((Object)datasetArray)) || new Array.UnapplySeqWrapper(Array.UnapplySeqWrapper$.MODULE$.get$extension(object)) == null || Array.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(Array.UnapplySeqWrapper$.MODULE$.get$extension(object), 2) != 0) {
            throw new MatchError((Object)datasetArray);
        }
        Dataset training = (Dataset)Array.UnapplySeqWrapper$.MODULE$.apply$extension(Array.UnapplySeqWrapper$.MODULE$.get$extension(object), 0);
        Dataset test = (Dataset)Array.UnapplySeqWrapper$.MODULE$.apply$extension(Array.UnapplySeqWrapper$.MODULE$.get$extension(object), 1);
        Tuple2 tuple2 = new Tuple2((Object)training, (Object)test);
        Dataset training2 = (Dataset)tuple2._1();
        Dataset test2 = (Dataset)tuple2._2();
        ALS als = new ALS().setMaxIter(5).setRegParam(0.01).setUserCol("userId").setItemCol("movieId").setRatingCol("rating");
        ALSModel model = als.fit(training2);
        model.setColdStartStrategy("drop");
        Dataset predictions = model.transform(test2);
        RegressionEvaluator evaluator = new RegressionEvaluator().setMetricName("rmse").setLabelCol("rating").setPredictionCol("prediction");
        double rmse = evaluator.evaluate(predictions);
        Predef$.MODULE$.println((Object)("Root-mean-square error = " + rmse));
        Dataset userRecs = model.recommendForAllUsers(10);
        Dataset movieRecs = model.recommendForAllItems(10);
        Dataset users = ratings.select(als.getUserCol(), (Seq)Nil$.MODULE$).distinct().limit(3);
        Dataset userSubsetRecs = model.recommendForUserSubset(users, 10);
        Dataset movies = ratings.select(als.getItemCol(), (Seq)Nil$.MODULE$).distinct().limit(3);
        Dataset movieSubSetRecs = model.recommendForItemSubset(movies, 10);
        userRecs.show();
        movieRecs.show();
        userSubsetRecs.show();
        movieSubSetRecs.show();
        spark.stop();
    }

    private ALSExample$() {
    }
}

