/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel.uring;

import io.netty.buffer.ByteBufAllocator;
import io.netty.channel.ChannelException;
import io.netty.channel.ChannelOption;
import io.netty.channel.MessageSizeEstimator;
import io.netty.channel.RecvByteBufAllocator;
import io.netty.channel.WriteBufferWaterMark;
import io.netty.channel.socket.SocketChannelConfig;
import io.netty.channel.uring.AbstractIoUringChannel;
import io.netty.channel.uring.IoUringChannelOption;
import io.netty.channel.uring.IoUringSocketChannel;
import io.netty.channel.uring.IoUringStreamChannelConfig;
import io.netty.util.internal.ObjectUtil;
import io.netty.util.internal.PlatformDependent;
import java.io.IOException;
import java.util.Map;

final class IoUringSocketChannelConfig
extends IoUringStreamChannelConfig
implements SocketChannelConfig {
    private volatile boolean allowHalfClosure;
    private volatile boolean tcpFastopen;
    static final int DISABLE_WRITE_ZERO_COPY = -1;
    private volatile int writeZeroCopyThreshold = -1;

    IoUringSocketChannelConfig(AbstractIoUringChannel channel) {
        super(channel);
        if (PlatformDependent.canEnableTcpNoDelayByDefault()) {
            this.setTcpNoDelay(true);
        }
    }

    @Override
    public Map<ChannelOption<?>, Object> getOptions() {
        return this.getOptions(super.getOptions(), new ChannelOption[]{ChannelOption.SO_RCVBUF, ChannelOption.SO_SNDBUF, ChannelOption.TCP_NODELAY, ChannelOption.SO_KEEPALIVE, ChannelOption.SO_REUSEADDR, ChannelOption.SO_LINGER, ChannelOption.IP_TOS, ChannelOption.ALLOW_HALF_CLOSURE, IoUringChannelOption.TCP_CORK, IoUringChannelOption.TCP_NOTSENT_LOWAT, IoUringChannelOption.TCP_KEEPCNT, IoUringChannelOption.TCP_KEEPIDLE, IoUringChannelOption.TCP_KEEPINTVL, IoUringChannelOption.TCP_QUICKACK, IoUringChannelOption.IP_TRANSPARENT, ChannelOption.TCP_FASTOPEN_CONNECT, IoUringChannelOption.IO_URING_WRITE_ZERO_COPY_THRESHOLD});
    }

    @Override
    public <T> T getOption(ChannelOption<T> option) {
        if (option == ChannelOption.SO_RCVBUF) {
            return (T)Integer.valueOf(this.getReceiveBufferSize());
        }
        if (option == ChannelOption.SO_SNDBUF) {
            return (T)Integer.valueOf(this.getSendBufferSize());
        }
        if (option == ChannelOption.TCP_NODELAY) {
            return (T)Boolean.valueOf(this.isTcpNoDelay());
        }
        if (option == ChannelOption.SO_KEEPALIVE) {
            return (T)Boolean.valueOf(this.isKeepAlive());
        }
        if (option == ChannelOption.SO_REUSEADDR) {
            return (T)Boolean.valueOf(this.isReuseAddress());
        }
        if (option == ChannelOption.SO_LINGER) {
            return (T)Integer.valueOf(this.getSoLinger());
        }
        if (option == ChannelOption.IP_TOS) {
            return (T)Integer.valueOf(this.getTrafficClass());
        }
        if (option == ChannelOption.ALLOW_HALF_CLOSURE) {
            return (T)Boolean.valueOf(this.isAllowHalfClosure());
        }
        if (option == IoUringChannelOption.TCP_CORK) {
            return (T)Boolean.valueOf(this.isTcpCork());
        }
        if (option == IoUringChannelOption.TCP_NOTSENT_LOWAT) {
            return (T)Long.valueOf(this.getTcpNotSentLowAt());
        }
        if (option == IoUringChannelOption.TCP_KEEPIDLE) {
            return (T)Integer.valueOf(this.getTcpKeepIdle());
        }
        if (option == IoUringChannelOption.TCP_KEEPINTVL) {
            return (T)Integer.valueOf(this.getTcpKeepIntvl());
        }
        if (option == IoUringChannelOption.TCP_KEEPCNT) {
            return (T)Integer.valueOf(this.getTcpKeepCnt());
        }
        if (option == IoUringChannelOption.TCP_USER_TIMEOUT) {
            return (T)Integer.valueOf(this.getTcpUserTimeout());
        }
        if (option == IoUringChannelOption.TCP_QUICKACK) {
            return (T)Boolean.valueOf(this.isTcpQuickAck());
        }
        if (option == IoUringChannelOption.IP_TRANSPARENT) {
            return (T)Boolean.valueOf(this.isIpTransparent());
        }
        if (option == ChannelOption.TCP_FASTOPEN_CONNECT) {
            return (T)Boolean.valueOf(this.isTcpFastOpenConnect());
        }
        if (option == IoUringChannelOption.IO_URING_WRITE_ZERO_COPY_THRESHOLD) {
            return (T)Integer.valueOf(this.getWriteZeroCopyThreshold());
        }
        return super.getOption(option);
    }

    @Override
    public <T> boolean setOption(ChannelOption<T> option, T value) {
        this.validate(option, value);
        if (option == ChannelOption.SO_RCVBUF) {
            this.setReceiveBufferSize((Integer)value);
        } else if (option == ChannelOption.SO_SNDBUF) {
            this.setSendBufferSize((Integer)value);
        } else if (option == ChannelOption.TCP_NODELAY) {
            this.setTcpNoDelay((Boolean)value);
        } else if (option == ChannelOption.SO_KEEPALIVE) {
            this.setKeepAlive((Boolean)value);
        } else if (option == ChannelOption.SO_REUSEADDR) {
            this.setReuseAddress((Boolean)value);
        } else if (option == ChannelOption.SO_LINGER) {
            this.setSoLinger((Integer)value);
        } else if (option == ChannelOption.IP_TOS) {
            this.setTrafficClass((Integer)value);
        } else if (option == ChannelOption.ALLOW_HALF_CLOSURE) {
            this.setAllowHalfClosure((Boolean)value);
        } else if (option == IoUringChannelOption.TCP_CORK) {
            this.setTcpCork((Boolean)value);
        } else if (option == IoUringChannelOption.TCP_NOTSENT_LOWAT) {
            this.setTcpNotSentLowAt((Long)value);
        } else if (option == IoUringChannelOption.TCP_KEEPIDLE) {
            this.setTcpKeepIdle((Integer)value);
        } else if (option == IoUringChannelOption.TCP_KEEPCNT) {
            this.setTcpKeepCnt((Integer)value);
        } else if (option == IoUringChannelOption.TCP_KEEPINTVL) {
            this.setTcpKeepIntvl((Integer)value);
        } else if (option == IoUringChannelOption.TCP_USER_TIMEOUT) {
            this.setTcpUserTimeout((Integer)value);
        } else if (option == IoUringChannelOption.IP_TRANSPARENT) {
            this.setIpTransparent((Boolean)value);
        } else if (option == IoUringChannelOption.TCP_QUICKACK) {
            this.setTcpQuickAck((Boolean)value);
        } else if (option == ChannelOption.TCP_FASTOPEN_CONNECT) {
            this.setTcpFastOpenConnect((Boolean)value);
        } else if (option == IoUringChannelOption.IO_URING_WRITE_ZERO_COPY_THRESHOLD) {
            this.setWriteZeroCopyThreshold((Integer)value);
        } else {
            return super.setOption(option, value);
        }
        return true;
    }

    public int getSendBufferSize() {
        try {
            return ((IoUringSocketChannel)this.channel).socket.getSendBufferSize();
        }
        catch (IOException e) {
            throw new ChannelException((Throwable)e);
        }
    }

    public int getSoLinger() {
        try {
            return ((IoUringSocketChannel)this.channel).socket.getSoLinger();
        }
        catch (IOException e) {
            throw new ChannelException((Throwable)e);
        }
    }

    public int getTrafficClass() {
        try {
            return ((IoUringSocketChannel)this.channel).socket.getTrafficClass();
        }
        catch (IOException e) {
            throw new ChannelException((Throwable)e);
        }
    }

    public boolean isKeepAlive() {
        try {
            return ((IoUringSocketChannel)this.channel).socket.isKeepAlive();
        }
        catch (IOException e) {
            throw new ChannelException((Throwable)e);
        }
    }

    public boolean isReuseAddress() {
        try {
            return ((IoUringSocketChannel)this.channel).socket.isReuseAddress();
        }
        catch (IOException e) {
            throw new ChannelException((Throwable)e);
        }
    }

    public boolean isTcpNoDelay() {
        try {
            return ((IoUringSocketChannel)this.channel).socket.isTcpNoDelay();
        }
        catch (IOException e) {
            throw new ChannelException((Throwable)e);
        }
    }

    public boolean isTcpCork() {
        try {
            return ((IoUringSocketChannel)this.channel).socket.isTcpCork();
        }
        catch (IOException e) {
            throw new ChannelException((Throwable)e);
        }
    }

    public int getSoBusyPoll() {
        try {
            return ((IoUringSocketChannel)this.channel).socket.getSoBusyPoll();
        }
        catch (IOException e) {
            throw new ChannelException((Throwable)e);
        }
    }

    public long getTcpNotSentLowAt() {
        try {
            return ((IoUringSocketChannel)this.channel).socket.getTcpNotSentLowAt();
        }
        catch (IOException e) {
            throw new ChannelException((Throwable)e);
        }
    }

    public int getTcpKeepIdle() {
        try {
            return ((IoUringSocketChannel)this.channel).socket.getTcpKeepIdle();
        }
        catch (IOException e) {
            throw new ChannelException((Throwable)e);
        }
    }

    public int getTcpKeepIntvl() {
        try {
            return ((IoUringSocketChannel)this.channel).socket.getTcpKeepIntvl();
        }
        catch (IOException e) {
            throw new ChannelException((Throwable)e);
        }
    }

    public int getTcpKeepCnt() {
        try {
            return ((IoUringSocketChannel)this.channel).socket.getTcpKeepCnt();
        }
        catch (IOException e) {
            throw new ChannelException((Throwable)e);
        }
    }

    public int getTcpUserTimeout() {
        try {
            return ((IoUringSocketChannel)this.channel).socket.getTcpUserTimeout();
        }
        catch (IOException e) {
            throw new ChannelException((Throwable)e);
        }
    }

    public IoUringSocketChannelConfig setKeepAlive(boolean keepAlive) {
        try {
            ((IoUringSocketChannel)this.channel).socket.setKeepAlive(keepAlive);
            return this;
        }
        catch (IOException e) {
            throw new ChannelException((Throwable)e);
        }
    }

    public IoUringSocketChannelConfig setPerformancePreferences(int connectionTime, int latency, int bandwidth) {
        return this;
    }

    public IoUringSocketChannelConfig setReceiveBufferSize(int receiveBufferSize) {
        try {
            ((IoUringSocketChannel)this.channel).socket.setReceiveBufferSize(receiveBufferSize);
            return this;
        }
        catch (IOException e) {
            throw new ChannelException((Throwable)e);
        }
    }

    public IoUringSocketChannelConfig setReuseAddress(boolean reuseAddress) {
        try {
            ((IoUringSocketChannel)this.channel).socket.setReuseAddress(reuseAddress);
            return this;
        }
        catch (IOException e) {
            throw new ChannelException((Throwable)e);
        }
    }

    public IoUringSocketChannelConfig setSendBufferSize(int sendBufferSize) {
        try {
            ((IoUringSocketChannel)this.channel).socket.setSendBufferSize(sendBufferSize);
            return this;
        }
        catch (IOException e) {
            throw new ChannelException((Throwable)e);
        }
    }

    public int getReceiveBufferSize() {
        try {
            return ((IoUringSocketChannel)this.channel).socket.getReceiveBufferSize();
        }
        catch (IOException e) {
            throw new ChannelException((Throwable)e);
        }
    }

    public IoUringSocketChannelConfig setSoLinger(int soLinger) {
        try {
            ((IoUringSocketChannel)this.channel).socket.setSoLinger(soLinger);
            return this;
        }
        catch (IOException e) {
            throw new ChannelException((Throwable)e);
        }
    }

    public IoUringSocketChannelConfig setTcpNoDelay(boolean tcpNoDelay) {
        try {
            ((IoUringSocketChannel)this.channel).socket.setTcpNoDelay(tcpNoDelay);
            return this;
        }
        catch (IOException e) {
            throw new ChannelException((Throwable)e);
        }
    }

    public IoUringSocketChannelConfig setTcpCork(boolean tcpCork) {
        try {
            ((IoUringSocketChannel)this.channel).socket.setTcpCork(tcpCork);
            return this;
        }
        catch (IOException e) {
            throw new ChannelException((Throwable)e);
        }
    }

    public IoUringSocketChannelConfig setSoBusyPoll(int loopMicros) {
        try {
            ((IoUringSocketChannel)this.channel).socket.setSoBusyPoll(loopMicros);
            return this;
        }
        catch (IOException e) {
            throw new ChannelException((Throwable)e);
        }
    }

    public IoUringSocketChannelConfig setTcpNotSentLowAt(long tcpNotSentLowAt) {
        try {
            ((IoUringSocketChannel)this.channel).socket.setTcpNotSentLowAt(tcpNotSentLowAt);
            return this;
        }
        catch (IOException e) {
            throw new ChannelException((Throwable)e);
        }
    }

    public IoUringSocketChannelConfig setTrafficClass(int trafficClass) {
        try {
            ((IoUringSocketChannel)this.channel).socket.setTrafficClass(trafficClass);
            return this;
        }
        catch (IOException e) {
            throw new ChannelException((Throwable)e);
        }
    }

    public IoUringSocketChannelConfig setTcpKeepIdle(int seconds) {
        try {
            ((IoUringSocketChannel)this.channel).socket.setTcpKeepIdle(seconds);
            return this;
        }
        catch (IOException e) {
            throw new ChannelException((Throwable)e);
        }
    }

    public IoUringSocketChannelConfig setTcpKeepIntvl(int seconds) {
        try {
            ((IoUringSocketChannel)this.channel).socket.setTcpKeepIntvl(seconds);
            return this;
        }
        catch (IOException e) {
            throw new ChannelException((Throwable)e);
        }
    }

    @Deprecated
    public IoUringSocketChannelConfig setTcpKeepCntl(int probes) {
        return this.setTcpKeepCnt(probes);
    }

    public IoUringSocketChannelConfig setTcpKeepCnt(int probes) {
        try {
            ((IoUringSocketChannel)this.channel).socket.setTcpKeepCnt(probes);
            return this;
        }
        catch (IOException e) {
            throw new ChannelException((Throwable)e);
        }
    }

    public IoUringSocketChannelConfig setTcpUserTimeout(int milliseconds) {
        try {
            ((IoUringSocketChannel)this.channel).socket.setTcpUserTimeout(milliseconds);
            return this;
        }
        catch (IOException e) {
            throw new ChannelException((Throwable)e);
        }
    }

    public boolean isIpTransparent() {
        try {
            return ((IoUringSocketChannel)this.channel).socket.isIpTransparent();
        }
        catch (IOException e) {
            throw new ChannelException((Throwable)e);
        }
    }

    public IoUringSocketChannelConfig setIpTransparent(boolean transparent) {
        try {
            ((IoUringSocketChannel)this.channel).socket.setIpTransparent(transparent);
            return this;
        }
        catch (IOException e) {
            throw new ChannelException((Throwable)e);
        }
    }

    public IoUringSocketChannelConfig setTcpQuickAck(boolean quickAck) {
        try {
            ((IoUringSocketChannel)this.channel).socket.setTcpQuickAck(quickAck);
            return this;
        }
        catch (IOException e) {
            throw new ChannelException((Throwable)e);
        }
    }

    public boolean isTcpQuickAck() {
        try {
            return ((IoUringSocketChannel)this.channel).socket.isTcpQuickAck();
        }
        catch (IOException e) {
            throw new ChannelException((Throwable)e);
        }
    }

    public IoUringSocketChannelConfig setTcpFastOpenConnect(boolean fastOpenConnect) {
        this.tcpFastopen = fastOpenConnect;
        return this;
    }

    public boolean isTcpFastOpenConnect() {
        return this.tcpFastopen;
    }

    public boolean isAllowHalfClosure() {
        return this.allowHalfClosure;
    }

    public IoUringSocketChannelConfig setAllowHalfClosure(boolean allowHalfClosure) {
        this.allowHalfClosure = allowHalfClosure;
        return this;
    }

    @Override
    public IoUringSocketChannelConfig setConnectTimeoutMillis(int connectTimeoutMillis) {
        super.setConnectTimeoutMillis(connectTimeoutMillis);
        return this;
    }

    @Override
    @Deprecated
    public IoUringSocketChannelConfig setMaxMessagesPerRead(int maxMessagesPerRead) {
        super.setMaxMessagesPerRead(maxMessagesPerRead);
        return this;
    }

    @Override
    public IoUringSocketChannelConfig setWriteSpinCount(int writeSpinCount) {
        super.setWriteSpinCount(writeSpinCount);
        return this;
    }

    @Override
    public IoUringSocketChannelConfig setAllocator(ByteBufAllocator allocator) {
        super.setAllocator(allocator);
        return this;
    }

    @Override
    public IoUringSocketChannelConfig setRecvByteBufAllocator(RecvByteBufAllocator allocator) {
        super.setRecvByteBufAllocator(allocator);
        return this;
    }

    @Override
    public IoUringSocketChannelConfig setAutoRead(boolean autoRead) {
        super.setAutoRead(autoRead);
        return this;
    }

    @Override
    public IoUringSocketChannelConfig setAutoClose(boolean autoClose) {
        super.setAutoClose(autoClose);
        return this;
    }

    @Override
    @Deprecated
    public IoUringSocketChannelConfig setWriteBufferHighWaterMark(int writeBufferHighWaterMark) {
        super.setWriteBufferHighWaterMark(writeBufferHighWaterMark);
        return this;
    }

    @Override
    @Deprecated
    public IoUringSocketChannelConfig setWriteBufferLowWaterMark(int writeBufferLowWaterMark) {
        super.setWriteBufferLowWaterMark(writeBufferLowWaterMark);
        return this;
    }

    @Override
    public IoUringSocketChannelConfig setWriteBufferWaterMark(WriteBufferWaterMark writeBufferWaterMark) {
        super.setWriteBufferWaterMark(writeBufferWaterMark);
        return this;
    }

    @Override
    public IoUringSocketChannelConfig setMessageSizeEstimator(MessageSizeEstimator estimator) {
        super.setMessageSizeEstimator(estimator);
        return this;
    }

    private int getWriteZeroCopyThreshold() {
        return this.writeZeroCopyThreshold;
    }

    IoUringSocketChannelConfig setWriteZeroCopyThreshold(int setWriteZeroCopyThreshold) {
        this.writeZeroCopyThreshold = setWriteZeroCopyThreshold == -1 ? -1 : ObjectUtil.checkPositiveOrZero((int)setWriteZeroCopyThreshold, (String)"setWriteZeroCopyThreshold");
        return this;
    }

    boolean shouldWriteZeroCopy(int amount) {
        int threshold = this.getWriteZeroCopyThreshold();
        return threshold != -1 && amount >= threshold;
    }
}

