/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.avro;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Map;
import org.apache.avro.Schema;
import org.apache.avro.file.CodecFactory;
import org.apache.avro.file.DataFileWriter;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericDatumWriter;
import org.apache.avro.io.DatumWriter;
import org.apache.avro.mapred.AvroKey;
import org.apache.avro.mapreduce.Syncable;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.mapreduce.RecordWriter;
import org.apache.hadoop.mapreduce.TaskAttemptContext;

class SparkAvroKeyRecordWriter<T>
extends RecordWriter<AvroKey<T>, NullWritable>
implements Syncable {
    private final DataFileWriter<T> mAvroFileWriter;

    SparkAvroKeyRecordWriter(Schema writerSchema, GenericData dataModel, CodecFactory compressionCodec, OutputStream outputStream, int syncInterval, Map<String, String> metadata) throws IOException {
        this.mAvroFileWriter = new DataFileWriter((DatumWriter)new GenericDatumWriter(writerSchema, dataModel));
        for (Map.Entry<String, String> entry : metadata.entrySet()) {
            this.mAvroFileWriter.setMeta(entry.getKey(), entry.getValue());
        }
        this.mAvroFileWriter.setCodec(compressionCodec);
        this.mAvroFileWriter.setSyncInterval(syncInterval);
        this.mAvroFileWriter.create(writerSchema, outputStream);
    }

    public void write(AvroKey<T> record, NullWritable ignore) throws IOException {
        this.mAvroFileWriter.append(record.datum());
    }

    public void close(TaskAttemptContext context) throws IOException {
        this.mAvroFileWriter.close();
    }

    public long sync() throws IOException {
        return this.mAvroFileWriter.sync();
    }
}

