/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.network.protocol;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToMessageEncoder;
import java.util.List;
import org.apache.spark.internal.LogKey;
import org.apache.spark.internal.LogKeys;
import org.apache.spark.internal.MDC;
import org.apache.spark.internal.SparkLogger;
import org.apache.spark.internal.SparkLoggerFactory;
import org.apache.spark.network.protocol.AbstractResponseMessage;
import org.apache.spark.network.protocol.Message;
import org.apache.spark.network.protocol.MessageWithHeader;

@ChannelHandler.Sharable
public final class MessageEncoder
extends MessageToMessageEncoder<Message> {
    private static final SparkLogger logger = SparkLoggerFactory.getLogger(MessageEncoder.class);
    public static final MessageEncoder INSTANCE = new MessageEncoder();

    private MessageEncoder() {
    }

    public void encode(ChannelHandlerContext ctx, Message in, List<Object> out) throws Exception {
        Object body = null;
        long bodyLength = 0L;
        boolean isBodyInFrame = false;
        if (in.body() != null) {
            try {
                bodyLength = in.body().size();
                body = in.body().convertToNetty();
                isBodyInFrame = in.isBodyInFrame();
            }
            catch (Exception e) {
                in.body().release();
                if (!(in instanceof AbstractResponseMessage)) {
                    throw e;
                }
                AbstractResponseMessage resp = (AbstractResponseMessage)in;
                String error = e.getMessage() != null ? e.getMessage() : "null";
                logger.error("Error processing {} for client {}", (Throwable)e, new MDC[]{MDC.of((LogKey)LogKeys.MESSAGE, (Object)in), MDC.of((LogKey)LogKeys.HOST_PORT, (Object)ctx.channel().remoteAddress())});
                this.encode(ctx, resp.createFailureResponse(error), out);
                return;
            }
        }
        Message.Type msgType = in.type();
        int headerLength = 8 + msgType.encodedLength() + in.encodedLength();
        long frameLength = (long)headerLength + (isBodyInFrame ? bodyLength : 0L);
        ByteBuf header = ctx.alloc().buffer(headerLength);
        header.writeLong(frameLength);
        msgType.encode(header);
        in.encode(header);
        assert (header.writableBytes() == 0);
        if (body != null) {
            out.add((Object)new MessageWithHeader(in.body(), header, body, bodyLength));
        } else {
            out.add(header);
        }
    }
}

