/*
 * Decompiled with CFR 0.152.
 */
package org.sparkproject.dmg.pmml.support_vector_machine;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonRootName;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlElements;
import jakarta.xml.bind.annotation.XmlEnum;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlSchemaType;
import jakarta.xml.bind.annotation.XmlType;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.sparkproject.dmg.pmml.Extension;
import org.sparkproject.dmg.pmml.HasExtensions;
import org.sparkproject.dmg.pmml.LocalTransformations;
import org.sparkproject.dmg.pmml.MathContext;
import org.sparkproject.dmg.pmml.MiningFunction;
import org.sparkproject.dmg.pmml.MiningSchema;
import org.sparkproject.dmg.pmml.Model;
import org.sparkproject.dmg.pmml.ModelExplanation;
import org.sparkproject.dmg.pmml.ModelStats;
import org.sparkproject.dmg.pmml.ModelVerification;
import org.sparkproject.dmg.pmml.Output;
import org.sparkproject.dmg.pmml.PMMLObject;
import org.sparkproject.dmg.pmml.StringValue;
import org.sparkproject.dmg.pmml.Targets;
import org.sparkproject.dmg.pmml.Version;
import org.sparkproject.dmg.pmml.Visitable;
import org.sparkproject.dmg.pmml.Visitor;
import org.sparkproject.dmg.pmml.VisitorAction;
import org.sparkproject.dmg.pmml.adapters.ObjectAdapter;
import org.sparkproject.dmg.pmml.adapters.RealNumberAdapter;
import org.sparkproject.dmg.pmml.support_vector_machine.Kernel;
import org.sparkproject.dmg.pmml.support_vector_machine.LinearKernel;
import org.sparkproject.dmg.pmml.support_vector_machine.PMMLAttributes;
import org.sparkproject.dmg.pmml.support_vector_machine.PMMLElements;
import org.sparkproject.dmg.pmml.support_vector_machine.PolynomialKernel;
import org.sparkproject.dmg.pmml.support_vector_machine.RadialBasisKernel;
import org.sparkproject.dmg.pmml.support_vector_machine.SigmoidKernel;
import org.sparkproject.dmg.pmml.support_vector_machine.SupportVectorMachine;
import org.sparkproject.dmg.pmml.support_vector_machine.VectorDictionary;
import org.sparkproject.jpmml.model.MissingAttributeException;
import org.sparkproject.jpmml.model.MissingElementException;
import org.sparkproject.jpmml.model.annotations.Added;
import org.sparkproject.jpmml.model.annotations.CollectionElementType;
import org.sparkproject.jpmml.model.annotations.Property;
import org.sparkproject.jpmml.model.annotations.Removed;
import org.sparkproject.jpmml.model.annotations.Required;
import org.sparkproject.jpmml.model.annotations.Since;
import org.sparkproject.jpmml.model.annotations.ValueConstructor;

@XmlRootElement(name="SupportVectorMachineModel", namespace="http://www.dmg.org/PMML-4_4")
@XmlType(name="", propOrder={"extensions", "miningSchema", "output", "modelStats", "modelExplanation", "targets", "localTransformations", "kernel", "vectorDictionary", "supportVectorMachines", "modelVerification"})
@JsonRootName(value="SupportVectorMachineModel")
@JsonPropertyOrder(value={"modelName", "miningFunction", "algorithmName", "threshold", "representation", "alternateBinaryTargetCategory", "classificationMethod", "maxWins", "scorable", "mathContext", "extensions", "miningSchema", "output", "modelStats", "modelExplanation", "targets", "localTransformations", "kernel", "vectorDictionary", "supportVectorMachines", "modelVerification"})
public class SupportVectorMachineModel
extends Model
implements HasExtensions<SupportVectorMachineModel> {
    @XmlAttribute(name="modelName")
    @JsonProperty(value="modelName")
    private String modelName;
    @XmlAttribute(name="functionName", required=true)
    @JsonProperty(value="functionName")
    private MiningFunction miningFunction;
    @XmlAttribute(name="algorithmName")
    @JsonProperty(value="algorithmName")
    private String algorithmName;
    @XmlAttribute(name="threshold")
    @XmlJavaTypeAdapter(value=RealNumberAdapter.class)
    @JsonProperty(value="threshold")
    @Added(value=Version.PMML_4_0)
    private Number threshold;
    @XmlAttribute(name="svmRepresentation")
    @JsonProperty(value="svmRepresentation")
    private Representation representation;
    @XmlAttribute(name="alternateBinaryTargetCategory")
    @XmlJavaTypeAdapter(value=ObjectAdapter.class)
    @XmlSchemaType(name="anySimpleType")
    @JsonProperty(value="alternateBinaryTargetCategory")
    @Added(value=Version.PMML_3_1)
    @Removed(value=Version.PMML_4_0)
    private Object alternateBinaryTargetCategory;
    @XmlAttribute(name="classificationMethod")
    @JsonProperty(value="classificationMethod")
    @Added(value=Version.PMML_4_0)
    private ClassificationMethod classificationMethod;
    @XmlAttribute(name="maxWins")
    @JsonProperty(value="maxWins")
    @Added(value=Version.PMML_4_3)
    private Boolean maxWins;
    @XmlAttribute(name="isScorable")
    @JsonProperty(value="isScorable")
    @Added(value=Version.PMML_4_1, removable=true)
    private Boolean scorable;
    @XmlAttribute(name="x-mathContext")
    @JsonProperty(value="x-mathContext")
    @Added(value=Version.XPMML, removable=true)
    @Since(value="1.3.7")
    private MathContext mathContext;
    @XmlElement(name="Extension", namespace="http://www.dmg.org/PMML-4_4")
    @JsonProperty(value="Extension")
    @CollectionElementType(value=Extension.class)
    private List<Extension> extensions;
    @XmlElement(name="MiningSchema", namespace="http://www.dmg.org/PMML-4_4", required=true)
    @JsonProperty(value="MiningSchema")
    private MiningSchema miningSchema;
    @XmlElement(name="Output", namespace="http://www.dmg.org/PMML-4_4")
    @JsonProperty(value="Output")
    private Output output;
    @XmlElement(name="ModelStats", namespace="http://www.dmg.org/PMML-4_4")
    @JsonProperty(value="ModelStats")
    private ModelStats modelStats;
    @XmlElement(name="ModelExplanation", namespace="http://www.dmg.org/PMML-4_4")
    @JsonProperty(value="ModelExplanation")
    @Added(value=Version.PMML_4_0, removable=true)
    private ModelExplanation modelExplanation;
    @XmlElement(name="Targets", namespace="http://www.dmg.org/PMML-4_4")
    @JsonProperty(value="Targets")
    private Targets targets;
    @XmlElement(name="LocalTransformations", namespace="http://www.dmg.org/PMML-4_4")
    @JsonProperty(value="LocalTransformations")
    private LocalTransformations localTransformations;
    @XmlElements(value={@XmlElement(name="LinearKernelType", namespace="http://www.dmg.org/PMML-4_4", type=LinearKernel.class), @XmlElement(name="PolynomialKernelType", namespace="http://www.dmg.org/PMML-4_4", type=PolynomialKernel.class), @XmlElement(name="RadialBasisKernelType", namespace="http://www.dmg.org/PMML-4_4", type=RadialBasisKernel.class), @XmlElement(name="SigmoidKernelType", namespace="http://www.dmg.org/PMML-4_4", type=SigmoidKernel.class)})
    @JsonProperty(value="Kernel")
    @JsonTypeInfo(include=JsonTypeInfo.As.WRAPPER_OBJECT, use=JsonTypeInfo.Id.NAME)
    @JsonSubTypes(value={@JsonSubTypes.Type(name="LinearKernel", value=LinearKernel.class), @JsonSubTypes.Type(name="PolynomialKernel", value=PolynomialKernel.class), @JsonSubTypes.Type(name="RadialBasisKernel", value=RadialBasisKernel.class), @JsonSubTypes.Type(name="SigmoidKernel", value=SigmoidKernel.class)})
    private Kernel kernel;
    @XmlElement(name="VectorDictionary", namespace="http://www.dmg.org/PMML-4_4", required=true)
    @JsonProperty(value="VectorDictionary")
    @Required(value=Version.PMML_3_1)
    private VectorDictionary vectorDictionary;
    @XmlElement(name="SupportVectorMachine", namespace="http://www.dmg.org/PMML-4_4", required=true)
    @JsonProperty(value="SupportVectorMachine")
    @CollectionElementType(value=SupportVectorMachine.class)
    private List<SupportVectorMachine> supportVectorMachines;
    @XmlElement(name="ModelVerification", namespace="http://www.dmg.org/PMML-4_4")
    @JsonProperty(value="ModelVerification")
    private ModelVerification modelVerification;
    private static final Number DEFAULT_THRESHOLD = new RealNumberAdapter().unmarshal("0");
    private static final Boolean DEFAULT_MAX_WINS = false;
    private static final Boolean DEFAULT_SCORABLE = true;
    private static final long serialVersionUID = 67371272L;

    public SupportVectorMachineModel() {
    }

    @ValueConstructor
    public SupportVectorMachineModel(@Property(value="miningFunction") MiningFunction miningFunction, @Property(value="miningSchema") MiningSchema miningSchema, @Property(value="kernel") Kernel kernel, @Property(value="vectorDictionary") VectorDictionary vectorDictionary, @Property(value="supportVectorMachines") List<SupportVectorMachine> supportVectorMachines) {
        this.miningFunction = miningFunction;
        this.miningSchema = miningSchema;
        this.kernel = kernel;
        this.vectorDictionary = vectorDictionary;
        this.supportVectorMachines = supportVectorMachines;
    }

    @Override
    public String getModelName() {
        return this.modelName;
    }

    @Override
    public SupportVectorMachineModel setModelName(@Property(value="modelName") String modelName) {
        this.modelName = modelName;
        return this;
    }

    @Override
    public MiningFunction requireMiningFunction() {
        if (this.miningFunction == null) {
            throw new MissingAttributeException(this, PMMLAttributes.SUPPORTVECTORMACHINEMODEL_MININGFUNCTION);
        }
        return this.miningFunction;
    }

    @Override
    public MiningFunction getMiningFunction() {
        return this.miningFunction;
    }

    @Override
    public SupportVectorMachineModel setMiningFunction(@Property(value="miningFunction") MiningFunction miningFunction) {
        this.miningFunction = miningFunction;
        return this;
    }

    @Override
    public String getAlgorithmName() {
        return this.algorithmName;
    }

    @Override
    public SupportVectorMachineModel setAlgorithmName(@Property(value="algorithmName") String algorithmName) {
        this.algorithmName = algorithmName;
        return this;
    }

    public Number getThreshold() {
        if (this.threshold == null) {
            return DEFAULT_THRESHOLD;
        }
        return this.threshold;
    }

    public SupportVectorMachineModel setThreshold(@Property(value="threshold") Number threshold) {
        this.threshold = threshold;
        return this;
    }

    public Representation getRepresentation() {
        if (this.representation == null) {
            return Representation.SUPPORT_VECTORS;
        }
        return this.representation;
    }

    public SupportVectorMachineModel setRepresentation(@Property(value="representation") Representation representation) {
        this.representation = representation;
        return this;
    }

    public Object getAlternateBinaryTargetCategory() {
        return this.alternateBinaryTargetCategory;
    }

    public SupportVectorMachineModel setAlternateBinaryTargetCategory(@Property(value="alternateBinaryTargetCategory") Object alternateBinaryTargetCategory) {
        this.alternateBinaryTargetCategory = alternateBinaryTargetCategory;
        return this;
    }

    public ClassificationMethod getClassificationMethod() {
        if (this.classificationMethod == null) {
            return ClassificationMethod.ONE_AGAINST_ALL;
        }
        return this.classificationMethod;
    }

    public SupportVectorMachineModel setClassificationMethod(@Property(value="classificationMethod") ClassificationMethod classificationMethod) {
        this.classificationMethod = classificationMethod;
        return this;
    }

    public boolean isMaxWins() {
        if (this.maxWins == null) {
            return DEFAULT_MAX_WINS;
        }
        return this.maxWins;
    }

    public SupportVectorMachineModel setMaxWins(@Property(value="maxWins") Boolean maxWins) {
        this.maxWins = maxWins;
        return this;
    }

    @Override
    public boolean isScorable() {
        if (this.scorable == null) {
            return DEFAULT_SCORABLE;
        }
        return this.scorable;
    }

    @Override
    public SupportVectorMachineModel setScorable(@Property(value="scorable") Boolean scorable) {
        this.scorable = scorable;
        return this;
    }

    @Override
    public MathContext getMathContext() {
        if (this.mathContext == null) {
            return MathContext.DOUBLE;
        }
        return this.mathContext;
    }

    @Override
    public SupportVectorMachineModel setMathContext(@Property(value="mathContext") MathContext mathContext) {
        this.mathContext = mathContext;
        return this;
    }

    @Override
    public boolean hasExtensions() {
        return this.extensions != null && !this.extensions.isEmpty();
    }

    @Override
    public List<Extension> getExtensions() {
        if (this.extensions == null) {
            this.extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    @Override
    public SupportVectorMachineModel addExtensions(Extension ... extensions) {
        this.getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    @Override
    public MiningSchema requireMiningSchema() {
        if (this.miningSchema == null) {
            throw new MissingElementException(this, PMMLElements.SUPPORTVECTORMACHINEMODEL_MININGSCHEMA);
        }
        return this.miningSchema;
    }

    @Override
    public MiningSchema getMiningSchema() {
        return this.miningSchema;
    }

    @Override
    public SupportVectorMachineModel setMiningSchema(@Property(value="miningSchema") MiningSchema miningSchema) {
        this.miningSchema = miningSchema;
        return this;
    }

    @Override
    public Output getOutput() {
        return this.output;
    }

    @Override
    public SupportVectorMachineModel setOutput(@Property(value="output") Output output) {
        this.output = output;
        return this;
    }

    @Override
    public ModelStats getModelStats() {
        return this.modelStats;
    }

    @Override
    public SupportVectorMachineModel setModelStats(@Property(value="modelStats") ModelStats modelStats) {
        this.modelStats = modelStats;
        return this;
    }

    @Override
    public ModelExplanation getModelExplanation() {
        return this.modelExplanation;
    }

    @Override
    public SupportVectorMachineModel setModelExplanation(@Property(value="modelExplanation") ModelExplanation modelExplanation) {
        this.modelExplanation = modelExplanation;
        return this;
    }

    @Override
    public Targets getTargets() {
        return this.targets;
    }

    @Override
    public SupportVectorMachineModel setTargets(@Property(value="targets") Targets targets) {
        this.targets = targets;
        return this;
    }

    @Override
    public LocalTransformations getLocalTransformations() {
        return this.localTransformations;
    }

    @Override
    public SupportVectorMachineModel setLocalTransformations(@Property(value="localTransformations") LocalTransformations localTransformations) {
        this.localTransformations = localTransformations;
        return this;
    }

    public Kernel requireKernel() {
        if (this.kernel == null) {
            throw new MissingElementException(this, PMMLElements.SUPPORTVECTORMACHINEMODEL_KERNEL);
        }
        return this.kernel;
    }

    public Kernel getKernel() {
        return this.kernel;
    }

    public SupportVectorMachineModel setKernel(@Property(value="kernel") Kernel kernel) {
        this.kernel = kernel;
        return this;
    }

    public VectorDictionary requireVectorDictionary() {
        if (this.vectorDictionary == null) {
            throw new MissingElementException(this, PMMLElements.SUPPORTVECTORMACHINEMODEL_VECTORDICTIONARY);
        }
        return this.vectorDictionary;
    }

    public VectorDictionary getVectorDictionary() {
        return this.vectorDictionary;
    }

    public SupportVectorMachineModel setVectorDictionary(@Property(value="vectorDictionary") VectorDictionary vectorDictionary) {
        this.vectorDictionary = vectorDictionary;
        return this;
    }

    public boolean hasSupportVectorMachines() {
        return this.supportVectorMachines != null && !this.supportVectorMachines.isEmpty();
    }

    public List<SupportVectorMachine> requireSupportVectorMachines() {
        if (this.supportVectorMachines == null || this.supportVectorMachines.isEmpty()) {
            throw new MissingElementException(this, PMMLElements.SUPPORTVECTORMACHINEMODEL_SUPPORTVECTORMACHINES);
        }
        return this.supportVectorMachines;
    }

    public List<SupportVectorMachine> getSupportVectorMachines() {
        if (this.supportVectorMachines == null) {
            this.supportVectorMachines = new ArrayList<SupportVectorMachine>();
        }
        return this.supportVectorMachines;
    }

    public SupportVectorMachineModel addSupportVectorMachines(SupportVectorMachine ... supportVectorMachines) {
        this.getSupportVectorMachines().addAll(Arrays.asList(supportVectorMachines));
        return this;
    }

    @Override
    public ModelVerification getModelVerification() {
        return this.modelVerification;
    }

    @Override
    public SupportVectorMachineModel setModelVerification(@Property(value="modelVerification") ModelVerification modelVerification) {
        this.modelVerification = modelVerification;
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if (status == VisitorAction.CONTINUE && this.hasExtensions()) {
                status = PMMLObject.traverse(visitor, this.getExtensions());
            }
            if (status == VisitorAction.CONTINUE) {
                status = PMMLObject.traverse(visitor, this.getMiningSchema(), this.getOutput(), this.getModelStats(), this.getModelExplanation(), this.getTargets(), this.getLocalTransformations(), this.getKernel(), this.getVectorDictionary());
            }
            if (status == VisitorAction.CONTINUE && this.hasSupportVectorMachines()) {
                status = PMMLObject.traverse(visitor, this.getSupportVectorMachines());
            }
            if (status == VisitorAction.CONTINUE) {
                status = PMMLObject.traverse(visitor, (Visitable)this.getModelVerification());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

    @XmlType(name="")
    @XmlEnum
    public static enum Representation implements StringValue<Representation>
    {
        SUPPORT_VECTORS("SupportVectors"),
        COEFFICIENTS("Coefficients");

        private final String value;

        private Representation(String v) {
            this.value = v;
        }

        @Override
        public String value() {
            return this.value;
        }

        public static Representation fromValue(String v) {
            for (Representation c : Representation.values()) {
                if (!c.value.equals(v)) continue;
                return c;
            }
            throw new IllegalArgumentException(v);
        }

        public String toString() {
            return this.value();
        }
    }

    @XmlType(name="")
    @XmlEnum
    public static enum ClassificationMethod implements StringValue<ClassificationMethod>
    {
        ONE_AGAINST_ALL("OneAgainstAll"),
        ONE_AGAINST_ONE("OneAgainstOne");

        private final String value;

        private ClassificationMethod(String v) {
            this.value = v;
        }

        @Override
        public String value() {
            return this.value;
        }

        public static ClassificationMethod fromValue(String v) {
            for (ClassificationMethod c : ClassificationMethod.values()) {
                if (!c.value.equals(v)) continue;
                return c;
            }
            throw new IllegalArgumentException(v);
        }

        public String toString() {
            return this.value();
        }
    }
}

