/*
 * Block comment 
 */
#include <cstdio>
#include <vector>
#include <iostream>

using namespace <ns>std</ns>;  // line comment
namespace <ns>foo</ns> {

  typedef struct <struct>Struct</struct> {
    int <sfield>field</sfield>;
  } <def>Typedef</def>;
  enum <struct>Enum</struct> {<enum>Foo</enum> = 1, <enum>Bar</enum> = 2};

  <def>Typedef</def> *<gvar>globalVar</gvar>;
  extern <def>Typedef</def> *<evar>externVar</evar>;
  constexpr int <constant>globalConstant</constant> = 123;

  template<typename <templt>T</templt>, int <templv>N</templv>>
  class <struct>Class</struct> {
    <templt>T</templt> <sfield>n</sfield>;
  public:
    /**{$SEMANTIC_DEMO}
     */
    float <fun_decl>function</fun_decl>(int <par>param1</par>, int <par>param2</par>, int <par>param3</par>) {
      int <lvar>localVar1</lvar>, <lvar>localVar2</lvar>, <lvar>localVar3</lvar>;
      int *<lvar>localVar</lvar> = new int[1];
      <ns>std</ns>::<struct>vector</struct><int> <lvar>vec</lvar> = <std_init_list_braces>{</std_init_list_braces> 1, 2, 3 <std_init_list_braces>}</std_init_list_braces>;

      if constexpr (<templv>N</templv> > 42) {
        <kw>this</kw>-><sfield>n</sfield> = <templv>N</templv>;
      }

      <lvar>localVar1</lvar> = <par>param1</par> + <par>param2</par> + <lvar>localVar3</lvar>;

    <label>label</label>:
      <fun_call>printf</fun_call>("Formatted string <fmt>%d</fmt>\n\g", <lvar>localVar</lvar>[0]);
      <fun_call>printf</fun_call>(R"**(Formatted raw-string <fmt>%d</fmt>\n)**", 1);
      <ns>std</ns>::<gvar>cout</gvar> <op><<</op> (1 << 2) <op><<</op> <ns>std</ns>::<fun_call>endl</fun_call>;

      unsigned int <lvar>counter</lvar> = 10;
      while (true) {
        <lvar>counter</lvar>--;
        if (<lvar>counter</lvar> > 5) {
          <ns>std</ns>::<gvar>cout</gvar> <op><<</op> ".";
          continue;
        }
        else if (<lvar>counter</lvar> == 0) {
          break;
        }

        <ns>std</ns>::<gvar>cout</gvar> <op><<</op> <lvar>counter</lvar>;
      }

    <cd_comment>/**
     * Macro documentation comment
     * <cd_comment_tag>@param</cd_comment_tag> <cd_comment_tag_val>A</cd_comment_tag_val> description
     */</cd_comment>
    #define <macro>FOO</macro>(<macro_par>A</macro_par>) <macro_par>A</macro_par>
    #ifdef <macro>DEBUG</macro>
      <ifdef>printf("debug");</ifdef>
    #endif

      return 3.1415f;
    }
  };

  template <typename <templt>T</templt>>
  concept <concept>Concept</concept> = requires (<templt>T</templt> <par>t</par>) {
    t.<dep_code>field</dep_code>;
  };

  template<typename <templt>T</templt>>
  struct <struct>Widget</struct> {
      <fun_decl>Widget</fun_decl>(<templt>T</templt> <par>t</par>);
  };

  template<typename <templt>T</templt>>
  <deduction_guide>Widget</deduction_guide>(<templt>T</templt>) -> <struct>Widget</struct><typename <templt>T</templt>::<dep_code>value_type</dep_code>>;
}
